#ifndef _DECL_NDMeshStreamer_H_
#define _DECL_NDMeshStreamer_H_
#include "charm++.h"
#include "completion.decl.h"

#include "DataItemTypes.h"

/* DECLS: template < class dtype > message MeshStreamerMessage{
int destinationPes[];
dtype data[];
}
;
 */
template < class dtype > class MeshStreamerMessage;
template < class dtype > class CMessage_MeshStreamerMessage:public CkMessage{
  public:
    static int __idx;
    void* operator new(size_t, void*p) { return p; }
    void* operator new(size_t);
    void* operator new(size_t, int*, const int);
    void* operator new(size_t, int*);
#if CMK_MULTIPLE_DELETE
    void operator delete(void*p, void*){dealloc(p);}
    void operator delete(void*p){dealloc(p);}
    void operator delete(void*p, int*, const int){dealloc(p);}
    void operator delete(void*p, int*){dealloc(p);}
#endif
    void operator delete(void*p, size_t){dealloc(p);}
    static void* alloc(int,size_t, int*, int);
    static void dealloc(void *p);
    CMessage_MeshStreamerMessage < dtype > ();
    static void *pack(MeshStreamerMessage < dtype >  *p);
    static MeshStreamerMessage < dtype > * unpack(void* p);
    void *operator new(size_t, int, int);
    void *operator new(size_t, int, int, const int);
#if CMK_MULTIPLE_DELETE
    void operator delete(void *p, int, int){dealloc(p);}
    void operator delete(void *p, int, int, const int){dealloc(p);}
#endif
    static void __register(const char *s, size_t size, CkPackFnPtr pack, CkUnpackFnPtr unpack) {
      __idx = CkRegisterMsg(s, pack, unpack, dealloc, size);
    }
};

/* DECLS: template < class dtype > group MeshStreamerGroupClient: IrrGroup{
void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg);
};
 */
template < class dtype >  class MeshStreamerGroupClient;
template < class dtype >  class CkIndex_MeshStreamerGroupClient;
template < class dtype >  class CProxy_MeshStreamerGroupClient;
template < class dtype >  class CProxyElement_MeshStreamerGroupClient;
template < class dtype >  class CProxySection_MeshStreamerGroupClient;
/* --------------- index object ------------------ */
template < class dtype > class CkIndex_MeshStreamerGroupClient:public CProxyElement_IrrGroup{
  public:
    typedef MeshStreamerGroupClient < dtype >  local_t;
    typedef CkIndex_MeshStreamerGroupClient < dtype >  index_t;
    typedef CProxy_MeshStreamerGroupClient < dtype >  proxy_t;
    typedef CProxyElement_MeshStreamerGroupClient < dtype >  element_t;
    typedef CProxySection_MeshStreamerGroupClient < dtype >  section_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg);
 */
    static int __idx_receiveCombinedData_MeshStreamerMessage;
    static int receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg) { return __idx_receiveCombinedData_MeshStreamerMessage; }
    static void _call_receiveCombinedData_MeshStreamerMessage(void* impl_msg,MeshStreamerGroupClient < dtype > * impl_obj);

};
/* --------------- element proxy ------------------ */
template < class dtype > class CProxyElement_MeshStreamerGroupClient: public CProxyElement_IrrGroup{
  public:
    typedef MeshStreamerGroupClient < dtype >  local_t;
    typedef CkIndex_MeshStreamerGroupClient < dtype >  index_t;
    typedef CProxy_MeshStreamerGroupClient < dtype >  proxy_t;
    typedef CProxyElement_MeshStreamerGroupClient < dtype >  element_t;
    typedef CProxySection_MeshStreamerGroupClient < dtype >  section_t;

    CProxyElement_MeshStreamerGroupClient(void) {}
    CProxyElement_MeshStreamerGroupClient(const IrrGroup *g) : CProxyElement_IrrGroup(g){  }
    CProxyElement_MeshStreamerGroupClient(CkGroupID _gid,int _onPE,CK_DELCTOR_PARAM) : CProxyElement_IrrGroup(_gid,_onPE,CK_DELCTOR_ARGS){  }
    CProxyElement_MeshStreamerGroupClient(CkGroupID _gid,int _onPE) : CProxyElement_IrrGroup(_gid,_onPE){  }
int ckIsDelegated(void) const {return CProxyElement_IrrGroup::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxyElement_IrrGroup::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxyElement_IrrGroup::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxyElement_IrrGroup::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxyElement_IrrGroup::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxyElement_IrrGroup::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxyElement_IrrGroup::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_IrrGroup::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_IrrGroup::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxyElement_IrrGroup::ckSetReductionClient(cb); }
int ckGetGroupPe(void) const
{return CProxyElement_IrrGroup::ckGetGroupPe();}
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_IrrGroup::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_IrrGroup::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_IrrGroup::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxyElement_IrrGroup::ckSetGroupID(g);
    }
    MeshStreamerGroupClient < dtype > * ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static MeshStreamerGroupClient < dtype > * ckLocalBranch(CkGroupID gID) {
      return (MeshStreamerGroupClient < dtype > *)CkLocalBranch(gID);
    }
/* DECLS: void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg);
 */
    void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg);

};
/* ---------------- collective proxy -------------- */
template < class dtype > class CProxy_MeshStreamerGroupClient: public CProxy_IrrGroup{
  public:
    typedef MeshStreamerGroupClient < dtype >  local_t;
    typedef CkIndex_MeshStreamerGroupClient < dtype >  index_t;
    typedef CProxy_MeshStreamerGroupClient < dtype >  proxy_t;
    typedef CProxyElement_MeshStreamerGroupClient < dtype >  element_t;
    typedef CProxySection_MeshStreamerGroupClient < dtype >  section_t;

    CProxy_MeshStreamerGroupClient(void) {}
    CProxy_MeshStreamerGroupClient(const IrrGroup *g) : CProxy_IrrGroup(g){  }
    CProxy_MeshStreamerGroupClient(CkGroupID _gid,CK_DELCTOR_PARAM) : CProxy_IrrGroup(_gid,CK_DELCTOR_ARGS){  }
    CProxy_MeshStreamerGroupClient(CkGroupID _gid) : CProxy_IrrGroup(_gid){  }
    CProxyElement_MeshStreamerGroupClient < dtype >  operator[](int onPE) const
      {return CProxyElement_MeshStreamerGroupClient < dtype > (ckGetGroupID(),onPE,CK_DELCTOR_CALL);}
int ckIsDelegated(void) const {return CProxy_IrrGroup::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxy_IrrGroup::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxy_IrrGroup::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxy_IrrGroup::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxy_IrrGroup::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxy_IrrGroup::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxy_IrrGroup::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_IrrGroup::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_IrrGroup::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxy_IrrGroup::ckSetReductionClient(cb); }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_IrrGroup::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_IrrGroup::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_IrrGroup::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxy_IrrGroup::ckSetGroupID(g);
    }
    MeshStreamerGroupClient < dtype > * ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static MeshStreamerGroupClient < dtype > * ckLocalBranch(CkGroupID gID) {
      return (MeshStreamerGroupClient < dtype > *)CkLocalBranch(gID);
    }
/* DECLS: void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg);
 */
    void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg);
    void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg, int npes, int *pes);
    void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg, CmiGroup &grp);

};
/* ---------------- section proxy -------------- */
template < class dtype > class CProxySection_MeshStreamerGroupClient: public CProxySection_IrrGroup{
  public:
    typedef MeshStreamerGroupClient < dtype >  local_t;
    typedef CkIndex_MeshStreamerGroupClient < dtype >  index_t;
    typedef CProxy_MeshStreamerGroupClient < dtype >  proxy_t;
    typedef CProxyElement_MeshStreamerGroupClient < dtype >  element_t;
    typedef CProxySection_MeshStreamerGroupClient < dtype >  section_t;

    CProxySection_MeshStreamerGroupClient(void) {}
    CProxySection_MeshStreamerGroupClient(const IrrGroup *g) : CProxySection_IrrGroup(g){  }
    CProxySection_MeshStreamerGroupClient(const CkGroupID &_gid,const int *_pelist,int _npes,CK_DELCTOR_PARAM) : CProxySection_IrrGroup(_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
    CProxySection_MeshStreamerGroupClient(const CkGroupID &_gid,const int *_pelist,int _npes) : CProxySection_IrrGroup(_gid,_pelist,_npes){  }
    CProxySection_MeshStreamerGroupClient(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes) : CProxySection_IrrGroup(n,_gid,_pelist,_npes){  }
    CProxySection_MeshStreamerGroupClient(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes,CK_DELCTOR_PARAM) : CProxySection_IrrGroup(n,_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
int ckIsDelegated(void) const {return CProxySection_IrrGroup::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxySection_IrrGroup::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxySection_IrrGroup::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxySection_IrrGroup::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxySection_IrrGroup::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxySection_IrrGroup::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxySection_IrrGroup::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_IrrGroup::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_IrrGroup::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxySection_IrrGroup::ckSetReductionClient(cb); }
inline int ckGetNumSections() const
{ return CProxySection_IrrGroup::ckGetNumSections(); }
inline CkSectionInfo &ckGetSectionInfo()
{ return CProxySection_IrrGroup::ckGetSectionInfo(); }
inline CkSectionID *ckGetSectionIDs()
{ return CProxySection_IrrGroup::ckGetSectionIDs(); }
inline CkSectionID &ckGetSectionID()
{ return CProxySection_IrrGroup::ckGetSectionID(); }
inline CkSectionID &ckGetSectionID(int i)
{ return CProxySection_IrrGroup::ckGetSectionID(i); }
inline CkGroupID ckGetGroupIDn(int i) const
{ return CProxySection_IrrGroup::ckGetGroupIDn(i); }
inline int *ckGetElements() const
{ return CProxySection_IrrGroup::ckGetElements(); }
inline int *ckGetElements(int i) const
{ return CProxySection_IrrGroup::ckGetElements(i); }
inline int ckGetNumElements() const
{ return CProxySection_IrrGroup::ckGetNumElements(); } 
inline int ckGetNumElements(int i) const
{ return CProxySection_IrrGroup::ckGetNumElements(i); }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxySection_IrrGroup::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxySection_IrrGroup::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxySection_IrrGroup::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxySection_IrrGroup::ckSetGroupID(g);
    }
    MeshStreamerGroupClient < dtype > * ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static MeshStreamerGroupClient < dtype > * ckLocalBranch(CkGroupID gID) {
      return (MeshStreamerGroupClient < dtype > *)CkLocalBranch(gID);
    }
/* DECLS: void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg);
 */
    void receiveCombinedData(MeshStreamerMessage<dtype >* impl_msg);

};
template < class dtype > 
class CBase_MeshStreamerGroupClient : public CBaseT1<Group, CProxy_MeshStreamerGroupClient < dtype >  > { };

/* DECLS: template < class dtype > array MeshStreamerArrayClient: ArrayElement{
MeshStreamerArrayClient(CkMigrateMessage* impl_msg);
void receiveRedeliveredItem(const dtype &data);
};
 */
template < class dtype >  class MeshStreamerArrayClient;
template < class dtype >  class CkIndex_MeshStreamerArrayClient;
template < class dtype >  class CProxy_MeshStreamerArrayClient;
template < class dtype >  class CProxyElement_MeshStreamerArrayClient;
template < class dtype >  class CProxySection_MeshStreamerArrayClient;
/* --------------- index object ------------------ */
template < class dtype > class CkIndex_MeshStreamerArrayClient:public CProxyElement_ArrayElement{
  public:
    typedef MeshStreamerArrayClient < dtype >  local_t;
    typedef CkIndex_MeshStreamerArrayClient < dtype >  index_t;
    typedef CProxy_MeshStreamerArrayClient < dtype >  proxy_t;
    typedef CProxyElement_MeshStreamerArrayClient < dtype >  element_t;
    typedef CProxySection_MeshStreamerArrayClient < dtype >  section_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: MeshStreamerArrayClient(CkMigrateMessage* impl_msg);
 */
    static int __idx_MeshStreamerArrayClient_CkMigrateMessage;
    static int ckNew(CkMigrateMessage* impl_msg) { return __idx_MeshStreamerArrayClient_CkMigrateMessage; }
    static void _call_MeshStreamerArrayClient_CkMigrateMessage(void* impl_msg,MeshStreamerArrayClient < dtype > * impl_obj);

/* DECLS: void receiveRedeliveredItem(const dtype &data);
 */
    static int __idx_receiveRedeliveredItem_marshall1;
    static int receiveRedeliveredItem(const dtype &data) { return __idx_receiveRedeliveredItem_marshall1; }
    static void _call_receiveRedeliveredItem_marshall1(void* impl_msg,MeshStreamerArrayClient < dtype > * impl_obj);
    static int _callmarshall_receiveRedeliveredItem_marshall1(char* impl_buf,MeshStreamerArrayClient < dtype > * impl_obj);
    static void _marshallmessagepup_receiveRedeliveredItem_marshall1(PUP::er &p,void *msg);

};
/* --------------- element proxy ------------------ */
template < class dtype >  class CProxyElement_MeshStreamerArrayClient : public CProxyElement_ArrayElement{
  public:
    typedef MeshStreamerArrayClient < dtype >  local_t;
    typedef CkIndex_MeshStreamerArrayClient < dtype >  index_t;
    typedef CProxy_MeshStreamerArrayClient < dtype >  proxy_t;
    typedef CProxyElement_MeshStreamerArrayClient < dtype >  element_t;
    typedef CProxySection_MeshStreamerArrayClient < dtype >  section_t;

    CProxyElement_MeshStreamerArrayClient(void) {}
    CProxyElement_MeshStreamerArrayClient(const ArrayElement *e) : CProxyElement_ArrayElement(e){  }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_ArrayElement::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_ArrayElement::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_ArrayElement::pup(p);
    }
int ckIsDelegated(void) const {return CProxyElement_ArrayElement::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxyElement_ArrayElement::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxyElement_ArrayElement::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxyElement_ArrayElement::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxyElement_ArrayElement::ckCheck();}
inline operator CkArrayID () const {return ckGetArrayID();}
inline static CkArrayID ckCreateEmptyArray(void){ return CProxyElement_ArrayElement::ckCreateEmptyArray(); }
inline static CkArrayID ckCreateArray(CkArrayMessage *m,int ctor,const CkArrayOptions &opts){ return CProxyElement_ArrayElement::ckCreateArray(m,ctor,opts); }
inline void ckInsertIdx(CkArrayMessage *m,int ctor,int onPe,const CkArrayIndex &idx){ CProxyElement_ArrayElement::ckInsertIdx(m,ctor,onPe,idx); }
inline void ckBroadcast(CkArrayMessage *m, int ep, int opts=0) const{ CProxyElement_ArrayElement::ckBroadcast(m,ep,opts); }
inline CkArrayID ckGetArrayID(void) const{ return CProxyElement_ArrayElement::ckGetArrayID();}
inline CkArray *ckLocalBranch(void) const{ return CProxyElement_ArrayElement::ckLocalBranch(); }
inline CkLocMgr *ckLocMgr(void) const{ return CProxyElement_ArrayElement::ckLocMgr(); }
inline void doneInserting(void) { CProxyElement_ArrayElement::doneInserting(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_ArrayElement::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_ArrayElement::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxyElement_ArrayElement::ckSetReductionClient(cb); }
inline void ckInsert(CkArrayMessage *m,int ctor,int onPe)
  { CProxyElement_ArrayElement::ckInsert(m,ctor,onPe); }
inline void ckSend(CkArrayMessage *m, int ep, int opts = 0) const
  { CProxyElement_ArrayElement::ckSend(m,ep,opts); }
inline void *ckSendSync(CkArrayMessage *m, int ep) const
  { return CProxyElement_ArrayElement::ckSendSync(m,ep); }
inline const CkArrayIndex &ckGetIndex() const
  { return CProxyElement_ArrayElement::ckGetIndex(); }
    MeshStreamerArrayClient < dtype >  *ckLocal(void) const
      { return (MeshStreamerArrayClient < dtype >  *)CProxyElement_ArrayElement::ckLocal(); }
    CProxyElement_MeshStreamerArrayClient(const CkArrayID &aid,const CkArrayIndex1D &idx,CK_DELCTOR_PARAM)
        :CProxyElement_ArrayElement(aid,idx,CK_DELCTOR_ARGS) {}
    CProxyElement_MeshStreamerArrayClient(const CkArrayID &aid,const CkArrayIndex1D &idx)
        :CProxyElement_ArrayElement(aid,idx) {}
/* DECLS: MeshStreamerArrayClient(CkMigrateMessage* impl_msg);
 */

/* DECLS: void receiveRedeliveredItem(const dtype &data);
 */
    void receiveRedeliveredItem(const dtype &data, const CkEntryOptions *impl_e_opts=NULL) ;

};
/* ---------------- collective proxy -------------- */
template < class dtype >  class CProxy_MeshStreamerArrayClient : public CProxy_ArrayElement{
  public:
    typedef MeshStreamerArrayClient < dtype >  local_t;
    typedef CkIndex_MeshStreamerArrayClient < dtype >  index_t;
    typedef CProxy_MeshStreamerArrayClient < dtype >  proxy_t;
    typedef CProxyElement_MeshStreamerArrayClient < dtype >  element_t;
    typedef CProxySection_MeshStreamerArrayClient < dtype >  section_t;

    CProxy_MeshStreamerArrayClient(void) {}
    CProxy_MeshStreamerArrayClient(const ArrayElement *e) : CProxy_ArrayElement(e){  }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_ArrayElement::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_ArrayElement::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_ArrayElement::pup(p);
    }
int ckIsDelegated(void) const {return CProxy_ArrayElement::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxy_ArrayElement::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxy_ArrayElement::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxy_ArrayElement::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxy_ArrayElement::ckCheck();}
inline operator CkArrayID () const {return ckGetArrayID();}
inline static CkArrayID ckCreateEmptyArray(void){ return CProxy_ArrayElement::ckCreateEmptyArray(); }
inline static CkArrayID ckCreateArray(CkArrayMessage *m,int ctor,const CkArrayOptions &opts){ return CProxy_ArrayElement::ckCreateArray(m,ctor,opts); }
inline void ckInsertIdx(CkArrayMessage *m,int ctor,int onPe,const CkArrayIndex &idx){ CProxy_ArrayElement::ckInsertIdx(m,ctor,onPe,idx); }
inline void ckBroadcast(CkArrayMessage *m, int ep, int opts=0) const{ CProxy_ArrayElement::ckBroadcast(m,ep,opts); }
inline CkArrayID ckGetArrayID(void) const{ return CProxy_ArrayElement::ckGetArrayID();}
inline CkArray *ckLocalBranch(void) const{ return CProxy_ArrayElement::ckLocalBranch(); }
inline CkLocMgr *ckLocMgr(void) const{ return CProxy_ArrayElement::ckLocMgr(); }
inline void doneInserting(void) { CProxy_ArrayElement::doneInserting(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_ArrayElement::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_ArrayElement::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxy_ArrayElement::ckSetReductionClient(cb); }
    static CkArrayID ckNew(void) {return ckCreateEmptyArray();}
//Generalized array indexing:
    CProxyElement_MeshStreamerArrayClient < dtype >  operator [] (const CkArrayIndex1D &idx) const
        {return CProxyElement_MeshStreamerArrayClient < dtype > (ckGetArrayID(), idx, CK_DELCTOR_CALL);}
    CProxyElement_MeshStreamerArrayClient < dtype >  operator() (const CkArrayIndex1D &idx) const
        {return CProxyElement_MeshStreamerArrayClient < dtype > (ckGetArrayID(), idx, CK_DELCTOR_CALL);}
    CProxyElement_MeshStreamerArrayClient < dtype >  operator [] (int idx) const 
        {return CProxyElement_MeshStreamerArrayClient < dtype > (ckGetArrayID(), CkArrayIndex1D(idx), CK_DELCTOR_CALL);}
    CProxyElement_MeshStreamerArrayClient < dtype >  operator () (int idx) const 
        {return CProxyElement_MeshStreamerArrayClient < dtype > (ckGetArrayID(), CkArrayIndex1D(idx), CK_DELCTOR_CALL);}
    CProxy_MeshStreamerArrayClient(const CkArrayID &aid,CK_DELCTOR_PARAM) 
        :CProxy_ArrayElement(aid,CK_DELCTOR_ARGS) {}
    CProxy_MeshStreamerArrayClient(const CkArrayID &aid) 
        :CProxy_ArrayElement(aid) {}
/* DECLS: MeshStreamerArrayClient(CkMigrateMessage* impl_msg);
 */

/* DECLS: void receiveRedeliveredItem(const dtype &data);
 */
    void receiveRedeliveredItem(const dtype &data, const CkEntryOptions *impl_e_opts=NULL) ;

};
/* ---------------- section proxy -------------- */
template < class dtype >  class CProxySection_MeshStreamerArrayClient : public CProxySection_ArrayElement{
  public:
    typedef MeshStreamerArrayClient < dtype >  local_t;
    typedef CkIndex_MeshStreamerArrayClient < dtype >  index_t;
    typedef CProxy_MeshStreamerArrayClient < dtype >  proxy_t;
    typedef CProxyElement_MeshStreamerArrayClient < dtype >  element_t;
    typedef CProxySection_MeshStreamerArrayClient < dtype >  section_t;

    CProxySection_MeshStreamerArrayClient(void) {}
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxySection_ArrayElement::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxySection_ArrayElement::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxySection_ArrayElement::pup(p);
    }
int ckIsDelegated(void) const {return CProxySection_ArrayElement::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxySection_ArrayElement::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxySection_ArrayElement::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxySection_ArrayElement::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxySection_ArrayElement::ckCheck();}
inline operator CkArrayID () const {return ckGetArrayID();}
inline static CkArrayID ckCreateEmptyArray(void){ return CProxySection_ArrayElement::ckCreateEmptyArray(); }
inline static CkArrayID ckCreateArray(CkArrayMessage *m,int ctor,const CkArrayOptions &opts){ return CProxySection_ArrayElement::ckCreateArray(m,ctor,opts); }
inline void ckInsertIdx(CkArrayMessage *m,int ctor,int onPe,const CkArrayIndex &idx){ CProxySection_ArrayElement::ckInsertIdx(m,ctor,onPe,idx); }
inline void ckBroadcast(CkArrayMessage *m, int ep, int opts=0) const{ CProxySection_ArrayElement::ckBroadcast(m,ep,opts); }
inline CkArrayID ckGetArrayID(void) const{ return CProxySection_ArrayElement::ckGetArrayID();}
inline CkArray *ckLocalBranch(void) const{ return CProxySection_ArrayElement::ckLocalBranch(); }
inline CkLocMgr *ckLocMgr(void) const{ return CProxySection_ArrayElement::ckLocMgr(); }
inline void doneInserting(void) { CProxySection_ArrayElement::doneInserting(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_ArrayElement::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_ArrayElement::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxySection_ArrayElement::ckSetReductionClient(cb); }
inline void ckSend(CkArrayMessage *m, int ep, int opts = 0)
 { CProxySection_ArrayElement::ckSend(m,ep,opts); }
inline CkSectionInfo &ckGetSectionInfo()
  { return CProxySection_ArrayElement::ckGetSectionInfo(); }
inline CkSectionID *ckGetSectionIDs()
  { return CProxySection_ArrayElement::ckGetSectionIDs(); }
inline CkSectionID &ckGetSectionID()
  { return CProxySection_ArrayElement::ckGetSectionID(); }
inline CkSectionID &ckGetSectionID(int i)
  { return CProxySection_ArrayElement::ckGetSectionID(i); }
inline CkArrayID ckGetArrayIDn(int i) const
{return CProxySection_ArrayElement::ckGetArrayIDn(i); } 
inline CkArrayIndex *ckGetArrayElements() const
  { return CProxySection_ArrayElement::ckGetArrayElements(); }
inline CkArrayIndex *ckGetArrayElements(int i) const
{return CProxySection_ArrayElement::ckGetArrayElements(i); }
inline int ckGetNumElements() const
  { return CProxySection_ArrayElement::ckGetNumElements(); } 
inline int ckGetNumElements(int i) const
{return CProxySection_ArrayElement::ckGetNumElements(i); } 
//Generalized array indexing:
    CProxyElement_MeshStreamerArrayClient < dtype >  operator [] (const CkArrayIndex1D &idx) const
        {return CProxyElement_MeshStreamerArrayClient < dtype > (ckGetArrayID(), idx, CK_DELCTOR_CALL);}
    CProxyElement_MeshStreamerArrayClient < dtype >  operator() (const CkArrayIndex1D &idx) const
        {return CProxyElement_MeshStreamerArrayClient < dtype > (ckGetArrayID(), idx, CK_DELCTOR_CALL);}
    CProxyElement_MeshStreamerArrayClient < dtype >  operator [] (int idx) const 
        {return CProxyElement_MeshStreamerArrayClient < dtype > (ckGetArrayID(), *(CkArrayIndex1D*)&ckGetArrayElements()[idx], CK_DELCTOR_CALL);}
    CProxyElement_MeshStreamerArrayClient < dtype >  operator () (int idx) const 
        {return CProxyElement_MeshStreamerArrayClient < dtype > (ckGetArrayID(), *(CkArrayIndex1D*)&ckGetArrayElements()[idx], CK_DELCTOR_CALL);}
    static CkSectionID ckNew(const CkArrayID &aid, CkArrayIndex1D *elems, int nElems) {
      return CkSectionID(aid, elems, nElems);
    } 
    static CkSectionID ckNew(const CkArrayID &aid, int l, int u, int s) {
      CkVec<CkArrayIndex1D> al;
      for (int i=l; i<=u; i+=s) al.push_back(CkArrayIndex1D(i));
      return CkSectionID(aid, al.getVec(), al.size());
    } 
    CProxySection_MeshStreamerArrayClient(const CkArrayID &aid, CkArrayIndex *elems, int nElems, CK_DELCTOR_PARAM) 
        :CProxySection_ArrayElement(aid,elems,nElems,CK_DELCTOR_ARGS) {}
    CProxySection_MeshStreamerArrayClient(const CkArrayID &aid, CkArrayIndex *elems, int nElems) 
        :CProxySection_ArrayElement(aid,elems,nElems) {}
    CProxySection_MeshStreamerArrayClient(const CkSectionID &sid)       :CProxySection_ArrayElement(sid) {}
    CProxySection_MeshStreamerArrayClient(int n, const CkArrayID *aid, CkArrayIndex const * const *elems, const int *nElems, CK_DELCTOR_PARAM) 
        :CProxySection_ArrayElement(n,aid,elems,nElems,CK_DELCTOR_ARGS) {}
    CProxySection_MeshStreamerArrayClient(int n, const CkArrayID *aid, CkArrayIndex const * const *elems, const int *nElems) 
        :CProxySection_ArrayElement(n,aid,elems,nElems) {}
    static CkSectionID ckNew(const CkArrayID &aid, CkArrayIndex *elems, int nElems) {
      return CkSectionID(aid, elems, nElems);
    } 
/* DECLS: MeshStreamerArrayClient(CkMigrateMessage* impl_msg);
 */

/* DECLS: void receiveRedeliveredItem(const dtype &data);
 */
    void receiveRedeliveredItem(const dtype &data, const CkEntryOptions *impl_e_opts=NULL) ;

};
template < class dtype > 
class CBase_MeshStreamerArrayClient : public CBaseT1<ArrayElementT<CkIndex1D>, CProxy_MeshStreamerArrayClient < dtype >  > { };

/* DECLS: template < class dtype > group MeshStreamer: IrrGroup{
void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg);
void flushDirect(void);
void finish(void);
void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector);
};
 */
template < class dtype >  class MeshStreamer;
template < class dtype >  class CkIndex_MeshStreamer;
template < class dtype >  class CProxy_MeshStreamer;
template < class dtype >  class CProxyElement_MeshStreamer;
template < class dtype >  class CProxySection_MeshStreamer;
/* --------------- index object ------------------ */
template < class dtype > class CkIndex_MeshStreamer:public CProxyElement_IrrGroup{
  public:
    typedef MeshStreamer < dtype >  local_t;
    typedef CkIndex_MeshStreamer < dtype >  index_t;
    typedef CProxy_MeshStreamer < dtype >  proxy_t;
    typedef CProxyElement_MeshStreamer < dtype >  element_t;
    typedef CProxySection_MeshStreamer < dtype >  section_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg);
 */
    static int __idx_receiveAlongRoute_MeshStreamerMessage;
    static int receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg) { return __idx_receiveAlongRoute_MeshStreamerMessage; }
    static void _call_receiveAlongRoute_MeshStreamerMessage(void* impl_msg,MeshStreamer < dtype > * impl_obj);

/* DECLS: void flushDirect(void);
 */
    static int __idx_flushDirect_void;
    static int flushDirect(void) { return __idx_flushDirect_void; }
    static void _call_flushDirect_void(void* impl_msg,MeshStreamer < dtype > * impl_obj);

/* DECLS: void finish(void);
 */
    static int __idx_finish_void;
    static int finish(void) { return __idx_finish_void; }
    static void _call_finish_void(void* impl_msg,MeshStreamer < dtype > * impl_obj);

/* DECLS: void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector);
 */
    static int __idx_associateCallback_marshall4;
    static int associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector) { return __idx_associateCallback_marshall4; }
    static void _call_associateCallback_marshall4(void* impl_msg,MeshStreamer < dtype > * impl_obj);
    static int _callmarshall_associateCallback_marshall4(char* impl_buf,MeshStreamer < dtype > * impl_obj);
    static void _marshallmessagepup_associateCallback_marshall4(PUP::er &p,void *msg);

};
/* --------------- element proxy ------------------ */
template < class dtype > class CProxyElement_MeshStreamer: public CProxyElement_IrrGroup{
  public:
    typedef MeshStreamer < dtype >  local_t;
    typedef CkIndex_MeshStreamer < dtype >  index_t;
    typedef CProxy_MeshStreamer < dtype >  proxy_t;
    typedef CProxyElement_MeshStreamer < dtype >  element_t;
    typedef CProxySection_MeshStreamer < dtype >  section_t;

    CProxyElement_MeshStreamer(void) {}
    CProxyElement_MeshStreamer(const IrrGroup *g) : CProxyElement_IrrGroup(g){  }
    CProxyElement_MeshStreamer(CkGroupID _gid,int _onPE,CK_DELCTOR_PARAM) : CProxyElement_IrrGroup(_gid,_onPE,CK_DELCTOR_ARGS){  }
    CProxyElement_MeshStreamer(CkGroupID _gid,int _onPE) : CProxyElement_IrrGroup(_gid,_onPE){  }
int ckIsDelegated(void) const {return CProxyElement_IrrGroup::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxyElement_IrrGroup::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxyElement_IrrGroup::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxyElement_IrrGroup::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxyElement_IrrGroup::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxyElement_IrrGroup::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxyElement_IrrGroup::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_IrrGroup::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_IrrGroup::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxyElement_IrrGroup::ckSetReductionClient(cb); }
int ckGetGroupPe(void) const
{return CProxyElement_IrrGroup::ckGetGroupPe();}
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_IrrGroup::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_IrrGroup::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_IrrGroup::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxyElement_IrrGroup::ckSetGroupID(g);
    }
    MeshStreamer < dtype > * ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static MeshStreamer < dtype > * ckLocalBranch(CkGroupID gID) {
      return (MeshStreamer < dtype > *)CkLocalBranch(gID);
    }
/* DECLS: void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg);
 */
    void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg);

/* DECLS: void flushDirect(void);
 */
    void flushDirect(void);

/* DECLS: void finish(void);
 */
    void finish(void);

/* DECLS: void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector);
 */
    void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector, const CkEntryOptions *impl_e_opts=NULL);

};
/* ---------------- collective proxy -------------- */
template < class dtype > class CProxy_MeshStreamer: public CProxy_IrrGroup{
  public:
    typedef MeshStreamer < dtype >  local_t;
    typedef CkIndex_MeshStreamer < dtype >  index_t;
    typedef CProxy_MeshStreamer < dtype >  proxy_t;
    typedef CProxyElement_MeshStreamer < dtype >  element_t;
    typedef CProxySection_MeshStreamer < dtype >  section_t;

    CProxy_MeshStreamer(void) {}
    CProxy_MeshStreamer(const IrrGroup *g) : CProxy_IrrGroup(g){  }
    CProxy_MeshStreamer(CkGroupID _gid,CK_DELCTOR_PARAM) : CProxy_IrrGroup(_gid,CK_DELCTOR_ARGS){  }
    CProxy_MeshStreamer(CkGroupID _gid) : CProxy_IrrGroup(_gid){  }
    CProxyElement_MeshStreamer < dtype >  operator[](int onPE) const
      {return CProxyElement_MeshStreamer < dtype > (ckGetGroupID(),onPE,CK_DELCTOR_CALL);}
int ckIsDelegated(void) const {return CProxy_IrrGroup::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxy_IrrGroup::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxy_IrrGroup::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxy_IrrGroup::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxy_IrrGroup::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxy_IrrGroup::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxy_IrrGroup::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_IrrGroup::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_IrrGroup::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxy_IrrGroup::ckSetReductionClient(cb); }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_IrrGroup::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_IrrGroup::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_IrrGroup::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxy_IrrGroup::ckSetGroupID(g);
    }
    MeshStreamer < dtype > * ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static MeshStreamer < dtype > * ckLocalBranch(CkGroupID gID) {
      return (MeshStreamer < dtype > *)CkLocalBranch(gID);
    }
/* DECLS: void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg);
 */
    void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg);
    void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg, int npes, int *pes);
    void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg, CmiGroup &grp);

/* DECLS: void flushDirect(void);
 */
    void flushDirect(void);
    void flushDirect(int npes, int *pes);
    void flushDirect(CmiGroup &grp);

/* DECLS: void finish(void);
 */
    void finish(void);
    void finish(int npes, int *pes);
    void finish(CmiGroup &grp);

/* DECLS: void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector);
 */
    void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector, const CkEntryOptions *impl_e_opts=NULL);
    void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

};
/* ---------------- section proxy -------------- */
template < class dtype > class CProxySection_MeshStreamer: public CProxySection_IrrGroup{
  public:
    typedef MeshStreamer < dtype >  local_t;
    typedef CkIndex_MeshStreamer < dtype >  index_t;
    typedef CProxy_MeshStreamer < dtype >  proxy_t;
    typedef CProxyElement_MeshStreamer < dtype >  element_t;
    typedef CProxySection_MeshStreamer < dtype >  section_t;

    CProxySection_MeshStreamer(void) {}
    CProxySection_MeshStreamer(const IrrGroup *g) : CProxySection_IrrGroup(g){  }
    CProxySection_MeshStreamer(const CkGroupID &_gid,const int *_pelist,int _npes,CK_DELCTOR_PARAM) : CProxySection_IrrGroup(_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
    CProxySection_MeshStreamer(const CkGroupID &_gid,const int *_pelist,int _npes) : CProxySection_IrrGroup(_gid,_pelist,_npes){  }
    CProxySection_MeshStreamer(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes) : CProxySection_IrrGroup(n,_gid,_pelist,_npes){  }
    CProxySection_MeshStreamer(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes,CK_DELCTOR_PARAM) : CProxySection_IrrGroup(n,_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
int ckIsDelegated(void) const {return CProxySection_IrrGroup::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxySection_IrrGroup::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxySection_IrrGroup::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxySection_IrrGroup::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxySection_IrrGroup::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxySection_IrrGroup::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxySection_IrrGroup::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_IrrGroup::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_IrrGroup::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxySection_IrrGroup::ckSetReductionClient(cb); }
inline int ckGetNumSections() const
{ return CProxySection_IrrGroup::ckGetNumSections(); }
inline CkSectionInfo &ckGetSectionInfo()
{ return CProxySection_IrrGroup::ckGetSectionInfo(); }
inline CkSectionID *ckGetSectionIDs()
{ return CProxySection_IrrGroup::ckGetSectionIDs(); }
inline CkSectionID &ckGetSectionID()
{ return CProxySection_IrrGroup::ckGetSectionID(); }
inline CkSectionID &ckGetSectionID(int i)
{ return CProxySection_IrrGroup::ckGetSectionID(i); }
inline CkGroupID ckGetGroupIDn(int i) const
{ return CProxySection_IrrGroup::ckGetGroupIDn(i); }
inline int *ckGetElements() const
{ return CProxySection_IrrGroup::ckGetElements(); }
inline int *ckGetElements(int i) const
{ return CProxySection_IrrGroup::ckGetElements(i); }
inline int ckGetNumElements() const
{ return CProxySection_IrrGroup::ckGetNumElements(); } 
inline int ckGetNumElements(int i) const
{ return CProxySection_IrrGroup::ckGetNumElements(i); }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxySection_IrrGroup::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxySection_IrrGroup::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxySection_IrrGroup::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxySection_IrrGroup::ckSetGroupID(g);
    }
    MeshStreamer < dtype > * ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static MeshStreamer < dtype > * ckLocalBranch(CkGroupID gID) {
      return (MeshStreamer < dtype > *)CkLocalBranch(gID);
    }
/* DECLS: void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg);
 */
    void receiveAlongRoute(MeshStreamerMessage<dtype >* impl_msg);

/* DECLS: void flushDirect(void);
 */
    void flushDirect(void);

/* DECLS: void finish(void);
 */
    void finish(void);

/* DECLS: void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector);
 */
    void associateCallback(const CkCallback &startCb, const CkCallback &endCb, const CProxy_CompletionDetector &detector, const CkEntryOptions *impl_e_opts=NULL);

};
template < class dtype > 
class CBase_MeshStreamer : public CBaseT1<Group, CProxy_MeshStreamer < dtype >  > { };

/* DECLS: template < class dtype > group GroupMeshStreamer: MeshStreamer<dtype >{
GroupMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
};
 */
template < class dtype >  class GroupMeshStreamer;
template < class dtype >  class CkIndex_GroupMeshStreamer;
template < class dtype >  class CProxy_GroupMeshStreamer;
template < class dtype >  class CProxyElement_GroupMeshStreamer;
template < class dtype >  class CProxySection_GroupMeshStreamer;
/* --------------- index object ------------------ */
template < class dtype > class CkIndex_GroupMeshStreamer:public CProxyElement_MeshStreamer<dtype >{
  public:
    typedef GroupMeshStreamer < dtype >  local_t;
    typedef CkIndex_GroupMeshStreamer < dtype >  index_t;
    typedef CProxy_GroupMeshStreamer < dtype >  proxy_t;
    typedef CProxyElement_GroupMeshStreamer < dtype >  element_t;
    typedef CProxySection_GroupMeshStreamer < dtype >  section_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: GroupMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
 */
    static int __idx_GroupMeshStreamer_marshall1;
    static int ckNew(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag = 0, double progressPeriodInMs = -1.0) { return __idx_GroupMeshStreamer_marshall1; }
    static void _call_GroupMeshStreamer_marshall1(void* impl_msg,GroupMeshStreamer < dtype > * impl_obj);
    static int _callmarshall_GroupMeshStreamer_marshall1(char* impl_buf,GroupMeshStreamer < dtype > * impl_obj);
    static void _marshallmessagepup_GroupMeshStreamer_marshall1(PUP::er &p,void *msg);

};
/* --------------- element proxy ------------------ */
template < class dtype > class CProxyElement_GroupMeshStreamer: public CProxyElement_MeshStreamer<dtype >{
  public:
    typedef GroupMeshStreamer < dtype >  local_t;
    typedef CkIndex_GroupMeshStreamer < dtype >  index_t;
    typedef CProxy_GroupMeshStreamer < dtype >  proxy_t;
    typedef CProxyElement_GroupMeshStreamer < dtype >  element_t;
    typedef CProxySection_GroupMeshStreamer < dtype >  section_t;

    CProxyElement_GroupMeshStreamer(void) {}
    CProxyElement_GroupMeshStreamer(const IrrGroup *g) : CProxyElement_MeshStreamer<dtype >(g){  }
    CProxyElement_GroupMeshStreamer(CkGroupID _gid,int _onPE,CK_DELCTOR_PARAM) : CProxyElement_MeshStreamer<dtype >(_gid,_onPE,CK_DELCTOR_ARGS){  }
    CProxyElement_GroupMeshStreamer(CkGroupID _gid,int _onPE) : CProxyElement_MeshStreamer<dtype >(_gid,_onPE){  }
int ckIsDelegated(void) const {return CProxyElement_MeshStreamer<dtype >::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxyElement_MeshStreamer<dtype >::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxyElement_MeshStreamer<dtype >::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxyElement_MeshStreamer<dtype >::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxyElement_MeshStreamer<dtype >::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxyElement_MeshStreamer<dtype >::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxyElement_MeshStreamer<dtype >::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_MeshStreamer<dtype >::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_MeshStreamer<dtype >::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxyElement_MeshStreamer<dtype >::ckSetReductionClient(cb); }
int ckGetGroupPe(void) const
{return CProxyElement_MeshStreamer<dtype >::ckGetGroupPe();}
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_MeshStreamer<dtype >::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_MeshStreamer<dtype >::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_MeshStreamer<dtype >::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxyElement_MeshStreamer<dtype >::ckSetGroupID(g);
    }
    GroupMeshStreamer < dtype > * ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static GroupMeshStreamer < dtype > * ckLocalBranch(CkGroupID gID) {
      return (GroupMeshStreamer < dtype > *)CkLocalBranch(gID);
    }
/* DECLS: GroupMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
 */

};
/* ---------------- collective proxy -------------- */
template < class dtype > class CProxy_GroupMeshStreamer: public CProxy_MeshStreamer<dtype >{
  public:
    typedef GroupMeshStreamer < dtype >  local_t;
    typedef CkIndex_GroupMeshStreamer < dtype >  index_t;
    typedef CProxy_GroupMeshStreamer < dtype >  proxy_t;
    typedef CProxyElement_GroupMeshStreamer < dtype >  element_t;
    typedef CProxySection_GroupMeshStreamer < dtype >  section_t;

    CProxy_GroupMeshStreamer(void) {}
    CProxy_GroupMeshStreamer(const IrrGroup *g) : CProxy_MeshStreamer<dtype >(g){  }
    CProxy_GroupMeshStreamer(CkGroupID _gid,CK_DELCTOR_PARAM) : CProxy_MeshStreamer<dtype >(_gid,CK_DELCTOR_ARGS){  }
    CProxy_GroupMeshStreamer(CkGroupID _gid) : CProxy_MeshStreamer<dtype >(_gid){  }
    CProxyElement_GroupMeshStreamer < dtype >  operator[](int onPE) const
      {return CProxyElement_GroupMeshStreamer < dtype > (ckGetGroupID(),onPE,CK_DELCTOR_CALL);}
int ckIsDelegated(void) const {return CProxy_MeshStreamer<dtype >::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxy_MeshStreamer<dtype >::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxy_MeshStreamer<dtype >::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxy_MeshStreamer<dtype >::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxy_MeshStreamer<dtype >::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxy_MeshStreamer<dtype >::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxy_MeshStreamer<dtype >::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_MeshStreamer<dtype >::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_MeshStreamer<dtype >::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxy_MeshStreamer<dtype >::ckSetReductionClient(cb); }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_MeshStreamer<dtype >::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_MeshStreamer<dtype >::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_MeshStreamer<dtype >::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxy_MeshStreamer<dtype >::ckSetGroupID(g);
    }
    GroupMeshStreamer < dtype > * ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static GroupMeshStreamer < dtype > * ckLocalBranch(CkGroupID gID) {
      return (GroupMeshStreamer < dtype > *)CkLocalBranch(gID);
    }
/* DECLS: GroupMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
 */
    static CkGroupID ckNew(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag = 0, double progressPeriodInMs = -1.0, const CkEntryOptions *impl_e_opts=NULL);
    CProxy_GroupMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag = 0, double progressPeriodInMs = -1.0, const CkEntryOptions *impl_e_opts=NULL);

};
/* ---------------- section proxy -------------- */
template < class dtype > class CProxySection_GroupMeshStreamer: public CProxySection_MeshStreamer<dtype >{
  public:
    typedef GroupMeshStreamer < dtype >  local_t;
    typedef CkIndex_GroupMeshStreamer < dtype >  index_t;
    typedef CProxy_GroupMeshStreamer < dtype >  proxy_t;
    typedef CProxyElement_GroupMeshStreamer < dtype >  element_t;
    typedef CProxySection_GroupMeshStreamer < dtype >  section_t;

    CProxySection_GroupMeshStreamer(void) {}
    CProxySection_GroupMeshStreamer(const IrrGroup *g) : CProxySection_MeshStreamer<dtype >(g){  }
    CProxySection_GroupMeshStreamer(const CkGroupID &_gid,const int *_pelist,int _npes,CK_DELCTOR_PARAM) : CProxySection_MeshStreamer<dtype >(_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
    CProxySection_GroupMeshStreamer(const CkGroupID &_gid,const int *_pelist,int _npes) : CProxySection_MeshStreamer<dtype >(_gid,_pelist,_npes){  }
    CProxySection_GroupMeshStreamer(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes) : CProxySection_MeshStreamer<dtype >(n,_gid,_pelist,_npes){  }
    CProxySection_GroupMeshStreamer(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes,CK_DELCTOR_PARAM) : CProxySection_MeshStreamer<dtype >(n,_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
int ckIsDelegated(void) const {return CProxySection_MeshStreamer<dtype >::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxySection_MeshStreamer<dtype >::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxySection_MeshStreamer<dtype >::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxySection_MeshStreamer<dtype >::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxySection_MeshStreamer<dtype >::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxySection_MeshStreamer<dtype >::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxySection_MeshStreamer<dtype >::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_MeshStreamer<dtype >::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_MeshStreamer<dtype >::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxySection_MeshStreamer<dtype >::ckSetReductionClient(cb); }
inline int ckGetNumSections() const
{ return CProxySection_MeshStreamer<dtype >::ckGetNumSections(); }
inline CkSectionInfo &ckGetSectionInfo()
{ return CProxySection_MeshStreamer<dtype >::ckGetSectionInfo(); }
inline CkSectionID *ckGetSectionIDs()
{ return CProxySection_MeshStreamer<dtype >::ckGetSectionIDs(); }
inline CkSectionID &ckGetSectionID()
{ return CProxySection_MeshStreamer<dtype >::ckGetSectionID(); }
inline CkSectionID &ckGetSectionID(int i)
{ return CProxySection_MeshStreamer<dtype >::ckGetSectionID(i); }
inline CkGroupID ckGetGroupIDn(int i) const
{ return CProxySection_MeshStreamer<dtype >::ckGetGroupIDn(i); }
inline int *ckGetElements() const
{ return CProxySection_MeshStreamer<dtype >::ckGetElements(); }
inline int *ckGetElements(int i) const
{ return CProxySection_MeshStreamer<dtype >::ckGetElements(i); }
inline int ckGetNumElements() const
{ return CProxySection_MeshStreamer<dtype >::ckGetNumElements(); } 
inline int ckGetNumElements(int i) const
{ return CProxySection_MeshStreamer<dtype >::ckGetNumElements(i); }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxySection_MeshStreamer<dtype >::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxySection_MeshStreamer<dtype >::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxySection_MeshStreamer<dtype >::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxySection_MeshStreamer<dtype >::ckSetGroupID(g);
    }
    GroupMeshStreamer < dtype > * ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static GroupMeshStreamer < dtype > * ckLocalBranch(CkGroupID gID) {
      return (GroupMeshStreamer < dtype > *)CkLocalBranch(gID);
    }
/* DECLS: GroupMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerGroupClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
 */

};
template < class dtype > 
class CBase_GroupMeshStreamer : public CBaseT1<MeshStreamer<dtype >, CProxy_GroupMeshStreamer < dtype >  > { };

/* DECLS: template < class dtype > group ArrayMeshStreamer: MeshStreamer<ArrayDataItem<dtype > >{
ArrayMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg);
};
 */
template < class dtype >  class ArrayMeshStreamer;
template < class dtype >  class CkIndex_ArrayMeshStreamer;
template < class dtype >  class CProxy_ArrayMeshStreamer;
template < class dtype >  class CProxyElement_ArrayMeshStreamer;
template < class dtype >  class CProxySection_ArrayMeshStreamer;
/* --------------- index object ------------------ */
template < class dtype > class CkIndex_ArrayMeshStreamer:public CProxyElement_MeshStreamer<ArrayDataItem<dtype > >{
  public:
    typedef ArrayMeshStreamer < dtype >  local_t;
    typedef CkIndex_ArrayMeshStreamer < dtype >  index_t;
    typedef CProxy_ArrayMeshStreamer < dtype >  proxy_t;
    typedef CProxyElement_ArrayMeshStreamer < dtype >  element_t;
    typedef CProxySection_ArrayMeshStreamer < dtype >  section_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: ArrayMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
 */
    static int __idx_ArrayMeshStreamer_marshall1;
    static int ckNew(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag = 0, double progressPeriodInMs = -1.0) { return __idx_ArrayMeshStreamer_marshall1; }
    static void _call_ArrayMeshStreamer_marshall1(void* impl_msg,ArrayMeshStreamer < dtype > * impl_obj);
    static int _callmarshall_ArrayMeshStreamer_marshall1(char* impl_buf,ArrayMeshStreamer < dtype > * impl_obj);
    static void _marshallmessagepup_ArrayMeshStreamer_marshall1(PUP::er &p,void *msg);

/* DECLS: void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg);
 */
    static int __idx_receiveArrayData_MeshStreamerMessage;
    static int receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg) { return __idx_receiveArrayData_MeshStreamerMessage; }
    static void _call_receiveArrayData_MeshStreamerMessage(void* impl_msg,ArrayMeshStreamer < dtype > * impl_obj);

};
/* --------------- element proxy ------------------ */
template < class dtype > class CProxyElement_ArrayMeshStreamer: public CProxyElement_MeshStreamer<ArrayDataItem<dtype > >{
  public:
    typedef ArrayMeshStreamer < dtype >  local_t;
    typedef CkIndex_ArrayMeshStreamer < dtype >  index_t;
    typedef CProxy_ArrayMeshStreamer < dtype >  proxy_t;
    typedef CProxyElement_ArrayMeshStreamer < dtype >  element_t;
    typedef CProxySection_ArrayMeshStreamer < dtype >  section_t;

    CProxyElement_ArrayMeshStreamer(void) {}
    CProxyElement_ArrayMeshStreamer(const IrrGroup *g) : CProxyElement_MeshStreamer<ArrayDataItem<dtype > >(g){  }
    CProxyElement_ArrayMeshStreamer(CkGroupID _gid,int _onPE,CK_DELCTOR_PARAM) : CProxyElement_MeshStreamer<ArrayDataItem<dtype > >(_gid,_onPE,CK_DELCTOR_ARGS){  }
    CProxyElement_ArrayMeshStreamer(CkGroupID _gid,int _onPE) : CProxyElement_MeshStreamer<ArrayDataItem<dtype > >(_gid,_onPE){  }
int ckIsDelegated(void) const {return CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::ckSetReductionClient(cb); }
int ckGetGroupPe(void) const
{return CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::ckGetGroupPe();}
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxyElement_MeshStreamer<ArrayDataItem<dtype > >::ckSetGroupID(g);
    }
    ArrayMeshStreamer < dtype > * ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static ArrayMeshStreamer < dtype > * ckLocalBranch(CkGroupID gID) {
      return (ArrayMeshStreamer < dtype > *)CkLocalBranch(gID);
    }
/* DECLS: ArrayMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
 */

/* DECLS: void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg);
 */
    void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg);

};
/* ---------------- collective proxy -------------- */
template < class dtype > class CProxy_ArrayMeshStreamer: public CProxy_MeshStreamer<ArrayDataItem<dtype > >{
  public:
    typedef ArrayMeshStreamer < dtype >  local_t;
    typedef CkIndex_ArrayMeshStreamer < dtype >  index_t;
    typedef CProxy_ArrayMeshStreamer < dtype >  proxy_t;
    typedef CProxyElement_ArrayMeshStreamer < dtype >  element_t;
    typedef CProxySection_ArrayMeshStreamer < dtype >  section_t;

    CProxy_ArrayMeshStreamer(void) {}
    CProxy_ArrayMeshStreamer(const IrrGroup *g) : CProxy_MeshStreamer<ArrayDataItem<dtype > >(g){  }
    CProxy_ArrayMeshStreamer(CkGroupID _gid,CK_DELCTOR_PARAM) : CProxy_MeshStreamer<ArrayDataItem<dtype > >(_gid,CK_DELCTOR_ARGS){  }
    CProxy_ArrayMeshStreamer(CkGroupID _gid) : CProxy_MeshStreamer<ArrayDataItem<dtype > >(_gid){  }
    CProxyElement_ArrayMeshStreamer < dtype >  operator[](int onPE) const
      {return CProxyElement_ArrayMeshStreamer < dtype > (ckGetGroupID(),onPE,CK_DELCTOR_CALL);}
int ckIsDelegated(void) const {return CProxy_MeshStreamer<ArrayDataItem<dtype > >::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxy_MeshStreamer<ArrayDataItem<dtype > >::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxy_MeshStreamer<ArrayDataItem<dtype > >::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxy_MeshStreamer<ArrayDataItem<dtype > >::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxy_MeshStreamer<ArrayDataItem<dtype > >::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxy_MeshStreamer<ArrayDataItem<dtype > >::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxy_MeshStreamer<ArrayDataItem<dtype > >::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_MeshStreamer<ArrayDataItem<dtype > >::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_MeshStreamer<ArrayDataItem<dtype > >::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxy_MeshStreamer<ArrayDataItem<dtype > >::ckSetReductionClient(cb); }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_MeshStreamer<ArrayDataItem<dtype > >::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_MeshStreamer<ArrayDataItem<dtype > >::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_MeshStreamer<ArrayDataItem<dtype > >::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxy_MeshStreamer<ArrayDataItem<dtype > >::ckSetGroupID(g);
    }
    ArrayMeshStreamer < dtype > * ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static ArrayMeshStreamer < dtype > * ckLocalBranch(CkGroupID gID) {
      return (ArrayMeshStreamer < dtype > *)CkLocalBranch(gID);
    }
/* DECLS: ArrayMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
 */
    static CkGroupID ckNew(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag = 0, double progressPeriodInMs = -1.0, const CkEntryOptions *impl_e_opts=NULL);
    CProxy_ArrayMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag = 0, double progressPeriodInMs = -1.0, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg);
 */
    void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg);
    void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg, int npes, int *pes);
    void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg, CmiGroup &grp);

};
/* ---------------- section proxy -------------- */
template < class dtype > class CProxySection_ArrayMeshStreamer: public CProxySection_MeshStreamer<ArrayDataItem<dtype > >{
  public:
    typedef ArrayMeshStreamer < dtype >  local_t;
    typedef CkIndex_ArrayMeshStreamer < dtype >  index_t;
    typedef CProxy_ArrayMeshStreamer < dtype >  proxy_t;
    typedef CProxyElement_ArrayMeshStreamer < dtype >  element_t;
    typedef CProxySection_ArrayMeshStreamer < dtype >  section_t;

    CProxySection_ArrayMeshStreamer(void) {}
    CProxySection_ArrayMeshStreamer(const IrrGroup *g) : CProxySection_MeshStreamer<ArrayDataItem<dtype > >(g){  }
    CProxySection_ArrayMeshStreamer(const CkGroupID &_gid,const int *_pelist,int _npes,CK_DELCTOR_PARAM) : CProxySection_MeshStreamer<ArrayDataItem<dtype > >(_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
    CProxySection_ArrayMeshStreamer(const CkGroupID &_gid,const int *_pelist,int _npes) : CProxySection_MeshStreamer<ArrayDataItem<dtype > >(_gid,_pelist,_npes){  }
    CProxySection_ArrayMeshStreamer(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes) : CProxySection_MeshStreamer<ArrayDataItem<dtype > >(n,_gid,_pelist,_npes){  }
    CProxySection_ArrayMeshStreamer(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes,CK_DELCTOR_PARAM) : CProxySection_MeshStreamer<ArrayDataItem<dtype > >(n,_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
int ckIsDelegated(void) const {return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_MeshStreamer<ArrayDataItem<dtype > >::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckSetReductionClient(cb); }
inline int ckGetNumSections() const
{ return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckGetNumSections(); }
inline CkSectionInfo &ckGetSectionInfo()
{ return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckGetSectionInfo(); }
inline CkSectionID *ckGetSectionIDs()
{ return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckGetSectionIDs(); }
inline CkSectionID &ckGetSectionID()
{ return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckGetSectionID(); }
inline CkSectionID &ckGetSectionID(int i)
{ return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckGetSectionID(i); }
inline CkGroupID ckGetGroupIDn(int i) const
{ return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckGetGroupIDn(i); }
inline int *ckGetElements() const
{ return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckGetElements(); }
inline int *ckGetElements(int i) const
{ return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckGetElements(i); }
inline int ckGetNumElements() const
{ return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckGetNumElements(); } 
inline int ckGetNumElements(int i) const
{ return CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckGetNumElements(i); }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxySection_MeshStreamer<ArrayDataItem<dtype > >::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxySection_MeshStreamer<ArrayDataItem<dtype > >::ckSetGroupID(g);
    }
    ArrayMeshStreamer < dtype > * ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static ArrayMeshStreamer < dtype > * ckLocalBranch(CkGroupID gID) {
      return (ArrayMeshStreamer < dtype > *)CkLocalBranch(gID);
    }
/* DECLS: ArrayMeshStreamer(int totalBufferCapacity, int numDimensions, const int *dimensionSizes, const CProxy_MeshStreamerArrayClient<dtype > &clientProxy, bool yieldFlag, double progressPeriodInMs);
 */

/* DECLS: void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg);
 */
    void receiveArrayData(MeshStreamerMessage<ArrayDataItem<dtype > >* impl_msg);

};
template < class dtype > 
class CBase_ArrayMeshStreamer : public CBaseT1<MeshStreamer<ArrayDataItem<dtype > >, CProxy_ArrayMeshStreamer < dtype >  > { };

extern void _registerNDMeshStreamer(void);
#endif
