/* DEFS: group CompletionDetector: IrrGroup{
CompletionDetector(void);
void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_);
void producers_done(int producers_done_global_);
void count_consumed(int produced_global, int consumed_global);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_CompletionDetector::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: CompletionDetector(void);
 */

/* DEFS: void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_);
 */
void CProxyElement_CompletionDetector::start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int num_producers, const CkCallback &start, const CkCallback &finish, int prio_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num_producers;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)start;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)finish;
    implP|prio_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num_producers;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)start;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)finish;
    implP|prio_;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CompletionDetector::__idx_start_detection_marshall2, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CompletionDetector::__idx_start_detection_marshall2, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CompletionDetector::__idx_start_detection_marshall2, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void producers_done(int producers_done_global_);
 */
void CProxyElement_CompletionDetector::producers_done(int producers_done_global_, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int producers_done_global_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|producers_done_global_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|producers_done_global_;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CompletionDetector::__idx_producers_done_marshall3, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CompletionDetector::__idx_producers_done_marshall3, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CompletionDetector::__idx_producers_done_marshall3, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}
void CkIndex_CompletionDetector::_producers_done_redn_wrapper(void* impl_msg, CompletionDetector* impl_obj)
{
  char* impl_buf = (char*)((CkReductionMsg*)impl_msg)->getData();
  /*Unmarshall pup'd fields: int producers_done_global_*/
  PUP::fromMem implP(impl_buf);
/* non two-param case */
  int producers_done_global_; implP|producers_done_global_;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->producers_done(producers_done_global_);

}


/* DEFS: void count_consumed(int produced_global, int consumed_global);
 */
void CProxyElement_CompletionDetector::count_consumed(int produced_global, int consumed_global, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int produced_global, int consumed_global
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|produced_global;
    implP|consumed_global;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|produced_global;
    implP|consumed_global;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CompletionDetector::__idx_count_consumed_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CompletionDetector::__idx_count_consumed_marshall4, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CompletionDetector::__idx_count_consumed_marshall4, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}
void CkIndex_CompletionDetector::_count_consumed_redn_wrapper(void* impl_msg, CompletionDetector* impl_obj)
{
  char* impl_buf = (char*)((CkReductionMsg*)impl_msg)->getData();
  /*Unmarshall pup'd fields: int produced_global, int consumed_global*/
  PUP::fromMem implP(impl_buf);
  int produced_global; implP|produced_global;
  int consumed_global; implP|consumed_global;
  impl_obj->count_consumed(produced_global, consumed_global);

}


/* DEFS: CompletionDetector(void);
 */
CkGroupID CProxy_CompletionDetector::ckNew(void)
{
  void *impl_msg = CkAllocSysMsg();
  return CkCreateGroup(CkIndex_CompletionDetector::__idx, CkIndex_CompletionDetector::__idx_CompletionDetector_void, impl_msg);
}
 int CkIndex_CompletionDetector::__idx_CompletionDetector_void=0;
void CkIndex_CompletionDetector::_call_CompletionDetector_void(void* impl_msg,CompletionDetector * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  new (impl_obj) CompletionDetector();
}

/* DEFS: void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_);
 */
void CProxy_CompletionDetector::start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int num_producers, const CkCallback &start, const CkCallback &finish, int prio_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num_producers;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)start;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)finish;
    implP|prio_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num_producers;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)start;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)finish;
    implP|prio_;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CompletionDetector::__idx_start_detection_marshall2, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CompletionDetector::__idx_start_detection_marshall2, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CompletionDetector::__idx_start_detection_marshall2, impl_msg, ckGetGroupID(),0);
}
void CProxy_CompletionDetector::start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: int num_producers, const CkCallback &start, const CkCallback &finish, int prio_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num_producers;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)start;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)finish;
    implP|prio_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num_producers;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)start;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)finish;
    implP|prio_;
  }
  CkSendMsgBranchMulti(CkIndex_CompletionDetector::__idx_start_detection_marshall2, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CompletionDetector::start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: int num_producers, const CkCallback &start, const CkCallback &finish, int prio_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num_producers;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)start;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)finish;
    implP|prio_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num_producers;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)start;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)finish;
    implP|prio_;
  }
  CkSendMsgBranchGroup(CkIndex_CompletionDetector::__idx_start_detection_marshall2, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CompletionDetector::__idx_start_detection_marshall2=0;
void CkIndex_CompletionDetector::_call_start_detection_marshall2(void* impl_msg,CompletionDetector * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int num_producers, const CkCallback &start, const CkCallback &finish, int prio_*/
  PUP::fromMem implP(impl_buf);
  int num_producers; implP|num_producers;
  CkCallback start; implP|start;
  CkCallback finish; implP|finish;
  int prio_; implP|prio_;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->start_detection(num_producers, start, finish, prio_);
}
int CkIndex_CompletionDetector::_callmarshall_start_detection_marshall2(char* impl_buf,CompletionDetector * impl_obj) {
  /*Unmarshall pup'd fields: int num_producers, const CkCallback &start, const CkCallback &finish, int prio_*/
  PUP::fromMem implP(impl_buf);
  int num_producers; implP|num_producers;
  CkCallback start; implP|start;
  CkCallback finish; implP|finish;
  int prio_; implP|prio_;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->start_detection(num_producers, start, finish, prio_);
  return implP.size();
}
void CkIndex_CompletionDetector::_marshallmessagepup_start_detection_marshall2(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int num_producers, const CkCallback &start, const CkCallback &finish, int prio_*/
  PUP::fromMem implP(impl_buf);
  int num_producers; implP|num_producers;
  CkCallback start; implP|start;
  CkCallback finish; implP|finish;
  int prio_; implP|prio_;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("num_producers");
  implDestP|num_producers;
  if (implDestP.hasComments()) implDestP.comment("start");
  implDestP|start;
  if (implDestP.hasComments()) implDestP.comment("finish");
  implDestP|finish;
  if (implDestP.hasComments()) implDestP.comment("prio_");
  implDestP|prio_;
}

/* DEFS: void producers_done(int producers_done_global_);
 */
void CProxy_CompletionDetector::producers_done(int producers_done_global_, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int producers_done_global_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|producers_done_global_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|producers_done_global_;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CompletionDetector::__idx_producers_done_marshall3, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CompletionDetector::__idx_producers_done_marshall3, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CompletionDetector::__idx_producers_done_marshall3, impl_msg, ckGetGroupID(),0);
}
void CProxy_CompletionDetector::producers_done(int producers_done_global_, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: int producers_done_global_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|producers_done_global_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|producers_done_global_;
  }
  CkSendMsgBranchMulti(CkIndex_CompletionDetector::__idx_producers_done_marshall3, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CompletionDetector::producers_done(int producers_done_global_, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: int producers_done_global_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|producers_done_global_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|producers_done_global_;
  }
  CkSendMsgBranchGroup(CkIndex_CompletionDetector::__idx_producers_done_marshall3, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CompletionDetector::__idx_producers_done_marshall3=0;
 int CkIndex_CompletionDetector::__idx_producers_done_redn_wrapper=0;
void CkIndex_CompletionDetector::_call_producers_done_marshall3(void* impl_msg,CompletionDetector * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int producers_done_global_*/
  PUP::fromMem implP(impl_buf);
  int producers_done_global_; implP|producers_done_global_;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->producers_done(producers_done_global_);
}
int CkIndex_CompletionDetector::_callmarshall_producers_done_marshall3(char* impl_buf,CompletionDetector * impl_obj) {
  /*Unmarshall pup'd fields: int producers_done_global_*/
  PUP::fromMem implP(impl_buf);
  int producers_done_global_; implP|producers_done_global_;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->producers_done(producers_done_global_);
  return implP.size();
}
void CkIndex_CompletionDetector::_marshallmessagepup_producers_done_marshall3(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int producers_done_global_*/
  PUP::fromMem implP(impl_buf);
  int producers_done_global_; implP|producers_done_global_;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("producers_done_global_");
  implDestP|producers_done_global_;
}

/* DEFS: void count_consumed(int produced_global, int consumed_global);
 */
void CProxy_CompletionDetector::count_consumed(int produced_global, int consumed_global, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int produced_global, int consumed_global
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|produced_global;
    implP|consumed_global;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|produced_global;
    implP|consumed_global;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CompletionDetector::__idx_count_consumed_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CompletionDetector::__idx_count_consumed_marshall4, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CompletionDetector::__idx_count_consumed_marshall4, impl_msg, ckGetGroupID(),0);
}
void CProxy_CompletionDetector::count_consumed(int produced_global, int consumed_global, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: int produced_global, int consumed_global
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|produced_global;
    implP|consumed_global;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|produced_global;
    implP|consumed_global;
  }
  CkSendMsgBranchMulti(CkIndex_CompletionDetector::__idx_count_consumed_marshall4, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CompletionDetector::count_consumed(int produced_global, int consumed_global, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: int produced_global, int consumed_global
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|produced_global;
    implP|consumed_global;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|produced_global;
    implP|consumed_global;
  }
  CkSendMsgBranchGroup(CkIndex_CompletionDetector::__idx_count_consumed_marshall4, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CompletionDetector::__idx_count_consumed_marshall4=0;
 int CkIndex_CompletionDetector::__idx_count_consumed_redn_wrapper=0;
void CkIndex_CompletionDetector::_call_count_consumed_marshall4(void* impl_msg,CompletionDetector * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int produced_global, int consumed_global*/
  PUP::fromMem implP(impl_buf);
  int produced_global; implP|produced_global;
  int consumed_global; implP|consumed_global;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->count_consumed(produced_global, consumed_global);
}
int CkIndex_CompletionDetector::_callmarshall_count_consumed_marshall4(char* impl_buf,CompletionDetector * impl_obj) {
  /*Unmarshall pup'd fields: int produced_global, int consumed_global*/
  PUP::fromMem implP(impl_buf);
  int produced_global; implP|produced_global;
  int consumed_global; implP|consumed_global;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->count_consumed(produced_global, consumed_global);
  return implP.size();
}
void CkIndex_CompletionDetector::_marshallmessagepup_count_consumed_marshall4(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int produced_global, int consumed_global*/
  PUP::fromMem implP(impl_buf);
  int produced_global; implP|produced_global;
  int consumed_global; implP|consumed_global;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("produced_global");
  implDestP|produced_global;
  if (implDestP.hasComments()) implDestP.comment("consumed_global");
  implDestP|consumed_global;
}

/* DEFS: CompletionDetector(void);
 */

/* DEFS: void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_);
 */
void CProxySection_CompletionDetector::start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int num_producers, const CkCallback &start, const CkCallback &finish, int prio_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num_producers;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)start;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)finish;
    implP|prio_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num_producers;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)start;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)finish;
    implP|prio_;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CompletionDetector::__idx_start_detection_marshall2, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CompletionDetector::__idx_start_detection_marshall2, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CompletionDetector::__idx_start_detection_marshall2, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void producers_done(int producers_done_global_);
 */
void CProxySection_CompletionDetector::producers_done(int producers_done_global_, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int producers_done_global_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|producers_done_global_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|producers_done_global_;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CompletionDetector::__idx_producers_done_marshall3, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CompletionDetector::__idx_producers_done_marshall3, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CompletionDetector::__idx_producers_done_marshall3, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void count_consumed(int produced_global, int consumed_global);
 */
void CProxySection_CompletionDetector::count_consumed(int produced_global, int consumed_global, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int produced_global, int consumed_global
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|produced_global;
    implP|consumed_global;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|produced_global;
    implP|consumed_global;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CompletionDetector::__idx_count_consumed_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CompletionDetector::__idx_count_consumed_marshall4, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CompletionDetector::__idx_count_consumed_marshall4, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_CompletionDetector::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeGroup);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,CompletionDetector::isIrreducible());
// REG: CompletionDetector(void);
  __idx_CompletionDetector_void = CkRegisterEp("CompletionDetector(void)",
     (CkCallFnPtr)_call_CompletionDetector_void, 0, __idx, 0);
  CkRegisterDefaultCtor(__idx, __idx_CompletionDetector_void);

// REG: void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_);
  __idx_start_detection_marshall2 = CkRegisterEp("start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_)",
     (CkCallFnPtr)_call_start_detection_marshall2, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_start_detection_marshall2,(CkMarshallUnpackFn)_callmarshall_start_detection_marshall2);
  CkRegisterMessagePupFn(__idx_start_detection_marshall2,(CkMessagePupFn)_marshallmessagepup_start_detection_marshall2);

// REG: void producers_done(int producers_done_global_);
  __idx_producers_done_marshall3 = CkRegisterEp("producers_done(int producers_done_global_)",
     (CkCallFnPtr)_call_producers_done_marshall3, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_producers_done_marshall3,(CkMarshallUnpackFn)_callmarshall_producers_done_marshall3);
  CkRegisterMessagePupFn(__idx_producers_done_marshall3,(CkMessagePupFn)_marshallmessagepup_producers_done_marshall3);
  __idx_producers_done_redn_wrapper = CkRegisterEp("producers_done_redn_wrapper(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_producers_done_redn_wrapper, CMessage_CkReductionMsg::__idx, __idx, 0);
// REG: void count_consumed(int produced_global, int consumed_global);
  __idx_count_consumed_marshall4 = CkRegisterEp("count_consumed(int produced_global, int consumed_global)",
     (CkCallFnPtr)_call_count_consumed_marshall4, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_count_consumed_marshall4,(CkMarshallUnpackFn)_callmarshall_count_consumed_marshall4);
  CkRegisterMessagePupFn(__idx_count_consumed_marshall4,(CkMessagePupFn)_marshallmessagepup_count_consumed_marshall4);
  __idx_count_consumed_redn_wrapper = CkRegisterEp("count_consumed_redn_wrapper(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_count_consumed_redn_wrapper, CMessage_CkReductionMsg::__idx, __idx, 0);
  CompletionDetector::__sdag_register(); 
}
#endif

CompletionDetector_SDAG_CODE_DEF


#ifndef CK_TEMPLATES_ONLY
void _registercompletion(void)
{
  static int _done = 0; if(_done) return; _done = 1;
/* REG: group CompletionDetector: IrrGroup{
CompletionDetector(void);
void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_);
void producers_done(int producers_done_global_);
void count_consumed(int produced_global, int consumed_global);
};
*/
  CkIndex_CompletionDetector::__register("CompletionDetector", sizeof(CompletionDetector));

}
#endif
