#ifndef _DECL_CkArray_H_
#define _DECL_CkArray_H_
#include "charm++.h"
#include "CkReduction.decl.h"

#include "CkLocation.decl.h"

#include "CkArrayReductionMgr.decl.h"

/* DECLS: readonly CmiBool _isAnytimeMigration;
 */

/* DECLS: group CkArray: CkReductionMgr{
CkArray(CkMigrateMessage* impl_msg);
CkArray(const CkArrayOptions &opts, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy);
void insertElement(CkMessage* impl_msg);
void remoteDoneInserting(void);
void sendBroadcast(CkMessage* impl_msg);
void recvBroadcast(CkMessage* impl_msg);
void sendExpeditedBroadcast(CkMessage* impl_msg);
void recvExpeditedBroadcast(CkMessage* impl_msg);
};
 */
 class CkArray;
 class CkIndex_CkArray;
 class CProxy_CkArray;
 class CProxyElement_CkArray;
 class CProxySection_CkArray;
/* --------------- index object ------------------ */
class CkIndex_CkArray:public CProxyElement_CkReductionMgr{
  public:
    typedef CkArray local_t;
    typedef CkIndex_CkArray index_t;
    typedef CProxy_CkArray proxy_t;
    typedef CProxyElement_CkArray element_t;
    typedef CProxySection_CkArray section_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: CkArray(CkMigrateMessage* impl_msg);
 */
    static int __idx_CkArray_CkMigrateMessage;
    static int ckNew(CkMigrateMessage* impl_msg) { return __idx_CkArray_CkMigrateMessage; }
    static void _call_CkArray_CkMigrateMessage(void* impl_msg,CkArray* impl_obj);

/* DECLS: CkArray(const CkArrayOptions &opts, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy);
 */
    static int __idx_CkArray_marshall1;
    static int ckNew(const CkArrayOptions &opts, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy) { return __idx_CkArray_marshall1; }
    static void _call_CkArray_marshall1(void* impl_msg,CkArray* impl_obj);
    static int _callmarshall_CkArray_marshall1(char* impl_buf,CkArray* impl_obj);
    static void _marshallmessagepup_CkArray_marshall1(PUP::er &p,void *msg);

/* DECLS: void insertElement(CkMessage* impl_msg);
 */
    static int __idx_insertElement_CkMessage;
    static int insertElement(CkMessage* impl_msg) { return __idx_insertElement_CkMessage; }
    static void _call_insertElement_CkMessage(void* impl_msg,CkArray* impl_obj);

/* DECLS: void remoteDoneInserting(void);
 */
    static int __idx_remoteDoneInserting_void;
    static int remoteDoneInserting(void) { return __idx_remoteDoneInserting_void; }
    static void _call_remoteDoneInserting_void(void* impl_msg,CkArray* impl_obj);

/* DECLS: void sendBroadcast(CkMessage* impl_msg);
 */
    static int __idx_sendBroadcast_CkMessage;
    static int sendBroadcast(CkMessage* impl_msg) { return __idx_sendBroadcast_CkMessage; }
    static void _call_sendBroadcast_CkMessage(void* impl_msg,CkArray* impl_obj);

/* DECLS: void recvBroadcast(CkMessage* impl_msg);
 */
    static int __idx_recvBroadcast_CkMessage;
    static int recvBroadcast(CkMessage* impl_msg) { return __idx_recvBroadcast_CkMessage; }
    static void _call_recvBroadcast_CkMessage(void* impl_msg,CkArray* impl_obj);

/* DECLS: void sendExpeditedBroadcast(CkMessage* impl_msg);
 */
    static int __idx_sendExpeditedBroadcast_CkMessage;
    static int sendExpeditedBroadcast(CkMessage* impl_msg) { return __idx_sendExpeditedBroadcast_CkMessage; }
    static void _call_sendExpeditedBroadcast_CkMessage(void* impl_msg,CkArray* impl_obj);

/* DECLS: void recvExpeditedBroadcast(CkMessage* impl_msg);
 */
    static int __idx_recvExpeditedBroadcast_CkMessage;
    static int recvExpeditedBroadcast(CkMessage* impl_msg) { return __idx_recvExpeditedBroadcast_CkMessage; }
    static void _call_recvExpeditedBroadcast_CkMessage(void* impl_msg,CkArray* impl_obj);

};
/* --------------- element proxy ------------------ */
class CProxyElement_CkArray: public CProxyElement_CkReductionMgr{
  public:
    typedef CkArray local_t;
    typedef CkIndex_CkArray index_t;
    typedef CProxy_CkArray proxy_t;
    typedef CProxyElement_CkArray element_t;
    typedef CProxySection_CkArray section_t;

    CProxyElement_CkArray(void) {}
    CProxyElement_CkArray(const IrrGroup *g) : CProxyElement_CkReductionMgr(g){  }
    CProxyElement_CkArray(CkGroupID _gid,int _onPE,CK_DELCTOR_PARAM) : CProxyElement_CkReductionMgr(_gid,_onPE,CK_DELCTOR_ARGS){  }
    CProxyElement_CkArray(CkGroupID _gid,int _onPE) : CProxyElement_CkReductionMgr(_gid,_onPE){  }
int ckIsDelegated(void) const {return CProxyElement_CkReductionMgr::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxyElement_CkReductionMgr::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxyElement_CkReductionMgr::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxyElement_CkReductionMgr::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxyElement_CkReductionMgr::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxyElement_CkReductionMgr::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxyElement_CkReductionMgr::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_CkReductionMgr::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_CkReductionMgr::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxyElement_CkReductionMgr::ckSetReductionClient(cb); }
int ckGetGroupPe(void) const
{return CProxyElement_CkReductionMgr::ckGetGroupPe();}
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_CkReductionMgr::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_CkReductionMgr::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_CkReductionMgr::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxyElement_CkReductionMgr::ckSetGroupID(g);
    }
    CkArray* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static CkArray* ckLocalBranch(CkGroupID gID) {
      return (CkArray*)CkLocalBranch(gID);
    }
/* DECLS: CkArray(CkMigrateMessage* impl_msg);
 */

/* DECLS: CkArray(const CkArrayOptions &opts, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy);
 */

/* DECLS: void insertElement(CkMessage* impl_msg);
 */
    void insertElement(CkMessage* impl_msg);

/* DECLS: void remoteDoneInserting(void);
 */
    void remoteDoneInserting(void);

/* DECLS: void sendBroadcast(CkMessage* impl_msg);
 */
    void sendBroadcast(CkMessage* impl_msg);

/* DECLS: void recvBroadcast(CkMessage* impl_msg);
 */
    void recvBroadcast(CkMessage* impl_msg);

/* DECLS: void sendExpeditedBroadcast(CkMessage* impl_msg);
 */
    void sendExpeditedBroadcast(CkMessage* impl_msg);

/* DECLS: void recvExpeditedBroadcast(CkMessage* impl_msg);
 */
    void recvExpeditedBroadcast(CkMessage* impl_msg);

};
PUPmarshall(CProxyElement_CkArray)
/* ---------------- collective proxy -------------- */
class CProxy_CkArray: public CProxy_CkReductionMgr{
  public:
    typedef CkArray local_t;
    typedef CkIndex_CkArray index_t;
    typedef CProxy_CkArray proxy_t;
    typedef CProxyElement_CkArray element_t;
    typedef CProxySection_CkArray section_t;

    CProxy_CkArray(void) {}
    CProxy_CkArray(const IrrGroup *g) : CProxy_CkReductionMgr(g){  }
    CProxy_CkArray(CkGroupID _gid,CK_DELCTOR_PARAM) : CProxy_CkReductionMgr(_gid,CK_DELCTOR_ARGS){  }
    CProxy_CkArray(CkGroupID _gid) : CProxy_CkReductionMgr(_gid){  }
    CProxyElement_CkArray operator[](int onPE) const
      {return CProxyElement_CkArray(ckGetGroupID(),onPE,CK_DELCTOR_CALL);}
int ckIsDelegated(void) const {return CProxy_CkReductionMgr::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxy_CkReductionMgr::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxy_CkReductionMgr::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxy_CkReductionMgr::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxy_CkReductionMgr::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxy_CkReductionMgr::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxy_CkReductionMgr::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_CkReductionMgr::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_CkReductionMgr::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxy_CkReductionMgr::ckSetReductionClient(cb); }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_CkReductionMgr::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_CkReductionMgr::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_CkReductionMgr::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxy_CkReductionMgr::ckSetGroupID(g);
    }
    CkArray* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static CkArray* ckLocalBranch(CkGroupID gID) {
      return (CkArray*)CkLocalBranch(gID);
    }
/* DECLS: CkArray(CkMigrateMessage* impl_msg);
 */

/* DECLS: CkArray(const CkArrayOptions &opts, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy);
 */
    static CkGroupID ckNew(const CkArrayOptions &opts, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy, const CkEntryOptions *impl_e_opts=NULL);
    CProxy_CkArray(const CkArrayOptions &opts, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void insertElement(CkMessage* impl_msg);
 */
    void insertElement(CkMessage* impl_msg);
    void insertElement(CkMessage* impl_msg, int npes, int *pes);
    void insertElement(CkMessage* impl_msg, CmiGroup &grp);

/* DECLS: void remoteDoneInserting(void);
 */
    void remoteDoneInserting(void);
    void remoteDoneInserting(int npes, int *pes);
    void remoteDoneInserting(CmiGroup &grp);

/* DECLS: void sendBroadcast(CkMessage* impl_msg);
 */
    void sendBroadcast(CkMessage* impl_msg);
    void sendBroadcast(CkMessage* impl_msg, int npes, int *pes);
    void sendBroadcast(CkMessage* impl_msg, CmiGroup &grp);

/* DECLS: void recvBroadcast(CkMessage* impl_msg);
 */
    void recvBroadcast(CkMessage* impl_msg);
    void recvBroadcast(CkMessage* impl_msg, int npes, int *pes);
    void recvBroadcast(CkMessage* impl_msg, CmiGroup &grp);

/* DECLS: void sendExpeditedBroadcast(CkMessage* impl_msg);
 */
    void sendExpeditedBroadcast(CkMessage* impl_msg);
    void sendExpeditedBroadcast(CkMessage* impl_msg, int npes, int *pes);
    void sendExpeditedBroadcast(CkMessage* impl_msg, CmiGroup &grp);

/* DECLS: void recvExpeditedBroadcast(CkMessage* impl_msg);
 */
    void recvExpeditedBroadcast(CkMessage* impl_msg);
    void recvExpeditedBroadcast(CkMessage* impl_msg, int npes, int *pes);
    void recvExpeditedBroadcast(CkMessage* impl_msg, CmiGroup &grp);

};
PUPmarshall(CProxy_CkArray)
/* ---------------- section proxy -------------- */
class CProxySection_CkArray: public CProxySection_CkReductionMgr{
  public:
    typedef CkArray local_t;
    typedef CkIndex_CkArray index_t;
    typedef CProxy_CkArray proxy_t;
    typedef CProxyElement_CkArray element_t;
    typedef CProxySection_CkArray section_t;

    CProxySection_CkArray(void) {}
    CProxySection_CkArray(const IrrGroup *g) : CProxySection_CkReductionMgr(g){  }
    CProxySection_CkArray(const CkGroupID &_gid,const int *_pelist,int _npes,CK_DELCTOR_PARAM) : CProxySection_CkReductionMgr(_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
    CProxySection_CkArray(const CkGroupID &_gid,const int *_pelist,int _npes) : CProxySection_CkReductionMgr(_gid,_pelist,_npes){  }
    CProxySection_CkArray(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes) : CProxySection_CkReductionMgr(n,_gid,_pelist,_npes){  }
    CProxySection_CkArray(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes,CK_DELCTOR_PARAM) : CProxySection_CkReductionMgr(n,_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
int ckIsDelegated(void) const {return CProxySection_CkReductionMgr::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxySection_CkReductionMgr::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxySection_CkReductionMgr::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxySection_CkReductionMgr::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxySection_CkReductionMgr::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxySection_CkReductionMgr::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxySection_CkReductionMgr::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_CkReductionMgr::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_CkReductionMgr::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxySection_CkReductionMgr::ckSetReductionClient(cb); }
inline int ckGetNumSections() const
{ return CProxySection_CkReductionMgr::ckGetNumSections(); }
inline CkSectionInfo &ckGetSectionInfo()
{ return CProxySection_CkReductionMgr::ckGetSectionInfo(); }
inline CkSectionID *ckGetSectionIDs()
{ return CProxySection_CkReductionMgr::ckGetSectionIDs(); }
inline CkSectionID &ckGetSectionID()
{ return CProxySection_CkReductionMgr::ckGetSectionID(); }
inline CkSectionID &ckGetSectionID(int i)
{ return CProxySection_CkReductionMgr::ckGetSectionID(i); }
inline CkGroupID ckGetGroupIDn(int i) const
{ return CProxySection_CkReductionMgr::ckGetGroupIDn(i); }
inline int *ckGetElements() const
{ return CProxySection_CkReductionMgr::ckGetElements(); }
inline int *ckGetElements(int i) const
{ return CProxySection_CkReductionMgr::ckGetElements(i); }
inline int ckGetNumElements() const
{ return CProxySection_CkReductionMgr::ckGetNumElements(); } 
inline int ckGetNumElements(int i) const
{ return CProxySection_CkReductionMgr::ckGetNumElements(i); }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxySection_CkReductionMgr::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxySection_CkReductionMgr::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxySection_CkReductionMgr::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxySection_CkReductionMgr::ckSetGroupID(g);
    }
    CkArray* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static CkArray* ckLocalBranch(CkGroupID gID) {
      return (CkArray*)CkLocalBranch(gID);
    }
/* DECLS: CkArray(CkMigrateMessage* impl_msg);
 */

/* DECLS: CkArray(const CkArrayOptions &opts, const CkMarshalledMessage &ctorMsg, const CkNodeGroupID &nodereductionProxy);
 */

/* DECLS: void insertElement(CkMessage* impl_msg);
 */
    void insertElement(CkMessage* impl_msg);

/* DECLS: void remoteDoneInserting(void);
 */
    void remoteDoneInserting(void);

/* DECLS: void sendBroadcast(CkMessage* impl_msg);
 */
    void sendBroadcast(CkMessage* impl_msg);

/* DECLS: void recvBroadcast(CkMessage* impl_msg);
 */
    void recvBroadcast(CkMessage* impl_msg);

/* DECLS: void sendExpeditedBroadcast(CkMessage* impl_msg);
 */
    void sendExpeditedBroadcast(CkMessage* impl_msg);

/* DECLS: void recvExpeditedBroadcast(CkMessage* impl_msg);
 */
    void recvExpeditedBroadcast(CkMessage* impl_msg);

};
PUPmarshall(CProxySection_CkArray)
typedef CBaseT1<CkReductionMgr, CProxy_CkArray> CBase_CkArray;





/* DECLS: array ArrayElement: ArrayBase{
ArrayElement(CkMigrateMessage* impl_msg);
ArrayElement(void);
void ckDestroy(void);
void recvBroadcast(CkMessage* impl_msg);
void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg);
};
 */
 class ArrayElement;
 class CkIndex_ArrayElement;
 class CProxy_ArrayElement;
 class CProxyElement_ArrayElement;
 class CProxySection_ArrayElement;
/* --------------- index object ------------------ */
class CkIndex_ArrayElement:public CProxyElement_ArrayBase{
  public:
    typedef ArrayElement local_t;
    typedef CkIndex_ArrayElement index_t;
    typedef CProxy_ArrayElement proxy_t;
    typedef CProxyElement_ArrayElement element_t;
    typedef CProxySection_ArrayElement section_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: ArrayElement(CkMigrateMessage* impl_msg);
 */
    static int __idx_ArrayElement_CkMigrateMessage;
    static int ckNew(CkMigrateMessage* impl_msg) { return __idx_ArrayElement_CkMigrateMessage; }
    static void _call_ArrayElement_CkMigrateMessage(void* impl_msg,ArrayElement* impl_obj);

/* DECLS: ArrayElement(void);
 */
    static int __idx_ArrayElement_void;
    static int ckNew(void) { return __idx_ArrayElement_void; }
    static void _call_ArrayElement_void(void* impl_msg,ArrayElement* impl_obj);

/* DECLS: void ckDestroy(void);
 */
    static int __idx_ckDestroy_void;
    static int ckDestroy(void) { return __idx_ckDestroy_void; }
    static void _call_ckDestroy_void(void* impl_msg,ArrayElement* impl_obj);

/* DECLS: void recvBroadcast(CkMessage* impl_msg);
 */
    static int __idx_recvBroadcast_CkMessage;
    static int recvBroadcast(CkMessage* impl_msg) { return __idx_recvBroadcast_CkMessage; }
    static void _call_recvBroadcast_CkMessage(void* impl_msg,ArrayElement* impl_obj);

/* DECLS: void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg);
 */
    static int __idx_inmem_checkpoint_CkArrayCheckPTReqMessage;
    static int inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg) { return __idx_inmem_checkpoint_CkArrayCheckPTReqMessage; }
    static void _call_inmem_checkpoint_CkArrayCheckPTReqMessage(void* impl_msg,ArrayElement* impl_obj);

};
/* --------------- element proxy ------------------ */
 class CProxyElement_ArrayElement : public CProxyElement_ArrayBase{
  public:
    typedef ArrayElement local_t;
    typedef CkIndex_ArrayElement index_t;
    typedef CProxy_ArrayElement proxy_t;
    typedef CProxyElement_ArrayElement element_t;
    typedef CProxySection_ArrayElement section_t;

    CProxyElement_ArrayElement(void) {}
    CProxyElement_ArrayElement(const ArrayElement *e) : CProxyElement_ArrayBase(e){  }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_ArrayBase::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_ArrayBase::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_ArrayBase::pup(p);
    }
int ckIsDelegated(void) const {return CProxyElement_ArrayBase::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxyElement_ArrayBase::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxyElement_ArrayBase::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxyElement_ArrayBase::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxyElement_ArrayBase::ckCheck();}
inline operator CkArrayID () const {return ckGetArrayID();}
inline static CkArrayID ckCreateEmptyArray(void){ return CProxyElement_ArrayBase::ckCreateEmptyArray(); }
inline static CkArrayID ckCreateArray(CkArrayMessage *m,int ctor,const CkArrayOptions &opts){ return CProxyElement_ArrayBase::ckCreateArray(m,ctor,opts); }
inline void ckInsertIdx(CkArrayMessage *m,int ctor,int onPe,const CkArrayIndex &idx){ CProxyElement_ArrayBase::ckInsertIdx(m,ctor,onPe,idx); }
inline void ckBroadcast(CkArrayMessage *m, int ep, int opts=0) const{ CProxyElement_ArrayBase::ckBroadcast(m,ep,opts); }
inline CkArrayID ckGetArrayID(void) const{ return CProxyElement_ArrayBase::ckGetArrayID();}
inline CkArray *ckLocalBranch(void) const{ return CProxyElement_ArrayBase::ckLocalBranch(); }
inline CkLocMgr *ckLocMgr(void) const{ return CProxyElement_ArrayBase::ckLocMgr(); }
inline void doneInserting(void) { CProxyElement_ArrayBase::doneInserting(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_ArrayBase::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_ArrayBase::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxyElement_ArrayBase::ckSetReductionClient(cb); }
inline void ckInsert(CkArrayMessage *m,int ctor,int onPe)
  { CProxyElement_ArrayBase::ckInsert(m,ctor,onPe); }
inline void ckSend(CkArrayMessage *m, int ep, int opts = 0) const
  { CProxyElement_ArrayBase::ckSend(m,ep,opts); }
inline void *ckSendSync(CkArrayMessage *m, int ep) const
  { return CProxyElement_ArrayBase::ckSendSync(m,ep); }
inline const CkArrayIndex &ckGetIndex() const
  { return CProxyElement_ArrayBase::ckGetIndex(); }
    ArrayElement *ckLocal(void) const
      { return (ArrayElement *)CProxyElement_ArrayBase::ckLocal(); }
    CProxyElement_ArrayElement(const CkArrayID &aid,const CkArrayIndex &idx,CK_DELCTOR_PARAM)
        :CProxyElement_ArrayBase(aid,idx,CK_DELCTOR_ARGS) {}
    CProxyElement_ArrayElement(const CkArrayID &aid,const CkArrayIndex &idx)
        :CProxyElement_ArrayBase(aid,idx) {}
/* DECLS: ArrayElement(CkMigrateMessage* impl_msg);
 */

/* DECLS: ArrayElement(void);
 */
    void insert(int onPE=-1);
/* DECLS: void ckDestroy(void);
 */
    void ckDestroy(void) ;

/* DECLS: void recvBroadcast(CkMessage* impl_msg);
 */
    void recvBroadcast(CkMessage* impl_msg) ;

/* DECLS: void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg);
 */
    void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg) ;

};
PUPmarshall(CProxyElement_ArrayElement)
/* ---------------- collective proxy -------------- */
 class CProxy_ArrayElement : public CProxy_ArrayBase{
  public:
    typedef ArrayElement local_t;
    typedef CkIndex_ArrayElement index_t;
    typedef CProxy_ArrayElement proxy_t;
    typedef CProxyElement_ArrayElement element_t;
    typedef CProxySection_ArrayElement section_t;

    CProxy_ArrayElement(void) {}
    CProxy_ArrayElement(const ArrayElement *e) : CProxy_ArrayBase(e){  }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_ArrayBase::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_ArrayBase::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_ArrayBase::pup(p);
    }
int ckIsDelegated(void) const {return CProxy_ArrayBase::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxy_ArrayBase::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxy_ArrayBase::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxy_ArrayBase::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxy_ArrayBase::ckCheck();}
inline operator CkArrayID () const {return ckGetArrayID();}
inline static CkArrayID ckCreateEmptyArray(void){ return CProxy_ArrayBase::ckCreateEmptyArray(); }
inline static CkArrayID ckCreateArray(CkArrayMessage *m,int ctor,const CkArrayOptions &opts){ return CProxy_ArrayBase::ckCreateArray(m,ctor,opts); }
inline void ckInsertIdx(CkArrayMessage *m,int ctor,int onPe,const CkArrayIndex &idx){ CProxy_ArrayBase::ckInsertIdx(m,ctor,onPe,idx); }
inline void ckBroadcast(CkArrayMessage *m, int ep, int opts=0) const{ CProxy_ArrayBase::ckBroadcast(m,ep,opts); }
inline CkArrayID ckGetArrayID(void) const{ return CProxy_ArrayBase::ckGetArrayID();}
inline CkArray *ckLocalBranch(void) const{ return CProxy_ArrayBase::ckLocalBranch(); }
inline CkLocMgr *ckLocMgr(void) const{ return CProxy_ArrayBase::ckLocMgr(); }
inline void doneInserting(void) { CProxy_ArrayBase::doneInserting(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_ArrayBase::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_ArrayBase::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxy_ArrayBase::ckSetReductionClient(cb); }
    static CkArrayID ckNew(void) {return ckCreateEmptyArray();}
    CProxy_ArrayElement(const CkArrayID &aid,CK_DELCTOR_PARAM) 
        :CProxy_ArrayBase(aid,CK_DELCTOR_ARGS) {}
    CProxy_ArrayElement(const CkArrayID &aid) 
        :CProxy_ArrayBase(aid) {}
/* DECLS: ArrayElement(CkMigrateMessage* impl_msg);
 */

/* DECLS: ArrayElement(void);
 */
    static CkArrayID ckNew(const CkArrayOptions &opts);

/* DECLS: void ckDestroy(void);
 */
    void ckDestroy(void) ;

/* DECLS: void recvBroadcast(CkMessage* impl_msg);
 */
    void recvBroadcast(CkMessage* impl_msg) ;

/* DECLS: void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg);
 */
    void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg) ;

};
PUPmarshall(CProxy_ArrayElement)
/* ---------------- section proxy -------------- */
 class CProxySection_ArrayElement : public CProxySection_ArrayBase{
  public:
    typedef ArrayElement local_t;
    typedef CkIndex_ArrayElement index_t;
    typedef CProxy_ArrayElement proxy_t;
    typedef CProxyElement_ArrayElement element_t;
    typedef CProxySection_ArrayElement section_t;

    CProxySection_ArrayElement(void) {}
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxySection_ArrayBase::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxySection_ArrayBase::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxySection_ArrayBase::pup(p);
    }
int ckIsDelegated(void) const {return CProxySection_ArrayBase::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxySection_ArrayBase::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxySection_ArrayBase::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxySection_ArrayBase::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxySection_ArrayBase::ckCheck();}
inline operator CkArrayID () const {return ckGetArrayID();}
inline static CkArrayID ckCreateEmptyArray(void){ return CProxySection_ArrayBase::ckCreateEmptyArray(); }
inline static CkArrayID ckCreateArray(CkArrayMessage *m,int ctor,const CkArrayOptions &opts){ return CProxySection_ArrayBase::ckCreateArray(m,ctor,opts); }
inline void ckInsertIdx(CkArrayMessage *m,int ctor,int onPe,const CkArrayIndex &idx){ CProxySection_ArrayBase::ckInsertIdx(m,ctor,onPe,idx); }
inline void ckBroadcast(CkArrayMessage *m, int ep, int opts=0) const{ CProxySection_ArrayBase::ckBroadcast(m,ep,opts); }
inline CkArrayID ckGetArrayID(void) const{ return CProxySection_ArrayBase::ckGetArrayID();}
inline CkArray *ckLocalBranch(void) const{ return CProxySection_ArrayBase::ckLocalBranch(); }
inline CkLocMgr *ckLocMgr(void) const{ return CProxySection_ArrayBase::ckLocMgr(); }
inline void doneInserting(void) { CProxySection_ArrayBase::doneInserting(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_ArrayBase::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_ArrayBase::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxySection_ArrayBase::ckSetReductionClient(cb); }
inline void ckSend(CkArrayMessage *m, int ep, int opts = 0)
 { CProxySection_ArrayBase::ckSend(m,ep,opts); }
inline CkSectionInfo &ckGetSectionInfo()
  { return CProxySection_ArrayBase::ckGetSectionInfo(); }
inline CkSectionID *ckGetSectionIDs()
  { return CProxySection_ArrayBase::ckGetSectionIDs(); }
inline CkSectionID &ckGetSectionID()
  { return CProxySection_ArrayBase::ckGetSectionID(); }
inline CkSectionID &ckGetSectionID(int i)
  { return CProxySection_ArrayBase::ckGetSectionID(i); }
inline CkArrayID ckGetArrayIDn(int i) const
{return CProxySection_ArrayBase::ckGetArrayIDn(i); } 
inline CkArrayIndexMax *ckGetArrayElements() const
  { return CProxySection_ArrayBase::ckGetArrayElements(); }
inline CkArrayIndexMax *ckGetArrayElements(int i) const
{return CProxySection_ArrayBase::ckGetArrayElements(i); }
inline int ckGetNumElements() const
  { return CProxySection_ArrayBase::ckGetNumElements(); } 
inline int ckGetNumElements(int i) const
{return CProxySection_ArrayBase::ckGetNumElements(i); } 
    CProxySection_ArrayElement(const CkArrayID &aid, CkArrayIndexMax *elems, int nElems, CK_DELCTOR_PARAM) 
        :CProxySection_ArrayBase(aid,elems,nElems,CK_DELCTOR_ARGS) {}
    CProxySection_ArrayElement(const CkArrayID &aid, CkArrayIndexMax *elems, int nElems) 
        :CProxySection_ArrayBase(aid,elems,nElems) {}
    CProxySection_ArrayElement(const CkSectionID &sid)       :CProxySection_ArrayBase(sid) {}
    CProxySection_ArrayElement(int n, const CkArrayID *aid, CkArrayIndexMax const * const *elems, const int *nElems, CK_DELCTOR_PARAM) 
        :CProxySection_ArrayBase(n,aid,elems,nElems,CK_DELCTOR_ARGS) {}
    CProxySection_ArrayElement(int n, const CkArrayID *aid, CkArrayIndexMax const * const *elems, const int *nElems) 
        :CProxySection_ArrayBase(n,aid,elems,nElems) {}
    static CkSectionID ckNew(const CkArrayID &aid, CkArrayIndexMax *elems, int nElems) {
      return CkSectionID(aid, elems, nElems);
    } 
/* DECLS: ArrayElement(CkMigrateMessage* impl_msg);
 */

/* DECLS: ArrayElement(void);
 */

/* DECLS: void ckDestroy(void);
 */
    void ckDestroy(void) ;

/* DECLS: void recvBroadcast(CkMessage* impl_msg);
 */
    void recvBroadcast(CkMessage* impl_msg) ;

/* DECLS: void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg);
 */
    void inmem_checkpoint(CkArrayCheckPTReqMessage* impl_msg) ;

};
PUPmarshall(CProxySection_ArrayElement)
typedef CBaseT1<ArrayBase, CProxy_ArrayElement> CBase_ArrayElement;

extern void _registerCkArray(void);
#endif
