#ifndef _DECL_completion_H_
#define _DECL_completion_H_
#include "charm++.h"
/* DECLS: group CompletionDetector: IrrGroup{
CompletionDetector(void);
void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_);
void producers_done(int producers_done_global_);
void count_consumed(int produced_global, int consumed_global);
};
 */
 class CompletionDetector;
 class CkIndex_CompletionDetector;
 class CProxy_CompletionDetector;
 class CProxyElement_CompletionDetector;
 class CProxySection_CompletionDetector;
/* --------------- index object ------------------ */
class CkIndex_CompletionDetector:public CProxyElement_IrrGroup{
  public:
    typedef CompletionDetector local_t;
    typedef CkIndex_CompletionDetector index_t;
    typedef CProxy_CompletionDetector proxy_t;
    typedef CProxyElement_CompletionDetector element_t;
    typedef CProxySection_CompletionDetector section_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: CompletionDetector(void);
 */
    static int __idx_CompletionDetector_void;
    static int ckNew(void) { return __idx_CompletionDetector_void; }
    static void _call_CompletionDetector_void(void* impl_msg,CompletionDetector* impl_obj);

/* DECLS: void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_);
 */
    static int __idx_start_detection_marshall2;
    static int start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_) { return __idx_start_detection_marshall2; }
    static void _call_start_detection_marshall2(void* impl_msg,CompletionDetector* impl_obj);
    static int _callmarshall_start_detection_marshall2(char* impl_buf,CompletionDetector* impl_obj);
    static void _marshallmessagepup_start_detection_marshall2(PUP::er &p,void *msg);

/* DECLS: void producers_done(int producers_done_global_);
 */
    static int __idx_producers_done_marshall3;
    static int producers_done(int producers_done_global_) { return __idx_producers_done_marshall3; }
    static int __idx_producers_done_redn_wrapper;
    static int producers_done_redn_wrapper(CkReductionMsg* impl_msg) { return __idx_producers_done_redn_wrapper; }
    static void _producers_done_redn_wrapper(void* impl_msg, CompletionDetector* impl_obj);
    static void _call_producers_done_marshall3(void* impl_msg,CompletionDetector* impl_obj);
    static int _callmarshall_producers_done_marshall3(char* impl_buf,CompletionDetector* impl_obj);
    static void _marshallmessagepup_producers_done_marshall3(PUP::er &p,void *msg);

/* DECLS: void count_consumed(int produced_global, int consumed_global);
 */
    static int __idx_count_consumed_marshall4;
    static int count_consumed(int produced_global, int consumed_global) { return __idx_count_consumed_marshall4; }
    static int __idx_count_consumed_redn_wrapper;
    static int count_consumed_redn_wrapper(CkReductionMsg* impl_msg) { return __idx_count_consumed_redn_wrapper; }
    static void _count_consumed_redn_wrapper(void* impl_msg, CompletionDetector* impl_obj);
    static void _call_count_consumed_marshall4(void* impl_msg,CompletionDetector* impl_obj);
    static int _callmarshall_count_consumed_marshall4(char* impl_buf,CompletionDetector* impl_obj);
    static void _marshallmessagepup_count_consumed_marshall4(PUP::er &p,void *msg);

};
/* --------------- element proxy ------------------ */
class CProxyElement_CompletionDetector: public CProxyElement_IrrGroup{
  public:
    typedef CompletionDetector local_t;
    typedef CkIndex_CompletionDetector index_t;
    typedef CProxy_CompletionDetector proxy_t;
    typedef CProxyElement_CompletionDetector element_t;
    typedef CProxySection_CompletionDetector section_t;

    CProxyElement_CompletionDetector(void) {}
    CProxyElement_CompletionDetector(const IrrGroup *g) : CProxyElement_IrrGroup(g){  }
    CProxyElement_CompletionDetector(CkGroupID _gid,int _onPE,CK_DELCTOR_PARAM) : CProxyElement_IrrGroup(_gid,_onPE,CK_DELCTOR_ARGS){  }
    CProxyElement_CompletionDetector(CkGroupID _gid,int _onPE) : CProxyElement_IrrGroup(_gid,_onPE){  }
int ckIsDelegated(void) const {return CProxyElement_IrrGroup::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxyElement_IrrGroup::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxyElement_IrrGroup::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxyElement_IrrGroup::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxyElement_IrrGroup::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxyElement_IrrGroup::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxyElement_IrrGroup::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_IrrGroup::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxyElement_IrrGroup::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxyElement_IrrGroup::ckSetReductionClient(cb); }
int ckGetGroupPe(void) const
{return CProxyElement_IrrGroup::ckGetGroupPe();}
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_IrrGroup::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_IrrGroup::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_IrrGroup::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxyElement_IrrGroup::ckSetGroupID(g);
    }
    CompletionDetector* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static CompletionDetector* ckLocalBranch(CkGroupID gID) {
      return (CompletionDetector*)CkLocalBranch(gID);
    }
/* DECLS: CompletionDetector(void);
 */

/* DECLS: void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_);
 */
    void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void producers_done(int producers_done_global_);
 */
    void producers_done(int producers_done_global_, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void count_consumed(int produced_global, int consumed_global);
 */
    void count_consumed(int produced_global, int consumed_global, const CkEntryOptions *impl_e_opts=NULL);

};
PUPmarshall(CProxyElement_CompletionDetector)
/* ---------------- collective proxy -------------- */
class CProxy_CompletionDetector: public CProxy_IrrGroup{
  public:
    typedef CompletionDetector local_t;
    typedef CkIndex_CompletionDetector index_t;
    typedef CProxy_CompletionDetector proxy_t;
    typedef CProxyElement_CompletionDetector element_t;
    typedef CProxySection_CompletionDetector section_t;

    CProxy_CompletionDetector(void) {}
    CProxy_CompletionDetector(const IrrGroup *g) : CProxy_IrrGroup(g){  }
    CProxy_CompletionDetector(CkGroupID _gid,CK_DELCTOR_PARAM) : CProxy_IrrGroup(_gid,CK_DELCTOR_ARGS){  }
    CProxy_CompletionDetector(CkGroupID _gid) : CProxy_IrrGroup(_gid){  }
    CProxyElement_CompletionDetector operator[](int onPE) const
      {return CProxyElement_CompletionDetector(ckGetGroupID(),onPE,CK_DELCTOR_CALL);}
int ckIsDelegated(void) const {return CProxy_IrrGroup::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxy_IrrGroup::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxy_IrrGroup::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxy_IrrGroup::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxy_IrrGroup::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxy_IrrGroup::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxy_IrrGroup::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_IrrGroup::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxy_IrrGroup::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxy_IrrGroup::ckSetReductionClient(cb); }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_IrrGroup::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_IrrGroup::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_IrrGroup::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxy_IrrGroup::ckSetGroupID(g);
    }
    CompletionDetector* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static CompletionDetector* ckLocalBranch(CkGroupID gID) {
      return (CompletionDetector*)CkLocalBranch(gID);
    }
/* DECLS: CompletionDetector(void);
 */
    static CkGroupID ckNew(void);

/* DECLS: void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_);
 */
    void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_, const CkEntryOptions *impl_e_opts=NULL);
    void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void producers_done(int producers_done_global_);
 */
    void producers_done(int producers_done_global_, const CkEntryOptions *impl_e_opts=NULL);
    void producers_done(int producers_done_global_, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void producers_done(int producers_done_global_, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void count_consumed(int produced_global, int consumed_global);
 */
    void count_consumed(int produced_global, int consumed_global, const CkEntryOptions *impl_e_opts=NULL);
    void count_consumed(int produced_global, int consumed_global, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL);
    void count_consumed(int produced_global, int consumed_global, CmiGroup &grp, const CkEntryOptions *impl_e_opts=NULL);

};
PUPmarshall(CProxy_CompletionDetector)
/* ---------------- section proxy -------------- */
class CProxySection_CompletionDetector: public CProxySection_IrrGroup{
  public:
    typedef CompletionDetector local_t;
    typedef CkIndex_CompletionDetector index_t;
    typedef CProxy_CompletionDetector proxy_t;
    typedef CProxyElement_CompletionDetector element_t;
    typedef CProxySection_CompletionDetector section_t;

    CProxySection_CompletionDetector(void) {}
    CProxySection_CompletionDetector(const IrrGroup *g) : CProxySection_IrrGroup(g){  }
    CProxySection_CompletionDetector(const CkGroupID &_gid,const int *_pelist,int _npes,CK_DELCTOR_PARAM) : CProxySection_IrrGroup(_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
    CProxySection_CompletionDetector(const CkGroupID &_gid,const int *_pelist,int _npes) : CProxySection_IrrGroup(_gid,_pelist,_npes){  }
    CProxySection_CompletionDetector(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes) : CProxySection_IrrGroup(n,_gid,_pelist,_npes){  }
    CProxySection_CompletionDetector(int n,const CkGroupID *_gid, int const * const *_pelist,const int *_npes,CK_DELCTOR_PARAM) : CProxySection_IrrGroup(n,_gid,_pelist,_npes,CK_DELCTOR_ARGS){  }
int ckIsDelegated(void) const {return CProxySection_IrrGroup::ckIsDelegated();}
inline CkDelegateMgr *ckDelegatedTo(void) const {return CProxySection_IrrGroup::ckDelegatedTo();}
inline CkDelegateData *ckDelegatedPtr(void) const {return CProxySection_IrrGroup::ckDelegatedPtr();}
CkGroupID ckDelegatedIdx(void) const {return CProxySection_IrrGroup::ckDelegatedIdx();}
inline void ckCheck(void) const {CProxySection_IrrGroup::ckCheck();}
CkChareID ckGetChareID(void) const
   {return CProxySection_IrrGroup::ckGetChareID();}
CkGroupID ckGetGroupID(void) const
   {return CProxySection_IrrGroup::ckGetGroupID();}
operator CkGroupID () const { return ckGetGroupID(); }
inline void setReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_IrrGroup::setReductionClient(fn,param); }
inline void ckSetReductionClient(CkReductionClientFn fn,void *param=NULL) const
{ CProxySection_IrrGroup::ckSetReductionClient(fn,param); }
inline void ckSetReductionClient(CkCallback *cb) const
{ CProxySection_IrrGroup::ckSetReductionClient(cb); }
inline int ckGetNumSections() const
{ return CProxySection_IrrGroup::ckGetNumSections(); }
inline CkSectionInfo &ckGetSectionInfo()
{ return CProxySection_IrrGroup::ckGetSectionInfo(); }
inline CkSectionID *ckGetSectionIDs()
{ return CProxySection_IrrGroup::ckGetSectionIDs(); }
inline CkSectionID &ckGetSectionID()
{ return CProxySection_IrrGroup::ckGetSectionID(); }
inline CkSectionID &ckGetSectionID(int i)
{ return CProxySection_IrrGroup::ckGetSectionID(i); }
inline CkGroupID ckGetGroupIDn(int i) const
{ return CProxySection_IrrGroup::ckGetGroupIDn(i); }
inline int *ckGetElements() const
{ return CProxySection_IrrGroup::ckGetElements(); }
inline int *ckGetElements(int i) const
{ return CProxySection_IrrGroup::ckGetElements(i); }
inline int ckGetNumElements() const
{ return CProxySection_IrrGroup::ckGetNumElements(); } 
inline int ckGetNumElements(int i) const
{ return CProxySection_IrrGroup::ckGetNumElements(i); }
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxySection_IrrGroup::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxySection_IrrGroup::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxySection_IrrGroup::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxySection_IrrGroup::ckSetGroupID(g);
    }
    CompletionDetector* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static CompletionDetector* ckLocalBranch(CkGroupID gID) {
      return (CompletionDetector*)CkLocalBranch(gID);
    }
/* DECLS: CompletionDetector(void);
 */

/* DECLS: void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_);
 */
    void start_detection(int num_producers, const CkCallback &start, const CkCallback &finish, int prio_, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void producers_done(int producers_done_global_);
 */
    void producers_done(int producers_done_global_, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void count_consumed(int produced_global, int consumed_global);
 */
    void count_consumed(int produced_global, int consumed_global, const CkEntryOptions *impl_e_opts=NULL);

};
PUPmarshall(CProxySection_CompletionDetector)
#define CompletionDetector_SDAG_CODE                                           \
public:                                                                        \
  void start_detection(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    _slist_0(num_producers, start, finish, prio_);                             \
    _TRACE_BEGIN_EXECUTE_DETAILED(-1, -1, _dummyEP, CkMyPe(), 0, NULL);        \
  }                                                                            \
                                                                               \
private:                                                                       \
  void start_detection_end(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
  }                                                                            \
                                                                               \
  void _slist_0(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    _atomic_0(num_producers, start, finish, prio_);                            \
  }                                                                            \
  void _slist_0_end(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    start_detection_end(num_producers, start, finish, prio_);                  \
  }                                                                            \
  void _atomic_0(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    _TRACE_BEGIN_EXECUTE_DETAILED(-1, -1, __idx_CompletionDetector_atomic_0, CkMyPe(), 0, NULL); \
                                                                               \
        CkAssert(!running);                                                    \
        running = true;                                                        \
        prio = prio_;                                                          \
        producers_total = num_producers;                                       \
        cb = finish;                                                           \
        if (!start.isInvalid())                                                \
         contribute(start);                                                    \
                                                                               \
    _TRACE_END_EXECUTE();                                                      \
    _while_0(num_producers, start, finish, prio_);                             \
  }                                                                            \
                                                                               \
  void _while_0(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    if (producers_done_global < producers_total) {                             \
      _slist_1(num_producers, start, finish, prio_);                           \
    } else {                                                                   \
      _while_1(num_producers, start, finish, prio_);                           \
    }                                                                          \
  }                                                                            \
                                                                               \
  void _while_0_end(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    if (producers_done_global < producers_total) {                             \
      _slist_1(num_producers, start, finish, prio_);                           \
    } else {                                                                   \
      _while_1(num_producers, start, finish, prio_);                           \
    }                                                                          \
  }                                                                            \
                                                                               \
  void _slist_1(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    _atomic_1(num_producers, start, finish, prio_);                            \
  }                                                                            \
  void _slist_1_end(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    _while_0_end(num_producers, start, finish, prio_);                         \
  }                                                                            \
  void _atomic_1(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    _TRACE_BEGIN_EXECUTE_DETAILED(-1, -1, __idx_CompletionDetector_atomic_1, CkMyPe(), 0, NULL); \
                                                                               \
      contribute(sizeof(int), &producers_done_local, CkReduction::sum_int,     \
               CkCallback(CkReductionTarget(CompletionDetector, producers_done),\
        thisgroup));                                                           \
                                                                               \
    _TRACE_END_EXECUTE();                                                      \
    _when_0(num_producers, start, finish, prio_);                              \
  }                                                                            \
                                                                               \
  int _when_0(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    CMsgBuffer *producers_done_buf;                                            \
    CkMarshallMsg *producers_done_msg;                                         \
                                                                               \
    producers_done_buf = __cDep->getMessage(0);                                \
                                                                               \
    if ((producers_done_buf != 0)) {                                           \
       producers_done_msg = (CkMarshallMsg *)producers_done_buf->msg;          \
       char *producers_done_impl_buf=((CkMarshallMsg *)producers_done_msg)->msgBuf;\
       PUP::fromMem producers_done_implP(producers_done_impl_buf);             \
       int producers_done_global_; producers_done_implP|producers_done_global_;\
       producers_done_impl_buf+=CK_ALIGN(producers_done_implP.size(),16);      \
       __cDep->removeMessage(producers_done_buf);                              \
       delete producers_done_buf;                                              \
       _atomic_2(num_producers, start, finish, prio_, producers_done_global_); \
       delete producers_done_msg;                                              \
       return 1;                                                               \
    } else {                                                                   \
       CWhenTrigger *tr;                                                       \
       tr = new CWhenTrigger(0, 4, 0, 1);                                      \
       int impl_off=0;                                                         \
       {                                                                       \
         PUP::sizer implP;                                                     \
         implP|num_producers;                                                  \
         implP|start;                                                          \
         implP|finish;                                                         \
         implP|prio_;                                                          \
         impl_off+=implP.size();                                               \
       }                                                                       \
       CkMarshallMsg *impl_msg;                                                \
       impl_msg = CkAllocateMarshallMsg(impl_off,NULL);                        \
       {                                                                       \
         PUP::toMem implP((void *)impl_msg->msgBuf);                           \
         implP|num_producers;                                                  \
         implP|start;                                                          \
         implP|finish;                                                         \
         implP|prio_;                                                          \
       }                                                                       \
       tr->args[0] = (size_t) impl_msg;                                        \
       tr->anyEntries[0] = 0;                                                  \
       __cDep->Register(tr);                                                   \
       return 0;                                                               \
    }                                                                          \
  }                                                                            \
                                                                               \
  void _when_0_end(int num_producers, CkCallback start, CkCallback finish, int prio_, int producers_done_global_) {\
    _slist_1_end(num_producers, start, finish, prio_);                         \
  }                                                                            \
                                                                               \
  void _atomic_2(int num_producers, CkCallback start, CkCallback finish, int prio_, int producers_done_global_) {\
    _TRACE_BEGIN_EXECUTE_DETAILED(-1, -1, __idx_CompletionDetector_atomic_2, CkMyPe(), 0, NULL); \
                                                                               \
          producers_done_global = producers_done_global_;                      \
                                                                               \
    _TRACE_END_EXECUTE();                                                      \
    _when_0_end(num_producers, start, finish, prio_, producers_done_global_);  \
  }                                                                            \
                                                                               \
  void _while_1(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    if (unconsumed > 0) {                                                      \
      _slist_2(num_producers, start, finish, prio_);                           \
    } else {                                                                   \
      _atomic_5(num_producers, start, finish, prio_);                          \
    }                                                                          \
  }                                                                            \
                                                                               \
  void _while_1_end(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    if (unconsumed > 0) {                                                      \
      _slist_2(num_producers, start, finish, prio_);                           \
    } else {                                                                   \
      _atomic_5(num_producers, start, finish, prio_);                          \
    }                                                                          \
  }                                                                            \
                                                                               \
  void _slist_2(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    _atomic_3(num_producers, start, finish, prio_);                            \
  }                                                                            \
  void _slist_2_end(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    _while_1_end(num_producers, start, finish, prio_);                         \
  }                                                                            \
  void _atomic_3(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    _TRACE_BEGIN_EXECUTE_DETAILED(-1, -1, __idx_CompletionDetector_atomic_3, CkMyPe(), 0, NULL); \
                                                                               \
          int counts[2];                                                       \
          counts[0] = produced;                                                \
          counts[1] = consumed;                                                \
         contribute(2*sizeof(int), counts, CkReduction::sum_int,               \
               CkCallback(CkReductionTarget(CompletionDetector, count_consumed),\
        thisgroup));                                                           \
                                                                               \
    _TRACE_END_EXECUTE();                                                      \
    _when_1(num_producers, start, finish, prio_);                              \
  }                                                                            \
                                                                               \
  int _when_1(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    CMsgBuffer *count_consumed_buf;                                            \
    CkMarshallMsg *count_consumed_msg;                                         \
                                                                               \
    count_consumed_buf = __cDep->getMessage(1);                                \
                                                                               \
    if ((count_consumed_buf != 0)) {                                           \
       count_consumed_msg = (CkMarshallMsg *)count_consumed_buf->msg;          \
       char *count_consumed_impl_buf=((CkMarshallMsg *)count_consumed_msg)->msgBuf;\
       PUP::fromMem count_consumed_implP(count_consumed_impl_buf);             \
       int produced_global; count_consumed_implP|produced_global;              \
       int consumed_global; count_consumed_implP|consumed_global;              \
       count_consumed_impl_buf+=CK_ALIGN(count_consumed_implP.size(),16);      \
       __cDep->removeMessage(count_consumed_buf);                              \
       delete count_consumed_buf;                                              \
       _atomic_4(num_producers, start, finish, prio_, produced_global, consumed_global);\
       delete count_consumed_msg;                                              \
       return 1;                                                               \
    } else {                                                                   \
       CWhenTrigger *tr;                                                       \
       tr = new CWhenTrigger(1, 4, 0, 1);                                      \
       int impl_off=0;                                                         \
       {                                                                       \
         PUP::sizer implP;                                                     \
         implP|num_producers;                                                  \
         implP|start;                                                          \
         implP|finish;                                                         \
         implP|prio_;                                                          \
         impl_off+=implP.size();                                               \
       }                                                                       \
       CkMarshallMsg *impl_msg;                                                \
       impl_msg = CkAllocateMarshallMsg(impl_off,NULL);                        \
       {                                                                       \
         PUP::toMem implP((void *)impl_msg->msgBuf);                           \
         implP|num_producers;                                                  \
         implP|start;                                                          \
         implP|finish;                                                         \
         implP|prio_;                                                          \
       }                                                                       \
       tr->args[0] = (size_t) impl_msg;                                        \
       tr->anyEntries[0] = 1;                                                  \
       __cDep->Register(tr);                                                   \
       return 0;                                                               \
    }                                                                          \
  }                                                                            \
                                                                               \
  void _when_1_end(int num_producers, CkCallback start, CkCallback finish, int prio_, int produced_global, int consumed_global) {\
    _slist_2_end(num_producers, start, finish, prio_);                         \
  }                                                                            \
                                                                               \
  void _atomic_4(int num_producers, CkCallback start, CkCallback finish, int prio_, int produced_global, int consumed_global) {\
    _TRACE_BEGIN_EXECUTE_DETAILED(-1, -1, __idx_CompletionDetector_atomic_4, CkMyPe(), 0, NULL); \
                                                                               \
         unconsumed = produced_global - consumed_global;                       \
                                                                               \
    _TRACE_END_EXECUTE();                                                      \
    _when_1_end(num_producers, start, finish, prio_, produced_global, consumed_global);\
  }                                                                            \
                                                                               \
  void _atomic_5(int num_producers, CkCallback start, CkCallback finish, int prio_) {\
    _TRACE_BEGIN_EXECUTE_DETAILED(-1, -1, __idx_CompletionDetector_completion_finished, CkMyPe(), 0, NULL); \
                                                                               \
  init();                                                                      \
  CkAssert(!cb.isInvalid());                                                   \
        contribute(cb);                                                        \
        cb = CkCallback();                                                     \
                                                                               \
    _TRACE_END_EXECUTE();                                                      \
    _slist_0_end(num_producers, start, finish, prio_);                         \
  }                                                                            \
                                                                               \
public:                                                                        \
  void producers_done(int producers_done_global_) {                            \
    CWhenTrigger *tr;                                                          \
    void* _bgParentLog = NULL;                                                 \
    CMsgBuffer* cmsgbuf;                                                       \
    int impl_off=0; int impl_arrstart=0;                                       \
    {                                                                          \
      PUP::sizer implP1;                                                       \
      implP1|producers_done_global_;                                           \
      impl_off+=implP1.size();                                                 \
    }                                                                          \
    CkMarshallMsg *impl_msg1=CkAllocateMarshallMsg(impl_off,NULL);             \
    {                                                                          \
      PUP::toMem implP1((void *)impl_msg1->msgBuf);                            \
      implP1|producers_done_global_;                                           \
    }                                                                          \
    cmsgbuf = __cDep->bufferMessage(0, (void *) impl_msg1, (void*) _bgParentLog, 0);\
    tr = __cDep->getTrigger(0, 0);                                             \
    if (tr == 0)                                                               \
      return;                                                                  \
    _TRACE_END_EXECUTE();                                                      \
    CkMarshallMsg *impl_msg = (CkMarshallMsg *) tr->args[0];                   \
    char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;                        \
    PUP::fromMem implP(impl_buf);                                              \
    int num_producers; implP|num_producers;                                    \
    CkCallback start; implP|start;                                             \
    CkCallback finish; implP|finish;                                           \
    int prio_; implP|prio_;                                                    \
     impl_buf+=CK_ALIGN(implP.size(),16);                                      \
    delete (CkMarshallMsg *)impl_msg;                                          \
    _when_0(num_producers, start, finish, prio_);                              \
    delete tr;                                                                 \
    _TRACE_BEGIN_EXECUTE_DETAILED(-1, -1, _dummyEP, CkMyPe(), 0, NULL);        \
    return;                                                                    \
  }                                                                            \
                                                                               \
  void count_consumed(int produced_global, int consumed_global) {              \
    CWhenTrigger *tr;                                                          \
    void* _bgParentLog = NULL;                                                 \
    CMsgBuffer* cmsgbuf;                                                       \
    int impl_off=0; int impl_arrstart=0;                                       \
    {                                                                          \
      PUP::sizer implP1;                                                       \
      implP1|produced_global;                                                  \
      implP1|consumed_global;                                                  \
      impl_off+=implP1.size();                                                 \
    }                                                                          \
    CkMarshallMsg *impl_msg1=CkAllocateMarshallMsg(impl_off,NULL);             \
    {                                                                          \
      PUP::toMem implP1((void *)impl_msg1->msgBuf);                            \
      implP1|produced_global;                                                  \
      implP1|consumed_global;                                                  \
    }                                                                          \
    cmsgbuf = __cDep->bufferMessage(1, (void *) impl_msg1, (void*) _bgParentLog, 0);\
    tr = __cDep->getTrigger(1, 0);                                             \
    if (tr == 0)                                                               \
      return;                                                                  \
    _TRACE_END_EXECUTE();                                                      \
    CkMarshallMsg *impl_msg = (CkMarshallMsg *) tr->args[0];                   \
    char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;                        \
    PUP::fromMem implP(impl_buf);                                              \
    int num_producers; implP|num_producers;                                    \
    CkCallback start; implP|start;                                             \
    CkCallback finish; implP|finish;                                           \
    int prio_; implP|prio_;                                                    \
     impl_buf+=CK_ALIGN(implP.size(),16);                                      \
    delete (CkMarshallMsg *)impl_msg;                                          \
    _when_1(num_producers, start, finish, prio_);                              \
    delete tr;                                                                 \
    _TRACE_BEGIN_EXECUTE_DETAILED(-1, -1, _dummyEP, CkMyPe(), 0, NULL);        \
    return;                                                                    \
  }                                                                            \
                                                                               \
private:                                                                       \
  CDep *__cDep;                                                                \
  void __sdag_init(void) {                                                     \
    __cDep = new CDep(2,2);                                                    \
    __cDep->addDepends(0,0);                                                   \
    __cDep->addDepends(1,1);                                                   \
  }                                                                            \
public:                                                                        \
  void __sdag_pup(PUP::er& p) {                                                \
    if (__cDep) { __cDep->pup(p); }                                            \
  }                                                                            \
  static void __sdag_register() {                                              \
                                                                               \
    __idx_CompletionDetector_atomic_0 = CkRegisterEp("CompletionDetector_atomic_0(void)", NULL, 0, CkIndex_CompletionDetector::__idx, 0);\
    __idx_CompletionDetector_atomic_1 = CkRegisterEp("CompletionDetector_atomic_1(void)", NULL, 0, CkIndex_CompletionDetector::__idx, 0);\
    __idx_CompletionDetector_atomic_2 = CkRegisterEp("CompletionDetector_atomic_2(void)", NULL, 0, CkIndex_CompletionDetector::__idx, 0);\
    __idx_CompletionDetector_atomic_3 = CkRegisterEp("CompletionDetector_atomic_3(void)", NULL, 0, CkIndex_CompletionDetector::__idx, 0);\
    __idx_CompletionDetector_atomic_4 = CkRegisterEp("CompletionDetector_atomic_4(void)", NULL, 0, CkIndex_CompletionDetector::__idx, 0);\
    __idx_CompletionDetector_completion_finished = CkRegisterEp("CompletionDetector_completion_finished(void)", NULL, 0, CkIndex_CompletionDetector::__idx, 0);\
  }                                                                            \
  static int __idx_CompletionDetector_atomic_0;                                \
  static int __idx_CompletionDetector_atomic_1;                                \
  static int __idx_CompletionDetector_atomic_2;                                \
  static int __idx_CompletionDetector_atomic_3;                                \
  static int __idx_CompletionDetector_atomic_4;                                \
  static int __idx_CompletionDetector_completion_finished;                     \

#define CompletionDetector_SDAG_CODE_DEF \
  int CompletionDetector::__idx_CompletionDetector_atomic_0=0;\
  int CompletionDetector::__idx_CompletionDetector_atomic_1=0;\
  int CompletionDetector::__idx_CompletionDetector_atomic_2=0;\
  int CompletionDetector::__idx_CompletionDetector_atomic_3=0;\
  int CompletionDetector::__idx_CompletionDetector_atomic_4=0;\
  int CompletionDetector::__idx_CompletionDetector_completion_finished=0;\

typedef CBaseT1<Group, CProxy_CompletionDetector> CBase_CompletionDetector;

extern void _registercompletion(void);
#endif
