/* DEFS: message CkCacheRequestMsg;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_CkCacheRequestMsg::operator new(size_t s){
  return CkCacheRequestMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_CkCacheRequestMsg::operator new(size_t s, int* sz){
  return CkCacheRequestMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_CkCacheRequestMsg::operator new(size_t s, int* sz,const int pb){
  return CkCacheRequestMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_CkCacheRequestMsg::operator new(size_t s, const int p) {
  return CkCacheRequestMsg::alloc(__idx, s, 0, p);
}
void* CMessage_CkCacheRequestMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  CkpvAccess(_offsets)[0] = ALIGN8(sz);
  return CkAllocMsg(msgnum, CkpvAccess(_offsets)[0], pb);
}
CMessage_CkCacheRequestMsg::CMessage_CkCacheRequestMsg() {
CkCacheRequestMsg *newmsg = (CkCacheRequestMsg *)this;
}
void CMessage_CkCacheRequestMsg::dealloc(void *p) {
  CkFreeMsg(p);
}
void* CMessage_CkCacheRequestMsg::pack(CkCacheRequestMsg *msg) {
  return (void *) msg;
}
CkCacheRequestMsg* CMessage_CkCacheRequestMsg::unpack(void* buf) {
  CkCacheRequestMsg *msg = (CkCacheRequestMsg *) buf;
  return msg;
}
int CMessage_CkCacheRequestMsg::__idx=0;
#endif

/* DEFS: message CkCacheFillMsg{
char data[];
}
;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_CkCacheFillMsg::operator new(size_t s){
  return CkCacheFillMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_CkCacheFillMsg::operator new(size_t s, int* sz){
  return CkCacheFillMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_CkCacheFillMsg::operator new(size_t s, int* sz,const int pb){
  return CkCacheFillMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_CkCacheFillMsg::operator new(size_t s, int sz0) {
  int sizes[1];
  sizes[0] = sz0;
  return CkCacheFillMsg::alloc(__idx, s, sizes, 0);
}
void *CMessage_CkCacheFillMsg::operator new(size_t s, int sz0, const int p) {
  int sizes[1];
  sizes[0] = sz0;
  return CkCacheFillMsg::alloc(__idx, s, sizes, p);
}
void* CMessage_CkCacheFillMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  CkpvAccess(_offsets)[0] = ALIGN8(sz);
  if(sizes==0)
    CkpvAccess(_offsets)[1] = CkpvAccess(_offsets)[0];
  else
    CkpvAccess(_offsets)[1] = CkpvAccess(_offsets)[0] + ALIGN8(sizeof(char)*sizes[0]);
  return CkAllocMsg(msgnum, CkpvAccess(_offsets)[1], pb);
}
CMessage_CkCacheFillMsg::CMessage_CkCacheFillMsg() {
CkCacheFillMsg *newmsg = (CkCacheFillMsg *)this;
  newmsg->data = (char *) ((char *)newmsg + CkpvAccess(_offsets)[0]);
}
void CMessage_CkCacheFillMsg::dealloc(void *p) {
  CkFreeMsg(p);
}
void* CMessage_CkCacheFillMsg::pack(CkCacheFillMsg *msg) {
  msg->data = (char *) ((char *)msg->data - (char *)msg);
  return (void *) msg;
}
CkCacheFillMsg* CMessage_CkCacheFillMsg::unpack(void* buf) {
  CkCacheFillMsg *msg = (CkCacheFillMsg *) buf;
  msg->data = (char *) ((size_t)msg->data + (char *)msg);
  return msg;
}
int CMessage_CkCacheFillMsg::__idx=0;
#endif

/* DEFS: group CkCacheManager: IrrGroup{
CkCacheManager(CkMigrateMessage* impl_msg);
CkCacheManager(int size, const CkGroupID &gid);
CkCacheManager(int size, int n, const CkGroupID *gid);
CkCacheManager(int size, int n, const CkGroupID *gid, int nWB, const CkGroupID *gidWB);
void* requestData(const CkCacheKey &what, const CkArrayIndexMax &toWhom, int chunk, CkCacheEntryType* impl_msg, const CkCacheRequestorData &req);
void* requestDataNoFetch(const CkCacheKey &key, int chunk);
void cacheSync(const int &numChunks, const CkArrayIndexMax &chareIdx, const int &localIdx);
void recvData(CkCacheFillMsg* impl_msg);
void recvData(const CkCacheKey &key, const CkArrayIndexMax &from, CkCacheEntryType* impl_msg, int chunk, void* data);
void writebackChunk(int num);
void finishedChunk(int num, const CmiUInt8 &weight);
void collectStatistics(const CkCallback &cb);
std::map<CkCacheKey,CkCacheEntry* >* getCache(void);
CkCacheEntry* requestCacheEntryNoFetch(const CkCacheKey &key, int chunk);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_CkCacheManager::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: CkCacheManager(CkMigrateMessage* impl_msg);
 */

/* DEFS: CkCacheManager(int size, const CkGroupID &gid);
 */

/* DEFS: CkCacheManager(int size, int n, const CkGroupID *gid);
 */

/* DEFS: CkCacheManager(int size, int n, const CkGroupID *gid, int nWB, const CkGroupID *gidWB);
 */

/* DEFS: void* requestData(const CkCacheKey &what, const CkArrayIndexMax &toWhom, int chunk, CkCacheEntryType* impl_msg, const CkCacheRequestorData &req);
 */
void* CProxyElement_CkCacheManager::requestData(CkCacheKey &what, CkArrayIndexMax &toWhom, int chunk, CkCacheEntryType* impl_msg, CkCacheRequestorData &req, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  CkCacheManager *obj = ckLocalBranch();
  CkAssert(obj);
  _TRACE_BEGIN_EXECUTE_DETAILED(0,ForBocMsg,CkIndex_CkCacheManager::__idx_requestData_marshall4,CkMyPe(),0,NULL);
#if CMK_LBDB_ON
  // if there is a running obj being measured, stop it temporarily
  LDObjHandle objHandle;
  int objstopped = 0;
  LBDatabase *the_lbdb = (LBDatabase *)CkLocalBranch(_lbdb);
  if (the_lbdb->RunningObject(&objHandle)) {
    objstopped = 1;
    the_lbdb->ObjectStop(objHandle);
  }
#endif
#if CMK_CHARMDEBUG
  CpdBeforeEp(CkIndex_CkCacheManager::__idx_requestData_marshall4, obj, NULL);
#endif
  void* retValue = obj->requestData(what, toWhom, chunk, impl_msg, req);
#if CMK_CHARMDEBUG
  CpdAfterEp(CkIndex_CkCacheManager::__idx_requestData_marshall4);
#endif
#if CMK_LBDB_ON
  if (objstopped) the_lbdb->ObjectStart(objHandle);
#endif
  _TRACE_END_EXECUTE();
  return retValue;
}

/* DEFS: void* requestDataNoFetch(const CkCacheKey &key, int chunk);
 */
void* CProxyElement_CkCacheManager::requestDataNoFetch(CkCacheKey &key, int chunk, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  CkCacheManager *obj = ckLocalBranch();
  CkAssert(obj);
  _TRACE_BEGIN_EXECUTE_DETAILED(0,ForBocMsg,CkIndex_CkCacheManager::__idx_requestDataNoFetch_marshall5,CkMyPe(),0,NULL);
#if CMK_LBDB_ON
  // if there is a running obj being measured, stop it temporarily
  LDObjHandle objHandle;
  int objstopped = 0;
  LBDatabase *the_lbdb = (LBDatabase *)CkLocalBranch(_lbdb);
  if (the_lbdb->RunningObject(&objHandle)) {
    objstopped = 1;
    the_lbdb->ObjectStop(objHandle);
  }
#endif
#if CMK_CHARMDEBUG
  CpdBeforeEp(CkIndex_CkCacheManager::__idx_requestDataNoFetch_marshall5, obj, NULL);
#endif
  void* retValue = obj->requestDataNoFetch(key, chunk);
#if CMK_CHARMDEBUG
  CpdAfterEp(CkIndex_CkCacheManager::__idx_requestDataNoFetch_marshall5);
#endif
#if CMK_LBDB_ON
  if (objstopped) the_lbdb->ObjectStart(objHandle);
#endif
  _TRACE_END_EXECUTE();
  return retValue;
}

/* DEFS: void cacheSync(const int &numChunks, const CkArrayIndexMax &chareIdx, const int &localIdx);
 */
void CProxyElement_CkCacheManager::cacheSync(int &numChunks, CkArrayIndexMax &chareIdx, int &localIdx, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  CkCacheManager *obj = ckLocalBranch();
  CkAssert(obj);
  _TRACE_BEGIN_EXECUTE_DETAILED(0,ForBocMsg,CkIndex_CkCacheManager::__idx_cacheSync_marshall6,CkMyPe(),0,NULL);
#if CMK_LBDB_ON
  // if there is a running obj being measured, stop it temporarily
  LDObjHandle objHandle;
  int objstopped = 0;
  LBDatabase *the_lbdb = (LBDatabase *)CkLocalBranch(_lbdb);
  if (the_lbdb->RunningObject(&objHandle)) {
    objstopped = 1;
    the_lbdb->ObjectStop(objHandle);
  }
#endif
#if CMK_CHARMDEBUG
  CpdBeforeEp(CkIndex_CkCacheManager::__idx_cacheSync_marshall6, obj, NULL);
#endif
  obj->cacheSync(numChunks, chareIdx, localIdx);
#if CMK_CHARMDEBUG
  CpdAfterEp(CkIndex_CkCacheManager::__idx_cacheSync_marshall6);
#endif
#if CMK_LBDB_ON
  if (objstopped) the_lbdb->ObjectStart(objHandle);
#endif
  _TRACE_END_EXECUTE();
}

/* DEFS: void recvData(CkCacheFillMsg* impl_msg);
 */
void CProxyElement_CkCacheManager::recvData(CkCacheFillMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkCacheManager::__idx_recvData_CkCacheFillMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkCacheManager::__idx_recvData_CkCacheFillMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkCacheManager::__idx_recvData_CkCacheFillMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void recvData(const CkCacheKey &key, const CkArrayIndexMax &from, CkCacheEntryType* impl_msg, int chunk, void* data);
 */
void CProxyElement_CkCacheManager::recvData(CkCacheKey &key, CkArrayIndexMax &from, CkCacheEntryType* impl_msg, int chunk, void* data, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  CkCacheManager *obj = ckLocalBranch();
  CkAssert(obj);
  _TRACE_BEGIN_EXECUTE_DETAILED(0,ForBocMsg,CkIndex_CkCacheManager::__idx_recvData_marshall8,CkMyPe(),0,NULL);
#if CMK_LBDB_ON
  // if there is a running obj being measured, stop it temporarily
  LDObjHandle objHandle;
  int objstopped = 0;
  LBDatabase *the_lbdb = (LBDatabase *)CkLocalBranch(_lbdb);
  if (the_lbdb->RunningObject(&objHandle)) {
    objstopped = 1;
    the_lbdb->ObjectStop(objHandle);
  }
#endif
#if CMK_CHARMDEBUG
  CpdBeforeEp(CkIndex_CkCacheManager::__idx_recvData_marshall8, obj, NULL);
#endif
  obj->recvData(key, from, impl_msg, chunk, data);
#if CMK_CHARMDEBUG
  CpdAfterEp(CkIndex_CkCacheManager::__idx_recvData_marshall8);
#endif
#if CMK_LBDB_ON
  if (objstopped) the_lbdb->ObjectStart(objHandle);
#endif
  _TRACE_END_EXECUTE();
}

/* DEFS: void writebackChunk(int num);
 */
void CProxyElement_CkCacheManager::writebackChunk(int num, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int num
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkCacheManager::__idx_writebackChunk_marshall9, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkCacheManager::__idx_writebackChunk_marshall9, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkCacheManager::__idx_writebackChunk_marshall9, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void finishedChunk(int num, const CmiUInt8 &weight);
 */
void CProxyElement_CkCacheManager::finishedChunk(int num, const CmiUInt8 &weight, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int num, const CmiUInt8 &weight
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num;
    //Have to cast away const-ness to get pup routine
    implP|(CmiUInt8 &)weight;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num;
    //Have to cast away const-ness to get pup routine
    implP|(CmiUInt8 &)weight;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkCacheManager::__idx_finishedChunk_marshall10, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkCacheManager::__idx_finishedChunk_marshall10, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkCacheManager::__idx_finishedChunk_marshall10, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void collectStatistics(const CkCallback &cb);
 */
void CProxyElement_CkCacheManager::collectStatistics(const CkCallback &cb, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkCallback &cb
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)cb;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)cb;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkCacheManager::__idx_collectStatistics_marshall11, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkCacheManager::__idx_collectStatistics_marshall11, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkCacheManager::__idx_collectStatistics_marshall11, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: std::map<CkCacheKey,CkCacheEntry* >* getCache(void);
 */
std::map<CkCacheKey,CkCacheEntry* >* CProxyElement_CkCacheManager::getCache(void)
{
  ckCheck();
  CkCacheManager *obj = ckLocalBranch();
  CkAssert(obj);
  _TRACE_BEGIN_EXECUTE_DETAILED(0,ForBocMsg,CkIndex_CkCacheManager::__idx_getCache_void,CkMyPe(),0,NULL);
#if CMK_LBDB_ON
  // if there is a running obj being measured, stop it temporarily
  LDObjHandle objHandle;
  int objstopped = 0;
  LBDatabase *the_lbdb = (LBDatabase *)CkLocalBranch(_lbdb);
  if (the_lbdb->RunningObject(&objHandle)) {
    objstopped = 1;
    the_lbdb->ObjectStop(objHandle);
  }
#endif
#if CMK_CHARMDEBUG
  CpdBeforeEp(CkIndex_CkCacheManager::__idx_getCache_void, obj, NULL);
#endif
  std::map<CkCacheKey,CkCacheEntry* >* retValue = obj->getCache();
#if CMK_CHARMDEBUG
  CpdAfterEp(CkIndex_CkCacheManager::__idx_getCache_void);
#endif
#if CMK_LBDB_ON
  if (objstopped) the_lbdb->ObjectStart(objHandle);
#endif
  _TRACE_END_EXECUTE();
  return retValue;
}

/* DEFS: CkCacheEntry* requestCacheEntryNoFetch(const CkCacheKey &key, int chunk);
 */
CkCacheEntry* CProxyElement_CkCacheManager::requestCacheEntryNoFetch(CkCacheKey &key, int chunk, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  CkCacheManager *obj = ckLocalBranch();
  CkAssert(obj);
  _TRACE_BEGIN_EXECUTE_DETAILED(0,ForBocMsg,CkIndex_CkCacheManager::__idx_requestCacheEntryNoFetch_marshall13,CkMyPe(),0,NULL);
#if CMK_LBDB_ON
  // if there is a running obj being measured, stop it temporarily
  LDObjHandle objHandle;
  int objstopped = 0;
  LBDatabase *the_lbdb = (LBDatabase *)CkLocalBranch(_lbdb);
  if (the_lbdb->RunningObject(&objHandle)) {
    objstopped = 1;
    the_lbdb->ObjectStop(objHandle);
  }
#endif
#if CMK_CHARMDEBUG
  CpdBeforeEp(CkIndex_CkCacheManager::__idx_requestCacheEntryNoFetch_marshall13, obj, NULL);
#endif
  CkCacheEntry* retValue = obj->requestCacheEntryNoFetch(key, chunk);
#if CMK_CHARMDEBUG
  CpdAfterEp(CkIndex_CkCacheManager::__idx_requestCacheEntryNoFetch_marshall13);
#endif
#if CMK_LBDB_ON
  if (objstopped) the_lbdb->ObjectStart(objHandle);
#endif
  _TRACE_END_EXECUTE();
  return retValue;
}

/* DEFS: CkCacheManager(CkMigrateMessage* impl_msg);
 */
 int CkIndex_CkCacheManager::__idx_CkCacheManager_CkMigrateMessage=0;
void CkIndex_CkCacheManager::_call_CkCacheManager_CkMigrateMessage(void* impl_msg,CkCacheManager * impl_obj)
{
  new (impl_obj) CkCacheManager((CkMigrateMessage*)impl_msg);
}

/* DEFS: CkCacheManager(int size, const CkGroupID &gid);
 */
CkGroupID CProxy_CkCacheManager::ckNew(int size, const CkGroupID &gid, const CkEntryOptions *impl_e_opts)
{
  //Marshall: int size, const CkGroupID &gid
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|size;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)gid;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|size;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)gid;
  }
  return CkCreateGroup(CkIndex_CkCacheManager::__idx, CkIndex_CkCacheManager::__idx_CkCacheManager_marshall1, impl_msg);
}
  CProxy_CkCacheManager::CProxy_CkCacheManager(int size, const CkGroupID &gid, const CkEntryOptions *impl_e_opts)
{
  //Marshall: int size, const CkGroupID &gid
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|size;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)gid;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|size;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)gid;
  }
  ckSetGroupID(CkCreateGroup(CkIndex_CkCacheManager::__idx, CkIndex_CkCacheManager::__idx_CkCacheManager_marshall1, impl_msg));
}
 int CkIndex_CkCacheManager::__idx_CkCacheManager_marshall1=0;
void CkIndex_CkCacheManager::_call_CkCacheManager_marshall1(void* impl_msg,CkCacheManager * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int size, const CkGroupID &gid*/
  PUP::fromMem implP(impl_buf);
  int size; implP|size;
  CkGroupID gid; implP|gid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) CkCacheManager(size, gid);
}
int CkIndex_CkCacheManager::_callmarshall_CkCacheManager_marshall1(char* impl_buf,CkCacheManager * impl_obj) {
  /*Unmarshall pup'd fields: int size, const CkGroupID &gid*/
  PUP::fromMem implP(impl_buf);
  int size; implP|size;
  CkGroupID gid; implP|gid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) CkCacheManager(size, gid);
  return implP.size();
}
void CkIndex_CkCacheManager::_marshallmessagepup_CkCacheManager_marshall1(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int size, const CkGroupID &gid*/
  PUP::fromMem implP(impl_buf);
  int size; implP|size;
  CkGroupID gid; implP|gid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("size");
  implDestP|size;
  if (implDestP.hasComments()) implDestP.comment("gid");
  implDestP|gid;
}

/* DEFS: CkCacheManager(int size, int n, const CkGroupID *gid);
 */
CkGroupID CProxy_CkCacheManager::ckNew(int size, int n, const CkGroupID *gid, const CkEntryOptions *impl_e_opts)
{
  //Marshall: int size, int n, const CkGroupID *gid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_gid, impl_cnt_gid;
  impl_off_gid=impl_off=CK_ALIGN(impl_off,sizeof(CkGroupID));
  impl_off+=(impl_cnt_gid=sizeof(CkGroupID)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|size;
    implP|n;
    implP|impl_off_gid;
    implP|impl_cnt_gid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|size;
    implP|n;
    implP|impl_off_gid;
    implP|impl_cnt_gid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_gid,gid,impl_cnt_gid);
  return CkCreateGroup(CkIndex_CkCacheManager::__idx, CkIndex_CkCacheManager::__idx_CkCacheManager_marshall2, impl_msg);
}
  CProxy_CkCacheManager::CProxy_CkCacheManager(int size, int n, const CkGroupID *gid, const CkEntryOptions *impl_e_opts)
{
  //Marshall: int size, int n, const CkGroupID *gid
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_gid, impl_cnt_gid;
  impl_off_gid=impl_off=CK_ALIGN(impl_off,sizeof(CkGroupID));
  impl_off+=(impl_cnt_gid=sizeof(CkGroupID)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|size;
    implP|n;
    implP|impl_off_gid;
    implP|impl_cnt_gid;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|size;
    implP|n;
    implP|impl_off_gid;
    implP|impl_cnt_gid;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_gid,gid,impl_cnt_gid);
  ckSetGroupID(CkCreateGroup(CkIndex_CkCacheManager::__idx, CkIndex_CkCacheManager::__idx_CkCacheManager_marshall2, impl_msg));
}
 int CkIndex_CkCacheManager::__idx_CkCacheManager_marshall2=0;
void CkIndex_CkCacheManager::_call_CkCacheManager_marshall2(void* impl_msg,CkCacheManager * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int size, int n, const CkGroupID *gid*/
  PUP::fromMem implP(impl_buf);
  int size; implP|size;
  int n; implP|n;
  int impl_off_gid, impl_cnt_gid; 
  implP|impl_off_gid;
  implP|impl_cnt_gid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  CkGroupID *gid=(CkGroupID *)(impl_buf+impl_off_gid);
  new (impl_obj) CkCacheManager(size, n, gid);
}
int CkIndex_CkCacheManager::_callmarshall_CkCacheManager_marshall2(char* impl_buf,CkCacheManager * impl_obj) {
  /*Unmarshall pup'd fields: int size, int n, const CkGroupID *gid*/
  PUP::fromMem implP(impl_buf);
  int size; implP|size;
  int n; implP|n;
  int impl_off_gid, impl_cnt_gid; 
  implP|impl_off_gid;
  implP|impl_cnt_gid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  CkGroupID *gid=(CkGroupID *)(impl_buf+impl_off_gid);
  new (impl_obj) CkCacheManager(size, n, gid);
  return implP.size();
}
void CkIndex_CkCacheManager::_marshallmessagepup_CkCacheManager_marshall2(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int size, int n, const CkGroupID *gid*/
  PUP::fromMem implP(impl_buf);
  int size; implP|size;
  int n; implP|n;
  int impl_off_gid, impl_cnt_gid; 
  implP|impl_off_gid;
  implP|impl_cnt_gid;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  CkGroupID *gid=(CkGroupID *)(impl_buf+impl_off_gid);
  if (implDestP.hasComments()) implDestP.comment("size");
  implDestP|size;
  if (implDestP.hasComments()) implDestP.comment("n");
  implDestP|n;
  if (implDestP.hasComments()) implDestP.comment("gid");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*gid))<impl_cnt_gid;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|gid[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
}

/* DEFS: CkCacheManager(int size, int n, const CkGroupID *gid, int nWB, const CkGroupID *gidWB);
 */
CkGroupID CProxy_CkCacheManager::ckNew(int size, int n, const CkGroupID *gid, int nWB, const CkGroupID *gidWB, const CkEntryOptions *impl_e_opts)
{
  //Marshall: int size, int n, const CkGroupID *gid, int nWB, const CkGroupID *gidWB
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_gid, impl_cnt_gid;
  impl_off_gid=impl_off=CK_ALIGN(impl_off,sizeof(CkGroupID));
  impl_off+=(impl_cnt_gid=sizeof(CkGroupID)*(n));
  int impl_off_gidWB, impl_cnt_gidWB;
  impl_off_gidWB=impl_off=CK_ALIGN(impl_off,sizeof(CkGroupID));
  impl_off+=(impl_cnt_gidWB=sizeof(CkGroupID)*(nWB));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|size;
    implP|n;
    implP|impl_off_gid;
    implP|impl_cnt_gid;
    implP|nWB;
    implP|impl_off_gidWB;
    implP|impl_cnt_gidWB;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|size;
    implP|n;
    implP|impl_off_gid;
    implP|impl_cnt_gid;
    implP|nWB;
    implP|impl_off_gidWB;
    implP|impl_cnt_gidWB;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_gid,gid,impl_cnt_gid);
  memcpy(impl_buf+impl_off_gidWB,gidWB,impl_cnt_gidWB);
  return CkCreateGroup(CkIndex_CkCacheManager::__idx, CkIndex_CkCacheManager::__idx_CkCacheManager_marshall3, impl_msg);
}
  CProxy_CkCacheManager::CProxy_CkCacheManager(int size, int n, const CkGroupID *gid, int nWB, const CkGroupID *gidWB, const CkEntryOptions *impl_e_opts)
{
  //Marshall: int size, int n, const CkGroupID *gid, int nWB, const CkGroupID *gidWB
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_gid, impl_cnt_gid;
  impl_off_gid=impl_off=CK_ALIGN(impl_off,sizeof(CkGroupID));
  impl_off+=(impl_cnt_gid=sizeof(CkGroupID)*(n));
  int impl_off_gidWB, impl_cnt_gidWB;
  impl_off_gidWB=impl_off=CK_ALIGN(impl_off,sizeof(CkGroupID));
  impl_off+=(impl_cnt_gidWB=sizeof(CkGroupID)*(nWB));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|size;
    implP|n;
    implP|impl_off_gid;
    implP|impl_cnt_gid;
    implP|nWB;
    implP|impl_off_gidWB;
    implP|impl_cnt_gidWB;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|size;
    implP|n;
    implP|impl_off_gid;
    implP|impl_cnt_gid;
    implP|nWB;
    implP|impl_off_gidWB;
    implP|impl_cnt_gidWB;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_gid,gid,impl_cnt_gid);
  memcpy(impl_buf+impl_off_gidWB,gidWB,impl_cnt_gidWB);
  ckSetGroupID(CkCreateGroup(CkIndex_CkCacheManager::__idx, CkIndex_CkCacheManager::__idx_CkCacheManager_marshall3, impl_msg));
}
 int CkIndex_CkCacheManager::__idx_CkCacheManager_marshall3=0;
void CkIndex_CkCacheManager::_call_CkCacheManager_marshall3(void* impl_msg,CkCacheManager * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int size, int n, const CkGroupID *gid, int nWB, const CkGroupID *gidWB*/
  PUP::fromMem implP(impl_buf);
  int size; implP|size;
  int n; implP|n;
  int impl_off_gid, impl_cnt_gid; 
  implP|impl_off_gid;
  implP|impl_cnt_gid;
  int nWB; implP|nWB;
  int impl_off_gidWB, impl_cnt_gidWB; 
  implP|impl_off_gidWB;
  implP|impl_cnt_gidWB;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  CkGroupID *gid=(CkGroupID *)(impl_buf+impl_off_gid);
  CkGroupID *gidWB=(CkGroupID *)(impl_buf+impl_off_gidWB);
  new (impl_obj) CkCacheManager(size, n, gid, nWB, gidWB);
}
int CkIndex_CkCacheManager::_callmarshall_CkCacheManager_marshall3(char* impl_buf,CkCacheManager * impl_obj) {
  /*Unmarshall pup'd fields: int size, int n, const CkGroupID *gid, int nWB, const CkGroupID *gidWB*/
  PUP::fromMem implP(impl_buf);
  int size; implP|size;
  int n; implP|n;
  int impl_off_gid, impl_cnt_gid; 
  implP|impl_off_gid;
  implP|impl_cnt_gid;
  int nWB; implP|nWB;
  int impl_off_gidWB, impl_cnt_gidWB; 
  implP|impl_off_gidWB;
  implP|impl_cnt_gidWB;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  CkGroupID *gid=(CkGroupID *)(impl_buf+impl_off_gid);
  CkGroupID *gidWB=(CkGroupID *)(impl_buf+impl_off_gidWB);
  new (impl_obj) CkCacheManager(size, n, gid, nWB, gidWB);
  return implP.size();
}
void CkIndex_CkCacheManager::_marshallmessagepup_CkCacheManager_marshall3(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int size, int n, const CkGroupID *gid, int nWB, const CkGroupID *gidWB*/
  PUP::fromMem implP(impl_buf);
  int size; implP|size;
  int n; implP|n;
  int impl_off_gid, impl_cnt_gid; 
  implP|impl_off_gid;
  implP|impl_cnt_gid;
  int nWB; implP|nWB;
  int impl_off_gidWB, impl_cnt_gidWB; 
  implP|impl_off_gidWB;
  implP|impl_cnt_gidWB;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  CkGroupID *gid=(CkGroupID *)(impl_buf+impl_off_gid);
  CkGroupID *gidWB=(CkGroupID *)(impl_buf+impl_off_gidWB);
  if (implDestP.hasComments()) implDestP.comment("size");
  implDestP|size;
  if (implDestP.hasComments()) implDestP.comment("n");
  implDestP|n;
  if (implDestP.hasComments()) implDestP.comment("gid");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*gid))<impl_cnt_gid;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|gid[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("nWB");
  implDestP|nWB;
  if (implDestP.hasComments()) implDestP.comment("gidWB");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*gidWB))<impl_cnt_gidWB;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|gidWB[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
}

/* DEFS: void* requestData(const CkCacheKey &what, const CkArrayIndexMax &toWhom, int chunk, CkCacheEntryType* impl_msg, const CkCacheRequestorData &req);
 */
 int CkIndex_CkCacheManager::__idx_requestData_marshall4=0;
void CkIndex_CkCacheManager::_call_requestData_marshall4(void* impl_msg,CkCacheManager * impl_obj)
{
  CkAbort("This method should never be called as it refers to a LOCAL entry method!");
}
int CkIndex_CkCacheManager::_callmarshall_requestData_marshall4(char* impl_buf,CkCacheManager * impl_obj) {
  CkAbort("This method should never be called as it refers to a LOCAL entry method!");
  return 0;
}
void CkIndex_CkCacheManager::_marshallmessagepup_requestData_marshall4(PUP::er &implDestP,void *impl_msg) {
  /*Fake pupping since we don't really have a message */
  int n=0;
  if (implDestP.hasComments()) implDestP.comment("LOCAL message");
  implDestP|n;
}

/* DEFS: void* requestDataNoFetch(const CkCacheKey &key, int chunk);
 */
 int CkIndex_CkCacheManager::__idx_requestDataNoFetch_marshall5=0;
void CkIndex_CkCacheManager::_call_requestDataNoFetch_marshall5(void* impl_msg,CkCacheManager * impl_obj)
{
  CkAbort("This method should never be called as it refers to a LOCAL entry method!");
}
int CkIndex_CkCacheManager::_callmarshall_requestDataNoFetch_marshall5(char* impl_buf,CkCacheManager * impl_obj) {
  CkAbort("This method should never be called as it refers to a LOCAL entry method!");
  return 0;
}
void CkIndex_CkCacheManager::_marshallmessagepup_requestDataNoFetch_marshall5(PUP::er &implDestP,void *impl_msg) {
  /*Fake pupping since we don't really have a message */
  int n=0;
  if (implDestP.hasComments()) implDestP.comment("LOCAL message");
  implDestP|n;
}

/* DEFS: void cacheSync(const int &numChunks, const CkArrayIndexMax &chareIdx, const int &localIdx);
 */
 int CkIndex_CkCacheManager::__idx_cacheSync_marshall6=0;
void CkIndex_CkCacheManager::_call_cacheSync_marshall6(void* impl_msg,CkCacheManager * impl_obj)
{
  CkAbort("This method should never be called as it refers to a LOCAL entry method!");
}
int CkIndex_CkCacheManager::_callmarshall_cacheSync_marshall6(char* impl_buf,CkCacheManager * impl_obj) {
  CkAbort("This method should never be called as it refers to a LOCAL entry method!");
  return 0;
}
void CkIndex_CkCacheManager::_marshallmessagepup_cacheSync_marshall6(PUP::er &implDestP,void *impl_msg) {
  /*Fake pupping since we don't really have a message */
  int n=0;
  if (implDestP.hasComments()) implDestP.comment("LOCAL message");
  implDestP|n;
}

/* DEFS: void recvData(CkCacheFillMsg* impl_msg);
 */
void CProxy_CkCacheManager::recvData(CkCacheFillMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkCacheManager::__idx_recvData_CkCacheFillMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkCacheManager::__idx_recvData_CkCacheFillMsg, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkCacheManager::__idx_recvData_CkCacheFillMsg, impl_msg, ckGetGroupID(),0);
}
void CProxy_CkCacheManager::recvData(CkCacheFillMsg* impl_msg, int npes, int *pes) {
  CkSendMsgBranchMulti(CkIndex_CkCacheManager::__idx_recvData_CkCacheFillMsg, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CkCacheManager::recvData(CkCacheFillMsg* impl_msg, CmiGroup &grp) {
  CkSendMsgBranchGroup(CkIndex_CkCacheManager::__idx_recvData_CkCacheFillMsg, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CkCacheManager::__idx_recvData_CkCacheFillMsg=0;
void CkIndex_CkCacheManager::_call_recvData_CkCacheFillMsg(void* impl_msg,CkCacheManager * impl_obj)
{
  impl_obj->recvData((CkCacheFillMsg*)impl_msg);
}

/* DEFS: void recvData(const CkCacheKey &key, const CkArrayIndexMax &from, CkCacheEntryType* impl_msg, int chunk, void* data);
 */
 int CkIndex_CkCacheManager::__idx_recvData_marshall8=0;
void CkIndex_CkCacheManager::_call_recvData_marshall8(void* impl_msg,CkCacheManager * impl_obj)
{
  CkAbort("This method should never be called as it refers to a LOCAL entry method!");
}
int CkIndex_CkCacheManager::_callmarshall_recvData_marshall8(char* impl_buf,CkCacheManager * impl_obj) {
  CkAbort("This method should never be called as it refers to a LOCAL entry method!");
  return 0;
}
void CkIndex_CkCacheManager::_marshallmessagepup_recvData_marshall8(PUP::er &implDestP,void *impl_msg) {
  /*Fake pupping since we don't really have a message */
  int n=0;
  if (implDestP.hasComments()) implDestP.comment("LOCAL message");
  implDestP|n;
}

/* DEFS: void writebackChunk(int num);
 */
void CProxy_CkCacheManager::writebackChunk(int num, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int num
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkCacheManager::__idx_writebackChunk_marshall9, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkCacheManager::__idx_writebackChunk_marshall9, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkCacheManager::__idx_writebackChunk_marshall9, impl_msg, ckGetGroupID(),0);
}
void CProxy_CkCacheManager::writebackChunk(int num, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: int num
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num;
  }
  CkSendMsgBranchMulti(CkIndex_CkCacheManager::__idx_writebackChunk_marshall9, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CkCacheManager::writebackChunk(int num, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: int num
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num;
  }
  CkSendMsgBranchGroup(CkIndex_CkCacheManager::__idx_writebackChunk_marshall9, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CkCacheManager::__idx_writebackChunk_marshall9=0;
void CkIndex_CkCacheManager::_call_writebackChunk_marshall9(void* impl_msg,CkCacheManager * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int num*/
  PUP::fromMem implP(impl_buf);
  int num; implP|num;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->writebackChunk(num);
}
int CkIndex_CkCacheManager::_callmarshall_writebackChunk_marshall9(char* impl_buf,CkCacheManager * impl_obj) {
  /*Unmarshall pup'd fields: int num*/
  PUP::fromMem implP(impl_buf);
  int num; implP|num;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->writebackChunk(num);
  return implP.size();
}
void CkIndex_CkCacheManager::_marshallmessagepup_writebackChunk_marshall9(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int num*/
  PUP::fromMem implP(impl_buf);
  int num; implP|num;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("num");
  implDestP|num;
}

/* DEFS: void finishedChunk(int num, const CmiUInt8 &weight);
 */
void CProxy_CkCacheManager::finishedChunk(int num, const CmiUInt8 &weight, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int num, const CmiUInt8 &weight
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num;
    //Have to cast away const-ness to get pup routine
    implP|(CmiUInt8 &)weight;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num;
    //Have to cast away const-ness to get pup routine
    implP|(CmiUInt8 &)weight;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkCacheManager::__idx_finishedChunk_marshall10, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkCacheManager::__idx_finishedChunk_marshall10, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkCacheManager::__idx_finishedChunk_marshall10, impl_msg, ckGetGroupID(),0);
}
void CProxy_CkCacheManager::finishedChunk(int num, const CmiUInt8 &weight, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: int num, const CmiUInt8 &weight
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num;
    //Have to cast away const-ness to get pup routine
    implP|(CmiUInt8 &)weight;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num;
    //Have to cast away const-ness to get pup routine
    implP|(CmiUInt8 &)weight;
  }
  CkSendMsgBranchMulti(CkIndex_CkCacheManager::__idx_finishedChunk_marshall10, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CkCacheManager::finishedChunk(int num, const CmiUInt8 &weight, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: int num, const CmiUInt8 &weight
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num;
    //Have to cast away const-ness to get pup routine
    implP|(CmiUInt8 &)weight;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num;
    //Have to cast away const-ness to get pup routine
    implP|(CmiUInt8 &)weight;
  }
  CkSendMsgBranchGroup(CkIndex_CkCacheManager::__idx_finishedChunk_marshall10, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CkCacheManager::__idx_finishedChunk_marshall10=0;
void CkIndex_CkCacheManager::_call_finishedChunk_marshall10(void* impl_msg,CkCacheManager * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int num, const CmiUInt8 &weight*/
  PUP::fromMem implP(impl_buf);
  int num; implP|num;
  CmiUInt8 weight; implP|weight;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->finishedChunk(num, weight);
}
int CkIndex_CkCacheManager::_callmarshall_finishedChunk_marshall10(char* impl_buf,CkCacheManager * impl_obj) {
  /*Unmarshall pup'd fields: int num, const CmiUInt8 &weight*/
  PUP::fromMem implP(impl_buf);
  int num; implP|num;
  CmiUInt8 weight; implP|weight;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->finishedChunk(num, weight);
  return implP.size();
}
void CkIndex_CkCacheManager::_marshallmessagepup_finishedChunk_marshall10(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int num, const CmiUInt8 &weight*/
  PUP::fromMem implP(impl_buf);
  int num; implP|num;
  CmiUInt8 weight; implP|weight;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("num");
  implDestP|num;
  if (implDestP.hasComments()) implDestP.comment("weight");
  implDestP|weight;
}

/* DEFS: void collectStatistics(const CkCallback &cb);
 */
void CProxy_CkCacheManager::collectStatistics(const CkCallback &cb, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkCallback &cb
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)cb;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)cb;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkCacheManager::__idx_collectStatistics_marshall11, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkCacheManager::__idx_collectStatistics_marshall11, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkCacheManager::__idx_collectStatistics_marshall11, impl_msg, ckGetGroupID(),0);
}
void CProxy_CkCacheManager::collectStatistics(const CkCallback &cb, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkCallback &cb
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)cb;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)cb;
  }
  CkSendMsgBranchMulti(CkIndex_CkCacheManager::__idx_collectStatistics_marshall11, impl_msg, ckGetGroupID(), npes, pes,0);
}
void CProxy_CkCacheManager::collectStatistics(const CkCallback &cb, CmiGroup &grp, const CkEntryOptions *impl_e_opts) {
  //Marshall: const CkCallback &cb
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)cb;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)cb;
  }
  CkSendMsgBranchGroup(CkIndex_CkCacheManager::__idx_collectStatistics_marshall11, impl_msg, ckGetGroupID(), grp,0);
}
 int CkIndex_CkCacheManager::__idx_collectStatistics_marshall11=0;
void CkIndex_CkCacheManager::_call_collectStatistics_marshall11(void* impl_msg,CkCacheManager * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkCallback &cb*/
  PUP::fromMem implP(impl_buf);
  CkCallback cb; implP|cb;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->collectStatistics(cb);
}
int CkIndex_CkCacheManager::_callmarshall_collectStatistics_marshall11(char* impl_buf,CkCacheManager * impl_obj) {
  /*Unmarshall pup'd fields: const CkCallback &cb*/
  PUP::fromMem implP(impl_buf);
  CkCallback cb; implP|cb;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->collectStatistics(cb);
  return implP.size();
}
void CkIndex_CkCacheManager::_marshallmessagepup_collectStatistics_marshall11(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkCallback &cb*/
  PUP::fromMem implP(impl_buf);
  CkCallback cb; implP|cb;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("cb");
  implDestP|cb;
}

/* DEFS: std::map<CkCacheKey,CkCacheEntry* >* getCache(void);
 */
 int CkIndex_CkCacheManager::__idx_getCache_void=0;
void CkIndex_CkCacheManager::_call_getCache_void(void* impl_msg,CkCacheManager * impl_obj)
{
  CkAbort("This method should never be called as it refers to a LOCAL entry method!");
}

/* DEFS: CkCacheEntry* requestCacheEntryNoFetch(const CkCacheKey &key, int chunk);
 */
 int CkIndex_CkCacheManager::__idx_requestCacheEntryNoFetch_marshall13=0;
void CkIndex_CkCacheManager::_call_requestCacheEntryNoFetch_marshall13(void* impl_msg,CkCacheManager * impl_obj)
{
  CkAbort("This method should never be called as it refers to a LOCAL entry method!");
}
int CkIndex_CkCacheManager::_callmarshall_requestCacheEntryNoFetch_marshall13(char* impl_buf,CkCacheManager * impl_obj) {
  CkAbort("This method should never be called as it refers to a LOCAL entry method!");
  return 0;
}
void CkIndex_CkCacheManager::_marshallmessagepup_requestCacheEntryNoFetch_marshall13(PUP::er &implDestP,void *impl_msg) {
  /*Fake pupping since we don't really have a message */
  int n=0;
  if (implDestP.hasComments()) implDestP.comment("LOCAL message");
  implDestP|n;
}

/* DEFS: CkCacheManager(CkMigrateMessage* impl_msg);
 */

/* DEFS: CkCacheManager(int size, const CkGroupID &gid);
 */

/* DEFS: CkCacheManager(int size, int n, const CkGroupID *gid);
 */

/* DEFS: CkCacheManager(int size, int n, const CkGroupID *gid, int nWB, const CkGroupID *gidWB);
 */

/* DEFS: void* requestData(const CkCacheKey &what, const CkArrayIndexMax &toWhom, int chunk, CkCacheEntryType* impl_msg, const CkCacheRequestorData &req);
 */

/* DEFS: void* requestDataNoFetch(const CkCacheKey &key, int chunk);
 */

/* DEFS: void cacheSync(const int &numChunks, const CkArrayIndexMax &chareIdx, const int &localIdx);
 */

/* DEFS: void recvData(CkCacheFillMsg* impl_msg);
 */
void CProxySection_CkCacheManager::recvData(CkCacheFillMsg* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkCacheManager::__idx_recvData_CkCacheFillMsg, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkCacheManager::__idx_recvData_CkCacheFillMsg, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkCacheManager::__idx_recvData_CkCacheFillMsg, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void recvData(const CkCacheKey &key, const CkArrayIndexMax &from, CkCacheEntryType* impl_msg, int chunk, void* data);
 */

/* DEFS: void writebackChunk(int num);
 */
void CProxySection_CkCacheManager::writebackChunk(int num, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int num
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkCacheManager::__idx_writebackChunk_marshall9, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkCacheManager::__idx_writebackChunk_marshall9, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkCacheManager::__idx_writebackChunk_marshall9, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void finishedChunk(int num, const CmiUInt8 &weight);
 */
void CProxySection_CkCacheManager::finishedChunk(int num, const CmiUInt8 &weight, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int num, const CmiUInt8 &weight
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|num;
    //Have to cast away const-ness to get pup routine
    implP|(CmiUInt8 &)weight;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|num;
    //Have to cast away const-ness to get pup routine
    implP|(CmiUInt8 &)weight;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkCacheManager::__idx_finishedChunk_marshall10, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkCacheManager::__idx_finishedChunk_marshall10, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkCacheManager::__idx_finishedChunk_marshall10, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: void collectStatistics(const CkCallback &cb);
 */
void CProxySection_CkCacheManager::collectStatistics(const CkCallback &cb, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkCallback &cb
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)cb;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkCallback &)cb;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkCacheManager::__idx_collectStatistics_marshall11, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_CkCacheManager::__idx_collectStatistics_marshall11, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_CkCacheManager::__idx_collectStatistics_marshall11, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

/* DEFS: std::map<CkCacheKey,CkCacheEntry* >* getCache(void);
 */

/* DEFS: CkCacheEntry* requestCacheEntryNoFetch(const CkCacheKey &key, int chunk);
 */

#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_CkCacheManager::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeGroup);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,CkCacheManager::isIrreducible());
// REG: CkCacheManager(CkMigrateMessage* impl_msg);
  __idx_CkCacheManager_CkMigrateMessage = CkRegisterEp("CkCacheManager(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_CkCacheManager_CkMigrateMessage, 0, __idx, 0);
  CkRegisterMigCtor(__idx, __idx_CkCacheManager_CkMigrateMessage);

// REG: CkCacheManager(int size, const CkGroupID &gid);
  __idx_CkCacheManager_marshall1 = CkRegisterEp("CkCacheManager(int size, const CkGroupID &gid)",
     (CkCallFnPtr)_call_CkCacheManager_marshall1, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_CkCacheManager_marshall1,(CkMarshallUnpackFn)_callmarshall_CkCacheManager_marshall1);
  CkRegisterMessagePupFn(__idx_CkCacheManager_marshall1,(CkMessagePupFn)_marshallmessagepup_CkCacheManager_marshall1);

// REG: CkCacheManager(int size, int n, const CkGroupID *gid);
  __idx_CkCacheManager_marshall2 = CkRegisterEp("CkCacheManager(int size, int n, const CkGroupID *gid)",
     (CkCallFnPtr)_call_CkCacheManager_marshall2, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_CkCacheManager_marshall2,(CkMarshallUnpackFn)_callmarshall_CkCacheManager_marshall2);
  CkRegisterMessagePupFn(__idx_CkCacheManager_marshall2,(CkMessagePupFn)_marshallmessagepup_CkCacheManager_marshall2);

// REG: CkCacheManager(int size, int n, const CkGroupID *gid, int nWB, const CkGroupID *gidWB);
  __idx_CkCacheManager_marshall3 = CkRegisterEp("CkCacheManager(int size, int n, const CkGroupID *gid, int nWB, const CkGroupID *gidWB)",
     (CkCallFnPtr)_call_CkCacheManager_marshall3, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_CkCacheManager_marshall3,(CkMarshallUnpackFn)_callmarshall_CkCacheManager_marshall3);
  CkRegisterMessagePupFn(__idx_CkCacheManager_marshall3,(CkMessagePupFn)_marshallmessagepup_CkCacheManager_marshall3);

// REG: void* requestData(const CkCacheKey &what, const CkArrayIndexMax &toWhom, int chunk, CkCacheEntryType* impl_msg, const CkCacheRequestorData &req);
  __idx_requestData_marshall4 = CkRegisterEp("requestData(const CkCacheKey &what, const CkArrayIndexMax &toWhom, int chunk, CkCacheEntryType* impl_msg, const CkCacheRequestorData &req)",
     (CkCallFnPtr)_call_requestData_marshall4, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_requestData_marshall4,(CkMarshallUnpackFn)_callmarshall_requestData_marshall4);
  CkRegisterMessagePupFn(__idx_requestData_marshall4,(CkMessagePupFn)_marshallmessagepup_requestData_marshall4);

// REG: void* requestDataNoFetch(const CkCacheKey &key, int chunk);
  __idx_requestDataNoFetch_marshall5 = CkRegisterEp("requestDataNoFetch(const CkCacheKey &key, int chunk)",
     (CkCallFnPtr)_call_requestDataNoFetch_marshall5, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_requestDataNoFetch_marshall5,(CkMarshallUnpackFn)_callmarshall_requestDataNoFetch_marshall5);
  CkRegisterMessagePupFn(__idx_requestDataNoFetch_marshall5,(CkMessagePupFn)_marshallmessagepup_requestDataNoFetch_marshall5);

// REG: void cacheSync(const int &numChunks, const CkArrayIndexMax &chareIdx, const int &localIdx);
  __idx_cacheSync_marshall6 = CkRegisterEp("cacheSync(const int &numChunks, const CkArrayIndexMax &chareIdx, const int &localIdx)",
     (CkCallFnPtr)_call_cacheSync_marshall6, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_cacheSync_marshall6,(CkMarshallUnpackFn)_callmarshall_cacheSync_marshall6);
  CkRegisterMessagePupFn(__idx_cacheSync_marshall6,(CkMessagePupFn)_marshallmessagepup_cacheSync_marshall6);

// REG: void recvData(CkCacheFillMsg* impl_msg);
  __idx_recvData_CkCacheFillMsg = CkRegisterEp("recvData(CkCacheFillMsg* impl_msg)",
     (CkCallFnPtr)_call_recvData_CkCacheFillMsg, CMessage_CkCacheFillMsg::__idx, __idx, 0);

// REG: void recvData(const CkCacheKey &key, const CkArrayIndexMax &from, CkCacheEntryType* impl_msg, int chunk, void* data);
  __idx_recvData_marshall8 = CkRegisterEp("recvData(const CkCacheKey &key, const CkArrayIndexMax &from, CkCacheEntryType* impl_msg, int chunk, void* data)",
     (CkCallFnPtr)_call_recvData_marshall8, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_recvData_marshall8,(CkMarshallUnpackFn)_callmarshall_recvData_marshall8);
  CkRegisterMessagePupFn(__idx_recvData_marshall8,(CkMessagePupFn)_marshallmessagepup_recvData_marshall8);

// REG: void writebackChunk(int num);
  __idx_writebackChunk_marshall9 = CkRegisterEp("writebackChunk(int num)",
     (CkCallFnPtr)_call_writebackChunk_marshall9, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_writebackChunk_marshall9,(CkMarshallUnpackFn)_callmarshall_writebackChunk_marshall9);
  CkRegisterMessagePupFn(__idx_writebackChunk_marshall9,(CkMessagePupFn)_marshallmessagepup_writebackChunk_marshall9);

// REG: void finishedChunk(int num, const CmiUInt8 &weight);
  __idx_finishedChunk_marshall10 = CkRegisterEp("finishedChunk(int num, const CmiUInt8 &weight)",
     (CkCallFnPtr)_call_finishedChunk_marshall10, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_finishedChunk_marshall10,(CkMarshallUnpackFn)_callmarshall_finishedChunk_marshall10);
  CkRegisterMessagePupFn(__idx_finishedChunk_marshall10,(CkMessagePupFn)_marshallmessagepup_finishedChunk_marshall10);

// REG: void collectStatistics(const CkCallback &cb);
  __idx_collectStatistics_marshall11 = CkRegisterEp("collectStatistics(const CkCallback &cb)",
     (CkCallFnPtr)_call_collectStatistics_marshall11, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_collectStatistics_marshall11,(CkMarshallUnpackFn)_callmarshall_collectStatistics_marshall11);
  CkRegisterMessagePupFn(__idx_collectStatistics_marshall11,(CkMessagePupFn)_marshallmessagepup_collectStatistics_marshall11);

// REG: std::map<CkCacheKey,CkCacheEntry* >* getCache(void);
  __idx_getCache_void = CkRegisterEp("getCache(void)",
     (CkCallFnPtr)_call_getCache_void, 0, __idx, 0);

// REG: CkCacheEntry* requestCacheEntryNoFetch(const CkCacheKey &key, int chunk);
  __idx_requestCacheEntryNoFetch_marshall13 = CkRegisterEp("requestCacheEntryNoFetch(const CkCacheKey &key, int chunk)",
     (CkCallFnPtr)_call_requestCacheEntryNoFetch_marshall13, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_requestCacheEntryNoFetch_marshall13,(CkMarshallUnpackFn)_callmarshall_requestCacheEntryNoFetch_marshall13);
  CkRegisterMessagePupFn(__idx_requestCacheEntryNoFetch_marshall13,(CkMessagePupFn)_marshallmessagepup_requestCacheEntryNoFetch_marshall13);

}
#endif

#ifndef CK_TEMPLATES_ONLY
void _registerCkCache(void)
{
  static int _done = 0; if(_done) return; _done = 1;
/* REG: message CkCacheRequestMsg;
*/
CMessage_CkCacheRequestMsg::__register("CkCacheRequestMsg", sizeof(CkCacheRequestMsg),(CkPackFnPtr) CkCacheRequestMsg::pack,(CkUnpackFnPtr) CkCacheRequestMsg::unpack);

/* REG: message CkCacheFillMsg{
char data[];
}
;
*/
CMessage_CkCacheFillMsg::__register("CkCacheFillMsg", sizeof(CkCacheFillMsg),(CkPackFnPtr) CkCacheFillMsg::pack,(CkUnpackFnPtr) CkCacheFillMsg::unpack);

/* REG: group CkCacheManager: IrrGroup{
CkCacheManager(CkMigrateMessage* impl_msg);
CkCacheManager(int size, const CkGroupID &gid);
CkCacheManager(int size, int n, const CkGroupID *gid);
CkCacheManager(int size, int n, const CkGroupID *gid, int nWB, const CkGroupID *gidWB);
void* requestData(const CkCacheKey &what, const CkArrayIndexMax &toWhom, int chunk, CkCacheEntryType* impl_msg, const CkCacheRequestorData &req);
void* requestDataNoFetch(const CkCacheKey &key, int chunk);
void cacheSync(const int &numChunks, const CkArrayIndexMax &chareIdx, const int &localIdx);
void recvData(CkCacheFillMsg* impl_msg);
void recvData(const CkCacheKey &key, const CkArrayIndexMax &from, CkCacheEntryType* impl_msg, int chunk, void* data);
void writebackChunk(int num);
void finishedChunk(int num, const CmiUInt8 &weight);
void collectStatistics(const CkCallback &cb);
std::map<CkCacheKey,CkCacheEntry* >* getCache(void);
CkCacheEntry* requestCacheEntryNoFetch(const CkCacheKey &key, int chunk);
};
*/
  CkIndex_CkCacheManager::__register("CkCacheManager", sizeof(CkCacheManager));

}
#endif
