/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.Utils;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;

public class FASerializer {
    protected Set markedStates;
    protected int stateCounter = 0;
    protected Map stateNumberTranslator;
    protected Grammar grammar;

    public FASerializer(Grammar grammar) {
        this.grammar = grammar;
    }

    public String serialize(State state) {
        if (state == null) {
            return "<no automaton>";
        }
        return this.serialize(state, true);
    }

    public String serialize(State state, boolean bl) {
        CharSequence charSequence;
        this.markedStates = new HashSet();
        this.stateCounter = 0;
        if (bl) {
            this.stateNumberTranslator = new HashMap();
            this.walkFANormalizingStateNumbers(state);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (state.getNumberOfTransitions() > 0) {
            this.walkSerializingFA(arrayList, state);
        } else {
            charSequence = this.getStateString(0, state);
            arrayList.add((String)charSequence + "\n");
        }
        charSequence = new StringBuffer(0);
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            ((StringBuffer)charSequence).append(string);
        }
        return ((StringBuffer)charSequence).toString();
    }

    protected void walkFANormalizingStateNumbers(State state) {
        if (state == null) {
            ErrorManager.internalError("null state s");
            return;
        }
        if (this.stateNumberTranslator.get(state) != null) {
            return;
        }
        this.stateNumberTranslator.put(state, Utils.integer(this.stateCounter));
        ++this.stateCounter;
        for (int i = 0; i < state.getNumberOfTransitions(); ++i) {
            Transition transition = state.transition(i);
            this.walkFANormalizingStateNumbers(transition.target);
            if (!(transition instanceof RuleClosureTransition)) continue;
            this.walkFANormalizingStateNumbers(((RuleClosureTransition)transition).followState);
        }
    }

    protected void walkSerializingFA(List list, State state) {
        Object object;
        if (this.markedStates.contains(state)) {
            return;
        }
        this.markedStates.add(state);
        int n = state.stateNumber;
        if (this.stateNumberTranslator != null) {
            object = (Integer)this.stateNumberTranslator.get(state);
            n = (Integer)object;
        }
        object = this.getStateString(n, state);
        for (int i = 0; i < state.getNumberOfTransitions(); ++i) {
            Object object2;
            Transition transition = state.transition(i);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append((String)object);
            if (transition.isAction()) {
                stringBuffer.append("-{}->");
            } else if (transition.isEpsilon()) {
                stringBuffer.append("->");
            } else if (transition.isSemanticPredicate()) {
                stringBuffer.append("-{" + transition.label.getSemanticContext() + "}?->");
            } else {
                String string = "";
                if (transition.target instanceof DFAState && (object2 = ((DFAState)transition.target).getGatedPredicatesInNFAConfigurations()) != null) {
                    string = "&&{" + ((SemanticContext)object2).genExpr(this.grammar.generator, this.grammar.generator.getTemplates(), null).toString() + "}?";
                }
                stringBuffer.append("-" + transition.label.toString(this.grammar) + string + "->");
            }
            int n2 = transition.target.stateNumber;
            if (this.stateNumberTranslator != null) {
                object2 = (Integer)this.stateNumberTranslator.get(transition.target);
                n2 = (Integer)object2;
            }
            stringBuffer.append(this.getStateString(n2, transition.target));
            stringBuffer.append("\n");
            list.add(stringBuffer.toString());
            this.walkSerializingFA(list, transition.target);
            if (!(transition instanceof RuleClosureTransition)) continue;
            this.walkSerializingFA(list, ((RuleClosureTransition)transition).followState);
        }
    }

    private String getStateString(int n, State state) {
        String string = ".s" + n;
        if (state.isAcceptState()) {
            string = state instanceof DFAState ? ":s" + n + "=>" + ((DFAState)state).getUniquelyPredictedAlt() : ":s" + n;
        }
        return string;
    }
}

