/* DEFS: readonly CProxy_ParFUMShadowArray meshSA;
 */
extern CProxy_ParFUMShadowArray meshSA;
#ifndef CK_TEMPLATES_ONLY
extern "C" void __xlater_roPup_meshSA(void *_impl_pup_er) {
  PUP::er &_impl_p=*(PUP::er *)_impl_pup_er;
  _impl_p|meshSA;
}
#endif

/* DEFS: message lockChunksMsg{
int chkList[];
}
;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_lockChunksMsg::operator new(size_t s){
  return lockChunksMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_lockChunksMsg::operator new(size_t s, int* sz){
  return lockChunksMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_lockChunksMsg::operator new(size_t s, int* sz,const int pb){
  return lockChunksMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_lockChunksMsg::operator new(size_t s, int sz0) {
  int sizes[1];
  sizes[0] = sz0;
  return lockChunksMsg::alloc(__idx, s, sizes, 0);
}
void *CMessage_lockChunksMsg::operator new(size_t s, int sz0, const int p) {
  int sizes[1];
  sizes[0] = sz0;
  return lockChunksMsg::alloc(__idx, s, sizes, p);
}
void* CMessage_lockChunksMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  size_t offsets[2];
  offsets[0] = ALIGN8(sz);
  if(sizes==0)
    offsets[1] = offsets[0];
  else
    offsets[1] = offsets[0] + ALIGN8(sizeof(int)*sizes[0]);
  lockChunksMsg *newmsg = (lockChunksMsg *) CkAllocMsg(msgnum, offsets[1], pb);
  newmsg->chkList = (int *) ((char *)newmsg + offsets[0]);
  return (void *) newmsg;
}
void CMessage_lockChunksMsg::dealloc(void *p) {
  CkFreeMsg(p);
}
void* CMessage_lockChunksMsg::pack(lockChunksMsg *msg) {
  msg->chkList = (int *) ((char *)msg->chkList - (char *)msg);
  return (void *) msg;
}
lockChunksMsg* CMessage_lockChunksMsg::unpack(void* buf) {
  lockChunksMsg *msg = (lockChunksMsg *) buf;
  msg->chkList = (int *) ((size_t)msg->chkList + (char *)msg);
  return msg;
}
int CMessage_lockChunksMsg::__idx=0;
#endif

/* DEFS: message adaptAdjMsg;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_adaptAdjMsg::operator new(size_t s){
  return adaptAdjMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_adaptAdjMsg::operator new(size_t s, int* sz){
  return adaptAdjMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_adaptAdjMsg::operator new(size_t s, int* sz,const int pb){
  return adaptAdjMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_adaptAdjMsg::operator new(size_t s, const int p) {
  return adaptAdjMsg::alloc(__idx, s, 0, p);
}
void* CMessage_adaptAdjMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  size_t offsets[1];
  offsets[0] = ALIGN8(sz);
  adaptAdjMsg *newmsg = (adaptAdjMsg *) CkAllocMsg(msgnum, offsets[0], pb);
  return (void *) newmsg;
}
void CMessage_adaptAdjMsg::dealloc(void *p) {
  CkFreeMsg(p);
}
void* CMessage_adaptAdjMsg::pack(adaptAdjMsg *msg) {
  return (void *) msg;
}
adaptAdjMsg* CMessage_adaptAdjMsg::unpack(void* buf) {
  adaptAdjMsg *msg = (adaptAdjMsg *) buf;
  return msg;
}
int CMessage_adaptAdjMsg::__idx=0;
#endif

/* DEFS: message longestMsg;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_longestMsg::operator new(size_t s){
  return longestMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_longestMsg::operator new(size_t s, int* sz){
  return longestMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_longestMsg::operator new(size_t s, int* sz,const int pb){
  return longestMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_longestMsg::operator new(size_t s, const int p) {
  return longestMsg::alloc(__idx, s, 0, p);
}
void* CMessage_longestMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  size_t offsets[1];
  offsets[0] = ALIGN8(sz);
  longestMsg *newmsg = (longestMsg *) CkAllocMsg(msgnum, offsets[0], pb);
  return (void *) newmsg;
}
void CMessage_longestMsg::dealloc(void *p) {
  CkFreeMsg(p);
}
void* CMessage_longestMsg::pack(longestMsg *msg) {
  return (void *) msg;
}
longestMsg* CMessage_longestMsg::unpack(void* buf) {
  longestMsg *msg = (longestMsg *) buf;
  return msg;
}
int CMessage_longestMsg::__idx=0;
#endif

/* DEFS: array ParFUMShadowArray: ArrayElement{
ParFUMShadowArray(CkMigrateMessage* impl_msg);
ParFUMShadowArray(int s, int i);
void setFemMesh(FEMMeshMsg* impl_msg);
void lockRegionForRemote(const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements);
void lockReply(int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess);
void unlockForRemote(const RegionID &regionID);
void unpendForRemote(const RegionID &regionID);
void unlockReply(int remoteChunk, const RegionID &regionID);
sync adaptAdjMsg* remote_bulk_edge_bisect_2D(const adaptAdj &nbrElem, const adaptAdj &splitElem, int new_idxl, int n1_idxl, int n2_idxl, int partitionID);
sync void remote_adaptAdj_replace(const adaptAdj &elem, const adaptAdj &oldElem, const adaptAdj &newElem);
sync void remote_edgeAdj_replace(int remotePartID, const adaptAdj &adj, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl);
sync void remote_edgeAdj_add(int remotePartID, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl);
void recv_split_3D(int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem);
void handle_split_3D(int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl);
threaded sync void recv_splits(int tableID, int expectedSplits);
sync longestMsg* isLongest(int elem, int elemType, double len);
void update_asterisk_3D(int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_ParFUMShadowArray::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: ParFUMShadowArray(CkMigrateMessage* impl_msg);
 */

/* DEFS: ParFUMShadowArray(int s, int i);
 */
void CProxyElement_ParFUMShadowArray::insert(int s, int i, int onPE, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: int s, int i
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|s;
    implP|i;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|s;
    implP|i;
  }
   ckInsert((CkArrayMessage *)impl_msg,CkIndex_ParFUMShadowArray::__idx_ParFUMShadowArray_marshall1,onPE);
}

/* DEFS: void setFemMesh(FEMMeshMsg* impl_msg);
 */
void CProxyElement_ParFUMShadowArray::setFemMesh(FEMMeshMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_setFemMesh_FEMMeshMsg,0);
}

/* DEFS: void lockRegionForRemote(const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements);
 */
void CProxyElement_ParFUMShadowArray::lockRegionForRemote(const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_sharedIdxls, impl_cnt_sharedIdxls;
  impl_off_sharedIdxls=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_sharedIdxls=sizeof(int)*(numSharedIdxls));
  int impl_off_elements, impl_cnt_elements;
  impl_off_elements=impl_off=CK_ALIGN(impl_off,sizeof(adaptAdj));
  impl_off+=(impl_cnt_elements=sizeof(adaptAdj)*(numElements));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    implP|impl_off_sharedIdxls;
    implP|impl_cnt_sharedIdxls;
    implP|numSharedIdxls;
    implP|impl_off_elements;
    implP|impl_cnt_elements;
    implP|numElements;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    implP|impl_off_sharedIdxls;
    implP|impl_cnt_sharedIdxls;
    implP|numSharedIdxls;
    implP|impl_off_elements;
    implP|impl_cnt_elements;
    implP|numElements;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_sharedIdxls,sharedIdxls,impl_cnt_sharedIdxls);
  memcpy(impl_buf+impl_off_elements,elements,impl_cnt_elements);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_lockRegionForRemote_marshall3,0);
}

/* DEFS: void lockReply(int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess);
 */
void CProxyElement_ParFUMShadowArray::lockReply(int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|remoteChunk;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    //Have to cast away const-ness to get pup routine
    implP|(bool &)success;
    implP|tag;
    implP|otherSuccess;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|remoteChunk;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    //Have to cast away const-ness to get pup routine
    implP|(bool &)success;
    implP|tag;
    implP|otherSuccess;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_lockReply_marshall4,0);
}

/* DEFS: void unlockForRemote(const RegionID &regionID);
 */
void CProxyElement_ParFUMShadowArray::unlockForRemote(const RegionID &regionID, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const RegionID &regionID
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_unlockForRemote_marshall5,0);
}

/* DEFS: void unpendForRemote(const RegionID &regionID);
 */
void CProxyElement_ParFUMShadowArray::unpendForRemote(const RegionID &regionID, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const RegionID &regionID
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_unpendForRemote_marshall6,0);
}

/* DEFS: void unlockReply(int remoteChunk, const RegionID &regionID);
 */
void CProxyElement_ParFUMShadowArray::unlockReply(int remoteChunk, const RegionID &regionID, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int remoteChunk, const RegionID &regionID
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|remoteChunk;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|remoteChunk;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_unlockReply_marshall7,0);
}

/* DEFS: sync adaptAdjMsg* remote_bulk_edge_bisect_2D(const adaptAdj &nbrElem, const adaptAdj &splitElem, int new_idxl, int n1_idxl, int n2_idxl, int partitionID);
 */
adaptAdjMsg* CProxyElement_ParFUMShadowArray::remote_bulk_edge_bisect_2D(const adaptAdj &nbrElem, const adaptAdj &splitElem, int new_idxl, int n1_idxl, int n2_idxl, int partitionID, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const adaptAdj &nbrElem, const adaptAdj &splitElem, int new_idxl, int n1_idxl, int n2_idxl, int partitionID
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)nbrElem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)splitElem;
    implP|new_idxl;
    implP|n1_idxl;
    implP|n2_idxl;
    implP|partitionID;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)nbrElem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)splitElem;
    implP|new_idxl;
    implP|n1_idxl;
    implP|n2_idxl;
    implP|partitionID;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  return (adaptAdjMsg*) (ckSendSync(impl_amsg, CkIndex_ParFUMShadowArray::__idx_remote_bulk_edge_bisect_2D_marshall8));
}

/* DEFS: sync void remote_adaptAdj_replace(const adaptAdj &elem, const adaptAdj &oldElem, const adaptAdj &newElem);
 */
void CProxyElement_ParFUMShadowArray::remote_adaptAdj_replace(const adaptAdj &elem, const adaptAdj &oldElem, const adaptAdj &newElem, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const adaptAdj &elem, const adaptAdj &oldElem, const adaptAdj &newElem
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)oldElem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)newElem;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)oldElem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)newElem;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  CkFreeSysMsg(ckSendSync(impl_amsg, CkIndex_ParFUMShadowArray::__idx_remote_adaptAdj_replace_marshall9));
}

/* DEFS: sync void remote_edgeAdj_replace(int remotePartID, const adaptAdj &adj, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl);
 */
void CProxyElement_ParFUMShadowArray::remote_edgeAdj_replace(int remotePartID, const adaptAdj &adj, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int remotePartID, const adaptAdj &adj, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|remotePartID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)adj;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)splitElem;
    implP|n1_idxl;
    implP|n2_idxl;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|remotePartID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)adj;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)splitElem;
    implP|n1_idxl;
    implP|n2_idxl;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  CkFreeSysMsg(ckSendSync(impl_amsg, CkIndex_ParFUMShadowArray::__idx_remote_edgeAdj_replace_marshall10));
}

/* DEFS: sync void remote_edgeAdj_add(int remotePartID, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl);
 */
void CProxyElement_ParFUMShadowArray::remote_edgeAdj_add(int remotePartID, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int remotePartID, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|remotePartID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)splitElem;
    implP|n1_idxl;
    implP|n2_idxl;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|remotePartID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)splitElem;
    implP|n1_idxl;
    implP|n2_idxl;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  CkFreeSysMsg(ckSendSync(impl_amsg, CkIndex_ParFUMShadowArray::__idx_remote_edgeAdj_add_marshall11));
}

/* DEFS: void recv_split_3D(int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem);
 */
void CProxyElement_ParFUMShadowArray::recv_split_3D(int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|pos;
    implP|tableID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)splitElem;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|pos;
    implP|tableID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)splitElem;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_recv_split_3D_marshall12,0);
}

/* DEFS: void handle_split_3D(int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl);
 */
void CProxyElement_ParFUMShadowArray::handle_split_3D(int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|remotePartID;
    implP|pos;
    implP|tableID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)lockRegionID;
    implP|n1_idxl;
    implP|n2_idxl;
    implP|n5_idxl;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|remotePartID;
    implP|pos;
    implP|tableID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)lockRegionID;
    implP|n1_idxl;
    implP|n2_idxl;
    implP|n5_idxl;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_handle_split_3D_marshall13,0);
}

/* DEFS: threaded sync void recv_splits(int tableID, int expectedSplits);
 */
void CProxyElement_ParFUMShadowArray::recv_splits(int tableID, int expectedSplits, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int tableID, int expectedSplits
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|tableID;
    implP|expectedSplits;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|tableID;
    implP|expectedSplits;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  CkFreeSysMsg(ckSendSync(impl_amsg, CkIndex_ParFUMShadowArray::__idx_recv_splits_marshall14));
}

/* DEFS: sync longestMsg* isLongest(int elem, int elemType, double len);
 */
longestMsg* CProxyElement_ParFUMShadowArray::isLongest(int elem, int elemType, double len, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int elem, int elemType, double len
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|elem;
    implP|elemType;
    implP|len;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|elem;
    implP|elemType;
    implP|len;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  return (longestMsg*) (ckSendSync(impl_amsg, CkIndex_ParFUMShadowArray::__idx_isLongest_marshall15));
}

/* DEFS: void update_asterisk_3D(int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl);
 */
void CProxyElement_ParFUMShadowArray::update_asterisk_3D(int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_elemPairs, impl_cnt_elemPairs;
  impl_off_elemPairs=impl_off=CK_ALIGN(impl_off,sizeof(adaptAdj));
  impl_off+=(impl_cnt_elemPairs=sizeof(adaptAdj)*(2*numElemPairs));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|remotePartID;
    implP|i;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    implP|numElemPairs;
    implP|impl_off_elemPairs;
    implP|impl_cnt_elemPairs;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)lockRegionID;
    implP|n1_idxl;
    implP|n2_idxl;
    implP|n5_idxl;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|remotePartID;
    implP|i;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    implP|numElemPairs;
    implP|impl_off_elemPairs;
    implP|impl_cnt_elemPairs;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)lockRegionID;
    implP|n1_idxl;
    implP|n2_idxl;
    implP|n5_idxl;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_elemPairs,elemPairs,impl_cnt_elemPairs);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_update_asterisk_3D_marshall16,0);
}

/* DEFS: ParFUMShadowArray(CkMigrateMessage* impl_msg);
 */
 int CkIndex_ParFUMShadowArray::__idx_ParFUMShadowArray_CkMigrateMessage=0;
void CkIndex_ParFUMShadowArray::_call_ParFUMShadowArray_CkMigrateMessage(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  new (impl_obj) ParFUMShadowArray((CkMigrateMessage*)impl_msg);
}

/* DEFS: ParFUMShadowArray(int s, int i);
 */
CkArrayID CProxy_ParFUMShadowArray::ckNew(int s, int i, const CkArrayOptions &opts, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: int s, int i
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|s;
    implP|i;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|s;
    implP|i;
  }
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_ParFUMShadowArray::__idx_ParFUMShadowArray_marshall1,opts);
}
CkArrayID CProxy_ParFUMShadowArray::ckNew(int s, int i, const int s1, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: int s, int i
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|s;
    implP|i;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|s;
    implP|i;
  }
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_ParFUMShadowArray::__idx_ParFUMShadowArray_marshall1,CkArrayOptions(s1));
}
 int CkIndex_ParFUMShadowArray::__idx_ParFUMShadowArray_marshall1=0;
void CkIndex_ParFUMShadowArray::_call_ParFUMShadowArray_marshall1(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int s, int i*/
  PUP::fromMem implP(impl_buf);
  int s; implP|s;
  int i; implP|i;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) ParFUMShadowArray(s, i);
}
int CkIndex_ParFUMShadowArray::_callmarshall_ParFUMShadowArray_marshall1(char* impl_buf,ParFUMShadowArray * impl_obj) {
  /*Unmarshall pup'd fields: int s, int i*/
  PUP::fromMem implP(impl_buf);
  int s; implP|s;
  int i; implP|i;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) ParFUMShadowArray(s, i);
  return implP.size();
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_ParFUMShadowArray_marshall1(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int s, int i*/
  PUP::fromMem implP(impl_buf);
  int s; implP|s;
  int i; implP|i;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("s");
  implDestP|s;
  if (implDestP.hasComments()) implDestP.comment("i");
  implDestP|i;
}

/* DEFS: void setFemMesh(FEMMeshMsg* impl_msg);
 */
void CProxy_ParFUMShadowArray::setFemMesh(FEMMeshMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ParFUMShadowArray::__idx_setFemMesh_FEMMeshMsg,0);
}
 int CkIndex_ParFUMShadowArray::__idx_setFemMesh_FEMMeshMsg=0;
void CkIndex_ParFUMShadowArray::_call_setFemMesh_FEMMeshMsg(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  impl_obj->setFemMesh((FEMMeshMsg*)impl_msg);
}

/* DEFS: void lockRegionForRemote(const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements);
 */
void CProxy_ParFUMShadowArray::lockRegionForRemote(const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_sharedIdxls, impl_cnt_sharedIdxls;
  impl_off_sharedIdxls=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_sharedIdxls=sizeof(int)*(numSharedIdxls));
  int impl_off_elements, impl_cnt_elements;
  impl_off_elements=impl_off=CK_ALIGN(impl_off,sizeof(adaptAdj));
  impl_off+=(impl_cnt_elements=sizeof(adaptAdj)*(numElements));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    implP|impl_off_sharedIdxls;
    implP|impl_cnt_sharedIdxls;
    implP|numSharedIdxls;
    implP|impl_off_elements;
    implP|impl_cnt_elements;
    implP|numElements;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    implP|impl_off_sharedIdxls;
    implP|impl_cnt_sharedIdxls;
    implP|numSharedIdxls;
    implP|impl_off_elements;
    implP|impl_cnt_elements;
    implP|numElements;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_sharedIdxls,sharedIdxls,impl_cnt_sharedIdxls);
  memcpy(impl_buf+impl_off_elements,elements,impl_cnt_elements);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ParFUMShadowArray::__idx_lockRegionForRemote_marshall3,0);
}
 int CkIndex_ParFUMShadowArray::__idx_lockRegionForRemote_marshall3=0;
void CkIndex_ParFUMShadowArray::_call_lockRegionForRemote_marshall3(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements*/
  PUP::fromMem implP(impl_buf);
  RegionID regionID; implP|regionID;
  int impl_off_sharedIdxls, impl_cnt_sharedIdxls; 
  implP|impl_off_sharedIdxls;
  implP|impl_cnt_sharedIdxls;
  int numSharedIdxls; implP|numSharedIdxls;
  int impl_off_elements, impl_cnt_elements; 
  implP|impl_off_elements;
  implP|impl_cnt_elements;
  int numElements; implP|numElements;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *sharedIdxls=(int *)(impl_buf+impl_off_sharedIdxls);
  adaptAdj *elements=(adaptAdj *)(impl_buf+impl_off_elements);
  impl_obj->lockRegionForRemote(regionID, sharedIdxls, numSharedIdxls, elements, numElements);
}
int CkIndex_ParFUMShadowArray::_callmarshall_lockRegionForRemote_marshall3(char* impl_buf,ParFUMShadowArray * impl_obj) {
  /*Unmarshall pup'd fields: const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements*/
  PUP::fromMem implP(impl_buf);
  RegionID regionID; implP|regionID;
  int impl_off_sharedIdxls, impl_cnt_sharedIdxls; 
  implP|impl_off_sharedIdxls;
  implP|impl_cnt_sharedIdxls;
  int numSharedIdxls; implP|numSharedIdxls;
  int impl_off_elements, impl_cnt_elements; 
  implP|impl_off_elements;
  implP|impl_cnt_elements;
  int numElements; implP|numElements;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *sharedIdxls=(int *)(impl_buf+impl_off_sharedIdxls);
  adaptAdj *elements=(adaptAdj *)(impl_buf+impl_off_elements);
  impl_obj->lockRegionForRemote(regionID, sharedIdxls, numSharedIdxls, elements, numElements);
  return implP.size();
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_lockRegionForRemote_marshall3(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements*/
  PUP::fromMem implP(impl_buf);
  RegionID regionID; implP|regionID;
  int impl_off_sharedIdxls, impl_cnt_sharedIdxls; 
  implP|impl_off_sharedIdxls;
  implP|impl_cnt_sharedIdxls;
  int numSharedIdxls; implP|numSharedIdxls;
  int impl_off_elements, impl_cnt_elements; 
  implP|impl_off_elements;
  implP|impl_cnt_elements;
  int numElements; implP|numElements;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *sharedIdxls=(int *)(impl_buf+impl_off_sharedIdxls);
  adaptAdj *elements=(adaptAdj *)(impl_buf+impl_off_elements);
  if (implDestP.hasComments()) implDestP.comment("regionID");
  implDestP|regionID;
  if (implDestP.hasComments()) implDestP.comment("sharedIdxls");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*sharedIdxls))<impl_cnt_sharedIdxls;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|sharedIdxls[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("numSharedIdxls");
  implDestP|numSharedIdxls;
  if (implDestP.hasComments()) implDestP.comment("elements");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*elements))<impl_cnt_elements;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|elements[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("numElements");
  implDestP|numElements;
}

/* DEFS: void lockReply(int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess);
 */
void CProxy_ParFUMShadowArray::lockReply(int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|remoteChunk;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    //Have to cast away const-ness to get pup routine
    implP|(bool &)success;
    implP|tag;
    implP|otherSuccess;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|remoteChunk;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    //Have to cast away const-ness to get pup routine
    implP|(bool &)success;
    implP|tag;
    implP|otherSuccess;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ParFUMShadowArray::__idx_lockReply_marshall4,0);
}
 int CkIndex_ParFUMShadowArray::__idx_lockReply_marshall4=0;
void CkIndex_ParFUMShadowArray::_call_lockReply_marshall4(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess*/
  PUP::fromMem implP(impl_buf);
  int remoteChunk; implP|remoteChunk;
  RegionID regionID; implP|regionID;
  bool success; implP|success;
  int tag; implP|tag;
  int otherSuccess; implP|otherSuccess;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->lockReply(remoteChunk, regionID, success, tag, otherSuccess);
}
int CkIndex_ParFUMShadowArray::_callmarshall_lockReply_marshall4(char* impl_buf,ParFUMShadowArray * impl_obj) {
  /*Unmarshall pup'd fields: int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess*/
  PUP::fromMem implP(impl_buf);
  int remoteChunk; implP|remoteChunk;
  RegionID regionID; implP|regionID;
  bool success; implP|success;
  int tag; implP|tag;
  int otherSuccess; implP|otherSuccess;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->lockReply(remoteChunk, regionID, success, tag, otherSuccess);
  return implP.size();
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_lockReply_marshall4(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess*/
  PUP::fromMem implP(impl_buf);
  int remoteChunk; implP|remoteChunk;
  RegionID regionID; implP|regionID;
  bool success; implP|success;
  int tag; implP|tag;
  int otherSuccess; implP|otherSuccess;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("remoteChunk");
  implDestP|remoteChunk;
  if (implDestP.hasComments()) implDestP.comment("regionID");
  implDestP|regionID;
  if (implDestP.hasComments()) implDestP.comment("success");
  implDestP|success;
  if (implDestP.hasComments()) implDestP.comment("tag");
  implDestP|tag;
  if (implDestP.hasComments()) implDestP.comment("otherSuccess");
  implDestP|otherSuccess;
}

/* DEFS: void unlockForRemote(const RegionID &regionID);
 */
void CProxy_ParFUMShadowArray::unlockForRemote(const RegionID &regionID, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const RegionID &regionID
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ParFUMShadowArray::__idx_unlockForRemote_marshall5,0);
}
 int CkIndex_ParFUMShadowArray::__idx_unlockForRemote_marshall5=0;
void CkIndex_ParFUMShadowArray::_call_unlockForRemote_marshall5(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const RegionID &regionID*/
  PUP::fromMem implP(impl_buf);
  RegionID regionID; implP|regionID;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->unlockForRemote(regionID);
}
int CkIndex_ParFUMShadowArray::_callmarshall_unlockForRemote_marshall5(char* impl_buf,ParFUMShadowArray * impl_obj) {
  /*Unmarshall pup'd fields: const RegionID &regionID*/
  PUP::fromMem implP(impl_buf);
  RegionID regionID; implP|regionID;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->unlockForRemote(regionID);
  return implP.size();
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_unlockForRemote_marshall5(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const RegionID &regionID*/
  PUP::fromMem implP(impl_buf);
  RegionID regionID; implP|regionID;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("regionID");
  implDestP|regionID;
}

/* DEFS: void unpendForRemote(const RegionID &regionID);
 */
void CProxy_ParFUMShadowArray::unpendForRemote(const RegionID &regionID, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const RegionID &regionID
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ParFUMShadowArray::__idx_unpendForRemote_marshall6,0);
}
 int CkIndex_ParFUMShadowArray::__idx_unpendForRemote_marshall6=0;
void CkIndex_ParFUMShadowArray::_call_unpendForRemote_marshall6(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const RegionID &regionID*/
  PUP::fromMem implP(impl_buf);
  RegionID regionID; implP|regionID;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->unpendForRemote(regionID);
}
int CkIndex_ParFUMShadowArray::_callmarshall_unpendForRemote_marshall6(char* impl_buf,ParFUMShadowArray * impl_obj) {
  /*Unmarshall pup'd fields: const RegionID &regionID*/
  PUP::fromMem implP(impl_buf);
  RegionID regionID; implP|regionID;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->unpendForRemote(regionID);
  return implP.size();
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_unpendForRemote_marshall6(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const RegionID &regionID*/
  PUP::fromMem implP(impl_buf);
  RegionID regionID; implP|regionID;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("regionID");
  implDestP|regionID;
}

/* DEFS: void unlockReply(int remoteChunk, const RegionID &regionID);
 */
void CProxy_ParFUMShadowArray::unlockReply(int remoteChunk, const RegionID &regionID, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int remoteChunk, const RegionID &regionID
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|remoteChunk;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|remoteChunk;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ParFUMShadowArray::__idx_unlockReply_marshall7,0);
}
 int CkIndex_ParFUMShadowArray::__idx_unlockReply_marshall7=0;
void CkIndex_ParFUMShadowArray::_call_unlockReply_marshall7(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int remoteChunk, const RegionID &regionID*/
  PUP::fromMem implP(impl_buf);
  int remoteChunk; implP|remoteChunk;
  RegionID regionID; implP|regionID;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->unlockReply(remoteChunk, regionID);
}
int CkIndex_ParFUMShadowArray::_callmarshall_unlockReply_marshall7(char* impl_buf,ParFUMShadowArray * impl_obj) {
  /*Unmarshall pup'd fields: int remoteChunk, const RegionID &regionID*/
  PUP::fromMem implP(impl_buf);
  int remoteChunk; implP|remoteChunk;
  RegionID regionID; implP|regionID;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->unlockReply(remoteChunk, regionID);
  return implP.size();
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_unlockReply_marshall7(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int remoteChunk, const RegionID &regionID*/
  PUP::fromMem implP(impl_buf);
  int remoteChunk; implP|remoteChunk;
  RegionID regionID; implP|regionID;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("remoteChunk");
  implDestP|remoteChunk;
  if (implDestP.hasComments()) implDestP.comment("regionID");
  implDestP|regionID;
}

/* DEFS: sync adaptAdjMsg* remote_bulk_edge_bisect_2D(const adaptAdj &nbrElem, const adaptAdj &splitElem, int new_idxl, int n1_idxl, int n2_idxl, int partitionID);
 */
 int CkIndex_ParFUMShadowArray::__idx_remote_bulk_edge_bisect_2D_marshall8=0;
void CkIndex_ParFUMShadowArray::_call_remote_bulk_edge_bisect_2D_marshall8(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  int impl_ref = CkGetRefNum(impl_msg), impl_src = CkGetSrcPe(impl_msg);
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const adaptAdj &nbrElem, const adaptAdj &splitElem, int new_idxl, int n1_idxl, int n2_idxl, int partitionID*/
  PUP::fromMem implP(impl_buf);
  adaptAdj nbrElem; implP|nbrElem;
  adaptAdj splitElem; implP|splitElem;
  int new_idxl; implP|new_idxl;
  int n1_idxl; implP|n1_idxl;
  int n2_idxl; implP|n2_idxl;
  int partitionID; implP|partitionID;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  void *impl_retMsg=(void *)   impl_obj->remote_bulk_edge_bisect_2D(nbrElem, splitElem, new_idxl, n1_idxl, n2_idxl, partitionID);
  CkSendToFuture(impl_ref, impl_retMsg, impl_src);
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_remote_bulk_edge_bisect_2D_marshall8(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const adaptAdj &nbrElem, const adaptAdj &splitElem, int new_idxl, int n1_idxl, int n2_idxl, int partitionID*/
  PUP::fromMem implP(impl_buf);
  adaptAdj nbrElem; implP|nbrElem;
  adaptAdj splitElem; implP|splitElem;
  int new_idxl; implP|new_idxl;
  int n1_idxl; implP|n1_idxl;
  int n2_idxl; implP|n2_idxl;
  int partitionID; implP|partitionID;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("nbrElem");
  implDestP|nbrElem;
  if (implDestP.hasComments()) implDestP.comment("splitElem");
  implDestP|splitElem;
  if (implDestP.hasComments()) implDestP.comment("new_idxl");
  implDestP|new_idxl;
  if (implDestP.hasComments()) implDestP.comment("n1_idxl");
  implDestP|n1_idxl;
  if (implDestP.hasComments()) implDestP.comment("n2_idxl");
  implDestP|n2_idxl;
  if (implDestP.hasComments()) implDestP.comment("partitionID");
  implDestP|partitionID;
}

/* DEFS: sync void remote_adaptAdj_replace(const adaptAdj &elem, const adaptAdj &oldElem, const adaptAdj &newElem);
 */
 int CkIndex_ParFUMShadowArray::__idx_remote_adaptAdj_replace_marshall9=0;
void CkIndex_ParFUMShadowArray::_call_remote_adaptAdj_replace_marshall9(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  int impl_ref = CkGetRefNum(impl_msg), impl_src = CkGetSrcPe(impl_msg);
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const adaptAdj &elem, const adaptAdj &oldElem, const adaptAdj &newElem*/
  PUP::fromMem implP(impl_buf);
  adaptAdj elem; implP|elem;
  adaptAdj oldElem; implP|oldElem;
  adaptAdj newElem; implP|newElem;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  void *impl_retMsg=CkAllocSysMsg();
    impl_obj->remote_adaptAdj_replace(elem, oldElem, newElem);
  CkSendToFuture(impl_ref, impl_retMsg, impl_src);
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_remote_adaptAdj_replace_marshall9(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const adaptAdj &elem, const adaptAdj &oldElem, const adaptAdj &newElem*/
  PUP::fromMem implP(impl_buf);
  adaptAdj elem; implP|elem;
  adaptAdj oldElem; implP|oldElem;
  adaptAdj newElem; implP|newElem;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("elem");
  implDestP|elem;
  if (implDestP.hasComments()) implDestP.comment("oldElem");
  implDestP|oldElem;
  if (implDestP.hasComments()) implDestP.comment("newElem");
  implDestP|newElem;
}

/* DEFS: sync void remote_edgeAdj_replace(int remotePartID, const adaptAdj &adj, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl);
 */
 int CkIndex_ParFUMShadowArray::__idx_remote_edgeAdj_replace_marshall10=0;
void CkIndex_ParFUMShadowArray::_call_remote_edgeAdj_replace_marshall10(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  int impl_ref = CkGetRefNum(impl_msg), impl_src = CkGetSrcPe(impl_msg);
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int remotePartID, const adaptAdj &adj, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl*/
  PUP::fromMem implP(impl_buf);
  int remotePartID; implP|remotePartID;
  adaptAdj adj; implP|adj;
  adaptAdj elem; implP|elem;
  adaptAdj splitElem; implP|splitElem;
  int n1_idxl; implP|n1_idxl;
  int n2_idxl; implP|n2_idxl;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  void *impl_retMsg=CkAllocSysMsg();
    impl_obj->remote_edgeAdj_replace(remotePartID, adj, elem, splitElem, n1_idxl, n2_idxl);
  CkSendToFuture(impl_ref, impl_retMsg, impl_src);
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_remote_edgeAdj_replace_marshall10(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int remotePartID, const adaptAdj &adj, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl*/
  PUP::fromMem implP(impl_buf);
  int remotePartID; implP|remotePartID;
  adaptAdj adj; implP|adj;
  adaptAdj elem; implP|elem;
  adaptAdj splitElem; implP|splitElem;
  int n1_idxl; implP|n1_idxl;
  int n2_idxl; implP|n2_idxl;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("remotePartID");
  implDestP|remotePartID;
  if (implDestP.hasComments()) implDestP.comment("adj");
  implDestP|adj;
  if (implDestP.hasComments()) implDestP.comment("elem");
  implDestP|elem;
  if (implDestP.hasComments()) implDestP.comment("splitElem");
  implDestP|splitElem;
  if (implDestP.hasComments()) implDestP.comment("n1_idxl");
  implDestP|n1_idxl;
  if (implDestP.hasComments()) implDestP.comment("n2_idxl");
  implDestP|n2_idxl;
}

/* DEFS: sync void remote_edgeAdj_add(int remotePartID, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl);
 */
 int CkIndex_ParFUMShadowArray::__idx_remote_edgeAdj_add_marshall11=0;
void CkIndex_ParFUMShadowArray::_call_remote_edgeAdj_add_marshall11(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  int impl_ref = CkGetRefNum(impl_msg), impl_src = CkGetSrcPe(impl_msg);
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int remotePartID, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl*/
  PUP::fromMem implP(impl_buf);
  int remotePartID; implP|remotePartID;
  adaptAdj elem; implP|elem;
  adaptAdj splitElem; implP|splitElem;
  int n1_idxl; implP|n1_idxl;
  int n2_idxl; implP|n2_idxl;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  void *impl_retMsg=CkAllocSysMsg();
    impl_obj->remote_edgeAdj_add(remotePartID, elem, splitElem, n1_idxl, n2_idxl);
  CkSendToFuture(impl_ref, impl_retMsg, impl_src);
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_remote_edgeAdj_add_marshall11(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int remotePartID, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl*/
  PUP::fromMem implP(impl_buf);
  int remotePartID; implP|remotePartID;
  adaptAdj elem; implP|elem;
  adaptAdj splitElem; implP|splitElem;
  int n1_idxl; implP|n1_idxl;
  int n2_idxl; implP|n2_idxl;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("remotePartID");
  implDestP|remotePartID;
  if (implDestP.hasComments()) implDestP.comment("elem");
  implDestP|elem;
  if (implDestP.hasComments()) implDestP.comment("splitElem");
  implDestP|splitElem;
  if (implDestP.hasComments()) implDestP.comment("n1_idxl");
  implDestP|n1_idxl;
  if (implDestP.hasComments()) implDestP.comment("n2_idxl");
  implDestP|n2_idxl;
}

/* DEFS: void recv_split_3D(int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem);
 */
void CProxy_ParFUMShadowArray::recv_split_3D(int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|pos;
    implP|tableID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)splitElem;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|pos;
    implP|tableID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)splitElem;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ParFUMShadowArray::__idx_recv_split_3D_marshall12,0);
}
 int CkIndex_ParFUMShadowArray::__idx_recv_split_3D_marshall12=0;
void CkIndex_ParFUMShadowArray::_call_recv_split_3D_marshall12(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem*/
  PUP::fromMem implP(impl_buf);
  int pos; implP|pos;
  int tableID; implP|tableID;
  adaptAdj elem; implP|elem;
  adaptAdj splitElem; implP|splitElem;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->recv_split_3D(pos, tableID, elem, splitElem);
}
int CkIndex_ParFUMShadowArray::_callmarshall_recv_split_3D_marshall12(char* impl_buf,ParFUMShadowArray * impl_obj) {
  /*Unmarshall pup'd fields: int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem*/
  PUP::fromMem implP(impl_buf);
  int pos; implP|pos;
  int tableID; implP|tableID;
  adaptAdj elem; implP|elem;
  adaptAdj splitElem; implP|splitElem;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->recv_split_3D(pos, tableID, elem, splitElem);
  return implP.size();
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_recv_split_3D_marshall12(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem*/
  PUP::fromMem implP(impl_buf);
  int pos; implP|pos;
  int tableID; implP|tableID;
  adaptAdj elem; implP|elem;
  adaptAdj splitElem; implP|splitElem;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("pos");
  implDestP|pos;
  if (implDestP.hasComments()) implDestP.comment("tableID");
  implDestP|tableID;
  if (implDestP.hasComments()) implDestP.comment("elem");
  implDestP|elem;
  if (implDestP.hasComments()) implDestP.comment("splitElem");
  implDestP|splitElem;
}

/* DEFS: void handle_split_3D(int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl);
 */
void CProxy_ParFUMShadowArray::handle_split_3D(int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|remotePartID;
    implP|pos;
    implP|tableID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)lockRegionID;
    implP|n1_idxl;
    implP|n2_idxl;
    implP|n5_idxl;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|remotePartID;
    implP|pos;
    implP|tableID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)lockRegionID;
    implP|n1_idxl;
    implP|n2_idxl;
    implP|n5_idxl;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ParFUMShadowArray::__idx_handle_split_3D_marshall13,0);
}
 int CkIndex_ParFUMShadowArray::__idx_handle_split_3D_marshall13=0;
void CkIndex_ParFUMShadowArray::_call_handle_split_3D_marshall13(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl*/
  PUP::fromMem implP(impl_buf);
  int remotePartID; implP|remotePartID;
  int pos; implP|pos;
  int tableID; implP|tableID;
  adaptAdj elem; implP|elem;
  RegionID lockRegionID; implP|lockRegionID;
  int n1_idxl; implP|n1_idxl;
  int n2_idxl; implP|n2_idxl;
  int n5_idxl; implP|n5_idxl;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->handle_split_3D(remotePartID, pos, tableID, elem, lockRegionID, n1_idxl, n2_idxl, n5_idxl);
}
int CkIndex_ParFUMShadowArray::_callmarshall_handle_split_3D_marshall13(char* impl_buf,ParFUMShadowArray * impl_obj) {
  /*Unmarshall pup'd fields: int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl*/
  PUP::fromMem implP(impl_buf);
  int remotePartID; implP|remotePartID;
  int pos; implP|pos;
  int tableID; implP|tableID;
  adaptAdj elem; implP|elem;
  RegionID lockRegionID; implP|lockRegionID;
  int n1_idxl; implP|n1_idxl;
  int n2_idxl; implP|n2_idxl;
  int n5_idxl; implP|n5_idxl;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->handle_split_3D(remotePartID, pos, tableID, elem, lockRegionID, n1_idxl, n2_idxl, n5_idxl);
  return implP.size();
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_handle_split_3D_marshall13(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl*/
  PUP::fromMem implP(impl_buf);
  int remotePartID; implP|remotePartID;
  int pos; implP|pos;
  int tableID; implP|tableID;
  adaptAdj elem; implP|elem;
  RegionID lockRegionID; implP|lockRegionID;
  int n1_idxl; implP|n1_idxl;
  int n2_idxl; implP|n2_idxl;
  int n5_idxl; implP|n5_idxl;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("remotePartID");
  implDestP|remotePartID;
  if (implDestP.hasComments()) implDestP.comment("pos");
  implDestP|pos;
  if (implDestP.hasComments()) implDestP.comment("tableID");
  implDestP|tableID;
  if (implDestP.hasComments()) implDestP.comment("elem");
  implDestP|elem;
  if (implDestP.hasComments()) implDestP.comment("lockRegionID");
  implDestP|lockRegionID;
  if (implDestP.hasComments()) implDestP.comment("n1_idxl");
  implDestP|n1_idxl;
  if (implDestP.hasComments()) implDestP.comment("n2_idxl");
  implDestP|n2_idxl;
  if (implDestP.hasComments()) implDestP.comment("n5_idxl");
  implDestP|n5_idxl;
}

/* DEFS: threaded sync void recv_splits(int tableID, int expectedSplits);
 */
 int CkIndex_ParFUMShadowArray::__idx_recv_splits_marshall14=0;
void CkIndex_ParFUMShadowArray::_call_recv_splits_marshall14(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  CthThread tid = CthCreate((CthVoidFn)_callthr_recv_splits_marshall14, new CkThrCallArg(impl_msg,impl_obj), 0);
  ((Chare *)impl_obj)->CkAddThreadListeners(tid,impl_msg);
  BgAttach(tid);
  CthAwaken(tid);
}
void CkIndex_ParFUMShadowArray::_callthr_recv_splits_marshall14(CkThrCallArg *impl_arg)
{
  void *impl_msg = impl_arg->msg;
  ParFUMShadowArray *impl_obj = (ParFUMShadowArray *) impl_arg->obj;
  delete impl_arg;
  int impl_ref = CkGetRefNum(impl_msg), impl_src = CkGetSrcPe(impl_msg);
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int tableID, int expectedSplits*/
  PUP::fromMem implP(impl_buf);
  int tableID; implP|tableID;
  int expectedSplits; implP|expectedSplits;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  void *impl_retMsg=CkAllocSysMsg();
    impl_obj->recv_splits(tableID, expectedSplits);
  CkSendToFuture(impl_ref, impl_retMsg, impl_src);
  delete impl_msg_typed;
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_recv_splits_marshall14(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int tableID, int expectedSplits*/
  PUP::fromMem implP(impl_buf);
  int tableID; implP|tableID;
  int expectedSplits; implP|expectedSplits;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("tableID");
  implDestP|tableID;
  if (implDestP.hasComments()) implDestP.comment("expectedSplits");
  implDestP|expectedSplits;
}

/* DEFS: sync longestMsg* isLongest(int elem, int elemType, double len);
 */
 int CkIndex_ParFUMShadowArray::__idx_isLongest_marshall15=0;
void CkIndex_ParFUMShadowArray::_call_isLongest_marshall15(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  int impl_ref = CkGetRefNum(impl_msg), impl_src = CkGetSrcPe(impl_msg);
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int elem, int elemType, double len*/
  PUP::fromMem implP(impl_buf);
  int elem; implP|elem;
  int elemType; implP|elemType;
  double len; implP|len;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  void *impl_retMsg=(void *)   impl_obj->isLongest(elem, elemType, len);
  CkSendToFuture(impl_ref, impl_retMsg, impl_src);
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_isLongest_marshall15(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int elem, int elemType, double len*/
  PUP::fromMem implP(impl_buf);
  int elem; implP|elem;
  int elemType; implP|elemType;
  double len; implP|len;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("elem");
  implDestP|elem;
  if (implDestP.hasComments()) implDestP.comment("elemType");
  implDestP|elemType;
  if (implDestP.hasComments()) implDestP.comment("len");
  implDestP|len;
}

/* DEFS: void update_asterisk_3D(int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl);
 */
void CProxy_ParFUMShadowArray::update_asterisk_3D(int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_elemPairs, impl_cnt_elemPairs;
  impl_off_elemPairs=impl_off=CK_ALIGN(impl_off,sizeof(adaptAdj));
  impl_off+=(impl_cnt_elemPairs=sizeof(adaptAdj)*(2*numElemPairs));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|remotePartID;
    implP|i;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    implP|numElemPairs;
    implP|impl_off_elemPairs;
    implP|impl_cnt_elemPairs;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)lockRegionID;
    implP|n1_idxl;
    implP|n2_idxl;
    implP|n5_idxl;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|remotePartID;
    implP|i;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    implP|numElemPairs;
    implP|impl_off_elemPairs;
    implP|impl_cnt_elemPairs;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)lockRegionID;
    implP|n1_idxl;
    implP|n2_idxl;
    implP|n5_idxl;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_elemPairs,elemPairs,impl_cnt_elemPairs);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ParFUMShadowArray::__idx_update_asterisk_3D_marshall16,0);
}
 int CkIndex_ParFUMShadowArray::__idx_update_asterisk_3D_marshall16=0;
void CkIndex_ParFUMShadowArray::_call_update_asterisk_3D_marshall16(void* impl_msg,ParFUMShadowArray * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl*/
  PUP::fromMem implP(impl_buf);
  int remotePartID; implP|remotePartID;
  int i; implP|i;
  adaptAdj elem; implP|elem;
  int numElemPairs; implP|numElemPairs;
  int impl_off_elemPairs, impl_cnt_elemPairs; 
  implP|impl_off_elemPairs;
  implP|impl_cnt_elemPairs;
  RegionID lockRegionID; implP|lockRegionID;
  int n1_idxl; implP|n1_idxl;
  int n2_idxl; implP|n2_idxl;
  int n5_idxl; implP|n5_idxl;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  adaptAdj *elemPairs=(adaptAdj *)(impl_buf+impl_off_elemPairs);
  impl_obj->update_asterisk_3D(remotePartID, i, elem, numElemPairs, elemPairs, lockRegionID, n1_idxl, n2_idxl, n5_idxl);
}
int CkIndex_ParFUMShadowArray::_callmarshall_update_asterisk_3D_marshall16(char* impl_buf,ParFUMShadowArray * impl_obj) {
  /*Unmarshall pup'd fields: int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl*/
  PUP::fromMem implP(impl_buf);
  int remotePartID; implP|remotePartID;
  int i; implP|i;
  adaptAdj elem; implP|elem;
  int numElemPairs; implP|numElemPairs;
  int impl_off_elemPairs, impl_cnt_elemPairs; 
  implP|impl_off_elemPairs;
  implP|impl_cnt_elemPairs;
  RegionID lockRegionID; implP|lockRegionID;
  int n1_idxl; implP|n1_idxl;
  int n2_idxl; implP|n2_idxl;
  int n5_idxl; implP|n5_idxl;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  adaptAdj *elemPairs=(adaptAdj *)(impl_buf+impl_off_elemPairs);
  impl_obj->update_asterisk_3D(remotePartID, i, elem, numElemPairs, elemPairs, lockRegionID, n1_idxl, n2_idxl, n5_idxl);
  return implP.size();
}
void CkIndex_ParFUMShadowArray::_marshallmessagepup_update_asterisk_3D_marshall16(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl*/
  PUP::fromMem implP(impl_buf);
  int remotePartID; implP|remotePartID;
  int i; implP|i;
  adaptAdj elem; implP|elem;
  int numElemPairs; implP|numElemPairs;
  int impl_off_elemPairs, impl_cnt_elemPairs; 
  implP|impl_off_elemPairs;
  implP|impl_cnt_elemPairs;
  RegionID lockRegionID; implP|lockRegionID;
  int n1_idxl; implP|n1_idxl;
  int n2_idxl; implP|n2_idxl;
  int n5_idxl; implP|n5_idxl;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  adaptAdj *elemPairs=(adaptAdj *)(impl_buf+impl_off_elemPairs);
  if (implDestP.hasComments()) implDestP.comment("remotePartID");
  implDestP|remotePartID;
  if (implDestP.hasComments()) implDestP.comment("i");
  implDestP|i;
  if (implDestP.hasComments()) implDestP.comment("elem");
  implDestP|elem;
  if (implDestP.hasComments()) implDestP.comment("numElemPairs");
  implDestP|numElemPairs;
  if (implDestP.hasComments()) implDestP.comment("elemPairs");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*elemPairs))<impl_cnt_elemPairs;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|elemPairs[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("lockRegionID");
  implDestP|lockRegionID;
  if (implDestP.hasComments()) implDestP.comment("n1_idxl");
  implDestP|n1_idxl;
  if (implDestP.hasComments()) implDestP.comment("n2_idxl");
  implDestP|n2_idxl;
  if (implDestP.hasComments()) implDestP.comment("n5_idxl");
  implDestP|n5_idxl;
}

/* DEFS: ParFUMShadowArray(CkMigrateMessage* impl_msg);
 */

/* DEFS: ParFUMShadowArray(int s, int i);
 */

/* DEFS: void setFemMesh(FEMMeshMsg* impl_msg);
 */
void CProxySection_ParFUMShadowArray::setFemMesh(FEMMeshMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_setFemMesh_FEMMeshMsg,0);
}

/* DEFS: void lockRegionForRemote(const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements);
 */
void CProxySection_ParFUMShadowArray::lockRegionForRemote(const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_sharedIdxls, impl_cnt_sharedIdxls;
  impl_off_sharedIdxls=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_sharedIdxls=sizeof(int)*(numSharedIdxls));
  int impl_off_elements, impl_cnt_elements;
  impl_off_elements=impl_off=CK_ALIGN(impl_off,sizeof(adaptAdj));
  impl_off+=(impl_cnt_elements=sizeof(adaptAdj)*(numElements));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    implP|impl_off_sharedIdxls;
    implP|impl_cnt_sharedIdxls;
    implP|numSharedIdxls;
    implP|impl_off_elements;
    implP|impl_cnt_elements;
    implP|numElements;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    implP|impl_off_sharedIdxls;
    implP|impl_cnt_sharedIdxls;
    implP|numSharedIdxls;
    implP|impl_off_elements;
    implP|impl_cnt_elements;
    implP|numElements;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_sharedIdxls,sharedIdxls,impl_cnt_sharedIdxls);
  memcpy(impl_buf+impl_off_elements,elements,impl_cnt_elements);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_lockRegionForRemote_marshall3,0);
}

/* DEFS: void lockReply(int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess);
 */
void CProxySection_ParFUMShadowArray::lockReply(int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|remoteChunk;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    //Have to cast away const-ness to get pup routine
    implP|(bool &)success;
    implP|tag;
    implP|otherSuccess;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|remoteChunk;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    //Have to cast away const-ness to get pup routine
    implP|(bool &)success;
    implP|tag;
    implP|otherSuccess;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_lockReply_marshall4,0);
}

/* DEFS: void unlockForRemote(const RegionID &regionID);
 */
void CProxySection_ParFUMShadowArray::unlockForRemote(const RegionID &regionID, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const RegionID &regionID
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_unlockForRemote_marshall5,0);
}

/* DEFS: void unpendForRemote(const RegionID &regionID);
 */
void CProxySection_ParFUMShadowArray::unpendForRemote(const RegionID &regionID, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const RegionID &regionID
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_unpendForRemote_marshall6,0);
}

/* DEFS: void unlockReply(int remoteChunk, const RegionID &regionID);
 */
void CProxySection_ParFUMShadowArray::unlockReply(int remoteChunk, const RegionID &regionID, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int remoteChunk, const RegionID &regionID
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|remoteChunk;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|remoteChunk;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)regionID;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_unlockReply_marshall7,0);
}

/* DEFS: sync adaptAdjMsg* remote_bulk_edge_bisect_2D(const adaptAdj &nbrElem, const adaptAdj &splitElem, int new_idxl, int n1_idxl, int n2_idxl, int partitionID);
 */

/* DEFS: sync void remote_adaptAdj_replace(const adaptAdj &elem, const adaptAdj &oldElem, const adaptAdj &newElem);
 */

/* DEFS: sync void remote_edgeAdj_replace(int remotePartID, const adaptAdj &adj, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl);
 */

/* DEFS: sync void remote_edgeAdj_add(int remotePartID, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl);
 */

/* DEFS: void recv_split_3D(int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem);
 */
void CProxySection_ParFUMShadowArray::recv_split_3D(int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|pos;
    implP|tableID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)splitElem;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|pos;
    implP|tableID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)splitElem;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_recv_split_3D_marshall12,0);
}

/* DEFS: void handle_split_3D(int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl);
 */
void CProxySection_ParFUMShadowArray::handle_split_3D(int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|remotePartID;
    implP|pos;
    implP|tableID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)lockRegionID;
    implP|n1_idxl;
    implP|n2_idxl;
    implP|n5_idxl;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|remotePartID;
    implP|pos;
    implP|tableID;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)lockRegionID;
    implP|n1_idxl;
    implP|n2_idxl;
    implP|n5_idxl;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_handle_split_3D_marshall13,0);
}

/* DEFS: threaded sync void recv_splits(int tableID, int expectedSplits);
 */

/* DEFS: sync longestMsg* isLongest(int elem, int elemType, double len);
 */

/* DEFS: void update_asterisk_3D(int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl);
 */
void CProxySection_ParFUMShadowArray::update_asterisk_3D(int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_elemPairs, impl_cnt_elemPairs;
  impl_off_elemPairs=impl_off=CK_ALIGN(impl_off,sizeof(adaptAdj));
  impl_off+=(impl_cnt_elemPairs=sizeof(adaptAdj)*(2*numElemPairs));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|remotePartID;
    implP|i;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    implP|numElemPairs;
    implP|impl_off_elemPairs;
    implP|impl_cnt_elemPairs;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)lockRegionID;
    implP|n1_idxl;
    implP|n2_idxl;
    implP|n5_idxl;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|remotePartID;
    implP|i;
    //Have to cast away const-ness to get pup routine
    implP|(adaptAdj &)elem;
    implP|numElemPairs;
    implP|impl_off_elemPairs;
    implP|impl_cnt_elemPairs;
    //Have to cast away const-ness to get pup routine
    implP|(RegionID &)lockRegionID;
    implP|n1_idxl;
    implP|n2_idxl;
    implP|n5_idxl;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_elemPairs,elemPairs,impl_cnt_elemPairs);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ParFUMShadowArray::__idx_update_asterisk_3D_marshall16,0);
}

#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_ParFUMShadowArray::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeArray);
  CkRegisterBase(__idx, CkIndex_ArrayElement::__idx);
// REG: ParFUMShadowArray(CkMigrateMessage* impl_msg);
  __idx_ParFUMShadowArray_CkMigrateMessage = CkRegisterEp("ParFUMShadowArray(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_ParFUMShadowArray_CkMigrateMessage, 0, __idx, 0);
  CkRegisterMigCtor(__idx, __idx_ParFUMShadowArray_CkMigrateMessage);

// REG: ParFUMShadowArray(int s, int i);
  __idx_ParFUMShadowArray_marshall1 = CkRegisterEp("ParFUMShadowArray(int s, int i)",
     (CkCallFnPtr)_call_ParFUMShadowArray_marshall1, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_ParFUMShadowArray_marshall1,(CkMarshallUnpackFn)_callmarshall_ParFUMShadowArray_marshall1);
  CkRegisterMessagePupFn(__idx_ParFUMShadowArray_marshall1,(CkMessagePupFn)_marshallmessagepup_ParFUMShadowArray_marshall1);

// REG: void setFemMesh(FEMMeshMsg* impl_msg);
  __idx_setFemMesh_FEMMeshMsg = CkRegisterEp("setFemMesh(FEMMeshMsg* impl_msg)",
     (CkCallFnPtr)_call_setFemMesh_FEMMeshMsg, CMessage_FEMMeshMsg::__idx, __idx, 0);

// REG: void lockRegionForRemote(const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements);
  __idx_lockRegionForRemote_marshall3 = CkRegisterEp("lockRegionForRemote(const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements)",
     (CkCallFnPtr)_call_lockRegionForRemote_marshall3, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_lockRegionForRemote_marshall3,(CkMarshallUnpackFn)_callmarshall_lockRegionForRemote_marshall3);
  CkRegisterMessagePupFn(__idx_lockRegionForRemote_marshall3,(CkMessagePupFn)_marshallmessagepup_lockRegionForRemote_marshall3);

// REG: void lockReply(int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess);
  __idx_lockReply_marshall4 = CkRegisterEp("lockReply(int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess)",
     (CkCallFnPtr)_call_lockReply_marshall4, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_lockReply_marshall4,(CkMarshallUnpackFn)_callmarshall_lockReply_marshall4);
  CkRegisterMessagePupFn(__idx_lockReply_marshall4,(CkMessagePupFn)_marshallmessagepup_lockReply_marshall4);

// REG: void unlockForRemote(const RegionID &regionID);
  __idx_unlockForRemote_marshall5 = CkRegisterEp("unlockForRemote(const RegionID &regionID)",
     (CkCallFnPtr)_call_unlockForRemote_marshall5, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_unlockForRemote_marshall5,(CkMarshallUnpackFn)_callmarshall_unlockForRemote_marshall5);
  CkRegisterMessagePupFn(__idx_unlockForRemote_marshall5,(CkMessagePupFn)_marshallmessagepup_unlockForRemote_marshall5);

// REG: void unpendForRemote(const RegionID &regionID);
  __idx_unpendForRemote_marshall6 = CkRegisterEp("unpendForRemote(const RegionID &regionID)",
     (CkCallFnPtr)_call_unpendForRemote_marshall6, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_unpendForRemote_marshall6,(CkMarshallUnpackFn)_callmarshall_unpendForRemote_marshall6);
  CkRegisterMessagePupFn(__idx_unpendForRemote_marshall6,(CkMessagePupFn)_marshallmessagepup_unpendForRemote_marshall6);

// REG: void unlockReply(int remoteChunk, const RegionID &regionID);
  __idx_unlockReply_marshall7 = CkRegisterEp("unlockReply(int remoteChunk, const RegionID &regionID)",
     (CkCallFnPtr)_call_unlockReply_marshall7, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_unlockReply_marshall7,(CkMarshallUnpackFn)_callmarshall_unlockReply_marshall7);
  CkRegisterMessagePupFn(__idx_unlockReply_marshall7,(CkMessagePupFn)_marshallmessagepup_unlockReply_marshall7);

// REG: sync adaptAdjMsg* remote_bulk_edge_bisect_2D(const adaptAdj &nbrElem, const adaptAdj &splitElem, int new_idxl, int n1_idxl, int n2_idxl, int partitionID);
  __idx_remote_bulk_edge_bisect_2D_marshall8 = CkRegisterEp("remote_bulk_edge_bisect_2D(const adaptAdj &nbrElem, const adaptAdj &splitElem, int new_idxl, int n1_idxl, int n2_idxl, int partitionID)",
     (CkCallFnPtr)_call_remote_bulk_edge_bisect_2D_marshall8, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMessagePupFn(__idx_remote_bulk_edge_bisect_2D_marshall8,(CkMessagePupFn)_marshallmessagepup_remote_bulk_edge_bisect_2D_marshall8);

// REG: sync void remote_adaptAdj_replace(const adaptAdj &elem, const adaptAdj &oldElem, const adaptAdj &newElem);
  __idx_remote_adaptAdj_replace_marshall9 = CkRegisterEp("remote_adaptAdj_replace(const adaptAdj &elem, const adaptAdj &oldElem, const adaptAdj &newElem)",
     (CkCallFnPtr)_call_remote_adaptAdj_replace_marshall9, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMessagePupFn(__idx_remote_adaptAdj_replace_marshall9,(CkMessagePupFn)_marshallmessagepup_remote_adaptAdj_replace_marshall9);

// REG: sync void remote_edgeAdj_replace(int remotePartID, const adaptAdj &adj, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl);
  __idx_remote_edgeAdj_replace_marshall10 = CkRegisterEp("remote_edgeAdj_replace(int remotePartID, const adaptAdj &adj, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl)",
     (CkCallFnPtr)_call_remote_edgeAdj_replace_marshall10, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMessagePupFn(__idx_remote_edgeAdj_replace_marshall10,(CkMessagePupFn)_marshallmessagepup_remote_edgeAdj_replace_marshall10);

// REG: sync void remote_edgeAdj_add(int remotePartID, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl);
  __idx_remote_edgeAdj_add_marshall11 = CkRegisterEp("remote_edgeAdj_add(int remotePartID, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl)",
     (CkCallFnPtr)_call_remote_edgeAdj_add_marshall11, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMessagePupFn(__idx_remote_edgeAdj_add_marshall11,(CkMessagePupFn)_marshallmessagepup_remote_edgeAdj_add_marshall11);

// REG: void recv_split_3D(int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem);
  __idx_recv_split_3D_marshall12 = CkRegisterEp("recv_split_3D(int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem)",
     (CkCallFnPtr)_call_recv_split_3D_marshall12, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_recv_split_3D_marshall12,(CkMarshallUnpackFn)_callmarshall_recv_split_3D_marshall12);
  CkRegisterMessagePupFn(__idx_recv_split_3D_marshall12,(CkMessagePupFn)_marshallmessagepup_recv_split_3D_marshall12);

// REG: void handle_split_3D(int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl);
  __idx_handle_split_3D_marshall13 = CkRegisterEp("handle_split_3D(int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl)",
     (CkCallFnPtr)_call_handle_split_3D_marshall13, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_handle_split_3D_marshall13,(CkMarshallUnpackFn)_callmarshall_handle_split_3D_marshall13);
  CkRegisterMessagePupFn(__idx_handle_split_3D_marshall13,(CkMessagePupFn)_marshallmessagepup_handle_split_3D_marshall13);

// REG: threaded sync void recv_splits(int tableID, int expectedSplits);
  __idx_recv_splits_marshall14 = CkRegisterEp("recv_splits(int tableID, int expectedSplits)",
     (CkCallFnPtr)_call_recv_splits_marshall14, CkMarshallMsg::__idx, __idx, 0);
  CkRegisterMessagePupFn(__idx_recv_splits_marshall14,(CkMessagePupFn)_marshallmessagepup_recv_splits_marshall14);

// REG: sync longestMsg* isLongest(int elem, int elemType, double len);
  __idx_isLongest_marshall15 = CkRegisterEp("isLongest(int elem, int elemType, double len)",
     (CkCallFnPtr)_call_isLongest_marshall15, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMessagePupFn(__idx_isLongest_marshall15,(CkMessagePupFn)_marshallmessagepup_isLongest_marshall15);

// REG: void update_asterisk_3D(int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl);
  __idx_update_asterisk_3D_marshall16 = CkRegisterEp("update_asterisk_3D(int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl)",
     (CkCallFnPtr)_call_update_asterisk_3D_marshall16, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_update_asterisk_3D_marshall16,(CkMarshallUnpackFn)_callmarshall_update_asterisk_3D_marshall16);
  CkRegisterMessagePupFn(__idx_update_asterisk_3D_marshall16,(CkMessagePupFn)_marshallmessagepup_update_asterisk_3D_marshall16);

}
#endif

#ifndef CK_TEMPLATES_ONLY
void _registerParFUM_SA(void)
{
  static int _done = 0; if(_done) return; _done = 1;
  CkRegisterReadonly("meshSA","CProxy_ParFUMShadowArray",sizeof(meshSA),(void *) &meshSA,__xlater_roPup_meshSA);

/* REG: message lockChunksMsg{
int chkList[];
}
;
*/
CMessage_lockChunksMsg::__register("lockChunksMsg", sizeof(lockChunksMsg),(CkPackFnPtr) lockChunksMsg::pack,(CkUnpackFnPtr) lockChunksMsg::unpack);

/* REG: message adaptAdjMsg;
*/
CMessage_adaptAdjMsg::__register("adaptAdjMsg", sizeof(adaptAdjMsg),(CkPackFnPtr) adaptAdjMsg::pack,(CkUnpackFnPtr) adaptAdjMsg::unpack);

/* REG: message longestMsg;
*/
CMessage_longestMsg::__register("longestMsg", sizeof(longestMsg),(CkPackFnPtr) longestMsg::pack,(CkUnpackFnPtr) longestMsg::unpack);

/* REG: array ParFUMShadowArray: ArrayElement{
ParFUMShadowArray(CkMigrateMessage* impl_msg);
ParFUMShadowArray(int s, int i);
void setFemMesh(FEMMeshMsg* impl_msg);
void lockRegionForRemote(const RegionID &regionID, const int *sharedIdxls, int numSharedIdxls, const adaptAdj *elements, int numElements);
void lockReply(int remoteChunk, const RegionID &regionID, const bool &success, int tag, int otherSuccess);
void unlockForRemote(const RegionID &regionID);
void unpendForRemote(const RegionID &regionID);
void unlockReply(int remoteChunk, const RegionID &regionID);
sync adaptAdjMsg* remote_bulk_edge_bisect_2D(const adaptAdj &nbrElem, const adaptAdj &splitElem, int new_idxl, int n1_idxl, int n2_idxl, int partitionID);
sync void remote_adaptAdj_replace(const adaptAdj &elem, const adaptAdj &oldElem, const adaptAdj &newElem);
sync void remote_edgeAdj_replace(int remotePartID, const adaptAdj &adj, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl);
sync void remote_edgeAdj_add(int remotePartID, const adaptAdj &elem, const adaptAdj &splitElem, int n1_idxl, int n2_idxl);
void recv_split_3D(int pos, int tableID, const adaptAdj &elem, const adaptAdj &splitElem);
void handle_split_3D(int remotePartID, int pos, int tableID, const adaptAdj &elem, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl);
threaded sync void recv_splits(int tableID, int expectedSplits);
sync longestMsg* isLongest(int elem, int elemType, double len);
void update_asterisk_3D(int remotePartID, int i, const adaptAdj &elem, int numElemPairs, const adaptAdj *elemPairs, const RegionID &lockRegionID, int n1_idxl, int n2_idxl, int n5_idxl);
};
*/
  CkIndex_ParFUMShadowArray::__register("ParFUMShadowArray", sizeof(ParFUMShadowArray));

}
#endif
