/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.tool;

import antlr.Token;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.antlr.tool.Attribute;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;

public class AttributeScope {
    public static AttributeScope tokenScope = new AttributeScope("Token", null);
    public Token derivedFromToken;
    public Grammar grammar;
    private String name;
    public boolean isDynamicGlobalScope;
    public boolean isDynamicRuleScope;
    public boolean isParameterScope;
    public boolean isReturnScope;
    public boolean isPredefinedRuleScope;
    public boolean isPredefinedLexerRuleScope;
    protected LinkedHashMap attributes = new LinkedHashMap();

    public AttributeScope(String string, Token token) {
        this(null, string, token);
    }

    public AttributeScope(Grammar grammar, String string, Token token) {
        this.grammar = grammar;
        this.name = string;
        this.derivedFromToken = token;
    }

    public String getName() {
        if (this.isParameterScope) {
            return this.name + "_parameter";
        }
        if (this.isReturnScope) {
            return this.name + "_return";
        }
        return this.name;
    }

    public void addAttributes(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreElements()) {
            String string3 = (String)stringTokenizer.nextElement();
            if ((string3 = string3.trim()).length() == 0) break;
            Attribute attribute = new Attribute(string3);
            if (!this.isReturnScope && attribute.initValue != null) {
                ErrorManager.grammarError(148, this.grammar, this.derivedFromToken, attribute.name);
                attribute.initValue = null;
            }
            this.attributes.put(attribute.name, attribute);
        }
    }

    public void addAttribute(String string, String string2) {
        this.attributes.put(string, new Attribute(string, string2));
    }

    public Attribute getAttribute(String string) {
        return (Attribute)this.attributes.get(string);
    }

    public List getAttributes() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.attributes.values());
        return arrayList;
    }

    public Set intersection(AttributeScope attributeScope) {
        if (attributeScope == null || attributeScope.size() == 0 || this.size() == 0) {
            return null;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Set set = this.attributes.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (attributeScope.attributes.get(string) == null) continue;
            hashSet.add(string);
        }
        if (hashSet.size() == 0) {
            return null;
        }
        return hashSet;
    }

    public int size() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public String toString() {
        return (this.isDynamicGlobalScope ? "global " : "") + this.getName() + ":" + this.attributes;
    }

    static {
        tokenScope.addAttribute("text", null);
        tokenScope.addAttribute("type", null);
        tokenScope.addAttribute("line", null);
        tokenScope.addAttribute("index", null);
        tokenScope.addAttribute("pos", null);
        tokenScope.addAttribute("channel", null);
        tokenScope.addAttribute("tree", null);
    }
}

