/* DEFS: message AmpiMsg{
char data[];
}
;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_AmpiMsg::operator new(size_t s){
  return AmpiMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_AmpiMsg::operator new(size_t s, int* sz){
  return AmpiMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_AmpiMsg::operator new(size_t s, int* sz,const int pb){
  return AmpiMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_AmpiMsg::operator new(size_t s, int sz0) {
  int sizes[1];
  sizes[0] = sz0;
  return AmpiMsg::alloc(__idx, s, sizes, 0);
}
void *CMessage_AmpiMsg::operator new(size_t s, int sz0, const int p) {
  int sizes[1];
  sizes[0] = sz0;
  return AmpiMsg::alloc(__idx, s, sizes, p);
}
void* CMessage_AmpiMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  size_t offsets[2];
  offsets[0] = ALIGN8(sz);
  if(sizes==0)
    offsets[1] = offsets[0];
  else
    offsets[1] = offsets[0] + ALIGN8(sizeof(char)*sizes[0]);
  AmpiMsg *newmsg = (AmpiMsg *) CkAllocMsg(msgnum, offsets[1], pb);
  newmsg->data = (char *) ((char *)newmsg + offsets[0]);
  return (void *) newmsg;
}
void CMessage_AmpiMsg::dealloc(void *p) {
  CkFreeMsg(p);
}
void* CMessage_AmpiMsg::pack(AmpiMsg *msg) {
  msg->data = (char *) ((char *)msg->data - (char *)msg);
  return (void *) msg;
}
AmpiMsg* CMessage_AmpiMsg::unpack(void* buf) {
  AmpiMsg *msg = (AmpiMsg *) buf;
  msg->data = (char *) ((size_t)msg->data + (char *)msg);
  return msg;
}
int CMessage_AmpiMsg::__idx=0;
#endif



/* DEFS: array ampiParent: ArrayElement{
ampiParent(CkMigrateMessage* impl_msg);
ampiParent(int universeNo, const CProxy_TCharm &threads_);
void ResumeThread(void);
void Checkpoint(int len, const char *dname);
void ExchangeProxy(const CProxy_ampi &impl_noname_0);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_ampiParent::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: ampiParent(CkMigrateMessage* impl_msg);
 */

/* DEFS: ampiParent(int universeNo, const CProxy_TCharm &threads_);
 */
void CProxyElement_ampiParent::insert(int universeNo, const CProxy_TCharm &threads_, int onPE, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: int universeNo, const CProxy_TCharm &threads_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|universeNo;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_TCharm &)threads_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|universeNo;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_TCharm &)threads_;
  }
   ckInsert((CkArrayMessage *)impl_msg,CkIndex_ampiParent::__idx_ampiParent_marshall1,onPE);
}

/* DEFS: void ResumeThread(void);
 */
void CProxyElement_ampiParent::ResumeThread(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampiParent::__idx_ResumeThread_void,0);
}

/* DEFS: void Checkpoint(int len, const char *dname);
 */
void CProxyElement_ampiParent::Checkpoint(int len, const char *dname, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int len, const char *dname
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_dname, impl_cnt_dname;
  impl_off_dname=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_dname=sizeof(char)*(len));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|len;
    implP|impl_off_dname;
    implP|impl_cnt_dname;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|len;
    implP|impl_off_dname;
    implP|impl_cnt_dname;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_dname,dname,impl_cnt_dname);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampiParent::__idx_Checkpoint_marshall3,0);
}

/* DEFS: void ExchangeProxy(const CProxy_ampi &impl_noname_0);
 */
void CProxyElement_ampiParent::ExchangeProxy(const CProxy_ampi &impl_noname_0, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CProxy_ampi &impl_noname_0
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_ampi &)impl_noname_0;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_ampi &)impl_noname_0;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampiParent::__idx_ExchangeProxy_marshall4,0);
}

/* DEFS: ampiParent(CkMigrateMessage* impl_msg);
 */
 int CkIndex_ampiParent::__idx_ampiParent_CkMigrateMessage=0;
void CkIndex_ampiParent::_call_ampiParent_CkMigrateMessage(void* impl_msg,ampiParent * impl_obj)
{
  new (impl_obj) ampiParent((CkMigrateMessage*)impl_msg);
}

/* DEFS: ampiParent(int universeNo, const CProxy_TCharm &threads_);
 */
CkArrayID CProxy_ampiParent::ckNew(int universeNo, const CProxy_TCharm &threads_, const CkArrayOptions &opts, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: int universeNo, const CProxy_TCharm &threads_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|universeNo;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_TCharm &)threads_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|universeNo;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_TCharm &)threads_;
  }
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_ampiParent::__idx_ampiParent_marshall1,opts);
}
CkArrayID CProxy_ampiParent::ckNew(int universeNo, const CProxy_TCharm &threads_, const int s1, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: int universeNo, const CProxy_TCharm &threads_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|universeNo;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_TCharm &)threads_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|universeNo;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_TCharm &)threads_;
  }
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_ampiParent::__idx_ampiParent_marshall1,CkArrayOptions(s1));
}
 int CkIndex_ampiParent::__idx_ampiParent_marshall1=0;
void CkIndex_ampiParent::_call_ampiParent_marshall1(void* impl_msg,ampiParent * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int universeNo, const CProxy_TCharm &threads_*/
  PUP::fromMem implP(impl_buf);
  int universeNo; implP|universeNo;
  CProxy_TCharm threads_; implP|threads_;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) ampiParent(universeNo, threads_);
}
int CkIndex_ampiParent::_callmarshall_ampiParent_marshall1(char* impl_buf,ampiParent * impl_obj) {
  /*Unmarshall pup'd fields: int universeNo, const CProxy_TCharm &threads_*/
  PUP::fromMem implP(impl_buf);
  int universeNo; implP|universeNo;
  CProxy_TCharm threads_; implP|threads_;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) ampiParent(universeNo, threads_);
  return implP.size();
}
void CkIndex_ampiParent::_marshallmessagepup_ampiParent_marshall1(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int universeNo, const CProxy_TCharm &threads_*/
  PUP::fromMem implP(impl_buf);
  int universeNo; implP|universeNo;
  CProxy_TCharm threads_; implP|threads_;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("universeNo");
  implDestP|universeNo;
  if (implDestP.hasComments()) implDestP.comment("threads_");
  implDestP|threads_;
}

/* DEFS: void ResumeThread(void);
 */
void CProxy_ampiParent::ResumeThread(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampiParent::__idx_ResumeThread_void,0);
}
 int CkIndex_ampiParent::__idx_ResumeThread_void=0;
void CkIndex_ampiParent::_call_ResumeThread_void(void* impl_msg,ampiParent * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->ResumeThread();
}

/* DEFS: void Checkpoint(int len, const char *dname);
 */
void CProxy_ampiParent::Checkpoint(int len, const char *dname, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int len, const char *dname
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_dname, impl_cnt_dname;
  impl_off_dname=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_dname=sizeof(char)*(len));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|len;
    implP|impl_off_dname;
    implP|impl_cnt_dname;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|len;
    implP|impl_off_dname;
    implP|impl_cnt_dname;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_dname,dname,impl_cnt_dname);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampiParent::__idx_Checkpoint_marshall3,0);
}
 int CkIndex_ampiParent::__idx_Checkpoint_marshall3=0;
void CkIndex_ampiParent::_call_Checkpoint_marshall3(void* impl_msg,ampiParent * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int len, const char *dname*/
  PUP::fromMem implP(impl_buf);
  int len; implP|len;
  int impl_off_dname, impl_cnt_dname; 
  implP|impl_off_dname;
  implP|impl_cnt_dname;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *dname=(char *)(impl_buf+impl_off_dname);
  impl_obj->Checkpoint(len, dname);
}
int CkIndex_ampiParent::_callmarshall_Checkpoint_marshall3(char* impl_buf,ampiParent * impl_obj) {
  /*Unmarshall pup'd fields: int len, const char *dname*/
  PUP::fromMem implP(impl_buf);
  int len; implP|len;
  int impl_off_dname, impl_cnt_dname; 
  implP|impl_off_dname;
  implP|impl_cnt_dname;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *dname=(char *)(impl_buf+impl_off_dname);
  impl_obj->Checkpoint(len, dname);
  return implP.size();
}
void CkIndex_ampiParent::_marshallmessagepup_Checkpoint_marshall3(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int len, const char *dname*/
  PUP::fromMem implP(impl_buf);
  int len; implP|len;
  int impl_off_dname, impl_cnt_dname; 
  implP|impl_off_dname;
  implP|impl_cnt_dname;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *dname=(char *)(impl_buf+impl_off_dname);
  if (implDestP.hasComments()) implDestP.comment("len");
  implDestP|len;
  if (implDestP.hasComments()) implDestP.comment("dname");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*dname))<impl_cnt_dname;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|dname[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
}

/* DEFS: void ExchangeProxy(const CProxy_ampi &impl_noname_0);
 */
void CProxy_ampiParent::ExchangeProxy(const CProxy_ampi &impl_noname_0, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CProxy_ampi &impl_noname_0
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_ampi &)impl_noname_0;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_ampi &)impl_noname_0;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampiParent::__idx_ExchangeProxy_marshall4,0);
}
 int CkIndex_ampiParent::__idx_ExchangeProxy_marshall4=0;
void CkIndex_ampiParent::_call_ExchangeProxy_marshall4(void* impl_msg,ampiParent * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CProxy_ampi &impl_noname_0*/
  PUP::fromMem implP(impl_buf);
  CProxy_ampi impl_noname_0; implP|impl_noname_0;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->ExchangeProxy(impl_noname_0);
}
int CkIndex_ampiParent::_callmarshall_ExchangeProxy_marshall4(char* impl_buf,ampiParent * impl_obj) {
  /*Unmarshall pup'd fields: const CProxy_ampi &impl_noname_0*/
  PUP::fromMem implP(impl_buf);
  CProxy_ampi impl_noname_0; implP|impl_noname_0;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->ExchangeProxy(impl_noname_0);
  return implP.size();
}
void CkIndex_ampiParent::_marshallmessagepup_ExchangeProxy_marshall4(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CProxy_ampi &impl_noname_0*/
  PUP::fromMem implP(impl_buf);
  CProxy_ampi impl_noname_0; implP|impl_noname_0;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("impl_noname_0");
  implDestP|impl_noname_0;
}

/* DEFS: ampiParent(CkMigrateMessage* impl_msg);
 */

/* DEFS: ampiParent(int universeNo, const CProxy_TCharm &threads_);
 */

/* DEFS: void ResumeThread(void);
 */
void CProxySection_ampiParent::ResumeThread(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampiParent::__idx_ResumeThread_void,0);
}

/* DEFS: void Checkpoint(int len, const char *dname);
 */
void CProxySection_ampiParent::Checkpoint(int len, const char *dname, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int len, const char *dname
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_dname, impl_cnt_dname;
  impl_off_dname=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_dname=sizeof(char)*(len));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|len;
    implP|impl_off_dname;
    implP|impl_cnt_dname;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|len;
    implP|impl_off_dname;
    implP|impl_cnt_dname;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_dname,dname,impl_cnt_dname);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampiParent::__idx_Checkpoint_marshall3,0);
}

/* DEFS: void ExchangeProxy(const CProxy_ampi &impl_noname_0);
 */
void CProxySection_ampiParent::ExchangeProxy(const CProxy_ampi &impl_noname_0, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CProxy_ampi &impl_noname_0
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_ampi &)impl_noname_0;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_ampi &)impl_noname_0;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampiParent::__idx_ExchangeProxy_marshall4,0);
}

#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_ampiParent::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeArray);
  CkRegisterBase(__idx, CkIndex_ArrayElement::__idx);
// REG: ampiParent(CkMigrateMessage* impl_msg);
  __idx_ampiParent_CkMigrateMessage = CkRegisterEp("ampiParent(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_ampiParent_CkMigrateMessage, 0, __idx, 0);
  CkRegisterMigCtor(__idx, __idx_ampiParent_CkMigrateMessage);

// REG: ampiParent(int universeNo, const CProxy_TCharm &threads_);
  __idx_ampiParent_marshall1 = CkRegisterEp("ampiParent(int universeNo, const CProxy_TCharm &threads_)",
     (CkCallFnPtr)_call_ampiParent_marshall1, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP+CK_EP_TRACEDISABLE);
  CkRegisterMarshallUnpackFn(__idx_ampiParent_marshall1,(CkMarshallUnpackFn)_callmarshall_ampiParent_marshall1);
  CkRegisterMessagePupFn(__idx_ampiParent_marshall1,(CkMessagePupFn)_marshallmessagepup_ampiParent_marshall1);

// REG: void ResumeThread(void);
  __idx_ResumeThread_void = CkRegisterEp("ResumeThread(void)",
     (CkCallFnPtr)_call_ResumeThread_void, 0, __idx, 0);

// REG: void Checkpoint(int len, const char *dname);
  __idx_Checkpoint_marshall3 = CkRegisterEp("Checkpoint(int len, const char *dname)",
     (CkCallFnPtr)_call_Checkpoint_marshall3, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_Checkpoint_marshall3,(CkMarshallUnpackFn)_callmarshall_Checkpoint_marshall3);
  CkRegisterMessagePupFn(__idx_Checkpoint_marshall3,(CkMessagePupFn)_marshallmessagepup_Checkpoint_marshall3);

// REG: void ExchangeProxy(const CProxy_ampi &impl_noname_0);
  __idx_ExchangeProxy_marshall4 = CkRegisterEp("ExchangeProxy(const CProxy_ampi &impl_noname_0)",
     (CkCallFnPtr)_call_ExchangeProxy_marshall4, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_ExchangeProxy_marshall4,(CkMarshallUnpackFn)_callmarshall_ExchangeProxy_marshall4);
  CkRegisterMessagePupFn(__idx_ExchangeProxy_marshall4,(CkMessagePupFn)_marshallmessagepup_ExchangeProxy_marshall4);

}
#endif

/* DEFS: array ampi: ArrayElement{
ampi(CkMigrateMessage* impl_msg);
ampi(void);
ampi(const CkArrayID &parent_, const ampiCommStruct &s);
ampi(const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_);
void allInitDone(CkReductionMsg* impl_msg);
void setInitDoneFlag(void);
void unblock(void);
void generic(AmpiMsg* impl_msg);
void reduceResult(CkReductionMsg* impl_msg);
void splitPhase1(CkReductionMsg* impl_msg);
void commCreatePhase1(CkReductionMsg* impl_msg);
void cartCreatePhase1(CkReductionMsg* impl_msg);
void graphCreatePhase1(CkReductionMsg* impl_msg);
void intercommCreatePhase1(CkReductionMsg* impl_msg);
void intercommMergePhase1(CkReductionMsg* impl_msg);
void setRemoteProxy(const CProxy_ampi &rproxy);
void winRemotePut(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src);
void winRemoteGet(int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src);
void winRemoteAccumulate(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src);
void winRemoteLock(int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank);
void winRemoteUnlock(int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank);
AmpiMsg* winRemoteIGet(int orgdisp, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex);
AmpiMsg* Alltoall_RemoteIGet(int disp, int cnt, const MPI_Datatype &type, int tag);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_ampi::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: ampi(CkMigrateMessage* impl_msg);
 */

/* DEFS: ampi(void);
 */
void CProxyElement_ampi::insert(int onPE)
{ 
  void *impl_msg = CkAllocSysMsg();
   ckInsert((CkArrayMessage *)impl_msg,CkIndex_ampi::__idx_ampi_void,onPE);
}

/* DEFS: ampi(const CkArrayID &parent_, const ampiCommStruct &s);
 */
void CProxyElement_ampi::insert(const CkArrayID &parent_, const ampiCommStruct &s, int onPE, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: const CkArrayID &parent_, const ampiCommStruct &s
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)parent_;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)s;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)parent_;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)s;
  }
   ckInsert((CkArrayMessage *)impl_msg,CkIndex_ampi::__idx_ampi_marshall2,onPE);
}

/* DEFS: ampi(const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_);
 */
void CProxyElement_ampi::insert(const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_, int onPE, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)parent_;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)s;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciStreaming_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciBcast_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciAllgather_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciAlltoall_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)parent_;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)s;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciStreaming_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciBcast_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciAllgather_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciAlltoall_;
  }
   ckInsert((CkArrayMessage *)impl_msg,CkIndex_ampi::__idx_ampi_marshall3,onPE);
}

/* DEFS: void allInitDone(CkReductionMsg* impl_msg);
 */
void CProxyElement_ampi::allInitDone(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_allInitDone_CkReductionMsg,0);
}

/* DEFS: void setInitDoneFlag(void);
 */
void CProxyElement_ampi::setInitDoneFlag(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_setInitDoneFlag_void,0);
}

/* DEFS: void unblock(void);
 */
void CProxyElement_ampi::unblock(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_unblock_void,0);
}

/* DEFS: void generic(AmpiMsg* impl_msg);
 */
void CProxyElement_ampi::generic(AmpiMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_generic_AmpiMsg,0);
}

/* DEFS: void reduceResult(CkReductionMsg* impl_msg);
 */
void CProxyElement_ampi::reduceResult(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_reduceResult_CkReductionMsg,0);
}

/* DEFS: void splitPhase1(CkReductionMsg* impl_msg);
 */
void CProxyElement_ampi::splitPhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_splitPhase1_CkReductionMsg,0);
}

/* DEFS: void commCreatePhase1(CkReductionMsg* impl_msg);
 */
void CProxyElement_ampi::commCreatePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_commCreatePhase1_CkReductionMsg,0);
}

/* DEFS: void cartCreatePhase1(CkReductionMsg* impl_msg);
 */
void CProxyElement_ampi::cartCreatePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_cartCreatePhase1_CkReductionMsg,0);
}

/* DEFS: void graphCreatePhase1(CkReductionMsg* impl_msg);
 */
void CProxyElement_ampi::graphCreatePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_graphCreatePhase1_CkReductionMsg,0);
}

/* DEFS: void intercommCreatePhase1(CkReductionMsg* impl_msg);
 */
void CProxyElement_ampi::intercommCreatePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_intercommCreatePhase1_CkReductionMsg,0);
}

/* DEFS: void intercommMergePhase1(CkReductionMsg* impl_msg);
 */
void CProxyElement_ampi::intercommMergePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_intercommMergePhase1_CkReductionMsg,0);
}

/* DEFS: void setRemoteProxy(const CProxy_ampi &rproxy);
 */
void CProxyElement_ampi::setRemoteProxy(const CProxy_ampi &rproxy, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CProxy_ampi &rproxy
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_ampi &)rproxy;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_ampi &)rproxy;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_setRemoteProxy_marshall15,0);
}

/* DEFS: void winRemotePut(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src);
 */
void CProxyElement_ampi::winRemotePut(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_orgaddr, impl_cnt_orgaddr;
  impl_off_orgaddr=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_orgaddr=sizeof(char)*(orgtotalsize));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|orgtotalsize;
    implP|impl_off_orgaddr;
    implP|impl_cnt_orgaddr;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|orgtotalsize;
    implP|impl_off_orgaddr;
    implP|impl_cnt_orgaddr;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_orgaddr,orgaddr,impl_cnt_orgaddr);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_winRemotePut_marshall16,0);
}

/* DEFS: void winRemoteGet(int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src);
 */
void CProxyElement_ampi::winRemoteGet(int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_winRemoteGet_marshall17,0);
}

/* DEFS: void winRemoteAccumulate(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src);
 */
void CProxyElement_ampi::winRemoteAccumulate(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_orgaddr, impl_cnt_orgaddr;
  impl_off_orgaddr=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_orgaddr=sizeof(char)*(orgtotalsize));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|orgtotalsize;
    implP|impl_off_orgaddr;
    implP|impl_cnt_orgaddr;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Op &)op;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|orgtotalsize;
    implP|impl_off_orgaddr;
    implP|impl_cnt_orgaddr;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Op &)op;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_orgaddr,orgaddr,impl_cnt_orgaddr);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_winRemoteAccumulate_marshall18,0);
}

/* DEFS: void winRemoteLock(int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank);
 */
void CProxyElement_ampi::winRemoteLock(int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|lock_type;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    implP|requestRank;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|lock_type;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    implP|requestRank;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_winRemoteLock_marshall19,0);
}

/* DEFS: void winRemoteUnlock(int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank);
 */
void CProxyElement_ampi::winRemoteUnlock(int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    implP|requestRank;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    implP|requestRank;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_winRemoteUnlock_marshall20,0);
}

/* DEFS: AmpiMsg* winRemoteIGet(int orgdisp, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex);
 */
CkFutureID  CProxyElement_ampi::winRemoteIGet(int orgdisp, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int orgdisp, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|orgdisp;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    implP|winIndex;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|orgdisp;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    implP|winIndex;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  CkFutureID f=CkCreateAttachedFutureSend(impl_amsg,CkIndex_ampi::__idx_winRemoteIGet_marshall21,ckGetArrayID(),ckGetIndex(),&CProxyElement_ArrayBase::ckSendWrapper);
  return f;
}

/* DEFS: AmpiMsg* Alltoall_RemoteIGet(int disp, int cnt, const MPI_Datatype &type, int tag);
 */
CkFutureID  CProxyElement_ampi::Alltoall_RemoteIGet(int disp, int cnt, const MPI_Datatype &type, int tag, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int disp, int cnt, const MPI_Datatype &type, int tag
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|disp;
    implP|cnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)type;
    implP|tag;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|disp;
    implP|cnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)type;
    implP|tag;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  CkFutureID f=CkCreateAttachedFutureSend(impl_amsg,CkIndex_ampi::__idx_Alltoall_RemoteIGet_marshall22,ckGetArrayID(),ckGetIndex(),&CProxyElement_ArrayBase::ckSendWrapper);
  return f;
}

/* DEFS: ampi(CkMigrateMessage* impl_msg);
 */
 int CkIndex_ampi::__idx_ampi_CkMigrateMessage=0;
void CkIndex_ampi::_call_ampi_CkMigrateMessage(void* impl_msg,ampi * impl_obj)
{
  new (impl_obj) ampi((CkMigrateMessage*)impl_msg);
}

/* DEFS: ampi(void);
 */
CkArrayID CProxy_ampi::ckNew(const CkArrayOptions &opts)
{ 
  void *impl_msg = CkAllocSysMsg();
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_ampi::__idx_ampi_void,opts);
}
CkArrayID CProxy_ampi::ckNew(const int s1)
{ 
  void *impl_msg = CkAllocSysMsg();
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_ampi::__idx_ampi_void,CkArrayOptions(s1));
}
 int CkIndex_ampi::__idx_ampi_void=0;
void CkIndex_ampi::_call_ampi_void(void* impl_msg,ampi * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  new (impl_obj) ampi();
}

/* DEFS: ampi(const CkArrayID &parent_, const ampiCommStruct &s);
 */
CkArrayID CProxy_ampi::ckNew(const CkArrayID &parent_, const ampiCommStruct &s, const CkArrayOptions &opts, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: const CkArrayID &parent_, const ampiCommStruct &s
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)parent_;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)s;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)parent_;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)s;
  }
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_ampi::__idx_ampi_marshall2,opts);
}
CkArrayID CProxy_ampi::ckNew(const CkArrayID &parent_, const ampiCommStruct &s, const int s1, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: const CkArrayID &parent_, const ampiCommStruct &s
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)parent_;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)s;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)parent_;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)s;
  }
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_ampi::__idx_ampi_marshall2,CkArrayOptions(s1));
}
 int CkIndex_ampi::__idx_ampi_marshall2=0;
void CkIndex_ampi::_call_ampi_marshall2(void* impl_msg,ampi * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkArrayID &parent_, const ampiCommStruct &s*/
  PUP::fromMem implP(impl_buf);
  CkArrayID parent_; implP|parent_;
  ampiCommStruct s; implP|s;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) ampi(parent_, s);
}
int CkIndex_ampi::_callmarshall_ampi_marshall2(char* impl_buf,ampi * impl_obj) {
  /*Unmarshall pup'd fields: const CkArrayID &parent_, const ampiCommStruct &s*/
  PUP::fromMem implP(impl_buf);
  CkArrayID parent_; implP|parent_;
  ampiCommStruct s; implP|s;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) ampi(parent_, s);
  return implP.size();
}
void CkIndex_ampi::_marshallmessagepup_ampi_marshall2(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkArrayID &parent_, const ampiCommStruct &s*/
  PUP::fromMem implP(impl_buf);
  CkArrayID parent_; implP|parent_;
  ampiCommStruct s; implP|s;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("parent_");
  implDestP|parent_;
  if (implDestP.hasComments()) implDestP.comment("s");
  implDestP|s;
}

/* DEFS: ampi(const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_);
 */
CkArrayID CProxy_ampi::ckNew(const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_, const CkArrayOptions &opts, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)parent_;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)s;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciStreaming_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciBcast_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciAllgather_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciAlltoall_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)parent_;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)s;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciStreaming_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciBcast_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciAllgather_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciAlltoall_;
  }
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_ampi::__idx_ampi_marshall3,opts);
}
CkArrayID CProxy_ampi::ckNew(const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_, const int s1, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)parent_;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)s;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciStreaming_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciBcast_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciAllgather_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciAlltoall_;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)parent_;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)s;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciStreaming_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciBcast_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciAllgather_;
    //Have to cast away const-ness to get pup routine
    implP|(ComlibInstanceHandle &)ciAlltoall_;
  }
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_ampi::__idx_ampi_marshall3,CkArrayOptions(s1));
}
 int CkIndex_ampi::__idx_ampi_marshall3=0;
void CkIndex_ampi::_call_ampi_marshall3(void* impl_msg,ampi * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_*/
  PUP::fromMem implP(impl_buf);
  CkArrayID parent_; implP|parent_;
  ampiCommStruct s; implP|s;
  ComlibInstanceHandle ciStreaming_; implP|ciStreaming_;
  ComlibInstanceHandle ciBcast_; implP|ciBcast_;
  ComlibInstanceHandle ciAllgather_; implP|ciAllgather_;
  ComlibInstanceHandle ciAlltoall_; implP|ciAlltoall_;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) ampi(parent_, s, ciStreaming_, ciBcast_, ciAllgather_, ciAlltoall_);
}
int CkIndex_ampi::_callmarshall_ampi_marshall3(char* impl_buf,ampi * impl_obj) {
  /*Unmarshall pup'd fields: const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_*/
  PUP::fromMem implP(impl_buf);
  CkArrayID parent_; implP|parent_;
  ampiCommStruct s; implP|s;
  ComlibInstanceHandle ciStreaming_; implP|ciStreaming_;
  ComlibInstanceHandle ciBcast_; implP|ciBcast_;
  ComlibInstanceHandle ciAllgather_; implP|ciAllgather_;
  ComlibInstanceHandle ciAlltoall_; implP|ciAlltoall_;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) ampi(parent_, s, ciStreaming_, ciBcast_, ciAllgather_, ciAlltoall_);
  return implP.size();
}
void CkIndex_ampi::_marshallmessagepup_ampi_marshall3(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_*/
  PUP::fromMem implP(impl_buf);
  CkArrayID parent_; implP|parent_;
  ampiCommStruct s; implP|s;
  ComlibInstanceHandle ciStreaming_; implP|ciStreaming_;
  ComlibInstanceHandle ciBcast_; implP|ciBcast_;
  ComlibInstanceHandle ciAllgather_; implP|ciAllgather_;
  ComlibInstanceHandle ciAlltoall_; implP|ciAlltoall_;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("parent_");
  implDestP|parent_;
  if (implDestP.hasComments()) implDestP.comment("s");
  implDestP|s;
  if (implDestP.hasComments()) implDestP.comment("ciStreaming_");
  implDestP|ciStreaming_;
  if (implDestP.hasComments()) implDestP.comment("ciBcast_");
  implDestP|ciBcast_;
  if (implDestP.hasComments()) implDestP.comment("ciAllgather_");
  implDestP|ciAllgather_;
  if (implDestP.hasComments()) implDestP.comment("ciAlltoall_");
  implDestP|ciAlltoall_;
}

/* DEFS: void allInitDone(CkReductionMsg* impl_msg);
 */
void CProxy_ampi::allInitDone(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_allInitDone_CkReductionMsg,0);
}
 int CkIndex_ampi::__idx_allInitDone_CkReductionMsg=0;
void CkIndex_ampi::_call_allInitDone_CkReductionMsg(void* impl_msg,ampi * impl_obj)
{
  impl_obj->allInitDone((CkReductionMsg*)impl_msg);
}

/* DEFS: void setInitDoneFlag(void);
 */
void CProxy_ampi::setInitDoneFlag(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_setInitDoneFlag_void,0);
}
 int CkIndex_ampi::__idx_setInitDoneFlag_void=0;
void CkIndex_ampi::_call_setInitDoneFlag_void(void* impl_msg,ampi * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->setInitDoneFlag();
}

/* DEFS: void unblock(void);
 */
void CProxy_ampi::unblock(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_unblock_void,0);
}
 int CkIndex_ampi::__idx_unblock_void=0;
void CkIndex_ampi::_call_unblock_void(void* impl_msg,ampi * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->unblock();
}

/* DEFS: void generic(AmpiMsg* impl_msg);
 */
void CProxy_ampi::generic(AmpiMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_generic_AmpiMsg,0);
}
 int CkIndex_ampi::__idx_generic_AmpiMsg=0;
void CkIndex_ampi::_call_generic_AmpiMsg(void* impl_msg,ampi * impl_obj)
{
  impl_obj->generic((AmpiMsg*)impl_msg);
}

/* DEFS: void reduceResult(CkReductionMsg* impl_msg);
 */
void CProxy_ampi::reduceResult(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_reduceResult_CkReductionMsg,0);
}
 int CkIndex_ampi::__idx_reduceResult_CkReductionMsg=0;
void CkIndex_ampi::_call_reduceResult_CkReductionMsg(void* impl_msg,ampi * impl_obj)
{
  impl_obj->reduceResult((CkReductionMsg*)impl_msg);
}

/* DEFS: void splitPhase1(CkReductionMsg* impl_msg);
 */
void CProxy_ampi::splitPhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_splitPhase1_CkReductionMsg,0);
}
 int CkIndex_ampi::__idx_splitPhase1_CkReductionMsg=0;
void CkIndex_ampi::_call_splitPhase1_CkReductionMsg(void* impl_msg,ampi * impl_obj)
{
  impl_obj->splitPhase1((CkReductionMsg*)impl_msg);
}

/* DEFS: void commCreatePhase1(CkReductionMsg* impl_msg);
 */
void CProxy_ampi::commCreatePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_commCreatePhase1_CkReductionMsg,0);
}
 int CkIndex_ampi::__idx_commCreatePhase1_CkReductionMsg=0;
void CkIndex_ampi::_call_commCreatePhase1_CkReductionMsg(void* impl_msg,ampi * impl_obj)
{
  impl_obj->commCreatePhase1((CkReductionMsg*)impl_msg);
}

/* DEFS: void cartCreatePhase1(CkReductionMsg* impl_msg);
 */
void CProxy_ampi::cartCreatePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_cartCreatePhase1_CkReductionMsg,0);
}
 int CkIndex_ampi::__idx_cartCreatePhase1_CkReductionMsg=0;
void CkIndex_ampi::_call_cartCreatePhase1_CkReductionMsg(void* impl_msg,ampi * impl_obj)
{
  impl_obj->cartCreatePhase1((CkReductionMsg*)impl_msg);
}

/* DEFS: void graphCreatePhase1(CkReductionMsg* impl_msg);
 */
void CProxy_ampi::graphCreatePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_graphCreatePhase1_CkReductionMsg,0);
}
 int CkIndex_ampi::__idx_graphCreatePhase1_CkReductionMsg=0;
void CkIndex_ampi::_call_graphCreatePhase1_CkReductionMsg(void* impl_msg,ampi * impl_obj)
{
  impl_obj->graphCreatePhase1((CkReductionMsg*)impl_msg);
}

/* DEFS: void intercommCreatePhase1(CkReductionMsg* impl_msg);
 */
void CProxy_ampi::intercommCreatePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_intercommCreatePhase1_CkReductionMsg,0);
}
 int CkIndex_ampi::__idx_intercommCreatePhase1_CkReductionMsg=0;
void CkIndex_ampi::_call_intercommCreatePhase1_CkReductionMsg(void* impl_msg,ampi * impl_obj)
{
  impl_obj->intercommCreatePhase1((CkReductionMsg*)impl_msg);
}

/* DEFS: void intercommMergePhase1(CkReductionMsg* impl_msg);
 */
void CProxy_ampi::intercommMergePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_intercommMergePhase1_CkReductionMsg,0);
}
 int CkIndex_ampi::__idx_intercommMergePhase1_CkReductionMsg=0;
void CkIndex_ampi::_call_intercommMergePhase1_CkReductionMsg(void* impl_msg,ampi * impl_obj)
{
  impl_obj->intercommMergePhase1((CkReductionMsg*)impl_msg);
}

/* DEFS: void setRemoteProxy(const CProxy_ampi &rproxy);
 */
void CProxy_ampi::setRemoteProxy(const CProxy_ampi &rproxy, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CProxy_ampi &rproxy
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_ampi &)rproxy;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_ampi &)rproxy;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_setRemoteProxy_marshall15,0);
}
 int CkIndex_ampi::__idx_setRemoteProxy_marshall15=0;
void CkIndex_ampi::_call_setRemoteProxy_marshall15(void* impl_msg,ampi * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CProxy_ampi &rproxy*/
  PUP::fromMem implP(impl_buf);
  CProxy_ampi rproxy; implP|rproxy;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->setRemoteProxy(rproxy);
}
int CkIndex_ampi::_callmarshall_setRemoteProxy_marshall15(char* impl_buf,ampi * impl_obj) {
  /*Unmarshall pup'd fields: const CProxy_ampi &rproxy*/
  PUP::fromMem implP(impl_buf);
  CProxy_ampi rproxy; implP|rproxy;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->setRemoteProxy(rproxy);
  return implP.size();
}
void CkIndex_ampi::_marshallmessagepup_setRemoteProxy_marshall15(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CProxy_ampi &rproxy*/
  PUP::fromMem implP(impl_buf);
  CProxy_ampi rproxy; implP|rproxy;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("rproxy");
  implDestP|rproxy;
}

/* DEFS: void winRemotePut(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src);
 */
void CProxy_ampi::winRemotePut(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_orgaddr, impl_cnt_orgaddr;
  impl_off_orgaddr=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_orgaddr=sizeof(char)*(orgtotalsize));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|orgtotalsize;
    implP|impl_off_orgaddr;
    implP|impl_cnt_orgaddr;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|orgtotalsize;
    implP|impl_off_orgaddr;
    implP|impl_cnt_orgaddr;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_orgaddr,orgaddr,impl_cnt_orgaddr);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_winRemotePut_marshall16,0);
}
 int CkIndex_ampi::__idx_winRemotePut_marshall16=0;
void CkIndex_ampi::_call_winRemotePut_marshall16(void* impl_msg,ampi * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src*/
  PUP::fromMem implP(impl_buf);
  int orgtotalsize; implP|orgtotalsize;
  int impl_off_orgaddr, impl_cnt_orgaddr; 
  implP|impl_off_orgaddr;
  implP|impl_cnt_orgaddr;
  int orgcnt; implP|orgcnt;
  MPI_Datatype orgtype; implP|orgtype;
  MPI_Aint targdisp; implP|targdisp;
  int targcnt; implP|targcnt;
  MPI_Datatype targtype; implP|targtype;
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *orgaddr=(char *)(impl_buf+impl_off_orgaddr);
  impl_obj->winRemotePut(orgtotalsize, orgaddr, orgcnt, orgtype, targdisp, targcnt, targtype, winIndex, ftHandle, pe_src);
}
int CkIndex_ampi::_callmarshall_winRemotePut_marshall16(char* impl_buf,ampi * impl_obj) {
  /*Unmarshall pup'd fields: int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src*/
  PUP::fromMem implP(impl_buf);
  int orgtotalsize; implP|orgtotalsize;
  int impl_off_orgaddr, impl_cnt_orgaddr; 
  implP|impl_off_orgaddr;
  implP|impl_cnt_orgaddr;
  int orgcnt; implP|orgcnt;
  MPI_Datatype orgtype; implP|orgtype;
  MPI_Aint targdisp; implP|targdisp;
  int targcnt; implP|targcnt;
  MPI_Datatype targtype; implP|targtype;
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *orgaddr=(char *)(impl_buf+impl_off_orgaddr);
  impl_obj->winRemotePut(orgtotalsize, orgaddr, orgcnt, orgtype, targdisp, targcnt, targtype, winIndex, ftHandle, pe_src);
  return implP.size();
}
void CkIndex_ampi::_marshallmessagepup_winRemotePut_marshall16(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src*/
  PUP::fromMem implP(impl_buf);
  int orgtotalsize; implP|orgtotalsize;
  int impl_off_orgaddr, impl_cnt_orgaddr; 
  implP|impl_off_orgaddr;
  implP|impl_cnt_orgaddr;
  int orgcnt; implP|orgcnt;
  MPI_Datatype orgtype; implP|orgtype;
  MPI_Aint targdisp; implP|targdisp;
  int targcnt; implP|targcnt;
  MPI_Datatype targtype; implP|targtype;
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *orgaddr=(char *)(impl_buf+impl_off_orgaddr);
  if (implDestP.hasComments()) implDestP.comment("orgtotalsize");
  implDestP|orgtotalsize;
  if (implDestP.hasComments()) implDestP.comment("orgaddr");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*orgaddr))<impl_cnt_orgaddr;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|orgaddr[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("orgcnt");
  implDestP|orgcnt;
  if (implDestP.hasComments()) implDestP.comment("orgtype");
  implDestP|orgtype;
  if (implDestP.hasComments()) implDestP.comment("targdisp");
  implDestP|targdisp;
  if (implDestP.hasComments()) implDestP.comment("targcnt");
  implDestP|targcnt;
  if (implDestP.hasComments()) implDestP.comment("targtype");
  implDestP|targtype;
  if (implDestP.hasComments()) implDestP.comment("winIndex");
  implDestP|winIndex;
  if (implDestP.hasComments()) implDestP.comment("ftHandle");
  implDestP|ftHandle;
  if (implDestP.hasComments()) implDestP.comment("pe_src");
  implDestP|pe_src;
}

/* DEFS: void winRemoteGet(int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src);
 */
void CProxy_ampi::winRemoteGet(int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_winRemoteGet_marshall17,0);
}
 int CkIndex_ampi::__idx_winRemoteGet_marshall17=0;
void CkIndex_ampi::_call_winRemoteGet_marshall17(void* impl_msg,ampi * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src*/
  PUP::fromMem implP(impl_buf);
  int orgcnt; implP|orgcnt;
  MPI_Datatype orgtype; implP|orgtype;
  MPI_Aint targdisp; implP|targdisp;
  int targcnt; implP|targcnt;
  MPI_Datatype targtype; implP|targtype;
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->winRemoteGet(orgcnt, orgtype, targdisp, targcnt, targtype, winIndex, ftHandle, pe_src);
}
int CkIndex_ampi::_callmarshall_winRemoteGet_marshall17(char* impl_buf,ampi * impl_obj) {
  /*Unmarshall pup'd fields: int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src*/
  PUP::fromMem implP(impl_buf);
  int orgcnt; implP|orgcnt;
  MPI_Datatype orgtype; implP|orgtype;
  MPI_Aint targdisp; implP|targdisp;
  int targcnt; implP|targcnt;
  MPI_Datatype targtype; implP|targtype;
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->winRemoteGet(orgcnt, orgtype, targdisp, targcnt, targtype, winIndex, ftHandle, pe_src);
  return implP.size();
}
void CkIndex_ampi::_marshallmessagepup_winRemoteGet_marshall17(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src*/
  PUP::fromMem implP(impl_buf);
  int orgcnt; implP|orgcnt;
  MPI_Datatype orgtype; implP|orgtype;
  MPI_Aint targdisp; implP|targdisp;
  int targcnt; implP|targcnt;
  MPI_Datatype targtype; implP|targtype;
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("orgcnt");
  implDestP|orgcnt;
  if (implDestP.hasComments()) implDestP.comment("orgtype");
  implDestP|orgtype;
  if (implDestP.hasComments()) implDestP.comment("targdisp");
  implDestP|targdisp;
  if (implDestP.hasComments()) implDestP.comment("targcnt");
  implDestP|targcnt;
  if (implDestP.hasComments()) implDestP.comment("targtype");
  implDestP|targtype;
  if (implDestP.hasComments()) implDestP.comment("winIndex");
  implDestP|winIndex;
  if (implDestP.hasComments()) implDestP.comment("ftHandle");
  implDestP|ftHandle;
  if (implDestP.hasComments()) implDestP.comment("pe_src");
  implDestP|pe_src;
}

/* DEFS: void winRemoteAccumulate(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src);
 */
void CProxy_ampi::winRemoteAccumulate(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_orgaddr, impl_cnt_orgaddr;
  impl_off_orgaddr=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_orgaddr=sizeof(char)*(orgtotalsize));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|orgtotalsize;
    implP|impl_off_orgaddr;
    implP|impl_cnt_orgaddr;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Op &)op;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|orgtotalsize;
    implP|impl_off_orgaddr;
    implP|impl_cnt_orgaddr;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Op &)op;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_orgaddr,orgaddr,impl_cnt_orgaddr);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_winRemoteAccumulate_marshall18,0);
}
 int CkIndex_ampi::__idx_winRemoteAccumulate_marshall18=0;
void CkIndex_ampi::_call_winRemoteAccumulate_marshall18(void* impl_msg,ampi * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src*/
  PUP::fromMem implP(impl_buf);
  int orgtotalsize; implP|orgtotalsize;
  int impl_off_orgaddr, impl_cnt_orgaddr; 
  implP|impl_off_orgaddr;
  implP|impl_cnt_orgaddr;
  int orgcnt; implP|orgcnt;
  MPI_Datatype orgtype; implP|orgtype;
  MPI_Aint targdisp; implP|targdisp;
  int targcnt; implP|targcnt;
  MPI_Datatype targtype; implP|targtype;
  MPI_Op op; implP|op;
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *orgaddr=(char *)(impl_buf+impl_off_orgaddr);
  impl_obj->winRemoteAccumulate(orgtotalsize, orgaddr, orgcnt, orgtype, targdisp, targcnt, targtype, op, winIndex, ftHandle, pe_src);
}
int CkIndex_ampi::_callmarshall_winRemoteAccumulate_marshall18(char* impl_buf,ampi * impl_obj) {
  /*Unmarshall pup'd fields: int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src*/
  PUP::fromMem implP(impl_buf);
  int orgtotalsize; implP|orgtotalsize;
  int impl_off_orgaddr, impl_cnt_orgaddr; 
  implP|impl_off_orgaddr;
  implP|impl_cnt_orgaddr;
  int orgcnt; implP|orgcnt;
  MPI_Datatype orgtype; implP|orgtype;
  MPI_Aint targdisp; implP|targdisp;
  int targcnt; implP|targcnt;
  MPI_Datatype targtype; implP|targtype;
  MPI_Op op; implP|op;
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *orgaddr=(char *)(impl_buf+impl_off_orgaddr);
  impl_obj->winRemoteAccumulate(orgtotalsize, orgaddr, orgcnt, orgtype, targdisp, targcnt, targtype, op, winIndex, ftHandle, pe_src);
  return implP.size();
}
void CkIndex_ampi::_marshallmessagepup_winRemoteAccumulate_marshall18(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src*/
  PUP::fromMem implP(impl_buf);
  int orgtotalsize; implP|orgtotalsize;
  int impl_off_orgaddr, impl_cnt_orgaddr; 
  implP|impl_off_orgaddr;
  implP|impl_cnt_orgaddr;
  int orgcnt; implP|orgcnt;
  MPI_Datatype orgtype; implP|orgtype;
  MPI_Aint targdisp; implP|targdisp;
  int targcnt; implP|targcnt;
  MPI_Datatype targtype; implP|targtype;
  MPI_Op op; implP|op;
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  char *orgaddr=(char *)(impl_buf+impl_off_orgaddr);
  if (implDestP.hasComments()) implDestP.comment("orgtotalsize");
  implDestP|orgtotalsize;
  if (implDestP.hasComments()) implDestP.comment("orgaddr");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*orgaddr))<impl_cnt_orgaddr;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|orgaddr[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("orgcnt");
  implDestP|orgcnt;
  if (implDestP.hasComments()) implDestP.comment("orgtype");
  implDestP|orgtype;
  if (implDestP.hasComments()) implDestP.comment("targdisp");
  implDestP|targdisp;
  if (implDestP.hasComments()) implDestP.comment("targcnt");
  implDestP|targcnt;
  if (implDestP.hasComments()) implDestP.comment("targtype");
  implDestP|targtype;
  if (implDestP.hasComments()) implDestP.comment("op");
  implDestP|op;
  if (implDestP.hasComments()) implDestP.comment("winIndex");
  implDestP|winIndex;
  if (implDestP.hasComments()) implDestP.comment("ftHandle");
  implDestP|ftHandle;
  if (implDestP.hasComments()) implDestP.comment("pe_src");
  implDestP|pe_src;
}

/* DEFS: void winRemoteLock(int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank);
 */
void CProxy_ampi::winRemoteLock(int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|lock_type;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    implP|requestRank;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|lock_type;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    implP|requestRank;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_winRemoteLock_marshall19,0);
}
 int CkIndex_ampi::__idx_winRemoteLock_marshall19=0;
void CkIndex_ampi::_call_winRemoteLock_marshall19(void* impl_msg,ampi * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank*/
  PUP::fromMem implP(impl_buf);
  int lock_type; implP|lock_type;
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  int requestRank; implP|requestRank;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->winRemoteLock(lock_type, winIndex, ftHandle, pe_src, requestRank);
}
int CkIndex_ampi::_callmarshall_winRemoteLock_marshall19(char* impl_buf,ampi * impl_obj) {
  /*Unmarshall pup'd fields: int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank*/
  PUP::fromMem implP(impl_buf);
  int lock_type; implP|lock_type;
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  int requestRank; implP|requestRank;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->winRemoteLock(lock_type, winIndex, ftHandle, pe_src, requestRank);
  return implP.size();
}
void CkIndex_ampi::_marshallmessagepup_winRemoteLock_marshall19(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank*/
  PUP::fromMem implP(impl_buf);
  int lock_type; implP|lock_type;
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  int requestRank; implP|requestRank;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("lock_type");
  implDestP|lock_type;
  if (implDestP.hasComments()) implDestP.comment("winIndex");
  implDestP|winIndex;
  if (implDestP.hasComments()) implDestP.comment("ftHandle");
  implDestP|ftHandle;
  if (implDestP.hasComments()) implDestP.comment("pe_src");
  implDestP|pe_src;
  if (implDestP.hasComments()) implDestP.comment("requestRank");
  implDestP|requestRank;
}

/* DEFS: void winRemoteUnlock(int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank);
 */
void CProxy_ampi::winRemoteUnlock(int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    implP|requestRank;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    implP|requestRank;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_ampi::__idx_winRemoteUnlock_marshall20,0);
}
 int CkIndex_ampi::__idx_winRemoteUnlock_marshall20=0;
void CkIndex_ampi::_call_winRemoteUnlock_marshall20(void* impl_msg,ampi * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank*/
  PUP::fromMem implP(impl_buf);
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  int requestRank; implP|requestRank;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->winRemoteUnlock(winIndex, ftHandle, pe_src, requestRank);
}
int CkIndex_ampi::_callmarshall_winRemoteUnlock_marshall20(char* impl_buf,ampi * impl_obj) {
  /*Unmarshall pup'd fields: int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank*/
  PUP::fromMem implP(impl_buf);
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  int requestRank; implP|requestRank;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->winRemoteUnlock(winIndex, ftHandle, pe_src, requestRank);
  return implP.size();
}
void CkIndex_ampi::_marshallmessagepup_winRemoteUnlock_marshall20(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank*/
  PUP::fromMem implP(impl_buf);
  int winIndex; implP|winIndex;
  CkFutureID ftHandle; implP|ftHandle;
  int pe_src; implP|pe_src;
  int requestRank; implP|requestRank;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("winIndex");
  implDestP|winIndex;
  if (implDestP.hasComments()) implDestP.comment("ftHandle");
  implDestP|ftHandle;
  if (implDestP.hasComments()) implDestP.comment("pe_src");
  implDestP|pe_src;
  if (implDestP.hasComments()) implDestP.comment("requestRank");
  implDestP|requestRank;
}

/* DEFS: AmpiMsg* winRemoteIGet(int orgdisp, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex);
 */
 int CkIndex_ampi::__idx_winRemoteIGet_marshall21=0;
void CkIndex_ampi::_call_winRemoteIGet_marshall21(void* impl_msg,ampi * impl_obj)
{
  int impl_ref = CkGetRefNum(impl_msg), impl_src = CkGetSrcPe(impl_msg);
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int orgdisp, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex*/
  PUP::fromMem implP(impl_buf);
  int orgdisp; implP|orgdisp;
  int orgcnt; implP|orgcnt;
  MPI_Datatype orgtype; implP|orgtype;
  MPI_Aint targdisp; implP|targdisp;
  int targcnt; implP|targcnt;
  MPI_Datatype targtype; implP|targtype;
  int winIndex; implP|winIndex;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  void *impl_retMsg=(void *)   impl_obj->winRemoteIGet(orgdisp, orgcnt, orgtype, targdisp, targcnt, targtype, winIndex);
  CkSendToFuture(impl_ref, impl_retMsg, impl_src);
}
int CkIndex_ampi::_callmarshall_winRemoteIGet_marshall21(char* impl_buf,ampi * impl_obj) {
  /*Unmarshall pup'd fields: int orgdisp, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex*/
  PUP::fromMem implP(impl_buf);
  int orgdisp; implP|orgdisp;
  int orgcnt; implP|orgcnt;
  MPI_Datatype orgtype; implP|orgtype;
  MPI_Aint targdisp; implP|targdisp;
  int targcnt; implP|targcnt;
  MPI_Datatype targtype; implP|targtype;
  int winIndex; implP|winIndex;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  void *impl_retMsg=(void *)   impl_obj->winRemoteIGet(orgdisp, orgcnt, orgtype, targdisp, targcnt, targtype, winIndex);
  return implP.size();
}
void CkIndex_ampi::_marshallmessagepup_winRemoteIGet_marshall21(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int orgdisp, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex*/
  PUP::fromMem implP(impl_buf);
  int orgdisp; implP|orgdisp;
  int orgcnt; implP|orgcnt;
  MPI_Datatype orgtype; implP|orgtype;
  MPI_Aint targdisp; implP|targdisp;
  int targcnt; implP|targcnt;
  MPI_Datatype targtype; implP|targtype;
  int winIndex; implP|winIndex;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("orgdisp");
  implDestP|orgdisp;
  if (implDestP.hasComments()) implDestP.comment("orgcnt");
  implDestP|orgcnt;
  if (implDestP.hasComments()) implDestP.comment("orgtype");
  implDestP|orgtype;
  if (implDestP.hasComments()) implDestP.comment("targdisp");
  implDestP|targdisp;
  if (implDestP.hasComments()) implDestP.comment("targcnt");
  implDestP|targcnt;
  if (implDestP.hasComments()) implDestP.comment("targtype");
  implDestP|targtype;
  if (implDestP.hasComments()) implDestP.comment("winIndex");
  implDestP|winIndex;
}

/* DEFS: AmpiMsg* Alltoall_RemoteIGet(int disp, int cnt, const MPI_Datatype &type, int tag);
 */
 int CkIndex_ampi::__idx_Alltoall_RemoteIGet_marshall22=0;
void CkIndex_ampi::_call_Alltoall_RemoteIGet_marshall22(void* impl_msg,ampi * impl_obj)
{
  int impl_ref = CkGetRefNum(impl_msg), impl_src = CkGetSrcPe(impl_msg);
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int disp, int cnt, const MPI_Datatype &type, int tag*/
  PUP::fromMem implP(impl_buf);
  int disp; implP|disp;
  int cnt; implP|cnt;
  MPI_Datatype type; implP|type;
  int tag; implP|tag;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  void *impl_retMsg=(void *)   impl_obj->Alltoall_RemoteIGet(disp, cnt, type, tag);
  CkSendToFuture(impl_ref, impl_retMsg, impl_src);
}
int CkIndex_ampi::_callmarshall_Alltoall_RemoteIGet_marshall22(char* impl_buf,ampi * impl_obj) {
  /*Unmarshall pup'd fields: int disp, int cnt, const MPI_Datatype &type, int tag*/
  PUP::fromMem implP(impl_buf);
  int disp; implP|disp;
  int cnt; implP|cnt;
  MPI_Datatype type; implP|type;
  int tag; implP|tag;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  void *impl_retMsg=(void *)   impl_obj->Alltoall_RemoteIGet(disp, cnt, type, tag);
  return implP.size();
}
void CkIndex_ampi::_marshallmessagepup_Alltoall_RemoteIGet_marshall22(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int disp, int cnt, const MPI_Datatype &type, int tag*/
  PUP::fromMem implP(impl_buf);
  int disp; implP|disp;
  int cnt; implP|cnt;
  MPI_Datatype type; implP|type;
  int tag; implP|tag;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("disp");
  implDestP|disp;
  if (implDestP.hasComments()) implDestP.comment("cnt");
  implDestP|cnt;
  if (implDestP.hasComments()) implDestP.comment("type");
  implDestP|type;
  if (implDestP.hasComments()) implDestP.comment("tag");
  implDestP|tag;
}

/* DEFS: ampi(CkMigrateMessage* impl_msg);
 */

/* DEFS: ampi(void);
 */

/* DEFS: ampi(const CkArrayID &parent_, const ampiCommStruct &s);
 */

/* DEFS: ampi(const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_);
 */

/* DEFS: void allInitDone(CkReductionMsg* impl_msg);
 */
void CProxySection_ampi::allInitDone(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_allInitDone_CkReductionMsg,0);
}

/* DEFS: void setInitDoneFlag(void);
 */
void CProxySection_ampi::setInitDoneFlag(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_setInitDoneFlag_void,0);
}

/* DEFS: void unblock(void);
 */
void CProxySection_ampi::unblock(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_unblock_void,0);
}

/* DEFS: void generic(AmpiMsg* impl_msg);
 */
void CProxySection_ampi::generic(AmpiMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_generic_AmpiMsg,0);
}

/* DEFS: void reduceResult(CkReductionMsg* impl_msg);
 */
void CProxySection_ampi::reduceResult(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_reduceResult_CkReductionMsg,0);
}

/* DEFS: void splitPhase1(CkReductionMsg* impl_msg);
 */
void CProxySection_ampi::splitPhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_splitPhase1_CkReductionMsg,0);
}

/* DEFS: void commCreatePhase1(CkReductionMsg* impl_msg);
 */
void CProxySection_ampi::commCreatePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_commCreatePhase1_CkReductionMsg,0);
}

/* DEFS: void cartCreatePhase1(CkReductionMsg* impl_msg);
 */
void CProxySection_ampi::cartCreatePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_cartCreatePhase1_CkReductionMsg,0);
}

/* DEFS: void graphCreatePhase1(CkReductionMsg* impl_msg);
 */
void CProxySection_ampi::graphCreatePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_graphCreatePhase1_CkReductionMsg,0);
}

/* DEFS: void intercommCreatePhase1(CkReductionMsg* impl_msg);
 */
void CProxySection_ampi::intercommCreatePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_intercommCreatePhase1_CkReductionMsg,0);
}

/* DEFS: void intercommMergePhase1(CkReductionMsg* impl_msg);
 */
void CProxySection_ampi::intercommMergePhase1(CkReductionMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_intercommMergePhase1_CkReductionMsg,0);
}

/* DEFS: void setRemoteProxy(const CProxy_ampi &rproxy);
 */
void CProxySection_ampi::setRemoteProxy(const CProxy_ampi &rproxy, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CProxy_ampi &rproxy
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_ampi &)rproxy;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_ampi &)rproxy;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_setRemoteProxy_marshall15,0);
}

/* DEFS: void winRemotePut(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src);
 */
void CProxySection_ampi::winRemotePut(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_orgaddr, impl_cnt_orgaddr;
  impl_off_orgaddr=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_orgaddr=sizeof(char)*(orgtotalsize));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|orgtotalsize;
    implP|impl_off_orgaddr;
    implP|impl_cnt_orgaddr;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|orgtotalsize;
    implP|impl_off_orgaddr;
    implP|impl_cnt_orgaddr;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_orgaddr,orgaddr,impl_cnt_orgaddr);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_winRemotePut_marshall16,0);
}

/* DEFS: void winRemoteGet(int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src);
 */
void CProxySection_ampi::winRemoteGet(int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_winRemoteGet_marshall17,0);
}

/* DEFS: void winRemoteAccumulate(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src);
 */
void CProxySection_ampi::winRemoteAccumulate(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_orgaddr, impl_cnt_orgaddr;
  impl_off_orgaddr=impl_off=CK_ALIGN(impl_off,sizeof(char));
  impl_off+=(impl_cnt_orgaddr=sizeof(char)*(orgtotalsize));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|orgtotalsize;
    implP|impl_off_orgaddr;
    implP|impl_cnt_orgaddr;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Op &)op;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|orgtotalsize;
    implP|impl_off_orgaddr;
    implP|impl_cnt_orgaddr;
    implP|orgcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)orgtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Aint &)targdisp;
    implP|targcnt;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Datatype &)targtype;
    //Have to cast away const-ness to get pup routine
    implP|(MPI_Op &)op;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_orgaddr,orgaddr,impl_cnt_orgaddr);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_winRemoteAccumulate_marshall18,0);
}

/* DEFS: void winRemoteLock(int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank);
 */
void CProxySection_ampi::winRemoteLock(int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|lock_type;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    implP|requestRank;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|lock_type;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    implP|requestRank;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_winRemoteLock_marshall19,0);
}

/* DEFS: void winRemoteUnlock(int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank);
 */
void CProxySection_ampi::winRemoteUnlock(int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    implP|requestRank;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|winIndex;
    //Have to cast away const-ness to get pup routine
    implP|(CkFutureID &)ftHandle;
    implP|pe_src;
    implP|requestRank;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_ampi::__idx_winRemoteUnlock_marshall20,0);
}

/* DEFS: AmpiMsg* winRemoteIGet(int orgdisp, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex);
 */

/* DEFS: AmpiMsg* Alltoall_RemoteIGet(int disp, int cnt, const MPI_Datatype &type, int tag);
 */

#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_ampi::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeArray);
  CkRegisterBase(__idx, CkIndex_ArrayElement::__idx);
// REG: ampi(CkMigrateMessage* impl_msg);
  __idx_ampi_CkMigrateMessage = CkRegisterEp("ampi(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_ampi_CkMigrateMessage, 0, __idx, 0);
  CkRegisterMigCtor(__idx, __idx_ampi_CkMigrateMessage);

// REG: ampi(void);
  __idx_ampi_void = CkRegisterEp("ampi(void)",
     (CkCallFnPtr)_call_ampi_void, 0, __idx, 0);
  CkRegisterDefaultCtor(__idx, __idx_ampi_void);

// REG: ampi(const CkArrayID &parent_, const ampiCommStruct &s);
  __idx_ampi_marshall2 = CkRegisterEp("ampi(const CkArrayID &parent_, const ampiCommStruct &s)",
     (CkCallFnPtr)_call_ampi_marshall2, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP+CK_EP_TRACEDISABLE);
  CkRegisterMarshallUnpackFn(__idx_ampi_marshall2,(CkMarshallUnpackFn)_callmarshall_ampi_marshall2);
  CkRegisterMessagePupFn(__idx_ampi_marshall2,(CkMessagePupFn)_marshallmessagepup_ampi_marshall2);

// REG: ampi(const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_);
  __idx_ampi_marshall3 = CkRegisterEp("ampi(const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_)",
     (CkCallFnPtr)_call_ampi_marshall3, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP+CK_EP_TRACEDISABLE);
  CkRegisterMarshallUnpackFn(__idx_ampi_marshall3,(CkMarshallUnpackFn)_callmarshall_ampi_marshall3);
  CkRegisterMessagePupFn(__idx_ampi_marshall3,(CkMessagePupFn)_marshallmessagepup_ampi_marshall3);

// REG: void allInitDone(CkReductionMsg* impl_msg);
  __idx_allInitDone_CkReductionMsg = CkRegisterEp("allInitDone(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_allInitDone_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0);

// REG: void setInitDoneFlag(void);
  __idx_setInitDoneFlag_void = CkRegisterEp("setInitDoneFlag(void)",
     (CkCallFnPtr)_call_setInitDoneFlag_void, 0, __idx, 0);

// REG: void unblock(void);
  __idx_unblock_void = CkRegisterEp("unblock(void)",
     (CkCallFnPtr)_call_unblock_void, 0, __idx, 0);

// REG: void generic(AmpiMsg* impl_msg);
  __idx_generic_AmpiMsg = CkRegisterEp("generic(AmpiMsg* impl_msg)",
     (CkCallFnPtr)_call_generic_AmpiMsg, CMessage_AmpiMsg::__idx, __idx, 0);

// REG: void reduceResult(CkReductionMsg* impl_msg);
  __idx_reduceResult_CkReductionMsg = CkRegisterEp("reduceResult(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_reduceResult_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0);

// REG: void splitPhase1(CkReductionMsg* impl_msg);
  __idx_splitPhase1_CkReductionMsg = CkRegisterEp("splitPhase1(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_splitPhase1_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0);

// REG: void commCreatePhase1(CkReductionMsg* impl_msg);
  __idx_commCreatePhase1_CkReductionMsg = CkRegisterEp("commCreatePhase1(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_commCreatePhase1_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0);

// REG: void cartCreatePhase1(CkReductionMsg* impl_msg);
  __idx_cartCreatePhase1_CkReductionMsg = CkRegisterEp("cartCreatePhase1(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_cartCreatePhase1_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0);

// REG: void graphCreatePhase1(CkReductionMsg* impl_msg);
  __idx_graphCreatePhase1_CkReductionMsg = CkRegisterEp("graphCreatePhase1(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_graphCreatePhase1_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0);

// REG: void intercommCreatePhase1(CkReductionMsg* impl_msg);
  __idx_intercommCreatePhase1_CkReductionMsg = CkRegisterEp("intercommCreatePhase1(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_intercommCreatePhase1_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0);

// REG: void intercommMergePhase1(CkReductionMsg* impl_msg);
  __idx_intercommMergePhase1_CkReductionMsg = CkRegisterEp("intercommMergePhase1(CkReductionMsg* impl_msg)",
     (CkCallFnPtr)_call_intercommMergePhase1_CkReductionMsg, CMessage_CkReductionMsg::__idx, __idx, 0);

// REG: void setRemoteProxy(const CProxy_ampi &rproxy);
  __idx_setRemoteProxy_marshall15 = CkRegisterEp("setRemoteProxy(const CProxy_ampi &rproxy)",
     (CkCallFnPtr)_call_setRemoteProxy_marshall15, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_setRemoteProxy_marshall15,(CkMarshallUnpackFn)_callmarshall_setRemoteProxy_marshall15);
  CkRegisterMessagePupFn(__idx_setRemoteProxy_marshall15,(CkMessagePupFn)_marshallmessagepup_setRemoteProxy_marshall15);

// REG: void winRemotePut(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src);
  __idx_winRemotePut_marshall16 = CkRegisterEp("winRemotePut(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src)",
     (CkCallFnPtr)_call_winRemotePut_marshall16, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_winRemotePut_marshall16,(CkMarshallUnpackFn)_callmarshall_winRemotePut_marshall16);
  CkRegisterMessagePupFn(__idx_winRemotePut_marshall16,(CkMessagePupFn)_marshallmessagepup_winRemotePut_marshall16);

// REG: void winRemoteGet(int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src);
  __idx_winRemoteGet_marshall17 = CkRegisterEp("winRemoteGet(int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src)",
     (CkCallFnPtr)_call_winRemoteGet_marshall17, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_winRemoteGet_marshall17,(CkMarshallUnpackFn)_callmarshall_winRemoteGet_marshall17);
  CkRegisterMessagePupFn(__idx_winRemoteGet_marshall17,(CkMessagePupFn)_marshallmessagepup_winRemoteGet_marshall17);

// REG: void winRemoteAccumulate(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src);
  __idx_winRemoteAccumulate_marshall18 = CkRegisterEp("winRemoteAccumulate(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src)",
     (CkCallFnPtr)_call_winRemoteAccumulate_marshall18, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_winRemoteAccumulate_marshall18,(CkMarshallUnpackFn)_callmarshall_winRemoteAccumulate_marshall18);
  CkRegisterMessagePupFn(__idx_winRemoteAccumulate_marshall18,(CkMessagePupFn)_marshallmessagepup_winRemoteAccumulate_marshall18);

// REG: void winRemoteLock(int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank);
  __idx_winRemoteLock_marshall19 = CkRegisterEp("winRemoteLock(int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank)",
     (CkCallFnPtr)_call_winRemoteLock_marshall19, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_winRemoteLock_marshall19,(CkMarshallUnpackFn)_callmarshall_winRemoteLock_marshall19);
  CkRegisterMessagePupFn(__idx_winRemoteLock_marshall19,(CkMessagePupFn)_marshallmessagepup_winRemoteLock_marshall19);

// REG: void winRemoteUnlock(int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank);
  __idx_winRemoteUnlock_marshall20 = CkRegisterEp("winRemoteUnlock(int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank)",
     (CkCallFnPtr)_call_winRemoteUnlock_marshall20, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_winRemoteUnlock_marshall20,(CkMarshallUnpackFn)_callmarshall_winRemoteUnlock_marshall20);
  CkRegisterMessagePupFn(__idx_winRemoteUnlock_marshall20,(CkMessagePupFn)_marshallmessagepup_winRemoteUnlock_marshall20);

// REG: AmpiMsg* winRemoteIGet(int orgdisp, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex);
  __idx_winRemoteIGet_marshall21 = CkRegisterEp("winRemoteIGet(int orgdisp, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex)",
     (CkCallFnPtr)_call_winRemoteIGet_marshall21, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_winRemoteIGet_marshall21,(CkMarshallUnpackFn)_callmarshall_winRemoteIGet_marshall21);
  CkRegisterMessagePupFn(__idx_winRemoteIGet_marshall21,(CkMessagePupFn)_marshallmessagepup_winRemoteIGet_marshall21);

// REG: AmpiMsg* Alltoall_RemoteIGet(int disp, int cnt, const MPI_Datatype &type, int tag);
  __idx_Alltoall_RemoteIGet_marshall22 = CkRegisterEp("Alltoall_RemoteIGet(int disp, int cnt, const MPI_Datatype &type, int tag)",
     (CkCallFnPtr)_call_Alltoall_RemoteIGet_marshall22, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_Alltoall_RemoteIGet_marshall22,(CkMarshallUnpackFn)_callmarshall_Alltoall_RemoteIGet_marshall22);
  CkRegisterMessagePupFn(__idx_Alltoall_RemoteIGet_marshall22,(CkMessagePupFn)_marshallmessagepup_Alltoall_RemoteIGet_marshall22);

}
#endif

/* DEFS: group ampiWorlds: IrrGroup{
ampiWorlds(CkMigrateMessage* impl_msg);
ampiWorlds(const ampiCommStruct &nextWorld);
void add(const ampiCommStruct &nextWorld);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_ampiWorlds::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: ampiWorlds(CkMigrateMessage* impl_msg);
 */

/* DEFS: ampiWorlds(const ampiCommStruct &nextWorld);
 */

/* DEFS: void add(const ampiCommStruct &nextWorld);
 */
void CProxyElement_ampiWorlds::add(const ampiCommStruct &nextWorld, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const ampiCommStruct &nextWorld
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)nextWorld;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)nextWorld;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ampiWorlds::__idx_add_marshall2, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_ampiWorlds::__idx_add_marshall2, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_ampiWorlds::__idx_add_marshall2, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: ampiWorlds(CkMigrateMessage* impl_msg);
 */
 int CkIndex_ampiWorlds::__idx_ampiWorlds_CkMigrateMessage=0;
void CkIndex_ampiWorlds::_call_ampiWorlds_CkMigrateMessage(void* impl_msg,ampiWorlds * impl_obj)
{
  new (impl_obj) ampiWorlds((CkMigrateMessage*)impl_msg);
}

/* DEFS: ampiWorlds(const ampiCommStruct &nextWorld);
 */
CkGroupID CProxy_ampiWorlds::ckNew(const ampiCommStruct &nextWorld, const CkEntryOptions *impl_e_opts)
{
  //Marshall: const ampiCommStruct &nextWorld
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)nextWorld;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)nextWorld;
  }
  return CkCreateGroup(CkIndex_ampiWorlds::__idx, CkIndex_ampiWorlds::__idx_ampiWorlds_marshall1, impl_msg);
}
  CProxy_ampiWorlds::CProxy_ampiWorlds(const ampiCommStruct &nextWorld, const CkEntryOptions *impl_e_opts)
{
  //Marshall: const ampiCommStruct &nextWorld
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)nextWorld;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)nextWorld;
  }
  ckSetGroupID(CkCreateGroup(CkIndex_ampiWorlds::__idx, CkIndex_ampiWorlds::__idx_ampiWorlds_marshall1, impl_msg));
}
 int CkIndex_ampiWorlds::__idx_ampiWorlds_marshall1=0;
void CkIndex_ampiWorlds::_call_ampiWorlds_marshall1(void* impl_msg,ampiWorlds * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const ampiCommStruct &nextWorld*/
  PUP::fromMem implP(impl_buf);
  ampiCommStruct nextWorld; implP|nextWorld;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) ampiWorlds(nextWorld);
}
int CkIndex_ampiWorlds::_callmarshall_ampiWorlds_marshall1(char* impl_buf,ampiWorlds * impl_obj) {
  /*Unmarshall pup'd fields: const ampiCommStruct &nextWorld*/
  PUP::fromMem implP(impl_buf);
  ampiCommStruct nextWorld; implP|nextWorld;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  new (impl_obj) ampiWorlds(nextWorld);
  return implP.size();
}
void CkIndex_ampiWorlds::_marshallmessagepup_ampiWorlds_marshall1(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const ampiCommStruct &nextWorld*/
  PUP::fromMem implP(impl_buf);
  ampiCommStruct nextWorld; implP|nextWorld;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("nextWorld");
  implDestP|nextWorld;
}

/* DEFS: void add(const ampiCommStruct &nextWorld);
 */
void CProxy_ampiWorlds::add(const ampiCommStruct &nextWorld, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const ampiCommStruct &nextWorld
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)nextWorld;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)nextWorld;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ampiWorlds::__idx_add_marshall2, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_ampiWorlds::__idx_add_marshall2, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_ampiWorlds::__idx_add_marshall2, impl_msg, ckGetGroupID(),0);
}
void CProxy_ampiWorlds::add(const ampiCommStruct &nextWorld, int npes, int *pes, const CkEntryOptions *impl_e_opts) {
  //Marshall: const ampiCommStruct &nextWorld
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)nextWorld;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)nextWorld;
  }
  CkSendMsgBranchMulti(CkIndex_ampiWorlds::__idx_add_marshall2, impl_msg, ckGetGroupID(), npes, pes,0);
}
 int CkIndex_ampiWorlds::__idx_add_marshall2=0;
void CkIndex_ampiWorlds::_call_add_marshall2(void* impl_msg,ampiWorlds * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const ampiCommStruct &nextWorld*/
  PUP::fromMem implP(impl_buf);
  ampiCommStruct nextWorld; implP|nextWorld;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->add(nextWorld);
}
int CkIndex_ampiWorlds::_callmarshall_add_marshall2(char* impl_buf,ampiWorlds * impl_obj) {
  /*Unmarshall pup'd fields: const ampiCommStruct &nextWorld*/
  PUP::fromMem implP(impl_buf);
  ampiCommStruct nextWorld; implP|nextWorld;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->add(nextWorld);
  return implP.size();
}
void CkIndex_ampiWorlds::_marshallmessagepup_add_marshall2(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const ampiCommStruct &nextWorld*/
  PUP::fromMem implP(impl_buf);
  ampiCommStruct nextWorld; implP|nextWorld;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("nextWorld");
  implDestP|nextWorld;
}

/* DEFS: ampiWorlds(CkMigrateMessage* impl_msg);
 */

/* DEFS: ampiWorlds(const ampiCommStruct &nextWorld);
 */

/* DEFS: void add(const ampiCommStruct &nextWorld);
 */
void CProxySection_ampiWorlds::add(const ampiCommStruct &nextWorld, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const ampiCommStruct &nextWorld
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)nextWorld;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(ampiCommStruct &)nextWorld;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_ampiWorlds::__idx_add_marshall2, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSectionSend(ckDelegatedPtr(),CkIndex_ampiWorlds::__idx_add_marshall2, impl_msg, ckGetNumSections(), ckGetSectionIDs());
  } else {
    void *impl_msg_tmp = (ckGetNumSections()>1) ? CkCopyMsg((void **) &impl_msg) : impl_msg;
    for (int i=0; i<ckGetNumSections(); ++i) {
       impl_msg_tmp= (i<ckGetNumSections()-1) ? CkCopyMsg((void **) &impl_msg):impl_msg;
       CkSendMsgBranchMulti(CkIndex_ampiWorlds::__idx_add_marshall2, impl_msg_tmp, ckGetGroupIDn(i), ckGetNumElements(i), ckGetElements(i),0);
    }
  }
}

#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_ampiWorlds::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size, TypeGroup);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,ampiWorlds::isIrreducible());
// REG: ampiWorlds(CkMigrateMessage* impl_msg);
  __idx_ampiWorlds_CkMigrateMessage = CkRegisterEp("ampiWorlds(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_ampiWorlds_CkMigrateMessage, 0, __idx, 0);
  CkRegisterMigCtor(__idx, __idx_ampiWorlds_CkMigrateMessage);

// REG: ampiWorlds(const ampiCommStruct &nextWorld);
  __idx_ampiWorlds_marshall1 = CkRegisterEp("ampiWorlds(const ampiCommStruct &nextWorld)",
     (CkCallFnPtr)_call_ampiWorlds_marshall1, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_ampiWorlds_marshall1,(CkMarshallUnpackFn)_callmarshall_ampiWorlds_marshall1);
  CkRegisterMessagePupFn(__idx_ampiWorlds_marshall1,(CkMessagePupFn)_marshallmessagepup_ampiWorlds_marshall1);

// REG: void add(const ampiCommStruct &nextWorld);
  __idx_add_marshall2 = CkRegisterEp("add(const ampiCommStruct &nextWorld)",
     (CkCallFnPtr)_call_add_marshall2, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_add_marshall2,(CkMarshallUnpackFn)_callmarshall_add_marshall2);
  CkRegisterMessagePupFn(__idx_add_marshall2,(CkMessagePupFn)_marshallmessagepup_add_marshall2);

}
#endif

#ifndef CK_TEMPLATES_ONLY
void _registerampi(void)
{
  static int _done = 0; if(_done) return; _done = 1;
/* REG: message AmpiMsg{
char data[];
}
;
*/
CMessage_AmpiMsg::__register("AmpiMsg", sizeof(AmpiMsg),(CkPackFnPtr) AmpiMsg::pack,(CkUnpackFnPtr) AmpiMsg::unpack);

      _registerInitCall(ampiNodeInit,1);

      _registerInitCall(ampiProcInit,0);

/* REG: array ampiParent: ArrayElement{
ampiParent(CkMigrateMessage* impl_msg);
ampiParent(int universeNo, const CProxy_TCharm &threads_);
void ResumeThread(void);
void Checkpoint(int len, const char *dname);
void ExchangeProxy(const CProxy_ampi &impl_noname_0);
};
*/
  CkIndex_ampiParent::__register("ampiParent", sizeof(ampiParent));

/* REG: array ampi: ArrayElement{
ampi(CkMigrateMessage* impl_msg);
ampi(void);
ampi(const CkArrayID &parent_, const ampiCommStruct &s);
ampi(const CkArrayID &parent_, const ampiCommStruct &s, const ComlibInstanceHandle &ciStreaming_, const ComlibInstanceHandle &ciBcast_, const ComlibInstanceHandle &ciAllgather_, const ComlibInstanceHandle &ciAlltoall_);
void allInitDone(CkReductionMsg* impl_msg);
void setInitDoneFlag(void);
void unblock(void);
void generic(AmpiMsg* impl_msg);
void reduceResult(CkReductionMsg* impl_msg);
void splitPhase1(CkReductionMsg* impl_msg);
void commCreatePhase1(CkReductionMsg* impl_msg);
void cartCreatePhase1(CkReductionMsg* impl_msg);
void graphCreatePhase1(CkReductionMsg* impl_msg);
void intercommCreatePhase1(CkReductionMsg* impl_msg);
void intercommMergePhase1(CkReductionMsg* impl_msg);
void setRemoteProxy(const CProxy_ampi &rproxy);
void winRemotePut(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src);
void winRemoteGet(int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex, const CkFutureID &ftHandle, int pe_src);
void winRemoteAccumulate(int orgtotalsize, const char *orgaddr, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, const MPI_Op &op, int winIndex, const CkFutureID &ftHandle, int pe_src);
void winRemoteLock(int lock_type, int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank);
void winRemoteUnlock(int winIndex, const CkFutureID &ftHandle, int pe_src, int requestRank);
AmpiMsg* winRemoteIGet(int orgdisp, int orgcnt, const MPI_Datatype &orgtype, const MPI_Aint &targdisp, int targcnt, const MPI_Datatype &targtype, int winIndex);
AmpiMsg* Alltoall_RemoteIGet(int disp, int cnt, const MPI_Datatype &type, int tag);
};
*/
  CkIndex_ampi::__register("ampi", sizeof(ampi));

/* REG: group ampiWorlds: IrrGroup{
ampiWorlds(CkMigrateMessage* impl_msg);
ampiWorlds(const ampiCommStruct &nextWorld);
void add(const ampiCommStruct &nextWorld);
};
*/
  CkIndex_ampiWorlds::__register("ampiWorlds", sizeof(ampiWorlds));

}
#endif
