/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import projections.gui.Timeline.Data;

public class AxisOverlayPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private AxisOverlayPanel thisPanel;
    private Data data;

    public AxisOverlayPanel(Data data) {
        this.data = data;
        this.thisPanel = this;
        this.addComponentListener(new MyListener());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setOpaque(false);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.data.selectionValid()) {
            g.setColor(Color.white);
            g.drawLine(this.data.leftSelection(), 0, this.data.leftSelection(), this.getHeight() - 1);
            g.drawLine(this.data.rightSelection(), 0, this.data.rightSelection(), this.getHeight() - 1);
        }
        if (this.data.highlightValid()) {
            g.setColor(Color.white);
            g.drawLine(this.data.getHighlight(), 0, this.data.getHighlight(), this.getHeight() - 1);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.data.setSelection2(e.getPoint().x);
        this.data.setHighlight(e.getPoint().x);
    }

    public void mouseMoved(MouseEvent e) {
        this.data.setHighlight(e.getPoint().x);
    }

    public void mouseClicked(MouseEvent e) {
        this.data.invalidateSelection();
    }

    public void mousePressed(MouseEvent e) {
        this.data.setSelection1(e.getPoint().x);
    }

    public void mouseReleased(MouseEvent e) {
        this.data.setSelection2(e.getPoint().x);
        this.data.setHighlight(e.getPoint().x);
    }

    public void mouseEntered(MouseEvent e) {
        this.setCursor(new Cursor(1));
        this.data.setHighlight(e.getPoint().x);
    }

    public void mouseExited(MouseEvent e) {
        this.setCursor(new Cursor(0));
        this.data.removeHighlight();
    }

    public class MyListener
    implements ComponentListener {
        public void componentHidden(ComponentEvent e) {
        }

        public void componentMoved(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
            AxisOverlayPanel.this.data.invalidateSelection();
            AxisOverlayPanel.this.thisPanel.repaint();
        }

        public void componentShown(ComponentEvent e) {
        }
    }
}

