/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.inspect.DataType;
import charm.debug.inspect.GenericElement;
import charm.debug.inspect.GenericType;
import charm.debug.inspect.Inspector;
import charm.debug.inspect.TypeVisitor;
import java.nio.ByteBuffer;

public class TypedefType
extends GenericType {
    GenericType real;
    int pointer;

    @Override
    public GenericType build(String n, String d) {
        int p;
        String realName = this.name = n;
        String realDesc = d;
        int ptr = 0;
        do {
            p = 0;
            for (int i = realDesc.length() - 1; i >= 0 && realDesc.charAt(i) == '*'; --i) {
                ++p;
            }
            ptr += p;
        } while ((realDesc = TypedefType.getDescription(realName = realDesc.substring(0, realDesc.length() - p).trim())).indexOf("{") == -1 && !realDesc.equals(realName));
        System.out.println("realName: " + realName);
        GenericType realType = Inspector.getType(realName);
        if (realType == null) {
            realType = new DataType();
            Inspector.putType(realName, realType);
            realType.build(realName, realDesc);
        }
        this.real = realType;
        this.pointer = ptr;
        return this;
    }

    public GenericType build(String n, DataType t, int p) {
        this.name = n;
        this.pointer = p;
        this.real = t;
        return this;
    }

    @Override
    public int getChildren() {
        return this.real.getChildren();
    }

    @Override
    public GenericElement getChild(int i) {
        return this.real.getChild(i);
    }

    @Override
    public String getValue(TypeVisitor v) {
        StringBuffer buf = new StringBuffer(this.real.getName());
        for (int i = 0; i < this.pointer; ++i) {
            buf.append('*');
        }
        if (this.real.getChildren() == 0) {
            buf.append(' ').append(this.real.getValue(v));
        }
        return buf.toString();
    }

    @Override
    public int getPointer() {
        return this.pointer;
    }

    public boolean isVirtual() {
        if (this.real instanceof DataType) {
            return ((DataType)this.real).isVirtual;
        }
        return false;
    }

    @Override
    public int getSize() {
        if (this.pointer > 0) {
            return this.pointerSize();
        }
        return this.real.getSize();
    }

    @Override
    public GenericType getType() {
        return this.real.getType();
    }

    @Override
    public boolean equals(GenericType t) {
        return this.name.equals(t.name) || this.real.equals(t);
    }

    @Override
    public boolean equals(TypedefType t) {
        return this.name.equals(t.name) || this.equals(t.real);
    }

    @Override
    public String toString(String indent) {
        System.out.println("typedef: |" + this.name + "| to |" + this.real.getName() + "|");
        StringBuffer buf = new StringBuffer();
        buf.append(this.name).append(" (");
        buf.append(this.real.toString(indent)).append(")");
        if (this.pointer > 0) {
            buf.append(" ");
            for (int i = 0; i < this.pointer; ++i) {
                buf.append("*");
            }
        }
        return buf.toString();
    }

    @Override
    public String memoryToString(String indent, ByteBuffer mem, int start) {
        if (this.pointer > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.real.getName());
            for (int i = 0; i < this.pointer; ++i) {
                buf.append("*");
            }
            buf.append(" ").append(TypedefType.printPointer(mem, start));
            return buf.toString();
        }
        return this.real.getName() + " " + this.real.memoryToString(indent, mem, start);
    }

    @Override
    public void visit(TypeVisitor v) {
        if (this.pointer > 0) {
            v.setPointer(this.pointer);
            v.addValue(v.printPointer());
        } else {
            v.addValue(this.real.getName());
            v.push();
            this.real.visit(v);
            v.pop();
        }
    }
}

