/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.IOException;
import projections.analysis.ProjDefs;
import projections.analysis.ProjectionsFormatException;

public abstract class ProjectionsReader
extends ProjDefs {
    private boolean available;
    protected String expectedVersion = null;
    protected String sourceString;

    public ProjectionsReader(String sourceString, String versionOverride) {
        this.expectedVersion = versionOverride;
        this.sourceString = sourceString;
        this.available = this.checkAvailable();
        if (this.available) {
            try {
                this.readStaticData();
            }
            catch (ProjectionsFormatException e) {
                System.err.println("Format Exception when reading from source [" + sourceString + "]");
                System.err.println(e.toString());
                System.err.println("Data is now marked as unavailable.");
                this.available = false;
            }
            catch (IOException e) {
                System.err.println("Unexpected IO error when reading from source [" + sourceString + "]");
                System.err.println("Data is now marked as unavailable.");
                this.available = false;
            }
        }
    }

    public ProjectionsReader(String sourceString) {
        this(sourceString, null);
    }

    protected abstract boolean checkAvailable();

    public final boolean isAvailable() {
        return this.available;
    }

    protected final void markUnavailable() {
        this.available = false;
    }

    protected abstract void readStaticData() throws IOException;

    public abstract void reset() throws IOException;
}

