/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import projections.analysis.NoiseMinerThread;
import projections.analysis.ProjDefs;
import projections.analysis.ThreadManager;
import projections.analysis.TimelineEvent;
import projections.gui.MainWindow;
import projections.gui.NoiseMinerExemplarTimelineWindow;
import projections.gui.OrderedIntList;

public class NoiseMiner
extends ProjDefs {
    int myRun = 0;
    private int numPe;
    private long startTime;
    private long endTime;
    private OrderedIntList peList;
    private String loggingText;
    private Duration osQuanta;
    private int eventsInBinWindow = 50;
    protected double peMergeDistance = 0.15;
    protected double importanceCutoff = 0.8;
    private int nbins = 5001;
    private Duration binWidth = new Duration(10L);
    public int numDisplayBins = 200;
    private LinkedList finalResults;
    public long[] histogramToDisplay;

    private LinkedList clusterResultsAcrossProcs(LinkedList results) {
        System.out.println("clusterResultsAcrossProcs() input size=" + results.size());
        LinkedList<NoiseResult> newResults = new LinkedList<NoiseResult>();
        for (NoiseResult v : results) {
            Iterator itr2 = newResults.iterator();
            boolean inserted = false;
            while (itr2.hasNext() && !inserted) {
                NoiseResult c = (NoiseResult)itr2.next();
                if (!(c.distance(v) < this.peMergeDistance)) continue;
                c.merge(v);
                inserted = true;
            }
            if (inserted) continue;
            newResults.add(v);
        }
        System.out.println("Merged " + results.size() + " clusters across all processors into " + newResults.size() + " resulting clusters");
        return newResults;
    }

    public LinkedList filterResults(LinkedList results) {
        int keepCount = 0;
        int dropCount = 0;
        LinkedList<NoiseResult> newResults = new LinkedList<NoiseResult>();
        for (NoiseResult v : results) {
            if (v.occurrences > 5L) {
                double importance = v.duration.us() / v.period().us() * Math.log(v.duration.us());
                System.out.println("importance=" + importance + " occurrences=" + v.occurrences);
                if (importance > this.importanceCutoff) {
                    newResults.add(v);
                    ++keepCount;
                    continue;
                }
                ++dropCount;
                continue;
            }
            ++dropCount;
        }
        System.out.println("Filtering out " + dropCount + " of " + (dropCount + keepCount) + " results");
        return newResults;
    }

    public NoiseMiner(long startInterval, long endInterval, OrderedIntList processorList) {
        this.peList = processorList;
        this.numPe = this.peList.size();
        this.setStartTime(startInterval);
        this.setEndTime(endInterval);
        this.osQuanta = new Duration();
        this.osQuanta.set_ms(100.0);
        this.loggingText = "";
    }

    public void gatherData(Component parent) {
        this.peList.reset();
        int numPs = this.peList.size();
        LinkedList<NoiseMinerThread> readyReaders = new LinkedList<NoiseMinerThread>();
        int p = 0;
        while (p < numPs) {
            int pe = this.peList.nextElement();
            readyReaders.add(new NoiseMinerThread(pe, MainWindow.runObject[this.myRun], this));
            ++p;
        }
        ThreadManager threadManager = new ThreadManager("Loading Files in Parallel", readyReaders, parent);
        threadManager.runThreads();
        this.histogramToDisplay = new long[this.numDisplayBins];
        int i = 0;
        while (i < this.numDisplayBins) {
            this.histogramToDisplay[i] = 0L;
            ++i;
        }
        LinkedList results = new LinkedList();
        for (NoiseMinerThread thread : readyReaders) {
            results.addAll(thread.results);
            int i2 = 0;
            while (i2 < this.numDisplayBins) {
                int n = i2;
                this.histogramToDisplay[n] = this.histogramToDisplay[n] + thread.histogramToDisplay[i2];
                ++i2;
            }
        }
        this.finalResults = this.clusterResultsAcrossProcs(results);
        results = null;
        this.finalResults = this.filterResults(this.finalResults);
    }

    public String getText() {
        String s = "NoiseMiner Text Report:\n";
        s = String.valueOf(s) + "Time range " + this.getStartTime() + " to " + this.getEndTime() + "\n";
        s = String.valueOf(s) + this.loggingText;
        return s;
    }

    public int numOldBinsPerNewBin() {
        return (int)Math.ceil((double)this.getNbins() / (double)this.numDisplayBins);
    }

    public double usPerDisplayBin() {
        return this.binWidth.us() * (double)this.numOldBinsPerNewBin();
    }

    public Vector getResultsTable() {
        Collections.sort(this.finalResults);
        int numResultRows = this.finalResults.size();
        Vector resultTable = new Vector();
        for (NoiseResult v : this.finalResults) {
            Vector<Object> row = new Vector<Object>();
            row.add(new String("" + v.duration));
            row.add(new String(v.pe_toString()));
            row.add(new String("" + v.occurrences));
            row.add(new String("" + v.period()));
            if (v.period().us() < this.osQuanta.us() * 0.8) {
                row.add(new String("internal"));
            } else {
                row.add(new String("external"));
            }
            row.add(new NoiseResultButton("view", v));
            resultTable.add(row);
        }
        if (resultTable.size() == 0) {
            Vector<String> row = new Vector<String>();
            row.add(new String("No Noise Components Found"));
            row.add(new String("n/a"));
            row.add(new String("n/a"));
            row.add(new String("n/a"));
            row.add(new String("n/a"));
            resultTable.add(row);
        }
        return resultTable;
    }

    public int getNumBins() {
        return this.getNbins();
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setNbins(int nbins) {
        this.nbins = nbins;
    }

    public int getNbins() {
        return this.nbins;
    }

    public Duration binWidth() {
        return this.binWidth;
    }

    public class Cluster {
        private Duration sum;
        private long count;
        EventWindow events;

        Cluster(Duration s, long c, EventWindow ew) {
            this.sum = new Duration(s);
            this.count = c;
            this.events = new EventWindow(NoiseMiner.this.eventsInBinWindow);
            this.events.merge(ew);
        }

        Cluster(double s_us, long c, EventWindow ew) {
            this.sum = new Duration(s_us);
            this.count = c;
            this.events = new EventWindow(NoiseMiner.this.eventsInBinWindow);
            this.events.merge(ew);
        }

        public void merge(Duration s, long c, EventWindow ew) {
            this.sum.add(s);
            this.count += c;
            this.events.merge(ew);
        }

        public void merge(Cluster c) {
            this.sum.add(c.sum);
            this.count += c.count;
            this.events.merge(c.events);
        }

        Duration mean() {
            Duration d = new Duration(this.sum.us() / (double)this.count);
            return d;
        }

        long count() {
            return this.count;
        }

        Duration sum() {
            return this.sum;
        }
    }

    public class Duration
    extends Time {
        public Duration() {
            this.d = 0.0;
        }

        public Duration(long us) {
            this.d = us;
        }

        public Duration(Time p) {
            this.d = p.d;
        }

        public Duration(Time start, Time end) {
            this.d = end.d - start.d;
        }

        public Duration(long start_us, long end_us) {
            this.d = end_us - start_us;
        }

        public Duration(double start_us, double end_us) {
            this.d = end_us - start_us;
        }

        public Duration(double us) {
            this.d = us;
        }
    }

    public class Event
    implements Comparable {
        public int event;
        public int userEvent;

        public Event(int e, int u) {
            this.event = e;
            this.userEvent = u;
        }

        public int compareTo(Object o) {
            Event other = (Event)o;
            if (this.event == other.event) {
                return this.userEvent - other.userEvent;
            }
            return this.event - other.event;
        }
    }

    public class EventWindow {
        public TreeSet occurrences = new TreeSet();
        private int max;

        EventWindow(int maxSize) {
            this.max = maxSize;
        }

        public void insert(TimelineEvent e) {
            this.occurrences.add(e);
            if (this.occurrences.size() > this.max) {
                this.occurrences.remove(this.occurrences.first());
            }
        }

        public void merge(EventWindow ew) {
            for (TimelineEvent v : ew.occurrences) {
                this.occurrences.add(v);
                if (this.occurrences.size() <= this.max) continue;
                this.occurrences.remove(this.occurrences.first());
            }
        }

        public int size() {
            return this.occurrences.size();
        }

        public TimelineEvent getFirst() {
            return (TimelineEvent)this.occurrences.first();
        }

        public TimelineEvent getLast() {
            return (TimelineEvent)this.occurrences.last();
        }

        public Duration period() {
            Duration d = new Duration();
            d.set_us((this.getLast().BeginTime - this.getFirst().BeginTime) / (long)this.occurrences.size());
            return d;
        }
    }

    public class Histogram {
        public long[] bin_count;
        public Duration[] bin_sum;
        private EventWindow[] bin_window;
        private Duration cummulativeEventDurations;
        private long eventsSeenSoFar;
        private ArrayList clusters;
        private ArrayList clustersNormalized;

        public int countEvents() {
            int c = 0;
            int i = 0;
            while (i < NoiseMiner.this.getNbins()) {
                c += this.bin_window[i].size();
                ++i;
            }
            return c;
        }

        public ArrayList clustersNormalized() {
            return this.clustersNormalized;
        }

        public ArrayList clusters() {
            return this.clusters;
        }

        public Cluster primaryNoise() {
            return (Cluster)this.clustersNormalized.get(1);
        }

        public boolean hasPrimaryNoise() {
            return this.clustersNormalized.size() > 1;
        }

        public Cluster secondaryNoise() {
            return (Cluster)this.clustersNormalized.get(2);
        }

        public boolean hasSecondaryNoise() {
            return this.clustersNormalized.size() > 2;
        }

        public Cluster nthNoise(int n) {
            return (Cluster)this.clustersNormalized.get(n);
        }

        public boolean hasNthNoiseComponent(int n) {
            return this.clustersNormalized.size() > n;
        }

        public Histogram() {
            this.cummulativeEventDurations = new Duration(0L);
            this.bin_count = new long[NoiseMiner.this.getNbins()];
            this.bin_sum = new Duration[NoiseMiner.this.getNbins()];
            this.bin_window = new EventWindow[NoiseMiner.this.getNbins()];
            int i = 0;
            while (i < NoiseMiner.this.getNbins()) {
                this.bin_count[i] = 0L;
                this.bin_sum[i] = new Duration(0.0);
                this.bin_window[i] = new EventWindow(NoiseMiner.this.eventsInBinWindow);
                ++i;
            }
        }

        public void insert(TimelineEvent event) {
            Duration duration = new Duration(event.EndTime - event.BeginTime);
            ++this.eventsSeenSoFar;
            this.cummulativeEventDurations.add(duration);
            int which_bin = (int)(duration.us() / NoiseMiner.this.binWidth.us());
            if (which_bin > NoiseMiner.this.getNbins() - 1) {
                which_bin = NoiseMiner.this.getNbins() - 1;
            }
            if (which_bin >= 0) {
                int n = which_bin;
                this.bin_count[n] = this.bin_count[n] + 1L;
                this.bin_sum[which_bin].add(duration);
                this.bin_window[which_bin].insert(event);
            }
        }

        public void insert(Cluster c) {
            if (c.count() > 0L) {
                this.eventsSeenSoFar += c.count();
                this.cummulativeEventDurations.add(c.sum());
                int which_bin = (int)(c.mean().us() / NoiseMiner.this.binWidth.us());
                if (which_bin > NoiseMiner.this.getNbins() - 1) {
                    which_bin = NoiseMiner.this.getNbins() - 1;
                }
                if (which_bin >= 0) {
                    int n = which_bin;
                    this.bin_count[n] = this.bin_count[n] + c.count();
                    this.bin_sum[which_bin].add(c.sum());
                    this.bin_window[which_bin].merge(c.events);
                }
            }
        }

        public String toString() {
            String s = "";
            if (this.used()) {
                int i = 0;
                while (i < NoiseMiner.this.getNbins()) {
                    s = String.valueOf(s) + this.bin_count[i] + "\t";
                    ++i;
                }
            } else {
                s = "unused";
            }
            return s;
        }

        private boolean used() {
            return this.cummulativeEventDurations.us() > 0.0;
        }

        public boolean isUsed() {
            return this.cummulativeEventDurations.us() > 0.0;
        }

        public void cluster() {
            this.clusters = new ArrayList();
            this.clustersNormalized = new ArrayList();
            boolean done = false;
            long[] bin_data = new long[NoiseMiner.this.getNbins() + 1];
            bin_data[NoiseMiner.this.getNbins()] = 0L;
            int i = 0;
            while (i < NoiseMiner.this.getNbins()) {
                bin_data[i] = this.bin_count[i];
                ++i;
            }
            while (!done) {
                long largest_val = bin_data[0];
                int largest = 0;
                int i2 = 1;
                while (i2 < NoiseMiner.this.getNbins()) {
                    if (bin_data[i2] > largest_val) {
                        largest_val = bin_data[i2];
                        largest = i2;
                    }
                    ++i2;
                }
                if (largest_val == 0L) {
                    done = true;
                    continue;
                }
                bin_data[largest] = 0L;
                Cluster c = new Cluster(this.bin_sum[largest], this.bin_count[largest], this.bin_window[largest]);
                int j = largest + 1;
                while (j < NoiseMiner.this.getNbins() && (j == NoiseMiner.this.getNbins() - 1 || bin_data[j] >= bin_data[j + 1]) && bin_data[j] != 0L) {
                    c.merge(this.bin_sum[j], this.bin_count[j], this.bin_window[j]);
                    bin_data[j] = 0L;
                    ++j;
                }
                j = largest - 1;
                while (j >= 0 && (j == 0 || bin_data[j] >= bin_data[j - 1]) && bin_data[j] != 0L) {
                    c.merge(this.bin_sum[j], this.bin_count[j], this.bin_window[j]);
                    bin_data[j] = 0L;
                    --j;
                }
                this.clusters.add(c);
            }
            if (this.clusters.size() > 0) {
                ListIterator i3 = this.clusters.listIterator();
                Duration baseMean = ((Cluster)this.clusters.get(0)).mean();
                while (i3.hasNext()) {
                    Cluster c = (Cluster)i3.next();
                    if (!(c.sum().us() - baseMean.us() * (double)c.count() >= 0.0)) continue;
                    this.clustersNormalized.add(new Cluster(c.sum().us() - baseMean.us() * (double)c.count(), c.count(), c.events));
                }
            }
        }

        public String clusters_toString(ArrayList clusters) {
            String result = "";
            ListIterator i = clusters.listIterator();
            while (i.hasNext()) {
                Cluster c = (Cluster)i.next();
                result = String.valueOf(result) + "{ duration= " + c.mean() + ", count=" + c.count() + " wes=" + c.events.size() + " } ";
            }
            return result;
        }

        public String clusters_toString() {
            return this.clusters_toString(this.clusters);
        }

        public String clusters_toString_Normalized() {
            return this.clusters_toString(this.clustersNormalized);
        }

        public Duration binCenter(int whichBin) {
            return new Duration(((double)whichBin + 0.5) * NoiseMiner.this.binWidth.us());
        }

        public Duration binLowerBound(int whichBin) {
            return new Duration((double)whichBin * NoiseMiner.this.binWidth.us());
        }

        public Duration binUpperBound(int whichBin) {
            return new Duration(((double)whichBin + 0.5) * NoiseMiner.this.binWidth.us());
        }

        public int findFirstLocalMax() {
            long current = this.bin_count[1];
            long previous = this.bin_count[0];
            if (current < previous) {
                return 0;
            }
            int i = 1;
            while (i < NoiseMiner.this.getNbins() - 1) {
                long next = this.bin_count[i + 1];
                if (current >= previous && current > next) {
                    return i;
                }
                previous = current;
                current = next;
                ++i;
            }
            return i;
        }

        public long getBin_count(int bin) {
            return this.bin_count[bin];
        }
    }

    public class NoiseResult
    implements Comparable {
        public TreeSet pes = new TreeSet();
        public Duration duration;
        public long occurrences;
        public EventWindow ew;

        public Duration period() {
            return this.ew.period();
        }

        public NoiseResult(Duration d, long o, int pe, EventWindow ew) {
            this.ew = ew;
            this.pes.add(new Integer(pe));
            this.duration = d;
            this.occurrences = o;
        }

        public String pe_toString() {
            String s = "";
            Iterator itr = this.pes.iterator();
            while (itr.hasNext()) {
                Integer v = (Integer)itr.next();
                s = String.valueOf(s) + v;
                if (!itr.hasNext()) continue;
                s = String.valueOf(s) + ", ";
            }
            return s;
        }

        public double distance(NoiseResult nr) {
            double result = 0.0;
            return result += 1.0 * (Math.abs(this.duration.us() - nr.duration.us()) / Math.max(this.duration.us(), nr.duration.us()));
        }

        public void merge(NoiseResult nr) {
            this.pes.addAll(nr.pes);
            this.duration.set_us((this.duration.us() * (double)this.occurrences + nr.duration.us() * (double)nr.occurrences) / (double)(this.occurrences + nr.occurrences));
            this.occurrences += nr.occurrences;
            this.ew.merge(nr.ew);
        }

        public int compareTo(Object other) {
            NoiseResult nr = (NoiseResult)other;
            double d = nr.duration.us() * Math.log(nr.occurrences) - this.duration.us() * Math.log(nr.occurrences);
            if (d < 0.0) {
                return -1;
            }
            if (d > 0.0) {
                return 1;
            }
            return 0;
        }
    }

    public class NoiseResultButton
    extends JButton {
        public NoiseResult nr;

        public NoiseResultButton(String label, NoiseResult nr) {
            super(label);
            this.nr = nr;
        }

        public void display() {
            NoiseMinerExemplarTimelineWindow nmetw = new NoiseMinerExemplarTimelineWindow(this.nr);
            nmetw.setSize(1000, 600);
            nmetw.setVisible(true);
        }
    }

    private class Time {
        protected double d;

        public Time() {
            this.d = 0.0;
        }

        public Time(long us) {
            this.d = us;
        }

        public Time(Time p) {
            this.d = p.d;
        }

        public Time(double us) {
            this.d = us;
        }

        public void set_ms(double p) {
            this.d = p * 1000.0;
        }

        public void set_us(double p) {
            this.d = p;
        }

        public void set(Duration p) {
            this.d = p.d;
        }

        public double us() {
            return this.d;
        }

        public double ms() {
            return this.d / 1000.0;
        }

        public String toString() {
            if (this.d > 1000.0) {
                return this.d / 1000.0 + "(ms)";
            }
            return this.d + "(us)";
        }

        public void add(Time p) {
            this.d += p.d;
        }

        public void add_us(double p) {
            this.d += p;
        }

        public void add_us(long p) {
            this.d += (double)p;
        }
    }
}

