/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import projections.analysis.IntervalUtils;
import projections.analysis.RLEBlock;
import projections.analysis.SumDetailReader;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;

public class IntervalData {
    int myRun = 0;
    public static final int NUM_TYPES = 2;
    public static final int TYPE_TIME = 0;
    public static final int TYPE_NUM_MSGS = 1;
    private static SumDetailReader[] summaryDetails;
    private Vector[][][] rawData;
    private int[][][] systemUsageData = null;
    private int[][][][] systemMsgsData = null;
    private int[][][][] userEntryData = null;
    private int numEPs = 0;
    private int numPEs = MainWindow.runObject[this.myRun].getNumProcessors();
    private int numIntervals = 0;
    private double intervalSize = 0.0;

    public IntervalData() {
        this.numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        if (MainWindow.runObject[this.myRun].hasSumDetailData()) {
            summaryDetails = new SumDetailReader[this.numPEs];
            this.rawData = new Vector[2][this.numPEs][];
            OrderedIntList availablePEs = MainWindow.runObject[this.myRun].getValidProcessorList(2);
            availablePEs.reset();
            while (availablePEs.hasMoreElements()) {
                int pe = availablePEs.nextElement();
                try {
                    IntervalData.summaryDetails[pe] = new SumDetailReader(MainWindow.runObject[this.myRun].getSumDetailName(pe), MainWindow.runObject[this.myRun].getVersion());
                    summaryDetails[pe].read();
                    int type = 0;
                    while (type < 2) {
                        this.rawData[type][pe] = summaryDetails[pe].getData(type);
                        ++type;
                    }
                    if (this.numIntervals < summaryDetails[pe].getNumIntervals()) {
                        this.numIntervals = summaryDetails[pe].getNumIntervals();
                    }
                    this.intervalSize = summaryDetails[pe].getIntervalSize();
                }
                catch (IOException e) {
                    System.err.println("Warning: Failed to read summary detail file for processor " + pe);
                }
            }
        }
    }

    public void loadIntervalData(long intervalSize, int intervalStart, int intervalEnd, boolean byEntryPoint, OrderedIntList processorList) {
        int numIntervals = intervalEnd - intervalStart + 1;
        this.systemUsageData = new int[3][processorList.size()][numIntervals];
        this.systemMsgsData = new int[5][3][processorList.size()][numIntervals];
        if (byEntryPoint) {
            this.userEntryData = new int[this.numEPs][3][processorList.size()][numIntervals];
        }
        double[][] tempData = null;
        int processorCount = 0;
        int curPe = 0;
        processorList.reset();
        while (processorList.hasMoreElements()) {
            int ep;
            curPe = processorList.nextElement();
            tempData = this.getData(curPe, 0, intervalSize, intervalStart, intervalEnd - intervalStart + 1);
            int i = 0;
            while (i < numIntervals) {
                ep = 0;
                while (ep < this.numEPs) {
                    if (byEntryPoint) {
                        this.userEntryData[ep][2][processorCount][i] = (int)tempData[ep][i];
                    }
                    int[] nArray = this.systemUsageData[1][processorCount];
                    int n = i;
                    nArray[n] = nArray[n] + (int)tempData[ep][i];
                    ++ep;
                }
                this.systemUsageData[1][processorCount][i] = (int)IntervalUtils.timeToUtil(this.systemUsageData[1][processorCount][i], (double)intervalSize);
                ++i;
            }
            tempData = this.getData(curPe, 1, intervalSize, intervalStart, intervalEnd - intervalStart + 1);
            i = 0;
            while (i < numIntervals) {
                ep = 0;
                while (ep < this.numEPs) {
                    int[] nArray = this.systemMsgsData[1][2][processorCount];
                    int n = i;
                    nArray[n] = nArray[n] + (int)tempData[ep][i];
                    ++ep;
                }
                ++i;
            }
            ++processorCount;
        }
    }

    public int[][][] getSystemUsageData() {
        return this.systemUsageData;
    }

    public int[][][][] getSystemMsgs() {
        return this.systemMsgsData;
    }

    public int[][][][] getUserEntries() {
        return this.userEntryData;
    }

    public double[][] getData(int pe, int type) {
        double[][] returnData = new double[this.numEPs][this.numIntervals];
        int ep = 0;
        while (ep < this.numEPs) {
            Iterator blockIterator = this.rawData[type][pe][ep].iterator();
            int curInterval = 0;
            while (blockIterator.hasNext()) {
                RLEBlock nextBlock = (RLEBlock)blockIterator.next();
                int offset = 0;
                while (offset < nextBlock.count) {
                    returnData[ep][curInterval + offset] = nextBlock.value;
                    ++offset;
                }
                curInterval += nextBlock.count;
            }
            ++ep;
        }
        return returnData;
    }

    public double[][] getData(int pe, int type, long destIntervalSize, int destIntervalStart, int numDestIntervals) {
        double[][] tempData = this.getData(pe, type);
        double[][] returnData = null;
        if ((double)destIntervalSize == this.intervalSize) {
            if (destIntervalStart == 0 && numDestIntervals == this.numIntervals) {
                return tempData;
            }
            returnData = new double[this.numEPs][numDestIntervals];
            int ep = 0;
            while (ep < tempData.length) {
                int interval = destIntervalStart;
                while (interval < destIntervalStart + numDestIntervals) {
                    returnData[ep][interval - destIntervalStart] = tempData[ep][interval];
                    ++interval;
                }
                ++ep;
            }
            return returnData;
        }
        returnData = new double[this.numEPs][numDestIntervals];
        boolean discrete = false;
        if (type == 1) {
            discrete = true;
        }
        int ep = 0;
        while (ep < tempData.length) {
            int srcInt = 0;
            while (srcInt < tempData[ep].length) {
                IntervalUtils.fillIntervals(returnData[ep], destIntervalSize, destIntervalStart, (long)((double)srcInt * this.intervalSize), (long)((double)(srcInt + 1) * this.intervalSize - 1.0), tempData[ep][srcInt], discrete);
                ++srcInt;
            }
            ++ep;
        }
        return returnData;
    }

    public int getNumIntervals() {
        return this.numIntervals;
    }

    public double getIntervalSize() {
        return this.intervalSize;
    }

    private void accumulateIntoArray(int type, int pe, int epIdx, int startInterval, int endInterval, double[] outData) {
        int currentIdx = 0;
        boolean done = false;
        for (RLEBlock nextBlock : this.rawData[type][pe][epIdx]) {
            int endIdx = currentIdx + nextBlock.count - 1;
            if (endIdx < startInterval) {
                currentIdx = endIdx + 1;
                continue;
            }
            if (currentIdx < startInterval) {
                currentIdx = startInterval;
            }
            if (endIdx > endInterval) {
                endIdx = endInterval;
                done = true;
            }
            int i = currentIdx - startInterval;
            while (i <= endIdx - startInterval) {
                outData[i] = nextBlock.value;
                ++i;
            }
            currentIdx = endIdx + 1;
            if (done) break;
        }
    }

    public double[][] getDataSummedAcrossProcessors(int type, OrderedIntList pes, int startInterval, int endInterval) {
        int numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        double[][] returnArray = new double[numEPs][endInterval - startInterval + 1];
        int ep = 0;
        while (ep < numEPs) {
            pes.reset();
            int i = 0;
            while (i < pes.size()) {
                int pe = pes.nextElement();
                this.accumulateIntoArray(type, pe, ep, startInterval, endInterval, returnArray[ep]);
                ++i;
            }
            ++ep;
        }
        return returnArray;
    }

    public Vector getDataSummedAcrossProcessors(int type, OrderedIntList pes, int startInterval, int endInterval, OrderedIntList eps) {
        Vector<double[]> returnVector = new Vector<double[]>();
        double[] dataArray = null;
        eps.reset();
        int i = 0;
        while (i < eps.size()) {
            dataArray = new double[endInterval - startInterval + 1];
            int ep = eps.nextElement();
            pes.reset();
            int j = 0;
            while (j < pes.size()) {
                int pe = pes.nextElement();
                this.accumulateIntoArray(type, pe, ep, startInterval, endInterval, dataArray);
                ++j;
            }
            returnVector.add(dataArray);
            ++i;
        }
        return returnVector;
    }
}

