/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import projections.gui.GraphControlPanel;
import projections.gui.GraphData;
import projections.gui.GraphDisplayPanel;
import projections.gui.GraphLegendPanel;
import projections.gui.IntervalRangeDialog;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ProjectionsWindow;
import projections.gui.SwingWorker;
import projections.gui.Util;
import projections.misc.PrintUtils;

public class GraphWindow
extends ProjectionsWindow
implements ActionListener {
    int myRun = 0;
    GraphDisplayPanel displayPanel;
    GraphControlPanel controlPanel;
    GraphLegendPanel legendPanel;
    GraphData data;
    GraphWindow thisWindow = this;
    int intervalStart;
    int intervalEnd;
    private long endTime;
    long intervalsize;
    OrderedIntList processorList;
    public static boolean dumpNow = false;
    public static int dumpCount = 0;

    public GraphWindow(MainWindow parentWindow) {
        super(parentWindow);
        this.setBackground(Color.lightGray);
        this.createLayout();
        this.createMenus();
        this.pack();
        this.setTitle("Projections Graph - " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.showDialog();
    }

    public void refreshDisplay() {
        if (this.displayPanel != null) {
            this.displayPanel.refreshDisplay();
        }
        if (this.legendPanel != null) {
            this.legendPanel.repaint();
        }
    }

    protected void windowInit() {
        this.endTime = MainWindow.runObject[this.myRun].getTotalTime();
        this.intervalsize = 1000L;
        this.intervalStart = 0;
        this.intervalEnd = this.endTime % this.intervalsize == 0L ? (int)(this.endTime / this.intervalsize - 1L) : (int)(this.endTime / this.intervalsize);
        this.processorList = MainWindow.runObject[this.myRun].getValidProcessorList();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() instanceof MenuItem) {
            MenuItem mi = (MenuItem)evt.getSource();
            String arg = mi.getLabel();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Print Graph")) {
                this.PrintGraph();
            } else if (arg.equals("Set Interval Size")) {
                this.showDialog();
            } else if (arg.equals("Dump Raw Data")) {
                try {
                    File dumpFile = new File("GraphDump." + dumpCount + ".out");
                    while (dumpFile.exists()) {
                        dumpFile = new File("GraphDump." + ++dumpCount + ".out");
                    }
                    MainWindow.dataDump = new PrintWriter(new FileWriter(dumpFile));
                    dumpNow = true;
                    this.refreshDisplay();
                }
                catch (IOException e) {
                    System.err.println("Failure to handle dump data GraphDump." + dumpCount + ".out");
                    System.exit(-1);
                }
            }
        }
    }

    private void createLayout() {
        Panel p = new Panel();
        this.getContentPane().add("Center", p);
        p.setBackground(Color.gray);
        this.displayPanel = new GraphDisplayPanel();
        this.controlPanel = new GraphControlPanel();
        this.legendPanel = new GraphLegendPanel(this);
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        p.setLayout(gbl);
        gbc.fill = 1;
        Util.gblAdd(p, this.displayPanel, gbc, 0, 0, 1, 1, 2, 1, 2, 2, 2, 2);
        Util.gblAdd(p, this.legendPanel, gbc, 1, 0, 1, 1, 1, 1, 2, 2, 2, 2);
        Util.gblAdd(p, this.controlPanel, gbc, 0, 1, 2, 1, 1, 0, 2, 2, 2, 2);
    }

    private void createMenus() {
        MenuBar mbar = new MenuBar();
        mbar.add(Util.makeMenu("File", new Object[]{"Print Graph", null, "Close"}, this));
        mbar.add(Util.makeMenu("Tools", new Object[]{"Set Interval Size", "Dump Raw Data", "Timeline"}, this));
        Menu helpMenu = new Menu("Help");
        mbar.add(Util.makeMenu(helpMenu, new Object[]{"Index", "About"}, this));
        mbar.setHelpMenu(helpMenu);
        this.setMenuBar(mbar);
    }

    private void PrintGraph() {
        PrinterJob pjob = PrinterJob.getPrinterJob();
        PageFormat format = new PageFormat();
        format = pjob.pageDialog(format);
        pjob.setPrintable(new PrintUtils(this.displayPanel), format);
        if (!pjob.printDialog()) {
            return;
        }
        try {
            pjob.print();
        }
        catch (PrinterException e) {
            System.err.println("Printer failure.");
        }
    }

    void setChildDatas() {
        this.controlPanel.setGraphData(this.data);
        this.displayPanel.setGraphData(this.data);
        this.legendPanel.setGraphData(this.data);
        this.data.graphWindow = this;
        this.data.controlPanel = this.controlPanel;
        this.data.displayPanel = this.displayPanel;
        this.data.legendPanel = this.legendPanel;
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new IntervalRangeDialog(this, "Graph Window");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            if (this.dialog.isModified()) {
                this.setCursor(new Cursor(3));
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        MainWindow.runObject[GraphWindow.this.myRun].LoadGraphData(GraphWindow.this.intervalsize, GraphWindow.this.intervalStart, GraphWindow.this.intervalEnd, true, GraphWindow.this.processorList);
                        GraphWindow.this.data = new GraphData(GraphWindow.this.intervalsize, GraphWindow.this.intervalStart, GraphWindow.this.intervalEnd, GraphWindow.this.processorList);
                        return null;
                    }

                    public void finished() {
                        GraphWindow.this.thisWindow.setChildDatas();
                        if (GraphWindow.this.legendPanel != null) {
                            GraphWindow.this.legendPanel.closeAttributesWindow();
                        }
                        GraphWindow.this.controlPanel.setXMode(GraphWindow.this.data.xmode);
                        GraphWindow.this.controlPanel.setYMode(GraphWindow.this.data.ymode);
                        GraphWindow.this.legendPanel.UpdateLegend();
                        GraphWindow.this.displayPanel.setAllBounds();
                        GraphWindow.this.displayPanel.UpdateDisplay();
                        GraphWindow.this.thisWindow.setCursor(new Cursor(0));
                        GraphWindow.this.thisWindow.setVisible(true);
                    }
                };
                worker.start();
            } else {
                this.setVisible(true);
            }
        } else {
            return;
        }
    }

    public void getDialogData() {
        IntervalRangeDialog dialog = (IntervalRangeDialog)this.dialog;
        this.intervalsize = dialog.getIntervalSize();
        this.intervalStart = (int)dialog.getStartInterval();
        this.intervalEnd = (int)dialog.getEndInterval();
        this.processorList = dialog.getValidProcessors();
    }

    public void setDialogData() {
        IntervalRangeDialog dialog = (IntervalRangeDialog)this.dialog;
        dialog.setIntervalSize(this.intervalsize);
        dialog.setValidProcessors(this.processorList);
        super.setDialogData();
    }
}

