package jade.JJ;

import antlr.collections.AST;
import java.util.Stack;
import java.io.StringReader;
import jade.JavaLexer;
import jade.JavaRecognizer;

public class J implements jade.JavaTokenTypes {

//  ================ CONSTANTS ================

    public static final String strChare = new String("Chare");
    public static final String strChareArray1D = new String("ChareArray1D");
    public static final String strChareArray2D = new String("ChareArray2D");
    public static boolean isStrChareArray(String s) {
        return ( s.equals(strChareArray1D) || s.equals(strChareArray2D) );
    }
    public static boolean isStrChareStar(String s) {
        return ( s.equals(strChare) || isStrChareArray(s) );
    }

    public static final String msa1d = new String("MSA1D");
    public static final String msa2d = new String("MSA2D");
    public static boolean isStrMSA(String s) {
        return ( s.equals(msa1d) || s.equals(msa2d) );
    }

//  ================ UTILITY FUNCTIONS ================

    /** abort with stack trace */
    public static void abort1(int exitCode) {

        // I do this to get a stack trace
        try { int []a; a = null; a[2] = 1; } catch(Exception e) { e.printStackTrace(); }
        System.exit(exitCode);

        // another option, which is more informative?
        {
            System.out.println("ASSERT FAILED");
            // I do this to get a stack trace and figure out where the
            // assert was called from.
            String s = null;
            s.equals("a");
            System.exit(-2);
        }
    }

    /* assert functionality. If value is false, barfs and generates a
     * stack trace. */
    public static void assert1(boolean value) {
        if (!value) abort1(-2);
    }

    public static void internalError(AST n, String msg) {
        System.out.println( ((n!=null)?((ASTJ)n).getLine():-1) + ": INTERNAL FATAL ERROR: " + msg);
        abort1(-1);
    }

    public static void fatalError(AST n, String msg) {
        System.out.println( ((n!=null)?((ASTJ)n).getLine():-1) + ": FATAL ERROR: " + msg);
        System.exit(1);
    }

    public static void nonfatalError(AST n, String msg) {
        System.out.println( ((n!=null)?((ASTJ)n).getLine():-1) + ": NONFATAL ERROR: " + msg);
    }

    public static void warning(AST n, String msg) {
        System.out.println( ((n!=null)?((ASTJ)n).getLine():-1) + ": WARNING: " + msg);
    }

//  ================ parseString ================

    /** This is a cool function.  It take a string "{ ... }" and
     * basically parses it with the java.g parser to generate an AST,
     * which it returns.
     */
    public static ASTJ parseString(String s) {
        String f = "<string>";
        StringReader r = new StringReader(s);

        // Create a scanner that reads from the input stream passed to us
        JavaLexer lexer = new JavaLexer(r);
        lexer.setFilename(f);

        // Create a parser that reads from the scanner
        JavaRecognizer parser = new JavaRecognizer(lexer);
        parser.setFilename(f);
        parser.setASTNodeClass("jade.JJ.ASTJ");

        // start parsing at the compoundStatement rule
        try {
            parser.compoundStatement();
        }
        catch (Exception e) {
            System.err.println("parser exception: "+e);
            e.printStackTrace();   // so we can get stack trace
        }

        return (ASTJ)parser.getAST();
    }

//  ================ GENERATED OUTPUT BUFFERS ================

    // We generate output into the ci/h/c files as we go along, which
    // means we keep nesting, thus: (GEN = generate output here)
    //
    // ci: module M { class C { GEN1, .endci here } .endci2 GEN2 } GEN
    // h:  class C { GEN, .endh here } .endh2 here
    // C:  method M { GEN30 }, .classInit here, .endc here, end-class, GEN
    //
    // What if you're in GEN and want to insert after the class end.
    // Need endci2.
    //
    // Why do we need endc?  Coz we gen reduction wrappers code while
    // in GEN30.
    //
    // Why do we need classInit in addition to endc ?  Coz we build it
    // while we go thru entire class.

    /** Primary output buffers */
    public static StringBuffer ci = new StringBuffer("");
    public static StringBuffer h  = new StringBuffer("");
    public static StringBuffer c  = new StringBuffer("");
    public static String curClassName = new String("");
    public static int curClassDim = 0;
    /**
       Stuff to be added at the end of the class. (end-class) I store
       it as a Stack of StringBuffer's.  Why Stack? To handle nested
       classes in the future.
     */
    public static Stack endci =  new Stack(); // of StringBuffer
    public static Stack endci2 =  new Stack(); // of StringBuffer
    public static Stack endh  =  new Stack(); // of StringBuffer
    public static Stack endh2  =  new Stack(); // of StringBuffer
    public static Stack endc  =  new Stack(); // of StringBuffer
    // generate init code here; this is called from the constructor
    public static Stack classInit = new Stack(); // of StringBuffer

//  ================ SYMBOL TABLE ================

    /** To keep track of current package and class name.  Used only in
     * pass 1.
     */
    public static Stack tmp  =  new Stack(); // of String
    public static String pgmName;
    /** print out the fully qualified name of name; assuming it is a
     * member of the current package and class. */
    public static String fullName(String name) {
        assert1(name != null);
        assert1(!name.equals(""));
        StringBuffer result = new StringBuffer("");
        for (int i=0; i<tmp.size(); i++) {
            String s = (String) tmp.elementAt(i);
            result.append(s+".");
        }
        result.append(name);
        return result.toString();
    }

    /** To keep track of "global" variables (i.e. class variables).
     * We store the fully qualified name of each symbol in the
     * globalStack.  This stack is populated in Pass 1.
     */
    private static Stack globalStack = new Stack(); // of String
    private static Stack globalStackShadow = new Stack(); // of AST

    /** To keep track of "local" variables (i.e. within method
     * variables).  This stack is populated and emptied as we go along
     * the AST in each pass that needs to keep track of local
     * variables.
     */
    private static Stack localStack = new Stack(); // of String
    private static Stack localStackShadow = new Stack(); // of AST
    private static final String BLOCK_MARKER = new String("____&NEWBLOCK&____");

    public static void localStackPush(String s, AST t) {
        J.localStack.push(s);
        J.localStackShadow.push(t);
    }

    public static void globalStackPush(String s, AST t) {
        J.globalStack.push(s);
        J.globalStackShadow.push(t);
    }

    public static class Tuple {
        String s;
        AST t;
    }

    public static Tuple localStackPop() {
        Tuple t = new Tuple();
        t.s = (String) J.localStack.pop();
        t.t = (AST) J.localStackShadow.pop();
        return t;
    }

    /** Push a special marker onto the local stack, to indicate the
     * start of a new block.
     */
    public static void startBlock() {
        localStackPush(BLOCK_MARKER, null);
    }

    /** Clear the most recent block of temporaries on the stack,
     * i.e. pop until the special start-of-block marker.
     */
    public static void endBlock() {
//         System.out.println(localStack);
//         System.out.println(localStackShadow);
        while (!localStack.empty()) {
            String e = (String)localStack.pop();
            localStackShadow.pop();
            if ( e.equals(BLOCK_MARKER) )
                return;
        }
        return;
    }

    /** private helper function: Given a Stack of StringBuffer and a
     * String 's', searches for the first string that ends with 's' in
     * the Stack and returns the index of that string.  Returns -1 if
     * not found. */
    private static int lookup(Stack st, String s) {
        for(int i=st.size()-1; i>=0; i--) {
            // given "b", search for "b", "a.b", etc., but weed out "ab"
            // given "c.b", search for "c.b", "a.c.b", etc., but weed out "ac.b"
            String e = (String)st.elementAt(i);
            if ( e.equals(s) || e.endsWith("." + s) )
                return i;
        }
        return -1;
    }

    /** Looks up 's' in the global stack. Then returns the
     * corresponding AST associated with s. */
    public static AST lookupGlobal(String s) {
        int i = lookup(globalStack, s);
        return (-1 == i)? null : ((AST)globalStackShadow.elementAt(i));
    }

    /** Looks up 's' in the local stack. Then returns the
     * corresponding AST associated with s. */
    public static AST lookupLocal(String s) {
        int i = lookup(localStack, s);
        return (-1 == i)? null : ((AST)localStackShadow.elementAt(i));
    }

    /** First looks up s in the local stack, then the global
     * stack. Then returns the corresponding AST associated with s. */
    private static AST lookupAST(String s) {
        AST retval = lookupLocal(s);
        if (retval == null)
            retval = lookupGlobal(s);
        return retval;
    }

    /** Determines if 's', which may be the short name or the full
     * name of a symbol, is a class static variable. */
    public static boolean isStaticClassVariable(String s) {
        boolean result = false;
        AST t = lookupGlobal(s);
        //System.out.println("isStatic: " + t + globalStack + "\n");
        if (t!=null)
            result = (VARIABLE_DEF==t.getType() && ((ASTJ)t.getFirstChild()).isX("static"));
        return result;
    }

    /** Determines if 's', which may be the short name or the full
     * name of a symbol, is a readonly variable. */
    public static boolean isReadonly(String s) {
        boolean result = false;
        AST t = lookupGlobal(s);
        //System.out.println("isReadOnly: " + t + globalStack + "\n");
        if (t!=null)
            result = (VARIABLE_DEF==t.getType() && ((ASTJ)t.getFirstChild()).isX("readonly"));
        return result;
    }

    // mangle the readonly's name
//     public static String roMangle(String className, String roName) {
//         return "RO_" + className + "_" + roName;
//     }

    // mangle the readonly's name
    public static String roMangleFullname(String fullName) {
        return "RO_" + fullName.replace('.', '_');
    }

    public static String mangleIfReadonly(String s) {
        String result = s;
        int i = lookup(globalStack, s);
        AST t = (-1 == i)? null : ((AST)globalStackShadow.elementAt(i));
        //System.out.println("mangleIfReadonly: " + s + globalStack);
        if (t!=null && (VARIABLE_DEF==t.getType() && ((ASTJ)t.getFirstChild()).isX("readonly"))) {
            //System.out.println("mangleIfReadonly: " + t.toString() );
            result=roMangleFullname((String)globalStack.elementAt(i));
        }
        return result;
    }

    /** Given "a.b.c", returns "b".
     */
    public static String getClassName(String s) {
        assert1(s != null && !s.equals(""));
        int end = s.lastIndexOf(".");
        int start = s.lastIndexOf(".", end-1);
//         System.out.println(s+"<"+start+","+end+">");
        return s.substring(start+1, end);
    }

    private static int uniqueNum = 0;
    public static int getUniqueNumber() {
        uniqueNum++;
        return uniqueNum;
    }

    public static String getUniqueIdentifier(String s) {
        return "_JADEIDENT_" + s + getUniqueNumber();
    }

//  ================ INDENTATION ================

    public static int indentLevel = 0;
    /** Outputs a newline, followed by indentLevel spaces. */
    public static void nl(StringBuffer s){
        s.append("\n");
        for(int i=0; i<indentLevel; i++)
            s.append(" ");
    }

    /** Outputs indentLevel spaces. */
    public static void indent(StringBuffer s){
        for(int i=0; i<indentLevel; i++)
            s.append(" ");
    }

    /** Outputs indentLevel spaces. */
    public static String indent(){
        StringBuffer s = new StringBuffer();
        for(int i=0; i<indentLevel; i++)
            s.append(" ");
        return s.toString();
    }

//  ================ TREE UTILITY FUNCTIONS ================

    /** Given a MODIFIERS node, determines if any modifier in it
     * matches the string s. */
    public static boolean isX(AST t, String s) {
        AST i=t.getFirstChild();
        while(i!=null) {
            if (i.getText().equalsIgnoreCase(s))
                return true;
            i = i.getNextSibling();
        }
        return false;
    }

    public static boolean isX(AST t, String[] s) {
        AST i=t.getFirstChild();
        while(i!=null) {
            int j;
            for (j=0; j<s.length; j++)
                if (i.getText().equalsIgnoreCase(s[j]))
                    return true;
            i = i.getNextSibling();
        }
        return false;
    }

    /** Given an AST and a "script", this function traverses the tree
     * rooted at the AST and returns the AST pointed to by the script,
     * while checking for errors along the way. */
    public static ASTJ getNode(AST t, String s)
    {
        AST retVal = t;
        if (t!=null && s!=null && !s.equals(""))
            for(int i=0; i<s.length(); i++) {

                if (retVal==null) {
                    J.internalError(t, "ERROR in getNode, TREE<<STRING " +s +"["+i+"] " +t.getText());
                    break;
                }

                if (s.charAt(i) == 'f')
                    retVal = retVal.getFirstChild();
                else if (s.charAt(i) == 'n')
                    retVal = retVal.getNextSibling();
                else {
                    retVal = null;
                    J.internalError(t, "ERROR in getNode, BAD STRING " +s +"["+i+"] " +t.getText());
                    break;
                }
            }
        return (ASTJ)retVal;
    }

// ================ OUTPUT GENERATION ================

    /** Controls whether a.b is changed to a::b */
    public static boolean dot2colonMode = true;

    // limit < 0, means print all the parameters, otherwise print only
    // 'limit' parameters.
    public static String printTemplateList(AST template) {
        return printTemplateList(template, -1);
    }
    public static String printTemplateList(AST template, int limit) {
        StringBuffer s = new StringBuffer("");

        if (template!=null) {
            assert1(TEMPLATE == template.getType());
            s.append("< ");
            AST param = template.getFirstChild();
            int paramNum = 0;
            while (param != null) {
                paramNum++;
                if (limit==0) break;
                // Convert Double.TYPE to double, etc.
                if (DOT == param.getType() && param.getFirstChild().getNextSibling().getText().equalsIgnoreCase("TYPE")) {
                        s.append(param.getFirstChild().getText().toLowerCase());
                } else
                    s.append(pE(param));
                if (limit>=0 && paramNum==limit) break;
                param = param.getNextSibling();
                if (param != null)
                    s.append(",");
            }
            s.append(" >");
        }

        return s.toString();
    }
    
    // Actually, this is subsumed in printExpression
    /** Given an identifier, i.e. IDENT or DOT rooted tree, we return
     * a string containing the printed name of the identifier */
//     public static String printIdentifier(AST t) {
//         if (null == t)
//             return "";
//         // assert t.getType() == IDENT || DOT

//         StringBuffer s = new StringBuffer();
//         if (t.getType() == IDENT) {
//             //System.out.println("Reached: " + t.getText());
//             s.append(t.getText());
//         } else if (t.getType() == DOT) {
//             AST u = t.getFirstChild();
//             //System.out.println("pI: " + t);
//             s.append(pE(u) + "." + u.getNextSibling().getText());
//             //System.out.println("pI: done");
//         } else {
//             System.out.println("ERROR in printIdentifier");
//         }

//         return s.toString();
//     }

    /** CkCallback: change "." to "::", and prefix method name with
        "_"
    */
    public static String reprintCallback(AST t) {
        if (null == t)
            return "";
        // assert t.getType() == IDENT || DOT

        StringBuffer s = new StringBuffer();
        if (t.getType() == IDENT)
            s.append(t.getText());
        else if (t.getType() == DOT) {
            AST u = t.getFirstChild();
	    if(!u.getText().equals(curClassName)){
		s.append(curClassName);
	    }else{
		s.append(pE(u));
	    }
            s.append("::_" + u.getNextSibling().getText());
        } else {
            System.out.println("ERROR in reprintCallback");
        }

        return s.toString();
    }

    // Basically convert int[]... to JArray<int> and append varName.
    // The name can be null, e.g. in a typecast, in which case no name
    // should be printed.
    public static String printTypeSpec(AST t, String varName) {
        if (null == t)
            return "";
        else if (TYPE == t.getType())
            return printTypeSpec(t.getFirstChild(), varName);
        // assert t.getType() == TYPE || ARRAY_DECLARATOR || IDENT || builtintype

        StringBuffer retVal = new StringBuffer();
        if ( ARRAY_DECLARATOR == t.getType() ) { // Is it an array?
            while(ARRAY_DECLARATOR == t.getType())
                t = t.getFirstChild();
            retVal.append("JArray< " + pE(t) + " >");// nD arrays
        } else
            retVal.append(printExpression(t));
        if (null == varName) varName = "";
        retVal.append(" "+varName);

        return  retVal.toString();
    }

    // #( PARAMETERS (parameterDef)* )
    // #(PARAMETER_DEF modifiers typeSpec IDENT )
    public static String printParamList(AST t) {
        if (null == t)
            return "";
        // assert t.getType() == PARAMETERS

        StringBuffer s = new StringBuffer();

        AST i = t.getFirstChild();
        while (i != null) {
            ASTJ j = ((ASTJ)i);
//             if (j.getChild(1).getFirstChild().getText().equalsIgnoreCase("chare")) {
//                 // We're receiving a chare
//                 s.append("CkChareID ");
//             } else
            AST typeSpec = j.getChild(1);
            AST paramName = j.getChild(2);
            s.append(printTypeSpec(typeSpec, pE(paramName)));
            i = i.getNextSibling();
            if (i != null)
                s.append(", ");
        }

        return s.toString();
    }

    public static String printVariableDeclarator(AST t) {
        if (null == t)
            return "";
        // assert t.getType() == 

        StringBuffer s = new StringBuffer();

        if (IDENT == t.getType()) {
            s.append(t.getText());
        } else {
            // @@TBD: a[][] i.e. array after name
            s.append(printVariableDeclarator(t.getFirstChild())
                     + "use 'int[] a' instead of 'int a[]'.  Otherwise tell Jay about it");
        }
        return s.toString();
    }

    private static String reductionNumBytes(String reductionType) {
        if (reductionType.endsWith("_int") || reductionType.endsWith("_and")
            || reductionType.endsWith("_or"))
            return "int";
        else if (reductionType.endsWith("_float"))
            return "float";
        else if (reductionType.endsWith("_double"))
            return "double";
        else
            return "ERROR: UNKNOWN REDUCTION TYPE";
    }

    private static String indexOpHelper(AST t)
    {
        if (INDEX_OP == t.getFirstChild().getType())
            return indexOpHelper(t.getFirstChild()) + ", " + printExpression(t.getFirstChild().getNextSibling());
        else
            return printExpression(t.getFirstChild().getNextSibling());
    }

    private static String printColon(AST t)
    {
        if(EXPR == t.getType())
            return printExpression(t)
                + ", " + printExpression(t) // @@ t is evaluated twice
                + ", 1";
        else if (COLON == t.getType())
            return printExpression(t.getFirstChild())
                + ", " + printExpression(t.getFirstChild().getNextSibling())
                + ", " + ((null == t.getFirstChild().getNextSibling().getNextSibling())? "1":
                          printExpression(t.getFirstChild().getNextSibling().getNextSibling()));
        else {
            System.err.println("printColon internal error: invalid expression");
            return "@@ERROR";
        }
    }

    // array section notation is assumed
    private static String indexOpHelperColon(AST t)
    {
        if (INDEX_OP == t.getFirstChild().getType())
            return indexOpHelperColon(t.getFirstChild()) + ", " + printColon(t.getFirstChild().getNextSibling());
        else
            return printColon(t.getFirstChild().getNextSibling());
    }

    public static String pElist(AST t) {
        StringBuffer s = new StringBuffer();
        AST i = t;
        while (i != null) {
            s.append(printExpression(i));
            i = i.getNextSibling();
            if (i != null)
                s.append(", ");
        }
        return s.toString();
    }

    /** Basically a set of name-value pairs.  put(s,v) overwrites the
     * previous value of s.  get(s) gets the value associated with
     * s. */
    public static class Env {
        private Stack name = new Stack(); // of String
        private Stack value = new Stack(); // of Object
        private String getnameN(int n) {return (String)(name.elementAt(n)); }
        private Object getvalueN(int n) {return value.elementAt(n);}

        public Object get(String s) {
            int pos = name.search(s);
            if (pos != -1)
                return getvalueN(name.size()-pos);
            return null;
        }

        public String getStr(String s) {return (String)get(s);}
        public AST getAST(String s) {return (AST)get(s);}

        public void put(String s, Object v) {
            name.push(s); value.push(v);
        }

        public String toString() {
            return "[" + name + ", " + value + "]" ;
        }
    }

    /** Checks if an MSA is being accessed, i.e. a[1] where a is an MSA. */
    public static AST isMSAAccess(AST t)
    {
        boolean isMSA = false;

        if (INDEX_OP == t.getType()) {
            while (INDEX_OP == t.getType()) {
                if (COLON == t.getFirstChild().getNextSibling().getType())
                    J.fatalError(t, "Array ranges are limited to parameter passing.");
                t = t.getFirstChild();
            }
            String name = t.getText();

            AST t2 = lookupAST(name);
            if (t2 != null && isStrMSA(getNode(t2, "fnf").getText()) )
                isMSA = true;
        }

        return isMSA?t:null;
    }

    interface Visitor {
        AST visit(AST t, Env e);
    }
    static class CheckIfMSA implements Visitor {
        public AST visit(AST t, Env e) {
            if (INDEX_OP == t.getType())
                return isMSAAccess(t);
            return null;
        }
    }

    // (a1 (b1 b2 (c1 c2) b4) a3 ...)
    public static AST traverseDFS(AST t, Visitor v, Env e)
    {
        if (t == null)
            return t;

        AST vt = null;
        if ( (vt = v.visit(t, e))!=null)
            return vt;

        AST child = t.getFirstChild();
        while(child != null) {
            if ((vt=traverseDFS(child, v, e))!=null)
                return vt;
            child = child.getNextSibling();
        }
        return null;
    }

    public static AST isMSAAccessAnywhere(AST t)
    {
        Env e = new Env();
        return traverseDFS(t, new CheckIfMSA(), e);
    }

    /** Results are basically stored in e. */
    public static void analyzeFor(AST t, Env e) {
        
        assert1(t.getType() == LITERAL_for);

        String loopnum = "";
        if (e.get("i1") == null)
            loopnum = "1";
        else if (e.get("i2") == null)
            loopnum = "2";
        else  // don't analyze third level loop
            abort1(1);

        J.dot2colonMode = false;
        // for (int i=n0; i OP n1; i++) // OP can be < or <=
        // for (i=n0; i OP n1; i++)
        if (getNode(t, "ff").getType() == VARIABLE_DEF) {
            e.put("i"+loopnum, getNode(t, "fffnn").toString());
            e.put("n0"+loopnum, pE(getNode(t, "fffnnnf")));
        } else
            abort1(1);
        e.put("OP"+loopnum, getNode(t, "fnff").toString());
        e.put("n1"+loopnum, pE(getNode(t, "fnfffn")));
        J.dot2colonMode = true;

        // inner for loop?
        if (getNode(t, "fnnn").getType() == LITERAL_for)
            analyzeFor(getNode(t, "fnnn"), e);
        else { // analyze body
            // done in caller already.
        }

        System.out.println("analyzeFor: " + e);
    }

    public static void pASSIGN(AST t, StringBuffer s)
    {
        // 1) a = new int[4]; => a.resize1D(4);
        // 2a) a[1][2] = 3;  => if a is MSA, a.set(1,2) = 3
        // 2b) a[1][2] += 3;  => if a is MSA, a.accumulate(1,2, 3);
        // 3) others

        // if we are doing a "new" array assignment, we drop the "="
        // i.e. a = new int[10], becomes a.resize1D(10)
        if (t.getFirstChild().getNextSibling().getType() == LITERAL_new
            && getNode(t, "fnfn").getType() == ARRAY_DECLARATOR) {
            s.append(printExpression(t.getFirstChild())
                     + printExpression(t.getFirstChild().getNextSibling()));

        } else if (isMSAAccess(t.getFirstChild())!=null) {
            // MSA set and accumulate are handled here; get is handled
            // in INDEX_OP.

            // Get the array name
            AST tt = t.getFirstChild();
            while (INDEX_OP == tt.getType()) {
                tt = tt.getFirstChild();
            }
            String name = tt.getText();

            s.append(name);
            if (ASSIGN == t.getType()) {
                s.append(".set(" + indexOpHelper(t.getFirstChild()) + ")"
                         + " " + t.getText() + " "
                         + printExpression(t.getFirstChild().getNextSibling()));
            } else {
                s.append(".accumulate");
                s.append("(" + indexOpHelper(t) + ", \"" + t.getText().charAt(0) + "\"");
                s.append(")");
            }

        } else {
            s.append(printExpression(t.getFirstChild())
                     + " " + t.getText() + " "
                     + printExpression(t.getFirstChild().getNextSibling()));
        } // end else

    } // endfunc

    /**
       returns a string containing the printed out expression or ELIST.
     **/
    public static String pE(AST t) { return printExpression(t); }
    public static String pE(AST t, int printExpressionMode) { return printExpression(t, printExpressionMode); }
    public static String printExpression(AST t) { return printExpression(t, 0); }
    public static String printExpression(AST t, int printExpressionMode) {
        if (null == t)
            return "";
        // assert t.getType() == ELIST || EXPR || expr's stuff || primaryExpression's stuff

        StringBuffer s = new StringBuffer();

        switch(t.getType()) {

        case ELIST:
            s.append(pElist(t.getFirstChild()));
            break;

        case EXPR:
            s.append(printExpression(t.getFirstChild()) );
            break;

        // 3 args
        case QUESTION: // a?b:c
            AST b;
            s.append("(" +
                     printExpression(t.getFirstChild())
                     + "?"
                     + printExpression(b = t.getFirstChild().getNextSibling())
                     + ":"
                     + printExpression(b.getNextSibling())
                     + ")");
            break;

        // 2 args, assignment
        case ASSIGN:
        case PLUS_ASSIGN:
        case MINUS_ASSIGN:
	case STAR_ASSIGN:
	case DIV_ASSIGN:
	case MOD_ASSIGN:
	case SR_ASSIGN:
	case BSR_ASSIGN:
	case SL_ASSIGN:
	case BAND_ASSIGN:
	case BXOR_ASSIGN:
	case BOR_ASSIGN:

            // ASSIGN has two cases: one child or two.  The first
            // happens for a variable def, e.g. int i = 10; We will
            // never see such a case because the code in variableDef
            // takes care of it.

            // Mark the first child as an lvalue
            ((ASTJ)(t.getFirstChild())).isLVALUE = true;

            // if we are doing a "new" array assignment, we drop the "="
            // i.e. a = new int[10], becomes a.resize1D(10)
//             if (t.getFirstChild().getNextSibling().getType() == LITERAL_new
//                 && getNode(t, "fnfn").getType() == ARRAY_DECLARATOR) {
//                 s.append(printExpression(t.getFirstChild())
//                      + printExpression(t.getFirstChild().getNextSibling()));
//             } else
//                 s.append(printExpression(t.getFirstChild())
//                      + " " + t.getText() + " "
//                      + printExpression(t.getFirstChild().getNextSibling()));

            pASSIGN(t, s);

            break;

        // 2 args, non-assignment
	case LOR:
	case LAND:
	case BOR:
	case BXOR:
	case BAND:
	case NOT_EQUAL:
	case EQUAL:
	case LT:
	case GT:
	case LE:
	case GE:
	case SL:
	case SR:
	case BSR:
	case PLUS:
	case MINUS:
	case DIV:
	case MOD:
	case STAR:
            s.append("(" + printExpression(t.getFirstChild())
                     + " " + t.getText() + " "
                     + printExpression(t.getFirstChild().getNextSibling()) + ")");
            break;

        // 1 arg, prefix
        case BNOT:
        case LNOT:
        case UNARY_MINUS:
        case UNARY_PLUS:
        case INC:
        case DEC:
            s.append("(" + t.getText() + printExpression(t.getFirstChild()) + ")");
            break;

        // 1 arg, postfix
        case POST_INC:
        case POST_DEC:
            s.append("(" + printExpression(t.getFirstChild()) + t.getText() + ")");
            break;

        // primaryExpression stuff starts here

        case IDENT:
            //System.out.println("pE: Reached IDENT:" + t);
            if (printExpressionMode==1) // We are in DOT expr, getting full name of var, so skip readonly processing
                s.append(t.getText());
            else
                s.append(mangleIfReadonly(t.getText()));
            s.append(printTemplateList(t.getFirstChild()));
            break;

        case DOT: // @@
            StringBuffer ss = new StringBuffer();
            ss.append(printExpression(t.getFirstChild(), 1)
                     + "."
                     + printExpression(t.getFirstChild().getNextSibling(), 1)
                     );
            // If the variable is a static class variable, we
            // regenerate the expression using "::" instead of ".",
            // otherwise what we have already is OK.  Regenerating the
            // expression is an inefficient way of doing it, but
            // there's no easy way to replace '.' by "::".
            //System.out.println("DOT: " + ss.toString() + "\n");
            if (isReadonly(ss.toString())) {
                s.append(J.mangleIfReadonly(ss.toString()));
                         //(printExpression(t.getFirstChild()), printExpression(t.getFirstChild().getNextSibling())));
            } else if (isStaticClassVariable(ss.toString()))
                s.append(printExpression(t.getFirstChild())
                         + (J.dot2colonMode?"::":".")
                     + printExpression(t.getFirstChild().getNextSibling())
                     );
            else if(ss.toString().startsWith("Ck")){	// starts with "Ck"
                s.append(printExpression(t.getFirstChild())
                         + (J.dot2colonMode?"::":".")
                     + printExpression(t.getFirstChild().getNextSibling())
                     );
	    }else
                s.append(ss.toString());
            s.append(printTemplateList(t.getFirstChild().getNextSibling().getNextSibling()));
            break;

        case INDEX_OP:
            // Get the name of the array, and detect if a range is given, i.e. a[10:12]
            AST tt = t;
            boolean rangeAccess = false; // is there a range ?
            while (INDEX_OP == tt.getType()) {
                if (COLON == tt.getFirstChild().getNextSibling().getType())
                    rangeAccess = true;
                tt = tt.getFirstChild();
            }
//             String name = tt.getText();
            String name = pE(tt);

            // Is it an MSA ?
            boolean isMSA = false;
            {
                AST t2 = lookupAST(name);
                if (t2 != null && isStrMSA(getNode(t2, "fnf").getText()) )
                    isMSA = true;
            }

            // Is it a ChareArray or a data array?
//             int kk = lookup(globalStack, name);
//             if (kk<0) {
//                 System.out.println("ERROR lookup");
//                 System.exit(-1);
//             }
//             System.out.println("k="+kk+J.globalStack+J.globalStackShadow);
//             AST t2 = ((AST)globalStackShadow.elementAt(k)).;

//             s.append(printExpression(t.getFirstChild()) + "[" + printExpression(t.getFirstChild().getNextSibling()) + "]");

            s.append(name);
            if (isMSA) {
//                 ((ASTJ)(t)).print();
                if ( ((ASTJ)t).isLVALUE )
                    J.internalError(t, "This case is handled in pASSIGN.");
                else
                    s.append(".get("+indexOpHelper(t) + ")");
                // @@ What if MSA and range given?

            } else if (name.equalsIgnoreCase("pi")) { // hack for strip-mine codegen
                    s.append("[" + indexOpHelper(t) + "]");
            } else { // JArray
                if (rangeAccess) {
                    s.append(".sV(" + indexOpHelperColon(t) + ")");
                } else
                    s.append("(" + indexOpHelper(t) + ")");
            }

            break;

        case METHOD_CALL:
            // detect contribute here.
            if (t.getFirstChild().getText().equals("contribute")) {
                // modify the parameters
                // Jade:  contribute(num_elements, base_element, reduction type [,callback])
                // charm: contribute(num_elements, &base_element, :: [,callback])
                AST p0 = t.getFirstChild().getNextSibling().getFirstChild();
                AST p1 = p0.getNextSibling();
                AST p2 = p1.getNextSibling();
                AST p3 = p2.getNextSibling();

                // @@ lookup p1, get type, if array do something else.

                String rednVarType = reductionNumBytes(p2.getFirstChild().getFirstChild().getNextSibling().getText());

                s.append(printExpression(t.getFirstChild())
                         + "(" + printExpression(p0) + "*sizeof(" + rednVarType + "), "
                         + "&" + printExpression(p1) + ", "
                         + printExpression(p2.getFirstChild().getFirstChild())
                             + "::" + printExpression(p2.getFirstChild().getFirstChild().getNextSibling())
                         + ((p3==null)?"":", ") + printExpression(p3) + ")"
                         );

            } else s.append(printExpression(t.getFirstChild())
                     + "(" + printExpression(t.getFirstChild().getNextSibling()) + ")"
                     );
            break;

        case TYPECAST:
            s.append("(" + printTypeSpec(t.getFirstChild(),null) + ")"
                     +  printExpression(t.getFirstChild().getNextSibling())
                     );
            break;

        case LITERAL_new: // @@ needs more work
            // "new" IDENT elist
            // newExpression: "new" type (arraydec || elist)
            if (t.getFirstChild().getNextSibling().getType() == ARRAY_DECLARATOR) {
                // variableDef: int[] a = new int[10], or
                // or assignment: a = new int[10]
                // becomes .resize(10);

                // 2D or 3D.  @@nD
                if (getNode(t, "fnf").getType() == ARRAY_DECLARATOR) {

                    //3D
                    if (getNode(t, "fnff").getType() == ARRAY_DECLARATOR) {
                        s.append(".resize3D("
                             + printExpression(getNode(t,"fnfff"))
                             + ", "
                             + printExpression(getNode(t,"fnffn"))
                             + ", "
                             + printExpression(getNode(t,"fnfn"))
                             + ")");
                    } else { // 2D
                        s.append(".resize2D("
                             + printExpression(getNode(t,"fnff"))
                             + ", "
                             + printExpression(getNode(t,"fnfn"))
                             + ")");
                    }
                } else { // 1D
                    s.append(".resize1D("
                             + printExpression(t.getFirstChild().getNextSibling().getFirstChild())
                             + ")");
                }
            } else if (t.getFirstChild().getText().equalsIgnoreCase("CkCallback")) { // we modify creation of CkCallback
                s.append("*(new " + printTypeSpec(t.getFirstChild(),null) + "(");
                AST p1 = t.getFirstChild().getNextSibling().getFirstChild();
                AST p2 = p1.getNextSibling();

                // generate wrapper callback
                //String cbName = printExpression(p3);
		String targetProxy = printExpression(p2);
		String thisProxy;
		switch(curClassDim){
		case 1:
		    thisProxy = new String("thisProxy(0)");  break;
		case 2: 
		    thisProxy = new String("thisProxy(0,0)");  break;
		case 0:
		default:
		    thisProxy = new String("thisProxy");  break;
		}
		String hereProxy;
		String remoteProxy;
		if(!printExpression(p2).startsWith("thisProxy")){
		    hereProxy = thisProxy;
		    remoteProxy = printExpression(p2) + ".";
		} else { 
		    hereProxy = printExpression(p2);
		    remoteProxy = new String("");
		}
                String cbClassName = p1.getFirstChild().getFirstChild().getText();
                String cbName = p1.getFirstChild().getFirstChild().getNextSibling().getText();

                s.append("CkIndex_"+reprintCallback(p1.getFirstChild()) + "(NULL), " + hereProxy + "))" );

                AST cbNode = lookupGlobal(cbName);
                assert1(cbNode != null);
                AST t2 = getNode( cbNode, "fnnnffnf" );
                String rednVarType = t2.getText();
                AST t3 = t2;
                String r3 = rednVarType;
                while (r3.startsWith("[")) {
                    t3 = t3.getFirstChild();
                    r3 = t3.getText();
                }
                ((StringBuffer)J.endci.peek()).append(J.indent() + "entry void _" + cbName + "(CkReductionMsg *m);\n");
                ((StringBuffer)J.endh.peek()).append(J.indent() + "public: void _" + cbName + "(CkReductionMsg *m);\n");
                ((StringBuffer)J.endc.peek()).append(J.indent() + "void " + curClassName + "::_" + cbName + "(CkReductionMsg *m){\n"
                                                     + J.indent() + "  " + remoteProxy + cbName
                                                     + (rednVarType.startsWith("[")?// ARRAY?
                                                        "( *( new JArray<"+r3+">(m->getSize()/sizeof("+r3+"), ("+r3+"*)m->getData()) ) )":
                                                        "( *((" + rednVarType + "*)(m->getData())) )") + ";\n"
                                                     + J.indent() + "  " + "delete m;\n"
						     + J.indent() + "}\n" );
/*
                ((StringBuffer)J.endc.peek()).append(J.indent() + "void " + cbClassName + "::_" + cbName + "(CkReductionMsg *m){"
                                                     + cbName
                                                     + (rednVarType.startsWith("[")?// ARRAY?
                                                        "( *( new JArray<"+r3+">(m->getSize()/sizeof("+r3+"), ("+r3+"*)m->getData()) ) )":
                                                        "( *((" + rednVarType + "*)(m->getData())) )")
                                                     + ";delete m;}\n" );
*/
            } else {
                // deref all new's, so that java's dot will work
                // unchanged, i.e. Klass a = new Klass(); a.etc()
                s.append("*(new " + printTypeSpec(t.getFirstChild(),null) + "("
                         + printExpression(t.getFirstChild().getNextSibling()) + "))" );
            }
            break;

        // 0 args, constants
        case NUM_INT:
        case CHAR_LITERAL:
	case STRING_LITERAL:
	case NUM_FLOAT:
	case NUM_DOUBLE:
	case NUM_LONG:
            s.append(t.getText());
            break;

        case LITERAL_super: // @@ ok?
            s.append("super");
            break;

        case LITERAL_true:
            s.append("1");
            break;

        case LITERAL_false:
            s.append("0");
            break;

        case LITERAL_this:
            s.append(t.getText());
            break;

        case LITERAL_null:
            s.append("0");
            break;

	case LITERAL_void:
	case LITERAL_boolean:
	case LITERAL_byte:
	case LITERAL_char:
	case LITERAL_short:
	case LITERAL_int:
	case LITERAL_float:
	case LITERAL_long:
	case LITERAL_double:
            s.append(t.getText());

        case TYPE:
            s.append(printTypeSpec(t.getFirstChild(),null));
            break;

        default:
            System.out.println("ERROR in printExpression: unexpected type " + t.getType() + " " + t.getText());
            s.append("ERROR");
            try { int []a; a = null; a[2] = 1; } catch(Exception e) { e.printStackTrace(); }
        }

        return s.toString();
    }

    public static int genPup(String className,boolean hasCBase) {
        Stack st = globalStack;
        J.indentLevel++;

        // Gen call to superclass pup here
        if(hasCBase)
	    J.c.append(J.indent()+"CBase_"+className+"::pup(p);\n");

        // pup the data members
        for(int i=st.size()-1; i>=0; i--) {
            if ( getClassName((String)st.elementAt(i)).equals(className) ) {
                AST t = ((AST)globalStackShadow.elementAt(i));
                ASTJ m = (ASTJ)t.getFirstChild(); // modifiers
                if (t.getType() == VARIABLE_DEF
                    // don't pup constants
                    && !(J.isX(m, "public") && J.isX(m, "static") && J.isX(m, "final"))
                    // don't pup readonly
                    && !(J.isX(m, "public") && J.isX(m, "static") && J.isX(m, "readonly"))
                    ) {
//                     System.out.println((String)st.elementAt(i));
                    J.c.append(J.indent() + "p|" + t.getFirstChild().getNextSibling().getNextSibling().getText() + ";\n");
                }
            }
        }
        J.indentLevel--;

        return 0;
    }

}; // end class J

