/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.fmt;

import charm.debug.fmt.PDisplayStyle;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;

public abstract class PAbstract {
    private String name = null;
    private PAbstract next = null;

    public String getDeepName() {
        PString pString = (PString)((PList)this).elementNamed("name");
        return pString.getString();
    }

    public String toString() {
        if (this.getName() != null) {
            return this.getName() + "=";
        }
        return "";
    }

    public void setName(String string) {
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public void setNext(PAbstract pAbstract) {
        this.next = pAbstract;
    }

    public final PAbstract getNext() {
        return this.next;
    }

    public boolean draw(PDisplayStyle pDisplayStyle) {
        int n = pDisplayStyle.getDrawStyle(this);
        return this.draw(pDisplayStyle, n);
    }

    public boolean draw(PDisplayStyle pDisplayStyle, int n) {
        if (this.getName() != null) {
            pDisplayStyle.drawString(this.getName() + "=");
        }
        return true;
    }

    public static void main(String[] stringArray) {
        Canvas canvas = new Canvas(){

            public void paint(Graphics graphics) {
                PDisplayStyle pDisplayStyle = new PDisplayStyle(graphics, 500);
                int[] nArray = new int[]{1, 2, 3, 4};
                PNative pNative = new PNative(nArray);
                pNative.setName("Foo");
                PNative pNative2 = new PNative(nArray);
                pNative2.setName("Bar");
                PNative pNative3 = new PNative(nArray);
                pNative3.setName("Baz");
                PList pList = new PList();
                pList.setName("Big");
                pList.add(pNative);
                pList.add(pNative2);
                PList pList2 = new PList();
                pList2.setName("Sub");
                int[] nArray2 = new int[]{23};
                pList2.add(new PNative(nArray2));
                pList2.add(new PNative(nArray2));
                pList2.add(new PList());
                pList2.add(new PNative(nArray2));
                pList.add(pList2);
                pList.add(pNative3);
                pList.draw(pDisplayStyle);
            }

            public Dimension getPreferredSize() {
                return new Dimension(500, 400);
            }
        };
        Frame frame = new Frame("Test PAbstract");
        frame.add(canvas);
        frame.pack();
        frame.setVisible(true);
    }
}

