/* DEFS: template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE > group MSA_CacheGroup: IrrGroup{
MSA_CacheGroup(unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads);
void AckPage(unsigned int page);
void ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size);
void ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size);
void enroll(unsigned int numberOfWorkerThreads);
void enrollAck(int originator);
void enrollDone(void);
void SyncAck(void);
void SyncDone(void);
void emitBufferValue(int ID, unsigned int pageNum, unsigned int offset);
};
 */
#ifdef CK_TEMPLATES_ONLY
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx=0;
#endif
#ifdef CK_TEMPLATES_ONLY
/* DEFS: MSA_CacheGroup(unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads);
 */

/* DEFS: void AckPage(unsigned int page);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::AckPage(unsigned int page, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int page
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|page;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|page;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_AckPage_marshall2, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_AckPage_marshall2, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_AckPage_marshall2, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int page, const ENTRY_TYPE *pageData, int size
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_pageData, impl_cnt_pageData;
  impl_off_pageData=impl_off=CK_ALIGN(impl_off,sizeof(ENTRY_TYPE));
  impl_off+=(impl_cnt_pageData=sizeof(ENTRY_TYPE)*(size));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|page;
    implP|impl_off_pageData;
    implP|impl_cnt_pageData;
    implP|size;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|page;
    implP|impl_off_pageData;
    implP|impl_cnt_pageData;
    implP|size;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_pageData,pageData,impl_cnt_pageData);
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePage_marshall3, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePage_marshall3, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePage_marshall3, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|page;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)pageData;
    implP|size;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|page;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)pageData;
    implP|size;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePageWithPUP_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePageWithPUP_marshall4, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePageWithPUP_marshall4, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void enroll(unsigned int numberOfWorkerThreads);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::enroll(unsigned int numberOfWorkerThreads, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int numberOfWorkerThreads
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|numberOfWorkerThreads;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|numberOfWorkerThreads;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enroll_marshall5, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enroll_marshall5, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enroll_marshall5, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void enrollAck(int originator);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::enrollAck(int originator, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int originator
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|originator;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|originator;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollAck_marshall6, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollAck_marshall6, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollAck_marshall6, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void enrollDone(void);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::enrollDone(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollDone_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollDone_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollDone_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void SyncAck(void);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::SyncAck(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncAck_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncAck_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncAck_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void SyncDone(void);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::SyncDone(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncDone_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncDone_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncDone_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void emitBufferValue(int ID, unsigned int pageNum, unsigned int offset);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::emitBufferValue(int ID, unsigned int pageNum, unsigned int offset, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int ID, unsigned int pageNum, unsigned int offset
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|ID;
    implP|pageNum;
    implP|offset;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|ID;
    implP|pageNum;
    implP|offset;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_emitBufferValue_marshall10, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_emitBufferValue_marshall10, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_emitBufferValue_marshall10, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}
/* DEFS: MSA_CacheGroup(unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  CkGroupID CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::ckNew(unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads, const CkEntryOptions *impl_e_opts)
{
  //Marshall: unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|nPages;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)pageArrayID;
    implP|max_bytes;
    implP|nEntries;
    implP|numberOfWorkerThreads;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|nPages;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)pageArrayID;
    implP|max_bytes;
    implP|nEntries;
    implP|numberOfWorkerThreads;
  }
  return CkCreateGroup(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx, CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_MSA_CacheGroup_marshall1, impl_msg);
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >    CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::CProxy_MSA_CacheGroup(unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads, const CkEntryOptions *impl_e_opts)
{
  //Marshall: unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|nPages;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)pageArrayID;
    implP|max_bytes;
    implP|nEntries;
    implP|numberOfWorkerThreads;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|nPages;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayID &)pageArrayID;
    implP|max_bytes;
    implP|nEntries;
    implP|numberOfWorkerThreads;
  }
  ckSetGroupID(CkCreateGroup(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx, CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_MSA_CacheGroup_marshall1, impl_msg));
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_MSA_CacheGroup_marshall1=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_MSA_CacheGroup_marshall1(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads*/
  PUP::fromMem implP(impl_buf);
  unsigned int nPages; implP|nPages;
  CkArrayID pageArrayID; implP|pageArrayID;
  unsigned int max_bytes; implP|max_bytes;
  unsigned int nEntries; implP|nEntries;
  unsigned int numberOfWorkerThreads; implP|numberOfWorkerThreads;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > (nPages, pageArrayID, max_bytes, nEntries, numberOfWorkerThreads);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_callmarshall_MSA_CacheGroup_marshall1(char* impl_buf,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj) {
  /*Unmarshall pup'd fields: unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads*/
  PUP::fromMem implP(impl_buf);
  unsigned int nPages; implP|nPages;
  CkArrayID pageArrayID; implP|pageArrayID;
  unsigned int max_bytes; implP|max_bytes;
  unsigned int nEntries; implP|nEntries;
  unsigned int numberOfWorkerThreads; implP|numberOfWorkerThreads;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > (nPages, pageArrayID, max_bytes, nEntries, numberOfWorkerThreads);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
  return implP.size();
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_marshallmessagepup_MSA_CacheGroup_marshall1(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads*/
  PUP::fromMem implP(impl_buf);
  unsigned int nPages; implP|nPages;
  CkArrayID pageArrayID; implP|pageArrayID;
  unsigned int max_bytes; implP|max_bytes;
  unsigned int nEntries; implP|nEntries;
  unsigned int numberOfWorkerThreads; implP|numberOfWorkerThreads;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("nPages");
  implDestP|nPages;
  if (implDestP.hasComments()) implDestP.comment("pageArrayID");
  implDestP|pageArrayID;
  if (implDestP.hasComments()) implDestP.comment("max_bytes");
  implDestP|max_bytes;
  if (implDestP.hasComments()) implDestP.comment("nEntries");
  implDestP|nEntries;
  if (implDestP.hasComments()) implDestP.comment("numberOfWorkerThreads");
  implDestP|numberOfWorkerThreads;
}

/* DEFS: void AckPage(unsigned int page);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::AckPage(unsigned int page, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int page
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|page;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|page;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_AckPage_marshall2, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_AckPage_marshall2, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_AckPage_marshall2, impl_msg, ckGetGroupID(),0);
}
    template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::AckPage(unsigned int page, int npes, int *pes, const CkEntryOptions *impl_e_opts)
    {
  //Marshall: unsigned int page
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|page;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|page;
  }
      CkSendMsgBranchMulti(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_AckPage_marshall2, impl_msg, npes, pes, ckGetGroupID(),0);
    }
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_AckPage_marshall2=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_AckPage_marshall2(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: unsigned int page*/
  PUP::fromMem implP(impl_buf);
  unsigned int page; implP|page;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->AckPage(page);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_callmarshall_AckPage_marshall2(char* impl_buf,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj) {
  /*Unmarshall pup'd fields: unsigned int page*/
  PUP::fromMem implP(impl_buf);
  unsigned int page; implP|page;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->AckPage(page);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
  return implP.size();
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_marshallmessagepup_AckPage_marshall2(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: unsigned int page*/
  PUP::fromMem implP(impl_buf);
  unsigned int page; implP|page;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("page");
  implDestP|page;
}

/* DEFS: void ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int page, const ENTRY_TYPE *pageData, int size
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_pageData, impl_cnt_pageData;
  impl_off_pageData=impl_off=CK_ALIGN(impl_off,sizeof(ENTRY_TYPE));
  impl_off+=(impl_cnt_pageData=sizeof(ENTRY_TYPE)*(size));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|page;
    implP|impl_off_pageData;
    implP|impl_cnt_pageData;
    implP|size;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|page;
    implP|impl_off_pageData;
    implP|impl_cnt_pageData;
    implP|size;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_pageData,pageData,impl_cnt_pageData);
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePage_marshall3, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePage_marshall3, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePage_marshall3, impl_msg, ckGetGroupID(),0);
}
    template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size, int npes, int *pes, const CkEntryOptions *impl_e_opts)
    {
  //Marshall: unsigned int page, const ENTRY_TYPE *pageData, int size
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_pageData, impl_cnt_pageData;
  impl_off_pageData=impl_off=CK_ALIGN(impl_off,sizeof(ENTRY_TYPE));
  impl_off+=(impl_cnt_pageData=sizeof(ENTRY_TYPE)*(size));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|page;
    implP|impl_off_pageData;
    implP|impl_cnt_pageData;
    implP|size;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|page;
    implP|impl_off_pageData;
    implP|impl_cnt_pageData;
    implP|size;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_pageData,pageData,impl_cnt_pageData);
      CkSendMsgBranchMulti(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePage_marshall3, impl_msg, npes, pes, ckGetGroupID(),0);
    }
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePage_marshall3=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_ReceivePage_marshall3(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: unsigned int page, const ENTRY_TYPE *pageData, int size*/
  PUP::fromMem implP(impl_buf);
  unsigned int page; implP|page;
  int impl_off_pageData, impl_cnt_pageData; 
  implP|impl_off_pageData;
  implP|impl_cnt_pageData;
  int size; implP|size;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  ENTRY_TYPE *pageData=(ENTRY_TYPE *)(impl_buf+impl_off_pageData);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->ReceivePage(page, pageData, size);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_callmarshall_ReceivePage_marshall3(char* impl_buf,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj) {
  /*Unmarshall pup'd fields: unsigned int page, const ENTRY_TYPE *pageData, int size*/
  PUP::fromMem implP(impl_buf);
  unsigned int page; implP|page;
  int impl_off_pageData, impl_cnt_pageData; 
  implP|impl_off_pageData;
  implP|impl_cnt_pageData;
  int size; implP|size;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  ENTRY_TYPE *pageData=(ENTRY_TYPE *)(impl_buf+impl_off_pageData);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->ReceivePage(page, pageData, size);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
  return implP.size();
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_marshallmessagepup_ReceivePage_marshall3(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: unsigned int page, const ENTRY_TYPE *pageData, int size*/
  PUP::fromMem implP(impl_buf);
  unsigned int page; implP|page;
  int impl_off_pageData, impl_cnt_pageData; 
  implP|impl_off_pageData;
  implP|impl_cnt_pageData;
  int size; implP|size;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  ENTRY_TYPE *pageData=(ENTRY_TYPE *)(impl_buf+impl_off_pageData);
  if (implDestP.hasComments()) implDestP.comment("page");
  implDestP|page;
  if (implDestP.hasComments()) implDestP.comment("pageData");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*pageData))<impl_cnt_pageData;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|pageData[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("size");
  implDestP|size;
}

/* DEFS: void ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|page;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)pageData;
    implP|size;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|page;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)pageData;
    implP|size;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePageWithPUP_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePageWithPUP_marshall4, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePageWithPUP_marshall4, impl_msg, ckGetGroupID(),0);
}
    template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size, int npes, int *pes, const CkEntryOptions *impl_e_opts)
    {
  //Marshall: unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|page;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)pageData;
    implP|size;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|page;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)pageData;
    implP|size;
  }
      CkSendMsgBranchMulti(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePageWithPUP_marshall4, impl_msg, npes, pes, ckGetGroupID(),0);
    }
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_ReceivePageWithPUP_marshall4=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_ReceivePageWithPUP_marshall4(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size*/
  PUP::fromMem implP(impl_buf);
  unsigned int page; implP|page;
  MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > pageData; implP|pageData;
  int size; implP|size;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->ReceivePageWithPUP(page, pageData, size);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_callmarshall_ReceivePageWithPUP_marshall4(char* impl_buf,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj) {
  /*Unmarshall pup'd fields: unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size*/
  PUP::fromMem implP(impl_buf);
  unsigned int page; implP|page;
  MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > pageData; implP|pageData;
  int size; implP|size;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->ReceivePageWithPUP(page, pageData, size);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
  return implP.size();
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_marshallmessagepup_ReceivePageWithPUP_marshall4(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size*/
  PUP::fromMem implP(impl_buf);
  unsigned int page; implP|page;
  MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > pageData; implP|pageData;
  int size; implP|size;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("page");
  implDestP|page;
  if (implDestP.hasComments()) implDestP.comment("pageData");
  implDestP|pageData;
  if (implDestP.hasComments()) implDestP.comment("size");
  implDestP|size;
}

/* DEFS: void enroll(unsigned int numberOfWorkerThreads);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::enroll(unsigned int numberOfWorkerThreads, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: unsigned int numberOfWorkerThreads
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|numberOfWorkerThreads;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|numberOfWorkerThreads;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enroll_marshall5, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enroll_marshall5, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enroll_marshall5, impl_msg, ckGetGroupID(),0);
}
    template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::enroll(unsigned int numberOfWorkerThreads, int npes, int *pes, const CkEntryOptions *impl_e_opts)
    {
  //Marshall: unsigned int numberOfWorkerThreads
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|numberOfWorkerThreads;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|numberOfWorkerThreads;
  }
      CkSendMsgBranchMulti(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enroll_marshall5, impl_msg, npes, pes, ckGetGroupID(),0);
    }
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enroll_marshall5=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_enroll_marshall5(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: unsigned int numberOfWorkerThreads*/
  PUP::fromMem implP(impl_buf);
  unsigned int numberOfWorkerThreads; implP|numberOfWorkerThreads;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->enroll(numberOfWorkerThreads);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_callmarshall_enroll_marshall5(char* impl_buf,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj) {
  /*Unmarshall pup'd fields: unsigned int numberOfWorkerThreads*/
  PUP::fromMem implP(impl_buf);
  unsigned int numberOfWorkerThreads; implP|numberOfWorkerThreads;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->enroll(numberOfWorkerThreads);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
  return implP.size();
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_marshallmessagepup_enroll_marshall5(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: unsigned int numberOfWorkerThreads*/
  PUP::fromMem implP(impl_buf);
  unsigned int numberOfWorkerThreads; implP|numberOfWorkerThreads;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("numberOfWorkerThreads");
  implDestP|numberOfWorkerThreads;
}

/* DEFS: void enrollAck(int originator);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::enrollAck(int originator, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int originator
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|originator;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|originator;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollAck_marshall6, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollAck_marshall6, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollAck_marshall6, impl_msg, ckGetGroupID(),0);
}
    template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::enrollAck(int originator, int npes, int *pes, const CkEntryOptions *impl_e_opts)
    {
  //Marshall: int originator
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|originator;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|originator;
  }
      CkSendMsgBranchMulti(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollAck_marshall6, impl_msg, npes, pes, ckGetGroupID(),0);
    }
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollAck_marshall6=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_enrollAck_marshall6(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: int originator*/
  PUP::fromMem implP(impl_buf);
  int originator; implP|originator;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->enrollAck(originator);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_callmarshall_enrollAck_marshall6(char* impl_buf,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj) {
  /*Unmarshall pup'd fields: int originator*/
  PUP::fromMem implP(impl_buf);
  int originator; implP|originator;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->enrollAck(originator);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
  return implP.size();
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_marshallmessagepup_enrollAck_marshall6(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: int originator*/
  PUP::fromMem implP(impl_buf);
  int originator; implP|originator;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("originator");
  implDestP|originator;
}

/* DEFS: void enrollDone(void);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::enrollDone(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollDone_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollDone_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollDone_void, impl_msg, ckGetGroupID(),0);
}
    template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::enrollDone(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollDone_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_enrollDone_void=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_enrollDone_void(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  CkFreeSysMsg(impl_msg);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->enrollDone();
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}

/* DEFS: void SyncAck(void);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::SyncAck(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncAck_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncAck_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncAck_void, impl_msg, ckGetGroupID(),0);
}
    template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::SyncAck(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncAck_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncAck_void=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_SyncAck_void(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  CkFreeSysMsg(impl_msg);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->SyncAck();
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}

/* DEFS: void SyncDone(void);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::SyncDone(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncDone_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncDone_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncDone_void, impl_msg, ckGetGroupID(),0);
}
    template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::SyncDone(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncDone_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_SyncDone_void=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_SyncDone_void(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  CkFreeSysMsg(impl_msg);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->SyncDone();
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}

/* DEFS: void emitBufferValue(int ID, unsigned int pageNum, unsigned int offset);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::emitBufferValue(int ID, unsigned int pageNum, unsigned int offset, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: int ID, unsigned int pageNum, unsigned int offset
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|ID;
    implP|pageNum;
    implP|offset;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|ID;
    implP|pageNum;
    implP|offset;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_emitBufferValue_marshall10, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_emitBufferValue_marshall10, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_emitBufferValue_marshall10, impl_msg, ckGetGroupID(),0);
}
    template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::emitBufferValue(int ID, unsigned int pageNum, unsigned int offset, int npes, int *pes, const CkEntryOptions *impl_e_opts)
    {
  //Marshall: int ID, unsigned int pageNum, unsigned int offset
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|ID;
    implP|pageNum;
    implP|offset;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|ID;
    implP|pageNum;
    implP|offset;
  }
      CkSendMsgBranchMulti(CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_emitBufferValue_marshall10, impl_msg, npes, pes, ckGetGroupID(),0);
    }
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_emitBufferValue_marshall10=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_emitBufferValue_marshall10(void* impl_msg,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: int ID, unsigned int pageNum, unsigned int offset*/
  PUP::fromMem implP(impl_buf);
  int ID; implP|ID;
  unsigned int pageNum; implP|pageNum;
  unsigned int offset; implP|offset;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->emitBufferValue(ID, pageNum, offset);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_callmarshall_emitBufferValue_marshall10(char* impl_buf,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj) {
  /*Unmarshall pup'd fields: int ID, unsigned int pageNum, unsigned int offset*/
  PUP::fromMem implP(impl_buf);
  int ID; implP|ID;
  unsigned int pageNum; implP|pageNum;
  unsigned int offset; implP|offset;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->emitBufferValue(ID, pageNum, offset);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
  return implP.size();
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_marshallmessagepup_emitBufferValue_marshall10(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: int ID, unsigned int pageNum, unsigned int offset*/
  PUP::fromMem implP(impl_buf);
  int ID; implP|ID;
  unsigned int pageNum; implP|pageNum;
  unsigned int offset; implP|offset;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("ID");
  implDestP|ID;
  if (implDestP.hasComments()) implDestP.comment("pageNum");
  implDestP|pageNum;
  if (implDestP.hasComments()) implDestP.comment("offset");
  implDestP|offset;
}
#endif /*CK_TEMPLATES_ONLY*/
#ifdef CK_TEMPLATES_ONLY
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE > void CkIndex_MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,MSA_CacheGroup < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::isIrreducible());
// REG: MSA_CacheGroup(unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads);
  __idx_MSA_CacheGroup_marshall1 = CkRegisterEp("MSA_CacheGroup(unsigned int nPages, const CkArrayID &pageArrayID, unsigned int max_bytes, unsigned int nEntries, unsigned int numberOfWorkerThreads)",
     (CkCallFnPtr)_call_MSA_CacheGroup_marshall1, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_MSA_CacheGroup_marshall1,(CkMarshallUnpackFn)_callmarshall_MSA_CacheGroup_marshall1);
  CkRegisterMessagePupFn(__idx_MSA_CacheGroup_marshall1,(CkMessagePupFn)_marshallmessagepup_MSA_CacheGroup_marshall1);

// REG: void AckPage(unsigned int page);
  __idx_AckPage_marshall2 = CkRegisterEp("AckPage(unsigned int page)",
     (CkCallFnPtr)_call_AckPage_marshall2, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_AckPage_marshall2,(CkMarshallUnpackFn)_callmarshall_AckPage_marshall2);
  CkRegisterMessagePupFn(__idx_AckPage_marshall2,(CkMessagePupFn)_marshallmessagepup_AckPage_marshall2);

// REG: void ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size);
  __idx_ReceivePage_marshall3 = CkRegisterEp("ReceivePage(unsigned int page, const ENTRY_TYPE *pageData, int size)",
     (CkCallFnPtr)_call_ReceivePage_marshall3, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_ReceivePage_marshall3,(CkMarshallUnpackFn)_callmarshall_ReceivePage_marshall3);
  CkRegisterMessagePupFn(__idx_ReceivePage_marshall3,(CkMessagePupFn)_marshallmessagepup_ReceivePage_marshall3);

// REG: void ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size);
  __idx_ReceivePageWithPUP_marshall4 = CkRegisterEp("ReceivePageWithPUP(unsigned int page, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &pageData, int size)",
     (CkCallFnPtr)_call_ReceivePageWithPUP_marshall4, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_ReceivePageWithPUP_marshall4,(CkMarshallUnpackFn)_callmarshall_ReceivePageWithPUP_marshall4);
  CkRegisterMessagePupFn(__idx_ReceivePageWithPUP_marshall4,(CkMessagePupFn)_marshallmessagepup_ReceivePageWithPUP_marshall4);

// REG: void enroll(unsigned int numberOfWorkerThreads);
  __idx_enroll_marshall5 = CkRegisterEp("enroll(unsigned int numberOfWorkerThreads)",
     (CkCallFnPtr)_call_enroll_marshall5, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_enroll_marshall5,(CkMarshallUnpackFn)_callmarshall_enroll_marshall5);
  CkRegisterMessagePupFn(__idx_enroll_marshall5,(CkMessagePupFn)_marshallmessagepup_enroll_marshall5);

// REG: void enrollAck(int originator);
  __idx_enrollAck_marshall6 = CkRegisterEp("enrollAck(int originator)",
     (CkCallFnPtr)_call_enrollAck_marshall6, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_enrollAck_marshall6,(CkMarshallUnpackFn)_callmarshall_enrollAck_marshall6);
  CkRegisterMessagePupFn(__idx_enrollAck_marshall6,(CkMessagePupFn)_marshallmessagepup_enrollAck_marshall6);

// REG: void enrollDone(void);
  __idx_enrollDone_void = CkRegisterEp("enrollDone(void)",
     (CkCallFnPtr)_call_enrollDone_void, 0, __idx, 0);

// REG: void SyncAck(void);
  __idx_SyncAck_void = CkRegisterEp("SyncAck(void)",
     (CkCallFnPtr)_call_SyncAck_void, 0, __idx, 0);

// REG: void SyncDone(void);
  __idx_SyncDone_void = CkRegisterEp("SyncDone(void)",
     (CkCallFnPtr)_call_SyncDone_void, 0, __idx, 0);

// REG: void emitBufferValue(int ID, unsigned int pageNum, unsigned int offset);
  __idx_emitBufferValue_marshall10 = CkRegisterEp("emitBufferValue(int ID, unsigned int pageNum, unsigned int offset)",
     (CkCallFnPtr)_call_emitBufferValue_marshall10, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_emitBufferValue_marshall10,(CkMarshallUnpackFn)_callmarshall_emitBufferValue_marshall10);
  CkRegisterMessagePupFn(__idx_emitBufferValue_marshall10,(CkMessagePupFn)_marshallmessagepup_emitBufferValue_marshall10);
}
#endif

/* DEFS: template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE > array MSA_PageArray: ArrayElement{
MSA_PageArray(CkMigrateMessage* impl_msg);
MSA_PageArray(void);
void setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache);
void GetPage(int pe);
void PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState);
void PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
void PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
void Sync(void);
void emit(int ID, int offset);
};
 */
#ifdef CK_TEMPLATES_ONLY
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx=0;
#endif
#ifdef CK_TEMPLATES_ONLY
/* DEFS: MSA_PageArray(CkMigrateMessage* impl_msg);
 */

/* DEFS: MSA_PageArray(void);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::insert(int onPE)
{ 
  void *impl_msg = CkAllocSysMsg();
   ckInsert((CkArrayMessage *)impl_msg,CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_MSA_PageArray_void,onPE);
}

/* DEFS: void setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)cache;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)cache;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_setCacheProxy_marshall2,0);
}

/* DEFS: void GetPage(int pe);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::GetPage(int pe, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int pe
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|pe;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|pe;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_GetPage_marshall3,0);
}

/* DEFS: void PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_page, impl_cnt_page;
  impl_off_page=impl_off=CK_ALIGN(impl_off,sizeof(ENTRY_TYPE));
  impl_off+=(impl_cnt_page=sizeof(ENTRY_TYPE)*(ENTRIES_PER_PAGE));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_page;
    implP|impl_cnt_page;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_page;
    implP|impl_cnt_page;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_page,page,impl_cnt_page);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_PAReceivePage_marshall4,0);
}

/* DEFS: void PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_spans, impl_cnt_spans;
  impl_off_spans=impl_off=CK_ALIGN(impl_off,sizeof(MSA_WriteSpan_t));
  impl_off+=(impl_cnt_spans=sizeof(MSA_WriteSpan_t)*(nSpans));
  int impl_off_entries, impl_cnt_entries;
  impl_off_entries=impl_off=CK_ALIGN(impl_off,sizeof(ENTRY_TYPE));
  impl_off+=(impl_cnt_entries=sizeof(ENTRY_TYPE)*(nEntries));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_spans;
    implP|impl_cnt_spans;
    implP|nSpans;
    implP|impl_off_entries;
    implP|impl_cnt_entries;
    implP|nEntries;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_spans;
    implP|impl_cnt_spans;
    implP|nSpans;
    implP|impl_off_entries;
    implP|impl_cnt_entries;
    implP|nEntries;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_spans,spans,impl_cnt_spans);
  memcpy(impl_buf+impl_off_entries,entries,impl_cnt_entries);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_PAReceiveRLEPage_marshall5,0);
}

/* DEFS: void PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_spans, impl_cnt_spans;
  impl_off_spans=impl_off=CK_ALIGN(impl_off,sizeof(MSA_WriteSpan_t));
  impl_off+=(impl_cnt_spans=sizeof(MSA_WriteSpan_t)*(nSpans));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_spans;
    implP|impl_cnt_spans;
    implP|nSpans;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)entries;
    implP|nEntries;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_spans;
    implP|impl_cnt_spans;
    implP|nSpans;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)entries;
    implP|nEntries;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_spans,spans,impl_cnt_spans);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_PAReceiveRLEPageWithPup_marshall6,0);
}

/* DEFS: void Sync(void);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::Sync(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_Sync_void,0);
}

/* DEFS: void emit(int ID, int offset);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxyElement_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::emit(int ID, int offset, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int ID, int offset
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|ID;
    implP|offset;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|ID;
    implP|offset;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_emit_marshall8,0);
}
/* DEFS: MSA_PageArray(CkMigrateMessage* impl_msg);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_MSA_PageArray_CkMigrateMessage=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_MSA_PageArray_CkMigrateMessage(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ((CkMigrateMessage*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}

/* DEFS: MSA_PageArray(void);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  CkArrayID CProxy_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::ckNew(const CkArrayOptions &opts)
{ 
  void *impl_msg = CkAllocSysMsg();
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_MSA_PageArray_void,opts);
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  CkArrayID CProxy_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::ckNew(const int s1)
{ 
  void *impl_msg = CkAllocSysMsg();
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_MSA_PageArray_void,CkArrayOptions(s1));
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_MSA_PageArray_void=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_MSA_PageArray_void(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  CkFreeSysMsg(impl_msg);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ();
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}

/* DEFS: void setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)cache;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)cache;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_setCacheProxy_marshall2,0);
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_setCacheProxy_marshall2=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_setCacheProxy_marshall2(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache*/
  PUP::fromMem implP(impl_buf);
  CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > cache; implP|cache;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->setCacheProxy(cache);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_callmarshall_setCacheProxy_marshall2(char* impl_buf,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj) {
  /*Unmarshall pup'd fields: const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache*/
  PUP::fromMem implP(impl_buf);
  CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > cache; implP|cache;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->setCacheProxy(cache);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
  return implP.size();
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_marshallmessagepup_setCacheProxy_marshall2(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache*/
  PUP::fromMem implP(impl_buf);
  CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > cache; implP|cache;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("cache");
  implDestP|cache;
}

/* DEFS: void GetPage(int pe);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::GetPage(int pe, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int pe
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|pe;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|pe;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_GetPage_marshall3,0);
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_GetPage_marshall3=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_GetPage_marshall3(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: int pe*/
  PUP::fromMem implP(impl_buf);
  int pe; implP|pe;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->GetPage(pe);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_callmarshall_GetPage_marshall3(char* impl_buf,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj) {
  /*Unmarshall pup'd fields: int pe*/
  PUP::fromMem implP(impl_buf);
  int pe; implP|pe;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->GetPage(pe);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
  return implP.size();
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_marshallmessagepup_GetPage_marshall3(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: int pe*/
  PUP::fromMem implP(impl_buf);
  int pe; implP|pe;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("pe");
  implDestP|pe;
}

/* DEFS: void PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_page, impl_cnt_page;
  impl_off_page=impl_off=CK_ALIGN(impl_off,sizeof(ENTRY_TYPE));
  impl_off+=(impl_cnt_page=sizeof(ENTRY_TYPE)*(ENTRIES_PER_PAGE));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_page;
    implP|impl_cnt_page;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_page;
    implP|impl_cnt_page;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_page,page,impl_cnt_page);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_PAReceivePage_marshall4,0);
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_PAReceivePage_marshall4=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_PAReceivePage_marshall4(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState*/
  PUP::fromMem implP(impl_buf);
  int impl_off_page, impl_cnt_page; 
  implP|impl_off_page;
  implP|impl_cnt_page;
  int pe; implP|pe;
  MSA_Page_Fault_t pageState; implP|pageState;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  ENTRY_TYPE *page=(ENTRY_TYPE *)(impl_buf+impl_off_page);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->PAReceivePage(page, pe, pageState);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_callmarshall_PAReceivePage_marshall4(char* impl_buf,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj) {
  /*Unmarshall pup'd fields: const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState*/
  PUP::fromMem implP(impl_buf);
  int impl_off_page, impl_cnt_page; 
  implP|impl_off_page;
  implP|impl_cnt_page;
  int pe; implP|pe;
  MSA_Page_Fault_t pageState; implP|pageState;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  ENTRY_TYPE *page=(ENTRY_TYPE *)(impl_buf+impl_off_page);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->PAReceivePage(page, pe, pageState);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
  return implP.size();
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_marshallmessagepup_PAReceivePage_marshall4(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState*/
  PUP::fromMem implP(impl_buf);
  int impl_off_page, impl_cnt_page; 
  implP|impl_off_page;
  implP|impl_cnt_page;
  int pe; implP|pe;
  MSA_Page_Fault_t pageState; implP|pageState;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  ENTRY_TYPE *page=(ENTRY_TYPE *)(impl_buf+impl_off_page);
  if (implDestP.hasComments()) implDestP.comment("page");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*page))<impl_cnt_page;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|page[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("pe");
  implDestP|pe;
  if (implDestP.hasComments()) implDestP.comment("pageState");
  implDestP|pageState;
}

/* DEFS: void PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_spans, impl_cnt_spans;
  impl_off_spans=impl_off=CK_ALIGN(impl_off,sizeof(MSA_WriteSpan_t));
  impl_off+=(impl_cnt_spans=sizeof(MSA_WriteSpan_t)*(nSpans));
  int impl_off_entries, impl_cnt_entries;
  impl_off_entries=impl_off=CK_ALIGN(impl_off,sizeof(ENTRY_TYPE));
  impl_off+=(impl_cnt_entries=sizeof(ENTRY_TYPE)*(nEntries));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_spans;
    implP|impl_cnt_spans;
    implP|nSpans;
    implP|impl_off_entries;
    implP|impl_cnt_entries;
    implP|nEntries;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_spans;
    implP|impl_cnt_spans;
    implP|nSpans;
    implP|impl_off_entries;
    implP|impl_cnt_entries;
    implP|nEntries;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_spans,spans,impl_cnt_spans);
  memcpy(impl_buf+impl_off_entries,entries,impl_cnt_entries);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_PAReceiveRLEPage_marshall5,0);
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_PAReceiveRLEPage_marshall5=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_PAReceiveRLEPage_marshall5(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState*/
  PUP::fromMem implP(impl_buf);
  int impl_off_spans, impl_cnt_spans; 
  implP|impl_off_spans;
  implP|impl_cnt_spans;
  unsigned int nSpans; implP|nSpans;
  int impl_off_entries, impl_cnt_entries; 
  implP|impl_off_entries;
  implP|impl_cnt_entries;
  unsigned int nEntries; implP|nEntries;
  int pe; implP|pe;
  MSA_Page_Fault_t pageState; implP|pageState;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  MSA_WriteSpan_t *spans=(MSA_WriteSpan_t *)(impl_buf+impl_off_spans);
  ENTRY_TYPE *entries=(ENTRY_TYPE *)(impl_buf+impl_off_entries);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->PAReceiveRLEPage(spans, nSpans, entries, nEntries, pe, pageState);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_callmarshall_PAReceiveRLEPage_marshall5(char* impl_buf,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj) {
  /*Unmarshall pup'd fields: const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState*/
  PUP::fromMem implP(impl_buf);
  int impl_off_spans, impl_cnt_spans; 
  implP|impl_off_spans;
  implP|impl_cnt_spans;
  unsigned int nSpans; implP|nSpans;
  int impl_off_entries, impl_cnt_entries; 
  implP|impl_off_entries;
  implP|impl_cnt_entries;
  unsigned int nEntries; implP|nEntries;
  int pe; implP|pe;
  MSA_Page_Fault_t pageState; implP|pageState;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  MSA_WriteSpan_t *spans=(MSA_WriteSpan_t *)(impl_buf+impl_off_spans);
  ENTRY_TYPE *entries=(ENTRY_TYPE *)(impl_buf+impl_off_entries);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->PAReceiveRLEPage(spans, nSpans, entries, nEntries, pe, pageState);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
  return implP.size();
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_marshallmessagepup_PAReceiveRLEPage_marshall5(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState*/
  PUP::fromMem implP(impl_buf);
  int impl_off_spans, impl_cnt_spans; 
  implP|impl_off_spans;
  implP|impl_cnt_spans;
  unsigned int nSpans; implP|nSpans;
  int impl_off_entries, impl_cnt_entries; 
  implP|impl_off_entries;
  implP|impl_cnt_entries;
  unsigned int nEntries; implP|nEntries;
  int pe; implP|pe;
  MSA_Page_Fault_t pageState; implP|pageState;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  MSA_WriteSpan_t *spans=(MSA_WriteSpan_t *)(impl_buf+impl_off_spans);
  ENTRY_TYPE *entries=(ENTRY_TYPE *)(impl_buf+impl_off_entries);
  if (implDestP.hasComments()) implDestP.comment("spans");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*spans))<impl_cnt_spans;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|spans[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("nSpans");
  implDestP|nSpans;
  if (implDestP.hasComments()) implDestP.comment("entries");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*entries))<impl_cnt_entries;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|entries[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("nEntries");
  implDestP|nEntries;
  if (implDestP.hasComments()) implDestP.comment("pe");
  implDestP|pe;
  if (implDestP.hasComments()) implDestP.comment("pageState");
  implDestP|pageState;
}

/* DEFS: void PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_spans, impl_cnt_spans;
  impl_off_spans=impl_off=CK_ALIGN(impl_off,sizeof(MSA_WriteSpan_t));
  impl_off+=(impl_cnt_spans=sizeof(MSA_WriteSpan_t)*(nSpans));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_spans;
    implP|impl_cnt_spans;
    implP|nSpans;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)entries;
    implP|nEntries;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_spans;
    implP|impl_cnt_spans;
    implP|nSpans;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)entries;
    implP|nEntries;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_spans,spans,impl_cnt_spans);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_PAReceiveRLEPageWithPup_marshall6,0);
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_PAReceiveRLEPageWithPup_marshall6=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_PAReceiveRLEPageWithPup_marshall6(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState*/
  PUP::fromMem implP(impl_buf);
  int impl_off_spans, impl_cnt_spans; 
  implP|impl_off_spans;
  implP|impl_cnt_spans;
  unsigned int nSpans; implP|nSpans;
  MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > entries; implP|entries;
  unsigned int nEntries; implP|nEntries;
  int pe; implP|pe;
  MSA_Page_Fault_t pageState; implP|pageState;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  MSA_WriteSpan_t *spans=(MSA_WriteSpan_t *)(impl_buf+impl_off_spans);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->PAReceiveRLEPageWithPup(spans, nSpans, entries, nEntries, pe, pageState);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_callmarshall_PAReceiveRLEPageWithPup_marshall6(char* impl_buf,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj) {
  /*Unmarshall pup'd fields: const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState*/
  PUP::fromMem implP(impl_buf);
  int impl_off_spans, impl_cnt_spans; 
  implP|impl_off_spans;
  implP|impl_cnt_spans;
  unsigned int nSpans; implP|nSpans;
  MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > entries; implP|entries;
  unsigned int nEntries; implP|nEntries;
  int pe; implP|pe;
  MSA_Page_Fault_t pageState; implP|pageState;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  MSA_WriteSpan_t *spans=(MSA_WriteSpan_t *)(impl_buf+impl_off_spans);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->PAReceiveRLEPageWithPup(spans, nSpans, entries, nEntries, pe, pageState);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
  return implP.size();
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_marshallmessagepup_PAReceiveRLEPageWithPup_marshall6(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState*/
  PUP::fromMem implP(impl_buf);
  int impl_off_spans, impl_cnt_spans; 
  implP|impl_off_spans;
  implP|impl_cnt_spans;
  unsigned int nSpans; implP|nSpans;
  MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > entries; implP|entries;
  unsigned int nEntries; implP|nEntries;
  int pe; implP|pe;
  MSA_Page_Fault_t pageState; implP|pageState;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  MSA_WriteSpan_t *spans=(MSA_WriteSpan_t *)(impl_buf+impl_off_spans);
  if (implDestP.hasComments()) implDestP.comment("spans");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*spans))<impl_cnt_spans;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|spans[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("nSpans");
  implDestP|nSpans;
  if (implDestP.hasComments()) implDestP.comment("entries");
  implDestP|entries;
  if (implDestP.hasComments()) implDestP.comment("nEntries");
  implDestP|nEntries;
  if (implDestP.hasComments()) implDestP.comment("pe");
  implDestP|pe;
  if (implDestP.hasComments()) implDestP.comment("pageState");
  implDestP|pageState;
}

/* DEFS: void Sync(void);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::Sync(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_Sync_void,0);
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_Sync_void=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_Sync_void(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  CkFreeSysMsg(impl_msg);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->Sync();
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}

/* DEFS: void emit(int ID, int offset);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxy_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::emit(int ID, int offset, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int ID, int offset
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|ID;
    implP|offset;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|ID;
    implP|offset;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_emit_marshall8,0);
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_emit_marshall8=0;
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_call_emit_marshall8(void* impl_msg,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: int ID, int offset*/
  PUP::fromMem implP(impl_buf);
  int ID; implP|ID;
  int offset; implP|offset;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->emit(ID, offset);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  int CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_callmarshall_emit_marshall8(char* impl_buf,MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE >  * impl_obj) {
  /*Unmarshall pup'd fields: int ID, int offset*/
  PUP::fromMem implP(impl_buf);
  int ID; implP|ID;
  int offset; implP|offset;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  int alreadyUserCode = 1;
  setMemoryStatus(alreadyUserCode);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->emit(ID, offset);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(alreadyUserCode);
#endif
  return implP.size();
}
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::_marshallmessagepup_emit_marshall8(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: int ID, int offset*/
  PUP::fromMem implP(impl_buf);
  int ID; implP|ID;
  int offset; implP|offset;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("ID");
  implDestP|ID;
  if (implDestP.hasComments()) implDestP.comment("offset");
  implDestP|offset;
}
/* DEFS: MSA_PageArray(CkMigrateMessage* impl_msg);
 */

/* DEFS: MSA_PageArray(void);
 */

/* DEFS: void setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxySection_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)cache;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)cache;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_setCacheProxy_marshall2,0);
}

/* DEFS: void GetPage(int pe);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxySection_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::GetPage(int pe, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int pe
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|pe;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|pe;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_GetPage_marshall3,0);
}

/* DEFS: void PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxySection_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_page, impl_cnt_page;
  impl_off_page=impl_off=CK_ALIGN(impl_off,sizeof(ENTRY_TYPE));
  impl_off+=(impl_cnt_page=sizeof(ENTRY_TYPE)*(ENTRIES_PER_PAGE));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_page;
    implP|impl_cnt_page;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_page;
    implP|impl_cnt_page;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_page,page,impl_cnt_page);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_PAReceivePage_marshall4,0);
}

/* DEFS: void PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxySection_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_spans, impl_cnt_spans;
  impl_off_spans=impl_off=CK_ALIGN(impl_off,sizeof(MSA_WriteSpan_t));
  impl_off+=(impl_cnt_spans=sizeof(MSA_WriteSpan_t)*(nSpans));
  int impl_off_entries, impl_cnt_entries;
  impl_off_entries=impl_off=CK_ALIGN(impl_off,sizeof(ENTRY_TYPE));
  impl_off+=(impl_cnt_entries=sizeof(ENTRY_TYPE)*(nEntries));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_spans;
    implP|impl_cnt_spans;
    implP|nSpans;
    implP|impl_off_entries;
    implP|impl_cnt_entries;
    implP|nEntries;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_spans;
    implP|impl_cnt_spans;
    implP|nSpans;
    implP|impl_off_entries;
    implP|impl_cnt_entries;
    implP|nEntries;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_spans,spans,impl_cnt_spans);
  memcpy(impl_buf+impl_off_entries,entries,impl_cnt_entries);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_PAReceiveRLEPage_marshall5,0);
}

/* DEFS: void PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxySection_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_spans, impl_cnt_spans;
  impl_off_spans=impl_off=CK_ALIGN(impl_off,sizeof(MSA_WriteSpan_t));
  impl_off+=(impl_cnt_spans=sizeof(MSA_WriteSpan_t)*(nSpans));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_spans;
    implP|impl_cnt_spans;
    implP|nSpans;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)entries;
    implP|nEntries;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_spans;
    implP|impl_cnt_spans;
    implP|nSpans;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &)entries;
    implP|nEntries;
    implP|pe;
    //Have to cast away const-ness to get pup routine
    implP|(MSA_Page_Fault_t &)pageState;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_spans,spans,impl_cnt_spans);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_PAReceiveRLEPageWithPup_marshall6,0);
}

/* DEFS: void Sync(void);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxySection_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::Sync(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_Sync_void,0);
}

/* DEFS: void emit(int ID, int offset);
 */
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE >  void CProxySection_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::emit(int ID, int offset, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int ID, int offset
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|ID;
    implP|offset;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|ID;
    implP|offset;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__idx_emit_marshall8,0);
}
#endif /*CK_TEMPLATES_ONLY*/
#ifdef CK_TEMPLATES_ONLY
template < class ENTRY_TYPE, class ENTRY_OPS_CLASS, unsigned int ENTRIES_PER_PAGE > void CkIndex_MSA_PageArray < ENTRY_TYPE, ENTRY_OPS_CLASS, ENTRIES_PER_PAGE > ::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterBase(__idx, CkIndex_ArrayElement::__idx);
// REG: MSA_PageArray(CkMigrateMessage* impl_msg);
  __idx_MSA_PageArray_CkMigrateMessage = CkRegisterEp("MSA_PageArray(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_MSA_PageArray_CkMigrateMessage, 0, __idx, 0);
  CkRegisterMigCtor(__idx, __idx_MSA_PageArray_CkMigrateMessage);

// REG: MSA_PageArray(void);
  __idx_MSA_PageArray_void = CkRegisterEp("MSA_PageArray(void)",
     (CkCallFnPtr)_call_MSA_PageArray_void, 0, __idx, 0);
  CkRegisterDefaultCtor(__idx, __idx_MSA_PageArray_void);

// REG: void setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache);
  __idx_setCacheProxy_marshall2 = CkRegisterEp("setCacheProxy(const CProxy_MSA_CacheGroup<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &cache)",
     (CkCallFnPtr)_call_setCacheProxy_marshall2, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_setCacheProxy_marshall2,(CkMarshallUnpackFn)_callmarshall_setCacheProxy_marshall2);
  CkRegisterMessagePupFn(__idx_setCacheProxy_marshall2,(CkMessagePupFn)_marshallmessagepup_setCacheProxy_marshall2);

// REG: void GetPage(int pe);
  __idx_GetPage_marshall3 = CkRegisterEp("GetPage(int pe)",
     (CkCallFnPtr)_call_GetPage_marshall3, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_GetPage_marshall3,(CkMarshallUnpackFn)_callmarshall_GetPage_marshall3);
  CkRegisterMessagePupFn(__idx_GetPage_marshall3,(CkMessagePupFn)_marshallmessagepup_GetPage_marshall3);

// REG: void PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState);
  __idx_PAReceivePage_marshall4 = CkRegisterEp("PAReceivePage(const ENTRY_TYPE *page, int pe, const MSA_Page_Fault_t &pageState)",
     (CkCallFnPtr)_call_PAReceivePage_marshall4, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_PAReceivePage_marshall4,(CkMarshallUnpackFn)_callmarshall_PAReceivePage_marshall4);
  CkRegisterMessagePupFn(__idx_PAReceivePage_marshall4,(CkMessagePupFn)_marshallmessagepup_PAReceivePage_marshall4);

// REG: void PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
  __idx_PAReceiveRLEPage_marshall5 = CkRegisterEp("PAReceiveRLEPage(const MSA_WriteSpan_t *spans, unsigned int nSpans, const ENTRY_TYPE *entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState)",
     (CkCallFnPtr)_call_PAReceiveRLEPage_marshall5, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_PAReceiveRLEPage_marshall5,(CkMarshallUnpackFn)_callmarshall_PAReceiveRLEPage_marshall5);
  CkRegisterMessagePupFn(__idx_PAReceiveRLEPage_marshall5,(CkMessagePupFn)_marshallmessagepup_PAReceiveRLEPage_marshall5);

// REG: void PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState);
  __idx_PAReceiveRLEPageWithPup_marshall6 = CkRegisterEp("PAReceiveRLEPageWithPup(const MSA_WriteSpan_t *spans, unsigned int nSpans, const MSA_PageT<ENTRY_TYPE,ENTRY_OPS_CLASS,ENTRIES_PER_PAGE > &entries, unsigned int nEntries, int pe, const MSA_Page_Fault_t &pageState)",
     (CkCallFnPtr)_call_PAReceiveRLEPageWithPup_marshall6, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_PAReceiveRLEPageWithPup_marshall6,(CkMarshallUnpackFn)_callmarshall_PAReceiveRLEPageWithPup_marshall6);
  CkRegisterMessagePupFn(__idx_PAReceiveRLEPageWithPup_marshall6,(CkMessagePupFn)_marshallmessagepup_PAReceiveRLEPageWithPup_marshall6);

// REG: void Sync(void);
  __idx_Sync_void = CkRegisterEp("Sync(void)",
     (CkCallFnPtr)_call_Sync_void, 0, __idx, 0);

// REG: void emit(int ID, int offset);
  __idx_emit_marshall8 = CkRegisterEp("emit(int ID, int offset)",
     (CkCallFnPtr)_call_emit_marshall8, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_emit_marshall8,(CkMarshallUnpackFn)_callmarshall_emit_marshall8);
  CkRegisterMessagePupFn(__idx_emit_marshall8,(CkMessagePupFn)_marshallmessagepup_emit_marshall8);
}
#endif

#ifndef CK_TEMPLATES_ONLY
void _registermsa(void)
{
  static int _done = 0; if(_done) return; _done = 1;


}
#endif
