/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import projections.analysis.ObjectId;
import projections.gui.Timeline.Data;
import projections.gui.Timeline.EntryMethodObject;
import projections.gui.Timeline.ThreadMessageStructures;
import projections.gui.Timeline.TimelineMessage;

public class MessageStructures {
    Data data;
    private Map[] eventIDToMessageMap;
    private Map[] eventIDToEntryMethodMap;
    private Map messageToExecutingObjectsMap;
    private Map messageToSendingObjectsMap;
    private Map oidToEntryMethodObjectsMap;
    private ThreadMessageStructures secondaryWorkers;

    public MessageStructures(Data data) {
        this.data = data;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        MessageStructures messageStructures = this;
        synchronized (messageStructures) {
            int i;
            int pe = this.data.numPEs();
            this.eventIDToMessageMap = new HashMap[pe];
            for (i = 0; i < pe; ++i) {
                this.eventIDToMessageMap[i] = new HashMap();
            }
            this.eventIDToEntryMethodMap = new HashMap[pe];
            for (i = 0; i < pe; ++i) {
                this.eventIDToEntryMethodMap[i] = new HashMap();
            }
            this.messageToSendingObjectsMap = new HashMap();
            this.messageToExecutingObjectsMap = new HashMap();
            this.oidToEntryMethodObjectsMap = new TreeMap();
        }
    }

    public void create(boolean useSeparateThread) {
        this.init();
        this.secondaryWorkers = new ThreadMessageStructures(this);
        if (useSeparateThread) {
            this.secondaryWorkers.setPriority(1);
            this.secondaryWorkers.start();
        } else {
            this.generate();
        }
    }

    public void setEventIDToMessageMap(Map[] eventIDToMessageMap) {
        this.eventIDToMessageMap = eventIDToMessageMap;
    }

    public Map[] getEventIDToMessageMap() {
        return this.eventIDToMessageMap;
    }

    public Map getMessageToSendingObjectsMap() {
        return this.messageToSendingObjectsMap;
    }

    public Map getOidToEntryMethonObjectsMap() {
        return this.getOidToEntryMethodObjectsMap();
    }

    public void setOidToEntryMethodObjectsMap(Map oidToEntryMethodObjectsMap) {
        this.oidToEntryMethodObjectsMap = oidToEntryMethodObjectsMap;
    }

    public Map getOidToEntryMethodObjectsMap() {
        return this.oidToEntryMethodObjectsMap;
    }

    public void setEventIDToEntryMethodMap(Map[] eventIDToEntryMethodMap) {
        this.eventIDToEntryMethodMap = eventIDToEntryMethodMap;
    }

    public Map[] getEventIDToEntryMethodMap() {
        return this.eventIDToEntryMethodMap;
    }

    public void setMessageToExecutingObjectsMap(Map messageToExecutingObjectsMap) {
        this.messageToExecutingObjectsMap = messageToExecutingObjectsMap;
    }

    public Map getMessageToExecutingObjectsMap() {
        return this.messageToExecutingObjectsMap;
    }

    public void setMessageToSendingObjectsMap(Map messageToSendingObjectsMap) {
        this.messageToSendingObjectsMap = messageToSendingObjectsMap;
    }

    public void kill() {
        if (this.secondaryWorkers != null) {
            this.secondaryWorkers.stop();
            this.secondaryWorkers = null;
        }
        this.init();
    }

    public void generate() {
        LinkedList objs;
        for (Integer pe : this.data.allEntryMethodObjects.keySet()) {
            objs = (LinkedList)this.data.allEntryMethodObjects.get(pe);
            for (EntryMethodObject obj : objs) {
                for (TimelineMessage msg : obj.messages) {
                    this.getEventIDToMessageMap()[pe].put(new Integer(msg.EventID), msg);
                }
            }
        }
        for (Integer pe : this.data.allEntryMethodObjects.keySet()) {
            objs = (LinkedList)this.data.allEntryMethodObjects.get(pe);
            for (EntryMethodObject obj : objs) {
                this.getEventIDToEntryMethodMap()[pe].put(new Integer(obj.EventID), obj);
            }
        }
        for (Integer pe : this.data.allEntryMethodObjects.keySet()) {
            objs = (LinkedList)this.data.allEntryMethodObjects.get(pe);
            for (EntryMethodObject obj : objs) {
                for (TimelineMessage msg : obj.messages) {
                    this.getMessageToSendingObjectsMap().put(msg, obj);
                }
            }
        }
        for (Integer pe : this.data.allEntryMethodObjects.keySet()) {
            objs = (LinkedList)this.data.allEntryMethodObjects.get(pe);
            for (EntryMethodObject obj : objs) {
                TimelineMessage msg = obj.creationMessage();
                if (msg == null) continue;
                if (this.getMessageToExecutingObjectsMap().containsKey(msg)) {
                    Object o = this.getMessageToExecutingObjectsMap().get(msg);
                    TreeSet ts = (TreeSet)o;
                    ts.add(obj);
                    continue;
                }
                TreeSet<EntryMethodObject> ts = new TreeSet<EntryMethodObject>();
                ts.add(obj);
                this.getMessageToExecutingObjectsMap().put(msg, ts);
            }
        }
        for (Integer pe : this.data.allEntryMethodObjects.keySet()) {
            objs = (LinkedList)this.data.allEntryMethodObjects.get(pe);
            for (EntryMethodObject obj : objs) {
                TreeSet s;
                if (obj == null) continue;
                ObjectId id = obj.getTid();
                if (this.getOidToEntryMethodObjectsMap().containsKey(id)) {
                    s = (TreeSet)this.getOidToEntryMethodObjectsMap().get(id);
                    s.add(obj);
                    continue;
                }
                s = new TreeSet();
                s.add(obj);
                this.getOidToEntryMethodObjectsMap().put(id, s);
            }
        }
    }
}

