/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Set;
import javax.swing.JPanel;
import projections.gui.Timeline.Data;
import projections.gui.Timeline.EntryMethodObject;

public class MainPanelForeground
extends JPanel {
    private static final long serialVersionUID = 1L;
    Data data;

    public MainPanelForeground(Data data) {
        this.data = data;
    }

    protected void paintComponent(Graphics g) {
        this.paintMessageSendLines(g, this.data.getMessageColor(), this.data.drawMessagesForTheseObjects);
        this.paintMessageSendLines(g, this.data.getMessageAltColor(), this.data.drawMessagesForTheseObjectsAlt);
    }

    public void paintMessageSendLines(Graphics g, Color c, Set drawMessagesForObjects) {
        if (drawMessagesForObjects.size() > 0) {
            g.setColor(c);
            for (Object o : drawMessagesForObjects) {
                EntryMethodObject obj;
                if (!(o instanceof EntryMethodObject) || (obj = (EntryMethodObject)o).creationMessage() == null) continue;
                int pCreation = obj.pCreation;
                int pExecution = obj.pCurrent;
                int startpe_index = this.data.whichTimelineVerticalPosition(pCreation);
                int endpe_index = this.data.whichTimelineVerticalPosition(pExecution);
                int x1 = this.data.timeToScreenPixelLeft(obj.creationMessage().Time, this.getWidth());
                double y1 = (double)this.data.singleTimelineHeight() * ((double)startpe_index + 0.5) + (double)(this.data.barheight() / 2) + (double)this.data.messageSendHeight();
                int x2 = this.data.timeToScreenPixel(obj.getBeginTime(), this.getWidth());
                double y2 = (double)this.data.singleTimelineHeight() * ((double)endpe_index + 0.5) - (double)(this.data.barheight() / 2);
                g.drawLine(x1, (int)y1, x2, (int)y2);
            }
        }
    }
}

