/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JPanel;
import projections.gui.Timeline.Data;

public class MainPanelBackground
extends JPanel {
    Data data;

    public MainPanelBackground(Data data) {
        this.data = data;
    }

    protected void paintComponent(Graphics g) {
        int width = this.getWidth();
        g.setColor(this.data.getBackgroundColor());
        Rectangle clipBounds = g.getClipBounds();
        g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        if (this.data.selectionValid()) {
            g.setColor(new Color(100, 100, 100));
            g.fillRect(this.data.leftSelection(), 0, this.data.rightSelection() - this.data.leftSelection(), this.getHeight() - 1);
            g.setColor(Color.white);
            g.drawLine(this.data.leftSelection(), 0, this.data.leftSelection(), this.getHeight() - 1);
            g.drawLine(this.data.rightSelection(), 0, this.data.rightSelection(), this.getHeight() - 1);
        }
        if (this.data.highlightValid()) {
            g.setColor(Color.white);
            g.drawLine(this.data.getHighlight(), 0, this.data.getHighlight(), this.getHeight() - 1);
        }
        g.setColor(new Color(128, 128, 128));
        for (int i = 0; i < this.data.numPs(); ++i) {
            int y = this.data.singleTimelineHeight() / 2 + i * this.data.singleTimelineHeight();
            g.drawLine(0 + this.data.offset(), y, width - this.data.offset(), y);
        }
    }
}

