/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.util.Vector;
import projections.gui.MainWindow;

public class AmpiFunctionData {
    static int myRun = 0;
    public int FunctionID;
    public int LineNo;
    public String sourceFileName;
    private long accExecTime;
    private long lastBeginTime;
    private Vector execIntervals;

    public AmpiFunctionData() {
        this.LineNo = 0;
        this.FunctionID = 0;
        this.sourceFileName = null;
        this.accExecTime = 0L;
        this.lastBeginTime = 0L;
        this.execIntervals = new Vector();
    }

    public AmpiFunctionData(int funcId, int line, String srcFileName) {
        this.FunctionID = funcId;
        this.LineNo = line;
        this.sourceFileName = srcFileName;
        this.accExecTime = 0L;
        this.execIntervals = new Vector();
    }

    public void incrAccExecTime(long t) {
        this.accExecTime += t;
    }

    public long getAccExecTime() {
        return this.accExecTime;
    }

    public void incrAccExecTimeNow(long now) {
        this.accExecTime += now - this.lastBeginTime;
    }

    public void setLastBeginTime(long t) {
        this.lastBeginTime = t;
    }

    public long getLastBeginTime() {
        return this.lastBeginTime;
    }

    public String toString() {
        return this.sourceFileName + "@" + this.LineNo + "::" + this.FunctionID + " : " + this.accExecTime;
    }

    public Vector getExecIntervals() {
        return this.execIntervals;
    }

    public void insertExecInterval(AmpiFuncExecInterval interval) {
        this.execIntervals.add(interval);
    }

    public AmpiFuncExecInterval getIntervalAt(int i) {
        return (AmpiFuncExecInterval)this.execIntervals.get(i);
    }

    public int execIntervalCnt() {
        return this.execIntervals.size();
    }

    public String getFunctionName() {
        String name = MainWindow.runObject[myRun].getFunctionName(this.FunctionID);
        return name + "@" + this.sourceFileName + "(" + this.LineNo + ")";
    }

    public static class AmpiFuncExecInterval {
        public long startTimestamp;
        public long endTimestamp;

        public AmpiFuncExecInterval(long begin, long end) {
            this.startTimestamp = begin;
            this.endTimestamp = end;
        }

        public String toString() {
            return "Start: " + this.startTimestamp + "; End: " + this.endTimestamp;
        }
    }
}

