/*****************************************************************************
 * $Source: /cvsroot/charm/src/xlat-i/xi-main.C,v $
 * $Author: gzheng $
 * $Date: 2005/11/14 04:10:29 $
 * $Revision: 1.13 $
 *****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "xi-symbol.h"
#include "xi-grammar.tab.h"

extern FILE *yyin;
extern void yyrestart ( FILE *input_file );
extern int yyparse (void);
extern int yyerror(char *);

extern ModuleList *modlist;

/******************* Macro defines ****************/
class MacroDefinition {
public:
  char *key;
  char *val;
  MacroDefinition(): key(NULL), val(NULL) {}
  MacroDefinition(char *k, char *v): key(k), val(v) {}
  MacroDefinition(char *str) {
    // split by '='
    char *equal = strchr(str, '=');
    if (equal) {
      *equal = 0;
      key = str;
      val = equal+1;
    }
    else {
      key = str;
      val = "";
    }
  }
  char *match(char *k) { if (!strcmp(k, key)) return val; return NULL; }
};

static TList<MacroDefinition *> macros;

int macroDefined(char *str, int istrue) 
{
  MacroDefinition *def;
  for (def = macros.begin(); !macros.end(); def=macros.next()) {
    char *val = def->match(str);
    if (val) {
      if (!istrue) return 1;
      else return atoi(val);
    }
  }
  return 0;
}


ModuleList *Parse(char *interfacefile)
{
  cur_file=interfacefile;
  FILE * fp = fopen (interfacefile, "r") ;
  if (fp) {
    yyin = fp ;
    if(yyparse())
      exit(1);
    fclose(fp) ;
  } else {
    cout << "ERROR : could not open " << interfacefile << endl ;
  }
  return modlist;
}

void abortxi(char *name)
{
  cout << "Usage : " << name << " [-ansi|-f90|-intrinsic]  module.ci" << endl;
  exit(1) ;
}

int main(int argc, char *argv[])
{
  char *fname=NULL;
  fortranMode = 0;
  internalMode = 0;

  for (int i=1; i<argc; i++) {
    if (*argv[i]=='-') {
      if (strcmp(argv[i],"-ansi")==0);
      else if (strcmp(argv[i],"-f90")==0)  fortranMode = 1;
      else if (strcmp(argv[i],"-intrinsic")==0)  internalMode = 1;
      else if (strncmp(argv[i],"-D", 2)==0)  macros.append(new MacroDefinition(argv[i]+2));
      else abortxi(argv[0]);
    }
    else
      fname = argv[i];
  }
  if (fname==NULL) abortxi(argv[0]);

  ModuleList *m = Parse(fname) ;
  m->generate();
  return 0 ;
}
