#ifndef _DECL_HybridBaseLB_H_
#define _DECL_HybridBaseLB_H_
#include "charm++.h"
#include "LBDatabase.decl.h"

#include "BaseLB.decl.h"

#include "NeighborLBMsg.h"

#include "CentralLBMsg.h"

#include "HybridLBMsg.h"


/* DECLS: group HybridBaseLB: BaseLB{
HybridBaseLB(CkMigrateMessage* impl_msg);
void HybridBaseLB(const CkLBOptions &impl_noname_0);
void ProcessAtSync(void);
void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level);
void ResumeClients(CkReductionMsg* impl_msg);
void ResumeClients(int balancing);
void ReceiveMigration(LBMigrateMsg* impl_msg);
void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg);
void TotalObjMigrated(int count, int level);
void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level);
void Loadbalancing(int level);
void NotifyObjectMigrationDone(int impl_noname_1);
void StartCollectInfo(void);
void CollectInfo(const Location *loc, int n, int fromlevel);
void PropagateInfo(const Location *loc, int n, int fromlevel);
void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6);
void reportLBMem(double impl_noname_7);
};
 */
 class HybridBaseLB;
 class CkIndex_HybridBaseLB;
 class CProxy_HybridBaseLB;
 class CProxyElement_HybridBaseLB;
/* --------------- index object ------------------ */
class CkIndex_HybridBaseLB:public CProxyElement_BaseLB{
  public:
    typedef HybridBaseLB local_t;
    typedef CkIndex_HybridBaseLB index_t;
    typedef CProxy_HybridBaseLB proxy_t;
    typedef CProxyElement_HybridBaseLB element_t;

    static int __idx;
    static void __register(const char *s, size_t size);
/* DECLS: HybridBaseLB(CkMigrateMessage* impl_msg);
 */
    static int __idx_HybridBaseLB_CkMigrateMessage;
    static int ckNew(CkMigrateMessage* impl_msg) { return __idx_HybridBaseLB_CkMigrateMessage; }
    static void _call_HybridBaseLB_CkMigrateMessage(void* impl_msg,HybridBaseLB* impl_obj);

/* DECLS: void HybridBaseLB(const CkLBOptions &impl_noname_0);
 */
    static int __idx_HybridBaseLB_marshall1;
    static int ckNew(const CkLBOptions &impl_noname_0) { return __idx_HybridBaseLB_marshall1; }
    static void _call_HybridBaseLB_marshall1(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_HybridBaseLB_marshall1(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_HybridBaseLB_marshall1(PUP::er &p,void *msg);

/* DECLS: void ProcessAtSync(void);
 */
    static int __idx_ProcessAtSync_void;
    static int ProcessAtSync(void) { return __idx_ProcessAtSync_void; }
    static void _call_ProcessAtSync_void(void* impl_msg,HybridBaseLB* impl_obj);

/* DECLS: void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level);
 */
    static int __idx_ReceiveStats_marshall3;
    static int ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level) { return __idx_ReceiveStats_marshall3; }
    static void _call_ReceiveStats_marshall3(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_ReceiveStats_marshall3(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_ReceiveStats_marshall3(PUP::er &p,void *msg);

/* DECLS: void ResumeClients(CkReductionMsg* impl_msg);
 */
    static int __idx_ResumeClients_CkReductionMsg;
    static int ResumeClients(CkReductionMsg* impl_msg) { return __idx_ResumeClients_CkReductionMsg; }
    static void _call_ResumeClients_CkReductionMsg(void* impl_msg,HybridBaseLB* impl_obj);

/* DECLS: void ResumeClients(int balancing);
 */
    static int __idx_ResumeClients_marshall5;
    static int ResumeClients(int balancing) { return __idx_ResumeClients_marshall5; }
    static void _call_ResumeClients_marshall5(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_ResumeClients_marshall5(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_ResumeClients_marshall5(PUP::er &p,void *msg);

/* DECLS: void ReceiveMigration(LBMigrateMsg* impl_msg);
 */
    static int __idx_ReceiveMigration_LBMigrateMsg;
    static int ReceiveMigration(LBMigrateMsg* impl_msg) { return __idx_ReceiveMigration_LBMigrateMsg; }
    static void _call_ReceiveMigration_LBMigrateMsg(void* impl_msg,HybridBaseLB* impl_obj);

/* DECLS: void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg);
 */
    static int __idx_ReceiveVectorMigration_LBVectorMigrateMsg;
    static int ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg) { return __idx_ReceiveVectorMigration_LBVectorMigrateMsg; }
    static void _call_ReceiveVectorMigration_LBVectorMigrateMsg(void* impl_msg,HybridBaseLB* impl_obj);

/* DECLS: void TotalObjMigrated(int count, int level);
 */
    static int __idx_TotalObjMigrated_marshall8;
    static int TotalObjMigrated(int count, int level) { return __idx_TotalObjMigrated_marshall8; }
    static void _call_TotalObjMigrated_marshall8(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_TotalObjMigrated_marshall8(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_TotalObjMigrated_marshall8(PUP::er &p,void *msg);

/* DECLS: void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level);
 */
    static int __idx_ObjMigrated_marshall9;
    static int ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level) { return __idx_ObjMigrated_marshall9; }
    static void _call_ObjMigrated_marshall9(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_ObjMigrated_marshall9(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_ObjMigrated_marshall9(PUP::er &p,void *msg);

/* DECLS: void Loadbalancing(int level);
 */
    static int __idx_Loadbalancing_marshall10;
    static int Loadbalancing(int level) { return __idx_Loadbalancing_marshall10; }
    static void _call_Loadbalancing_marshall10(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_Loadbalancing_marshall10(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_Loadbalancing_marshall10(PUP::er &p,void *msg);

/* DECLS: void NotifyObjectMigrationDone(int impl_noname_1);
 */
    static int __idx_NotifyObjectMigrationDone_marshall11;
    static int NotifyObjectMigrationDone(int impl_noname_1) { return __idx_NotifyObjectMigrationDone_marshall11; }
    static void _call_NotifyObjectMigrationDone_marshall11(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_NotifyObjectMigrationDone_marshall11(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_NotifyObjectMigrationDone_marshall11(PUP::er &p,void *msg);

/* DECLS: void StartCollectInfo(void);
 */
    static int __idx_StartCollectInfo_void;
    static int StartCollectInfo(void) { return __idx_StartCollectInfo_void; }
    static void _call_StartCollectInfo_void(void* impl_msg,HybridBaseLB* impl_obj);

/* DECLS: void CollectInfo(const Location *loc, int n, int fromlevel);
 */
    static int __idx_CollectInfo_marshall13;
    static int CollectInfo(const Location *loc, int n, int fromlevel) { return __idx_CollectInfo_marshall13; }
    static void _call_CollectInfo_marshall13(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_CollectInfo_marshall13(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_CollectInfo_marshall13(PUP::er &p,void *msg);

/* DECLS: void PropagateInfo(const Location *loc, int n, int fromlevel);
 */
    static int __idx_PropagateInfo_marshall14;
    static int PropagateInfo(const Location *loc, int n, int fromlevel) { return __idx_PropagateInfo_marshall14; }
    static void _call_PropagateInfo_marshall14(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_PropagateInfo_marshall14(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_PropagateInfo_marshall14(PUP::er &p,void *msg);

/* DECLS: void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6);
 */
    static int __idx_reportLBQulity_marshall15;
    static int reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6) { return __idx_reportLBQulity_marshall15; }
    static void _call_reportLBQulity_marshall15(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_reportLBQulity_marshall15(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_reportLBQulity_marshall15(PUP::er &p,void *msg);

/* DECLS: void reportLBMem(double impl_noname_7);
 */
    static int __idx_reportLBMem_marshall16;
    static int reportLBMem(double impl_noname_7) { return __idx_reportLBMem_marshall16; }
    static void _call_reportLBMem_marshall16(void* impl_msg,HybridBaseLB* impl_obj);
    static int _callmarshall_reportLBMem_marshall16(char* impl_buf,HybridBaseLB* impl_obj);
    static void _marshallmessagepup_reportLBMem_marshall16(PUP::er &p,void *msg);
};
/* --------------- element proxy ------------------ */
class CProxyElement_HybridBaseLB: public CProxyElement_BaseLB{
  public:
    typedef HybridBaseLB local_t;
    typedef CkIndex_HybridBaseLB index_t;
    typedef CProxy_HybridBaseLB proxy_t;
    typedef CProxyElement_HybridBaseLB element_t;

    CProxyElement_HybridBaseLB(void) {}
    CProxyElement_HybridBaseLB(const IrrGroup *g) : CProxyElement_BaseLB(g){  }
    CProxyElement_HybridBaseLB(CkGroupID _gid,int _onPE,CK_DELCTOR_PARAM) : CProxyElement_BaseLB(_gid,_onPE,CK_DELCTOR_ARGS){  }
    CProxyElement_HybridBaseLB(CkGroupID _gid,int _onPE) : CProxyElement_BaseLB(_gid,_onPE){  }
   CK_DISAMBIG_GROUP_ELEMENT(CProxyElement_BaseLB)
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxyElement_BaseLB::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxyElement_BaseLB::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxyElement_BaseLB::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxyElement_BaseLB::ckSetGroupID(g);
    }
    HybridBaseLB* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static HybridBaseLB* ckLocalBranch(CkGroupID gID) {
      return (HybridBaseLB*)CkLocalBranch(gID);
    }
/* DECLS: HybridBaseLB(CkMigrateMessage* impl_msg);
 */

/* DECLS: void HybridBaseLB(const CkLBOptions &impl_noname_0);
 */

/* DECLS: void ProcessAtSync(void);
 */
    void ProcessAtSync(void)
    {
    ckCheck();
  void *impl_msg = CkAllocSysMsg();
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_ProcessAtSync_void, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_ProcessAtSync_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_ProcessAtSync_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level);
 */
    void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: const CkMarshalledCLBStatsMessage &data, int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkMarshalledCLBStatsMessage &)data;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkMarshalledCLBStatsMessage &)data;
    implP|level;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_ReceiveStats_marshall3, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_ReceiveStats_marshall3, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_ReceiveStats_marshall3, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void ResumeClients(CkReductionMsg* impl_msg);
 */
    void ResumeClients(CkReductionMsg* impl_msg)
    {
    ckCheck();
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_ResumeClients_CkReductionMsg, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_ResumeClients_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_ResumeClients_CkReductionMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void ResumeClients(int balancing);
 */
    void ResumeClients(int balancing, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int balancing
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|balancing;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|balancing;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_ResumeClients_marshall5, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_ResumeClients_marshall5, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_ResumeClients_marshall5, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void ReceiveMigration(LBMigrateMsg* impl_msg);
 */
    void ReceiveMigration(LBMigrateMsg* impl_msg)
    {
    ckCheck();
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_ReceiveMigration_LBMigrateMsg, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_ReceiveMigration_LBMigrateMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_ReceiveMigration_LBMigrateMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg);
 */
    void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg)
    {
    ckCheck();
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_ReceiveVectorMigration_LBVectorMigrateMsg, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_ReceiveVectorMigration_LBVectorMigrateMsg, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_ReceiveVectorMigration_LBVectorMigrateMsg, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void TotalObjMigrated(int count, int level);
 */
    void TotalObjMigrated(int count, int level, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int count, int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|count;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|count;
    implP|level;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_TotalObjMigrated_marshall8, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_TotalObjMigrated_marshall8, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_TotalObjMigrated_marshall8, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level);
 */
    void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: const LDObjData &data, const LDCommData *cdata, int n, int level
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_cdata, impl_cnt_cdata;
  impl_off_cdata=impl_off=CK_ALIGN(impl_off,sizeof(LDCommData));
  impl_off+=(impl_cnt_cdata=sizeof(LDCommData)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(LDObjData &)data;
    implP|impl_off_cdata;
    implP|impl_cnt_cdata;
    implP|n;
    implP|level;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(LDObjData &)data;
    implP|impl_off_cdata;
    implP|impl_cnt_cdata;
    implP|n;
    implP|level;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_cdata,cdata,impl_cnt_cdata);
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_ObjMigrated_marshall9, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_ObjMigrated_marshall9, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_ObjMigrated_marshall9, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void Loadbalancing(int level);
 */
    void Loadbalancing(int level, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|level;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_Loadbalancing_marshall10, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_Loadbalancing_marshall10, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_Loadbalancing_marshall10, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void NotifyObjectMigrationDone(int impl_noname_1);
 */
    void NotifyObjectMigrationDone(int impl_noname_1, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int impl_noname_1
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_1;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_1;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_NotifyObjectMigrationDone_marshall11, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_NotifyObjectMigrationDone_marshall11, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_NotifyObjectMigrationDone_marshall11, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void StartCollectInfo(void);
 */
    void StartCollectInfo(void)
    {
    ckCheck();
  void *impl_msg = CkAllocSysMsg();
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_StartCollectInfo_void, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_StartCollectInfo_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_StartCollectInfo_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void CollectInfo(const Location *loc, int n, int fromlevel);
 */
    void CollectInfo(const Location *loc, int n, int fromlevel, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: const Location *loc, int n, int fromlevel
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_loc, impl_cnt_loc;
  impl_off_loc=impl_off=CK_ALIGN(impl_off,sizeof(Location));
  impl_off+=(impl_cnt_loc=sizeof(Location)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_loc;
    implP|impl_cnt_loc;
    implP|n;
    implP|fromlevel;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_loc;
    implP|impl_cnt_loc;
    implP|n;
    implP|fromlevel;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_loc,loc,impl_cnt_loc);
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_CollectInfo_marshall13, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_CollectInfo_marshall13, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_CollectInfo_marshall13, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void PropagateInfo(const Location *loc, int n, int fromlevel);
 */
    void PropagateInfo(const Location *loc, int n, int fromlevel, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: const Location *loc, int n, int fromlevel
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_loc, impl_cnt_loc;
  impl_off_loc=impl_off=CK_ALIGN(impl_off,sizeof(Location));
  impl_off+=(impl_cnt_loc=sizeof(Location)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_loc;
    implP|impl_cnt_loc;
    implP|n;
    implP|fromlevel;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_loc;
    implP|impl_cnt_loc;
    implP|n;
    implP|fromlevel;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_loc,loc,impl_cnt_loc);
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_PropagateInfo_marshall14, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_PropagateInfo_marshall14, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_PropagateInfo_marshall14, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6);
 */
    void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_2;
    implP|impl_noname_3;
    implP|impl_noname_4;
    implP|impl_noname_5;
    implP|impl_noname_6;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_2;
    implP|impl_noname_3;
    implP|impl_noname_4;
    implP|impl_noname_5;
    implP|impl_noname_6;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_reportLBQulity_marshall15, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_reportLBQulity_marshall15, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_reportLBQulity_marshall15, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }

/* DECLS: void reportLBMem(double impl_noname_7);
 */
    void reportLBMem(double impl_noname_7, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: double impl_noname_7
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_7;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_7;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_reportLBMem_marshall16, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_reportLBMem_marshall16, impl_msg, ckGetGroupPe(), ckGetGroupID());
      } else CkSendMsgBranch(CkIndex_HybridBaseLB::__idx_reportLBMem_marshall16, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
    }
};
PUPmarshall(CProxyElement_HybridBaseLB);
/* ---------------- collective proxy -------------- */
class CProxy_HybridBaseLB: public CProxy_BaseLB{
  public:
    typedef HybridBaseLB local_t;
    typedef CkIndex_HybridBaseLB index_t;
    typedef CProxy_HybridBaseLB proxy_t;
    typedef CProxyElement_HybridBaseLB element_t;

    CProxy_HybridBaseLB(void) {}
    CProxy_HybridBaseLB(const IrrGroup *g) : CProxy_BaseLB(g){  }
    CProxy_HybridBaseLB(CkGroupID _gid,CK_DELCTOR_PARAM) : CProxy_BaseLB(_gid,CK_DELCTOR_ARGS){  }
    CProxy_HybridBaseLB(CkGroupID _gid) : CProxy_BaseLB(_gid){  }
    CProxyElement_HybridBaseLB operator[](int onPE) const
      {return CProxyElement_HybridBaseLB(ckGetGroupID(),onPE,CK_DELCTOR_CALL);}
   CK_DISAMBIG_GROUP(CProxy_BaseLB)
    void ckDelegate(CkDelegateMgr *dTo,CkDelegateData *dPtr=NULL) {
      CProxy_BaseLB::ckDelegate(dTo,dPtr);
    }
    void ckUndelegate(void) {
      CProxy_BaseLB::ckUndelegate();
    }
    void pup(PUP::er &p) {
      CProxy_BaseLB::pup(p);
    }
    void ckSetGroupID(CkGroupID g) {
      CProxy_BaseLB::ckSetGroupID(g);
    }
    HybridBaseLB* ckLocalBranch(void) const {
      return ckLocalBranch(ckGetGroupID());
    }
    static HybridBaseLB* ckLocalBranch(CkGroupID gID) {
      return (HybridBaseLB*)CkLocalBranch(gID);
    }
/* DECLS: HybridBaseLB(CkMigrateMessage* impl_msg);
 */

/* DECLS: void HybridBaseLB(const CkLBOptions &impl_noname_0);
 */
    static CkGroupID ckNew(const CkLBOptions &impl_noname_0, const CkEntryOptions *impl_e_opts=NULL);
    CProxy_HybridBaseLB(const CkLBOptions &impl_noname_0, const CkEntryOptions *impl_e_opts=NULL);

/* DECLS: void ProcessAtSync(void);
 */
    void ProcessAtSync(void)
    {
    ckCheck();
  void *impl_msg = CkAllocSysMsg();
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_ProcessAtSync_void, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_ProcessAtSync_void, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_ProcessAtSync_void, impl_msg, ckGetGroupID(),0);
    }
    void ProcessAtSync(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_ProcessAtSync_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level);
 */
    void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: const CkMarshalledCLBStatsMessage &data, int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkMarshalledCLBStatsMessage &)data;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkMarshalledCLBStatsMessage &)data;
    implP|level;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_ReceiveStats_marshall3, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_ReceiveStats_marshall3, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_ReceiveStats_marshall3, impl_msg, ckGetGroupID(),0);
    }
    void ReceiveStats(const CkMarshalledCLBStatsMessage &data, int level, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: const CkMarshalledCLBStatsMessage &data, int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkMarshalledCLBStatsMessage &)data;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkMarshalledCLBStatsMessage &)data;
    implP|level;
  }
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_ReceiveStats_marshall3, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void ResumeClients(CkReductionMsg* impl_msg);
 */
    void ResumeClients(CkReductionMsg* impl_msg)
    {
    ckCheck();
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_ResumeClients_CkReductionMsg, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_ResumeClients_CkReductionMsg, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_ResumeClients_CkReductionMsg, impl_msg, ckGetGroupID(),0);
    }
    void ResumeClients(CkReductionMsg* impl_msg, int npes, int *pes)
    {
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_ResumeClients_CkReductionMsg, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void ResumeClients(int balancing);
 */
    void ResumeClients(int balancing, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int balancing
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|balancing;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|balancing;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_ResumeClients_marshall5, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_ResumeClients_marshall5, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_ResumeClients_marshall5, impl_msg, ckGetGroupID(),0);
    }
    void ResumeClients(int balancing, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: int balancing
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|balancing;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|balancing;
  }
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_ResumeClients_marshall5, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void ReceiveMigration(LBMigrateMsg* impl_msg);
 */
    void ReceiveMigration(LBMigrateMsg* impl_msg)
    {
    ckCheck();
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_ReceiveMigration_LBMigrateMsg, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_ReceiveMigration_LBMigrateMsg, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_ReceiveMigration_LBMigrateMsg, impl_msg, ckGetGroupID(),0);
    }
    void ReceiveMigration(LBMigrateMsg* impl_msg, int npes, int *pes)
    {
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_ReceiveMigration_LBMigrateMsg, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg);
 */
    void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg)
    {
    ckCheck();
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_ReceiveVectorMigration_LBVectorMigrateMsg, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_ReceiveVectorMigration_LBVectorMigrateMsg, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_ReceiveVectorMigration_LBVectorMigrateMsg, impl_msg, ckGetGroupID(),0);
    }
    void ReceiveVectorMigration(LBVectorMigrateMsg* impl_msg, int npes, int *pes)
    {
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_ReceiveVectorMigration_LBVectorMigrateMsg, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void TotalObjMigrated(int count, int level);
 */
    void TotalObjMigrated(int count, int level, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int count, int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|count;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|count;
    implP|level;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_TotalObjMigrated_marshall8, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_TotalObjMigrated_marshall8, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_TotalObjMigrated_marshall8, impl_msg, ckGetGroupID(),0);
    }
    void TotalObjMigrated(int count, int level, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: int count, int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|count;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|count;
    implP|level;
  }
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_TotalObjMigrated_marshall8, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level);
 */
    void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: const LDObjData &data, const LDCommData *cdata, int n, int level
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_cdata, impl_cnt_cdata;
  impl_off_cdata=impl_off=CK_ALIGN(impl_off,sizeof(LDCommData));
  impl_off+=(impl_cnt_cdata=sizeof(LDCommData)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(LDObjData &)data;
    implP|impl_off_cdata;
    implP|impl_cnt_cdata;
    implP|n;
    implP|level;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(LDObjData &)data;
    implP|impl_off_cdata;
    implP|impl_cnt_cdata;
    implP|n;
    implP|level;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_cdata,cdata,impl_cnt_cdata);
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_ObjMigrated_marshall9, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_ObjMigrated_marshall9, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_ObjMigrated_marshall9, impl_msg, ckGetGroupID(),0);
    }
    void ObjMigrated(const LDObjData &data, const LDCommData *cdata, int n, int level, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: const LDObjData &data, const LDCommData *cdata, int n, int level
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_cdata, impl_cnt_cdata;
  impl_off_cdata=impl_off=CK_ALIGN(impl_off,sizeof(LDCommData));
  impl_off+=(impl_cnt_cdata=sizeof(LDCommData)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(LDObjData &)data;
    implP|impl_off_cdata;
    implP|impl_cnt_cdata;
    implP|n;
    implP|level;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(LDObjData &)data;
    implP|impl_off_cdata;
    implP|impl_cnt_cdata;
    implP|n;
    implP|level;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_cdata,cdata,impl_cnt_cdata);
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_ObjMigrated_marshall9, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void Loadbalancing(int level);
 */
    void Loadbalancing(int level, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|level;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_Loadbalancing_marshall10, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_Loadbalancing_marshall10, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_Loadbalancing_marshall10, impl_msg, ckGetGroupID(),0);
    }
    void Loadbalancing(int level, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: int level
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|level;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|level;
  }
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_Loadbalancing_marshall10, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void NotifyObjectMigrationDone(int impl_noname_1);
 */
    void NotifyObjectMigrationDone(int impl_noname_1, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: int impl_noname_1
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_1;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_1;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_NotifyObjectMigrationDone_marshall11, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_NotifyObjectMigrationDone_marshall11, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_NotifyObjectMigrationDone_marshall11, impl_msg, ckGetGroupID(),0);
    }
    void NotifyObjectMigrationDone(int impl_noname_1, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: int impl_noname_1
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_1;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_1;
  }
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_NotifyObjectMigrationDone_marshall11, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void StartCollectInfo(void);
 */
    void StartCollectInfo(void)
    {
    ckCheck();
  void *impl_msg = CkAllocSysMsg();
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_StartCollectInfo_void, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_StartCollectInfo_void, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_StartCollectInfo_void, impl_msg, ckGetGroupID(),0);
    }
    void StartCollectInfo(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_StartCollectInfo_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void CollectInfo(const Location *loc, int n, int fromlevel);
 */
    void CollectInfo(const Location *loc, int n, int fromlevel, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: const Location *loc, int n, int fromlevel
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_loc, impl_cnt_loc;
  impl_off_loc=impl_off=CK_ALIGN(impl_off,sizeof(Location));
  impl_off+=(impl_cnt_loc=sizeof(Location)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_loc;
    implP|impl_cnt_loc;
    implP|n;
    implP|fromlevel;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_loc;
    implP|impl_cnt_loc;
    implP|n;
    implP|fromlevel;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_loc,loc,impl_cnt_loc);
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_CollectInfo_marshall13, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_CollectInfo_marshall13, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_CollectInfo_marshall13, impl_msg, ckGetGroupID(),0);
    }
    void CollectInfo(const Location *loc, int n, int fromlevel, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: const Location *loc, int n, int fromlevel
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_loc, impl_cnt_loc;
  impl_off_loc=impl_off=CK_ALIGN(impl_off,sizeof(Location));
  impl_off+=(impl_cnt_loc=sizeof(Location)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_loc;
    implP|impl_cnt_loc;
    implP|n;
    implP|fromlevel;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_loc;
    implP|impl_cnt_loc;
    implP|n;
    implP|fromlevel;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_loc,loc,impl_cnt_loc);
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_CollectInfo_marshall13, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void PropagateInfo(const Location *loc, int n, int fromlevel);
 */
    void PropagateInfo(const Location *loc, int n, int fromlevel, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: const Location *loc, int n, int fromlevel
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_loc, impl_cnt_loc;
  impl_off_loc=impl_off=CK_ALIGN(impl_off,sizeof(Location));
  impl_off+=(impl_cnt_loc=sizeof(Location)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_loc;
    implP|impl_cnt_loc;
    implP|n;
    implP|fromlevel;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_loc;
    implP|impl_cnt_loc;
    implP|n;
    implP|fromlevel;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_loc,loc,impl_cnt_loc);
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_PropagateInfo_marshall14, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_PropagateInfo_marshall14, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_PropagateInfo_marshall14, impl_msg, ckGetGroupID(),0);
    }
    void PropagateInfo(const Location *loc, int n, int fromlevel, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: const Location *loc, int n, int fromlevel
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_loc, impl_cnt_loc;
  impl_off_loc=impl_off=CK_ALIGN(impl_off,sizeof(Location));
  impl_off+=(impl_cnt_loc=sizeof(Location)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_loc;
    implP|impl_cnt_loc;
    implP|n;
    implP|fromlevel;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_loc;
    implP|impl_cnt_loc;
    implP|n;
    implP|fromlevel;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_loc,loc,impl_cnt_loc);
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_PropagateInfo_marshall14, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6);
 */
    void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_2;
    implP|impl_noname_3;
    implP|impl_noname_4;
    implP|impl_noname_5;
    implP|impl_noname_6;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_2;
    implP|impl_noname_3;
    implP|impl_noname_4;
    implP|impl_noname_5;
    implP|impl_noname_6;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_reportLBQulity_marshall15, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_reportLBQulity_marshall15, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_reportLBQulity_marshall15, impl_msg, ckGetGroupID(),0);
    }
    void reportLBQulity(double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: double impl_noname_2, double impl_noname_3, double impl_noname_4, int impl_noname_5, double impl_noname_6
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_2;
    implP|impl_noname_3;
    implP|impl_noname_4;
    implP|impl_noname_5;
    implP|impl_noname_6;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_2;
    implP|impl_noname_3;
    implP|impl_noname_4;
    implP|impl_noname_5;
    implP|impl_noname_6;
  }
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_reportLBQulity_marshall15, impl_msg, npes, pes, ckGetGroupID(),0);
    }

/* DECLS: void reportLBMem(double impl_noname_7);
 */
    void reportLBMem(double impl_noname_7, const CkEntryOptions *impl_e_opts=NULL)
    {
    ckCheck();
  //Marshall: double impl_noname_7
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_7;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_7;
  }
      if (ckIsDelegated()) {
         CkGroupMsgPrep(CkIndex_HybridBaseLB::__idx_reportLBMem_marshall16, impl_msg, ckGetGroupID());
         ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_HybridBaseLB::__idx_reportLBMem_marshall16, impl_msg, ckGetGroupID());
      } else CkBroadcastMsgBranch(CkIndex_HybridBaseLB::__idx_reportLBMem_marshall16, impl_msg, ckGetGroupID(),0);
    }
    void reportLBMem(double impl_noname_7, int npes, int *pes, const CkEntryOptions *impl_e_opts=NULL)
    {
  //Marshall: double impl_noname_7
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_7;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_7;
  }
      CkSendMsgBranchMulti(CkIndex_HybridBaseLB::__idx_reportLBMem_marshall16, impl_msg, npes, pes, ckGetGroupID(),0);
    }
};
PUPmarshall(CProxy_HybridBaseLB);
typedef CBaseT<BaseLB,CProxy_HybridBaseLB>  CBase_HybridBaseLB;

extern void _registerHybridBaseLB(void);
#endif
