/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import projections.gui.Analysis;

public class Util {
    public static void gblAdd(Container container, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        container.add(component, gridBagConstraints);
    }

    public static void gblAdd(Container container, Component component, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        Insets insets = gridBagConstraints.insets;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
        gridBagConstraints.insets = new Insets(n7, n8, n9, n10);
        container.add(component, gridBagConstraints);
        gridBagConstraints.insets = insets;
    }

    public static int getBestIncrement(int n) {
        int[] nArray = new int[]{1, 2, 5, 25};
        int n2 = -1;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = 0;
            int n4 = 0;
            while ((n4 = (int)((double)nArray[i] * Math.pow(10.0, n3))) < n) {
                ++n3;
            }
            if (n4 - n >= n2 - n && n2 >= 0) continue;
            n2 = n4;
        }
        return n2;
    }

    public static Menu makeMenu(Object object, Object[] objectArray, Object object2) {
        Menu menu = null;
        if (object instanceof Menu) {
            menu = (Menu)object;
        } else if (object instanceof String) {
            menu = new Menu((String)object);
        } else {
            return null;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            MenuItem menuItem;
            if (objectArray[i] instanceof String) {
                menuItem = new MenuItem((String)objectArray[i]);
                if (object2 instanceof ActionListener) {
                    menuItem.addActionListener((ActionListener)object2);
                }
                menu.add(menuItem);
                continue;
            }
            if (objectArray[i] instanceof CheckboxMenuItem && object2 instanceof ItemListener) {
                menuItem = (CheckboxMenuItem)objectArray[i];
                ((CheckboxMenuItem)menuItem).addItemListener((ItemListener)object2);
                menu.add(menuItem);
                continue;
            }
            if (objectArray[i] instanceof MenuItem) {
                menuItem = (MenuItem)objectArray[i];
                if (object2 instanceof ActionListener) {
                    menuItem.addActionListener((ActionListener)object2);
                }
                menu.add(menuItem);
                continue;
            }
            if (objectArray[i] != null) continue;
            menu.addSeparator();
        }
        return menu;
    }

    public static JMenu makeJMenu(Object object, Object[] objectArray, boolean[] blArray, Object object2) {
        JMenu jMenu = null;
        if (object instanceof JMenu) {
            jMenu = (JMenu)object;
        } else if (object instanceof String) {
            jMenu = new JMenu((String)object);
        } else {
            return null;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            String[] stringArray;
            if (objectArray[i] instanceof String) {
                stringArray = new JMenuItem((String)objectArray[i]);
                if (object2 instanceof ActionListener) {
                    stringArray.addActionListener((ActionListener)object2);
                }
                jMenu.add((JMenuItem)stringArray);
                continue;
            }
            if (objectArray[i] instanceof JCheckBoxMenuItem && object2 instanceof ItemListener) {
                stringArray = (JCheckBoxMenuItem)objectArray[i];
                stringArray.addItemListener((ItemListener)object2);
                jMenu.add((JMenuItem)stringArray);
                continue;
            }
            if (objectArray[i] instanceof JRadioButtonMenuItem) {
                stringArray = (JRadioButtonMenuItem)objectArray[i];
                stringArray.addActionListener((ActionListener)object2);
                jMenu.add((JMenuItem)stringArray);
                continue;
            }
            if (objectArray[i] instanceof JMenuItem) {
                stringArray = (JMenuItem)objectArray[i];
                if (object2 instanceof ActionListener) {
                    stringArray.addActionListener((ActionListener)object2);
                }
                jMenu.add((JMenuItem)stringArray);
                continue;
            }
            if (objectArray[i] instanceof String[]) {
                stringArray = (String[])objectArray[i];
                JMenu jMenu2 = new JMenu(stringArray[0]);
                jMenu.add(jMenu2);
                for (int j = 1; j < stringArray.length; ++j) {
                    JMenuItem jMenuItem = new JMenuItem(stringArray[j]);
                    if (object2 instanceof ActionListener) {
                        jMenuItem.addActionListener((ActionListener)object2);
                    }
                    jMenu2.add(jMenuItem);
                }
                continue;
            }
            if (objectArray[i] != null) continue;
            jMenu.addSeparator();
        }
        return jMenu;
    }

    public static void waitForImage(Component component, Image image) {
        MediaTracker mediaTracker = new MediaTracker(component);
        try {
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static void wallPaper(Component component, Graphics graphics, Image image) {
        Dimension dimension = component.getSize();
        Util.waitForImage(component, image);
        int n = image.getWidth(component);
        int n2 = image.getHeight(component);
        for (int i = 0; i < dimension.width; i += n) {
            for (int j = 0; j < dimension.height; j += n2) {
                graphics.drawImage(image, i, j, component);
            }
        }
    }

    public static boolean[] applyMap(boolean[] blArray, int[] nArray) {
        if (nArray == null) {
            return blArray;
        }
        boolean[] blArray2 = new boolean[blArray.length];
        for (int i = 0; i < blArray2.length; ++i) {
            blArray2[i] = blArray[nArray[i]];
        }
        return blArray2;
    }

    public static Color[] applyMap(Color[] colorArray, int[] nArray) {
        if (nArray == null) {
            return colorArray;
        }
        Color[] colorArray2 = new Color[colorArray.length];
        for (int i = 0; i < colorArray2.length; ++i) {
            colorArray2[i] = colorArray[nArray[i]];
        }
        return colorArray2;
    }

    public static String[] applyMap(String[] stringArray, int[] nArray) {
        if (nArray == null) {
            return stringArray;
        }
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[nArray[i]];
        }
        return stringArray2;
    }

    public static double[][] applyMap(double[][] dArray, int[] nArray) {
        if (nArray == null) {
            return dArray;
        }
        double[][] dArrayArray = new double[dArray.length][];
        for (int i = 0; i < dArrayArray.length; ++i) {
            dArrayArray[i] = new double[dArray[i].length];
            for (int j = 0; j < dArrayArray[i].length; ++j) {
                dArrayArray[i][j] = dArray[i][nArray[j]];
            }
        }
        return dArrayArray;
    }

    public static boolean[] orFilters(boolean[] blArray, boolean[] blArray2) {
        boolean[] blArray3 = new boolean[blArray.length];
        for (int i = 0; i < blArray3.length; ++i) {
            blArray3[i] = blArray[i] || blArray2[i];
        }
        return blArray3;
    }

    public static boolean[] andFilters(boolean[] blArray, boolean[] blArray2) {
        boolean[] blArray3 = new boolean[blArray.length];
        for (int i = 0; i < blArray3.length; ++i) {
            blArray3[i] = blArray[i] && blArray2[i];
        }
        return blArray3;
    }

    public static void saveColors(Color[] colorArray, String string, String string2) throws IOException {
        File file = new File("bin/color.map");
        int n = string2 == null ? 0 : 1;
        do {
            boolean bl = file.exists();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            String string3 = new String();
            int n2 = 1;
            String[] stringArray = new String[n2];
            stringArray[0] = "Timeline Graph";
            if (!bl) {
                for (int i = 0; i < n2; ++i) {
                    randomAccessFile.writeBytes(stringArray[i] + "\n");
                    for (int j = 0; j < colorArray.length; ++j) {
                        randomAccessFile.writeBytes(j + " ");
                        randomAccessFile.writeBytes(String.valueOf(Analysis.getEntryColor(j).getRed()));
                        randomAccessFile.writeBytes(" ");
                        randomAccessFile.writeBytes(String.valueOf(Analysis.getEntryColor(j).getGreen()));
                        randomAccessFile.writeBytes(" ");
                        randomAccessFile.writeBytes(String.valueOf(Analysis.getEntryColor(j).getBlue()));
                        randomAccessFile.writeBytes(";     ");
                    }
                    randomAccessFile.writeBytes("                    ");
                    randomAccessFile.writeBytes("\n");
                    randomAccessFile.writeBytes("\n");
                }
            }
            long l = 0L;
            randomAccessFile.seek(l);
            for (int i = 0; i < n2; ++i) {
                int n3;
                if (string.compareTo(stringArray[i]) != 0) continue;
                int n4 = 3 * i + 1;
                for (n3 = 0; n3 < n4; ++n3) {
                    string3 = randomAccessFile.readLine();
                }
                for (n3 = 0; n3 < colorArray.length; ++n3) {
                    randomAccessFile.writeBytes(n3 + " ");
                    randomAccessFile.writeBytes(String.valueOf(colorArray[n3].getRed()));
                    randomAccessFile.writeBytes(" ");
                    randomAccessFile.writeBytes(String.valueOf(colorArray[n3].getGreen()));
                    randomAccessFile.writeBytes(" ");
                    randomAccessFile.writeBytes(String.valueOf(colorArray[n3].getBlue()));
                    randomAccessFile.writeBytes(";     ");
                }
            }
            if (string2 != null) {
                file = new File(string2);
            }
            randomAccessFile.close();
        } while (--n >= 0);
    }

    public static void saveColors(Color[] colorArray, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(Analysis.getLogDirectory() + File.separator + "color.map");
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        for (int i = 0; i < colorArray.length; ++i) {
            objectOutputStream.writeObject(colorArray[i]);
        }
        objectOutputStream.close();
    }

    public static void restoreColors(Color[] colorArray, String string) throws IOException, ClassNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(Analysis.getLogDirectory() + File.separator + "color.map");
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        for (int i = 0; i < colorArray.length; ++i) {
            colorArray[i] = (Color)objectInputStream.readObject();
        }
        objectInputStream.close();
    }

    public static void restoreColors(Color[] colorArray, String string, String string2) throws IOException {
        File file = string2 == null ? new File("bin/color.map") : new File(string2);
        boolean bl = file.exists();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        String string3 = new String();
        Integer n = new Integer(0);
        if (bl) {
            string3 = randomAccessFile.readLine();
            while (string3.compareTo("null") != 0) {
                if (string3.compareTo(string) == 0) {
                    StringTokenizer stringTokenizer = new StringTokenizer(randomAccessFile.readLine(), " ;");
                    for (int i = 0; i < colorArray.length; ++i) {
                        string3 = stringTokenizer.nextToken();
                        colorArray[i] = new Color(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken()));
                    }
                    string3 = "null";
                    continue;
                }
                string3 = randomAccessFile.readLine();
            }
        } else {
            for (int i = 0; i < colorArray.length; ++i) {
                colorArray[i] = Analysis.getEntryColor(i);
            }
        }
        Util.saveColors(colorArray, string, null);
        randomAccessFile.close();
    }
}

