/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import projections.analysis.UserEvent;
import projections.gui.FormattedNumber;
import projections.gui.TimelineData;
import projections.gui.count.TableSorter;

public class UserEventWindow
extends JFrame {
    private Color BACKGROUND = Color.black;
    private Color FOREGROUND = Color.white;
    private static DecimalFormat format_ = null;
    private Checkbox checkbox_;
    private UserEvent[][] events_ = null;
    private JTabbedPane tabbedPane_ = new JTabbedPane();
    private TableSorter[] sorter_ = null;
    private DefaultTableCellRenderer rightJustify_ = new DefaultTableCellRenderer();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$projections$gui$FormattedNumber;

    public void setData(TimelineData timelineData) {
        this.events_ = timelineData.userEventsArray;
        timelineData.processorList.reset();
        super.getContentPane().removeAll();
        this.tabbedPane_.removeAll();
        if (this.events_.length > 1) {
            super.getContentPane().add(this.tabbedPane_);
        }
        this.sorter_ = new TableSorter[this.events_.length];
        for (int i = 0; i < this.events_.length; ++i) {
            UserEventTable userEventTable = new UserEventTable(i);
            this.sorter_[i] = new TableSorter(userEventTable);
            JTable jTable = new JTable(this.sorter_[i]);
            this.sorter_[i].addMouseListenerToHeaderInTable(jTable);
            jTable.setBackground(this.BACKGROUND);
            jTable.setForeground(this.FOREGROUND);
            TableColumn tableColumn = null;
            tableColumn = jTable.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(150);
            tableColumn.setCellRenderer(new NameRenderer(i));
            for (int j = 1; j < userEventTable.getColumnCount(); ++j) {
                tableColumn = jTable.getColumnModel().getColumn(j);
                tableColumn.setPreferredWidth(75);
                tableColumn.setCellRenderer(this.rightJustify_);
            }
            if (this.events_.length == 1) {
                super.getContentPane().add(new JScrollPane(jTable));
                continue;
            }
            this.tabbedPane_.addTab(new Integer(timelineData.processorList.nextElement()).toString(), new JScrollPane(jTable));
        }
        super.getContentPane().invalidate();
        super.getContentPane().doLayout();
    }

    public UserEventWindow(Checkbox checkbox) {
        super("User Event Window");
        if (format_ == null) {
            format_ = new DecimalFormat();
            format_.setGroupingUsed(true);
        }
        this.rightJustify_.setHorizontalAlignment(4);
        this.checkbox_ = checkbox;
        super.setSize(480, 400);
        this.tabbedPane_ = new JTabbedPane();
        super.setDefaultCloseOperation(0);
        super.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                UserEventWindow.this.setVisible(false);
                UserEventWindow.this.checkbox_.setState(false);
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class UserEventTable
    extends AbstractTableModel {
        private int index_ = -1;

        public UserEventTable(int n) {
            this.index_ = n;
        }

        public int getColumnCount() {
            return 4;
        }

        public int getRowCount() {
            if (UserEventWindow.this.events_ != null && UserEventWindow.this.events_[this.index_] != null) {
                return UserEventWindow.this.events_[this.index_].length;
            }
            return 0;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "User Event";
                }
                case 1: {
                    return "Begin Time";
                }
                case 2: {
                    return "End Time";
                }
                case 3: {
                    return "Delta Time";
                }
            }
            return "ERROR";
        }

        public Object getValueAt(int n, int n2) {
            if (UserEventWindow.this.events_ != null && UserEventWindow.this.events_[0] != null) {
                switch (n2) {
                    case 0: {
                        return ((UserEventWindow)UserEventWindow.this).events_[this.index_][n].Name;
                    }
                    case 1: {
                        return new FormattedNumber((int)((UserEventWindow)UserEventWindow.this).events_[this.index_][n].BeginTime, format_);
                    }
                    case 2: {
                        return new FormattedNumber((int)((UserEventWindow)UserEventWindow.this).events_[this.index_][n].EndTime, format_);
                    }
                    case 3: {
                        return new FormattedNumber((int)((UserEventWindow)UserEventWindow.this).events_[this.index_][n].EndTime - (int)((UserEventWindow)UserEventWindow.this).events_[this.index_][n].BeginTime, format_);
                    }
                }
                return "ERROR";
            }
            return "ERROR";
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return class$java$lang$String == null ? (class$java$lang$String = UserEventWindow.class$("java.lang.String")) : class$java$lang$String;
            }
            return class$projections$gui$FormattedNumber == null ? (class$projections$gui$FormattedNumber = UserEventWindow.class$("projections.gui.FormattedNumber")) : class$projections$gui$FormattedNumber;
        }
    }

    private class NameRenderer
    extends DefaultTableCellRenderer {
        private int index_;

        public NameRenderer(int n) {
            this.index_ = n;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setHorizontalAlignment(0);
            this.setEnabled(jTable == null || jTable.isEnabled());
            this.setForeground(((UserEventWindow)UserEventWindow.this).events_[this.index_][((UserEventWindow)UserEventWindow.this).sorter_[this.index_].mapRow((int)n)].color);
            this.setBackground(UserEventWindow.this.BACKGROUND);
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }
    }
}

