/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import projections.gui.Analysis;
import projections.gui.ColorFileFilter;
import projections.gui.CommWindow;
import projections.gui.FloatTextField;
import projections.gui.GraphWindow;
import projections.gui.HistogramWindow;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.OrderedUsageList;
import projections.gui.ProfileWindow;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.StlWindow;
import projections.gui.SwingWorker;
import projections.gui.TimelineAxisCanvas;
import projections.gui.TimelineColorWindow;
import projections.gui.TimelineData;
import projections.gui.TimelineDisplayCanvas;
import projections.gui.TimelineLabelCanvas;
import projections.gui.TimelineMessageWindow;
import projections.gui.UserEventWindow;
import projections.gui.Util;

public class TimelineWindow
extends ProjectionsWindow
implements ActionListener,
AdjustmentListener,
ItemListener {
    private NoUpdatePanel mainPanel;
    private NoUpdatePanel displayPanel;
    private TimelineLabelCanvas labelCanvas;
    private TimelineAxisCanvas axisTopCanvas;
    private TimelineAxisCanvas axisBotCanvas;
    public TimelineDisplayCanvas displayCanvas;
    private TimelineColorWindow colorWindow;
    private TimelineWindow thisWindow = this;
    private Scrollbar HSB;
    private Scrollbar VSB;
    private TimelineData data;
    private FontMetrics fm;
    private Button bSelectRange;
    private Button bColors;
    private Button bDecrease;
    private Button bIncrease;
    private Button bReset;
    private Button bZoomSelected;
    private Button bLoadSelected;
    private Button bJumpProfile;
    private Button bJumpGraph;
    private Button bJumpHistogram;
    private Button bJumpComm;
    private Button bJumpStl;
    private TextField highlightTime;
    private TextField selectionBeginTime;
    private TextField selectionEndTime;
    private TextField selectionDiff;
    private DecimalFormat format = new DecimalFormat();
    private FloatTextField scaleField;
    private Checkbox cbPacks;
    private Checkbox cbMsgs;
    private Checkbox cbIdle;
    private Checkbox cbUser;
    private int maxLabelLen;
    private long oldEndTime;
    private TimelineMessageWindow messageWindow;
    private UserEventWindow userEventWindow;
    public OrderedIntList validPEs;
    public long startTime;
    public long endTime;
    private AxisMouseController mouseController;

    public void refreshDisplay() {
        this.labelCanvas.makeNewImage();
        this.labelCanvas.repaint();
        this.axisTopCanvas.makeNewImage();
        this.axisTopCanvas.repaint();
        this.axisBotCanvas.makeNewImage();
        this.axisBotCanvas.repaint();
        this.displayCanvas.makeNewImage();
        this.displayCanvas.repaint();
        this.displayPanel.setBackground(Analysis.background);
        this.displayPanel.repaint();
    }

    void windowInit() {
        this.validPEs = Analysis.getValidProcessorList();
        this.startTime = 0L;
        this.endTime = Analysis.getTotalTime();
    }

    public TimelineWindow(MainWindow mainWindow, Integer n) {
        super(mainWindow, n);
        this.format.setGroupingUsed(true);
        this.format.setMinimumFractionDigits(0);
        this.format.setMaximumFractionDigits(0);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (TimelineWindow.this.displayCanvas != null && TimelineWindow.this.axisTopCanvas != null && TimelineWindow.this.axisBotCanvas != null) {
                    TimelineWindow.this.setCursor(new Cursor(3));
                    TimelineWindow.this.setAllSizes(false);
                    TimelineWindow.this.displayCanvas.makeNewImage();
                    TimelineWindow.this.axisTopCanvas.makeNewImage();
                    TimelineWindow.this.axisBotCanvas.makeNewImage();
                    TimelineWindow.this.setCursor(new Cursor(0));
                }
            }
        });
        this.setBackground(Color.lightGray);
        this.data = new TimelineData(this);
        this.setTitle("Projections Timelines - " + Analysis.getFilename() + ".sts");
        this.CreateMenus();
        this.CreateLayout();
        this.showDialog();
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = new RangeDialog(this, "Select Timeline Range");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            if (this.dialog.isModified()) {
                SwingWorker swingWorker = new SwingWorker(){

                    public Object construct() {
                        ((TimelineWindow)TimelineWindow.this).data.beginTime = TimelineWindow.this.startTime;
                        ((TimelineWindow)TimelineWindow.this).data.endTime = TimelineWindow.this.endTime;
                        ((TimelineWindow)TimelineWindow.this).data.processorList = TimelineWindow.this.validPEs;
                        ((TimelineWindow)TimelineWindow.this).data.numPs = TimelineWindow.this.validPEs.size();
                        TimelineWindow.this.procRangeDialog(true);
                        return null;
                    }

                    public void finished() {
                        TimelineWindow.this.thisWindow.pack();
                        TimelineWindow.this.thisWindow.setVisible(true);
                    }
                };
                swingWorker.start();
            } else {
                this.setVisible(true);
            }
        }
    }

    public void showWindow() {
    }

    public void getDialogData() {
        this.validPEs = this.dialog.getValidProcessors();
        this.startTime = this.dialog.getStartTime();
        this.endTime = this.dialog.getEndTime();
    }

    public void setDialogData() {
        this.dialog.setValidProcessors(this.validPEs);
        this.dialog.setStartTime(this.startTime);
        this.dialog.setEndTime(this.endTime);
        super.setDialogData();
    }

    private double calcLeftTime(double d, double d2, double d3, double d4) {
        double d5 = (d2 - d) * d3 / d4;
        double d6 = Math.abs(d2 - d - d5);
        if (d3 > d4) {
            return d - d6 / 2.0;
        }
        return d + d6 / 2.0;
    }

    public void setHighlightTime(double d) {
        this.highlightTime.setText(this.format.format(d));
    }

    public void unsetHighlightTime() {
        this.highlightTime.setText("");
    }

    public void setSelectedTime(double d, double d2) {
        this.selectionBeginTime.setText(this.format.format(d));
        this.selectionEndTime.setText(this.format.format(d2));
        this.format.setMinimumFractionDigits(3);
        this.format.setMaximumFractionDigits(3);
        this.selectionDiff.setText(this.format.format((d2 - d) / 1000.0) + " ms");
        this.format.setMinimumFractionDigits(0);
        this.format.setMaximumFractionDigits(0);
    }

    public void unsetSelectedTime() {
        this.selectionBeginTime.setText("");
        this.selectionEndTime.setText("");
        this.selectionDiff.setText("");
    }

    public void setZoom(double d, double d2) {
        this.data.scale = (float)((double)(this.data.endTime - this.data.beginTime) / (d2 - d));
        this.scaleField.setText("" + this.data.scale);
        this.setCursor(new Cursor(3));
        this.setAllSizes(true);
        this.displayCanvas.makeNewImage();
        this.axisTopCanvas.makeNewImage();
        this.axisBotCanvas.makeNewImage();
        if ((double)this.data.scale != 1.0) {
            this.HSB.setValue(this.axisBotCanvas.calcHSBOffset(d));
            this.displayCanvas.setLocation(-this.HSB.getValue(), -this.VSB.getValue());
        }
        this.setCursor(new Cursor(0));
    }

    public void zoomSelected() {
        if (this.mouseController.selected_) {
            Rectangle rectangle = this.displayCanvas.rubberBand.bounds();
            this.mouseController.selected_ = false;
            this.unsetSelectedTime();
            if (rectangle.width == 0) {
                return;
            }
            double d = this.axisBotCanvas.canvasToTime(rectangle.x);
            double d2 = this.axisBotCanvas.canvasToTime(rectangle.x + rectangle.width);
            this.setZoom(d, d2);
        }
    }

    public void loadSelected() {
        if (this.mouseController.selected_) {
            Rectangle rectangle = this.displayCanvas.rubberBand.bounds();
            this.mouseController.selected_ = false;
            this.unsetSelectedTime();
            if (rectangle.width == 0) {
                return;
            }
            this.startTime = (long)this.axisBotCanvas.canvasToTime(rectangle.x);
            this.endTime = (long)this.axisBotCanvas.canvasToTime(rectangle.x + rectangle.width);
            if (this.startTime < this.data.beginTime) {
                this.startTime = this.data.beginTime;
            }
            if (this.endTime > this.data.endTime) {
                this.endTime = this.data.endTime;
            }
            this.data.oldBT = this.data.beginTime;
            this.data.oldET = this.data.endTime;
            this.data.beginTime = (long)((double)this.startTime + 0.5);
            this.data.endTime = (long)((double)this.endTime + 0.5);
            this.data.scale = 1.0f;
            this.scaleField.setText("1.0");
            this.data.oldplist = this.data.processorList == null ? null : this.data.processorList.copyOf();
            this.procRangeDialog(true);
        }
    }

    public void jumpToGraph(String string) {
        Rectangle rectangle = this.displayCanvas.rubberBand.bounds();
        double d = this.axisBotCanvas.canvasToTime(rectangle.x);
        double d2 = this.axisBotCanvas.canvasToTime(rectangle.x + rectangle.width);
        Analysis.setJTimeAvailable(true);
        if (rectangle.width == 0) {
            Analysis.setJTime(0L, Analysis.getTotalTime());
        } else {
            Analysis.setJTime((long)(d + 0.5), (long)(d2 + 0.5));
        }
        if (string == "Profile") {
            ProfileWindow profileWindow = new ProfileWindow(this.parentWindow, new Integer(0));
        } else if (string == "Graph") {
            GraphWindow graphWindow = new GraphWindow(this.parentWindow, new Integer(0));
        } else if (string == "Histogram") {
            HistogramWindow histogramWindow = new HistogramWindow(this.parentWindow, new Integer(0));
        } else if (string == "Comm") {
            CommWindow commWindow = new CommWindow(this.parentWindow, new Integer(0));
        } else if (string == "Stl") {
            StlWindow stlWindow = new StlWindow(this.parentWindow, new Integer(0));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bSelectRange) {
                this.showDialog();
            } else if (button == this.bColors) {
                this.ShowColorWindow();
            } else if (button == this.bZoomSelected) {
                this.zoomSelected();
            } else if (button == this.bLoadSelected) {
                this.loadSelected();
            } else if (button == this.bJumpProfile) {
                this.jumpToGraph("Profile");
            } else if (button == this.bJumpGraph) {
                this.jumpToGraph("Graph");
            } else if (button == this.bJumpHistogram) {
                this.jumpToGraph("Histogram");
            } else if (button == this.bJumpComm) {
                this.jumpToGraph("Comm");
            } else if (button == this.bJumpStl) {
                this.jumpToGraph("Stl");
            } else {
                int n = this.HSB.getValue();
                int n2 = n + this.data.vpw;
                double d = this.axisBotCanvas.canvasToTime(n);
                double d2 = this.axisBotCanvas.canvasToTime(n2);
                double d3 = this.data.scale;
                if (button == this.bDecrease) {
                    this.data.scale = (float)((int)(this.data.scale * 4.0f) - 1) / 4.0f;
                    if ((double)this.data.scale < 1.0) {
                        this.data.scale = 1.0f;
                    }
                } else if (button == this.bIncrease) {
                    this.data.scale = (float)((int)(this.data.scale * 4.0f) + 1) / 4.0f;
                } else if (button == this.bReset) {
                    this.data.scale = 1.0f;
                }
                this.scaleField.setText("" + this.data.scale);
                double d4 = this.calcLeftTime(d, d2, d3, this.data.scale);
                this.setCursor(new Cursor(3));
                this.setAllSizes(false);
                this.displayCanvas.makeNewImage();
                this.axisTopCanvas.makeNewImage();
                this.axisBotCanvas.makeNewImage();
                if ((double)this.data.scale != 1.0) {
                    this.HSB.setValue(this.axisBotCanvas.calcHSBOffset(d4));
                    this.displayCanvas.setLocation(-this.HSB.getValue(), -this.VSB.getValue());
                }
                this.setCursor(new Cursor(0));
            }
        } else if (actionEvent.getSource() instanceof MenuItem) {
            String string = ((MenuItem)actionEvent.getSource()).getLabel();
            if (string.equals("Close")) {
                this.close();
            } else if (string.equals("Modify Ranges")) {
                this.showDialog();
            } else if (string.equals("Print Timeline")) {
                this.PrintTimeline();
            } else if (string.equals("Change Entry Point Colors")) {
                this.ShowColorWindow();
            } else if (string.equals("Save Entry Point Colors")) {
                try {
                    Util.saveColors(this.data.entryColor, "Timeline Graph");
                }
                catch (IOException iOException) {
                    System.err.println("Attempt to write to color.map failed");
                }
            } else if (string.equals("Restore Entry Point Colors")) {
                try {
                    Util.restoreColors(this.data.entryColor, "Timeline Graph");
                }
                catch (Exception exception) {
                    System.err.println("Attempt to read from color.map failed");
                }
                this.data.displayCanvas.updateColors();
            } else if (string.equals("Default Entry Point Colors")) {
                for (int i = 0; i < this.data.entryColor.length; ++i) {
                    this.data.entryColor[i] = Analysis.getEntryColor(i);
                }
                this.data.displayCanvas.updateColors();
            }
        } else {
            int n = this.HSB.getValue();
            int n3 = n + this.data.vpw;
            double d = this.axisBotCanvas.canvasToTime(n);
            double d5 = this.axisBotCanvas.canvasToTime(n3);
            double d6 = this.data.scale;
            this.data.scale = this.scaleField.getValue();
            if ((double)this.data.scale < 1.0) {
                this.data.scale = 1.0f;
            }
            double d7 = this.calcLeftTime(d, d5, d6, this.data.scale);
            this.setCursor(new Cursor(3));
            this.setAllSizes(true);
            this.displayCanvas.makeNewImage();
            this.axisTopCanvas.makeNewImage();
            this.axisBotCanvas.makeNewImage();
            if ((double)this.data.scale != 1.0) {
                this.HSB.setValue(this.axisBotCanvas.calcHSBOffset(d7));
                this.displayCanvas.setLocation(-this.HSB.getValue(), -this.VSB.getValue());
            }
            this.setCursor(new Cursor(0));
        }
    }

    public void openColorFile() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setFileFilter(new ColorFileFilter());
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            try {
                Util.restoreColors(this.data.entryColor, "Timeline Graph", jFileChooser.getSelectedFile().getAbsolutePath());
            }
            catch (IOException iOException) {
                System.err.println("Attempt to read from color.map failed");
            }
        }
    }

    public void saveColorFile() {
        JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
        jFileChooser.setFileFilter(new ColorFileFilter());
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            try {
                Util.saveColors(this.data.entryColor, "Timeline Graph", jFileChooser.getSelectedFile().getAbsolutePath());
            }
            catch (IOException iOException) {
                System.err.println("Attempt to write to color.map failed");
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Scrollbar scrollbar = (Scrollbar)adjustmentEvent.getSource();
        this.displayCanvas.setLocation(-this.HSB.getValue(), -this.VSB.getValue());
        if (scrollbar == this.HSB) {
            this.axisTopCanvas.repaint();
            this.axisBotCanvas.repaint();
        } else if (scrollbar == this.VSB) {
            this.labelCanvas.repaint();
        }
    }

    public void close() {
        if (this.colorWindow != null) {
            this.colorWindow.dispose();
            this.colorWindow = null;
        }
        this.setVisible(false);
        this.dispose();
        this.parentWindow.closeChildWindow(this.myWindowID);
    }

    public void CloseColorWindow() {
        this.colorWindow = null;
    }

    public void procRangeDialog(boolean bl) {
        int n;
        int n2;
        this.setCursor(new Cursor(3));
        this.data.tlh = this.data.tluh * this.data.numPs;
        this.VSB.setMaximum(this.data.tlh);
        this.displayCanvas.removeAll();
        this.data.createTLOArray();
        for (n2 = 0; n2 < this.data.numPs; ++n2) {
            for (n = 0; n < this.data.tloArray[n2].length; ++n) {
                this.displayCanvas.add(this.data.tloArray[n2][n]);
            }
        }
        if (this.data.userEventsArray != null) {
            for (n2 = 0; n2 < this.data.numPs; ++n2) {
                if (this.data.userEventsArray[n2] == null) continue;
                for (n = 0; n < this.data.userEventsArray[n2].length; ++n) {
                    this.displayCanvas.add(this.data.userEventsArray[n2][n]);
                }
            }
        }
        this.setAllSizes(bl);
        this.labelCanvas.makeNewImage();
        this.axisTopCanvas.makeNewImage();
        this.axisBotCanvas.makeNewImage();
        this.displayCanvas.makeNewImage();
        this.cbUser.setLabel("View User Events (" + this.data.getNumUserEvents() + ")");
        if (this.userEventWindow == null) {
            this.userEventWindow = new UserEventWindow(this.cbUser);
        }
        this.userEventWindow.setData(this.data);
        this.setCursor(new Cursor(0));
    }

    private void CreateLayout() {
        this.mainPanel = new NoUpdatePanel();
        this.displayPanel = new NoUpdatePanel();
        this.labelCanvas = new TimelineLabelCanvas(this.data);
        this.axisTopCanvas = new TimelineAxisCanvas(this.data, "top");
        this.axisBotCanvas = new TimelineAxisCanvas(this.data, "bot");
        this.data.displayCanvas = this.displayCanvas = new TimelineDisplayCanvas(this.data);
        this.mouseController = new AxisMouseController(this, this.displayCanvas, this.axisBotCanvas);
        this.axisTopCanvas.addMouseListener(this.mouseController.mouseListener);
        this.axisTopCanvas.addMouseMotionListener(this.mouseController.mouseMotionAdapter);
        this.axisBotCanvas.addMouseListener(this.mouseController.mouseListener);
        this.axisBotCanvas.addMouseMotionListener(this.mouseController.mouseMotionAdapter);
        this.HSB = new Scrollbar(0, 0, 1, 0, 1);
        this.VSB = new Scrollbar(1, 0, 1, 0, 1);
        this.mainPanel.setLayout(null);
        this.mainPanel.setBackground(Analysis.background);
        this.mainPanel.add(this.labelCanvas);
        this.mainPanel.add(this.axisTopCanvas);
        this.mainPanel.add(this.axisBotCanvas);
        this.mainPanel.add(this.displayPanel);
        this.mainPanel.add(this.HSB);
        this.mainPanel.add(this.VSB);
        this.displayPanel.setLayout(null);
        this.displayPanel.add(this.displayCanvas);
        this.HSB.setBackground(Color.lightGray);
        this.HSB.addAdjustmentListener(this);
        this.VSB.setBackground(Color.lightGray);
        this.VSB.addAdjustmentListener(this);
        this.cbPacks = new Checkbox("Display Pack Times", this.data.showPacks);
        this.cbMsgs = new Checkbox("Display Message Sends", this.data.showMsgs);
        this.cbIdle = new Checkbox("Display Idle Time", this.data.showIdle);
        this.cbUser = new Checkbox("Display User Event Window", false);
        this.cbPacks.addItemListener(this);
        this.cbMsgs.addItemListener(this);
        this.cbIdle.addItemListener(this);
        this.cbUser.addItemListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        Panel panel = new Panel();
        panel.setLayout(gridBagLayout);
        Util.gblAdd(panel, this.cbPacks, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.cbMsgs, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.cbIdle, gridBagConstraints, 2, 0, 1, 1, 1, 1);
        Util.gblAdd(panel, this.cbUser, gridBagConstraints, 3, 0, 1, 1, 1, 1);
        this.bSelectRange = new Button("Select Ranges");
        this.bColors = new Button("Change Entry Point Colors");
        this.bDecrease = new Button("<<");
        this.bIncrease = new Button(">>");
        this.bReset = new Button("Reset");
        this.bSelectRange.addActionListener(this);
        this.bColors.addActionListener(this);
        this.bDecrease.addActionListener(this);
        this.bIncrease.addActionListener(this);
        this.bReset.addActionListener(this);
        Label label = new Label("SCALE: ", 1);
        this.scaleField = new FloatTextField(this.data.scale, 5);
        this.scaleField.addActionListener(this);
        Panel panel2 = new Panel();
        panel2.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        Util.gblAdd(panel2, this.bSelectRange, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.bColors, gridBagConstraints, 1, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.bDecrease, gridBagConstraints, 3, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, label, gridBagConstraints, 4, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.scaleField, gridBagConstraints, 5, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.bIncrease, gridBagConstraints, 6, 0, 1, 1, 1, 1);
        Util.gblAdd(panel2, this.bReset, gridBagConstraints, 7, 0, 1, 1, 1, 1);
        this.bZoomSelected = new Button("Zoom Selected");
        this.bLoadSelected = new Button("Load Selected");
        this.bZoomSelected.addActionListener(this);
        this.bLoadSelected.addActionListener(this);
        this.highlightTime = new TextField("");
        this.selectionBeginTime = new TextField("");
        this.selectionEndTime = new TextField("");
        this.selectionDiff = new TextField("");
        this.highlightTime.setEditable(false);
        this.selectionBeginTime.setEditable(false);
        this.selectionEndTime.setEditable(false);
        this.selectionDiff.setEditable(false);
        Panel panel3 = new Panel();
        panel3.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        Util.gblAdd(panel3, new Label(" "), gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(panel3, this.bZoomSelected, gridBagConstraints, 0, 2, 1, 1, 1, 1);
        Util.gblAdd(panel3, this.bLoadSelected, gridBagConstraints, 1, 2, 1, 1, 1, 1);
        Util.gblAdd(panel3, this.highlightTime, gridBagConstraints, 2, 2, 1, 1, 1, 1);
        Util.gblAdd(panel3, this.selectionBeginTime, gridBagConstraints, 3, 2, 1, 1, 1, 1);
        Util.gblAdd(panel3, this.selectionEndTime, gridBagConstraints, 4, 2, 1, 1, 1, 1);
        Util.gblAdd(panel3, this.selectionDiff, gridBagConstraints, 5, 2, 1, 1, 1, 1);
        Util.gblAdd(panel3, new Label("Highlight Time", 1), gridBagConstraints, 2, 1, 1, 1, 1, 1);
        Util.gblAdd(panel3, new Label("Selection Begin Time", 1), gridBagConstraints, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(panel3, new Label("Selection End Time", 1), gridBagConstraints, 4, 1, 1, 1, 1, 1);
        Util.gblAdd(panel3, new Label("Selection Length", 1), gridBagConstraints, 5, 1, 1, 1, 1, 1);
        this.bJumpProfile = new Button("Usage Profile");
        this.bJumpGraph = new Button("Graph");
        this.bJumpHistogram = new Button("Histogram");
        this.bJumpComm = new Button("Communication");
        this.bJumpStl = new Button("Overview");
        this.bJumpProfile.addActionListener(this);
        this.bJumpGraph.addActionListener(this);
        this.bJumpHistogram.addActionListener(this);
        this.bJumpComm.addActionListener(this);
        this.bJumpStl.addActionListener(this);
        Panel panel4 = new Panel();
        panel4.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        Util.gblAdd(panel4, new Label(" "), gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(panel4, new Label("Jump to graph: ", 0), gridBagConstraints, 1, 1, 1, 1, 1, 1);
        Util.gblAdd(panel4, this.bJumpProfile, gridBagConstraints, 3, 1, 1, 1, 1, 1);
        Util.gblAdd(panel4, this.bJumpGraph, gridBagConstraints, 4, 1, 1, 1, 1, 1);
        Util.gblAdd(panel4, this.bJumpHistogram, gridBagConstraints, 5, 1, 1, 1, 1, 1);
        Util.gblAdd(panel4, this.bJumpComm, gridBagConstraints, 6, 1, 1, 1, 1, 1);
        Util.gblAdd(panel4, this.bJumpStl, gridBagConstraints, 7, 1, 1, 1, 1, 1);
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(gridBagLayout);
        Util.gblAdd(jPanel, this.mainPanel, gridBagConstraints, 0, 0, 1, 1, 1, 1);
        Util.gblAdd(jPanel, panel, gridBagConstraints, 0, 1, 1, 1, 1, 0);
        Util.gblAdd(jPanel, panel2, gridBagConstraints, 0, 2, 1, 1, 1, 0);
        Util.gblAdd(jPanel, panel3, gridBagConstraints, 0, 3, 1, 1, 1, 0);
        Util.gblAdd(jPanel, panel4, gridBagConstraints, 0, 4, 1, 1, 1, 0);
    }

    private void CreateMenus() {
        MenuBar menuBar = new MenuBar();
        menuBar.add(Util.makeMenu("File", new Object[]{"Print Timeline", null, "Close"}, this));
        menuBar.add(Util.makeMenu("Tools", new Object[]{"Modify Ranges"}, this));
        menuBar.add(Util.makeMenu("Colors", new Object[]{"Change Entry Point Colors", "Save Entry Point Colors", "Restore Entry Point Colors", "Default Entry Point Colors"}, this));
        Menu menu = new Menu("Help");
        menuBar.add(Util.makeMenu(menu, new Object[]{"Index", "About"}, this));
        menuBar.setHelpMenu(menu);
        this.setMenuBar(menuBar);
    }

    public long getBeginTime() {
        return this.data.beginTime;
    }

    public long getEndTime() {
        return this.data.endTime;
    }

    public int[] getEntries() {
        return this.data.entries;
    }

    public Color[] getEntryColors() {
        if (this.data == null) {
            return null;
        }
        return this.data.entryColor;
    }

    public OrderedUsageList[] getEntryUsageData() {
        if (this.data == null) {
            return null;
        }
        return this.data.entryUsageList;
    }

    public Color getGraphColor(int n) {
        return this.parentWindow.getGraphColor(n);
    }

    public int getHSBValue() {
        return this.HSB.getValue();
    }

    public float[] getIdleUsageData() {
        if (this.data == null) {
            return null;
        }
        return this.data.idleUsage;
    }

    public float[] getPackUsageData() {
        if (this.data == null) {
            return null;
        }
        return this.data.packUsage;
    }

    public OrderedIntList getProcessorList() {
        if (this.data == null) {
            return null;
        }
        return this.data.processorList;
    }

    public int getVSBValue() {
        return this.VSB.getValue();
    }

    public boolean GraphExists() {
        return this.parentWindow.GraphExists();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.data == null) {
            return;
        }
        Checkbox checkbox = (Checkbox)itemEvent.getSource();
        if (checkbox == this.cbPacks) {
            this.data.showPacks = this.cbPacks.getState();
        } else if (checkbox == this.cbMsgs) {
            this.data.showMsgs = this.cbMsgs.getState();
        } else if (checkbox == this.cbIdle) {
            this.data.showIdle = this.cbIdle.getState();
        } else if (checkbox == this.cbUser) {
            if (this.cbUser.getState()) {
                this.userEventWindow.setVisible(true);
                this.userEventWindow.show();
            } else {
                this.userEventWindow.setVisible(false);
            }
        }
        this.setCursor(new Cursor(3));
        this.displayCanvas.makeNewImage();
        this.setCursor(new Cursor(0));
    }

    private void PrintTimeline() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        PrintJob printJob = this.getToolkit().getPrintJob(this, "Print Timeline", null);
        if (printJob == null) {
            return;
        }
        Dimension dimension = printJob.getPageDimension();
        if (dimension.width < dimension.height) {
            n7 = (int)(0.6 * (double)dimension.width / 8.5);
            n6 = (int)(0.6 * (double)dimension.height / 11.0);
        } else {
            n7 = (int)(0.6 * (double)dimension.width / 11.0);
            n6 = (int)(0.6 * (double)dimension.height / 8.5);
        }
        int n8 = dimension.width - 2 * n7;
        int n9 = dimension.height - 2 * n6;
        int n10 = this.HSB.getValue();
        long l = (long)Math.floor((double)(n10 - this.data.offset) / this.data.pixelIncrement) * (long)this.data.timeIncrement;
        if (l < 0L) {
            l = 0L;
        }
        l += this.data.beginTime;
        long l2 = (long)Math.ceil((double)(n10 + this.data.vpw - this.data.offset) / this.data.pixelIncrement) * (long)this.data.timeIncrement;
        if ((l2 += this.data.beginTime) > this.data.endTime) {
            l2 = this.data.endTime;
        }
        int n11 = this.VSB.getValue();
        int n12 = (int)Math.floor((double)n11 / (double)this.data.tluh);
        int n13 = (int)Math.floor((double)(n11 + this.data.vph) / (double)this.data.tluh);
        if (n12 < 0) {
            n12 = 0;
        }
        if (n13 > this.data.numPs - 1) {
            n13 = this.data.numPs - 1;
        }
        Graphics graphics = printJob.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setFont(new Font("SansSerif", 0, 10));
        graphics.translate(n7, n6);
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n14 = fontMetrics.getHeight();
        int n15 = 2 * n14 + 12;
        int n16 = 20 + n14;
        int n17 = n14 + 5;
        int[] nArray = new int[Analysis.getNumUserEntries()];
        for (n5 = 0; n5 < Analysis.getNumUserEntries(); ++n5) {
            nArray[n5] = 0;
        }
        n5 = 0;
        for (n4 = n12; n4 <= n13; ++n4) {
            for (n3 = this.data.tloArray[n4].length - 1; n3 >= 0; --n3) {
                long l3 = this.data.tloArray[n4][n3].getBeginTime();
                long l4 = this.data.tloArray[n4][n3].getEndTime();
                if (l3 > l2 || l4 < l) continue;
                n2 = this.data.tloArray[n4][n3].getEntry();
                if (n2 < 0) {
                    n5 = 1;
                    continue;
                }
                nArray[n2] = 1;
            }
        }
        n4 = 0;
        for (n3 = 0; n3 < Analysis.getNumUserEntries(); ++n3) {
            if (nArray[n3] <= 0) continue;
            ++n4;
        }
        if (n5 == 1 && this.data.showIdle) {
            ++n4;
        }
        System.out.println("The number of items to be shown in the legend is " + n4);
        n3 = ((int)Math.ceil((double)n4 / 2.0) + 2) * (n14 + 2);
        System.out.println("The legend height = " + n3);
        int n18 = 1;
        int n19 = n15 + 2 * n16 + n17;
        for (n = n12; n <= n13; ++n) {
            if ((n19 += this.data.tluh) <= n9) continue;
            ++n18;
            n19 = n15 + 2 * n16 + n17 + this.data.tluh;
        }
        n19 += n3;
        while (n19 > n9) {
            ++n18;
            n19 = n19 - n9 + n15 + n17;
        }
        System.out.println("It will take " + n18 + " to fit this data");
        n = fontMetrics.stringWidth("Processor " + n13);
        int n20 = n + 20;
        n2 = n8 - n20;
        int n21 = 5 + fontMetrics.stringWidth("" + l) / 2;
        int n22 = 5 + fontMetrics.stringWidth("" + l2) / 2;
        long l5 = l2 - l + 1L;
        int n23 = n2 - n21 - n22;
        int n24 = (int)Math.ceil(5.0 / ((double)n23 / (double)l5));
        n24 = Util.getBestIncrement(n24);
        int n25 = (int)Math.ceil(l5 / (long)n24) + 1;
        double d = (double)n23 / (double)n25;
        int n26 = (int)Math.ceil((double)(fontMetrics.stringWidth("" + l2) + 10) / d);
        n26 = Util.getBestIncrement(n26);
        this.data.processorList.reset();
        for (int i = 0; i < n12; ++i) {
            this.data.processorList.nextElement();
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        String[][] stringArray = Analysis.getEntryNames();
        int n27 = n12;
        int n28 = 0;
        boolean bl = false;
        for (int i = 0; i < n18; ++i) {
            int n29;
            int n30;
            String string;
            int n31;
            int n32;
            if (graphics == null) {
                graphics = printJob.getGraphics();
                graphics.setFont(new Font("SansSerif", 0, 10));
                graphics.translate(n7, n6);
            }
            int n33 = 0;
            String string2 = "PROJECTIONS TIMELINE FOR " + Analysis.getFilename();
            graphics.setColor(Color.black);
            graphics.drawString(string2, (n8 - fontMetrics.stringWidth(string2)) / 2, n33 += n14);
            n33 += 10;
            int n34 = (int)((double)(n25 - 1) * d);
            if (!bl) {
                graphics.setColor(Color.black);
                graphics.drawLine(n20 + n21, n33 += 10 + n14, n20 + n21 + n34, n33);
                for (n32 = 0; n32 < n25 && (long)(n31 = n20 + n21 + (int)((double)n32 * d)) <= l2; ++n32) {
                    if (n32 % n26 == 0) {
                        string = "" + (l + (long)(n32 * n24));
                        graphics.drawLine(n31, n33 - 5, n31, n33 + 5);
                        graphics.drawString(string, n31 - fontMetrics.stringWidth(string) / 2, n33 - 10);
                        continue;
                    }
                    graphics.drawLine(n31, n33 - 2, n31, n33 + 2);
                }
            }
            n33 += 10;
            for (n30 = n27; n30 <= n13 && n33 + this.data.tluh + n16 + n17 <= n9; ++n30) {
                ++n27;
                n32 = (n33 += this.data.tluh) - this.data.tluh / 2;
                graphics.setColor(Color.black);
                string = "Processor " + this.data.processorList.nextElement();
                graphics.drawString(string, 10, n32);
                graphics.setColor(Color.gray);
                string = "(" + numberFormat.format(this.data.processorUsage[n30]) + "%)";
                graphics.drawString(string, 20, n32 + fontMetrics.getHeight() + 2);
                graphics.setColor(Color.gray);
                graphics.drawLine(n20 + n21, n32, n20 + n21 + n34, n32);
                for (n29 = this.data.tloArray[n30].length - 1; n29 >= 0; --n29) {
                    long l6 = this.data.tloArray[n30][n29].getBeginTime();
                    long l7 = this.data.tloArray[n30][n29].getEndTime();
                    if (l6 > l2 || l7 < l) continue;
                    int n35 = (int)((double)(l6 - l) * d / (double)n24);
                    if (l6 < l) {
                        n35 = -5;
                    }
                    graphics.translate(n20 + n21 + n35, n32 - 10);
                    this.data.tloArray[n30][n29].print(graphics, l, l2, d, n24);
                    graphics.translate(-(n20 + n21 + n35), -(n32 - 10));
                }
            }
            if (!bl) {
                graphics.setColor(Color.black);
                graphics.drawLine(n20 + n21, n33 += 10, n20 + n21 + n34, n33);
                for (n30 = 0; n30 < n25 && (long)(n31 = n20 + n21 + (int)((double)n30 * d)) <= l2; ++n30) {
                    if (n30 % n26 == 0) {
                        string = "" + (l + (long)(n30 * n24));
                        graphics.drawLine(n31, n33 - 5, n31, n33 + 5);
                        graphics.drawString(string, n31 - fontMetrics.stringWidth(string) / 2, n33 + 10 + fontMetrics.getHeight());
                        continue;
                    }
                    graphics.drawLine(n31, n33 - 2, n31, n33 + 2);
                }
                n33 += 10 + n14;
            }
            if (n27 > n13) {
                bl = true;
                graphics.setColor(Color.black);
                String string3 = "LEGEND";
                graphics.drawString(string3, (n8 - fontMetrics.stringWidth(string3)) / 2, n33 += 10 + n14);
                n33 += 2 * n14;
                n29 = 0;
                for (int j = n28; j < nArray.length; ++j) {
                    ++n28;
                    if (nArray[j] <= 0) continue;
                    graphics.setColor(this.data.entryColor[j]);
                    string3 = stringArray[j][1] + "::" + stringArray[j][0];
                    graphics.drawString(string3, n29, n33);
                    if (n29 == 0) {
                        n29 = (int)((double)n8 / 2.0);
                        continue;
                    }
                    n29 = 0;
                    if ((n33 += n14 + 2) + n17 > n9) break;
                }
            }
            n33 = n9;
            graphics.setColor(Color.black);
            String string4 = "Page " + (i + 1) + " of " + n18;
            graphics.drawString(string4, (n8 - fontMetrics.stringWidth(string4)) / 2, n33);
            graphics.dispose();
            graphics = null;
        }
        printJob.end();
    }

    private void setAllSizes(boolean bl) {
        if (bl) {
            this.data.clearAllLines();
            this.setAllSizes();
        } else {
            this.setAllSizes();
            this.data.drawAllLines();
        }
    }

    private void setAllSizes() {
        this.data.mpw = this.mainPanel.getSize().width;
        this.data.mph = this.mainPanel.getSize().height;
        this.data.vpw = this.data.mpw - this.data.lcw - this.data.sbw;
        this.data.abh = this.data.mph - this.data.ath - this.data.tlh - this.data.sbh;
        if (this.data.abh < this.data.ath) {
            this.data.abh = this.data.ath;
            this.VSB.setVisible(true);
        } else {
            this.VSB.setVisible(false);
        }
        this.data.vph = this.data.mph - this.data.ath - this.data.abh - this.data.sbh;
        this.setTLSizes();
        this.setScales();
        this.labelCanvas.setBounds(0, this.data.ath, this.data.lcw, this.data.vph);
        this.axisTopCanvas.setBounds(this.data.lcw, 0, this.data.vpw, this.data.ath);
        this.displayPanel.setBounds(this.data.lcw, this.data.ath, this.data.vpw, this.data.vph);
        this.axisBotCanvas.setBounds(this.data.lcw, this.data.ath + this.data.vph, this.data.vpw, this.data.abh);
        this.HSB.setBounds(this.data.lcw, this.data.mph - this.data.sbh, this.data.vpw, this.data.sbh);
        this.VSB.setBounds(this.data.mpw - this.data.sbw, 0, this.data.sbw, this.data.mph - this.data.sbh);
        int n = this.data.vpw;
        if (n < 1) {
            n = 1;
        }
        this.HSB.setVisibleAmount(n);
        this.HSB.setBlockIncrement(n);
        int n2 = this.data.vph;
        if (n2 < 1) {
            n2 = 1;
        }
        this.VSB.setVisibleAmount(n2);
        this.VSB.setBlockIncrement(n2);
        this.setTLBounds();
    }

    public void setScales() {
        Graphics graphics;
        int n = this.HSB.getValue();
        int n2 = this.VSB.getValue();
        int n3 = (int)Math.floor((double)(n - this.data.offset) / this.data.pixelIncrement) * this.data.timeIncrement;
        if (n3 < 0) {
            n3 = 0;
        }
        if (this.fm == null && (graphics = this.getGraphics()) != null) {
            this.fm = graphics.getFontMetrics(graphics.getFont());
            this.maxLabelLen = this.fm.stringWidth("" + this.data.endTime) + 20;
            this.data.offset = 5 + this.maxLabelLen / 2;
            graphics.dispose();
        }
        if (this.fm != null) {
            long l = this.data.endTime - this.data.beginTime;
            int n4 = this.data.tlw - 2 * this.data.offset;
            this.data.timeIncrement = (int)Math.ceil(5.0 / ((double)n4 / (double)l));
            this.data.timeIncrement = Util.getBestIncrement(this.data.timeIncrement);
            this.data.numIntervals = (int)Math.ceil(l / (long)this.data.timeIncrement) + 1;
            this.data.pixelIncrement = (double)n4 / (double)this.data.numIntervals;
            this.data.labelIncrement = (int)Math.ceil((double)this.maxLabelLen / this.data.pixelIncrement);
            this.data.labelIncrement = Util.getBestIncrement(this.data.labelIncrement);
        }
        int n5 = (double)this.data.scale == 1.0 ? 0 : n;
        this.HSB.setValue(n5);
        this.VSB.setValue(n2);
    }

    private void setTLBounds() {
        int n;
        int n2;
        this.HSB.setMaximum(this.data.tlw);
        this.displayCanvas.setBounds(0, 0, this.data.tlw, this.data.tlh);
        if (this.data.tloArray != null) {
            for (n2 = 0; n2 < this.data.numPs; ++n2) {
                if (this.data.tloArray[n2] == null) continue;
                for (n = 0; n < this.data.tloArray[n2].length; ++n) {
                    this.data.tloArray[n2][n].setBounds(n2);
                }
            }
        }
        if (this.data.userEventsArray != null) {
            for (n2 = 0; n2 < this.data.numPs; ++n2) {
                if (this.data.userEventsArray[n2] == null) continue;
                for (n = 0; n < this.data.userEventsArray[n2].length; ++n) {
                    this.data.userEventsArray[n2][n].setBounds(n2, this.data);
                }
            }
        }
    }

    private void setTLSizes() {
        this.data.tlw = (int)((float)this.data.vpw * this.data.scale);
        if (this.data.scale > 1.0f) {
            this.HSB.setVisible(true);
        } else {
            this.HSB.setVisible(false);
        }
    }

    private void ShowColorWindow() {
        if (this.colorWindow == null) {
            this.colorWindow = new TimelineColorWindow((Frame)this, this.data);
        }
        this.colorWindow.setVisible(true);
    }

    class NoUpdatePanel
    extends Panel {
        NoUpdatePanel() {
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    private class AxisMouseController {
        public MouseMotionAdapter mouseMotionAdapter = null;
        public MouseListener mouseListener = null;
        private TimelineDisplayCanvas canvas_;
        private TimelineAxisCanvas timeline_;
        private TimelineWindow window_;
        public boolean selected_ = false;

        AxisMouseController(TimelineWindow timelineWindow2, TimelineDisplayCanvas timelineDisplayCanvas, TimelineAxisCanvas timelineAxisCanvas) {
            this.window_ = timelineWindow2;
            this.canvas_ = timelineDisplayCanvas;
            this.timeline_ = timelineAxisCanvas;
            this.mouseMotionAdapter = new MouseMotionAdapter(this){
                private final /* synthetic */ AxisMouseController this$1;
                {
                    this.this$1 = axisMouseController;
                }

                public void mouseDragged(MouseEvent mouseEvent) {
                    Point point = AxisMouseController.access$000(this.this$1).screenToCanvas(mouseEvent.getPoint());
                    AxisMouseController.access$100((AxisMouseController)this.this$1).rubberBand.stretch(point);
                    AxisMouseController.access$200(this.this$1).setHighlightTime(AxisMouseController.access$000(this.this$1).canvasToTime(point.x));
                    AxisMouseController.access$100(this.this$1).repaint();
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    Point point = AxisMouseController.access$000(this.this$1).screenToCanvas(mouseEvent.getPoint());
                    AxisMouseController.access$100((AxisMouseController)this.this$1).rubberBand.highlight(point);
                    AxisMouseController.access$200(this.this$1).setHighlightTime(AxisMouseController.access$000(this.this$1).canvasToTime(point.x));
                    AxisMouseController.access$100(this.this$1).repaint();
                }
            };
            this.mouseListener = new MouseListener(this){
                private final /* synthetic */ AxisMouseController this$1;
                {
                    this.this$1 = axisMouseController;
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    AxisMouseController.access$100((AxisMouseController)this.this$1).rubberBand.clearHighlight();
                    AxisMouseController.access$200(this.this$1).unsetHighlightTime();
                    AxisMouseController.access$100((AxisMouseController)this.this$1).rubberBand.anchor(AxisMouseController.access$000(this.this$1).screenToCanvas(mouseEvent.getPoint()));
                    AxisMouseController.access$100(this.this$1).repaint();
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    AxisMouseController.access$100((AxisMouseController)this.this$1).rubberBand.stretch(AxisMouseController.access$000(this.this$1).screenToCanvas(mouseEvent.getPoint()));
                    AxisMouseController.access$100(this.this$1).repaint();
                    this.this$1.selected_ = true;
                    Rectangle rectangle = AxisMouseController.access$100((AxisMouseController)this.this$1).rubberBand.bounds();
                    double d = AxisMouseController.access$000(this.this$1).canvasToTime(rectangle.x);
                    double d2 = AxisMouseController.access$000(this.this$1).canvasToTime(rectangle.x + rectangle.width);
                    AxisMouseController.access$200(this.this$1).setSelectedTime(d, d2);
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    AxisMouseController.access$100((AxisMouseController)this.this$1).rubberBand.clearHighlight();
                    AxisMouseController.access$300(this.this$1).unsetHighlightTime();
                    AxisMouseController.access$100(this.this$1).repaint();
                }
            };
        }

        static /* synthetic */ TimelineAxisCanvas access$000(AxisMouseController axisMouseController) {
            return axisMouseController.timeline_;
        }

        static /* synthetic */ TimelineDisplayCanvas access$100(AxisMouseController axisMouseController) {
            return axisMouseController.canvas_;
        }

        static /* synthetic */ TimelineWindow access$200(AxisMouseController axisMouseController) {
            return axisMouseController.window_;
        }

        static /* synthetic */ TimelineWindow access$300(AxisMouseController axisMouseController) {
            return axisMouseController.TimelineWindow.this;
        }
    }
}

