/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import projections.gui.Analysis;
import projections.gui.Bubble;

public class ProfileGraph
extends JPanel
implements MouseMotionListener {
    float[][] dataSource;
    private int[][] colorsMap;
    private Color[] colorsPool;
    private String[][] sectionNames;
    private String[] graphTitles;
    private int gTitleH;
    private int canvasWidth;
    private int canvasHeight;
    private int baseWidth = -1;
    private int baseHeight = -1;
    private int xWidth;
    private int originX;
    private double xscale;
    private String xTitle;
    private String xUnit;
    private String[] xNames;
    private double pixelIncX;
    private int yHeight;
    private int originY;
    private double yscale;
    private String yTitle;
    private double pixelIncY;
    private double tickIncY;
    private static final int FONT_SIZE = 12;
    private Font font = null;
    private FontMetrics fm = null;
    private double barWidth;
    private Bubble bubble;
    private int bubbleXVal;
    private int bubbleYVal;

    public ProfileGraph() {
        this.setPreferredSize(new Dimension(600, 450));
        this.dataSource = null;
        this.xscale = 1.0;
        this.yscale = 1.0;
        this.addMouseMotionListener(this);
    }

    public ProfileGraph(String[] stringArray) {
        this();
        this.graphTitles = stringArray;
    }

    public void setXAxis(String string, String string2, String[] stringArray) {
        this.xTitle = string;
        this.xUnit = string2;
        this.xNames = stringArray;
    }

    public void setYAxis(String string) {
        this.yTitle = string;
    }

    public void setGraphTiltes(String[] stringArray) {
        this.graphTitles = stringArray;
    }

    public Dimension getMinimumSize() {
        return new Dimension(600, 450);
    }

    public void setDisplayDataSource(float[][] fArray, int[][] nArray, Color[] colorArray, String[][] stringArray) {
        this.dataSource = fArray;
        this.colorsMap = nArray;
        this.colorsPool = colorArray;
        this.sectionNames = stringArray;
    }

    public void setScaleX(double d) {
        this.xscale = d;
        this.setPreferredSize(new Dimension((int)((double)this.baseWidth * this.xscale), (int)((double)this.baseHeight * this.yscale)));
        this.revalidate();
        this.repaint();
    }

    public double getScaleX() {
        return this.xscale;
    }

    public void setScaleY(double d) {
        this.yscale = d;
        this.setPreferredSize(new Dimension((int)((double)this.baseWidth * this.xscale), (int)((double)this.baseHeight * this.yscale)));
        this.revalidate();
        this.repaint();
    }

    public double getScaleY() {
        return this.yscale;
    }

    private int getXValue(int n) {
        int n2;
        int n3;
        int n4;
        if (n > this.originX && n < this.canvasWidth + this.originX && (double)n > (double)(n4 = this.originX + (int)((double)(n3 = (int)((double)(n2 = n - this.originX) / this.pixelIncX)) * this.pixelIncX) + (int)(this.pixelIncX / 2.0)) - this.barWidth / 2.0 && (double)n < (double)n4 + this.barWidth / 2.0) {
            return n3;
        }
        return -1;
    }

    private int getYValue(int n, int n2) {
        if (n2 < this.originY && n2 > this.gTitleH) {
            int n3;
            int n4 = this.originY - n2;
            for (n3 = 0; n3 < this.dataSource[n].length; ++n3) {
                int n5;
                double d = (double)this.dataSource[n][n3] * this.pixelIncY;
                int n6 = n5 = (int)d == 0 ? 1 : (int)d;
                if ((n4 -= n5) < 0) break;
            }
            if (n4 < 0) {
                return n3;
            }
        }
        return -1;
    }

    public void paint(Graphics graphics) {
        if (this.font == null) {
            this.font = new Font("Times New Roman", 1, 12);
            graphics.setFont(this.font);
            this.fm = graphics.getFontMetrics(this.font);
        }
        this.drawDisplay(graphics);
    }

    public void print(Graphics graphics) {
        if (this.font == null) {
            this.font = new Font("Times New Roman", 1, 12);
            graphics.setFont(this.font);
            this.fm = graphics.getFontMetrics(this.font);
        }
        Color color = Analysis.background;
        Color color2 = Analysis.foreground;
        Analysis.background = Color.white;
        Analysis.foreground = Color.black;
        this.drawDisplay(graphics);
        Analysis.background = color;
        Analysis.foreground = color2;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.dataSource == null) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.getXValue(n);
        int n4 = -1;
        if (n3 > -1) {
            n4 = this.getYValue(n3, n2);
        }
        if (n3 > -1 && n4 > -1) {
            this.showPopup(n3, n4, n, n2);
        } else if (this.bubble != null) {
            this.bubble.setVisible(false);
            this.bubble.dispose();
            this.bubble = null;
        }
    }

    private Point getBubbleOffset() {
        Container container = this;
        int n = container.getLocation().x;
        int n2 = container.getLocation().y;
        while ((container = container.getParent()) != null) {
            n += container.getLocation().x;
            n2 += container.getLocation().y;
        }
        return new Point(n, n2);
    }

    public void showPopup(int n, int n2, int n3, int n4) {
        Point point = this.getBubbleOffset();
        String[] stringArray = new String[2];
        stringArray[0] = this.sectionNames[n][n2];
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(3);
        stringArray[1] = "Usage: " + decimalFormat.format(this.dataSource[n][n2]) + "%";
        if (this.bubble != null && (this.bubbleXVal != n || this.bubbleYVal != n2)) {
            this.bubble.setVisible(false);
            this.bubble.dispose();
            this.bubble = null;
        }
        if (this.bubble == null) {
            this.bubble = new Bubble(this, stringArray);
            this.bubble.setLocation(n3 + point.x, n4 + point.y);
            this.bubble.setVisible(true);
            this.bubbleXVal = n;
            this.bubbleYVal = n2;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    private void drawDisplay(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setBackground(Analysis.background);
        graphics2D.setColor(Analysis.foreground);
        this.canvasWidth = this.getWidth();
        this.canvasHeight = this.getHeight();
        graphics2D.clearRect(0, 0, this.canvasWidth, this.canvasHeight);
        if (this.dataSource == null) {
            return;
        }
        Font font = this.font;
        this.font = new Font("Times New Roman", 1, 18);
        graphics2D.setFont(this.font);
        this.fm = graphics2D.getFontMetrics(this.font);
        int n = 0;
        int n2 = 0;
        this.baseWidth = this.getParent().getWidth();
        this.baseHeight = this.getParent().getHeight();
        if (!this.xTitle.equals("")) {
            graphics2D.drawString(this.xTitle, (this.canvasWidth - this.fm.stringWidth(this.xTitle)) / 2 + n, this.canvasHeight - 10 + n2);
        }
        for (int i = 0; i < this.graphTitles.length; ++i) {
            graphics2D.drawString(this.graphTitles[i], (this.canvasWidth - this.fm.stringWidth(this.graphTitles[i])) / 2 + n, 10 + this.fm.getHeight() * (i + 1) + n2);
        }
        this.gTitleH = this.fm.getHeight() * this.graphTitles.length + 15;
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.drawString(this.yTitle, -(this.canvasHeight + this.fm.stringWidth(this.yTitle)) / 2 + n2, this.fm.getHeight() + n);
        graphics2D.rotate(1.5707963267948966);
        this.originX = this.fm.getHeight() * 2 + this.fm.stringWidth("100");
        this.originY = this.canvasHeight - (30 + this.fm.getHeight() * 2);
        this.font = font;
        graphics2D.setFont(this.font);
        this.fm = graphics2D.getFontMetrics(this.font);
        this.drawXAxis(graphics2D);
        this.drawYAxis(graphics2D, this.gTitleH);
        this.drawBarGraph(graphics2D);
    }

    private void drawXAxis(Graphics2D graphics2D) {
        this.canvasWidth = (int)((double)(this.baseWidth - 30 - this.originX) * this.xscale);
        int n = this.dataSource.length;
        this.pixelIncX = (double)this.canvasWidth / (double)n;
        graphics2D.drawLine(this.originX, this.originY, this.canvasWidth + this.originX, this.originY);
        int n2 = this.originX + (int)this.pixelIncX / 2;
        for (int i = 0; i < n; ++i) {
            String string = this.xNames[i];
            graphics2D.drawString(string, n2 - this.fm.stringWidth(string) / 2, this.originY + 10 + this.fm.getHeight());
            n2 += (int)this.pixelIncX;
        }
    }

    private void drawYAxis(Graphics2D graphics2D, int n) {
        graphics2D.drawLine(this.originX, this.originY, this.originX, n);
        this.canvasHeight = this.originY - n;
        this.pixelIncY = (double)this.canvasHeight / 100.0;
        int n2 = this.fm.getHeight();
        double d = this.originY;
        int n3 = 5;
        int n4 = 2;
        for (int i = 0; i <= 100; ++i) {
            if (i % 5 == 0) {
                graphics2D.drawLine(this.originX, (int)d, this.originX - n3, (int)d);
                String string = "" + i;
                graphics2D.drawString(string, this.originX - this.fm.stringWidth(string) - 5, (int)d + n2 / 2);
            } else {
                graphics2D.drawLine(this.originX, (int)d, this.originX - n4, (int)d);
            }
            d -= this.pixelIncY;
        }
    }

    private void drawBarGraph(Graphics2D graphics2D) {
        Color color = graphics2D.getColor();
        double d = (double)this.originX + this.pixelIncX / 8.0;
        this.barWidth = this.pixelIncX * 3.0 / 4.0;
        for (int i = 0; i < this.dataSource.length; ++i) {
            double d2 = this.originY;
            for (int j = 0; j < this.dataSource[i].length; ++j) {
                graphics2D.setColor(this.colorsPool[this.colorsMap[i][j]]);
                double d3 = (double)this.dataSource[i][j] * this.pixelIncY;
                int n = (int)d3 == 0 ? 1 : (int)d3;
                graphics2D.fillRect((int)d, (int)(d2 - (double)n), (int)this.barWidth, n);
                d2 -= d3;
            }
            d += this.pixelIncX;
        }
        graphics2D.setColor(color);
    }
}

