/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import projections.analysis.MultiRunDataAnalyzer;
import projections.gui.MainWindow;
import projections.gui.MultiRunControlPanel;
import projections.gui.MultiRunTables;
import projections.gui.ProjectionsFileChooser;
import projections.gui.ProjectionsWindow;
import projections.gui.SwingWorker;
import projections.gui.Util;
import projections.gui.graph.Graph;
import projections.gui.graph.GraphPanel;
import projections.gui.graph.MultiRunDataSource;
import projections.gui.graph.MultiRunXAxis;
import projections.gui.graph.MultiRunYAxis;
import projections.misc.MultiRunData;

public class MultiRunWindow
extends ProjectionsWindow
implements ActionListener,
ItemListener {
    private MultiRunWindow thisWindow = this;
    private MultiRunControlPanel controlPanel;
    private MultiRunTables tablesPanel;
    private JDialog tablesWindow;
    private GraphPanel graphPanel;
    private Graph graphCanvas;
    private ProjectionsFileChooser fc;
    private MultiRunData data;
    private MultiRunDataAnalyzer analyzer;
    private JPanel mainPanel;
    GridBagLayout gbl;
    GridBagConstraints gbc;
    private int selectedDataType;

    void windowInit() {
    }

    public MultiRunWindow(MainWindow mainWindow, Integer n) {
        super(mainWindow, n);
        this.setBackground(Color.lightGray);
        this.showDialog();
    }

    public void showDialog() {
        this.showFileDialog();
    }

    public void showWindow() {
        this.showFileDialog();
    }

    public void getDialogData() {
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
        this.parentWindow.closeChildWindow(this.myWindowID);
    }

    public void showFileDialog() {
        this.fc = new ProjectionsFileChooser(this, "Multirun Analysis", 1);
        this.fc.showDialog();
    }

    public void dialogCallback() {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                try {
                    MultiRunWindow.this.data = new MultiRunData(((MultiRunWindow)MultiRunWindow.this).fc.userSelect_returnVal);
                    MultiRunWindow.this.analyzer = new MultiRunDataAnalyzer(MultiRunWindow.this.data);
                    MultiRunWindow.this.selectedDataType = 0;
                    MultiRunWindow.this.thisWindow.createDisplayPanels();
                }
                catch (IOException iOException) {
                    System.err.println(iOException.toString());
                }
                return null;
            }

            public void finished() {
                MultiRunWindow.this.thisWindow.createLayout();
                MultiRunWindow.this.thisWindow.pack();
                MultiRunWindow.this.thisWindow.setTitle("Multiple Run Analysis");
                MultiRunWindow.this.thisWindow.setVisible(true);
            }
        };
        swingWorker.start();
    }

    private void createLayout() {
        this.mainPanel = new JPanel();
        this.mainPanel.setBackground(Color.gray);
        this.controlPanel = new MultiRunControlPanel(this, this.selectedDataType);
        this.gbl = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.mainPanel.setLayout(this.gbl);
        this.gbc.fill = 1;
        Util.gblAdd(this.mainPanel, this.graphPanel, this.gbc, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2);
        Util.gblAdd(this.mainPanel, this.controlPanel, this.gbc, 0, 1, 2, 1, 1, 0, 2, 2, 2, 2);
        this.setContentPane(this.mainPanel);
    }

    private void createDisplayPanels() {
        MultiRunDataSource multiRunDataSource = this.analyzer.getDataSource(this.selectedDataType);
        MultiRunXAxis multiRunXAxis = this.analyzer.getMRXAxisData();
        MultiRunYAxis multiRunYAxis = this.analyzer.getMRYAxisData(this.selectedDataType);
        this.graphCanvas = new Graph(multiRunDataSource, multiRunXAxis, multiRunYAxis);
        this.graphPanel = new GraphPanel(this.graphCanvas);
        this.tablesPanel = new MultiRunTables(this.selectedDataType, this.analyzer);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JRadioButton) {
            JRadioButton jRadioButton = (JRadioButton)itemEvent.getSource();
            if (itemEvent.getStateChange() == 1) {
                this.selectedDataType = this.controlPanel.getSelectedIdx(itemEvent.getItemSelectable());
                MultiRunDataSource multiRunDataSource = this.analyzer.getDataSource(this.selectedDataType);
                MultiRunXAxis multiRunXAxis = this.analyzer.getMRXAxisData();
                MultiRunYAxis multiRunYAxis = this.analyzer.getMRYAxisData(this.selectedDataType);
                this.graphCanvas.setData(multiRunDataSource, multiRunXAxis, multiRunYAxis);
                this.tablesPanel.setType(this.selectedDataType);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.getText().equals("Close Window")) {
                this.close();
            } else if (jButton.getText().equals("Display Tables")) {
                if (this.tablesWindow == null) {
                    this.tablesWindow = new JDialog(this);
                    this.tablesWindow.getContentPane().add(this.tablesPanel);
                    this.tablesWindow.setSize(new Dimension(500, 300));
                    this.tablesWindow.show();
                } else {
                    this.tablesWindow.show();
                }
            }
        }
    }
}

