/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JColorChooser;
import projections.gui.ColorPanel;
import projections.gui.ColorSelectWindow;
import projections.gui.ColorWindowFrame;
import projections.gui.GraphData;
import projections.gui.GrayPanel;
import projections.gui.LWPanel;
import projections.gui.Util;
import projections.gui.ZItem;

public class GraphAttributesWindow
extends ColorWindowFrame
implements ActionListener {
    private ColorSelectWindow colorSelectWindow;
    private GraphData data;
    private Checkbox[] cbSystemUsage;
    private ColorPanel[] cpSystemUsage;
    private ColorPanel[][] cpSystemMsgs;
    private ColorPanel[][] cpUserEntry;
    private Checkbox[][] cbSystemMsgs;
    private Checkbox[][] cbUserEntry;
    private ColorPanel selectedCP;
    private GrayPanel p1;
    private GrayPanel p2;
    private GrayPanel p4;
    private Button bAll;
    private Button bClear;
    private Button bApply;
    private Button bClose;

    public GraphAttributesWindow(Frame frame, GraphData graphData) {
        super(frame);
        this.data = graphData;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GraphAttributesWindow.this.Close();
            }
        });
        this.setBackground(Color.lightGray);
        this.setTitle("Select Display Items");
        this.setLocation(0, 0);
        this.CreateLayout();
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof ColorPanel) {
            int n;
            int n2;
            this.selectedCP = (ColorPanel)actionEvent.getSource();
            String string = "TEST";
            for (n2 = 0; n2 < 3; ++n2) {
                if (this.selectedCP != this.cpSystemUsage[n2]) continue;
                string = this.data.systemUsage[n2].name;
            }
            for (n2 = 0; n2 < 5; ++n2) {
                for (n = 0; n < 2; ++n) {
                    if (this.selectedCP != this.cpSystemMsgs[n2][n]) continue;
                    string = this.data.systemMsgs[n2][n].name;
                    string = string + this.data.systemMsgs[n2][n].type;
                }
            }
            for (n2 = 0; n2 < this.data.numUserEntries; ++n2) {
                for (n = 0; n < 2; ++n) {
                    if (this.selectedCP != this.cpUserEntry[n2][n]) continue;
                    string = this.data.userEntry[n2][n].name;
                    string = string + this.data.userEntry[n2][n].type;
                }
            }
            JColorChooser jColorChooser = new JColorChooser();
            Color color = JColorChooser.showDialog(this, string, this.selectedCP.getColor());
            if (color != null) {
                this.selectedCP.setColor(color);
            }
        } else if (actionEvent.getSource() instanceof Button) {
            Button button = (Button)actionEvent.getSource();
            if (button == this.bAll || button == this.bClear) {
                int n;
                boolean bl = button == this.bAll;
                for (n = 0; n < 3; ++n) {
                    if (null == this.cbSystemUsage[n]) continue;
                    this.cbSystemUsage[n].setState(bl);
                }
                for (n = 0; n < 5; ++n) {
                    if (null == this.cbSystemMsgs[n][0]) continue;
                    this.cbSystemMsgs[n][0].setState(bl);
                    this.cbSystemMsgs[n][1].setState(bl);
                }
                for (n = 0; n < this.data.numUserEntries; ++n) {
                    if (null == this.cbUserEntry[n][0]) continue;
                    this.cbUserEntry[n][0].setState(bl);
                    this.cbUserEntry[n][1].setState(bl);
                }
            } else if (button == this.bClose) {
                this.Close();
            } else if (button == this.bApply) {
                int n;
                int n3;
                int n4;
                int n5 = 0;
                for (n4 = 0; n4 < 3; ++n4) {
                    if (null == this.cbSystemUsage[n4]) continue;
                    this.data.systemUsage[n4].state = this.cbSystemUsage[n4].getState();
                    this.data.systemUsage[n4].color = this.cpSystemUsage[n4].getColor();
                    if (!this.data.systemUsage[n4].state || !this.data.systemUsage[n4].exists) continue;
                    ++n5;
                }
                for (n4 = 0; n4 < 5; ++n4) {
                    if (null == this.cbSystemMsgs[n4][0]) continue;
                    for (n3 = 0; n3 < 3; ++n3) {
                        if (n3 < 2) {
                            this.data.systemMsgs[n4][n3].state = this.cbSystemMsgs[n4][n3].getState();
                            this.data.systemMsgs[n4][n3].color = this.cpSystemMsgs[n4][n3].getColor();
                        } else {
                            this.data.systemMsgs[n4][2].state = this.data.systemMsgs[n4][0].state || this.data.systemMsgs[n4][1].state;
                            this.data.systemMsgs[n4][2].color = this.data.systemMsgs[n4][0].color;
                        }
                        if (!this.data.systemMsgs[n4][n3].state || !this.data.systemMsgs[n4][n3].exists) continue;
                        ++n5;
                    }
                }
                for (n4 = 0; n4 < this.data.numUserEntries; ++n4) {
                    if (null == this.cbUserEntry[n4][0]) continue;
                    for (n3 = 0; n3 < 3; ++n3) {
                        if (n3 < 2) {
                            this.data.userEntry[n4][n3].state = this.cbUserEntry[n4][n3].getState();
                            this.data.userEntry[n4][n3].color = this.cpUserEntry[n4][n3].getColor();
                        } else {
                            this.data.userEntry[n4][2].state = this.data.userEntry[n4][0].state || this.data.userEntry[n4][1].state;
                            this.data.userEntry[n4][2].color = this.data.userEntry[n4][0].color;
                        }
                        if (!this.data.userEntry[n4][n3].state || !this.data.userEntry[n4][n3].exists) continue;
                        ++n5;
                    }
                }
                this.data.onGraph = new ZItem[n5];
                n4 = 0;
                for (n3 = 0; n3 < 3; ++n3) {
                    if (!this.data.systemUsage[n3].exists || !this.data.systemUsage[n3].state) continue;
                    this.data.onGraph[n4++] = this.data.systemUsage[n3];
                }
                for (n3 = 0; n3 < 5; ++n3) {
                    for (n = 0; n < 3; ++n) {
                        if (!this.data.systemMsgs[n3][n].exists || !this.data.systemMsgs[n3][n].state) continue;
                        this.data.onGraph[n4++] = this.data.systemMsgs[n3][n];
                    }
                }
                for (n3 = 0; n3 < this.data.numUserEntries; ++n3) {
                    for (n = 0; n < 3; ++n) {
                        if (!this.data.userEntry[n3][n].exists || !this.data.userEntry[n3][n].state) continue;
                        this.data.onGraph[n4++] = this.data.userEntry[n3][n];
                    }
                }
                this.data.setData();
                this.data.legendPanel.UpdateLegend();
                this.data.displayPanel.setAllBounds();
                this.data.displayPanel.UpdateDisplay();
            }
        }
    }

    public void Close() {
        int n;
        int n2;
        this.setVisible(false);
        for (n2 = 0; n2 < 3; ++n2) {
            if (this.cbSystemUsage[n2] == null) continue;
            this.cbSystemUsage[n2].setState(this.data.systemUsage[n2].state);
            this.cpSystemUsage[n2].setColor(this.data.systemUsage[n2].color);
        }
        for (n2 = 0; n2 < 5; ++n2) {
            if (null == this.cbSystemMsgs[n2][0]) continue;
            for (n = 0; n < 2; ++n) {
                this.cbSystemMsgs[n2][n].setState(this.data.systemMsgs[n2][n].state);
                this.cpSystemMsgs[n2][n].setColor(this.data.systemMsgs[n2][n].color);
            }
        }
        for (n2 = 0; n2 < this.data.numUserEntries; ++n2) {
            if (null == this.cbUserEntry[n2][0]) continue;
            for (n = 0; n < 2; ++n) {
                this.cbUserEntry[n2][n].setState(this.data.userEntry[n2][n].state);
                this.cpUserEntry[n2][n].setColor(this.data.userEntry[n2][n].color);
            }
        }
    }

    private void CreateLayout() {
        Label label;
        Label label2;
        int n;
        int n2;
        this.cbSystemUsage = new Checkbox[3];
        this.cpSystemUsage = new ColorPanel[3];
        for (n2 = 0; n2 < 3; ++n2) {
            if (!this.data.systemUsage[n2].exists) continue;
            this.cbSystemUsage[n2] = new Checkbox();
            this.cbSystemUsage[n2].setState(this.data.systemUsage[n2].state);
            this.cpSystemUsage[n2] = new ColorPanel(this.data.systemUsage[n2].color);
            this.cpSystemUsage[n2].addActionListener(this);
        }
        this.cbSystemMsgs = new Checkbox[5][2];
        this.cpSystemMsgs = new ColorPanel[5][2];
        for (n2 = 0; n2 < 5; ++n2) {
            for (n = 0; n < 2; ++n) {
                if (!this.data.systemMsgs[n2][0].exists && !this.data.systemMsgs[n2][1].exists) continue;
                this.cbSystemMsgs[n2][n] = new Checkbox();
                this.cbSystemMsgs[n2][n].setState(this.data.systemMsgs[n2][n].state);
                this.cpSystemMsgs[n2][n] = new ColorPanel(this.data.systemMsgs[n2][n].color);
                this.cpSystemMsgs[n2][n].addActionListener(this);
            }
        }
        this.cbUserEntry = new Checkbox[this.data.numUserEntries][2];
        this.cpUserEntry = new ColorPanel[this.data.numUserEntries][2];
        for (n2 = 0; n2 < this.data.numUserEntries; ++n2) {
            for (n = 0; n < 2; ++n) {
                if (!this.data.userEntry[n2][0].exists && !this.data.userEntry[n2][1].exists) continue;
                this.cbUserEntry[n2][n] = new Checkbox();
                this.cbUserEntry[n2][n].setState(this.data.userEntry[n2][n].state);
                this.cpUserEntry[n2][n] = new ColorPanel(this.data.userEntry[n2][n].color);
                this.cpUserEntry[n2][n].addActionListener(this);
            }
        }
        Panel panel = new Panel();
        this.add("Center", panel);
        panel.setBackground(Color.gray);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        panel.setLayout(gridBagLayout);
        this.p1 = new GrayPanel();
        this.p2 = new GrayPanel();
        this.p4 = new GrayPanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        Label label3 = new Label("SYSTEM USAGE", 0);
        label3.setFont(new Font("SansSerif", 1, 12));
        this.p1.setLayout(gridBagLayout);
        Util.gblAdd(this.p1, label3, gridBagConstraints, 0, 0, 3, 1, 1, 0, 5, 5, 0, 5);
        for (int i = 0; i < 3; ++i) {
            if (!this.data.systemUsage[i].exists) continue;
            label2 = new Label(this.data.systemUsage[i].name, 2);
            Util.gblAdd(this.p1, label2, gridBagConstraints, 0, i + 1, 1, 1, 0, 0, 0, 5, 0, 5);
            Util.gblAdd(this.p1, this.cbSystemUsage[i], gridBagConstraints, 1, i + 1, 1, 1, 0, 0, 0, 0, 0, 0);
            Util.gblAdd(this.p1, this.cpSystemUsage[i], gridBagConstraints, 2, i + 1, 1, 1, 0, 0, 0, 0, 0, 5);
        }
        ScrollPane scrollPane = new ScrollPane();
        label2 = new Label("* For a Y-Axis setting of Time:");
        Label label4 = new Label("- System Usage items will not be displayed.");
        Label label5 = new Label("- Selecting Creation AND/OR Processing will display the others.");
        label2.setFont(new Font("SansSerif", 0, 10));
        label4.setFont(new Font("SansSerif", 0, 10));
        label5.setFont(new Font("SansSerif", 0, 10));
        this.p2.setLayout(gridBagLayout);
        Util.gblAdd(this.p2, scrollPane, gridBagConstraints, 0, 0, 1, 1, 1, 1, 5, 5, 0, 5);
        Util.gblAdd(this.p2, label2, gridBagConstraints, 0, 1, 1, 1, 1, 0, 0, 5, -1, 5);
        Util.gblAdd(this.p2, label4, gridBagConstraints, 0, 2, 1, 1, 1, 0, 0, 5, -1, 5);
        Util.gblAdd(this.p2, label5, gridBagConstraints, 0, 3, 1, 1, 1, 0, 0, 5, 5, 5);
        Label label6 = new Label("SYSTEM MESSAGES", 0);
        Label label7 = new Label("USER ENTRIES", 0);
        Label label8 = new Label("Creation", 1);
        Label label9 = new Label("Processing", 1);
        label6.setFont(new Font("SansSerif", 1, 12));
        label7.setFont(new Font("SansSerif", 1, 12));
        LWPanel lWPanel = new LWPanel();
        scrollPane.add(lWPanel);
        lWPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        Util.gblAdd(lWPanel, label8, gridBagConstraints, 1, 0, 2, 1, 1, 0);
        Util.gblAdd(lWPanel, label9, gridBagConstraints, 3, 0, 2, 1, 1, 0);
        Util.gblAdd(lWPanel, label6, gridBagConstraints, 0, 1, 3, 1, 1, 0);
        int n3 = 2;
        for (int i = 0; i < 5; ++i) {
            if (!this.data.systemMsgs[i][0].exists) continue;
            label = new Label(this.data.systemMsgs[i][0].name, 2);
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            Util.gblAdd(lWPanel, label, gridBagConstraints, 0, n3, 1, 1, 1, 0, 0, 2, 0, 5);
            gridBagConstraints.fill = 3;
            gridBagConstraints.anchor = 13;
            Util.gblAdd(lWPanel, this.cbSystemMsgs[i][0], gridBagConstraints, 1, n3, 1, 1, 0, 0, 0, 0, 0, 0);
            Util.gblAdd(lWPanel, this.cbSystemMsgs[i][1], gridBagConstraints, 3, n3, 1, 1, 0, 0, 0, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            Util.gblAdd(lWPanel, this.cpSystemMsgs[i][0], gridBagConstraints, 2, n3, 1, 1, 0, 0, 0, 0, 0, 5);
            Util.gblAdd(lWPanel, this.cpSystemMsgs[i][1], gridBagConstraints, 4, n3++, 1, 1, 0, 0, 0, 0, 0, 5);
        }
        String string = new String();
        gridBagConstraints.fill = 1;
        Util.gblAdd(lWPanel, label7, gridBagConstraints, 0, n3++, 1, 1, 1, 0);
        for (int i = 0; i < this.data.numUserEntries; ++i) {
            if (!this.data.userEntry[i][0].exists && !this.data.userEntry[i][1].exists) continue;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 1;
            if (!this.data.userEntry[i][0].parent.equals(string)) {
                string = this.data.userEntry[i][0].parent;
                label = new Label(string, 0);
                Util.gblAdd(lWPanel, label, gridBagConstraints, 0, n3++, 3, 1, 1, 0);
            }
            label = new Label(this.data.userEntry[i][0].name, 2);
            Util.gblAdd(lWPanel, label, gridBagConstraints, 0, n3, 1, 1, 1, 0, 0, 2, 0, 5);
            gridBagConstraints.fill = 3;
            gridBagConstraints.anchor = 13;
            Util.gblAdd(lWPanel, this.cbUserEntry[i][0], gridBagConstraints, 1, n3, 1, 1, 0, 0, 0, 0, 0, 0);
            Util.gblAdd(lWPanel, this.cbUserEntry[i][1], gridBagConstraints, 3, n3, 1, 1, 0, 0, 0, 0, 0, 0);
            gridBagConstraints.anchor = 17;
            Util.gblAdd(lWPanel, this.cpUserEntry[i][0], gridBagConstraints, 2, n3, 1, 1, 0, 0, 0, 0, 0, 5);
            Util.gblAdd(lWPanel, this.cpUserEntry[i][1], gridBagConstraints, 4, n3++, 1, 1, 0, 0, 0, 0, 0, 5);
        }
        scrollPane.validate();
        this.p4.setLayout(new FlowLayout());
        this.bAll = new Button("Select All");
        this.bClear = new Button("Clear All");
        this.bApply = new Button("Apply");
        this.bClose = new Button("Close");
        this.bAll.addActionListener(this);
        this.bClear.addActionListener(this);
        this.bApply.addActionListener(this);
        this.bClose.addActionListener(this);
        this.p4.add(this.bAll);
        this.p4.add(this.bClear);
        this.p4.add(this.bApply);
        this.p4.add(this.bClose);
        gridBagConstraints.fill = 1;
        Util.gblAdd(panel, this.p1, gridBagConstraints, 0, 0, 1, 1, 1, 0, 4, 4, 2, 4);
        Util.gblAdd(panel, this.p2, gridBagConstraints, 0, 1, 1, 1, 1, 1, 2, 4, 2, 4);
        Util.gblAdd(panel, this.p4, gridBagConstraints, 0, 2, 1, 1, 1, 0, 2, 4, 4, 4);
    }
}

