/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import projections.gui.Analysis;
import projections.gui.AnimationWindow;
import projections.gui.OrderedIntList;

public class AnimationDisplayPanel
extends Panel
implements MouseMotionListener,
MouseListener {
    private float MAXHUE = 0.65f;
    private int numPs = -1;
    private int numIs = -1;
    private int pwidth;
    private int pheight;
    private int numrows;
    private int numcols;
    private int pold = -1;
    private int phoffset;
    private int pvoffset;
    private int hoffset;
    private int voffset;
    private float psize = 0.75f;
    private float fontOffset = 0.9f;
    private FontMetrics fm = null;
    private Font font = null;
    private int curI = -1;
    private int curP = -1;
    private long Isize = 0L;
    private int[][] data;
    private Image offscreen;
    private Color[] colors;
    private int w;
    private int h;
    private AnimationWindow animationWindow;

    public AnimationDisplayPanel(AnimationWindow animationWindow) {
        this.animationWindow = animationWindow;
        this.setBackground(Analysis.background);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                AnimationDisplayPanel.this.w = AnimationDisplayPanel.this.getSize().width;
                AnimationDisplayPanel.this.h = AnimationDisplayPanel.this.getSize().height;
                if (AnimationDisplayPanel.this.w > 0 && AnimationDisplayPanel.this.h > 0) {
                    AnimationDisplayPanel.this.offscreen = AnimationDisplayPanel.this.createImage(AnimationDisplayPanel.this.w, AnimationDisplayPanel.this.h);
                    AnimationDisplayPanel.this.numcols = (int)Math.sqrt(AnimationDisplayPanel.this.numPs) - (int)(Math.sqrt(AnimationDisplayPanel.this.numPs) % 5.0);
                    if (AnimationDisplayPanel.this.numcols == 0) {
                        AnimationDisplayPanel.this.numcols = Math.min(AnimationDisplayPanel.this.numPs, 10);
                    }
                    AnimationDisplayPanel.this.numrows = (int)Math.ceil((double)AnimationDisplayPanel.this.numPs / (double)AnimationDisplayPanel.this.numcols);
                    AnimationDisplayPanel.this.pwidth = Math.min(AnimationDisplayPanel.this.w / AnimationDisplayPanel.this.numcols, AnimationDisplayPanel.this.h / AnimationDisplayPanel.this.numrows);
                    AnimationDisplayPanel.this.pheight = AnimationDisplayPanel.this.pwidth;
                    AnimationDisplayPanel.this.hoffset = (AnimationDisplayPanel.this.w - AnimationDisplayPanel.this.numcols * AnimationDisplayPanel.this.pwidth) / 2;
                    AnimationDisplayPanel.this.voffset = (AnimationDisplayPanel.this.h - AnimationDisplayPanel.this.numrows * AnimationDisplayPanel.this.pheight) / 2;
                    AnimationDisplayPanel.this.phoffset = (int)((1.0f - AnimationDisplayPanel.this.psize) * (float)AnimationDisplayPanel.this.pwidth) / 2;
                    AnimationDisplayPanel.this.pvoffset = (int)((1.0f - AnimationDisplayPanel.this.psize) * (float)AnimationDisplayPanel.this.pheight) / 2;
                    AnimationDisplayPanel.this.clearScreen();
                }
                AnimationDisplayPanel.this.w = AnimationDisplayPanel.this.getSize().width;
                AnimationDisplayPanel.this.h = AnimationDisplayPanel.this.getSize().height;
            }
        });
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.colors = new Color[101];
        for (int i = 0; i <= 100; ++i) {
            this.colors[i] = Color.getHSBColor((float)((double)(100 - i) / 100.0) * this.MAXHUE, 1.0f, 1.0f);
        }
        this.setParameters();
    }

    private void clearScreen() {
        if (this.offscreen == null) {
            return;
        }
        Graphics graphics = this.offscreen.getGraphics();
        if (graphics != null) {
            graphics.clearRect(0, 0, this.w, this.h);
        }
        this.repaint();
    }

    public int getCurI() {
        return this.curI;
    }

    public int getNumI() {
        return this.numIs;
    }

    public Dimension getMinimumSize() {
        return new Dimension(150, 100);
    }

    public Dimension getPreferredSize() {
        return new Dimension(550, 400);
    }

    public void makeNextImage(Graphics graphics, int n) {
        int n2 = this.phoffset + this.hoffset;
        int n3 = this.pvoffset + this.voffset;
        int n4 = (int)((float)this.pwidth * this.psize);
        int n5 = (int)((float)this.pheight * this.psize);
        graphics.translate(n2, n3);
        if (this.font == null) {
            this.font = new Font("Times New Roman", 1, 12);
            graphics.setFont(this.font);
            this.fm = graphics.getFontMetrics(this.font);
        }
        int n6 = 0;
        block0: for (int i = 0; i < this.numrows; ++i) {
            for (int j = 0; j < this.numcols; ++j) {
                int n7;
                if ((n7 = this.data[n6++][n]) >= 0 && n7 <= 100) {
                    graphics.setColor(this.colors[n7]);
                    graphics.fillRect(j * this.pwidth, i * this.pheight, n4, n5);
                    if ((float)this.fm.stringWidth(String.valueOf(this.numPs)) <= this.fontOffset * (float)n4 && (float)this.fm.getHeight() <= this.fontOffset * (float)n5) {
                        graphics.setColor(Color.black);
                        graphics.drawString(String.valueOf(n6 - 1), j * this.pwidth + (n4 - this.fm.stringWidth(String.valueOf(n6 - 1))) / 2, i * this.pheight + (n5 + this.fm.getHeight()) / 2);
                    }
                }
                if (n6 >= this.numPs) continue block0;
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.pold = -1;
        this.animationWindow.setStatusInfo(-1, -1, -1);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.pwidth <= 0 || this.pheight <= 0) {
            return;
        }
        int n = (mouseEvent.getY() - this.voffset) / this.pheight;
        int n2 = (mouseEvent.getX() - this.hoffset) / this.pwidth;
        this.curP = n * this.numcols + n2;
        if (this.curP >= this.numPs || this.curP < 0 || n < 0 || n2 < 0 || n >= this.numrows || n2 >= this.numcols) {
            this.curP = -1;
        }
        if (this.curP != this.pold) {
            this.pold = this.curP;
            int n3 = 0;
            OrderedIntList orderedIntList = this.animationWindow.validPEs;
            orderedIntList.reset();
            for (int i = 0; i <= this.curP; ++i) {
                n3 = orderedIntList.nextElement();
            }
            if (this.curP >= 0 && this.curI != -1) {
                this.animationWindow.setStatusInfo(n3, this.curI, this.data[this.curP][this.curI]);
            } else {
                this.animationWindow.setStatusInfo(-1, -1, -1);
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void paint(Graphics graphics) {
        if (this.offscreen == null) {
            return;
        }
        if (this.curI != -1) {
            this.makeNextImage(this.offscreen.getGraphics(), this.curI);
        }
        graphics.drawImage(this.offscreen, 0, 0, null);
    }

    public void setCurI(int n) {
        this.curI = n % this.numIs;
        if (this.curI < 0) {
            this.curI += this.numIs;
        }
        if (this.curP >= 0 && this.curP < this.numPs) {
            this.animationWindow.setStatusInfo(this.curP, this.curI, this.data[this.curP][this.curI]);
        }
        this.repaint();
    }

    public void setParameters() {
        OrderedIntList orderedIntList = this.animationWindow.validPEs;
        this.numPs = orderedIntList.size();
        this.Isize = this.animationWindow.intervalSize;
        this.data = Analysis.getAnimationData(this.Isize, this.animationWindow.startTime, this.animationWindow.endTime, orderedIntList);
        this.numIs = this.data[0].length;
        if (this.numIs > 0) {
            this.curI = 0;
        }
        this.w = this.getSize().width;
        this.h = this.getSize().height;
        if (this.w > 0 && this.h > 0) {
            this.numcols = (int)Math.sqrt(this.numPs) - (int)(Math.sqrt(this.numPs) % 5.0);
            if (this.numcols == 0) {
                this.numcols = Math.min(this.numPs, 10);
            }
            this.numrows = (int)Math.ceil((double)this.numPs / (double)this.numcols);
            this.pheight = this.pwidth = Math.min(this.w / this.numcols, this.h / this.numrows);
            this.hoffset = (this.w - this.numcols * this.pwidth) / 2;
            this.voffset = (this.h - this.numrows * this.pheight) / 2;
            this.phoffset = (int)((1.0f - this.psize) * (float)this.pwidth) / 2;
            this.pvoffset = (int)((1.0f - this.psize) * (float)this.pheight) / 2;
            this.animationWindow.setTitleInfo(this.curI);
            this.clearScreen();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

