/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import projections.analysis.ColorSaver;
import projections.analysis.IntervalData;
import projections.analysis.LogLoader;
import projections.analysis.LogReader;
import projections.analysis.PoseDopReader;
import projections.analysis.ProjectionsConfigurationReader;
import projections.analysis.StsReader;
import projections.analysis.SumAnalyzer;
import projections.analysis.SumDetailReader;
import projections.analysis.UsageCalc;
import projections.analysis.ViewerEvent;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.SwingWorker;
import projections.guiUtils.ActivityManager;
import projections.misc.EntryNotFoundException;
import projections.misc.LogLoadException;
import projections.misc.SummaryFormatException;

public class Analysis {
    public static final int NUM_FILETYPES = 3;
    public static final int FTYPE_SUMMARY = 0;
    public static final int FTYPE_SUMDETAIL = 1;
    public static final int FTYPE_LOG = 2;
    public static Color background = Color.black;
    public static Color foreground = Color.white;
    public static Component guiRoot;
    public static ProjectionsConfigurationReader rcReader;
    private static StsReader sts;
    private static LogLoader logLoader;
    private static SumAnalyzer sumAnalyzer;
    private static SumDetailReader[] summaryDetails;
    private static PoseDopReader dopReader;
    private static IntervalData intervalData;
    public static ActivityManager activityManager;
    public static final int NUM_TYPES = 5;
    public static final int LOG = 0;
    public static final int SUMMARY = 1;
    public static final int COUNTER = 2;
    public static final int SUMDETAIL = 3;
    public static final int DOP = 4;
    private static String baseName;
    private static String logDirectory;
    private static boolean hasSum;
    private static boolean hasSumDetail;
    private static boolean hasSumAccumulated;
    private static boolean hasLog;
    private static boolean hasPoseDop;
    private static OrderedIntList[] validPEs;
    private static String[] validPEStrings;
    private static long totalTime;
    private static long poseTotalTime;
    private static long poseTotalVirtualTime;
    private static int[][][] systemUsageData;
    private static int[][][][] systemMsgsData;
    private static int[][][][] userEntryData;
    private static int[] bgData;
    private static long logReaderIntervalSize;
    private static Color[] entryColors;
    private static Color[] grayColors;
    private static Color[] userEventColors;
    private static Color[] grayUserEventColors;
    private static Color[] activeColorMap;
    private static Color[] activeUserColorMap;
    private static Color[] functionColors;
    private static Color[] universalColors;
    private static long jStartTime;
    private static long jEndTime;
    private static boolean jTimeAvailable;

    private static void splitUniversalColors() {
        int n;
        int n2 = sts.getEntryCount();
        entryColors = new Color[n2];
        for (n = 0; n < n2; ++n) {
            Analysis.entryColors[n] = universalColors[n];
        }
        n = sts.getNumFunctionEvents();
        functionColors = new Color[n];
        for (int i = 0; i < n; ++i) {
            Analysis.functionColors[i] = universalColors[i + n2];
        }
    }

    public static void initAnalysis(String string, Component component) throws IOException {
        Object object;
        guiRoot = component;
        activityManager = new ActivityManager();
        try {
            baseName = Analysis.getBaseName(string);
            logDirectory = Analysis.dirFromFile(string);
            sts = new StsReader(string);
            rcReader = new ProjectionsConfigurationReader(Analysis.getFilename(), Analysis.getLogDirectory());
            Analysis.detectFiles();
            object = Analysis.getLogDirectory() + File.separator + "savedcolors.prj";
            ColorSaver.setLocation((String)object);
            if (new File((String)object).exists()) {
                try {
                    universalColors = ColorSaver.loadColors();
                    Analysis.splitUniversalColors();
                }
                catch (IOException iOException) {
                    System.err.println("Failed to load colors!!!");
                    universalColors = Analysis.createColorMap(sts.getEntryCount() + sts.getNumFunctionEvents());
                    Analysis.splitUniversalColors();
                }
            } else {
                universalColors = Analysis.createColorMap(sts.getEntryCount() + sts.getNumFunctionEvents());
                Analysis.splitUniversalColors();
            }
            grayColors = Analysis.createGrayscaleColorMap(sts.getEntryCount());
            userEventColors = Analysis.createColorMap(sts.getNumUserDefinedEvents());
            grayUserEventColors = Analysis.createGrayscaleColorMap(sts.getNumUserDefinedEvents());
            activeColorMap = entryColors;
            activeUserColorMap = userEventColors;
        }
        catch (LogLoadException logLoadException) {
            throw new IOException(logLoadException.toString());
        }
        if (Analysis.hasSumAccumulatedFile()) {
            sumAnalyzer = null;
            sumAnalyzer = new SumAnalyzer(sts, 0);
            Analysis.setTotalTime(sumAnalyzer.GetTotalTime());
        }
        if (Analysis.hasSumFiles()) {
            try {
                sumAnalyzer = null;
                sumAnalyzer = new SumAnalyzer();
                Analysis.setTotalTime(sumAnalyzer.GetTotalTime());
            }
            catch (SummaryFormatException summaryFormatException) {
                System.err.println(summaryFormatException.toString());
            }
        }
        if (Analysis.hasSumDetailFiles() || Analysis.hasLogFiles()) {
            if (intervalData == null) {
                intervalData = new IntervalData();
            }
            Analysis.setTotalTime((long)((double)intervalData.getNumIntervals() * intervalData.getIntervalSize() * 1000000.0));
        }
        if (Analysis.hasLogFiles()) {
            logLoader = new LogLoader();
        }
        if (Analysis.hasPoseDopFiles()) {
            dopReader = new PoseDopReader();
            object = new SwingWorker(){

                public Object construct() {
                    poseTotalTime = dopReader.getTotalRealTime();
                    poseTotalVirtualTime = dopReader.getTotalVirtualTime();
                    return null;
                }

                public void finished() {
                }
            };
            ((SwingWorker)object).start();
        }
    }

    public static Vector createTL(int n, long l, long l2, Vector vector, Vector vector2) {
        try {
            if (Analysis.hasLogFiles()) {
                if (logLoader == null) {
                    logLoader = new LogLoader();
                }
                return logLoader.createtimeline(n, l, l2, vector, vector2);
            }
            System.err.println("createTL: No log files available!");
            return null;
        }
        catch (LogLoadException logLoadException) {
            System.err.println("LOG LOAD EXCEPTION");
            return null;
        }
    }

    public static void createAMPIUsage(int n, long l, long l2, Vector vector) {
        try {
            if (Analysis.hasLogFiles()) {
                if (logLoader == null) {
                    logLoader = new LogLoader();
                }
                logLoader.createAMPIUsageProfile(n, l, l2, vector);
            } else {
                System.err.println("createAMPIUsage: No log files available!");
            }
        }
        catch (LogLoadException logLoadException) {
            System.err.println("LOG LOAD EXCEPTION");
        }
    }

    public static void createAMPITimeProfile(int n, long l, long l2, Vector vector) {
        try {
            if (Analysis.hasLogFiles()) {
                if (logLoader == null) {
                    logLoader = new LogLoader();
                }
                logLoader.createAMPIFuncTimeProfile(n, l, l2, vector);
            } else {
                System.err.println("createAMPIUsage: No log files available!");
            }
        }
        catch (LogLoadException logLoadException) {
            System.err.println("LOG LOAD EXCEPTION");
        }
    }

    public static int[][] getAnimationData(long l, long l2, long l3, OrderedIntList orderedIntList) {
        if (l >= l3 - l2) {
            l = l3 - l2;
        }
        int n = (int)(l2 / l);
        int n2 = (int)(l3 / l);
        int n3 = orderedIntList.size();
        Analysis.LoadGraphData(l, n, n2 - 1, false, null);
        int[][] nArray = new int[n3][n2 - n];
        int n4 = orderedIntList.nextElement();
        int n5 = 0;
        while (n4 != -1) {
            for (int i = 0; i < n2 - n; ++i) {
                nArray[n5][i] = Analysis.getSystemUsageData(1)[n4][i];
            }
            n4 = orderedIntList.nextElement();
            ++n5;
        }
        return nArray;
    }

    public static String[][] getLogFileText(int n) {
        if (!Analysis.hasLogFiles()) {
            return null;
        }
        Vector vector = null;
        try {
            if (logLoader == null) {
                logLoader = new LogLoader();
            }
            vector = logLoader.view(n);
        }
        catch (LogLoadException logLoadException) {
            System.err.println("Failed to load Log files");
            return null;
        }
        if (vector == null) {
            return null;
        }
        int n2 = vector.size();
        if (n2 == 0) {
            return null;
        }
        String[][] stringArray = new String[n2][2];
        block14: for (int i = 0; i < n2; ++i) {
            ViewerEvent viewerEvent = (ViewerEvent)vector.elementAt(i);
            stringArray[i][0] = "" + viewerEvent.Time;
            switch (viewerEvent.EventType) {
                case 1: {
                    stringArray[i][1] = "CREATE message to be sent to " + viewerEvent.Dest;
                    continue block14;
                }
                case 2: {
                    stringArray[i][1] = "BEGIN PROCESSING of message sent to " + viewerEvent.Dest;
                    String[] stringArray2 = stringArray[i];
                    stringArray2[1] = stringArray2[1] + " from processor " + viewerEvent.SrcPe;
                    continue block14;
                }
                case 3: {
                    stringArray[i][1] = "END PROCESSING of message sent to " + viewerEvent.Dest;
                    String[] stringArray3 = stringArray[i];
                    stringArray3[1] = stringArray3[1] + " from processor " + viewerEvent.SrcPe;
                    continue block14;
                }
                case 4: {
                    stringArray[i][1] = "ENQUEUEING message received from processor " + viewerEvent.SrcPe + " destined for " + viewerEvent.Dest;
                    continue block14;
                }
                case 14: {
                    stringArray[i][1] = "IDLE begin";
                    continue block14;
                }
                case 15: {
                    stringArray[i][1] = "IDLE end";
                    continue block14;
                }
                case 16: {
                    stringArray[i][1] = "BEGIN PACKING a message to be sent";
                    continue block14;
                }
                case 17: {
                    stringArray[i][1] = "FINISHED PACKING a message to be sent";
                    continue block14;
                }
                case 18: {
                    stringArray[i][1] = "BEGIN UNPACKING a received message";
                    continue block14;
                }
                case 19: {
                    stringArray[i][1] = "FINISHED UNPACKING a received message";
                    continue block14;
                }
                default: {
                    stringArray[i][1] = "!!!! ADD EVENT TYPE " + viewerEvent.EventType + " !!!";
                }
            }
        }
        return stringArray;
    }

    public static int getNumPhases() {
        if (sumAnalyzer != null) {
            return sumAnalyzer.GetPhaseCount();
        }
        return 0;
    }

    public static int[][] getSystemMsgsData(int n, int n2) {
        return systemMsgsData[n][n2];
    }

    public static int[][] getSystemUsageData(int n) {
        return systemUsageData[n];
    }

    public static long getTotalTime() {
        return totalTime;
    }

    public static void setTotalTime(long l) {
        totalTime = l;
    }

    public static long getPoseTotalTime() {
        return poseTotalTime;
    }

    public static long getPoseTotalVirtualTime() {
        return poseTotalVirtualTime;
    }

    public static PoseDopReader getPoseDopReader() {
        return dopReader;
    }

    public static long getLogReaderIntervalSize() {
        return logReaderIntervalSize;
    }

    public static double[] getSummaryAverageData() {
        return sumAnalyzer.getSummaryAverageData();
    }

    public static long getSummaryIntervalSize() {
        return sumAnalyzer.getIntervalSize();
    }

    public static Color getEntryColor(int n) {
        if (n < sts.getEntryCount()) {
            return activeColorMap[n];
        }
        return null;
    }

    public static void setEntryColor(int n, Color color) {
        if (n < sts.getEntryCount()) {
            Analysis.activeColorMap[n] = color;
        } else {
            System.err.println("Warning: entry point index " + n + " not found. Cannot set color");
        }
    }

    public static float[][] GetUsageData(int n, long l, long l2, OrderedIntList orderedIntList) {
        long[][] lArray;
        if (Analysis.hasLogFiles()) {
            UsageCalc usageCalc = new UsageCalc();
            return usageCalc.usage(n, l, l2, Analysis.getVersion());
        }
        int n2 = sts.getEntryCount();
        if (sumAnalyzer.GetPhaseCount() > 1) {
            orderedIntList.reset();
            lArray = sumAnalyzer.GetPhaseChareTime(orderedIntList.nextElement());
            if (orderedIntList.hasMoreElements()) {
                while (orderedIntList.hasMoreElements() && n > -1) {
                    long[][] lArray2 = sumAnalyzer.GetPhaseChareTime(orderedIntList.nextElement());
                    for (int i = 0; i < n2; ++i) {
                        long[] lArray3 = lArray[n];
                        int n3 = i;
                        lArray3[n3] = lArray3[n3] + lArray2[n][i];
                    }
                }
            }
        } else {
            lArray = sumAnalyzer.GetChareTime();
        }
        float[][] fArray = new float[2][n2 + 4];
        double d = 100.0 / (double)Analysis.getTotalTime();
        for (int i = 0; i < n2; ++i) {
            fArray[0][i] = (float)(d * (double)lArray[n][i]);
            fArray[1][i] = 0.0f;
        }
        return fArray;
    }

    public static int[][] getUserEntryData(int n, int n2) {
        return userEntryData[n][n2];
    }

    public static boolean hasSystemMsgsData(int n, int n2) {
        if (systemMsgsData == null) {
            return false;
        }
        return null != systemMsgsData[n][n2];
    }

    public static boolean hasUserEntryData(int n, int n2) {
        if (userEntryData == null) {
            return false;
        }
        if (userEntryData[n][n2] == null) {
            return false;
        }
        for (int i = 0; i < Analysis.getNumProcessors(); ++i) {
            if (userEntryData[n][n2][i] == null) continue;
            return true;
        }
        return false;
    }

    public static int[] getBGData() {
        return bgData;
    }

    public static void LoadGraphData(long l, int n, int n2, boolean bl, OrderedIntList orderedIntList) {
        if (Analysis.hasLogFiles()) {
            LogReader logReader = new LogReader();
            logReader.read(l, n, n2, bl, orderedIntList);
            systemUsageData = logReader.getSystemUsageData();
            systemMsgsData = logReader.getSystemMsgs();
            userEntryData = logReader.getUserEntries();
            logReaderIntervalSize = logReader.getIntervalSize();
            logReader = null;
        } else if (Analysis.hasSumDetailFiles()) {
            if (Analysis.hasSumFiles()) {
                Analysis.loadSummaryData(l, n, n2);
            }
        } else if (Analysis.hasSumFiles()) {
            Analysis.loadSummaryData(l, n, n2);
        } else {
            System.err.println("Error: No data Files found!!");
        }
    }

    public static void loadSummaryData(long l, int n, int n2) {
        systemUsageData = new int[3][][];
        try {
            Analysis.systemUsageData[1] = sumAnalyzer.GetSystemUsageData(n, n2, l);
        }
        catch (SummaryFormatException summaryFormatException) {
            System.err.println("Caught SummaryFormatException");
        }
        catch (IOException iOException) {
            System.err.println("Caught IOExcpetion");
        }
    }

    public static void loadSummaryData(int n, int n2) {
        Analysis.loadSummaryData(sumAnalyzer.getIntervalSize(), n, n2);
    }

    public static void loadSummaryData() {
        if (Analysis.hasSumFiles()) {
            int n = (int)sumAnalyzer.getIntervalSize();
            int n2 = (int)(Analysis.getTotalTime() / (long)n);
            Analysis.loadSummaryData(n, 0, n2 - 1);
        } else if (Analysis.hasSumAccumulatedFile()) {
            // empty if block
        }
    }

    public static double[][] getSumDetailData(int n, int n2) {
        return intervalData.getData(n, n2);
    }

    public static long searchTimeline(int n, int n2, int n3) throws EntryNotFoundException {
        try {
            if (Analysis.hasLogFiles()) {
                if (logLoader == null) {
                    logLoader = new LogLoader();
                }
                return logLoader.searchtimeline(n2, n3, n);
            }
            System.err.println("No log files!");
            return -1L;
        }
        catch (LogLoadException logLoadException) {
            System.err.println("LogLoadException");
            return -1L;
        }
    }

    public static double getVersion() {
        if (sts == null) {
            return MainWindow.CUR_VERSION;
        }
        return sts.getVersion();
    }

    public static boolean hasSummaryData() {
        return Analysis.hasSumFiles() || Analysis.hasSumAccumulatedFile();
    }

    public static boolean hasLogData() {
        return Analysis.hasLogFiles();
    }

    public static boolean hasSumDetailData() {
        return Analysis.hasSumDetailFiles();
    }

    public static boolean hasPoseDopData() {
        return Analysis.hasPoseDopFiles();
    }

    public static String getLogDirectory() {
        return logDirectory;
    }

    public static String getFilename() {
        return baseName;
    }

    public static String getLogName(int n) {
        return baseName + "." + n + ".log";
    }

    public static String getSumName(int n) {
        return baseName + "." + n + ".sum";
    }

    public static String getSumAccumulatedName() {
        return baseName + ".sum";
    }

    public static String getSumDetailName(int n) {
        return baseName + "." + n + ".sumd";
    }

    public static String getPoseDopName(int n) {
        return baseName + "." + n + ".poselog";
    }

    public static int getNumProcessors() {
        return sts.getProcessorCount();
    }

    public static int getNumUserEntries() {
        return sts.getEntryCount();
    }

    public static String[][] getEntryNames() {
        return sts.getEntryNames();
    }

    public static String getEntryName(int n) {
        return sts.getEntryNames()[n][0];
    }

    public static String getEntryChareName(int n) {
        return sts.getEntryNames()[n][1];
    }

    public static int getNumUserDefinedEvents() {
        return sts.getNumUserDefinedEvents();
    }

    public static int getUserDefinedEventIndex(int n) {
        return sts.getUserEventIndex(n);
    }

    public static String getUserEventName(int n) {
        return sts.getUserEventName(n);
    }

    public static String[] getUserEventNames() {
        return sts.getUserEventNames();
    }

    public static int getNumPerfCounts() {
        return sts.getNumPerfCounts();
    }

    public static String[] getPerfCountNames() {
        return sts.getPerfCountNames();
    }

    public static int getNumFunctionEvents() {
        return sts.getNumFunctionEvents();
    }

    public static Color getFunctionColor(int n) {
        return functionColors[sts.getFunctionEventIndex(n)];
    }

    public static Color[] getFunctionColors() {
        return functionColors;
    }

    public static String getFunctionName(int n) {
        return sts.getFunctionEventDescriptor(n);
    }

    public static String[] getFunctionNames() {
        return sts.getFunctionEventDescriptors();
    }

    public static int getNumIntervals() {
        if (intervalData == null) {
            System.err.println("No interval based data. Call to getNumIntervals is invalid.");
            return -1;
        }
        return intervalData.getNumIntervals();
    }

    public static double getIntervalSize() {
        if (intervalData == null) {
            System.err.println("No interval based data. Call to getIntervalSize is invalid.");
            return -1.0;
        }
        return intervalData.getIntervalSize();
    }

    public static Color getUserEventColor(int n) {
        if (sts != null) {
            return userEventColors[sts.getUserEventIndex(n)];
        }
        return null;
    }

    public static double[][] getDataSummedAcrossProcessors(int n, OrderedIntList orderedIntList, int n2, int n3) {
        return intervalData.getDataSummedAcrossProcessors(n, orderedIntList, n2, n3);
    }

    public static Vector getDataSummedAcrossProcessors(int n, OrderedIntList orderedIntList, int n2, int n3, OrderedIntList orderedIntList2) {
        return intervalData.getDataSummedAcrossProcessors(n, orderedIntList, n2, n3, orderedIntList2);
    }

    public static String getValidProcessorString() {
        if (Analysis.hasLogFiles()) {
            return Analysis.getValidProcessorString(0);
        }
        if (Analysis.hasSumFiles()) {
            return Analysis.getValidProcessorString(1);
        }
        if (Analysis.hasSumDetailFiles()) {
            return Analysis.getValidProcessorString(3);
        }
        if (Analysis.hasPoseDopFiles()) {
            return Analysis.getValidProcessorString(4);
        }
        return "";
    }

    public static OrderedIntList getValidProcessorList() {
        if (Analysis.hasLogFiles()) {
            return Analysis.getValidProcessorList(0);
        }
        if (Analysis.hasSumFiles()) {
            return Analysis.getValidProcessorList(1);
        }
        if (Analysis.hasSumDetailFiles()) {
            return Analysis.getValidProcessorList(3);
        }
        if (Analysis.hasPoseDopFiles()) {
            return Analysis.getValidProcessorList(4);
        }
        return null;
    }

    public static String getValidProcessorString(int n) {
        switch (n) {
            case 0: {
                if (hasLog) break;
                System.err.println("Warning: No log files.");
                break;
            }
            case 1: {
                if (hasSum) break;
                System.err.println("Warning: No summary files.");
                break;
            }
            case 3: {
                if (hasSumDetail) break;
                System.err.println("Warning: No summary detail files.");
                break;
            }
            case 4: {
                if (hasPoseDop) break;
                System.err.println("Warning: No poselog files found.");
            }
        }
        return validPEStrings[n];
    }

    public static OrderedIntList getValidProcessorList(int n) {
        switch (n) {
            case 0: {
                if (hasLog) break;
                System.err.println("Warning: No log files.");
                break;
            }
            case 1: {
                if (hasSum) break;
                System.err.println("Warning: No summary files.");
                break;
            }
            case 3: {
                if (hasSumDetail) break;
                System.err.println("Warning: No summary detail files.");
                break;
            }
            case 4: {
                if (hasPoseDop) break;
                System.err.println("Warning: No poselog files found.");
            }
        }
        return validPEs[n];
    }

    public static Color[] getColorMap() {
        return activeColorMap;
    }

    public static void setFullColor() {
        activeColorMap = entryColors;
        activeUserColorMap = userEventColors;
    }

    public static void setGrayscale() {
        activeColorMap = grayColors;
        activeUserColorMap = grayUserEventColors;
    }

    public static Color[] createGrayscaleColorMap(int n) {
        Color[] colorArray = new Color[n];
        float f = 1.0f;
        float f2 = 0.0f;
        float f3 = 0.9f;
        float f4 = (float)(0.8 / (double)n);
        for (int i = 0; i < n; ++i) {
            colorArray[i] = Color.getHSBColor(f, f2, f3);
            if (!((double)(f3 -= f4) < 0.1)) continue;
            f3 = 0.1f;
        }
        return colorArray;
    }

    public static Color[] createColorMap(int n) {
        Color[] colorArray = new Color[n];
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = (float)(1.0 / (double)n);
        for (int i = 0; i < n; ++i) {
            colorArray[i] = Color.getHSBColor(f, f2, f3);
            if (!((double)(f -= f4) < 0.0)) continue;
            f = 1.0f;
        }
        return colorArray;
    }

    public static Color[] createColorMap(int n, int[] nArray) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        if (n2 > 0) {
            int n3 = 2;
            int n4 = 7;
            nArray2[n2 - 1] = 5;
            for (int i = n2 - 2; i >= 0; --i) {
                nArray2[i] = nArray2[i + 1] + n4;
                n4 += n3;
            }
        }
        return Analysis.createColorMap(n, nArray, nArray2);
    }

    public static Color[] createColorMap(int n, int[] nArray, int[] nArray2) {
        Color[] colorArray = new Color[n];
        int n2 = nArray.length;
        if (n2 == 0) {
            return Analysis.createColorMap(n);
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += nArray2[i];
        }
        double d = (double)nArray2[n2 - 1] / (double)n3;
        int n4 = n - n2;
        double d2 = 1.0 / (d * (double)n4 + 1.0);
        if (d2 < 0.67) {
            d2 = 0.67;
        }
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        for (int i = 0; i < n2; ++i) {
            colorArray[nArray[i]] = Color.getHSBColor((float)d3, (float)d4, (float)d5);
            d3 -= (double)nArray2[i] / (double)n3 * d2;
        }
        double d6 = d3 / (double)n4;
        for (int i = 0; i < n; ++i) {
            if (colorArray[i] != null) continue;
            colorArray[i] = Color.getHSBColor((float)d3, (float)d4, (float)d5);
            d3 -= d6;
        }
        return colorArray;
    }

    public static void setJTimeAvailable(boolean bl) {
        jTimeAvailable = bl;
    }

    public static boolean checkJTimeAvailable() {
        return jTimeAvailable;
    }

    public static void setJTime(long l, long l2) {
        jStartTime = l;
        jEndTime = l2;
    }

    public static long getJStart() {
        return jStartTime;
    }

    public static long getJEnd() {
        return jEndTime;
    }

    public static boolean hasPapi() {
        return sts.hasPapi();
    }

    private static void detectFiles() {
        int n;
        hasLog = false;
        hasSum = false;
        hasSumDetail = false;
        hasSumAccumulated = false;
        hasPoseDop = false;
        validPEs = new OrderedIntList[5];
        validPEStrings = new String[5];
        for (n = 0; n < 5; ++n) {
            Analysis.validPEs[n] = new OrderedIntList();
        }
        for (n = 0; n < sts.getProcessorCount(); ++n) {
            if (new File(Analysis.getSumName(n)).isFile()) {
                hasSum = true;
                validPEs[1].insert(n);
            }
            if (new File(Analysis.getSumDetailName(n)).isFile()) {
                hasSumDetail = true;
                validPEs[3].insert(n);
            }
            if (new File(Analysis.getLogName(n)).isFile()) {
                hasLog = true;
                validPEs[0].insert(n);
            }
            if (!new File(Analysis.getPoseDopName(n)).isFile()) continue;
            hasPoseDop = true;
            validPEs[4].insert(n);
        }
        for (n = 0; n < 5; ++n) {
            Analysis.validPEStrings[n] = validPEs[n].listToString();
        }
        if (new File(Analysis.getSumAccumulatedName()).isFile()) {
            hasSumAccumulated = true;
        }
    }

    private static boolean hasLogFiles() {
        return hasLog;
    }

    private static boolean hasSumFiles() {
        return hasSum;
    }

    private static boolean hasSumAccumulatedFile() {
        return hasSumAccumulated;
    }

    private static boolean hasSumDetailFiles() {
        return hasSumDetail;
    }

    private static boolean hasPoseDopFiles() {
        return hasPoseDop;
    }

    private static String getBaseName(String string) {
        String string2 = null;
        if (string.endsWith(".sum.sts")) {
            string2 = string.substring(0, string.length() - 8);
        } else if (string.endsWith(".sts")) {
            string2 = string.substring(0, string.length() - 4);
        } else {
            System.err.println("Invalid sts filename! Exiting ...");
            System.exit(-1);
        }
        return string2;
    }

    private static String dirFromFile(String string) {
        int n = string.lastIndexOf(File.separator);
        if (n != -1) {
            return string.substring(0, n);
        }
        return ".";
    }

    static {
        totalTime = 0L;
        poseTotalTime = 0L;
        poseTotalVirtualTime = 0L;
        logReaderIntervalSize = -1L;
    }
}

