/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import java.io.IOException;
import projections.analysis.ProjDefs;
import projections.analysis.ProjectionsFormatException;

public abstract class ProjectionsReader
extends ProjDefs {
    private boolean available;
    protected String expectedVersion = null;
    protected String sourceString;

    public ProjectionsReader(String string, String string2) {
        this.expectedVersion = string2;
        this.sourceString = string;
        this.available = this.checkAvailable();
        if (this.available) {
            try {
                this.readStaticData();
            }
            catch (ProjectionsFormatException projectionsFormatException) {
                System.err.println("Format Exception when reading from source [" + string + "]");
                System.err.println(projectionsFormatException.toString());
                System.err.println("Data is now marked as unavailable.");
                this.available = false;
            }
            catch (IOException iOException) {
                System.err.println("Unexpected IO error when reading from source [" + string + "]");
                System.err.println("Data is now marked as unavailable.");
                this.available = false;
            }
        }
    }

    public ProjectionsReader(String string) {
        this(string, null);
    }

    protected abstract boolean checkAvailable();

    public final boolean isAvailable() {
        return this.available;
    }

    protected final void markUnavailable() {
        this.available = false;
    }

    protected abstract void readStaticData() throws IOException;

    public abstract void reset() throws IOException;
}

