/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.graph;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import projections.gui.Bubble;
import projections.gui.MainWindow;
import projections.gui.graph.DataSource;
import projections.gui.graph.DataSource2D;
import projections.gui.graph.XAxis;
import projections.gui.graph.XAxisFixed;
import projections.gui.graph.YAxis;
import projections.gui.graph.YAxisAuto;

public class Graph
extends JPanel
implements MouseInputListener {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    public static final int STACKED = 0;
    public static final int UNSTACKED = 1;
    public static final int AREA = 2;
    public static final int SINGLE = 3;
    public static final int BAR = 4;
    public static final int LINE = 5;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    private int GraphType;
    private boolean GraphStacked;
    private DataSource dataSource;
    private XAxis xAxis;
    private YAxis yAxis;
    private int originX;
    private int originY;
    private double xscale;
    private double yscale;
    private static final int FONT_SIZE = 12;
    private static final double PI = Math.PI;
    private Font font = null;
    private FontMetrics fm = null;
    double pixelincrementX;
    double pixelincrementY;
    double tickIncrementX;
    double tickIncrementY;
    long valuesPerTickX;
    long valuesPerLabelX;
    long valuesPerTickY;
    long valuesPerLabelY;
    private double barWidth;
    private double[][] stackArray;
    private double maxSumY;
    private int width;
    private int w;
    private int h;
    private int baseWidth = -1;
    private int baseHeight = -1;
    private double maxvalueX;
    private double maxvalueY;
    private Bubble bubble;
    private int bubbleXVal;
    private int bubbleYVal;

    public Graph() {
        this.setPreferredSize(new Dimension(400, 300));
        this.GraphType = 4;
        this.GraphStacked = true;
        this.stackArray = null;
        this.dataSource = null;
        this.xscale = 1.0;
        this.yscale = 1.0;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public Graph(DataSource d, XAxis x, YAxis y) {
        this();
        this.xAxis = x;
        this.yAxis = y;
        this.dataSource = d;
        this.createStackArray();
    }

    public Dimension getMinimumSize() {
        return new Dimension(400, 300);
    }

    public void setGraphType(int type) {
        if (type == 5 || type == 4) {
            this.GraphType = type;
            this.repaint();
        } else if (type == 2) {
            this.GraphType = type;
            this.repaint();
        }
    }

    public int getGraphType() {
        return this.GraphType;
    }

    public void setStackGraph(boolean isSet) {
        this.GraphStacked = isSet;
        this.repaint();
    }

    public void setData(DataSource d, XAxis x, YAxis y) {
        this.xAxis = x;
        this.yAxis = y;
        this.dataSource = d;
        this.createStackArray();
        this.repaint();
    }

    public void setData(DataSource d) {
        this.dataSource = d;
        this.createStackArray();
        this.repaint();
    }

    public void setScaleX(double val) {
        this.xscale = val;
        this.setPreferredSize(new Dimension((int)((double)this.baseWidth * this.xscale), (int)((double)this.baseHeight * this.yscale)));
        this.revalidate();
        this.repaint();
    }

    public void setScaleY(double val) {
        this.yscale = val;
        this.setPreferredSize(new Dimension((int)((double)this.baseWidth * this.xscale), (int)((double)this.baseHeight * this.yscale)));
        this.revalidate();
        this.repaint();
    }

    private void createStackArray() {
        if (this.dataSource != null) {
            double tempMax = 0.0;
            int numY = this.dataSource.getValueCount();
            this.stackArray = new double[this.dataSource.getIndexCount()][];
            for (int k = 0; k < this.dataSource.getIndexCount(); ++k) {
                this.stackArray[k] = new double[numY];
                this.dataSource.getValues(k, this.stackArray[k]);
                for (int j = 1; j < numY; ++j) {
                    double[] dArray = this.stackArray[k];
                    int n = j;
                    dArray[n] = dArray[n] + this.stackArray[k][j - 1];
                }
                if (this.stackArray == null || this.stackArray.length <= k || this.stackArray[k] == null || numY - 1 < 0 || this.stackArray[k].length <= numY - 1 || !(tempMax < this.stackArray[k][numY - 1])) continue;
                tempMax = this.stackArray[k][numY - 1];
            }
            this.maxSumY = tempMax;
        } else {
            this.stackArray = null;
        }
    }

    private int getXValue(int xPos) {
        if (xPos > this.originX && xPos < this.width + this.originX) {
            int displacement = xPos - this.originX;
            int expectedValue = (int)((double)displacement / this.pixelincrementX);
            int x1 = this.originX + (int)((double)expectedValue * this.pixelincrementX) + (int)(this.pixelincrementX / 2.0);
            if ((this.GraphType == 4 || this.GraphType == 2) && (double)xPos > (double)x1 - this.barWidth / 2.0 && (double)xPos < (double)x1 + this.barWidth / 2.0) {
                return expectedValue;
            }
        }
        return -1;
    }

    private int getYValue(int xVal, int yPos) {
        if (xVal >= 0 && yPos < this.originY && yPos > 30 && this.stackArray != null) {
            int numY = this.dataSource.getValueCount();
            for (int k = 0; k < numY; ++k) {
                int y = this.originY - (int)(this.stackArray[xVal][k] * this.pixelincrementY);
                if (yPos <= y) continue;
                return k;
            }
        }
        return -1;
    }

    public void paint(Graphics g) {
        if (this.font == null) {
            this.font = new Font("Times New Roman", 1, 12);
            g.setFont(this.font);
            this.fm = g.getFontMetrics(this.font);
        }
        this.drawDisplay(g);
    }

    public void print(Graphics pg) {
        if (this.font == null) {
            this.font = new Font("Times New Roman", 1, 12);
            pg.setFont(this.font);
            this.fm = pg.getFontMetrics(this.font);
        }
        Color oldBackground = MainWindow.runObject[this.myRun].background;
        Color oldForeground = MainWindow.runObject[this.myRun].foreground;
        MainWindow.runObject[this.myRun].background = Color.white;
        MainWindow.runObject[this.myRun].foreground = Color.black;
        this.drawDisplay(pg);
        MainWindow.runObject[this.myRun].background = oldBackground;
        MainWindow.runObject[this.myRun].foreground = oldForeground;
    }

    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int xVal = this.getXValue(x);
        int yVal = this.getYValue(xVal, y);
        if (xVal > -1 || yVal > -1) {
            this.toolClickResponse(e, xVal, yVal);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int xVal = this.getXValue(x);
        int yVal = this.getYValue(xVal, y);
        if (xVal > -1 && yVal > -1) {
            this.showPopup(xVal, yVal, x, y);
        } else if (this.bubble != null) {
            this.bubble.setVisible(false);
            this.bubble.dispose();
            this.bubble = null;
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    private Point getBubbleOffset() {
        Container c = this;
        int xOffset = c.getLocation().x;
        int yOffset = c.getLocation().y;
        while ((c = c.getParent()) != null) {
            xOffset += c.getLocation().x;
            yOffset += c.getLocation().y;
        }
        return new Point(xOffset, yOffset);
    }

    public void showPopup(int xVal, int yVal, int xPos, int yPos) {
        Point offset = this.getBubbleOffset();
        String[] text = this.dataSource.getPopup(xVal, yVal);
        if (text == null) {
            return;
        }
        if (this.bubble != null && (this.bubbleXVal != xVal || this.bubbleYVal != yVal)) {
            this.bubble.setVisible(false);
            this.bubble.dispose();
            this.bubble = null;
        }
        if (this.bubble == null && this.GraphStacked) {
            this.bubble = new Bubble(this, text);
            this.bubble.setLocation(xPos + offset.x, yPos + offset.y);
            this.bubble.setVisible(true);
            this.bubbleXVal = xVal;
            this.bubbleYVal = yVal;
        }
    }

    public void toolClickResponse(MouseEvent e, int xVal, int yVal) {
        this.dataSource.toolClickResponse(e, xVal, yVal);
    }

    private void drawDisplay(Graphics _g) {
        Graphics2D g = (Graphics2D)_g;
        g.setBackground(MainWindow.runObject[this.myRun].background);
        g.setColor(MainWindow.runObject[this.myRun].foreground);
        this.w = this.getWidth();
        this.h = this.getHeight();
        g.clearRect(0, 0, this.w, this.h);
        if (this.dataSource == null) {
            return;
        }
        int xOffset = 0;
        int yOffset = 0;
        this.baseWidth = this.getParent().getWidth();
        this.baseHeight = this.getParent().getHeight();
        String title = this.xAxis.getTitle();
        g.drawString(title, (this.w - this.fm.stringWidth(title)) / 2 + xOffset, this.h - 10 + yOffset);
        title = this.dataSource.getTitle();
        g.drawString(title, (this.w - this.fm.stringWidth(title)) / 2 + xOffset, 10 + this.fm.getHeight() + yOffset);
        title = this.yAxis.getTitle();
        g.rotate(-1.5707963267948966);
        g.drawString(title, -(this.h + this.fm.stringWidth(title)) / 2 + yOffset, this.fm.getHeight() + xOffset);
        g.rotate(1.5707963267948966);
        this.maxvalueX = this.dataSource.getIndexCount();
        this.maxvalueY = this.GraphType == 4 && this.GraphStacked || this.GraphType == 5 && this.GraphStacked || this.GraphType == 2 ? this.maxSumY : this.yAxis.getMax();
        this.originX = this.fm.getHeight() * 2 + this.fm.stringWidth("" + (long)this.maxvalueY);
        this.originY = this.h - (30 + this.fm.getHeight() * 2);
        if (this.xAxis != null && this.yAxis != null) {
            this.drawXAxis(g);
            this.drawYAxis(g);
            if (this.GraphType == 4) {
                this.drawBarGraph(g);
            } else if (this.GraphType == 2) {
                this.drawAreaGraph(g);
            } else {
                this.drawLineGraph(g);
            }
        }
    }

    private void drawXAxis(Graphics2D g) {
        this.width = (int)((double)(this.baseWidth - 30 - this.originX) * this.xscale);
        this.pixelincrementX = (double)this.width / this.maxvalueX;
        this.setBestIncrements(0, this.pixelincrementX, (int)this.maxvalueX);
        g.drawLine(this.originX, this.originY, this.width + this.originX, this.originY);
        int mini = 0;
        int maxi = (int)this.maxvalueX;
        int i = mini;
        while (i < maxi) {
            int curx = this.originX + (int)((double)i * this.pixelincrementX);
            if (this.valuesPerTickX == 1L) {
                curx += (int)(this.tickIncrementX / 2.0);
            }
            if ((long)i % this.valuesPerLabelX == 0L) {
                g.drawLine(curx, this.originY + 5, curx, this.originY - 5);
                String s = this.xAxis.getIndexName(i);
                g.drawString(s, curx - this.fm.stringWidth(s) / 2, this.originY + 10 + this.fm.getHeight());
            } else {
                g.drawLine(curx, this.originY + 2, curx, this.originY - 2);
            }
            i = (int)((long)i + this.valuesPerTickX);
        }
    }

    private void drawYAxis(Graphics2D g) {
        g.drawLine(this.originX, this.originY, this.originX, 30);
        this.pixelincrementY = (double)(this.originY - 30) / this.maxvalueY;
        this.setBestIncrements(1, this.pixelincrementY, (long)this.maxvalueY);
        int sw = this.fm.getHeight();
        long i = 0L;
        while ((double)i <= this.maxvalueY) {
            int cury = this.originY - (int)((double)i * this.pixelincrementY);
            if (i % this.valuesPerLabelY == 0L) {
                g.drawLine(this.originX + 5, cury, this.originX - 5, cury);
                String yLabel = "" + i;
                g.drawString(yLabel, this.originX - this.fm.stringWidth(yLabel) - 5, cury + sw / 2);
            } else {
                g.drawLine(this.originX + 2, cury, this.originX - 2, cury);
            }
            i += this.valuesPerTickY;
        }
    }

    private void drawBarGraph(Graphics2D g) {
        int numX = this.dataSource.getIndexCount();
        int numY = this.dataSource.getValueCount();
        double[] data = new double[numY];
        this.barWidth = this.valuesPerTickX == 1L && this.tickIncrementX >= 3.0 ? 0.8 * this.tickIncrementX : 1.0;
        for (int i = 0; i < numX; ++i) {
            int k;
            this.dataSource.getValues(i, data);
            if (this.GraphStacked) {
                int y = 0;
                for (int k2 = 0; k2 < numY; ++k2) {
                    y = this.originY - (int)(this.stackArray[i][k2] * this.pixelincrementY);
                    g.setColor(this.dataSource.getColor(k2));
                    if (this.valuesPerTickX == 1L) {
                        g.fillRect(this.originX + (int)((double)i * this.pixelincrementX + this.tickIncrementX / 2.0 - this.barWidth / 2.0), y, (int)this.barWidth, (int)(data[k2] * this.pixelincrementY));
                        continue;
                    }
                    g.fillRect(this.originX + (int)((double)i * this.pixelincrementX), y, (int)((double)(i + 1) * this.pixelincrementX) - (int)((double)i * this.pixelincrementX), (int)(data[k2] * this.pixelincrementY));
                }
                continue;
            }
            int maxIndex = 0;
            int y = 0;
            double maxValue = 0.0;
            double[][] temp = new double[numY][2];
            for (k = 0; k < numY; ++k) {
                temp[k][0] = k;
                temp[k][1] = data[k];
            }
            for (k = 0; k < numY; ++k) {
                maxValue = temp[k][1];
                maxIndex = k;
                for (int j = k; j < numY; ++j) {
                    if (!(temp[j][1] > maxValue)) continue;
                    maxIndex = j;
                    maxValue = temp[j][1];
                }
                int t = (int)temp[k][0];
                double t2 = temp[k][1];
                temp[k][0] = temp[maxIndex][0];
                temp[k][1] = maxValue;
                temp[maxIndex][0] = t;
                temp[maxIndex][1] = t2;
            }
            for (k = 0; k < numY; ++k) {
                g.setColor(this.dataSource.getColor((int)temp[k][0]));
                y = this.originY - (int)(temp[k][1] * this.pixelincrementY);
                if (this.valuesPerTickX == 1L) {
                    g.fillRect(this.originX + (int)((double)i * this.pixelincrementX + this.tickIncrementX / 2.0 - this.barWidth / 2.0), y, (int)this.barWidth, (int)(temp[k][1] * this.pixelincrementY));
                    continue;
                }
                g.fillRect(this.originX + (int)((double)i * this.pixelincrementX), y, (int)((double)(i + 1) * this.pixelincrementX) - (int)((double)i * this.pixelincrementX), (int)(temp[k][1] * this.pixelincrementY));
            }
        }
    }

    public void drawLineGraph(Graphics2D g) {
        int i;
        int xValues = this.dataSource.getIndexCount();
        int yValues = this.dataSource.getValueCount();
        double[] data = new double[yValues];
        int x1 = -1;
        int[] y1 = new int[yValues];
        int x2 = 0;
        int[] y2 = new int[yValues];
        for (i = 0; i < yValues; ++i) {
            y1[i] = -1;
        }
        for (i = 0; i < xValues; ++i) {
            if (this.GraphStacked) {
                data = this.stackArray[i];
            } else {
                this.dataSource.getValues(i, data);
            }
            x2 = this.originX + (int)((double)i * this.pixelincrementX) + (int)(this.pixelincrementX / 2.0);
            for (int j = 0; j < yValues; ++j) {
                g.setColor(this.dataSource.getColor(j));
                y2[j] = this.originY - (int)(data[j] * this.pixelincrementY);
                if (x1 != -1) {
                    g.drawLine(x1, y1[j], x2, y2[j]);
                }
                y1[j] = y2[j];
            }
            x1 = x2;
        }
    }

    public void drawAreaGraph(Graphics2D g) {
        int xValues = this.dataSource.getIndexCount();
        int yValues = this.dataSource.getValueCount();
        double[] data = new double[yValues];
        Polygon polygon = new Polygon();
        for (int layer = yValues - 1; layer >= 0; --layer) {
            polygon = new Polygon();
            int offsetY = -2;
            for (int idx = 0; idx < xValues; ++idx) {
                this.dataSource.getValues(idx, data);
                int xPixel = this.originX + (int)((double)idx * this.pixelincrementX) + (int)(this.pixelincrementX / 2.0);
                this.prefixSum(data);
                int yPixel = this.originY - (int)(data[layer] * this.pixelincrementY) + offsetY;
                if (idx == 0) {
                    polygon.addPoint(xPixel, this.originY + offsetY);
                }
                polygon.addPoint(xPixel, yPixel);
                if (idx != xValues - 1) continue;
                polygon.addPoint(xPixel, this.originY + offsetY);
            }
            g.setColor(this.dataSource.getColor(layer));
            g.fill(polygon);
            g.setColor(Color.black);
            g.draw(polygon);
        }
    }

    private void prefixSum(double[] data) {
        for (int i = 0; i < data.length - 1; ++i) {
            data[i + 1] = data[i + 1] + data[i];
        }
    }

    private void setBestIncrements(int axis, double pixelsPerValue, long maxValue) {
        long index = 0L;
        long labelValue = this.getNextLabelValue(index);
        long tickValue = this.getNextTickValue(index++);
        int labelWidth = 0;
        while (true) {
            if ((double)(labelWidth = axis == 0 ? this.fm.stringWidth(this.xAxis.getIndexName((int)(maxValue - 1L))) : this.fm.getHeight()) > pixelsPerValue * (double)labelValue * 0.8) {
                labelValue = this.getNextLabelValue(index);
                tickValue = this.getNextTickValue(index++);
                continue;
            }
            if (!(pixelsPerValue * (double)tickValue < 2.0)) break;
            labelValue = this.getNextLabelValue(index);
            tickValue = this.getNextTickValue(index++);
        }
        if (axis == 0) {
            this.tickIncrementX = (double)tickValue * pixelsPerValue;
            this.valuesPerTickX = tickValue;
            this.valuesPerLabelX = labelValue;
        } else if (axis == 1) {
            this.tickIncrementY = (double)tickValue * pixelsPerValue;
            this.valuesPerTickY = tickValue;
            this.valuesPerLabelY = labelValue;
        }
    }

    private long getNextLabelValue(long prevIndex) {
        if (prevIndex == 0L) {
            return 1L;
        }
        if (prevIndex % 2L == 0L) {
            return (long)Math.pow(10.0, prevIndex / 2L);
        }
        return (long)Math.pow(10.0, (prevIndex + 1L) / 2L) / 2L;
    }

    private long getNextTickValue(long prevIndex) {
        if (prevIndex == 0L) {
            return 1L;
        }
        return (long)Math.pow(10.0, (prevIndex - 1L) / 2L);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        JPanel mainPanel = new JPanel();
        double[][] data = new double[][]{{20.0, 21.0, 49.0, 3.0}, {25.0, 34.0, 8.0, 10.0}, {23.0, 20.0, 54.0, 3.0}, {20.0, 27.0, 4.0, 40.0}, {25.0, 21.0, 7.0, 4.0}, {20.0, 21.0, 8.0, 10.0}, {24.0, 26.0, 44.0, 4.0}, {22.0, 26.0, 20.0, 5.0}, {29.0, 29.0, 5.0, 20.0}, {20.0, 21.0, 8.0, 7.0}, {24.0, 20.0, 10.0, 3.0}, {21.0, 25.0, 6.0, 8.0}, {34.0, 23.0, 11.0, 11.0}, {20.0, 20.0, 20.0, 20.0}, {27.0, 25.0, 4.0, 5.0}, {21.0, 20.0, 5.0, 7.0}, {21.0, 24.0, 5.0, 8.0}, {26.0, 22.0, 5.0, 3.0}, {26.0, 29.0, 7.0, 10.0}, {29.0, 20.0, 8.0, 6.0}, {21.0, 24.0, 9.0, 4.0}};
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        DataSource2D ds = new DataSource2D("Histogram", data);
        XAxisFixed xa = new XAxisFixed("Entry Point Execution Time", "ms");
        YAxisAuto ya = new YAxisAuto("Count", "", ds);
        Graph g = new Graph();
        g.setGraphType(2);
        g.setData(ds, xa, ya);
        mainPanel.add(g);
        f.getContentPane().add(mainPanel);
        f.pack();
        f.setSize(500, 400);
        f.setTitle("Projections");
        f.setVisible(true);
    }
}

