/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JOptionPane;
import projections.gui.MainWindow;
import projections.gui.ProjectionsWindow;
import projections.gui.Timeline.AxisLayout;
import projections.gui.Timeline.AxisOverlayPanel;
import projections.gui.Timeline.AxisPanel;
import projections.gui.Timeline.Data;
import projections.gui.Timeline.LabelPanel;
import projections.gui.Timeline.LayeredPanel;
import projections.gui.Timeline.MainHandler;
import projections.gui.Timeline.MainPanel;
import projections.gui.Timeline.ScrollingPanel;
import projections.gui.Timeline.WindowControls;

public class TimelineWindow
extends ProjectionsWindow
implements MainHandler {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    public ScrollingPanel scrollingPanel;
    public LabelPanel labelPanel;
    public LayeredPanel axisPanel;
    public MainPanel mainPanel;
    public WindowControls controls;
    TimelineWindow thisWindow = this;
    Data data = new Data(this);

    public void refreshDisplay(boolean doRevalidate) {
        if (this.data.selectionValid()) {
            this.controls.setSelectedTime(this.data.leftSelectionTime(), this.data.rightSelectionTime());
        } else {
            this.controls.unsetSelectedTime();
        }
        if (this.data.highlightValid()) {
            this.controls.setHighlightTime(this.data.getHighlightTime());
        } else {
            this.controls.unsetHighlightTime();
        }
        this.controls.updateScaleField();
        this.scrollingPanel.refreshDisplay(doRevalidate);
    }

    public TimelineWindow(MainWindow parentWindow, Integer myWindowID) {
        super(parentWindow, myWindowID);
        this.data.guiRoot(this);
        this.labelPanel = new LabelPanel(this.data);
        AxisPanel ap = new AxisPanel(this.data);
        AxisOverlayPanel op = new AxisOverlayPanel(this.data);
        AxisLayout lay = new AxisLayout(this.data, ap);
        this.axisPanel = new LayeredPanel(this.data, ap, op, lay);
        this.mainPanel = new MainPanel(this.data, this);
        this.scrollingPanel = new ScrollingPanel(this.data, this.mainPanel, this.axisPanel, this.labelPanel);
        this.controls = new WindowControls(this, this.data);
        this.thisWindow.getContentPane().setLayout(new BorderLayout());
        this.thisWindow.getContentPane().add((Component)this.scrollingPanel, "Center");
        this.thisWindow.getContentPane().add((Component)this.controls, "South");
        this.setTitle("Projections Timelines - " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.controls.CreateMenus();
        this.showDialog();
    }

    protected void showWindow() {
    }

    protected void showDialog() {
        this.controls.showDialog();
    }

    public void setData(Data data) {
        this.controls.userEventWindowSetData();
    }

    protected void getDialogData() {
        this.data.setProcessorList(this.dialog.getValidProcessors());
        this.data.setRange(this.dialog.getStartTime(), this.dialog.getEndTime());
    }

    public void setDialogData() {
        this.dialog.setValidProcessors(this.data.processorList());
        this.dialog.setStartTime(this.data.startTime());
        this.dialog.setEndTime(this.data.endTime());
        super.setDialogData();
    }

    protected void windowInit() {
        this.data = new Data(this);
        this.data.setProcessorList(MainWindow.runObject[this.myRun].getValidProcessorList());
        this.data.setRange(0L, MainWindow.runObject[this.myRun].getTotalTime());
    }

    public void notifyProcessorListHasChanged() {
        this.mainPanel.loadTimelineObjects(false, this);
    }

    public void addProcessor(int p) {
        this.data.addProcessor(p);
    }

    public void displayWarning(String message) {
        JOptionPane.showMessageDialog(this, message, "Warning", 2);
    }
}

