/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.BaseTest;

public class TestSets
extends BaseTest {
    protected boolean debug = false;

    public void testSeqDoesNotBecomeSet() throws Exception {
        String string = "grammar P;\na : C {System.out.println(input);} ;\nfragment A : '1' | '2';\nfragment B : '3' '4';\nC : A | B;\n";
        String string2 = this.execParser("P.g", string, "PParser", "PLexer", "a", "34", this.debug);
        TestSets.assertEquals((String)"34\n", (String)string2);
    }

    public void testParserSet() throws Exception {
        String string = "grammar T;\na : t=('x'|'y') {System.out.println($t.text);} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "x", this.debug);
        TestSets.assertEquals((String)"x\n", (String)string2);
    }

    public void testParserNotSet() throws Exception {
        String string = "grammar T;\na : t=~('x'|'y') 'z' {System.out.println($t.text);} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "zz", this.debug);
        TestSets.assertEquals((String)"z\n", (String)string2);
    }

    public void testParserNotToken() throws Exception {
        String string = "grammar T;\na : ~'x' 'z' {System.out.println(input);} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "zz", this.debug);
        TestSets.assertEquals((String)"zz\n", (String)string2);
    }

    public void testParserNotTokenWithLabel() throws Exception {
        String string = "grammar T;\na : t=~'x' 'z' {System.out.println($t.text);} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "zz", this.debug);
        TestSets.assertEquals((String)"z\n", (String)string2);
    }

    public void testRuleAsSet() throws Exception {
        String string = "grammar T;\na @after {System.out.println(input);} : 'a' | 'b' |'c' ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "b", this.debug);
        TestSets.assertEquals((String)"b\n", (String)string2);
    }

    public void testRuleAsSetAST() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : 'a' | 'b' |'c' ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "b", this.debug);
        TestSets.assertEquals((String)"b\n", (String)string2);
    }

    public void testNotChar() throws Exception {
        String string = "grammar T;\na : A {System.out.println($A.text);} ;\nA : ~'b' ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "x", this.debug);
        TestSets.assertEquals((String)"x\n", (String)string2);
    }

    public void testOptionalSingleElement() throws Exception {
        String string = "grammar T;\na : A? 'c' {System.out.println(input);} ;\nA : 'b' ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "bc", this.debug);
        TestSets.assertEquals((String)"bc\n", (String)string2);
    }

    public void testOptionalLexerSingleElement() throws Exception {
        String string = "grammar T;\na : A {System.out.println(input);} ;\nA : 'b'? 'c' ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "bc", this.debug);
        TestSets.assertEquals((String)"bc\n", (String)string2);
    }

    public void testStarLexerSingleElement() throws Exception {
        String string = "grammar T;\na : A {System.out.println(input);} ;\nA : 'b'* 'c' ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "bbbbc", this.debug);
        TestSets.assertEquals((String)"bbbbc\n", (String)string2);
        string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "c", this.debug);
        TestSets.assertEquals((String)"c\n", (String)string2);
    }

    public void testPlusLexerSingleElement() throws Exception {
        String string = "grammar T;\na : A {System.out.println(input);} ;\nA : 'b'+ 'c' ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "bbbbc", this.debug);
        TestSets.assertEquals((String)"bbbbc\n", (String)string2);
    }

    public void testOptionalSet() throws Exception {
        String string = "grammar T;\na : ('a'|'b')? 'c' {System.out.println(input);} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "ac", this.debug);
        TestSets.assertEquals((String)"ac\n", (String)string2);
    }

    public void testStarSet() throws Exception {
        String string = "grammar T;\na : ('a'|'b')* 'c' {System.out.println(input);} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abaac", this.debug);
        TestSets.assertEquals((String)"abaac\n", (String)string2);
    }

    public void testPlusSet() throws Exception {
        String string = "grammar T;\na : ('a'|'b')+ 'c' {System.out.println(input);} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abaac", this.debug);
        TestSets.assertEquals((String)"abaac\n", (String)string2);
    }

    public void testLexerOptionalSet() throws Exception {
        String string = "grammar T;\na : A {System.out.println(input);} ;\nA : ('a'|'b')? 'c' ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "ac", this.debug);
        TestSets.assertEquals((String)"ac\n", (String)string2);
    }

    public void testLexerStarSet() throws Exception {
        String string = "grammar T;\na : A {System.out.println(input);} ;\nA : ('a'|'b')* 'c' ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abaac", this.debug);
        TestSets.assertEquals((String)"abaac\n", (String)string2);
    }

    public void testLexerPlusSet() throws Exception {
        String string = "grammar T;\na : A {System.out.println(input);} ;\nA : ('a'|'b')+ 'c' ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "abaac", this.debug);
        TestSets.assertEquals((String)"abaac\n", (String)string2);
    }

    public void testNotCharSet() throws Exception {
        String string = "grammar T;\na : A {System.out.println($A.text);} ;\nA : ~('b'|'c') ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "x", this.debug);
        TestSets.assertEquals((String)"x\n", (String)string2);
    }

    public void testNotCharSetWithLabel() throws Exception {
        String string = "grammar T;\na : A {System.out.println($A.text);} ;\nA : h=~('b'|'c') ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "x", this.debug);
        TestSets.assertEquals((String)"x\n", (String)string2);
    }

    public void testNotCharSetWithRuleRef() throws Exception {
        String string = "grammar T;\na : A {System.out.println($A.text);} ;\nA : ~('a'|B) ;\nB : 'b' ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "x", this.debug);
        TestSets.assertEquals((String)"x\n", (String)string2);
    }

    public void testNotCharSetWithRuleRef2() throws Exception {
        String string = "grammar T;\na : A {System.out.println($A.text);} ;\nA : ~('a'|B) ;\nB : 'b'|'c' ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "x", this.debug);
        TestSets.assertEquals((String)"x\n", (String)string2);
    }

    public void testNotCharSetWithRuleRef3() throws Exception {
        String string = "grammar T;\na : A {System.out.println($A.text);} ;\nA : ('a'|B) ;\nfragment\nB : ~('a'|'c') ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "x", this.debug);
        TestSets.assertEquals((String)"x\n", (String)string2);
    }

    public void testNotCharSetWithRuleRef4() throws Exception {
        String string = "grammar T;\na : A {System.out.println($A.text);} ;\nA : ('a'|B) ;\nfragment\nB : ~('a'|C) ;\nfragment\nC : 'c'|'d' ;\n ";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "x", this.debug);
        TestSets.assertEquals((String)"x\n", (String)string2);
    }
}

