/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.antlr;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.taskdefs.Redirector;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.apache.tools.ant.util.LoaderUtils;
import org.apache.tools.ant.util.TeeOutputStream;

public class ANTLR3
extends Task {
    private CommandlineJava commandline = new CommandlineJava();
    private File target = null;
    private File outputDirectory = null;
    private File libDirectory = null;
    private File superGrammar;
    private boolean depend = false;
    private boolean fork;
    private String messageFormatName;
    private boolean diagnostic;
    private boolean trace;
    private boolean traceParser;
    private boolean traceLexer;
    private File workingdir = null;
    private ByteArrayOutputStream bos = new ByteArrayOutputStream();
    private boolean debug;
    private boolean report;
    private boolean print;
    private boolean profile;
    private boolean nfa;
    private boolean dfa;
    private boolean multiThreaded;
    private boolean nocollapse;
    private boolean noprune;
    private boolean dbgST;
    private boolean grammarTree;
    private FileUtils fileUtils;

    public ANTLR3() {
        this.commandline.setVm(JavaEnvUtils.getJreExecutable((String)"java"));
        this.commandline.setClassname("org.antlr.Tool");
        this.fileUtils = FileUtils.getFileUtils();
    }

    public void setTarget(File target) {
        this.log("Setting target to: " + target.toString(), 3);
        this.target = target;
    }

    public void setOutputdirectory(File outputDirectory) {
        this.log("Setting output directory to: " + outputDirectory.toString(), 3);
        this.outputDirectory = outputDirectory;
    }

    public File getOutputdirectory() {
        return this.outputDirectory;
    }

    public void setLibdirectory(File libDirectory) {
        this.log("Setting lib directory to: " + libDirectory.toString(), 3);
        this.libDirectory = libDirectory;
    }

    public void setMessageformat(String name) {
        this.log("Setting message-format to: " + name, 3);
        this.messageFormatName = name;
    }

    public void setGlib(File superGrammar) {
        this.superGrammar = superGrammar;
    }

    public void setDebug(boolean enable) {
        this.debug = enable;
    }

    public void setReport(boolean enable) {
        this.report = enable;
    }

    public void setPrint(boolean enable) {
        this.print = enable;
    }

    public void setProfile(boolean enable) {
        this.profile = enable;
    }

    public void setNfa(boolean enable) {
        this.nfa = enable;
    }

    public void setDfa(boolean enable) {
        this.dfa = enable;
    }

    public void setMultithreaded(boolean enable) {
        this.multiThreaded = enable;
    }

    public void setNocollapse(boolean enable) {
        this.nocollapse = enable;
    }

    public void setNoprune(boolean enable) {
        this.noprune = enable;
    }

    public void setDbgST(boolean enable) {
        this.dbgST = enable;
    }

    public void setGrammartree(boolean enable) {
        this.grammarTree = enable;
    }

    public void setDepend(boolean s) {
        this.depend = s;
    }

    public void setDiagnostic(boolean enable) {
        this.diagnostic = enable;
    }

    public void setTrace(boolean enable) {
        this.trace = enable;
    }

    public void setTraceParser(boolean enable) {
        this.traceParser = enable;
    }

    public void setTraceLexer(boolean enable) {
        this.traceLexer = enable;
    }

    public void setFork(boolean s) {
        this.fork = s;
    }

    public void setDir(File d) {
        this.workingdir = d;
    }

    public Path createClasspath() {
        return this.commandline.createClasspath(this.getProject()).createPath();
    }

    public Commandline.Argument createJvmarg() {
        return this.commandline.createVmArgument();
    }

    public void init() throws BuildException {
        this.addClasspathEntry("/antlr/ANTLRGrammarParseBehavior.class", "AntLR2");
        this.addClasspathEntry("/org/antlr/tool/ANTLRParser.class", "AntLR3");
        this.addClasspathEntry("/org/antlr/stringtemplate/StringTemplate.class", "Stringtemplate");
    }

    protected void addClasspathEntry(String resource, String msg) {
        resource = resource.startsWith("/") ? resource.substring(1) : "org/apache/tools/ant/taskdefs/optional/" + resource;
        File f = LoaderUtils.getResourceSource((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)resource);
        if (f != null) {
            this.log("Found " + f.getAbsolutePath(), 3);
            this.createClasspath().setLocation(f);
        } else {
            this.log("Couldn't find resource " + resource + " for library " + msg + " in external classpath", 3);
        }
    }

    public void execute() throws BuildException {
        this.validateAttributes();
        if (this.depend ? this.dependencyCheck() : this.checkGeneratedFile()) {
            this.populateAttributes();
            this.commandline.createArgument().setValue(this.target.toString());
            this.log(this.commandline.describeCommand(), 3);
            int err = 0;
            try {
                err = this.run(this.commandline.getCommandline(), (OutputStream)new LogOutputStream((Task)this, 2), (OutputStream)new LogOutputStream((Task)this, 1));
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e, this.getLocation());
            }
            finally {
                try {
                    this.bos.close();
                }
                catch (IOException e) {}
            }
            if (err != 0) {
                throw new BuildException("ANTLR returned: " + err, this.getLocation());
            }
            Pattern p = Pattern.compile("error\\([0-9]+\\):");
            Matcher m = p.matcher(this.bos.toString());
            if (m.find()) {
                throw new BuildException("ANTLR signaled an error.", this.getLocation());
            }
        } else {
            try {
                this.log("All dependencies of grammar file '" + this.target.getCanonicalPath() + "' are up to date.", 3);
            }
            catch (IOException ex) {
                this.log("All dependencies of grammar file '" + this.target.toString() + "' are up to date.", 3);
            }
        }
    }

    private void populateAttributes() {
        this.commandline.createArgument().setValue("-o");
        this.commandline.createArgument().setValue(this.outputDirectory.toString());
        this.commandline.createArgument().setValue("-lib");
        this.commandline.createArgument().setValue(this.libDirectory.toString());
        if (this.superGrammar != null) {
            this.log("Option 'glib' is not supported by ANTLR v3. Option ignored!", 1);
        }
        if (this.diagnostic) {
            this.commandline.createArgument().setValue("-diagnostic");
        }
        if (this.trace) {
            this.log("Option 'trace' is not supported by ANTLR v3. Option ignored!", 1);
        }
        if (this.traceParser) {
            this.log("Option 'traceParser' is not supported by ANTLR v3. Option ignored!", 1);
        }
        if (this.traceLexer) {
            this.log("Option 'traceLexer' is not supported by ANTLR v3. Option ignored!", 1);
        }
        if (this.debug) {
            this.commandline.createArgument().setValue("-debug");
        }
        if (this.report) {
            this.commandline.createArgument().setValue("-report");
        }
        if (this.print) {
            this.commandline.createArgument().setValue("-print");
        }
        if (this.profile) {
            this.commandline.createArgument().setValue("-profile");
        }
        if (this.messageFormatName != null) {
            this.commandline.createArgument().setValue("-message-format");
            this.commandline.createArgument().setValue(this.messageFormatName);
        }
        if (this.nfa) {
            this.commandline.createArgument().setValue("-nfa");
        }
        if (this.dfa) {
            this.commandline.createArgument().setValue("-dfa");
        }
        if (this.multiThreaded) {
            this.commandline.createArgument().setValue("-Xmultithreaded");
        }
        if (this.nocollapse) {
            this.commandline.createArgument().setValue("-Xnocollapse");
        }
        if (this.noprune) {
            this.commandline.createArgument().setValue("-Xnoprune");
        }
        if (this.dbgST) {
            this.commandline.createArgument().setValue("-XdbgST");
        }
        if (this.grammarTree) {
            this.commandline.createArgument().setValue("-Xgrtree");
        }
    }

    private void validateAttributes() throws BuildException {
        if (this.target == null) {
            throw new BuildException("No target grammar, lexer grammar or tree parser specified!");
        }
        if (!this.target.isFile()) {
            throw new BuildException("Target: " + this.target + " is not a file!");
        }
        if (this.outputDirectory == null) {
            this.setOutputdirectory(new File(this.target.getParent()));
        }
        if (!this.outputDirectory.isDirectory()) {
            throw new BuildException("Invalid output directory: " + this.outputDirectory);
        }
        if (this.workingdir != null && !this.workingdir.isDirectory()) {
            throw new BuildException("Invalid working directory: " + this.workingdir);
        }
        if (this.libDirectory == null) {
            this.setLibdirectory(new File(this.target.getParent()));
        }
        if (!this.libDirectory.isDirectory()) {
            throw new BuildException("Invalid lib directory: " + this.libDirectory);
        }
    }

    private boolean dependencyCheck() throws BuildException {
        CommandlineJava cmdline = null;
        try {
            cmdline = (CommandlineJava)this.commandline.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new BuildException("Clone of commandline failed: " + e);
        }
        cmdline.createArgument().setValue("-depend");
        cmdline.createArgument().setValue("-o");
        cmdline.createArgument().setValue(this.outputDirectory.toString());
        cmdline.createArgument().setValue("-lib");
        cmdline.createArgument().setValue(this.libDirectory.toString());
        cmdline.createArgument().setValue(this.target.toString());
        this.log(cmdline.describeCommand(), 3);
        Redirector r = new Redirector((Task)this);
        File f = null;
        try {
            f = File.createTempFile("depend", null, this.getOutputdirectory());
            f.deleteOnExit();
            this.log("Write dependencies for '" + this.target.toString() + "' to file '" + f.getCanonicalPath() + "'", 3);
            r.setOutput(f);
            r.setAlwaysLog(false);
            r.createStreams();
        }
        catch (IOException e) {
            throw new BuildException("Redirection of output failed: " + e);
        }
        int err = 0;
        try {
            err = this.run(cmdline.getCommandline(), r.getOutputStream(), null);
        }
        catch (IOException e) {
            try {
                r.complete();
                r = null;
                this.log("Redirection of output terminated.", 3);
            }
            catch (IOException ex) {
                this.log("Termination of output redirection failed: " + ex, 0);
            }
            throw new BuildException((Throwable)e, this.getLocation());
        }
        finally {
            try {
                this.bos.close();
            }
            catch (IOException e) {}
        }
        try {
            r.complete();
            r = null;
            this.log("Redirection of output terminated.", 3);
        }
        catch (IOException e) {
            this.log("Termination of output redirection failed: " + e, 0);
        }
        if (err != 0) {
            if (f.exists()) {
                f.delete();
            }
            if (cmdline.getClasspath() == null) {
                this.log("Antlr libraries not found in external classpath or embedded classpath statement ", 0);
            }
            throw new BuildException("ANTLR returned: " + err);
        }
        Pattern p = Pattern.compile("error\\([0-9]+\\):");
        Matcher m = p.matcher(this.bos.toString());
        if (m.find()) {
            if (f.exists()) {
                f.delete();
            }
            return true;
        }
        boolean compile = false;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(f));
        }
        catch (IOException e) {
            if (f.exists()) {
                f.delete();
            }
            try {
                throw new BuildException("Could not open '" + f.getCanonicalPath() + "' for reading.");
            }
            catch (IOException ex) {
                throw new BuildException("Could not open '" + f.toString() + "' for reading.");
            }
        }
        String s = null;
        try {
            while ((s = in.readLine()) != null) {
                String a = null;
                String b = null;
                int to = s.indexOf(": ");
                if (to < 0) continue;
                a = s.substring(0, to).trim();
                b = s.substring(to + ": ".length());
                this.log("File '" + a + "' depends on file '" + b + "'", 3);
                this.log("File '" + a + "' modified at " + new File(a).lastModified(), 3);
                this.log("File '" + b + "' modified at " + new File(b).lastModified(), 3);
                if (!this.fileUtils.isUpToDate(new File(a), new File(b))) continue;
                this.log("Compiling " + this.target + " as '" + b + "' is newer than '" + a + "'", 3);
                this.fileUtils.setFileLastModified(new File(a), -1L);
                this.log("Touching file '" + a + "'", 3);
                compile = true;
                break;
            }
            in.close();
        }
        catch (IOException e) {
            if (f.exists()) {
                f.delete();
            }
            throw new BuildException("Error reading file '" + f.toString() + "'");
        }
        if (f.exists()) {
            f.delete();
        }
        return compile;
    }

    private boolean checkGeneratedFile() throws BuildException {
        String generatedFileName = null;
        Pattern p = Pattern.compile("^\\p{javaWhitespace}*(grammar|lexer\\p{javaWhitespace}+grammar|tree\\p{javaWhitespace}+grammar|parser\\p{javaWhitespace}+grammar)\\p{javaWhitespace}+\\w+\\p{javaWhitespace}*;.*$", 130);
        Matcher m = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(this.target));
        }
        catch (IOException e) {
            throw new BuildException("Could not open file:" + this.target + " for reading!");
        }
        try {
            String line;
            while ((line = in.readLine()) != null) {
                m = p.matcher(line);
                this.log("Trying to match grammar in '" + line + "'", 3);
                if (!m.matches()) continue;
                String type = line.trim();
                type = type.startsWith("lexer") ? "Lexer" : (type.startsWith("tree") ? "" : "Parser");
                this.log("Matched '" + type + " grammar' in '" + line + "'", 3);
                p = Pattern.compile("^\\p{javaWhitespace}*(grammar|lexer\\p{javaWhitespace}+grammar|tree\\p{javaWhitespace}+grammar|parser\\p{javaWhitespace}+grammar)\\p{javaWhitespace}+", 130);
                m.usePattern(p);
                int startIndex = -1;
                if (!m.lookingAt()) continue;
                startIndex = m.end();
                this.log("Start index of grammar filename at position " + startIndex, 3);
                int extendsIndex = line.indexOf(";");
                this.log("End index of grammar filename at position " + extendsIndex, 3);
                generatedFileName = line.substring(startIndex, extendsIndex).trim() + type;
                this.log("Grammar file name extracted: '" + generatedFileName + "'", 3);
                break;
            }
        }
        catch (IOException e) {
            throw new BuildException("Unable to read from file: " + this.target, (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new BuildException("Could not close file: " + this.target + " after reading!", (Throwable)e);
            }
        }
        if (generatedFileName == null) {
            throw new BuildException("Unable to determine generated class");
        }
        File f = new File(this.outputDirectory, generatedFileName + ".java");
        this.log("Check if file '" + f.getName() + "' is older than" + this.target.getName(), 3);
        return !this.fileUtils.isUpToDate(this.target, f);
    }

    private int run(String[] command, OutputStream out, OutputStream err) throws IOException {
        PumpStreamHandler psh = null;
        psh = err == null ? new PumpStreamHandler(out, (OutputStream)this.bos) : new PumpStreamHandler(out, (OutputStream)new TeeOutputStream(err, (OutputStream)this.bos));
        Execute exe = new Execute((ExecuteStreamHandler)psh, null);
        exe.setAntRun(this.getProject());
        if (this.workingdir != null) {
            exe.setWorkingDirectory(this.workingdir);
        }
        exe.setCommandline(command);
        return exe.execute();
    }
}

