/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexFloatFFT;
import jnt.FFT.Factorize;

public class ComplexFloatFFT_Radix2
extends ComplexFloatFFT {
    static final int FORWARD = -1;
    static final int BACKWARD = 1;
    static final int DECINTIME = 0;
    static final int DECINFREQ = 1;
    private int logn;
    private int decimate = 0;

    public ComplexFloatFFT_Radix2(int n) {
        super(n);
        this.logn = Factorize.log2(n);
        if (this.logn < 0) {
            throw new Error(n + " is not a power of 2");
        }
    }

    public void setDecimateInTime() {
        this.decimate = 0;
    }

    public void setDecimateInFrequency() {
        this.decimate = 1;
    }

    public void transform(float[] data, int i0, int stride) {
        this.checkData(data, i0, stride);
        this.transform_internal(data, i0, stride, -1);
    }

    public void backtransform(float[] data, int i0, int stride) {
        this.checkData(data, i0, stride);
        this.transform_internal(data, i0, stride, 1);
    }

    void transform_internal(float[] data, int i0, int stride, int direction) {
        if (this.decimate == 1) {
            this.transform_DIF(data, i0, stride, direction);
        } else {
            this.transform_DIT(data, i0, stride, direction);
        }
    }

    void transform_DIT(float[] data, int i0, int stride, int direction) {
        if (this.n == 1) {
            return;
        }
        this.bitreverse(data, i0, stride);
        int bit = 0;
        int dual = 1;
        while (bit < this.logn) {
            float w_real = 1.0f;
            float w_imag = 0.0f;
            double theta = 2.0 * (double)direction * Math.PI / (2.0 * (double)dual);
            float s = (float)Math.sin(theta);
            float t = (float)Math.sin(theta / 2.0);
            float s2 = 2.0f * t * t;
            for (int b = 0; b < this.n; b += 2 * dual) {
                int i = i0 + b * stride;
                int j = i0 + (b + dual) * stride;
                float wd_real = data[j];
                float wd_imag = data[j + 1];
                data[j] = data[i] - wd_real;
                data[j + 1] = data[i + 1] - wd_imag;
                int n = i;
                data[n] = data[n] + wd_real;
                int n2 = i + 1;
                data[n2] = data[n2] + wd_imag;
            }
            for (int a = 1; a < dual; ++a) {
                float tmp_real = w_real - s * w_imag - s2 * w_real;
                float tmp_imag = w_imag + s * w_real - s2 * w_imag;
                w_real = tmp_real;
                w_imag = tmp_imag;
                for (int b = 0; b < this.n; b += 2 * dual) {
                    int i = i0 + (b + a) * stride;
                    int j = i0 + (b + a + dual) * stride;
                    float z1_real = data[j];
                    float z1_imag = data[j + 1];
                    float wd_real = w_real * z1_real - w_imag * z1_imag;
                    float wd_imag = w_real * z1_imag + w_imag * z1_real;
                    data[j] = data[i] - wd_real;
                    data[j + 1] = data[i + 1] - wd_imag;
                    int n = i;
                    data[n] = data[n] + wd_real;
                    int n3 = i + 1;
                    data[n3] = data[n3] + wd_imag;
                }
            }
            ++bit;
            dual *= 2;
        }
    }

    void transform_DIF(float[] data, int i0, int stride, int direction) {
        if (this.n == 1) {
            return;
        }
        int bit = 0;
        int dual = this.n / 2;
        while (bit < this.logn) {
            float w_real = 1.0f;
            float w_imag = 0.0f;
            double theta = 2.0 * (double)direction * Math.PI / (double)(2 * dual);
            float s = (float)Math.sin(theta);
            float t = (float)Math.sin(theta / 2.0);
            float s2 = 2.0f * t * t;
            for (int b = 0; b < dual; ++b) {
                for (int a = 0; a < this.n; a += 2 * dual) {
                    int i = i0 + (b + a) * stride;
                    int j = i0 + (b + a + dual) * stride;
                    float t1_real = data[i] + data[j];
                    float t1_imag = data[i + 1] + data[j + 1];
                    float t2_real = data[i] - data[j];
                    float t2_imag = data[i + 1] - data[j + 1];
                    data[i] = t1_real;
                    data[i + 1] = t1_imag;
                    data[j] = w_real * t2_real - w_imag * t2_imag;
                    data[j + 1] = w_real * t2_imag + w_imag * t2_real;
                }
                float tmp_real = w_real - s * w_imag - s2 * w_real;
                float tmp_imag = w_imag + s * w_real - s2 * w_imag;
                w_real = tmp_real;
                w_imag = tmp_imag;
            }
            ++bit;
            dual /= 2;
        }
        this.bitreverse(data, i0, stride);
    }

    protected void bitreverse(float[] data, int i0, int stride) {
        int j = 0;
        for (int i = 0; i < this.n - 1; ++i) {
            int ii = i0 + i * stride;
            int jj = i0 + j * stride;
            int k = this.n / 2;
            if (i < j) {
                float tmp_real = data[ii];
                float tmp_imag = data[ii + 1];
                data[ii] = data[jj];
                data[ii + 1] = data[jj + 1];
                data[jj] = tmp_real;
                data[jj + 1] = tmp_imag;
            }
            while (k <= j) {
                j -= k;
                k /= 2;
            }
            j += k;
        }
    }
}

