/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.gunit.GrammarInfo;
import org.antlr.gunit.gUnitTestInput;
import org.antlr.gunit.gUnitTestSuite;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;

public class JUnitCodeGen {
    public GrammarInfo grammarInfo;
    public Map<String, String> ruleWithReturn;
    private static final Handler console = new ConsoleHandler();
    private static final Logger logger = Logger.getLogger(JUnitCodeGen.class.getName());

    public JUnitCodeGen(GrammarInfo grammarInfo) throws ClassNotFoundException {
        Method[] methodArray;
        this.grammarInfo = grammarInfo;
        this.ruleWithReturn = new HashMap<String, String>();
        Class<?> clazz = grammarInfo.getHeader() != null ? Class.forName(grammarInfo.getHeader() + "." + grammarInfo.getGrammarName() + "Parser") : Class.forName(grammarInfo.getGrammarName() + "Parser");
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            if (method.getReturnType().getName().equals("void")) continue;
            this.ruleWithReturn.put(method.getName(), method.getReturnType().getName().replace('$', '.'));
        }
    }

    public void compile() throws IOException {
        String string = this.grammarInfo.getTreeGrammarName() != null ? "Test" + this.grammarInfo.getTreeGrammarName() : "Test" + this.grammarInfo.getGrammarName();
        String string2 = this.grammarInfo.getGrammarName() + "Lexer";
        String string3 = this.grammarInfo.getGrammarName() + "Parser";
        CommonGroupLoader commonGroupLoader = new CommonGroupLoader("org/antlr/gunit", null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
        StringTemplateGroup.registerDefaultLexer(DefaultTemplateLexer.class);
        StringBuffer stringBuffer = this.compileToBuffer(string, string2, string3);
        this.writeTestFile(".", string + ".java", stringBuffer.toString());
    }

    public StringBuffer compileToBuffer(String string, String string2, String string3) {
        StringTemplateGroup stringTemplateGroup = StringTemplateGroup.loadGroup((String)"junit");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.genClassHeader(stringTemplateGroup, string));
        stringBuffer.append(this.genTestRuleMethods(stringTemplateGroup));
        stringBuffer.append(this.genSupportingMethods(stringTemplateGroup, string2, string3));
        stringBuffer.append(stringTemplateGroup.getInstanceOf("examineParserExecResult").toString());
        stringBuffer.append("\n\n}");
        return stringBuffer;
    }

    protected String genClassHeader(StringTemplateGroup stringTemplateGroup, String string) {
        StringTemplate stringTemplate = stringTemplateGroup.getInstanceOf("classHeader");
        if (this.grammarInfo.getHeader() != null) {
            stringTemplate.setAttribute("header", (Object)("package " + this.grammarInfo.getHeader() + ";"));
        }
        stringTemplate.setAttribute("junitFileName", (Object)string);
        return stringTemplate.toString();
    }

    protected String genTestRuleMethods(StringTemplateGroup stringTemplateGroup) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.grammarInfo.getTreeGrammarName() != null) {
            for (gUnitTestSuite gUnitTestSuite2 : this.grammarInfo.getRuleTestSuites()) {
                int n = 0;
                for (gUnitTestInput gUnitTestInput2 : gUnitTestSuite2.testSuites.keySet()) {
                    String string;
                    String string2;
                    StringTemplate stringTemplate;
                    ++n;
                    if (gUnitTestSuite2.testSuites.get(gUnitTestInput2).getType() == 6 && this.ruleWithReturn.containsKey(gUnitTestSuite2.treeRule)) {
                        stringTemplate = stringTemplateGroup.getInstanceOf("testTreeRuleMethod2");
                        string2 = gUnitTestInput2.testInput.replace("\n", "\\n").replace("\t", "\\t");
                        string = gUnitTestSuite2.testSuites.get(gUnitTestInput2).getText();
                        stringTemplate.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(gUnitTestSuite2.treeRule) + "_walks_" + this.changeFirstCapital(gUnitTestSuite2.rule) + n));
                        stringTemplate.setAttribute("testTreeRuleName", (Object)('\"' + gUnitTestSuite2.treeRule + '\"'));
                        stringTemplate.setAttribute("testRuleName", (Object)('\"' + gUnitTestSuite2.rule + '\"'));
                        stringTemplate.setAttribute("testInput", (Object)('\"' + string2 + '\"'));
                        stringTemplate.setAttribute("returnType", (Object)this.ruleWithReturn.get(gUnitTestSuite2.treeRule));
                        stringTemplate.setAttribute("isFile", (Object)gUnitTestInput2.inputIsFile);
                        stringTemplate.setAttribute("expecting", (Object)string);
                    } else {
                        stringTemplate = stringTemplateGroup.getInstanceOf("testTreeRuleMethod");
                        string2 = gUnitTestInput2.testInput.replace("\n", "\\n").replace("\t", "\\t");
                        string = gUnitTestSuite2.testSuites.get(gUnitTestInput2).getText();
                        stringTemplate.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(gUnitTestSuite2.treeRule) + "_walks_" + this.changeFirstCapital(gUnitTestSuite2.rule) + n));
                        stringTemplate.setAttribute("testTreeRuleName", (Object)('\"' + gUnitTestSuite2.treeRule + '\"'));
                        stringTemplate.setAttribute("testRuleName", (Object)('\"' + gUnitTestSuite2.rule + '\"'));
                        stringTemplate.setAttribute("testInput", (Object)('\"' + string2 + '\"'));
                        stringTemplate.setAttribute("isFile", (Object)gUnitTestInput2.inputIsFile);
                        stringTemplate.setAttribute("tokenType", gUnitTestSuite2.testSuites.get(gUnitTestInput2).getType());
                        if (gUnitTestSuite2.testSuites.get(gUnitTestInput2).getType() == 6) {
                            stringTemplate.setAttribute("expecting", (Object)string);
                        } else if (gUnitTestSuite2.testSuites.get(gUnitTestInput2).getType() == 7) {
                            stringTemplate.setAttribute("expecting", (Object)string);
                        } else {
                            stringTemplate.setAttribute("expecting", (Object)('\"' + string.replace("\n", "\\n") + '\"'));
                        }
                    }
                    stringBuffer.append(stringTemplate.toString());
                }
            }
        } else {
            for (gUnitTestSuite gUnitTestSuite3 : this.grammarInfo.getRuleTestSuites()) {
                int n = 0;
                for (gUnitTestInput gUnitTestInput3 : gUnitTestSuite3.testSuites.keySet()) {
                    String string;
                    String string3;
                    StringTemplate stringTemplate;
                    ++n;
                    if (gUnitTestSuite3.testSuites.get(gUnitTestInput3).getType() == 6 && this.ruleWithReturn.containsKey(gUnitTestSuite3.rule)) {
                        stringTemplate = stringTemplateGroup.getInstanceOf("testRuleMethod2");
                        string3 = gUnitTestInput3.testInput.replace("\n", "\\n").replace("\t", "\\t");
                        string = gUnitTestSuite3.testSuites.get(gUnitTestInput3).getText();
                        stringTemplate.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(gUnitTestSuite3.rule) + n));
                        stringTemplate.setAttribute("testRuleName", (Object)('\"' + gUnitTestSuite3.rule + '\"'));
                        stringTemplate.setAttribute("testInput", (Object)('\"' + string3 + '\"'));
                        stringTemplate.setAttribute("returnType", (Object)this.ruleWithReturn.get(gUnitTestSuite3.rule));
                        stringTemplate.setAttribute("isFile", (Object)gUnitTestInput3.inputIsFile);
                        stringTemplate.setAttribute("expecting", (Object)string);
                    } else {
                        stringTemplate = stringTemplateGroup.getInstanceOf("testRuleMethod");
                        string3 = gUnitTestInput3.testInput.replace("\n", "\\n").replace("\t", "\\t");
                        string = gUnitTestSuite3.testSuites.get(gUnitTestInput3).getText();
                        stringTemplate.setAttribute("methodName", (Object)("test" + this.changeFirstCapital(gUnitTestSuite3.rule) + n));
                        stringTemplate.setAttribute("testRuleName", (Object)('\"' + gUnitTestSuite3.rule + '\"'));
                        stringTemplate.setAttribute("testInput", (Object)('\"' + string3 + '\"'));
                        stringTemplate.setAttribute("isFile", (Object)gUnitTestInput3.inputIsFile);
                        stringTemplate.setAttribute("tokenType", gUnitTestSuite3.testSuites.get(gUnitTestInput3).getType());
                        if (gUnitTestSuite3.testSuites.get(gUnitTestInput3).getType() == 6) {
                            stringTemplate.setAttribute("expecting", (Object)string);
                        } else if (gUnitTestSuite3.testSuites.get(gUnitTestInput3).getType() == 7) {
                            stringTemplate.setAttribute("expecting", (Object)string);
                        } else {
                            stringTemplate.setAttribute("expecting", (Object)('\"' + string.replace("\n", "\\n") + '\"'));
                        }
                    }
                    stringBuffer.append(stringTemplate.toString());
                }
            }
        }
        return stringBuffer.toString();
    }

    protected String genSupportingMethods(StringTemplateGroup stringTemplateGroup, String string, String string2) {
        StringTemplate stringTemplate;
        String string3;
        String string4;
        if (this.grammarInfo.getHeader() != null) {
            string4 = this.grammarInfo.getHeader() + "." + string2;
            string3 = this.grammarInfo.getHeader() + "." + this.grammarInfo.getTreeGrammarName();
        } else {
            string4 = string2;
            string3 = this.grammarInfo.getTreeGrammarName();
        }
        if (this.grammarInfo.getTreeGrammarName() != null) {
            stringTemplate = stringTemplateGroup.getInstanceOf("execTreeParser");
            stringTemplate.setAttribute("treeParserName", (Object)this.grammarInfo.getTreeGrammarName());
            stringTemplate.setAttribute("treeParserPath", (Object)string3);
        } else {
            stringTemplate = stringTemplateGroup.getInstanceOf("execParser");
        }
        stringTemplate.setAttribute("lexerName", (Object)string);
        stringTemplate.setAttribute("parserName", (Object)string2);
        stringTemplate.setAttribute("parserPath", (Object)string4);
        return stringTemplate.toString();
    }

    protected void writeTestFile(String string, String string2, String string3) {
        try {
            File file = new File(string, string2);
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(string3);
            bufferedWriter.close();
            fileWriter.close();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "can't write file", iOException);
        }
    }

    protected String changeFirstCapital(String string) {
        String string2 = String.valueOf(string.charAt(0));
        return string2.toUpperCase() + string.substring(1);
    }

    static {
        logger.addHandler(console);
    }
}

