
/* DEFS: message CkArrayElementMigrateMessage{
double packData[];
}
;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_CkArrayElementMigrateMessage::operator new(size_t s){
  return CkArrayElementMigrateMessage::alloc(__idx, s, 0, 0);
}
void *CMessage_CkArrayElementMigrateMessage::operator new(size_t s, int* sz){
  return CkArrayElementMigrateMessage::alloc(__idx, s, sz, 0);
}
void *CMessage_CkArrayElementMigrateMessage::operator new(size_t s, int* sz,const int pb){
  return CkArrayElementMigrateMessage::alloc(__idx, s, sz, pb);
}
void *CMessage_CkArrayElementMigrateMessage::operator new(size_t s, int sz0) {
  int sizes[1];
  sizes[0] = sz0;
  return CkArrayElementMigrateMessage::alloc(__idx, s, sizes, 0);
}
void *CMessage_CkArrayElementMigrateMessage::operator new(size_t s, int sz0, const int p) {
  int sizes[1];
  sizes[0] = sz0;
  return CkArrayElementMigrateMessage::alloc(__idx, s, sizes, p);
}
void* CMessage_CkArrayElementMigrateMessage::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  int offsets[2];
  offsets[0] = ALIGN8(sz);
  if(sizes==0)
    offsets[1] = offsets[0];
  else
    offsets[1] = offsets[0] + ALIGN8(sizeof(double)*sizes[0]);
  CkArrayElementMigrateMessage *newmsg = (CkArrayElementMigrateMessage *) CkAllocMsg(msgnum, offsets[1], pb);
  newmsg->packData = (double *) ((char *)newmsg + offsets[0]);
  return (void *) newmsg;
}
void* CMessage_CkArrayElementMigrateMessage::pack(CkArrayElementMigrateMessage *msg) {
  msg->packData = (double *) ((char *)msg->packData - (char *)msg);
  return (void *) msg;
}
CkArrayElementMigrateMessage* CMessage_CkArrayElementMigrateMessage::unpack(void* buf) {
  CkArrayElementMigrateMessage *msg = (CkArrayElementMigrateMessage *) buf;
  msg->packData = (double *) ((size_t)msg->packData + (char *)msg);
  return msg;
}
int CMessage_CkArrayElementMigrateMessage::__idx=0;
#endif

/* DEFS: group CkLocMgr: IrrGroup{
CkLocMgr(CkMigrateMessage* impl_msg);
CkLocMgr(const CkGroupID &map, const CkGroupID &_lbdb, const CkArrayIndexMax &numInitial);
void deliverInline(CkMessage* impl_msg);
void immigrate(CkArrayElementMigrateMessage* impl_msg);
void updateLocation(const CkArrayIndexMax &idx, int nowOnPe);
void reclaimRemote(const CkArrayIndexMax &idx, int deletedOnPe);
void dummyAtSync(void);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_CkLocMgr::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: CkLocMgr(CkMigrateMessage* impl_msg);
 */

/* DEFS: CkLocMgr(const CkGroupID &map, const CkGroupID &_lbdb, const CkArrayIndexMax &numInitial);
 */

/* DEFS: void deliverInline(CkMessage* impl_msg);
 */
void CProxyElement_CkLocMgr::deliverInline(CkMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkLocMgr::__idx_deliverInline_CkMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkLocMgr::__idx_deliverInline_CkMessage, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkLocMgr::__idx_deliverInline_CkMessage, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void immigrate(CkArrayElementMigrateMessage* impl_msg);
 */
void CProxyElement_CkLocMgr::immigrate(CkArrayElementMigrateMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkLocMgr::__idx_immigrate_CkArrayElementMigrateMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkLocMgr::__idx_immigrate_CkArrayElementMigrateMessage, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkLocMgr::__idx_immigrate_CkArrayElementMigrateMessage, impl_msg, ckGetGroupPe(), ckGetGroupID(),0+CK_MSG_EXPEDITED);
}

/* DEFS: void updateLocation(const CkArrayIndexMax &idx, int nowOnPe);
 */
void CProxyElement_CkLocMgr::updateLocation(const CkArrayIndexMax &idx, int nowOnPe, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkArrayIndexMax &idx, int nowOnPe
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)idx;
    implP|nowOnPe;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)idx;
    implP|nowOnPe;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkLocMgr::__idx_updateLocation_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkLocMgr::__idx_updateLocation_marshall4, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkLocMgr::__idx_updateLocation_marshall4, impl_msg, ckGetGroupPe(), ckGetGroupID(),0+CK_MSG_EXPEDITED);
}

/* DEFS: void reclaimRemote(const CkArrayIndexMax &idx, int deletedOnPe);
 */
void CProxyElement_CkLocMgr::reclaimRemote(const CkArrayIndexMax &idx, int deletedOnPe, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkArrayIndexMax &idx, int deletedOnPe
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)idx;
    implP|deletedOnPe;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)idx;
    implP|deletedOnPe;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkLocMgr::__idx_reclaimRemote_marshall5, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkLocMgr::__idx_reclaimRemote_marshall5, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkLocMgr::__idx_reclaimRemote_marshall5, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}

/* DEFS: void dummyAtSync(void);
 */
void CProxyElement_CkLocMgr::dummyAtSync(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkLocMgr::__idx_dummyAtSync_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupSend(ckDelegatedPtr(),CkIndex_CkLocMgr::__idx_dummyAtSync_void, impl_msg, ckGetGroupPe(), ckGetGroupID());
  } else CkSendMsgBranch(CkIndex_CkLocMgr::__idx_dummyAtSync_void, impl_msg, ckGetGroupPe(), ckGetGroupID(),0);
}
/* DEFS: CkLocMgr(CkMigrateMessage* impl_msg);
 */
 int CkIndex_CkLocMgr::__idx_CkLocMgr_CkMigrateMessage=0;
void CkIndex_CkLocMgr::_call_CkLocMgr_CkMigrateMessage(void* impl_msg,CkLocMgr * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) CkLocMgr((CkMigrateMessage*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}

/* DEFS: CkLocMgr(const CkGroupID &map, const CkGroupID &_lbdb, const CkArrayIndexMax &numInitial);
 */
CkGroupID CProxy_CkLocMgr::ckNew(const CkGroupID &map, const CkGroupID &_lbdb, const CkArrayIndexMax &numInitial, const CkEntryOptions *impl_e_opts)
{
  //Marshall: const CkGroupID &map, const CkGroupID &_lbdb, const CkArrayIndexMax &numInitial
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)map;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)_lbdb;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)numInitial;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)map;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)_lbdb;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)numInitial;
  }
  return CkCreateGroup(CkIndex_CkLocMgr::__idx, CkIndex_CkLocMgr::__idx_CkLocMgr_marshall1, impl_msg);
}
  CProxy_CkLocMgr::CProxy_CkLocMgr(const CkGroupID &map, const CkGroupID &_lbdb, const CkArrayIndexMax &numInitial, const CkEntryOptions *impl_e_opts)
{
  //Marshall: const CkGroupID &map, const CkGroupID &_lbdb, const CkArrayIndexMax &numInitial
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)map;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)_lbdb;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)numInitial;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)map;
    //Have to cast away const-ness to get pup routine
    implP|(CkGroupID &)_lbdb;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)numInitial;
  }
  ckSetGroupID(CkCreateGroup(CkIndex_CkLocMgr::__idx, CkIndex_CkLocMgr::__idx_CkLocMgr_marshall1, impl_msg));
}
 int CkIndex_CkLocMgr::__idx_CkLocMgr_marshall1=0;
void CkIndex_CkLocMgr::_call_CkLocMgr_marshall1(void* impl_msg,CkLocMgr * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const CkGroupID &map, const CkGroupID &_lbdb, const CkArrayIndexMax &numInitial*/
  PUP::fromMem implP(impl_buf);
  CkGroupID map; implP|map;
  CkGroupID _lbdb; implP|_lbdb;
  CkArrayIndexMax numInitial; implP|numInitial;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) CkLocMgr(map, _lbdb, numInitial);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}
int CkIndex_CkLocMgr::_callmarshall_CkLocMgr_marshall1(char* impl_buf,CkLocMgr * impl_obj) {
  /*Unmarshall pup'd fields: const CkGroupID &map, const CkGroupID &_lbdb, const CkArrayIndexMax &numInitial*/
  PUP::fromMem implP(impl_buf);
  CkGroupID map; implP|map;
  CkGroupID _lbdb; implP|_lbdb;
  CkArrayIndexMax numInitial; implP|numInitial;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) CkLocMgr(map, _lbdb, numInitial);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
  return implP.size();
}
void CkIndex_CkLocMgr::_marshallmessagepup_CkLocMgr_marshall1(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const CkGroupID &map, const CkGroupID &_lbdb, const CkArrayIndexMax &numInitial*/
  PUP::fromMem implP(impl_buf);
  CkGroupID map; implP|map;
  CkGroupID _lbdb; implP|_lbdb;
  CkArrayIndexMax numInitial; implP|numInitial;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("map");
  implDestP|map;
  if (implDestP.hasComments()) implDestP.comment("_lbdb");
  implDestP|_lbdb;
  if (implDestP.hasComments()) implDestP.comment("numInitial");
  implDestP|numInitial;
}

/* DEFS: void deliverInline(CkMessage* impl_msg);
 */
void CProxy_CkLocMgr::deliverInline(CkMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkLocMgr::__idx_deliverInline_CkMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkLocMgr::__idx_deliverInline_CkMessage, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkLocMgr::__idx_deliverInline_CkMessage, impl_msg, ckGetGroupID(),0);
}
    void CProxy_CkLocMgr::deliverInline(CkMessage* impl_msg, int npes, int *pes)
    {
      CkSendMsgBranchMulti(CkIndex_CkLocMgr::__idx_deliverInline_CkMessage, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_CkLocMgr::__idx_deliverInline_CkMessage=0;
void CkIndex_CkLocMgr::_call_deliverInline_CkMessage(void* impl_msg,CkLocMgr * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->deliverInline((CkMessage*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}

/* DEFS: void immigrate(CkArrayElementMigrateMessage* impl_msg);
 */
void CProxy_CkLocMgr::immigrate(CkArrayElementMigrateMessage* impl_msg)
{
  ckCheck();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkLocMgr::__idx_immigrate_CkArrayElementMigrateMessage, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkLocMgr::__idx_immigrate_CkArrayElementMigrateMessage, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkLocMgr::__idx_immigrate_CkArrayElementMigrateMessage, impl_msg, ckGetGroupID(),0+CK_MSG_EXPEDITED);
}
    void CProxy_CkLocMgr::immigrate(CkArrayElementMigrateMessage* impl_msg, int npes, int *pes)
    {
      CkSendMsgBranchMulti(CkIndex_CkLocMgr::__idx_immigrate_CkArrayElementMigrateMessage, impl_msg, npes, pes, ckGetGroupID(),0+CK_MSG_EXPEDITED);
    }
 int CkIndex_CkLocMgr::__idx_immigrate_CkArrayElementMigrateMessage=0;
void CkIndex_CkLocMgr::_call_immigrate_CkArrayElementMigrateMessage(void* impl_msg,CkLocMgr * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->immigrate((CkArrayElementMigrateMessage*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}

/* DEFS: void updateLocation(const CkArrayIndexMax &idx, int nowOnPe);
 */
void CProxy_CkLocMgr::updateLocation(const CkArrayIndexMax &idx, int nowOnPe, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkArrayIndexMax &idx, int nowOnPe
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)idx;
    implP|nowOnPe;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)idx;
    implP|nowOnPe;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkLocMgr::__idx_updateLocation_marshall4, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkLocMgr::__idx_updateLocation_marshall4, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkLocMgr::__idx_updateLocation_marshall4, impl_msg, ckGetGroupID(),0+CK_MSG_EXPEDITED);
}
    void CProxy_CkLocMgr::updateLocation(const CkArrayIndexMax &idx, int nowOnPe, int npes, int *pes, const CkEntryOptions *impl_e_opts)
    {
  //Marshall: const CkArrayIndexMax &idx, int nowOnPe
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)idx;
    implP|nowOnPe;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)idx;
    implP|nowOnPe;
  }
      CkSendMsgBranchMulti(CkIndex_CkLocMgr::__idx_updateLocation_marshall4, impl_msg, npes, pes, ckGetGroupID(),0+CK_MSG_EXPEDITED);
    }
 int CkIndex_CkLocMgr::__idx_updateLocation_marshall4=0;
void CkIndex_CkLocMgr::_call_updateLocation_marshall4(void* impl_msg,CkLocMgr * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const CkArrayIndexMax &idx, int nowOnPe*/
  PUP::fromMem implP(impl_buf);
  CkArrayIndexMax idx; implP|idx;
  int nowOnPe; implP|nowOnPe;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->updateLocation(idx, nowOnPe);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}
int CkIndex_CkLocMgr::_callmarshall_updateLocation_marshall4(char* impl_buf,CkLocMgr * impl_obj) {
  /*Unmarshall pup'd fields: const CkArrayIndexMax &idx, int nowOnPe*/
  PUP::fromMem implP(impl_buf);
  CkArrayIndexMax idx; implP|idx;
  int nowOnPe; implP|nowOnPe;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->updateLocation(idx, nowOnPe);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
  return implP.size();
}
void CkIndex_CkLocMgr::_marshallmessagepup_updateLocation_marshall4(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const CkArrayIndexMax &idx, int nowOnPe*/
  PUP::fromMem implP(impl_buf);
  CkArrayIndexMax idx; implP|idx;
  int nowOnPe; implP|nowOnPe;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("idx");
  implDestP|idx;
  if (implDestP.hasComments()) implDestP.comment("nowOnPe");
  implDestP|nowOnPe;
}

/* DEFS: void reclaimRemote(const CkArrayIndexMax &idx, int deletedOnPe);
 */
void CProxy_CkLocMgr::reclaimRemote(const CkArrayIndexMax &idx, int deletedOnPe, const CkEntryOptions *impl_e_opts)
{
  ckCheck();
  //Marshall: const CkArrayIndexMax &idx, int deletedOnPe
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)idx;
    implP|deletedOnPe;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)idx;
    implP|deletedOnPe;
  }
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkLocMgr::__idx_reclaimRemote_marshall5, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkLocMgr::__idx_reclaimRemote_marshall5, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkLocMgr::__idx_reclaimRemote_marshall5, impl_msg, ckGetGroupID(),0);
}
    void CProxy_CkLocMgr::reclaimRemote(const CkArrayIndexMax &idx, int deletedOnPe, int npes, int *pes, const CkEntryOptions *impl_e_opts)
    {
  //Marshall: const CkArrayIndexMax &idx, int deletedOnPe
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)idx;
    implP|deletedOnPe;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkArrayIndexMax &)idx;
    implP|deletedOnPe;
  }
      CkSendMsgBranchMulti(CkIndex_CkLocMgr::__idx_reclaimRemote_marshall5, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_CkLocMgr::__idx_reclaimRemote_marshall5=0;
void CkIndex_CkLocMgr::_call_reclaimRemote_marshall5(void* impl_msg,CkLocMgr * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const CkArrayIndexMax &idx, int deletedOnPe*/
  PUP::fromMem implP(impl_buf);
  CkArrayIndexMax idx; implP|idx;
  int deletedOnPe; implP|deletedOnPe;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->reclaimRemote(idx, deletedOnPe);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}
int CkIndex_CkLocMgr::_callmarshall_reclaimRemote_marshall5(char* impl_buf,CkLocMgr * impl_obj) {
  /*Unmarshall pup'd fields: const CkArrayIndexMax &idx, int deletedOnPe*/
  PUP::fromMem implP(impl_buf);
  CkArrayIndexMax idx; implP|idx;
  int deletedOnPe; implP|deletedOnPe;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->reclaimRemote(idx, deletedOnPe);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
  return implP.size();
}
void CkIndex_CkLocMgr::_marshallmessagepup_reclaimRemote_marshall5(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: const CkArrayIndexMax &idx, int deletedOnPe*/
  PUP::fromMem implP(impl_buf);
  CkArrayIndexMax idx; implP|idx;
  int deletedOnPe; implP|deletedOnPe;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("idx");
  implDestP|idx;
  if (implDestP.hasComments()) implDestP.comment("deletedOnPe");
  implDestP|deletedOnPe;
}

/* DEFS: void dummyAtSync(void);
 */
void CProxy_CkLocMgr::dummyAtSync(void)
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  if (ckIsDelegated()) {
     CkGroupMsgPrep(CkIndex_CkLocMgr::__idx_dummyAtSync_void, impl_msg, ckGetGroupID());
     ckDelegatedTo()->GroupBroadcast(ckDelegatedPtr(),CkIndex_CkLocMgr::__idx_dummyAtSync_void, impl_msg, ckGetGroupID());
  } else CkBroadcastMsgBranch(CkIndex_CkLocMgr::__idx_dummyAtSync_void, impl_msg, ckGetGroupID(),0);
}
    void CProxy_CkLocMgr::dummyAtSync(int npes, int *pes)
    {
  void *impl_msg = CkAllocSysMsg();
      CkSendMsgBranchMulti(CkIndex_CkLocMgr::__idx_dummyAtSync_void, impl_msg, npes, pes, ckGetGroupID(),0);
    }
 int CkIndex_CkLocMgr::__idx_dummyAtSync_void=0;
void CkIndex_CkLocMgr::_call_dummyAtSync_void(void* impl_msg,CkLocMgr * impl_obj)
{
  CkFreeSysMsg(impl_msg);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->dummyAtSync();
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}
#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_CkLocMgr::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterChareInCharm(__idx);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,CkLocMgr::isIrreducible());
// REG: CkLocMgr(CkMigrateMessage* impl_msg);
  __idx_CkLocMgr_CkMigrateMessage = CkRegisterEp("CkLocMgr(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_CkLocMgr_CkMigrateMessage, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterMigCtor(__idx, __idx_CkLocMgr_CkMigrateMessage);

// REG: CkLocMgr(const CkGroupID &map, const CkGroupID &_lbdb, const CkArrayIndexMax &numInitial);
  __idx_CkLocMgr_marshall1 = CkRegisterEp("CkLocMgr(const CkGroupID &map, const CkGroupID &_lbdb, const CkArrayIndexMax &numInitial)",
     (CkCallFnPtr)_call_CkLocMgr_marshall1, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP+CK_EP_INTRINSIC);
  CkRegisterMarshallUnpackFn(__idx_CkLocMgr_marshall1,(CkMarshallUnpackFn)_callmarshall_CkLocMgr_marshall1);
  CkRegisterMessagePupFn(__idx_CkLocMgr_marshall1,(CkMessagePupFn)_marshallmessagepup_CkLocMgr_marshall1);

// REG: void deliverInline(CkMessage* impl_msg);
  __idx_deliverInline_CkMessage = CkRegisterEp("deliverInline(CkMessage* impl_msg)",
     (CkCallFnPtr)_call_deliverInline_CkMessage, CMessage_CkMessage::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void immigrate(CkArrayElementMigrateMessage* impl_msg);
  __idx_immigrate_CkArrayElementMigrateMessage = CkRegisterEp("immigrate(CkArrayElementMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_immigrate_CkArrayElementMigrateMessage, CMessage_CkArrayElementMigrateMessage::__idx, __idx, 0+CK_EP_INTRINSIC);

// REG: void updateLocation(const CkArrayIndexMax &idx, int nowOnPe);
  __idx_updateLocation_marshall4 = CkRegisterEp("updateLocation(const CkArrayIndexMax &idx, int nowOnPe)",
     (CkCallFnPtr)_call_updateLocation_marshall4, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP+CK_EP_INTRINSIC);
  CkRegisterMarshallUnpackFn(__idx_updateLocation_marshall4,(CkMarshallUnpackFn)_callmarshall_updateLocation_marshall4);
  CkRegisterMessagePupFn(__idx_updateLocation_marshall4,(CkMessagePupFn)_marshallmessagepup_updateLocation_marshall4);

// REG: void reclaimRemote(const CkArrayIndexMax &idx, int deletedOnPe);
  __idx_reclaimRemote_marshall5 = CkRegisterEp("reclaimRemote(const CkArrayIndexMax &idx, int deletedOnPe)",
     (CkCallFnPtr)_call_reclaimRemote_marshall5, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP+CK_EP_INTRINSIC);
  CkRegisterMarshallUnpackFn(__idx_reclaimRemote_marshall5,(CkMarshallUnpackFn)_callmarshall_reclaimRemote_marshall5);
  CkRegisterMessagePupFn(__idx_reclaimRemote_marshall5,(CkMessagePupFn)_marshallmessagepup_reclaimRemote_marshall5);

// REG: void dummyAtSync(void);
  __idx_dummyAtSync_void = CkRegisterEp("dummyAtSync(void)",
     (CkCallFnPtr)_call_dummyAtSync_void, 0, __idx, 0+CK_EP_INTRINSIC);
}
#endif


/* DEFS: group CkArrayMap: IrrGroup;
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_CkArrayMap::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
void CkIndex_CkArrayMap::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterChareInCharm(__idx);
  CkRegisterBase(__idx, CkIndex_IrrGroup::__idx);
   CkRegisterGroupIrr(__idx,CkArrayMap::isIrreducible());
}
#endif

/* DEFS: readonly CkGroupID _RRMapID;
 */
extern CkGroupID _RRMapID;
#ifndef CK_TEMPLATES_ONLY
extern "C" void __xlater_roPup__RRMapID(void *_impl_pup_er) {
  PUP::er &_impl_p=*(PUP::er *)_impl_pup_er;
  _impl_p|_RRMapID;
}
#endif

/* DEFS: group RRMap: CkArrayMap{
RRMap(CkMigrateMessage* impl_msg);
RRMap(void);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_RRMap::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: RRMap(CkMigrateMessage* impl_msg);
 */

/* DEFS: RRMap(void);
 */
/* DEFS: RRMap(CkMigrateMessage* impl_msg);
 */
 int CkIndex_RRMap::__idx_RRMap_CkMigrateMessage=0;
void CkIndex_RRMap::_call_RRMap_CkMigrateMessage(void* impl_msg,RRMap * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) RRMap((CkMigrateMessage*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}

/* DEFS: RRMap(void);
 */
CkGroupID CProxy_RRMap::ckNew(void)
{
  void *impl_msg = CkAllocSysMsg();
  return CkCreateGroup(CkIndex_RRMap::__idx, CkIndex_RRMap::__idx_RRMap_void, impl_msg);
}
 int CkIndex_RRMap::__idx_RRMap_void=0;
void CkIndex_RRMap::_call_RRMap_void(void* impl_msg,RRMap * impl_obj)
{
  CkFreeSysMsg(impl_msg);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) RRMap();
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}
#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_RRMap::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterChareInCharm(__idx);
  CkRegisterBase(__idx, CkIndex_CkArrayMap::__idx);
   CkRegisterGroupIrr(__idx,RRMap::isIrreducible());
// REG: RRMap(CkMigrateMessage* impl_msg);
  __idx_RRMap_CkMigrateMessage = CkRegisterEp("RRMap(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_RRMap_CkMigrateMessage, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterMigCtor(__idx, __idx_RRMap_CkMigrateMessage);

// REG: RRMap(void);
  __idx_RRMap_void = CkRegisterEp("RRMap(void)",
     (CkCallFnPtr)_call_RRMap_void, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterDefaultCtor(__idx, __idx_RRMap_void);
}
#endif

/* DEFS: group BlockMap: RRMap{
BlockMap(CkMigrateMessage* impl_msg);
BlockMap(void);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_BlockMap::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: BlockMap(CkMigrateMessage* impl_msg);
 */

/* DEFS: BlockMap(void);
 */
/* DEFS: BlockMap(CkMigrateMessage* impl_msg);
 */
 int CkIndex_BlockMap::__idx_BlockMap_CkMigrateMessage=0;
void CkIndex_BlockMap::_call_BlockMap_CkMigrateMessage(void* impl_msg,BlockMap * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) BlockMap((CkMigrateMessage*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}

/* DEFS: BlockMap(void);
 */
CkGroupID CProxy_BlockMap::ckNew(void)
{
  void *impl_msg = CkAllocSysMsg();
  return CkCreateGroup(CkIndex_BlockMap::__idx, CkIndex_BlockMap::__idx_BlockMap_void, impl_msg);
}
 int CkIndex_BlockMap::__idx_BlockMap_void=0;
void CkIndex_BlockMap::_call_BlockMap_void(void* impl_msg,BlockMap * impl_obj)
{
  CkFreeSysMsg(impl_msg);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) BlockMap();
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}
#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_BlockMap::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterChareInCharm(__idx);
  CkRegisterBase(__idx, CkIndex_RRMap::__idx);
   CkRegisterGroupIrr(__idx,BlockMap::isIrreducible());
// REG: BlockMap(CkMigrateMessage* impl_msg);
  __idx_BlockMap_CkMigrateMessage = CkRegisterEp("BlockMap(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_BlockMap_CkMigrateMessage, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterMigCtor(__idx, __idx_BlockMap_CkMigrateMessage);

// REG: BlockMap(void);
  __idx_BlockMap_void = CkRegisterEp("BlockMap(void)",
     (CkCallFnPtr)_call_BlockMap_void, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterDefaultCtor(__idx, __idx_BlockMap_void);
}
#endif

/* DEFS: group CldMap: CkArrayMap{
CldMap(CkMigrateMessage* impl_msg);
CldMap(void);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_CldMap::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: CldMap(CkMigrateMessage* impl_msg);
 */

/* DEFS: CldMap(void);
 */
/* DEFS: CldMap(CkMigrateMessage* impl_msg);
 */
 int CkIndex_CldMap::__idx_CldMap_CkMigrateMessage=0;
void CkIndex_CldMap::_call_CldMap_CkMigrateMessage(void* impl_msg,CldMap * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) CldMap((CkMigrateMessage*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}

/* DEFS: CldMap(void);
 */
CkGroupID CProxy_CldMap::ckNew(void)
{
  void *impl_msg = CkAllocSysMsg();
  return CkCreateGroup(CkIndex_CldMap::__idx, CkIndex_CldMap::__idx_CldMap_void, impl_msg);
}
 int CkIndex_CldMap::__idx_CldMap_void=0;
void CkIndex_CldMap::_call_CldMap_void(void* impl_msg,CldMap * impl_obj)
{
  CkFreeSysMsg(impl_msg);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) CldMap();
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}
#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_CldMap::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterChareInCharm(__idx);
  CkRegisterBase(__idx, CkIndex_CkArrayMap::__idx);
   CkRegisterGroupIrr(__idx,CldMap::isIrreducible());
// REG: CldMap(CkMigrateMessage* impl_msg);
  __idx_CldMap_CkMigrateMessage = CkRegisterEp("CldMap(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_CldMap_CkMigrateMessage, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterMigCtor(__idx, __idx_CldMap_CkMigrateMessage);

// REG: CldMap(void);
  __idx_CldMap_void = CkRegisterEp("CldMap(void)",
     (CkCallFnPtr)_call_CldMap_void, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterDefaultCtor(__idx, __idx_CldMap_void);
}
#endif



/* DEFS: group PropMap: CkArrayMap{
PropMap(CkMigrateMessage* impl_msg);
PropMap(void);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_PropMap::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: PropMap(CkMigrateMessage* impl_msg);
 */

/* DEFS: PropMap(void);
 */
/* DEFS: PropMap(CkMigrateMessage* impl_msg);
 */
 int CkIndex_PropMap::__idx_PropMap_CkMigrateMessage=0;
void CkIndex_PropMap::_call_PropMap_CkMigrateMessage(void* impl_msg,PropMap * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) PropMap((CkMigrateMessage*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}

/* DEFS: PropMap(void);
 */
CkGroupID CProxy_PropMap::ckNew(void)
{
  void *impl_msg = CkAllocSysMsg();
  return CkCreateGroup(CkIndex_PropMap::__idx, CkIndex_PropMap::__idx_PropMap_void, impl_msg);
}
 int CkIndex_PropMap::__idx_PropMap_void=0;
void CkIndex_PropMap::_call_PropMap_void(void* impl_msg,PropMap * impl_obj)
{
  CkFreeSysMsg(impl_msg);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) PropMap();
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}
#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_PropMap::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterChareInCharm(__idx);
  CkRegisterBase(__idx, CkIndex_CkArrayMap::__idx);
   CkRegisterGroupIrr(__idx,PropMap::isIrreducible());
// REG: PropMap(CkMigrateMessage* impl_msg);
  __idx_PropMap_CkMigrateMessage = CkRegisterEp("PropMap(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_PropMap_CkMigrateMessage, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterMigCtor(__idx, __idx_PropMap_CkMigrateMessage);

// REG: PropMap(void);
  __idx_PropMap_void = CkRegisterEp("PropMap(void)",
     (CkCallFnPtr)_call_PropMap_void, 0, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterDefaultCtor(__idx, __idx_PropMap_void);
}
#endif

/* DEFS: mainchare CkMapsInit: Chare{
CkMapsInit(CkArgMsg* impl_msg);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_CkMapsInit::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: CkMapsInit(CkArgMsg* impl_msg);
 */
CkChareID CProxy_CkMapsInit::ckNew(CkArgMsg* impl_msg, int impl_onPE)
{
  CkChareID impl_ret;
  CkCreateChare(CkIndex_CkMapsInit::__idx, CkIndex_CkMapsInit::__idx_CkMapsInit_CkArgMsg, impl_msg, &impl_ret, impl_onPE);
  return impl_ret;
}
void CProxy_CkMapsInit::ckNew(CkArgMsg* impl_msg, CkChareID* pcid, int impl_onPE)
{
  CkCreateChare(CkIndex_CkMapsInit::__idx, CkIndex_CkMapsInit::__idx_CkMapsInit_CkArgMsg, impl_msg, pcid, impl_onPE);
}
  CProxy_CkMapsInit::CProxy_CkMapsInit(CkArgMsg* impl_msg, int impl_onPE)
{
  CkChareID impl_ret;
  CkCreateChare(CkIndex_CkMapsInit::__idx, CkIndex_CkMapsInit::__idx_CkMapsInit_CkArgMsg, impl_msg, &impl_ret, impl_onPE);
  ckSetChareID(impl_ret);
}
 int CkIndex_CkMapsInit::__idx_CkMapsInit_CkArgMsg=0;
void CkIndex_CkMapsInit::_call_CkMapsInit_CkArgMsg(void* impl_msg,CkMapsInit * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) CkMapsInit((CkArgMsg*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
#endif
}
#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_CkMapsInit::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterChareInCharm(__idx);
  CkRegisterBase(__idx, CkIndex_Chare::__idx);
// REG: CkMapsInit(CkArgMsg* impl_msg);
  __idx_CkMapsInit_CkArgMsg = CkRegisterEp("CkMapsInit(CkArgMsg* impl_msg)",
     (CkCallFnPtr)_call_CkMapsInit_CkArgMsg, CMessage_CkArgMsg::__idx, __idx, 0+CK_EP_INTRINSIC);
  CkRegisterMainChare(__idx, __idx_CkMapsInit_CkArgMsg);
}
#endif

#ifndef CK_TEMPLATES_ONLY
void _registerCkLocation(void)
{
  static int _done = 0; if(_done) return; _done = 1;
      _registerCkMarshall();

/* REG: message CkArrayElementMigrateMessage{
double packData[];
}
;
*/
CMessage_CkArrayElementMigrateMessage::__register("CkArrayElementMigrateMessage", sizeof(CkArrayElementMigrateMessage),(CkPackFnPtr) CkArrayElementMigrateMessage::pack,(CkUnpackFnPtr) CkArrayElementMigrateMessage::unpack);

/* REG: group CkLocMgr: IrrGroup{
CkLocMgr(CkMigrateMessage* impl_msg);
CkLocMgr(const CkGroupID &map, const CkGroupID &_lbdb, const CkArrayIndexMax &numInitial);
void deliverInline(CkMessage* impl_msg);
void immigrate(CkArrayElementMigrateMessage* impl_msg);
void updateLocation(const CkArrayIndexMax &idx, int nowOnPe);
void reclaimRemote(const CkArrayIndexMax &idx, int deletedOnPe);
void dummyAtSync(void);
};
*/
  CkIndex_CkLocMgr::__register("CkLocMgr", sizeof(CkLocMgr));

      _registerInitCall(_CkLocMgrInit,1);

/* REG: group CkArrayMap: IrrGroup;
*/
  CkIndex_CkArrayMap::__register("CkArrayMap", sizeof(CkArrayMap));

  CkRegisterReadonly("_RRMapID","CkGroupID",sizeof(_RRMapID),(void *) &_RRMapID,__xlater_roPup__RRMapID);

/* REG: group RRMap: CkArrayMap{
RRMap(CkMigrateMessage* impl_msg);
RRMap(void);
};
*/
  CkIndex_RRMap::__register("RRMap", sizeof(RRMap));

/* REG: group BlockMap: RRMap{
BlockMap(CkMigrateMessage* impl_msg);
BlockMap(void);
};
*/
  CkIndex_BlockMap::__register("BlockMap", sizeof(BlockMap));

/* REG: group CldMap: CkArrayMap{
CldMap(CkMigrateMessage* impl_msg);
CldMap(void);
};
*/
  CkIndex_CldMap::__register("CldMap", sizeof(CldMap));

      _registerInitCall(_propMapInit,1);

      _registerInitCall(_CkMigratable_initInfoInit,1);

/* REG: group PropMap: CkArrayMap{
PropMap(CkMigrateMessage* impl_msg);
PropMap(void);
};
*/
  CkIndex_PropMap::__register("PropMap", sizeof(PropMap));

/* REG: mainchare CkMapsInit: Chare{
CkMapsInit(CkArgMsg* impl_msg);
};
*/
  CkIndex_CkMapsInit::__register("CkMapsInit", sizeof(CkMapsInit));

}
#endif
