/* DEFS: message Msg{
double strip[];
}
;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_Msg::operator new(size_t s){
  return Msg::alloc(__idx, s, 0, 0);
}
void *CMessage_Msg::operator new(size_t s, int* sz){
  return Msg::alloc(__idx, s, sz, 0);
}
void *CMessage_Msg::operator new(size_t s, int* sz,const int pb){
  return Msg::alloc(__idx, s, sz, pb);
}
void *CMessage_Msg::operator new(size_t s, int sz0) {
  int sizes[1];
  sizes[0] = sz0;
  return Msg::alloc(__idx, s, sizes, 0);
}
void *CMessage_Msg::operator new(size_t s, int sz0, const int p) {
  int sizes[1];
  sizes[0] = sz0;
  return Msg::alloc(__idx, s, sizes, p);
}
void* CMessage_Msg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  int offsets[2];
  offsets[0] = ALIGN8(sz);
  if(sizes==0)
    offsets[1] = offsets[0];
  else
    offsets[1] = offsets[0] + ALIGN8(sizeof(double)*sizes[0]);
  Msg *newmsg = (Msg *) CkAllocMsg(msgnum, offsets[1], pb);
  newmsg->strip = (double *) ((char *)newmsg + offsets[0]);
  return (void *) newmsg;
}
void* CMessage_Msg::pack(Msg *msg) {
  msg->strip = (double *) ((char *)msg->strip - (char *)msg);
  return (void *) msg;
}
Msg* CMessage_Msg::unpack(void* buf) {
  Msg *msg = (Msg *) buf;
  msg->strip = (double *) ((size_t)msg->strip + (char *)msg);
  return msg;
}
int CMessage_Msg::__idx=0;
#endif

/* DEFS: message MaxMsg;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_MaxMsg::operator new(size_t s){
  return MaxMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_MaxMsg::operator new(size_t s, int* sz){
  return MaxMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_MaxMsg::operator new(size_t s, int* sz,const int pb){
  return MaxMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_MaxMsg::operator new(size_t s, const int p) {
  return MaxMsg::alloc(__idx, s, 0, p);
}
void* CMessage_MaxMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  int offsets[1];
  offsets[0] = ALIGN8(sz);
  MaxMsg *newmsg = (MaxMsg *) CkAllocMsg(msgnum, offsets[0], pb);
  return (void *) newmsg;
}
void* CMessage_MaxMsg::pack(MaxMsg *msg) {
  return (void *) msg;
}
MaxMsg* CMessage_MaxMsg::unpack(void* buf) {
  MaxMsg *msg = (MaxMsg *) buf;
  return msg;
}
int CMessage_MaxMsg::__idx=0;
#endif

/* DEFS: message VoidMsg;
 */
#ifndef CK_TEMPLATES_ONLY
void *CMessage_VoidMsg::operator new(size_t s){
  return VoidMsg::alloc(__idx, s, 0, 0);
}
void *CMessage_VoidMsg::operator new(size_t s, int* sz){
  return VoidMsg::alloc(__idx, s, sz, 0);
}
void *CMessage_VoidMsg::operator new(size_t s, int* sz,const int pb){
  return VoidMsg::alloc(__idx, s, sz, pb);
}
void *CMessage_VoidMsg::operator new(size_t s, const int p) {
  return VoidMsg::alloc(__idx, s, 0, p);
}
void* CMessage_VoidMsg::alloc(int msgnum, size_t sz, int *sizes, int pb) {
  int offsets[1];
  offsets[0] = ALIGN8(sz);
  VoidMsg *newmsg = (VoidMsg *) CkAllocMsg(msgnum, offsets[0], pb);
  return (void *) newmsg;
}
void* CMessage_VoidMsg::pack(VoidMsg *msg) {
  return (void *) msg;
}
VoidMsg* CMessage_VoidMsg::unpack(void* buf) {
  VoidMsg *msg = (VoidMsg *) buf;
  return msg;
}
int CMessage_VoidMsg::__idx=0;
#endif

/* DEFS: mainchare Main: Chare{
Main(CkArgMsg* impl_msg);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_Main::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: Main(CkArgMsg* impl_msg);
 */
CkChareID CProxy_Main::ckNew(CkArgMsg* impl_msg, int impl_onPE)
{
  CkChareID impl_ret;
  CkCreateChare(CkIndex_Main::__idx, CkIndex_Main::__idx_Main_CkArgMsg, impl_msg, &impl_ret, impl_onPE);
  return impl_ret;
}
void CProxy_Main::ckNew(CkArgMsg* impl_msg, CkChareID* pcid, int impl_onPE)
{
  CkCreateChare(CkIndex_Main::__idx, CkIndex_Main::__idx_Main_CkArgMsg, impl_msg, pcid, impl_onPE);
}
  CProxy_Main::CProxy_Main(CkArgMsg* impl_msg, int impl_onPE)
{
  CkChareID impl_ret;
  CkCreateChare(CkIndex_Main::__idx, CkIndex_Main::__idx_Main_CkArgMsg, impl_msg, &impl_ret, impl_onPE);
  ckSetChareID(impl_ret);
}
 int CkIndex_Main::__idx_Main_CkArgMsg=0;
void CkIndex_Main::_call_Main_CkArgMsg(void* impl_msg,Main * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  setMemoryStatus(1);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) Main((CkArgMsg*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(0);
#endif
}
#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_Main::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterBase(__idx, CkIndex_Chare::__idx);
// REG: Main(CkArgMsg* impl_msg);
  __idx_Main_CkArgMsg = CkRegisterEp("Main(CkArgMsg* impl_msg)",
     (CkCallFnPtr)_call_Main_CkArgMsg, CMessage_CkArgMsg::__idx, __idx, 0);
  CkRegisterMainChare(__idx, __idx_Main_CkArgMsg);
}
#endif

/* DEFS: readonly CProxy_Main globalMainProxy;
 */
extern CProxy_Main globalMainProxy;
#ifndef CK_TEMPLATES_ONLY
extern "C" void __xlater_roPup_globalMainProxy(void *_impl_pup_er) {
  PUP::er &_impl_p=*(PUP::er *)_impl_pup_er;
  _impl_p|globalMainProxy;
}
#endif

/* DEFS: readonly CProxy_Chunk chunk_arr;
 */
extern CProxy_Chunk chunk_arr;
#ifndef CK_TEMPLATES_ONLY
extern "C" void __xlater_roPup_chunk_arr(void *_impl_pup_er) {
  PUP::er &_impl_p=*(PUP::er *)_impl_pup_er;
  _impl_p|chunk_arr;
}
#endif

/* DEFS: readonly int numFinished;
 */
extern int numFinished;
#ifndef CK_TEMPLATES_ONLY
extern "C" void __xlater_roPup_numFinished(void *_impl_pup_er) {
  PUP::er &_impl_p=*(PUP::er *)_impl_pup_er;
  _impl_p|numFinished;
}
#endif

/* DEFS: array Chunk: ArrayElement{
Chunk(CkMigrateMessage* impl_msg);
Chunk(int impl_noname_0, int impl_noname_1, int impl_noname_2);
void getStripfromleft(Msg* impl_msg);
void getStripfromright(Msg* impl_msg);
void processStripfromleft(Msg* impl_msg);
void processStripfromright(Msg* impl_msg);
void startWork(void);
void singleStep(VoidMsg* impl_msg);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_Chunk::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: Chunk(CkMigrateMessage* impl_msg);
 */

/* DEFS: Chunk(int impl_noname_0, int impl_noname_1, int impl_noname_2);
 */
void CProxyElement_Chunk::insert(int impl_noname_0, int impl_noname_1, int impl_noname_2, int onPE, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: int impl_noname_0, int impl_noname_1, int impl_noname_2
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_0;
    implP|impl_noname_1;
    implP|impl_noname_2;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_0;
    implP|impl_noname_1;
    implP|impl_noname_2;
  }
   ckInsert((CkArrayMessage *)impl_msg,CkIndex_Chunk::__idx_Chunk_marshall1,onPE);
}

/* DEFS: void getStripfromleft(Msg* impl_msg);
 */
void CProxyElement_Chunk::getStripfromleft(Msg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_Chunk::__idx_getStripfromleft_Msg,0);
}

/* DEFS: void getStripfromright(Msg* impl_msg);
 */
void CProxyElement_Chunk::getStripfromright(Msg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_Chunk::__idx_getStripfromright_Msg,0);
}

/* DEFS: void processStripfromleft(Msg* impl_msg);
 */
void CProxyElement_Chunk::processStripfromleft(Msg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_Chunk::__idx_processStripfromleft_Msg,0);
}

/* DEFS: void processStripfromright(Msg* impl_msg);
 */
void CProxyElement_Chunk::processStripfromright(Msg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_Chunk::__idx_processStripfromright_Msg,0);
}

/* DEFS: void startWork(void);
 */
void CProxyElement_Chunk::startWork(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_Chunk::__idx_startWork_void,0);
}

/* DEFS: void singleStep(VoidMsg* impl_msg);
 */
void CProxyElement_Chunk::singleStep(VoidMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_Chunk::__idx_singleStep_VoidMsg,0);
}
/* DEFS: Chunk(CkMigrateMessage* impl_msg);
 */
 int CkIndex_Chunk::__idx_Chunk_CkMigrateMessage=0;
void CkIndex_Chunk::_call_Chunk_CkMigrateMessage(void* impl_msg,Chunk * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  setMemoryStatus(1);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) Chunk((CkMigrateMessage*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(0);
#endif
}

/* DEFS: Chunk(int impl_noname_0, int impl_noname_1, int impl_noname_2);
 */
CkArrayID CProxy_Chunk::ckNew(int impl_noname_0, int impl_noname_1, int impl_noname_2, const CkArrayOptions &opts, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: int impl_noname_0, int impl_noname_1, int impl_noname_2
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_0;
    implP|impl_noname_1;
    implP|impl_noname_2;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_0;
    implP|impl_noname_1;
    implP|impl_noname_2;
  }
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_Chunk::__idx_Chunk_marshall1,opts);
}
CkArrayID CProxy_Chunk::ckNew(int impl_noname_0, int impl_noname_1, int impl_noname_2, const int s1, const CkEntryOptions *impl_e_opts)
{ 
  //Marshall: int impl_noname_0, int impl_noname_1, int impl_noname_2
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_noname_0;
    implP|impl_noname_1;
    implP|impl_noname_2;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_noname_0;
    implP|impl_noname_1;
    implP|impl_noname_2;
  }
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_Chunk::__idx_Chunk_marshall1,CkArrayOptions(s1));
}
 int CkIndex_Chunk::__idx_Chunk_marshall1=0;
void CkIndex_Chunk::_call_Chunk_marshall1(void* impl_msg,Chunk * impl_obj)
{
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: int impl_noname_0, int impl_noname_1, int impl_noname_2*/
  PUP::fromMem implP(impl_buf);
  int impl_noname_0; implP|impl_noname_0;
  int impl_noname_1; implP|impl_noname_1;
  int impl_noname_2; implP|impl_noname_2;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  setMemoryStatus(1);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) Chunk(impl_noname_0, impl_noname_1, impl_noname_2);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(0);
#endif
}
int CkIndex_Chunk::_callmarshall_Chunk_marshall1(char* impl_buf,Chunk * impl_obj) {
  /*Unmarshall pup'd fields: int impl_noname_0, int impl_noname_1, int impl_noname_2*/
  PUP::fromMem implP(impl_buf);
  int impl_noname_0; implP|impl_noname_0;
  int impl_noname_1; implP|impl_noname_1;
  int impl_noname_2; implP|impl_noname_2;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  setMemoryStatus(1);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  new (impl_obj) Chunk(impl_noname_0, impl_noname_1, impl_noname_2);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(0);
#endif
  return implP.size();
}
void CkIndex_Chunk::_marshallmessagepup_Chunk_marshall1(PUP::er &implDestP,void *impl_msg) {
  char *impl_buf=((CkMarshallMsg *)impl_msg)->msgBuf;
  /*Unmarshall pup'd fields: int impl_noname_0, int impl_noname_1, int impl_noname_2*/
  PUP::fromMem implP(impl_buf);
  int impl_noname_0; implP|impl_noname_0;
  int impl_noname_1; implP|impl_noname_1;
  int impl_noname_2; implP|impl_noname_2;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("impl_noname_0");
  implDestP|impl_noname_0;
  if (implDestP.hasComments()) implDestP.comment("impl_noname_1");
  implDestP|impl_noname_1;
  if (implDestP.hasComments()) implDestP.comment("impl_noname_2");
  implDestP|impl_noname_2;
}

/* DEFS: void getStripfromleft(Msg* impl_msg);
 */
void CProxy_Chunk::getStripfromleft(Msg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_Chunk::__idx_getStripfromleft_Msg,0);
}
 int CkIndex_Chunk::__idx_getStripfromleft_Msg=0;
void CkIndex_Chunk::_call_getStripfromleft_Msg(void* impl_msg,Chunk * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  setMemoryStatus(1);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->getStripfromleft((Msg*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(0);
#endif
}

/* DEFS: void getStripfromright(Msg* impl_msg);
 */
void CProxy_Chunk::getStripfromright(Msg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_Chunk::__idx_getStripfromright_Msg,0);
}
 int CkIndex_Chunk::__idx_getStripfromright_Msg=0;
void CkIndex_Chunk::_call_getStripfromright_Msg(void* impl_msg,Chunk * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  setMemoryStatus(1);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->getStripfromright((Msg*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(0);
#endif
}

/* DEFS: void processStripfromleft(Msg* impl_msg);
 */
void CProxy_Chunk::processStripfromleft(Msg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_Chunk::__idx_processStripfromleft_Msg,0);
}
 int CkIndex_Chunk::__idx_processStripfromleft_Msg=0;
void CkIndex_Chunk::_call_processStripfromleft_Msg(void* impl_msg,Chunk * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  setMemoryStatus(1);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->processStripfromleft((Msg*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(0);
#endif
}

/* DEFS: void processStripfromright(Msg* impl_msg);
 */
void CProxy_Chunk::processStripfromright(Msg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_Chunk::__idx_processStripfromright_Msg,0);
}
 int CkIndex_Chunk::__idx_processStripfromright_Msg=0;
void CkIndex_Chunk::_call_processStripfromright_Msg(void* impl_msg,Chunk * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  setMemoryStatus(1);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->processStripfromright((Msg*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(0);
#endif
}

/* DEFS: void startWork(void);
 */
void CProxy_Chunk::startWork(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_Chunk::__idx_startWork_void,0);
}
 int CkIndex_Chunk::__idx_startWork_void=0;
void CkIndex_Chunk::_call_startWork_void(void* impl_msg,Chunk * impl_obj)
{
  CkFreeSysMsg(impl_msg);
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  setMemoryStatus(1);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->startWork();
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(0);
#endif
}

/* DEFS: void singleStep(VoidMsg* impl_msg);
 */
void CProxy_Chunk::singleStep(VoidMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_Chunk::__idx_singleStep_VoidMsg,0);
}
 int CkIndex_Chunk::__idx_singleStep_VoidMsg=0;
void CkIndex_Chunk::_call_singleStep_VoidMsg(void* impl_msg,Chunk * impl_obj)
{
#ifndef CMK_OPTIMIZE
  setMemoryChareID(impl_obj);
  setMemoryStatus(1);
#endif
#ifdef CMK_CHECK_CRC
  checkAllCRC(0);
#endif
  impl_obj->singleStep((VoidMsg*)impl_msg);
#ifdef CMK_CHECK_CRC
  checkAllCRC(1);
#endif
#ifndef CMK_OPTIMIZE
  setMemoryChareID(NULL);
  setMemoryStatus(0);
#endif
}
/* DEFS: Chunk(CkMigrateMessage* impl_msg);
 */

/* DEFS: Chunk(int impl_noname_0, int impl_noname_1, int impl_noname_2);
 */

/* DEFS: void getStripfromleft(Msg* impl_msg);
 */
void CProxySection_Chunk::getStripfromleft(Msg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_Chunk::__idx_getStripfromleft_Msg,0);
}

/* DEFS: void getStripfromright(Msg* impl_msg);
 */
void CProxySection_Chunk::getStripfromright(Msg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_Chunk::__idx_getStripfromright_Msg,0);
}

/* DEFS: void processStripfromleft(Msg* impl_msg);
 */
void CProxySection_Chunk::processStripfromleft(Msg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_Chunk::__idx_processStripfromleft_Msg,0);
}

/* DEFS: void processStripfromright(Msg* impl_msg);
 */
void CProxySection_Chunk::processStripfromright(Msg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_Chunk::__idx_processStripfromright_Msg,0);
}

/* DEFS: void startWork(void);
 */
void CProxySection_Chunk::startWork(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_Chunk::__idx_startWork_void,0);
}

/* DEFS: void singleStep(VoidMsg* impl_msg);
 */
void CProxySection_Chunk::singleStep(VoidMsg* impl_msg) 
{
  ckCheck();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_Chunk::__idx_singleStep_VoidMsg,0);
}
#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_Chunk::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterBase(__idx, CkIndex_ArrayElement::__idx);
// REG: Chunk(CkMigrateMessage* impl_msg);
  __idx_Chunk_CkMigrateMessage = CkRegisterEp("Chunk(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_Chunk_CkMigrateMessage, 0, __idx, 0);
  CkRegisterMigCtor(__idx, __idx_Chunk_CkMigrateMessage);

// REG: Chunk(int impl_noname_0, int impl_noname_1, int impl_noname_2);
  __idx_Chunk_marshall1 = CkRegisterEp("Chunk(int impl_noname_0, int impl_noname_1, int impl_noname_2)",
     (CkCallFnPtr)_call_Chunk_marshall1, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_Chunk_marshall1,(CkMarshallUnpackFn)_callmarshall_Chunk_marshall1);
  CkRegisterMessagePupFn(__idx_Chunk_marshall1,(CkMessagePupFn)_marshallmessagepup_Chunk_marshall1);

// REG: void getStripfromleft(Msg* impl_msg);
  __idx_getStripfromleft_Msg = CkRegisterEp("getStripfromleft(Msg* impl_msg)",
     (CkCallFnPtr)_call_getStripfromleft_Msg, CMessage_Msg::__idx, __idx, 0);

// REG: void getStripfromright(Msg* impl_msg);
  __idx_getStripfromright_Msg = CkRegisterEp("getStripfromright(Msg* impl_msg)",
     (CkCallFnPtr)_call_getStripfromright_Msg, CMessage_Msg::__idx, __idx, 0);

// REG: void processStripfromleft(Msg* impl_msg);
  __idx_processStripfromleft_Msg = CkRegisterEp("processStripfromleft(Msg* impl_msg)",
     (CkCallFnPtr)_call_processStripfromleft_Msg, CMessage_Msg::__idx, __idx, 0);

// REG: void processStripfromright(Msg* impl_msg);
  __idx_processStripfromright_Msg = CkRegisterEp("processStripfromright(Msg* impl_msg)",
     (CkCallFnPtr)_call_processStripfromright_Msg, CMessage_Msg::__idx, __idx, 0);

// REG: void startWork(void);
  __idx_startWork_void = CkRegisterEp("startWork(void)",
     (CkCallFnPtr)_call_startWork_void, 0, __idx, 0);

// REG: void singleStep(VoidMsg* impl_msg);
  __idx_singleStep_VoidMsg = CkRegisterEp("singleStep(VoidMsg* impl_msg)",
     (CkCallFnPtr)_call_singleStep_VoidMsg, CMessage_VoidMsg::__idx, __idx, 0);
  Chunk::__sdag_register(); 
}
#endif

Chunk_SDAG_CODE_DEF


#ifndef CK_TEMPLATES_ONLY
void _registerparallelJacobi(void)
{
  static int _done = 0; if(_done) return; _done = 1;
/* REG: message Msg{
double strip[];
}
;
*/
CMessage_Msg::__register("Msg", sizeof(Msg),(CkPackFnPtr) Msg::pack,(CkUnpackFnPtr) Msg::unpack);

/* REG: message MaxMsg;
*/
CMessage_MaxMsg::__register("MaxMsg", sizeof(MaxMsg),(CkPackFnPtr) MaxMsg::pack,(CkUnpackFnPtr) MaxMsg::unpack);

/* REG: message VoidMsg;
*/
CMessage_VoidMsg::__register("VoidMsg", sizeof(VoidMsg),(CkPackFnPtr) VoidMsg::pack,(CkUnpackFnPtr) VoidMsg::unpack);

/* REG: mainchare Main: Chare{
Main(CkArgMsg* impl_msg);
};
*/
  CkIndex_Main::__register("Main", sizeof(Main));

  CkRegisterReadonly("globalMainProxy","CProxy_Main",sizeof(globalMainProxy),(void *) &globalMainProxy,__xlater_roPup_globalMainProxy);

  CkRegisterReadonly("chunk_arr","CProxy_Chunk",sizeof(chunk_arr),(void *) &chunk_arr,__xlater_roPup_chunk_arr);

  CkRegisterReadonly("numFinished","int",sizeof(numFinished),(void *) &numFinished,__xlater_roPup_numFinished);

/* REG: array Chunk: ArrayElement{
Chunk(CkMigrateMessage* impl_msg);
Chunk(int impl_noname_0, int impl_noname_1, int impl_noname_2);
void getStripfromleft(Msg* impl_msg);
void getStripfromright(Msg* impl_msg);
void processStripfromleft(Msg* impl_msg);
void processStripfromright(Msg* impl_msg);
void startWork(void);
void singleStep(VoidMsg* impl_msg);
};
*/
  CkIndex_Chunk::__register("Chunk", sizeof(Chunk));

}
extern "C" void CkRegisterMainModule(void) {
  _registerparallelJacobi();
}
#endif
