/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.ccs.CcsServer;
import charm.debug.CpdUtil;
import charm.debug.fmt.PAbstract;
import charm.debug.fmt.PList;
import charm.debug.fmt.PNative;
import charm.debug.fmt.PString;

public class SetReadonly {
    private CpdUtil cpd;

    public ReadonlyInfo findName(String name, PList list, boolean verbose) {
        int count = 0;
        for (PAbstract cur = list.elementAt(0); cur != null; cur = cur.getNext()) {
            PList lcur = (PList)cur;
            PString n = (PString)lcur.elementNamed("name");
            if (verbose) {
                System.out.println("Readonly '" + n.getString() + "'");
            }
            if (n.getString().equals(name)) {
                ReadonlyInfo ri = new ReadonlyInfo();
                ri.idx = count;
                ri.name = n.getString();
                ri.type = ((PString)lcur.elementNamed("type")).getString();
                ri.size = ((PNative)lcur.elementNamed("size")).getIntValue(0);
                ri.value = lcur.elementNamed("value");
                return ri;
            }
            ++count;
        }
        return null;
    }

    public SetReadonly(CcsServer ccs, String[] args) {
        PList ros;
        ReadonlyInfo ri;
        this.cpd = new CpdUtil(ccs);
        int nPe = ccs.getNumPes();
        System.out.println("Connected: The CCS server has " + nPe + " processors.");
        String listName = "charm/readonly";
        String roName = args[2];
        String roValue = null;
        if (args.length > 3) {
            roValue = args[3];
        }
        if ((ri = this.findName(roName, ros = this.cpd.getPList(listName, 0), false)) == null) {
            this.findName("", ros, true);
            this.cpd.abort("Can't find readonly " + roName);
        }
        if (!ri.type.equals("int")) {
            this.cpd.abort("Can only set int readonlies, not " + ri.type);
        }
        System.out.println("Old value: " + ri.value);
        if (roValue != null) {
            int val = Integer.parseInt(roValue);
            byte[] bval = new byte[8];
            int o = 0;
            int l = 4;
            CcsServer.writeInt(bval, o, ri.size);
            o += l;
            l = 4;
            CcsServer.writeInt(bval, o, val);
            o += l;
            for (int pe = 0; pe < nPe; ++pe) {
                this.cpd.setListItem(listName, pe, ri.idx, bval);
            }
            System.out.println("New value: " + val);
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        if (args.length != 3 && args.length != 4) {
            System.out.println("Usage: setReadonly <host> <port>   <readonly name> <new value>");
            System.exit(1);
        }
        String[] ccsArgs = new String[]{args[0], args[1]};
        CcsServer ccs = CcsServer.create(ccsArgs, false);
        new SetReadonly(ccs, args);
    }

    class ReadonlyInfo {
        public int idx;
        public String name;
        public String type;
        public int size;
        public PAbstract value;

        ReadonlyInfo() {
        }
    }
}

