/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import javax.swing.ProgressMonitor;
import projections.gui.ColorMap;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.ScalePanel;
import projections.gui.StlWindow;
import projections.gui.SwingWorker;
import projections.gui.U;

public class StlPanel
extends ScalePanel.Child {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    int[][] entryData;
    private int[][] utilData;
    private int[][] idleData;
    private int[][] mergedData;
    private int[][] colors;
    private int intervalSize;
    private int nPe;
    private OrderedIntList validPEs;
    private long totalTime;
    private long startTime;
    private long endTime;
    private OrderedIntList oldPEList = new OrderedIntList();
    private long prevStartTime = -1L;
    private long prevEndTime = -1L;
    private ColorMap colorMap;
    private int mode = 0;
    boolean newEPData = true;
    StlWindow parentWindow = null;

    public StlPanel(StlWindow parentWindow) {
        this.parentWindow = parentWindow;
    }

    public String getPointInfo(double time, double procs) {
        int p = (int)procs;
        if (p < 0 || p >= this.nPe || procs < 0.0) {
            return "";
        }
        long t = (long)time;
        if (t < 0L || t >= this.totalTime) {
            return "";
        }
        if (this.validPEs != null) {
            int pe = 0;
            this.validPEs.reset();
            for (int count = 0; count <= p; ++count) {
                pe = this.validPEs.nextElement();
            }
            int numEP = MainWindow.runObject[this.myRun].getNumUserEntries();
            int interval = (int)(t / (long)this.intervalSize);
            long timedisplay = t + this.startTime;
            if (this.mode == 0) {
                return "Processor " + pe + ": Usage = " + this.utilData[p][interval] + "%" + " IDLE = " + this.idleData[p][interval] + "%" + " at " + U.t(timedisplay) + " (" + timedisplay + " us). ";
            }
            if (interval >= this.entryData[p].length) {
                return "";
            }
            if (this.entryData[p][interval] > 0) {
                return "Processor " + pe + ": Usage = " + this.utilData[p][interval] + "%" + " at " + U.t(timedisplay) + " (" + timedisplay + " us)." + " EP = " + MainWindow.runObject[this.myRun].getEntryName(this.entryData[p][interval]);
            }
            return "Processor " + pe + ": Usage = " + this.utilData[p][interval] + "%" + " at " + U.t(timedisplay) + " (" + timedisplay + " us). ";
        }
        return "";
    }

    public void paint(ScalePanel.Child.RepaintRequest req) {
        double proc2pix = req.y(1.0) - req.y(0.0);
        double time2pix = req.x(1.0) - req.x(0.0);
        double pix2time = 1.0 / time2pix;
        double tl = req.xInv(0.0);
        double th = req.xInv(req.w - 1);
        double pl = req.yInv(0.0);
        double ph = req.yInv(req.h - 1);
        if (tl < 0.0) {
            tl = 0.0;
        }
        if (tl >= (double)this.totalTime) {
            tl = (double)this.totalTime - 0.001;
        }
        if (th < 0.0) {
            th = 0.0;
        }
        if (th >= (double)this.totalTime) {
            th = (double)this.totalTime - 0.001;
        }
        if (pl < 0.0) {
            pl = 0.0;
        }
        if (pl >= (double)this.nPe) {
            pl = (double)this.nPe - 0.001;
        }
        if (ph < 0.0) {
            ph = 0.0;
        }
        if (ph >= (double)this.nPe) {
            ph = (double)this.nPe - 0.001;
        }
        int startx = (int)Math.ceil(req.x(tl));
        int endx = (int)Math.floor(req.x(th));
        int starty = (int)Math.ceil(req.y(pl));
        int endy = (int)Math.floor(req.y(ph));
        int wid = endx - startx;
        int ht = endy - starty;
        double x2t_off = req.xInv(startx) / (double)this.intervalSize;
        double x2t_slope = pix2time / (double)this.intervalSize;
        if (this.validPEs != null && wid > 0 && ht > 0) {
            int proc;
            int[] offBuf = new int[wid * ht];
            int proc_min = (int)Math.floor(pl);
            int proc_max = (int)Math.ceil(ph);
            this.validPEs.reset();
            int p = 0;
            while ((proc = this.validPEs.nextElement()) != -1) {
                if (proc == -1) continue;
                int y_min = (int)Math.floor(req.y(p));
                int y_max = (int)Math.floor(req.y(p + 1));
                if (y_min < starty) {
                    y_min = starty;
                }
                if (y_max > endy) {
                    y_max = endy;
                }
                if (p < this.colors.length) {
                    this.renderRow(this.colors[p], x2t_off, x2t_slope, offBuf, wid, y_min - starty, y_max - starty, startx - startx, endx - startx);
                }
                ++p;
            }
            Image offImg = this.createImage(new MemoryImageSource(wid, ht, offBuf, 0, wid));
            req.g.drawImage(offImg, startx, starty, null);
        }
        req.g.setColor(Color.black);
        req.g.fillRect(0, 0, startx, endy);
        req.g.fillRect(startx, 0, req.w, starty);
        req.g.fillRect(endx, starty, req.w, endy);
        req.g.fillRect(0, endy, req.w, req.h);
    }

    private void renderRow(int[] src, double off, double slope, int[] dest, int w, int yLo, int yHi, int xLo, int xHi) {
        int iOff = (int)(65536.0 * off);
        int iSlope = (int)(65536.0 * slope);
        int iCur = iOff + xLo * iSlope;
        int srcIndex = 0;
        for (int x = xLo; x < xHi; ++x) {
            srcIndex = iCur >> 16;
            if (srcIndex < 0) {
                srcIndex = 0;
                continue;
            }
            if (srcIndex >= src.length) {
                iCur += iSlope;
                continue;
            }
            int val = src[srcIndex];
            iCur += iSlope;
            int loc = yLo * w + x;
            int y = yLo;
            while (y < yHi) {
                if (loc < dest.length) {
                    dest[loc] = val;
                }
                ++y;
                loc += w;
            }
        }
    }

    public void setColorMap(ColorMap cm) {
        this.colorMap = cm;
    }

    void applyColorMap(int[][] data, boolean entryBased) {
        if (!entryBased) {
            int nPE = data.length;
            this.colors = new int[nPE][];
            for (int p = 0; p < nPE; ++p) {
                int n = data[p].length;
                this.colors[p] = new int[n];
                for (int i = 0; i < n; ++i) {
                    if (data[p][i] > 255 || data[p][i] < 0) {
                        this.colors[p][i] = this.colorMap.apply(255);
                        System.err.println("[" + p + "] Warning: Invalid " + "value " + data[p][i] + " being " + "applied to the color map " + "at time interval " + i + "!");
                        continue;
                    }
                    this.colors[p][i] = this.colorMap.apply(data[p][i]);
                }
            }
        } else {
            int numPE = data.length;
            int numIntervals = data[numPE - 1].length;
            this.colors = new int[numPE][numIntervals];
            for (int pe = 0; pe < numPE; ++pe) {
                for (int interval = 0; interval < numIntervals; ++interval) {
                    this.colors[pe][interval] = data[pe][interval] > 0 ? MainWindow.runObject[this.myRun].getEntryColor(data[pe][interval]).getRGB() : Color.black.getRGB();
                }
            }
        }
    }

    public void setMode(int mode) {
        this.mode = mode;
        int numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        if (mode == 0) {
            this.applyColorMap(this.mergedData, false);
            this.repaint();
        } else if (mode == 1) {
            if (this.newEPData) {
                this.parentWindow.setVisible(false);
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        StlPanel.this.setEPData();
                        StlPanel.this.newEPData = false;
                        return null;
                    }

                    public void finished() {
                        StlPanel.this.parentWindow.setVisible(true);
                        StlPanel.this.applyColorMap(StlPanel.this.entryData, true);
                        StlPanel.this.repaint();
                    }
                };
                worker.start();
            } else {
                this.applyColorMap(this.entryData, true);
                this.repaint();
            }
        }
    }

    public void resetMode() {
        this.mode = 0;
        this.newEPData = true;
    }

    public void setData(OrderedIntList validPEs, long startTime, long endTime) {
        this.validPEs = validPEs;
        this.totalTime = endTime - startTime;
        this.startTime = startTime;
        this.endTime = endTime;
        int desiredIntervals = this.totalTime < 7000L ? (int)((double)this.totalTime - 1.0) : 7000;
        double trialintervalSize = this.totalTime / (long)desiredIntervals;
        if (trialintervalSize < 5.0) {
            trialintervalSize = this.totalTime / (long)(desiredIntervals /= 5);
        }
        this.intervalSize = (int)trialintervalSize;
        int startInterval = (int)(startTime / (long)this.intervalSize);
        int endInterval = (int)(endTime / (long)this.intervalSize);
        this.nPe = validPEs.size();
        int numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        if (startTime == this.prevStartTime && endTime == this.prevEndTime && this.oldPEList.equals(validPEs)) {
            this.newEPData = false;
            return;
        }
        this.prevStartTime = startTime;
        this.prevEndTime = endTime;
        if (!this.oldPEList.equals(validPEs)) {
            this.oldPEList = validPEs.copyOf();
        }
        validPEs.reset();
        MainWindow.runObject[this.myRun].LoadGraphData(this.intervalSize, startInterval, endInterval, false, validPEs);
        this.utilData = MainWindow.runObject[this.myRun].getSystemUsageData(1);
        this.idleData = MainWindow.runObject[this.myRun].getSystemUsageData(2);
        if (this.idleData == null) {
            this.idleData = new int[this.utilData.length][this.utilData[0].length];
        }
        this.mergedData = new int[this.utilData.length][this.utilData[0].length];
        for (int i = 0; i < this.utilData.length; ++i) {
            for (int j = 0; j < this.utilData[i].length; ++j) {
                if (this.utilData[i][j] == 0) {
                    if (this.idleData[i][j] > 0) {
                        this.mergedData[i][j] = 0;
                        continue;
                    }
                    this.mergedData[i][j] = 0;
                    continue;
                }
                this.mergedData[i][j] = this.utilData[i][j];
            }
        }
        this.applyColorMap(this.mergedData, false);
        validPEs.reset();
        this.repaint();
    }

    public void setEPData() {
        int desiredIntervals = this.totalTime < 7000L ? (int)((double)this.totalTime - 1.0) : 7000;
        double trialintervalSize = this.totalTime / (long)desiredIntervals;
        if (trialintervalSize < 5.0) {
            trialintervalSize = this.totalTime / (long)(desiredIntervals /= 5);
        }
        this.intervalSize = (int)trialintervalSize;
        int startInterval = (int)(this.startTime / (long)this.intervalSize);
        int endInterval = (int)(this.endTime / (long)this.intervalSize);
        this.nPe = this.validPEs.size();
        int numEPs = MainWindow.runObject[this.myRun].getNumUserEntries();
        if (MainWindow.runObject[this.myRun].hasLogData()) {
            ProgressMonitor progressBar = new ProgressMonitor(MainWindow.runObject[this.myRun].guiRoot, "Building EP Data", "", 0, this.validPEs.size());
            progressBar.setNote("Building EP Data");
            progressBar.setProgress(0);
            OrderedIntList curPEList = new OrderedIntList();
            int[][] temp = new int[this.validPEs.size()][];
            int[][] max = new int[this.validPEs.size()][desiredIntervals];
            this.entryData = new int[this.validPEs.size()][desiredIntervals];
            int curPeIdx = 0;
            int curPE = 0;
            this.validPEs.reset();
            while (this.validPEs.hasMoreElements()) {
                curPE = this.validPEs.nextElement();
                curPEList.insert(curPE);
                progressBar.setProgress(curPeIdx);
                progressBar.setNote("[PE: " + curPE + " ( " + curPeIdx + " of " + this.validPEs.size() + ") ] Acummulating Data");
                MainWindow.runObject[this.myRun].LoadGraphData(this.intervalSize, startInterval, endInterval, true, curPEList);
                for (int ep = 0; ep < numEPs; ++ep) {
                    temp[curPeIdx] = MainWindow.runObject[this.myRun].getUserEntryData(ep, 2)[0];
                    for (int i = 0; i < temp[curPeIdx].length && i < desiredIntervals; ++i) {
                        if (temp[curPeIdx][i] <= max[curPeIdx][i]) continue;
                        max[curPeIdx][i] = temp[curPeIdx][i];
                        this.entryData[curPeIdx][i] = ep;
                    }
                }
                curPEList.removeAll();
                ++curPeIdx;
            }
            progressBar.close();
        }
    }
}

