  PUPable_def(parent);
  PUPable_def(child);


/* DEFS: array marshallElt: ArrayElement{
marshallElt(CkMigrateMessage* impl_msg);
marshallElt(void);
void basic(unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d);
void flatRef(const flatStruct &s);
void pupped(const pupStruct &s);
void puppedSubclass(const pupStruct &s);
void PUPableReference(const CkReference<parent > &p);
void PUPablePointer(const CkPointer<parent > &p);
void simpleArray(int n, const int *arr);
void fancyArray(const int *arr2, int n, int m);
void crazyArray(const int *arr1, const int *arr2, int n);
void msgQ(int nMsgs, const msgQ_t &q);
void reflectMarshall(int forElt);
void done(void);
  initcall void eltInit(void);
};
 */
#ifndef CK_TEMPLATES_ONLY
 int CkIndex_marshallElt::__idx=0;
#endif
#ifndef CK_TEMPLATES_ONLY
/* DEFS: marshallElt(CkMigrateMessage* impl_msg);
 */

/* DEFS: marshallElt(void);
 */
void CProxyElement_marshallElt::insert(int onPE)
{ 
  void *impl_msg = CkAllocSysMsg();
   ckInsert((CkArrayMessage *)impl_msg,CkIndex_marshallElt::__idx_marshallElt_void,onPE);
}

/* DEFS: void basic(unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d);
 */
void CProxyElement_marshallElt::basic(unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|b;
    implP|c;
    implP|i;
    implP|j;
    implP|k;
    implP|l;
    implP|m;
    implP|n;
    implP|f;
    implP|d;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|b;
    implP|c;
    implP|i;
    implP|j;
    implP|k;
    implP|l;
    implP|m;
    implP|n;
    implP|f;
    implP|d;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_basic_marshall2,0);
}

/* DEFS: void flatRef(const flatStruct &s);
 */
void CProxyElement_marshallElt::flatRef(const flatStruct &s, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const flatStruct &s
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(flatStruct &)s;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(flatStruct &)s;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_flatRef_marshall3,0);
}

/* DEFS: void pupped(const pupStruct &s);
 */
void CProxyElement_marshallElt::pupped(const pupStruct &s, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const pupStruct &s
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(pupStruct &)s;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(pupStruct &)s;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_pupped_marshall4,0);
}

/* DEFS: void puppedSubclass(const pupStruct &s);
 */
void CProxyElement_marshallElt::puppedSubclass(const pupStruct &s, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const pupStruct &s
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(pupStruct &)s;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(pupStruct &)s;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_puppedSubclass_marshall5,0);
}

/* DEFS: void PUPableReference(const CkReference<parent > &p);
 */
void CProxyElement_marshallElt::PUPableReference(const CkReference<parent > &p, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CkReference<parent > &p
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkReference<parent > &)p;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkReference<parent > &)p;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_PUPableReference_marshall6,0);
}

/* DEFS: void PUPablePointer(const CkPointer<parent > &p);
 */
void CProxyElement_marshallElt::PUPablePointer(const CkPointer<parent > &p, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CkPointer<parent > &p
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkPointer<parent > &)p;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkPointer<parent > &)p;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_PUPablePointer_marshall7,0);
}

/* DEFS: void simpleArray(int n, const int *arr);
 */
void CProxyElement_marshallElt::simpleArray(int n, const int *arr, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int n, const int *arr
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_arr, impl_cnt_arr;
  impl_off_arr=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_arr=sizeof(int)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|n;
    implP|impl_off_arr;
    implP|impl_cnt_arr;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|n;
    implP|impl_off_arr;
    implP|impl_cnt_arr;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_arr,arr,impl_cnt_arr);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_simpleArray_marshall8,0);
}

/* DEFS: void fancyArray(const int *arr2, int n, int m);
 */
void CProxyElement_marshallElt::fancyArray(const int *arr2, int n, int m, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const int *arr2, int n, int m
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_arr2, impl_cnt_arr2;
  impl_off_arr2=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_arr2=sizeof(int)*(n*m));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_arr2;
    implP|impl_cnt_arr2;
    implP|n;
    implP|m;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_arr2;
    implP|impl_cnt_arr2;
    implP|n;
    implP|m;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_arr2,arr2,impl_cnt_arr2);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_fancyArray_marshall9,0);
}

/* DEFS: void crazyArray(const int *arr1, const int *arr2, int n);
 */
void CProxyElement_marshallElt::crazyArray(const int *arr1, const int *arr2, int n, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const int *arr1, const int *arr2, int n
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_arr1, impl_cnt_arr1;
  impl_off_arr1=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_arr1=sizeof(int)*(arr2[0]));
  int impl_off_arr2, impl_cnt_arr2;
  impl_off_arr2=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_arr2=sizeof(int)*(arr1[0]+n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_arr1;
    implP|impl_cnt_arr1;
    implP|impl_off_arr2;
    implP|impl_cnt_arr2;
    implP|n;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_arr1;
    implP|impl_cnt_arr1;
    implP|impl_off_arr2;
    implP|impl_cnt_arr2;
    implP|n;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_arr1,arr1,impl_cnt_arr1);
  memcpy(impl_buf+impl_off_arr2,arr2,impl_cnt_arr2);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_crazyArray_marshall10,0);
}

/* DEFS: void msgQ(int nMsgs, const msgQ_t &q);
 */
void CProxyElement_marshallElt::msgQ(int nMsgs, const msgQ_t &q, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int nMsgs, const msgQ_t &q
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|nMsgs;
    //Have to cast away const-ness to get pup routine
    implP|(msgQ_t &)q;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|nMsgs;
    //Have to cast away const-ness to get pup routine
    implP|(msgQ_t &)q;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_msgQ_marshall11,0);
}

/* DEFS: void reflectMarshall(int forElt);
 */
void CProxyElement_marshallElt::reflectMarshall(int forElt, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int forElt
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|forElt;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|forElt;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_reflectMarshall_marshall12,0);
}

/* DEFS: void done(void);
 */
void CProxyElement_marshallElt::done(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_done_void,0);
}

/* DEFS: marshallElt(CkMigrateMessage* impl_msg);
 */
 int CkIndex_marshallElt::__idx_marshallElt_CkMigrateMessage=0;
void CkIndex_marshallElt::_call_marshallElt_CkMigrateMessage(void* impl_msg,marshallElt * impl_obj)
{
  new (impl_obj) marshallElt((CkMigrateMessage*)impl_msg);
}

/* DEFS: marshallElt(void);
 */
CkArrayID CProxy_marshallElt::ckNew(const CkArrayOptions &opts)
{ 
  void *impl_msg = CkAllocSysMsg();
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_marshallElt::__idx_marshallElt_void,opts);
}
CkArrayID CProxy_marshallElt::ckNew(const int s1)
{ 
  void *impl_msg = CkAllocSysMsg();
   return ckCreateArray((CkArrayMessage *)impl_msg,CkIndex_marshallElt::__idx_marshallElt_void,CkArrayOptions(s1));
}
 int CkIndex_marshallElt::__idx_marshallElt_void=0;
void CkIndex_marshallElt::_call_marshallElt_void(void* impl_msg,marshallElt * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  new (impl_obj) marshallElt();
}

/* DEFS: void basic(unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d);
 */
void CProxy_marshallElt::basic(unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|b;
    implP|c;
    implP|i;
    implP|j;
    implP|k;
    implP|l;
    implP|m;
    implP|n;
    implP|f;
    implP|d;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|b;
    implP|c;
    implP|i;
    implP|j;
    implP|k;
    implP|l;
    implP|m;
    implP|n;
    implP|f;
    implP|d;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_marshallElt::__idx_basic_marshall2,0);
}
 int CkIndex_marshallElt::__idx_basic_marshall2=0;
void CkIndex_marshallElt::_call_basic_marshall2(void* impl_msg,marshallElt * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d*/
  PUP::fromMem implP(impl_buf);
  unsigned char b; implP|b;
  char c; implP|c;
  short i; implP|i;
  unsigned short j; implP|j;
  int k; implP|k;
  unsigned int l; implP|l;
  long m; implP|m;
  unsigned long n; implP|n;
  float f; implP|f;
  double d; implP|d;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->basic(b, c, i, j, k, l, m, n, f, d);
}
int CkIndex_marshallElt::_callmarshall_basic_marshall2(char* impl_buf,marshallElt * impl_obj) {
  /*Unmarshall pup'd fields: unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d*/
  PUP::fromMem implP(impl_buf);
  unsigned char b; implP|b;
  char c; implP|c;
  short i; implP|i;
  unsigned short j; implP|j;
  int k; implP|k;
  unsigned int l; implP|l;
  long m; implP|m;
  unsigned long n; implP|n;
  float f; implP|f;
  double d; implP|d;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->basic(b, c, i, j, k, l, m, n, f, d);
  return implP.size();
}
void CkIndex_marshallElt::_marshallmessagepup_basic_marshall2(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d*/
  PUP::fromMem implP(impl_buf);
  unsigned char b; implP|b;
  char c; implP|c;
  short i; implP|i;
  unsigned short j; implP|j;
  int k; implP|k;
  unsigned int l; implP|l;
  long m; implP|m;
  unsigned long n; implP|n;
  float f; implP|f;
  double d; implP|d;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("b");
  implDestP|b;
  if (implDestP.hasComments()) implDestP.comment("c");
  implDestP|c;
  if (implDestP.hasComments()) implDestP.comment("i");
  implDestP|i;
  if (implDestP.hasComments()) implDestP.comment("j");
  implDestP|j;
  if (implDestP.hasComments()) implDestP.comment("k");
  implDestP|k;
  if (implDestP.hasComments()) implDestP.comment("l");
  implDestP|l;
  if (implDestP.hasComments()) implDestP.comment("m");
  implDestP|m;
  if (implDestP.hasComments()) implDestP.comment("n");
  implDestP|n;
  if (implDestP.hasComments()) implDestP.comment("f");
  implDestP|f;
  if (implDestP.hasComments()) implDestP.comment("d");
  implDestP|d;
}

/* DEFS: void flatRef(const flatStruct &s);
 */
void CProxy_marshallElt::flatRef(const flatStruct &s, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const flatStruct &s
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(flatStruct &)s;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(flatStruct &)s;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_marshallElt::__idx_flatRef_marshall3,0);
}
 int CkIndex_marshallElt::__idx_flatRef_marshall3=0;
void CkIndex_marshallElt::_call_flatRef_marshall3(void* impl_msg,marshallElt * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const flatStruct &s*/
  PUP::fromMem implP(impl_buf);
  flatStruct s; implP|s;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->flatRef(s);
}
int CkIndex_marshallElt::_callmarshall_flatRef_marshall3(char* impl_buf,marshallElt * impl_obj) {
  /*Unmarshall pup'd fields: const flatStruct &s*/
  PUP::fromMem implP(impl_buf);
  flatStruct s; implP|s;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->flatRef(s);
  return implP.size();
}
void CkIndex_marshallElt::_marshallmessagepup_flatRef_marshall3(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const flatStruct &s*/
  PUP::fromMem implP(impl_buf);
  flatStruct s; implP|s;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("s");
  implDestP|s;
}

/* DEFS: void pupped(const pupStruct &s);
 */
void CProxy_marshallElt::pupped(const pupStruct &s, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const pupStruct &s
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(pupStruct &)s;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(pupStruct &)s;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_marshallElt::__idx_pupped_marshall4,0);
}
 int CkIndex_marshallElt::__idx_pupped_marshall4=0;
void CkIndex_marshallElt::_call_pupped_marshall4(void* impl_msg,marshallElt * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const pupStruct &s*/
  PUP::fromMem implP(impl_buf);
  pupStruct s; implP|s;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->pupped(s);
}
int CkIndex_marshallElt::_callmarshall_pupped_marshall4(char* impl_buf,marshallElt * impl_obj) {
  /*Unmarshall pup'd fields: const pupStruct &s*/
  PUP::fromMem implP(impl_buf);
  pupStruct s; implP|s;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->pupped(s);
  return implP.size();
}
void CkIndex_marshallElt::_marshallmessagepup_pupped_marshall4(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const pupStruct &s*/
  PUP::fromMem implP(impl_buf);
  pupStruct s; implP|s;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("s");
  implDestP|s;
}

/* DEFS: void puppedSubclass(const pupStruct &s);
 */
void CProxy_marshallElt::puppedSubclass(const pupStruct &s, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const pupStruct &s
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(pupStruct &)s;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(pupStruct &)s;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_marshallElt::__idx_puppedSubclass_marshall5,0);
}
 int CkIndex_marshallElt::__idx_puppedSubclass_marshall5=0;
void CkIndex_marshallElt::_call_puppedSubclass_marshall5(void* impl_msg,marshallElt * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const pupStruct &s*/
  PUP::fromMem implP(impl_buf);
  pupStruct s; implP|s;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->puppedSubclass(s);
}
int CkIndex_marshallElt::_callmarshall_puppedSubclass_marshall5(char* impl_buf,marshallElt * impl_obj) {
  /*Unmarshall pup'd fields: const pupStruct &s*/
  PUP::fromMem implP(impl_buf);
  pupStruct s; implP|s;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->puppedSubclass(s);
  return implP.size();
}
void CkIndex_marshallElt::_marshallmessagepup_puppedSubclass_marshall5(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const pupStruct &s*/
  PUP::fromMem implP(impl_buf);
  pupStruct s; implP|s;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("s");
  implDestP|s;
}

/* DEFS: void PUPableReference(const CkReference<parent > &p);
 */
void CProxy_marshallElt::PUPableReference(const CkReference<parent > &p, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CkReference<parent > &p
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkReference<parent > &)p;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkReference<parent > &)p;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_marshallElt::__idx_PUPableReference_marshall6,0);
}
 int CkIndex_marshallElt::__idx_PUPableReference_marshall6=0;
void CkIndex_marshallElt::_call_PUPableReference_marshall6(void* impl_msg,marshallElt * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkReference<parent > &p*/
  PUP::fromMem implP(impl_buf);
  CkReference<parent > p; implP|p;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->PUPableReference(p);
}
int CkIndex_marshallElt::_callmarshall_PUPableReference_marshall6(char* impl_buf,marshallElt * impl_obj) {
  /*Unmarshall pup'd fields: const CkReference<parent > &p*/
  PUP::fromMem implP(impl_buf);
  CkReference<parent > p; implP|p;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->PUPableReference(p);
  return implP.size();
}
void CkIndex_marshallElt::_marshallmessagepup_PUPableReference_marshall6(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkReference<parent > &p*/
  PUP::fromMem implP(impl_buf);
  CkReference<parent > p; implP|p;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("p");
  implDestP|p;
}

/* DEFS: void PUPablePointer(const CkPointer<parent > &p);
 */
void CProxy_marshallElt::PUPablePointer(const CkPointer<parent > &p, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CkPointer<parent > &p
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkPointer<parent > &)p;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkPointer<parent > &)p;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_marshallElt::__idx_PUPablePointer_marshall7,0);
}
 int CkIndex_marshallElt::__idx_PUPablePointer_marshall7=0;
void CkIndex_marshallElt::_call_PUPablePointer_marshall7(void* impl_msg,marshallElt * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkPointer<parent > &p*/
  PUP::fromMem implP(impl_buf);
  CkPointer<parent > p; implP|p;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->PUPablePointer(p);
}
int CkIndex_marshallElt::_callmarshall_PUPablePointer_marshall7(char* impl_buf,marshallElt * impl_obj) {
  /*Unmarshall pup'd fields: const CkPointer<parent > &p*/
  PUP::fromMem implP(impl_buf);
  CkPointer<parent > p; implP|p;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->PUPablePointer(p);
  return implP.size();
}
void CkIndex_marshallElt::_marshallmessagepup_PUPablePointer_marshall7(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const CkPointer<parent > &p*/
  PUP::fromMem implP(impl_buf);
  CkPointer<parent > p; implP|p;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("p");
  implDestP|p;
}

/* DEFS: void simpleArray(int n, const int *arr);
 */
void CProxy_marshallElt::simpleArray(int n, const int *arr, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int n, const int *arr
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_arr, impl_cnt_arr;
  impl_off_arr=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_arr=sizeof(int)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|n;
    implP|impl_off_arr;
    implP|impl_cnt_arr;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|n;
    implP|impl_off_arr;
    implP|impl_cnt_arr;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_arr,arr,impl_cnt_arr);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_marshallElt::__idx_simpleArray_marshall8,0);
}
 int CkIndex_marshallElt::__idx_simpleArray_marshall8=0;
void CkIndex_marshallElt::_call_simpleArray_marshall8(void* impl_msg,marshallElt * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int n, const int *arr*/
  PUP::fromMem implP(impl_buf);
  int n; implP|n;
  int impl_off_arr, impl_cnt_arr; 
  implP|impl_off_arr;
  implP|impl_cnt_arr;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *arr=(int *)(impl_buf+impl_off_arr);
  impl_obj->simpleArray(n, arr);
}
int CkIndex_marshallElt::_callmarshall_simpleArray_marshall8(char* impl_buf,marshallElt * impl_obj) {
  /*Unmarshall pup'd fields: int n, const int *arr*/
  PUP::fromMem implP(impl_buf);
  int n; implP|n;
  int impl_off_arr, impl_cnt_arr; 
  implP|impl_off_arr;
  implP|impl_cnt_arr;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *arr=(int *)(impl_buf+impl_off_arr);
  impl_obj->simpleArray(n, arr);
  return implP.size();
}
void CkIndex_marshallElt::_marshallmessagepup_simpleArray_marshall8(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int n, const int *arr*/
  PUP::fromMem implP(impl_buf);
  int n; implP|n;
  int impl_off_arr, impl_cnt_arr; 
  implP|impl_off_arr;
  implP|impl_cnt_arr;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *arr=(int *)(impl_buf+impl_off_arr);
  if (implDestP.hasComments()) implDestP.comment("n");
  implDestP|n;
  if (implDestP.hasComments()) implDestP.comment("arr");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*arr))<impl_cnt_arr;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|arr[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
}

/* DEFS: void fancyArray(const int *arr2, int n, int m);
 */
void CProxy_marshallElt::fancyArray(const int *arr2, int n, int m, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const int *arr2, int n, int m
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_arr2, impl_cnt_arr2;
  impl_off_arr2=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_arr2=sizeof(int)*(n*m));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_arr2;
    implP|impl_cnt_arr2;
    implP|n;
    implP|m;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_arr2;
    implP|impl_cnt_arr2;
    implP|n;
    implP|m;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_arr2,arr2,impl_cnt_arr2);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_marshallElt::__idx_fancyArray_marshall9,0);
}
 int CkIndex_marshallElt::__idx_fancyArray_marshall9=0;
void CkIndex_marshallElt::_call_fancyArray_marshall9(void* impl_msg,marshallElt * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const int *arr2, int n, int m*/
  PUP::fromMem implP(impl_buf);
  int impl_off_arr2, impl_cnt_arr2; 
  implP|impl_off_arr2;
  implP|impl_cnt_arr2;
  int n; implP|n;
  int m; implP|m;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *arr2=(int *)(impl_buf+impl_off_arr2);
  impl_obj->fancyArray(arr2, n, m);
}
int CkIndex_marshallElt::_callmarshall_fancyArray_marshall9(char* impl_buf,marshallElt * impl_obj) {
  /*Unmarshall pup'd fields: const int *arr2, int n, int m*/
  PUP::fromMem implP(impl_buf);
  int impl_off_arr2, impl_cnt_arr2; 
  implP|impl_off_arr2;
  implP|impl_cnt_arr2;
  int n; implP|n;
  int m; implP|m;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *arr2=(int *)(impl_buf+impl_off_arr2);
  impl_obj->fancyArray(arr2, n, m);
  return implP.size();
}
void CkIndex_marshallElt::_marshallmessagepup_fancyArray_marshall9(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const int *arr2, int n, int m*/
  PUP::fromMem implP(impl_buf);
  int impl_off_arr2, impl_cnt_arr2; 
  implP|impl_off_arr2;
  implP|impl_cnt_arr2;
  int n; implP|n;
  int m; implP|m;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *arr2=(int *)(impl_buf+impl_off_arr2);
  if (implDestP.hasComments()) implDestP.comment("arr2");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*arr2))<impl_cnt_arr2;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|arr2[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("n");
  implDestP|n;
  if (implDestP.hasComments()) implDestP.comment("m");
  implDestP|m;
}

/* DEFS: void crazyArray(const int *arr1, const int *arr2, int n);
 */
void CProxy_marshallElt::crazyArray(const int *arr1, const int *arr2, int n, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const int *arr1, const int *arr2, int n
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_arr1, impl_cnt_arr1;
  impl_off_arr1=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_arr1=sizeof(int)*(arr2[0]));
  int impl_off_arr2, impl_cnt_arr2;
  impl_off_arr2=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_arr2=sizeof(int)*(arr1[0]+n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_arr1;
    implP|impl_cnt_arr1;
    implP|impl_off_arr2;
    implP|impl_cnt_arr2;
    implP|n;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_arr1;
    implP|impl_cnt_arr1;
    implP|impl_off_arr2;
    implP|impl_cnt_arr2;
    implP|n;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_arr1,arr1,impl_cnt_arr1);
  memcpy(impl_buf+impl_off_arr2,arr2,impl_cnt_arr2);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_marshallElt::__idx_crazyArray_marshall10,0);
}
 int CkIndex_marshallElt::__idx_crazyArray_marshall10=0;
void CkIndex_marshallElt::_call_crazyArray_marshall10(void* impl_msg,marshallElt * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const int *arr1, const int *arr2, int n*/
  PUP::fromMem implP(impl_buf);
  int impl_off_arr1, impl_cnt_arr1; 
  implP|impl_off_arr1;
  implP|impl_cnt_arr1;
  int impl_off_arr2, impl_cnt_arr2; 
  implP|impl_off_arr2;
  implP|impl_cnt_arr2;
  int n; implP|n;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *arr1=(int *)(impl_buf+impl_off_arr1);
  int *arr2=(int *)(impl_buf+impl_off_arr2);
  impl_obj->crazyArray(arr1, arr2, n);
}
int CkIndex_marshallElt::_callmarshall_crazyArray_marshall10(char* impl_buf,marshallElt * impl_obj) {
  /*Unmarshall pup'd fields: const int *arr1, const int *arr2, int n*/
  PUP::fromMem implP(impl_buf);
  int impl_off_arr1, impl_cnt_arr1; 
  implP|impl_off_arr1;
  implP|impl_cnt_arr1;
  int impl_off_arr2, impl_cnt_arr2; 
  implP|impl_off_arr2;
  implP|impl_cnt_arr2;
  int n; implP|n;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *arr1=(int *)(impl_buf+impl_off_arr1);
  int *arr2=(int *)(impl_buf+impl_off_arr2);
  impl_obj->crazyArray(arr1, arr2, n);
  return implP.size();
}
void CkIndex_marshallElt::_marshallmessagepup_crazyArray_marshall10(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: const int *arr1, const int *arr2, int n*/
  PUP::fromMem implP(impl_buf);
  int impl_off_arr1, impl_cnt_arr1; 
  implP|impl_off_arr1;
  implP|impl_cnt_arr1;
  int impl_off_arr2, impl_cnt_arr2; 
  implP|impl_off_arr2;
  implP|impl_cnt_arr2;
  int n; implP|n;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  int *arr1=(int *)(impl_buf+impl_off_arr1);
  int *arr2=(int *)(impl_buf+impl_off_arr2);
  if (implDestP.hasComments()) implDestP.comment("arr1");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*arr1))<impl_cnt_arr1;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|arr1[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("arr2");
  implDestP.synchronize(PUP::sync_begin_array);
  { for (int impl_i=0;impl_i*(sizeof(*arr2))<impl_cnt_arr2;impl_i++) { 
      implDestP.synchronize(PUP::sync_item);
      implDestP|arr2[impl_i];
  } } 
  implDestP.synchronize(PUP::sync_end_array);
  if (implDestP.hasComments()) implDestP.comment("n");
  implDestP|n;
}

/* DEFS: void msgQ(int nMsgs, const msgQ_t &q);
 */
void CProxy_marshallElt::msgQ(int nMsgs, const msgQ_t &q, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int nMsgs, const msgQ_t &q
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|nMsgs;
    //Have to cast away const-ness to get pup routine
    implP|(msgQ_t &)q;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|nMsgs;
    //Have to cast away const-ness to get pup routine
    implP|(msgQ_t &)q;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_marshallElt::__idx_msgQ_marshall11,0);
}
 int CkIndex_marshallElt::__idx_msgQ_marshall11=0;
void CkIndex_marshallElt::_call_msgQ_marshall11(void* impl_msg,marshallElt * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int nMsgs, const msgQ_t &q*/
  PUP::fromMem implP(impl_buf);
  int nMsgs; implP|nMsgs;
  msgQ_t q; implP|q;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->msgQ(nMsgs, q);
}
int CkIndex_marshallElt::_callmarshall_msgQ_marshall11(char* impl_buf,marshallElt * impl_obj) {
  /*Unmarshall pup'd fields: int nMsgs, const msgQ_t &q*/
  PUP::fromMem implP(impl_buf);
  int nMsgs; implP|nMsgs;
  msgQ_t q; implP|q;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->msgQ(nMsgs, q);
  return implP.size();
}
void CkIndex_marshallElt::_marshallmessagepup_msgQ_marshall11(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int nMsgs, const msgQ_t &q*/
  PUP::fromMem implP(impl_buf);
  int nMsgs; implP|nMsgs;
  msgQ_t q; implP|q;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("nMsgs");
  implDestP|nMsgs;
  if (implDestP.hasComments()) implDestP.comment("q");
  implDestP|q;
}

/* DEFS: void reflectMarshall(int forElt);
 */
void CProxy_marshallElt::reflectMarshall(int forElt, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int forElt
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|forElt;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|forElt;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_marshallElt::__idx_reflectMarshall_marshall12,0);
}
 int CkIndex_marshallElt::__idx_reflectMarshall_marshall12=0;
void CkIndex_marshallElt::_call_reflectMarshall_marshall12(void* impl_msg,marshallElt * impl_obj)
{
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int forElt*/
  PUP::fromMem implP(impl_buf);
  int forElt; implP|forElt;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->reflectMarshall(forElt);
}
int CkIndex_marshallElt::_callmarshall_reflectMarshall_marshall12(char* impl_buf,marshallElt * impl_obj) {
  /*Unmarshall pup'd fields: int forElt*/
  PUP::fromMem implP(impl_buf);
  int forElt; implP|forElt;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  impl_obj->reflectMarshall(forElt);
  return implP.size();
}
void CkIndex_marshallElt::_marshallmessagepup_reflectMarshall_marshall12(PUP::er &implDestP,void *impl_msg) {
  CkMarshallMsg *impl_msg_typed=(CkMarshallMsg *)impl_msg;
  char *impl_buf=impl_msg_typed->msgBuf;
  /*Unmarshall pup'd fields: int forElt*/
  PUP::fromMem implP(impl_buf);
  int forElt; implP|forElt;
  impl_buf+=CK_ALIGN(implP.size(),16);
  /*Unmarshall arrays:*/
  if (implDestP.hasComments()) implDestP.comment("forElt");
  implDestP|forElt;
}

/* DEFS: void done(void);
 */
void CProxy_marshallElt::done(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckBroadcast(impl_amsg, CkIndex_marshallElt::__idx_done_void,0);
}
 int CkIndex_marshallElt::__idx_done_void=0;
void CkIndex_marshallElt::_call_done_void(void* impl_msg,marshallElt * impl_obj)
{
  CkFreeSysMsg(impl_msg);
  impl_obj->done();
}

/* DEFS: marshallElt(CkMigrateMessage* impl_msg);
 */

/* DEFS: marshallElt(void);
 */

/* DEFS: void basic(unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d);
 */
void CProxySection_marshallElt::basic(unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|b;
    implP|c;
    implP|i;
    implP|j;
    implP|k;
    implP|l;
    implP|m;
    implP|n;
    implP|f;
    implP|d;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|b;
    implP|c;
    implP|i;
    implP|j;
    implP|k;
    implP|l;
    implP|m;
    implP|n;
    implP|f;
    implP|d;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_basic_marshall2,0);
}

/* DEFS: void flatRef(const flatStruct &s);
 */
void CProxySection_marshallElt::flatRef(const flatStruct &s, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const flatStruct &s
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(flatStruct &)s;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(flatStruct &)s;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_flatRef_marshall3,0);
}

/* DEFS: void pupped(const pupStruct &s);
 */
void CProxySection_marshallElt::pupped(const pupStruct &s, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const pupStruct &s
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(pupStruct &)s;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(pupStruct &)s;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_pupped_marshall4,0);
}

/* DEFS: void puppedSubclass(const pupStruct &s);
 */
void CProxySection_marshallElt::puppedSubclass(const pupStruct &s, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const pupStruct &s
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(pupStruct &)s;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(pupStruct &)s;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_puppedSubclass_marshall5,0);
}

/* DEFS: void PUPableReference(const CkReference<parent > &p);
 */
void CProxySection_marshallElt::PUPableReference(const CkReference<parent > &p, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CkReference<parent > &p
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkReference<parent > &)p;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkReference<parent > &)p;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_PUPableReference_marshall6,0);
}

/* DEFS: void PUPablePointer(const CkPointer<parent > &p);
 */
void CProxySection_marshallElt::PUPablePointer(const CkPointer<parent > &p, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const CkPointer<parent > &p
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    //Have to cast away const-ness to get pup routine
    implP|(CkPointer<parent > &)p;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    //Have to cast away const-ness to get pup routine
    implP|(CkPointer<parent > &)p;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_PUPablePointer_marshall7,0);
}

/* DEFS: void simpleArray(int n, const int *arr);
 */
void CProxySection_marshallElt::simpleArray(int n, const int *arr, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int n, const int *arr
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_arr, impl_cnt_arr;
  impl_off_arr=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_arr=sizeof(int)*(n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|n;
    implP|impl_off_arr;
    implP|impl_cnt_arr;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|n;
    implP|impl_off_arr;
    implP|impl_cnt_arr;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_arr,arr,impl_cnt_arr);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_simpleArray_marshall8,0);
}

/* DEFS: void fancyArray(const int *arr2, int n, int m);
 */
void CProxySection_marshallElt::fancyArray(const int *arr2, int n, int m, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const int *arr2, int n, int m
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_arr2, impl_cnt_arr2;
  impl_off_arr2=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_arr2=sizeof(int)*(n*m));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_arr2;
    implP|impl_cnt_arr2;
    implP|n;
    implP|m;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_arr2;
    implP|impl_cnt_arr2;
    implP|n;
    implP|m;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_arr2,arr2,impl_cnt_arr2);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_fancyArray_marshall9,0);
}

/* DEFS: void crazyArray(const int *arr1, const int *arr2, int n);
 */
void CProxySection_marshallElt::crazyArray(const int *arr1, const int *arr2, int n, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: const int *arr1, const int *arr2, int n
  int impl_off=0;
  int impl_arrstart=0;
  int impl_off_arr1, impl_cnt_arr1;
  impl_off_arr1=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_arr1=sizeof(int)*(arr2[0]));
  int impl_off_arr2, impl_cnt_arr2;
  impl_off_arr2=impl_off=CK_ALIGN(impl_off,sizeof(int));
  impl_off+=(impl_cnt_arr2=sizeof(int)*(arr1[0]+n));
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|impl_off_arr1;
    implP|impl_cnt_arr1;
    implP|impl_off_arr2;
    implP|impl_cnt_arr2;
    implP|n;
    impl_arrstart=CK_ALIGN(implP.size(),16);
    impl_off+=impl_arrstart;
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|impl_off_arr1;
    implP|impl_cnt_arr1;
    implP|impl_off_arr2;
    implP|impl_cnt_arr2;
    implP|n;
  }
  char *impl_buf=impl_msg->msgBuf+impl_arrstart;
  memcpy(impl_buf+impl_off_arr1,arr1,impl_cnt_arr1);
  memcpy(impl_buf+impl_off_arr2,arr2,impl_cnt_arr2);
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_crazyArray_marshall10,0);
}

/* DEFS: void msgQ(int nMsgs, const msgQ_t &q);
 */
void CProxySection_marshallElt::msgQ(int nMsgs, const msgQ_t &q, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int nMsgs, const msgQ_t &q
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|nMsgs;
    //Have to cast away const-ness to get pup routine
    implP|(msgQ_t &)q;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|nMsgs;
    //Have to cast away const-ness to get pup routine
    implP|(msgQ_t &)q;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_msgQ_marshall11,0);
}

/* DEFS: void reflectMarshall(int forElt);
 */
void CProxySection_marshallElt::reflectMarshall(int forElt, const CkEntryOptions *impl_e_opts) 
{
  ckCheck();
  //Marshall: int forElt
  int impl_off=0;
  { //Find the size of the PUP'd data
    PUP::sizer implP;
    implP|forElt;
    impl_off+=implP.size();
  }
  CkMarshallMsg *impl_msg=CkAllocateMarshallMsg(impl_off,impl_e_opts);
  { //Copy over the PUP'd data
    PUP::toMem implP((void *)impl_msg->msgBuf);
    implP|forElt;
  }
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_reflectMarshall_marshall12,0);
}

/* DEFS: void done(void);
 */
void CProxySection_marshallElt::done(void) 
{
  ckCheck();
  void *impl_msg = CkAllocSysMsg();
  CkArrayMessage *impl_amsg=(CkArrayMessage *)impl_msg;
  impl_amsg->array_setIfNotThere(CkArray_IfNotThere_buffer);
  ckSend(impl_amsg, CkIndex_marshallElt::__idx_done_void,0);
}

#endif /*CK_TEMPLATES_ONLY*/
#ifndef CK_TEMPLATES_ONLY
void CkIndex_marshallElt::__register(const char *s, size_t size) {
  __idx = CkRegisterChare(s, size);
  CkRegisterBase(__idx, CkIndex_ArrayElement::__idx);
// REG: marshallElt(CkMigrateMessage* impl_msg);
  __idx_marshallElt_CkMigrateMessage = CkRegisterEp("marshallElt(CkMigrateMessage* impl_msg)",
     (CkCallFnPtr)_call_marshallElt_CkMigrateMessage, 0, __idx, 0);
  CkRegisterMigCtor(__idx, __idx_marshallElt_CkMigrateMessage);

// REG: marshallElt(void);
  __idx_marshallElt_void = CkRegisterEp("marshallElt(void)",
     (CkCallFnPtr)_call_marshallElt_void, 0, __idx, 0);
  CkRegisterDefaultCtor(__idx, __idx_marshallElt_void);

// REG: void basic(unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d);
  __idx_basic_marshall2 = CkRegisterEp("basic(unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d)",
     (CkCallFnPtr)_call_basic_marshall2, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_basic_marshall2,(CkMarshallUnpackFn)_callmarshall_basic_marshall2);
  CkRegisterMessagePupFn(__idx_basic_marshall2,(CkMessagePupFn)_marshallmessagepup_basic_marshall2);

// REG: void flatRef(const flatStruct &s);
  __idx_flatRef_marshall3 = CkRegisterEp("flatRef(const flatStruct &s)",
     (CkCallFnPtr)_call_flatRef_marshall3, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_flatRef_marshall3,(CkMarshallUnpackFn)_callmarshall_flatRef_marshall3);
  CkRegisterMessagePupFn(__idx_flatRef_marshall3,(CkMessagePupFn)_marshallmessagepup_flatRef_marshall3);

// REG: void pupped(const pupStruct &s);
  __idx_pupped_marshall4 = CkRegisterEp("pupped(const pupStruct &s)",
     (CkCallFnPtr)_call_pupped_marshall4, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_pupped_marshall4,(CkMarshallUnpackFn)_callmarshall_pupped_marshall4);
  CkRegisterMessagePupFn(__idx_pupped_marshall4,(CkMessagePupFn)_marshallmessagepup_pupped_marshall4);

// REG: void puppedSubclass(const pupStruct &s);
  __idx_puppedSubclass_marshall5 = CkRegisterEp("puppedSubclass(const pupStruct &s)",
     (CkCallFnPtr)_call_puppedSubclass_marshall5, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_puppedSubclass_marshall5,(CkMarshallUnpackFn)_callmarshall_puppedSubclass_marshall5);
  CkRegisterMessagePupFn(__idx_puppedSubclass_marshall5,(CkMessagePupFn)_marshallmessagepup_puppedSubclass_marshall5);

// REG: void PUPableReference(const CkReference<parent > &p);
  __idx_PUPableReference_marshall6 = CkRegisterEp("PUPableReference(const CkReference<parent > &p)",
     (CkCallFnPtr)_call_PUPableReference_marshall6, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_PUPableReference_marshall6,(CkMarshallUnpackFn)_callmarshall_PUPableReference_marshall6);
  CkRegisterMessagePupFn(__idx_PUPableReference_marshall6,(CkMessagePupFn)_marshallmessagepup_PUPableReference_marshall6);

// REG: void PUPablePointer(const CkPointer<parent > &p);
  __idx_PUPablePointer_marshall7 = CkRegisterEp("PUPablePointer(const CkPointer<parent > &p)",
     (CkCallFnPtr)_call_PUPablePointer_marshall7, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_PUPablePointer_marshall7,(CkMarshallUnpackFn)_callmarshall_PUPablePointer_marshall7);
  CkRegisterMessagePupFn(__idx_PUPablePointer_marshall7,(CkMessagePupFn)_marshallmessagepup_PUPablePointer_marshall7);

// REG: void simpleArray(int n, const int *arr);
  __idx_simpleArray_marshall8 = CkRegisterEp("simpleArray(int n, const int *arr)",
     (CkCallFnPtr)_call_simpleArray_marshall8, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_simpleArray_marshall8,(CkMarshallUnpackFn)_callmarshall_simpleArray_marshall8);
  CkRegisterMessagePupFn(__idx_simpleArray_marshall8,(CkMessagePupFn)_marshallmessagepup_simpleArray_marshall8);

// REG: void fancyArray(const int *arr2, int n, int m);
  __idx_fancyArray_marshall9 = CkRegisterEp("fancyArray(const int *arr2, int n, int m)",
     (CkCallFnPtr)_call_fancyArray_marshall9, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_fancyArray_marshall9,(CkMarshallUnpackFn)_callmarshall_fancyArray_marshall9);
  CkRegisterMessagePupFn(__idx_fancyArray_marshall9,(CkMessagePupFn)_marshallmessagepup_fancyArray_marshall9);

// REG: void crazyArray(const int *arr1, const int *arr2, int n);
  __idx_crazyArray_marshall10 = CkRegisterEp("crazyArray(const int *arr1, const int *arr2, int n)",
     (CkCallFnPtr)_call_crazyArray_marshall10, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_crazyArray_marshall10,(CkMarshallUnpackFn)_callmarshall_crazyArray_marshall10);
  CkRegisterMessagePupFn(__idx_crazyArray_marshall10,(CkMessagePupFn)_marshallmessagepup_crazyArray_marshall10);

// REG: void msgQ(int nMsgs, const msgQ_t &q);
  __idx_msgQ_marshall11 = CkRegisterEp("msgQ(int nMsgs, const msgQ_t &q)",
     (CkCallFnPtr)_call_msgQ_marshall11, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_msgQ_marshall11,(CkMarshallUnpackFn)_callmarshall_msgQ_marshall11);
  CkRegisterMessagePupFn(__idx_msgQ_marshall11,(CkMessagePupFn)_marshallmessagepup_msgQ_marshall11);

// REG: void reflectMarshall(int forElt);
  __idx_reflectMarshall_marshall12 = CkRegisterEp("reflectMarshall(int forElt)",
     (CkCallFnPtr)_call_reflectMarshall_marshall12, CkMarshallMsg::__idx, __idx, 0+CK_EP_NOKEEP);
  CkRegisterMarshallUnpackFn(__idx_reflectMarshall_marshall12,(CkMarshallUnpackFn)_callmarshall_reflectMarshall_marshall12);
  CkRegisterMessagePupFn(__idx_reflectMarshall_marshall12,(CkMessagePupFn)_marshallmessagepup_reflectMarshall_marshall12);

// REG: void done(void);
  __idx_done_void = CkRegisterEp("done(void)",
     (CkCallFnPtr)_call_done_void, 0, __idx, 0);

      _registerInitCall(marshallElt::eltInit,1);
}
#endif

#ifndef CK_TEMPLATES_ONLY
void _registermarshall(void)
{
  static int _done = 0; if(_done) return; _done = 1;
      PUPable_reg(parent);
      PUPable_reg(child);

      _registerInitCall(marshallInit,1);

/* REG: array marshallElt: ArrayElement{
marshallElt(CkMigrateMessage* impl_msg);
marshallElt(void);
void basic(unsigned char b, char c, short i, unsigned short j, int k, unsigned int l, long m, unsigned long n, float f, double d);
void flatRef(const flatStruct &s);
void pupped(const pupStruct &s);
void puppedSubclass(const pupStruct &s);
void PUPableReference(const CkReference<parent > &p);
void PUPablePointer(const CkPointer<parent > &p);
void simpleArray(int n, const int *arr);
void fancyArray(const int *arr2, int n, int m);
void crazyArray(const int *arr1, const int *arr2, int n);
void msgQ(int nMsgs, const msgQ_t &q);
void reflectMarshall(int forElt);
void done(void);
  initcall void eltInit(void);
};
*/
  CkIndex_marshallElt::__register("marshallElt", sizeof(marshallElt));

}
#endif
