/*
 * Decompiled with CFR 0.152.
 */
package charm.ccs;

import charm.ccs.CcsProgress;
import charm.ccs.CcsServer;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Stack;

public class CcsThread
implements Runnable {
    private boolean isBad;
    private Stack requests = new Stack();
    private volatile boolean keepGoing;
    private CcsServer ccs;
    private CcsProgress status;
    private Thread myThread;
    private String hostName;
    private int port;

    public CcsThread(CcsProgress ccsProgress, String string, int n) {
        this.status = ccsProgress;
        this.hostName = string;
        this.port = n;
        this.isBad = false;
        this.keepGoing = true;
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public void addRequest(request request2) {
        this.addRequest(request2, false);
    }

    public void addRequest(request request2, boolean bl) {
        if (bl) {
            while (!this.requests.empty()) {
                this.requests.pop();
            }
        }
        this.requests.push(request2);
    }

    public void finish() {
        this.keepGoing = false;
    }

    public boolean isInvalid() {
        return this.isBad;
    }

    private void ioError(Exception exception, String string) {
        this.isBad = true;
        this.keepGoing = false;
        this.status.setText(string + " (" + this.hostName + ":" + this.port + ")");
        System.out.println("ERROR> " + string);
        System.out.println("Traceback: " + exception);
        exception.printStackTrace();
    }

    public void run() {
        System.out.println("Connecting to " + this.hostName + ":" + this.port + "...\n");
        this.status.setText("Connecting to " + this.hostName + ":" + this.port + "...");
        try {
            this.ccs = new CcsServer(this.hostName, this.port);
        }
        catch (UnknownHostException unknownHostException) {
            this.ioError(unknownHostException, "Bad host name");
        }
        catch (IOException iOException) {
            this.ioError(iOException, "Could not connect");
        }
        if (!this.keepGoing) {
            return;
        }
        this.status.setText("Connected to " + this.hostName + " (" + this.ccs.getNumPes() + " processors)");
        while (this.keepGoing) {
            byte[] byArray;
            while (this.requests.empty() && this.keepGoing) {
                try {
                    int n = 30;
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!this.keepGoing) break;
            request request2 = (request)this.requests.pop();
            this.status.setText("Sending request " + request2.getHandler());
            try {
                this.ccs.sendRequest(request2.getHandler(), request2.getPE(), request2.getData());
            }
            catch (IOException iOException) {
                this.ioError(iOException, "Error sending request");
                break;
            }
            try {
                byArray = this.ccs.recvResponse();
            }
            catch (IOException iOException) {
                this.ioError(iOException, "Error receiving response");
                break;
            }
            request2.handleReply(byArray);
            this.status.setText("");
        }
    }

    public static class request
    extends message {
        int onPE;
        String handler;

        public request(String string, byte[] byArray) {
            super(byArray);
            this.handler = string;
        }

        public request(String string, int n) {
            super(n);
            this.handler = string;
        }

        public void setPE(int n) {
            this.onPE = n;
        }

        public int getPE() {
            return this.onPE;
        }

        public String getHandler() {
            return this.handler;
        }

        public void handleReply(byte[] byArray) {
            if (byArray.length != 0) {
                System.out.println("Overload handleReply to actually use these " + byArray.length + " bytes of reply!");
            }
        }
    }

    public static class message {
        private byte[] data;

        public message(byte[] byArray) {
            this.data = byArray;
        }

        public message(int n) {
            this.data = new byte[n];
        }

        public byte[] getData() {
            return this.data;
        }

        protected void setData(byte[] byArray) {
            this.data = byArray;
        }
    }
}

