/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;

public class OrderedGraphDataList {
    private Link head;
    private Link pre;
    private int len;

    public Color currentC() {
        Link cur = this.nextLink();
        if (cur == null) {
            return null;
        }
        return cur.color;
    }

    public int currentY() {
        Link cur = this.nextLink();
        if (cur == null) {
            return -1;
        }
        return cur.height;
    }

    public boolean hasMoreElements() {
        return this.nextLink() != null;
    }

    public void insert(int y, Color c) {
        this.reset();
        Link tmp = this.nextLink();
        while (tmp != null && tmp.height < y) {
            this.pre = tmp;
            tmp = this.nextLink();
        }
        if (tmp == null) {
            Link newLink = new Link(y, c, tmp);
            if (this.head == null) {
                this.head = newLink;
            } else {
                this.pre.next = newLink;
            }
            ++this.len;
        } else if (y == tmp.height) {
            tmp.color = c;
        } else {
            Link newLink = new Link(y, c, tmp);
            if (this.head == tmp) {
                this.head = newLink;
            } else {
                this.pre.next = newLink;
            }
            ++this.len;
        }
    }

    public void nextElement() {
        this.pre = this.pre == null ? this.head : this.pre.next;
    }

    private Link nextLink() {
        if (this.pre == null) {
            return this.head;
        }
        return this.pre.next;
    }

    public void removeAll() {
        this.pre = null;
        this.head = null;
        this.len = 0;
    }

    public void reset() {
        this.pre = null;
    }

    public int size() {
        return this.len;
    }

    class Link {
        int height;
        Color color;
        Link next;

        Link(int h, Color c, Link n) {
            this.height = h;
            this.color = c;
            this.next = n;
        }
    }
}

