/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import projections.gui.GraphData;
import projections.gui.MainWindow;

public class GraphTitleCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private GraphData data;
    private FontMetrics fm;

    public GraphTitleCanvas() {
        this.setBackground(MainWindow.runObject[this.myRun].background);
        this.setForeground(MainWindow.runObject[this.myRun].foreground);
    }

    public int getPreferredHeight() {
        Graphics g;
        int h = 0;
        if (this.fm == null && (g = this.getGraphics()) != null) {
            this.fm = g.getFontMetrics(g.getFont());
        }
        if (this.fm != null) {
            h = this.fm.getHeight() + 20;
        }
        return h;
    }

    public void paint(Graphics g) {
        String title;
        if (this.data == null) {
            return;
        }
        if (this.fm == null) {
            this.fm = g.getFontMetrics(g.getFont());
        }
        if (this.data.xmode == 0) {
            title = "Interval";
            if (this.data.interval.list.size() > 1) {
                title = title + "s";
            }
            title = title + " " + this.data.interval.string;
        } else {
            title = "Processor";
            if (this.data.processor.list.size() > 1) {
                title = title + "s";
            }
            title = title + " " + this.data.processor.string;
        }
        int x = (this.getSize().width - this.fm.stringWidth(title)) / 2;
        int y = (this.getSize().height + this.fm.getHeight()) / 2;
        g.setColor(MainWindow.runObject[this.myRun].background);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.setColor(MainWindow.runObject[this.myRun].foreground);
        g.drawString(title, x, y);
    }

    public void print(Graphics pg) {
        ((Graphics2D)pg).setBackground(Color.white);
        this.setForeground(Color.black);
        int w = this.getSize().width;
        int h = this.getSize().height;
        pg.clearRect(0, 0, w, h);
        this.paint(pg);
        ((Graphics2D)pg).setBackground(Color.black);
        this.setForeground(Color.white);
    }

    public void setData(GraphData data) {
        this.data = data;
    }
}

