/*
 * Decompiled with CFR 0.152.
 */
package projections.gui.Timeline;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import javax.swing.ToolTipManager;
import projections.analysis.PackTime;
import projections.analysis.TimelineEvent;
import projections.gui.MainWindow;
import projections.gui.OrderedIntList;
import projections.gui.OrderedUsageList;
import projections.gui.Timeline.EntryMethodObject;
import projections.gui.Timeline.MainHandler;
import projections.gui.Timeline.TimelineMessage;
import projections.gui.Timeline.UserEventObject;
import projections.misc.LogLoadException;

public class Data {
    int myRun = 0;
    private MainHandler modificationHandler = null;
    private float scaleFactor = 1.0f;
    private double preferredViewTime = -1.0;
    private int mostRecentScaledScreenWidth;
    private OrderedIntList processorList;
    private OrderedIntList oldplist;
    private String oldpstring;
    private boolean colorbyObjectId;
    private boolean colorbyUserSupplied;
    private int[] entries;
    private Color[] entryColor;
    public EntryMethodObject[][] tloArray;
    public Vector[] mesgVector;
    public Vector[] oldmesgVector;
    public UserEventObject[][] timelineUserEventObjectsArray = null;
    float[] processorUsage;
    float[] idleUsage;
    float[] packUsage;
    OrderedUsageList[] entryUsageList;
    private long beginTime;
    private long endTime;
    long oldBT;
    long oldET;
    Map[] eventIDToMessageMap;
    Map[] eventIDToEntryMethodMap;
    Map messageToExecutingObjectsMap;
    Map messageToSendingObjectsMap;
    Map oidToEntryMethonObjectsMap;
    boolean showPacks;
    boolean showIdle;
    boolean showMsgs;
    boolean showUserEvents;
    public Font labelFont;
    public Font axisFont;
    private boolean useMinimalView = false;
    public Set drawMessagesForTheseObjects;
    public Set drawMessagesForTheseObjectsAlt;
    public float messageLineThickness = 2.5f;
    private boolean useCustomColors = false;
    private Color customForeground;
    private Color customBackground;
    private int selection1 = -1;
    private int selection2 = -1;
    private int highlight = -1;
    private boolean keepViewCentered = false;
    private Set highlightedObjects;
    private boolean traceMessagesOnHover;
    private boolean traceOIDOnHover;

    public boolean useMinimalView() {
        return this.useMinimalView;
    }

    public Data(MainHandler rh) {
        this.modificationHandler = rh;
        this.showPacks = false;
        this.showMsgs = true;
        this.showIdle = true;
        this.showUserEvents = true;
        this.processorList = MainWindow.runObject[this.myRun].getValidProcessorList();
        this.oldBT = -1L;
        this.oldET = -1L;
        this.oldplist = null;
        this.oldpstring = null;
        this.processorUsage = null;
        this.entryUsageList = null;
        this.beginTime = 0L;
        this.endTime = MainWindow.runObject[this.myRun].getTotalTime();
        this.drawMessagesForTheseObjects = new HashSet();
        this.drawMessagesForTheseObjectsAlt = new HashSet();
        this.tloArray = null;
        this.mesgVector = null;
        this.entries = new int[MainWindow.runObject[this.myRun].getNumUserEntries()];
        this.entryColor = MainWindow.runObject[this.myRun].getColorMap();
        this.labelFont = new Font("SansSerif", 0, 12);
        this.axisFont = new Font("SansSerif", 0, 10);
        this.highlightedObjects = new HashSet();
    }

    public void addProcessor(int pCreation) {
        int oldNumP = this.processorList.size();
        this.oldplist = this.processorList.copyOf();
        this.processorList.insert(pCreation);
        int newNumP = this.processorList.size();
        if (oldNumP != newNumP) {
            this.modificationHandler.notifyProcessorListHasChanged();
        }
    }

    public void setFontSizes(int labelFontSize, int axisFontSize, boolean useBoldForLabel) {
        this.labelFont = useBoldForLabel ? new Font("SansSerif", 1, labelFontSize) : new Font("SansSerif", 0, labelFontSize);
        this.axisFont = new Font("SansSerif", 0, axisFontSize);
    }

    public long beginTime() {
        return this.beginTime;
    }

    public boolean colorbyObjectId() {
        return this.colorbyObjectId;
    }

    private Vector createTL(int p, long bt, long et, Vector timelineEvents, Vector userEvents) {
        try {
            if (MainWindow.runObject[this.myRun].hasLogData()) {
                return MainWindow.runObject[this.myRun].logLoader.createtimeline(p, bt, et, timelineEvents, userEvents);
            }
            System.err.println("createTL: No log files available!");
            return null;
        }
        catch (LogLoadException e) {
            System.err.println("LOG LOAD EXCEPTION");
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void createTLOArray() {
        block51: {
            oldtloArray = this.tloArray;
            oldUserEventsArray = this.timelineUserEventObjectsArray;
            if (this.mesgVector != null) {
                this.oldmesgVector = this.mesgVector;
            }
            this.mesgVector = new Vector[this.numPEs()];
            i = 0;
            while (i < this.numPEs()) {
                this.mesgVector[i] = null;
                ++i;
            }
            this.tloArray = new EntryMethodObject[this.processorList.size()][];
            this.timelineUserEventObjectsArray = new UserEventObject[this.processorList.size()][];
            if (oldtloArray == null || this.beginTime < this.oldBT || this.endTime > this.oldET) break block51;
            oldpindex = 0;
            newpindex = 0;
            this.processorList.reset();
            this.oldplist.reset();
            newp = this.processorList.nextElement();
            oldp = this.oldplist.nextElement();
            ** GOTO lbl86
            {
                oldp = this.oldplist.nextElement();
                ++oldpindex;
                do {
                    if (oldp != -1 && oldp < newp) continue block1;
                    if (oldp == -1) break block1;
                    if (oldp == newp) {
                        if (this.beginTime == this.oldBT && this.endTime == this.oldET) {
                            this.tloArray[newpindex] = oldtloArray[oldpindex];
                            this.timelineUserEventObjectsArray[newpindex] = oldUserEventsArray[oldpindex];
                            this.mesgVector[oldp] = this.oldmesgVector[newp];
                        } else {
                            oldNumItems = oldtloArray[oldpindex].length;
                            newNumItems = 0;
                            startIndex = 0;
                            endIndex = oldNumItems - 1;
                            n = 0;
                            while (n < oldNumItems) {
                                if (oldtloArray[oldpindex][n].getEndTime() >= this.beginTime) break;
                                ++startIndex;
                                ++n;
                            }
                            n = oldNumItems - 1;
                            while (n >= 0) {
                                if (oldtloArray[oldpindex][n].getBeginTime() <= this.endTime) break;
                                --endIndex;
                                --n;
                            }
                            newNumItems = endIndex - startIndex + 1;
                            this.tloArray[newpindex] = new EntryMethodObject[newNumItems];
                            this.mesgVector[newp] = new Vector<E>();
                            n = 0;
                            while (n < newNumItems) {
                                this.tloArray[newpindex][n] = oldtloArray[oldpindex][n + startIndex];
                                this.tloArray[newpindex][n].setUsage();
                                this.tloArray[newpindex][n].setPackUsage();
                                this.mesgVector[newp].addAll(this.tloArray[newpindex][n].messages);
                                ++n;
                            }
                            if (oldUserEventsArray != null && oldUserEventsArray[oldpindex] != null) {
                                oldNumItems = oldUserEventsArray[oldpindex].length;
                                newNumItems = 0;
                                startIndex = 0;
                                endIndex = oldNumItems - 1;
                                n = 0;
                                while (n < oldNumItems) {
                                    if (oldUserEventsArray[oldpindex][n].EndTime >= this.beginTime) break;
                                    ++startIndex;
                                    ++n;
                                }
                                n = oldNumItems - 1;
                                while (n >= 0) {
                                    if (oldUserEventsArray[oldpindex][n].BeginTime <= this.endTime) break;
                                    --endIndex;
                                    --n;
                                }
                                newNumItems = endIndex - startIndex + 1;
                                this.timelineUserEventObjectsArray[newpindex] = new UserEventObject[newNumItems];
                                n = 0;
                                while (n < newNumItems) {
                                    this.timelineUserEventObjectsArray[newpindex][n] = oldUserEventsArray[oldpindex][startIndex + n];
                                    ++n;
                                }
                            }
                        }
                    }
                    newp = this.processorList.nextElement();
                    ++newpindex;
lbl86:
                    // 2 sources

                } while (newp != -1);
            }
            oldtloArray = null;
            oldUserEventsArray = null;
        }
        this.processorList.reset();
        numPs = this.processorList.size();
        progressBar = new ProgressMonitor(MainWindow.runObject[this.myRun].guiRoot, "Reading timeline data", "", 0, numPs);
        progressBar.setProgress(0);
        p = 0;
        while (p < numPs) {
            if (progressBar.isCanceled()) break;
            progressBar.setNote(String.valueOf(p) + " of " + numPs);
            progressBar.setProgress(p);
            pnum = this.processorList.nextElement();
            if (this.tloArray[p] == null) {
                this.tloArray[p] = this.getData(pnum, p);
            }
            ++p;
        }
        progressBar.close();
        e = 0;
        while (e < MainWindow.runObject[this.myRun].getNumUserEntries()) {
            this.entries[e] = 0;
            ++e;
        }
        this.processorUsage = new float[this.tloArray.length];
        this.entryUsageList = new OrderedUsageList[this.tloArray.length];
        entryUsageArray = new float[MainWindow.runObject[this.myRun].getNumUserEntries()];
        this.idleUsage = new float[this.tloArray.length];
        this.packUsage = new float[this.tloArray.length];
        p = 0;
        while (p < this.tloArray.length) {
            this.processorUsage[p] = 0.0f;
            this.idleUsage[p] = 0.0f;
            this.packUsage[p] = 0.0f;
            i = 0;
            while (i < MainWindow.runObject[this.myRun].getNumUserEntries()) {
                entryUsageArray[i] = 0.0f;
                ++i;
            }
            n = 0;
            while (n < this.tloArray[p].length) {
                usage = this.tloArray[p][n].getUsage();
                entrynum = this.tloArray[p][n].getEntry();
                if (entrynum >= 0) {
                    v0 = entrynum;
                    this.entries[v0] = this.entries[v0] + 1;
                    v1 = p;
                    this.processorUsage[v1] = this.processorUsage[v1] + usage;
                    v2 = p;
                    this.packUsage[v2] = this.packUsage[v2] + this.tloArray[p][n].getPackUsage();
                    v3 = entrynum;
                    entryUsageArray[v3] = entryUsageArray[v3] + this.tloArray[p][n].getNonPackUsage();
                } else {
                    v4 = p;
                    this.idleUsage[v4] = this.idleUsage[v4] + usage;
                }
                ++n;
            }
            this.entryUsageList[p] = new OrderedUsageList();
            i = 0;
            while (i < MainWindow.runObject[this.myRun].getNumUserEntries()) {
                if (entryUsageArray[i] > 0.0f) {
                    this.entryUsageList[p].insert(entryUsageArray[i], i);
                }
                ++i;
            }
            ++p;
        }
        progressBar = new ProgressMonitor(MainWindow.runObject[this.myRun].guiRoot, "Creating auxiliary data structures to speed up visualization", "", 0, 4);
        progressBar.setProgress(0);
        progressBar.setNote("Creating Map 1");
        this.eventIDToMessageMap = new HashMap[this.numPEs()];
        if (this.processorList != null) {
            i = 0;
            this.processorList.reset();
            while (this.processorList.hasMoreElements()) {
                p = this.processorList.nextElement();
                this.eventIDToMessageMap[p] = new HashMap<K, V>();
                if (this.mesgVector[p] != null) {
                    for (TimelineMessage msg : this.mesgVector[p]) {
                        if (msg == null) continue;
                        this.eventIDToMessageMap[p].put(msg.EventID, msg);
                    }
                } else {
                    System.out.println("Message vector is empty");
                }
                ++i;
            }
        }
        progressBar.setProgress(1);
        progressBar.setNote("Creating Map 2");
        this.eventIDToEntryMethodMap = new HashMap[this.numPEs()];
        if (this.processorList != null) {
            this.processorList.reset();
            i = 0;
            while (this.processorList.hasMoreElements()) {
                p = this.processorList.nextElement();
                this.eventIDToEntryMethodMap[p] = new HashMap<K, V>();
                if (this.tloArray[i] != null) {
                    j = 0;
                    while (j < this.tloArray[i].length) {
                        obj = this.tloArray[i][j];
                        if (obj != null) {
                            this.eventIDToEntryMethodMap[p].put(obj.EventID, obj);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        progressBar.setProgress(2);
        progressBar.setNote("Creating Map 3");
        this.messageToSendingObjectsMap = new HashMap<K, V>();
        i = 0;
        while (i < this.tloArray.length) {
            if (this.tloArray[i] != null) {
                j = 0;
                while (j < this.tloArray[i].length) {
                    obj = this.tloArray[i][j];
                    if (obj != null) {
                        for (TimelineMessage msg : obj.messages) {
                            this.messageToSendingObjectsMap.put(msg, obj);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        progressBar.setProgress(3);
        progressBar.setNote("Creating Map 4");
        this.messageToExecutingObjectsMap = new HashMap<K, V>();
        i = 0;
        while (i < this.tloArray.length) {
            if (this.tloArray[i] != null) {
                j = 0;
                while (j < this.tloArray[i].length) {
                    obj = this.tloArray[i][j];
                    if (obj != null && (msg = obj.creationMessage()) != null) {
                        if (this.messageToExecutingObjectsMap.containsKey(msg)) {
                            o = this.messageToExecutingObjectsMap.get(msg);
                            ts = (TreeSet)o;
                            ts.add(obj);
                        } else {
                            ts = new TreeSet<EntryMethodObject>();
                            ts.add(obj);
                            this.messageToExecutingObjectsMap.put(msg, ts);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        progressBar.setProgress(4);
        progressBar.setNote("Creating Map 5");
        this.oidToEntryMethonObjectsMap = new TreeMap<K, V>();
        i = 0;
        while (i < this.tloArray.length) {
            if (this.tloArray[i] != null) {
                j = 0;
                while (j < this.tloArray[i].length) {
                    obj = this.tloArray[i][j];
                    if (obj != null) {
                        id = obj.getTid();
                        if (this.oidToEntryMethonObjectsMap.containsKey(id)) {
                            s = (TreeSet)this.oidToEntryMethonObjectsMap.get(id);
                            s.add(obj);
                        } else {
                            s = new TreeSet();
                            s.add(obj);
                            this.oidToEntryMethonObjectsMap.put(id, s);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        progressBar.close();
    }

    public void decreaseScaleFactor() {
        this.setScaleFactor((float)((int)(this.getScaleFactor() * 4.0f) - 1) / 4.0f);
    }

    private void displayMustBeRedrawn() {
        if (this.modificationHandler != null) {
            this.modificationHandler.refreshDisplay(true);
        }
    }

    public void displayMustBeRepainted() {
        if (this.modificationHandler != null) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    public void clearAllLines() {
        this.drawMessagesForTheseObjects.clear();
        this.drawMessagesForTheseObjectsAlt.clear();
        this.displayMustBeRepainted();
    }

    public void toggleMessageSendLine(EntryMethodObject obj) {
        TimelineMessage created_message = obj.creationMessage();
        if (created_message != null) {
            if (this.drawMessagesForTheseObjects.contains(obj)) {
                this.drawMessagesForTheseObjects.remove(obj);
            } else {
                this.drawMessagesForTheseObjects.add(obj);
            }
            this.displayMustBeRepainted();
        } else {
            this.modificationHandler.displayWarning("Message was sent from outside the current time range");
        }
    }

    public void addMessageSendLine(EntryMethodObject obj) {
        this.drawMessagesForTheseObjects.add(obj);
    }

    public void addMessageSendLineAlt(Set s) {
        this.drawMessagesForTheseObjectsAlt.addAll(s);
    }

    public void addMessageSendLine(Set s) {
        this.drawMessagesForTheseObjects.addAll(s);
    }

    public void removeMessageSendLine(Set s) {
        this.drawMessagesForTheseObjects.removeAll(s);
        this.drawMessagesForTheseObjectsAlt.removeAll(s);
    }

    public void clearMessageSendLines() {
        this.drawMessagesForTheseObjects.clear();
        this.drawMessagesForTheseObjectsAlt.clear();
    }

    public long endTime() {
        return this.endTime;
    }

    public int[] entries() {
        return this.entries;
    }

    public Color[] entryColor() {
        return this.entryColor;
    }

    public Color getBackgroundColor() {
        if (this.useCustomColors) {
            return this.customBackground;
        }
        return MainWindow.runObject[this.myRun].background;
    }

    private EntryMethodObject[] getData(int pnum, int index) {
        Vector tl = new Vector();
        Vector userEvents = new Vector();
        this.mesgVector[pnum] = new Vector();
        this.createTL(pnum, this.beginTime, this.endTime, tl, userEvents);
        int numUserEvents = userEvents.size();
        if (numUserEvents > 0) {
            this.timelineUserEventObjectsArray[index] = new UserEventObject[numUserEvents];
            int i = 0;
            while (i < numUserEvents) {
                this.timelineUserEventObjectsArray[index][i] = (UserEventObject)userEvents.elementAt(i);
                ++i;
            }
        } else {
            this.timelineUserEventObjectsArray[index] = null;
        }
        int numItems = tl.size();
        EntryMethodObject[] tlo = new EntryMethodObject[numItems];
        int i = 0;
        while (i < numItems) {
            Vector packlist;
            TimelineEvent tle = (TimelineEvent)tl.elementAt(i);
            Vector msglist = tle.MsgsSent;
            TreeSet msgs = new TreeSet();
            if (msglist != null) {
                msgs.addAll(msglist);
                this.mesgVector[pnum].addAll(msglist);
            }
            int numpacks = (packlist = tle.PackTimes) == null ? 0 : packlist.size();
            PackTime[] packs = new PackTime[numpacks];
            int p = 0;
            while (p < numpacks) {
                packs[p] = (PackTime)packlist.elementAt(p);
                ++p;
            }
            tlo[i] = new EntryMethodObject(this, tle, msgs, packs, pnum);
            ++i;
        }
        return tlo;
    }

    public Color getForegroundColor() {
        if (this.useCustomColors) {
            return this.customForeground;
        }
        return MainWindow.runObject[this.myRun].foreground;
    }

    public int getNumUserEvents() {
        if (this.timelineUserEventObjectsArray == null) {
            return 0;
        }
        int num = 0;
        int i = 0;
        while (i < this.timelineUserEventObjectsArray.length) {
            if (this.timelineUserEventObjectsArray[i] != null) {
                num += this.timelineUserEventObjectsArray[i].length;
            }
            ++i;
        }
        return num;
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public void increaseScaleFactor() {
        this.setScaleFactor((float)((int)(this.getScaleFactor() * 4.0f) + 1) / 4.0f);
    }

    public int lineWidth(int actualDisplayWidth) {
        return actualDisplayWidth - 2 * this.offset();
    }

    public int maxLabelLen() {
        return 70;
    }

    public int numPs() {
        return this.processorList.size();
    }

    public int numPEs() {
        return MainWindow.runObject[this.myRun].getNumProcessors();
    }

    public int offset() {
        if (this.useMinimalView()) {
            return this.maxLabelLen() / 2;
        }
        return 5 + this.maxLabelLen() / 2;
    }

    public int leftOffset() {
        return this.offset();
    }

    public int rightOffset() {
        return this.offset();
    }

    public OrderedIntList oldplist() {
        return this.oldplist;
    }

    public String oldpstring() {
        return this.oldpstring;
    }

    public OrderedIntList processorList() {
        return this.processorList;
    }

    public int scaledScreenWidth(int actualDisplayWidth) {
        this.mostRecentScaledScreenWidth = (int)((float)actualDisplayWidth * this.scaleFactor);
        return this.mostRecentScaledScreenWidth;
    }

    public int screenHeight() {
        if (this.useMinimalView()) {
            return this.singleTimelineHeight() * this.numPs();
        }
        return this.singleTimelineHeight() * this.numPs() + 15;
    }

    public int barheight() {
        return 16;
    }

    public int singleTimelineHeight() {
        if (this.useMinimalView()) {
            return this.barheight() + 10;
        }
        return this.barheight() + 18;
    }

    public int userEventRectHeight() {
        return 5;
    }

    public void setColors(Color backgroundColor, Color foregroundColor) {
        this.customForeground = foregroundColor;
        this.customBackground = backgroundColor;
        this.useCustomColors = true;
        this.displayMustBeRedrawn();
    }

    public void setHandler(MainHandler rh) {
        this.modificationHandler = rh;
        this.displayMustBeRedrawn();
    }

    public void setProcessorList(OrderedIntList procs) {
        this.processorList = procs.copyOf();
    }

    public void setNewRange(long beginTime, long endTime) {
        this.oldBT = this.beginTime;
        this.oldET = this.endTime;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.oldplist = this.processorList == null ? null : this.processorList.copyOf();
        this.setScaleFactor(1.0f);
    }

    public void setRange(long beginTime, long endTime) {
        this.beginTime = beginTime;
        this.endTime = endTime;
    }

    public void setScaleFactor(float scale_) {
        this.scaleFactor = scale_;
        if ((double)this.scaleFactor < 1.0) {
            this.scaleFactor = 1.0f;
        }
        this.displayMustBeRedrawn();
    }

    public long startTime() {
        return this.beginTime();
    }

    public long totalTime() {
        return this.endTime - this.beginTime;
    }

    public boolean selectionValid() {
        return this.selection1 >= 0 && this.selection2 >= 0 && this.selection1 != this.selection2;
    }

    public boolean highlightValid() {
        return this.highlight >= 0;
    }

    public void invalidateSelection() {
        this.selection1 = -1;
        this.selection2 = -1;
        this.modificationHandler.refreshDisplay(false);
    }

    public int leftSelection() {
        if (this.selection1 < this.selection2) {
            return this.selection1;
        }
        return this.selection2;
    }

    public int rightSelection() {
        if (this.selection1 < this.selection2) {
            return this.selection2;
        }
        return this.selection1;
    }

    public int selectionWidth() {
        return this.rightSelection() - this.leftSelection();
    }

    public void setSelection1(int value) {
        this.selection1 = value;
        if (this.selectionValid()) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    public void setSelection2(int value) {
        this.selection2 = value;
        if (this.selectionValid()) {
            this.modificationHandler.refreshDisplay(false);
        }
    }

    public void removeHighlight() {
        this.highlight = -1;
        this.modificationHandler.refreshDisplay(false);
    }

    public void setHighlight(int x) {
        this.highlight = x;
        this.modificationHandler.refreshDisplay(false);
    }

    public int getHighlight() {
        return this.highlight;
    }

    public double getHighlightTime() {
        return this.screenToTime(this.getHighlight());
    }

    public double leftSelectionTime() {
        return this.screenToTime(this.leftSelection());
    }

    public double rightSelectionTime() {
        return this.screenToTime(this.rightSelection());
    }

    public long screenToTime(int xPixelCoord) {
        double fractionAlongAxis = (double)(xPixelCoord - this.leftOffset()) / (double)(this.mostRecentScaledScreenWidth - 2 * this.offset());
        return Math.round((double)this.beginTime + fractionAlongAxis * (double)(this.endTime - this.beginTime));
    }

    public int timeToScreenPixel(double time) {
        double fractionAlongTimeAxis = (time - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)Math.round(fractionAlongTimeAxis * (double)(this.mostRecentScaledScreenWidth - 2 * this.offset()));
    }

    public int timeToScreenPixelRight(double time) {
        double fractionAlongTimeAxis = (time + 0.5 - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)Math.floor(fractionAlongTimeAxis * (double)(this.mostRecentScaledScreenWidth - 2 * this.offset()));
    }

    public int timeToScreenPixelLeft(double time) {
        double fractionAlongTimeAxis = (time - 0.5 - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)Math.ceil(fractionAlongTimeAxis * (double)(this.mostRecentScaledScreenWidth - 2 * this.offset()));
    }

    public int timeToScreenPixel(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    public int timeToScreenPixelLeft(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time - 0.5 - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)Math.ceil(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    public int timeToScreenPixelRight(double time, int assumedScreenWidth) {
        double fractionAlongTimeAxis = (time + 0.5 - (double)this.beginTime) / (double)(this.endTime - this.beginTime);
        return this.offset() + (int)Math.floor(fractionAlongTimeAxis * (double)(assumedScreenWidth - 2 * this.offset()));
    }

    public void setPreferredViewTimeCenter(double time) {
        if (time > (double)this.beginTime && time < (double)this.endTime) {
            this.preferredViewTime = time;
        }
    }

    public int getNewPreferredViewCenter(int newScreenWidth) {
        double value = this.preferredViewTime;
        int coord = this.timeToScreenPixel(value, newScreenWidth);
        return coord;
    }

    public void resetPreferredView() {
        this.preferredViewTime = -1.0;
    }

    public boolean hasNewPreferredView() {
        return this.preferredViewTime >= 0.0 && (double)this.scaleFactor > 1.0;
    }

    public void setUseMinimalMargins(boolean useMinimalMargins) {
        this.useMinimalView = useMinimalMargins;
    }

    public void keepViewCentered(boolean b) {
        this.keepViewCentered = b;
    }

    public boolean keepViewCentered() {
        return this.keepViewCentered;
    }

    public int messageSendHeight() {
        return 5;
    }

    public int messagePackHeight() {
        return 3;
    }

    public void entryMethodObjectRightClick(EntryMethodObject obj) {
        if (!this.useMinimalView()) {
            this.addProcessor(obj.pCreation);
            this.toggleMessageSendLine(obj);
        }
    }

    public void clearObjectHighlights() {
        this.highlightedObjects.clear();
    }

    public void HighlightObjects(Set objects) {
        this.highlightedObjects.addAll(objects);
    }

    public boolean isObjectDimmed(Object o) {
        if (this.highlightedObjects.size() == 0) {
            return false;
        }
        return !this.highlightedObjects.contains(o);
    }

    public boolean isAnyObjectDimmed() {
        return this.highlightedObjects.size() > 0;
    }

    public boolean traceMessagesOnHover() {
        return this.traceMessagesOnHover;
    }

    public boolean traceOIDOnHover() {
        return this.traceOIDOnHover;
    }

    public void setTraceMessagesOnHover(boolean traceMessagesOnHover) {
        this.traceMessagesOnHover = traceMessagesOnHover;
        if (traceMessagesOnHover) {
            this.SetToolTipDelayLarge();
        } else {
            this.SetToolTipDelaySmall();
        }
    }

    public void setTraceOIDOnHover(boolean showOIDOnHover) {
        this.traceOIDOnHover = showOIDOnHover;
    }

    public void SetToolTipDelaySmall() {
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(600000);
    }

    public void SetToolTipDelayLarge() {
        ToolTipManager.sharedInstance().setInitialDelay(2000);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
    }

    public Color getMessageColor() {
        return Color.white;
    }

    public Color getMessageAltColor() {
        return Color.yellow;
    }

    public void setColorByIndex(boolean b) {
        this.colorbyObjectId = b;
        this.displayMustBeRepainted();
    }

    public void setColorByUserSupplied(boolean b) {
        this.colorbyUserSupplied = b;
        this.displayMustBeRepainted();
    }

    public boolean colorByUserSupplied() {
        return this.colorbyUserSupplied;
    }

    public void showUserEvents(boolean b) {
        this.showUserEvents = b;
    }

    public boolean showUserEvents() {
        return this.showUserEvents;
    }
}

