/*
 * Decompiled with CFR 0.152.
 */
package projections.gui;

import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ProgressMonitor;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import projections.analysis.AmpiFunctionData;
import projections.analysis.AmpiProcessProfile;
import projections.analysis.UsageCalc;
import projections.gui.AmpiProfileData;
import projections.gui.ColorManager;
import projections.gui.ColorSelectable;
import projections.gui.EntrySelectionDialog;
import projections.gui.JFloatTextField;
import projections.gui.MainWindow;
import projections.gui.ProfileGraph;
import projections.gui.ProjectionsWindow;
import projections.gui.RangeDialog;
import projections.gui.Util;

public class AmpiProfileWindow
extends ProjectionsWindow
implements ActionListener,
ColorSelectable,
ChangeListener {
    private static final long serialVersionUID = 1L;
    int myRun = 0;
    private AmpiProfileData data;
    private boolean colorsSet = false;
    private Color[] colors = null;
    private float[][] dataSource = null;
    private int[][] colorMap = null;
    private String[][] nameMap = null;
    private String[] procNames = null;
    private float[][] accTime = null;
    private float[] sDataSrc = null;
    private int[] sColorMap = null;
    private String[] sNameMap = null;
    private JTabbedPane tabPane;
    private ProfileGraph displayCanvas;
    private JScrollPane displayPanel;
    private int displayPanelTabIndex;
    private ProfileGraph ampiDisplayCanvas;
    private JScrollPane ampiDisplayPanel;
    private int ampiDisplayPanelTabIndex;
    private JButton btnIncX;
    private JButton btnDecX;
    private JButton btnResX;
    private JButton btnIncY;
    private JButton btnDecY;
    private JButton btnResY;
    private JFloatTextField txtScaleX;
    private JFloatTextField txtScaleY;
    private float[] avgData;
    private EntrySelectionDialog entryDialog;
    boolean ampiTraceOn = false;

    public AmpiProfileWindow(MainWindow parentWindow, Integer myWindowID) {
        super(parentWindow, myWindowID);
        if (MainWindow.runObject[this.myRun].getNumFunctionEvents() > 0) {
            this.ampiTraceOn = true;
        }
        this.setBackground(Color.lightGray);
        this.setTitle("Projections AMPI Usage Profile - " + MainWindow.runObject[this.myRun].getFilename() + ".sts");
        this.CreateMenus();
        this.CreateLayout();
        this.pack();
        this.showDialog();
    }

    protected void windowInit() {
        this.data = new AmpiProfileData(this);
        this.data.plist = MainWindow.runObject[this.myRun].getValidProcessorList();
        this.data.pstring = MainWindow.runObject[this.myRun].getValidProcessorString();
        this.data.begintime = 0L;
        this.data.endtime = MainWindow.runObject[this.myRun].getTotalTime();
    }

    private void CreateMenus() {
        JMenuBar mbar = new JMenuBar();
        mbar.add(Util.makeJMenu("File", new Object[]{"Select Processors", "Print Profile", null, "Close"}, null, this));
        if (this.ampiTraceOn) {
            mbar.add(Util.makeJMenu("Tools", new Object[]{"Change Colors", "Usage Table"}, null, this));
        }
        mbar.add(Util.makeJMenu("Help", new Object[]{"Index", "About"}, null, this));
        this.setJMenuBar(mbar);
    }

    private void CreateLayout() {
        JPanel wholePanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        this.displayCanvas = new ProfileGraph();
        this.displayPanel = new JScrollPane(this.displayCanvas);
        if (this.ampiTraceOn) {
            this.ampiDisplayCanvas = new ProfileGraph();
            this.ampiDisplayPanel = new JScrollPane(this.ampiDisplayCanvas);
            this.tabPane = new JTabbedPane();
            this.tabPane.add("Per Processor", this.displayPanel);
            this.tabPane.add("Per Function", this.ampiDisplayPanel);
            this.displayPanelTabIndex = this.tabPane.indexOfComponent(this.displayPanel);
            this.ampiDisplayPanelTabIndex = this.tabPane.indexOfComponent(this.ampiDisplayPanel);
            this.tabPane.addChangeListener(this);
        }
        JPanel xScalePanel = new JPanel();
        xScalePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "x-scale"));
        xScalePanel.setLayout(gbl);
        this.btnDecX = new JButton("<<");
        JLabel lScaleX = new JLabel("X-Axis Scale: ", 0);
        this.txtScaleX = new JFloatTextField(1.0f, 5);
        this.btnIncX = new JButton(">>");
        this.btnResX = new JButton("Reset");
        this.btnDecX.addActionListener(this);
        this.txtScaleX.addActionListener(this);
        this.btnIncX.addActionListener(this);
        this.btnResX.addActionListener(this);
        Util.gblAdd(xScalePanel, this.btnDecX, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(xScalePanel, lScaleX, gbc, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(xScalePanel, this.txtScaleX, gbc, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(xScalePanel, this.btnIncX, gbc, 3, 0, 1, 1, 0, 0);
        Util.gblAdd(xScalePanel, this.btnResX, gbc, 4, 0, 1, 1, 0, 0);
        JPanel yScalePanel = new JPanel();
        yScalePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), "y-scale"));
        yScalePanel.setLayout(gbl);
        this.btnDecY = new JButton("<<");
        JLabel lScaleY = new JLabel("Y-Axis Scale: ", 0);
        this.txtScaleY = new JFloatTextField(1.0f, 5);
        this.btnIncY = new JButton(">>");
        this.btnResY = new JButton("Reset");
        this.btnDecY.addActionListener(this);
        this.txtScaleY.addActionListener(this);
        this.btnIncY.addActionListener(this);
        this.btnResY.addActionListener(this);
        Util.gblAdd(yScalePanel, this.btnDecY, gbc, 0, 0, 1, 1, 0, 0);
        Util.gblAdd(yScalePanel, lScaleY, gbc, 1, 0, 1, 1, 0, 0);
        Util.gblAdd(yScalePanel, this.txtScaleY, gbc, 2, 0, 1, 1, 1, 0);
        Util.gblAdd(yScalePanel, this.btnIncY, gbc, 3, 0, 1, 1, 0, 0);
        Util.gblAdd(yScalePanel, this.btnResY, gbc, 4, 0, 1, 1, 0, 0);
        Container wholeContainer = this.getContentPane();
        wholeContainer.setLayout(gbl);
        if (this.ampiTraceOn) {
            Util.gblAdd(wholeContainer, this.tabPane, gbc, 0, 0, 2, 1, 1, 1, 5, 5, 5, 5);
        } else {
            Util.gblAdd(wholeContainer, this.displayPanel, gbc, 0, 0, 2, 1, 1, 1, 5, 5, 5, 5);
        }
        Util.gblAdd(wholeContainer, xScalePanel, gbc, 0, 1, 1, 1, 1, 0, 2, 2, 2, 2);
        Util.gblAdd(wholeContainer, yScalePanel, gbc, 1, 1, 1, 1, 1, 0, 2, 2, 2, 2);
    }

    public void showDialog() {
        if (this.dialog == null) {
            this.dialog = !MainWindow.runObject[this.myRun].hasLogData() && !MainWindow.runObject[this.myRun].hasSumDetailData() ? new RangeDialog(this, "AMPI Usage Profile", true) : new RangeDialog(this, "AMPI Usage Profile");
        } else {
            this.setDialogData();
        }
        this.dialog.displayDialog();
        if (!this.dialog.isCancelled()) {
            this.getDialogData();
            Thread t = new Thread(){

                public void run() {
                    AmpiProfileWindow.this.readAmpiUsageData();
                    if (AmpiProfileWindow.this.ampiTraceOn) {
                        AmpiProfileWindow.this.setDisplayProfileData();
                        AmpiProfileWindow.this.setAmpiDisplayProfileData();
                    }
                    AmpiProfileWindow.this.setLocationRelativeTo(AmpiProfileWindow.this.parentWindow);
                    AmpiProfileWindow.this.setVisible(true);
                }
            };
            t.start();
        }
    }

    public void getDialogData() {
        this.data.plist = this.dialog.getValidProcessors();
        this.data.pstring = this.dialog.getValidProcessorString();
        this.data.begintime = this.dialog.getStartTime();
        this.data.endtime = this.dialog.getEndTime();
    }

    public void setDialogData() {
        this.dialog.setValidProcessors(this.data.plist);
        this.dialog.setStartTime(this.data.begintime);
        this.dialog.setEndTime(this.data.endtime);
        super.setDialogData();
    }

    public void showWindow() {
    }

    public void actionPerformed(ActionEvent evt) {
        float oldScaleX = this.txtScaleX.getValue();
        float oldScaleY = this.txtScaleY.getValue();
        float scaleX = 0.0f;
        float scaleY = 0.0f;
        if (evt.getSource() instanceof JButton) {
            JButton b = (JButton)evt.getSource();
            if (b == this.btnDecX) {
                scaleX = (float)((int)(oldScaleX * 4.0f) - 1) / 4.0f;
                if ((double)scaleX < 1.0) {
                    scaleX = 1.0f;
                }
            } else if (b == this.btnIncX) {
                scaleX = (float)((int)(oldScaleX * 4.0f) + 1) / 4.0f;
            } else if (b == this.btnResX) {
                scaleX = 1.0f;
            } else if (b == this.btnDecY) {
                scaleY = (float)((int)(oldScaleY * 4.0f) - 1) / 4.0f;
                if ((double)scaleY < 1.0) {
                    scaleY = 1.0f;
                }
            } else if (b == this.btnIncY) {
                scaleY = (float)((int)(oldScaleY * 4.0f) + 1) / 4.0f;
            } else if (b == this.btnResY) {
                scaleY = 1.0f;
            }
            if (scaleX != oldScaleX && (double)scaleX > 0.0) {
                this.txtScaleX.setText("" + scaleX);
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleX(scaleX);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleX(scaleX);
                    }
                } else {
                    this.displayCanvas.setScaleX(scaleX);
                }
            }
            if (scaleY != oldScaleY && (double)scaleY > 0.0) {
                this.txtScaleY.setText("" + scaleY);
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleY(scaleY);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleY(scaleY);
                    }
                } else {
                    this.displayCanvas.setScaleY(scaleY);
                }
            }
        } else if (evt.getSource() instanceof JFloatTextField) {
            JFloatTextField field = (JFloatTextField)evt.getSource();
            if (field == this.txtScaleX) {
                scaleX = oldScaleX;
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleX(scaleX);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleX(scaleX);
                    }
                } else {
                    this.displayCanvas.setScaleX(scaleX);
                }
            } else if (field == this.txtScaleY) {
                scaleY = oldScaleY;
                if (this.ampiTraceOn) {
                    if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                        this.displayCanvas.setScaleY(scaleY);
                    } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                        this.ampiDisplayCanvas.setScaleY(scaleY);
                    }
                } else {
                    this.displayCanvas.setScaleY(scaleY);
                }
            }
        } else if (evt.getSource() instanceof JMenuItem) {
            String arg = ((JMenuItem)evt.getSource()).getText();
            if (arg.equals("Close")) {
                this.close();
            } else if (arg.equals("Select Processors")) {
                this.showDialog();
            } else if (arg.equals("Change Colors")) {
                this.showChangeColorDialog();
            } else if (arg.equals("Usage Table")) {
                this.showUsageTable();
            } else if (arg.equals("Usage Profile")) {
                this.showAMPIUsageProfile();
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.tabPane) {
            if (this.tabPane.getSelectedIndex() == this.displayPanelTabIndex) {
                this.txtScaleX.setText(this.displayCanvas.getScaleX() + "");
                this.txtScaleY.setText(this.displayCanvas.getScaleY() + "");
            } else if (this.tabPane.getSelectedIndex() == this.ampiDisplayPanelTabIndex) {
                this.txtScaleX.setText(this.ampiDisplayCanvas.getScaleX() + "");
                this.txtScaleY.setText(this.ampiDisplayCanvas.getScaleY() + "");
            }
        }
    }

    public void applyDialogColors() {
        int numFunc = MainWindow.runObject[this.myRun].getNumFunctionEvents();
        System.out.println(this.colors[numFunc]);
        this.displayCanvas.setDisplayDataSource(this.dataSource, this.colorMap, this.colors, this.nameMap);
        this.displayCanvas.repaint();
    }

    public void showChangeColorDialog() {
        int numFunc = MainWindow.runObject[this.myRun].getNumFunctionEvents();
        if (this.entryDialog == null) {
            String[] typeLabelStrings = new String[]{"Functions"};
            boolean[][] existsArray = new boolean[1][numFunc + 1];
            for (int i = 1; i < numFunc + 1; ++i) {
                existsArray[0][i] = true;
            }
            boolean[][] stateArray = new boolean[1][numFunc + 1];
            for (int i = 1; i < numFunc; ++i) {
                stateArray[0][i] = true;
            }
            String[] entryNames = new String[numFunc + 1];
            for (int i = 1; i < numFunc; ++i) {
                entryNames[i] = MainWindow.runObject[this.myRun].getFunctionName(i);
            }
            entryNames[numFunc] = "OTHER";
            Color[][] newColors = new Color[][]{this.colors};
            this.entryDialog = new EntrySelectionDialog(this, this, typeLabelStrings, stateArray, newColors, existsArray, entryNames);
        }
        this.entryDialog.showDialog();
    }

    private void showUsageTable() {
        if (this.dataSource == null) {
            return;
        }
        JFrame usageFrame = new JFrame();
        usageFrame.setTitle("Entry Points Usage Percent Table");
        usageFrame.setDefaultCloseOperation(2);
        Object[] tHeading = new String[]{"Proc#", "Entry Name", "Usage Percent (%)"};
        int totalEntry = 0;
        for (int i = 1; i < this.dataSource.length; ++i) {
            totalEntry += this.dataSource[i].length;
        }
        Object[][] tData = new Object[totalEntry][];
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(3);
        int entryCnt = 0;
        for (int i = 1; i < this.dataSource.length; ++i) {
            for (int j = 0; j < this.dataSource[i].length; ++j) {
                tData[entryCnt] = new Object[3];
                tData[entryCnt][0] = this.procNames[i];
                tData[entryCnt][1] = this.nameMap[i][j];
                tData[entryCnt][2] = df.format(this.dataSource[i][j]) + "%";
                ++entryCnt;
            }
        }
        JTable t = new JTable(tData, tHeading);
        JScrollPane sp = new JScrollPane(t);
        usageFrame.getContentPane().add(sp);
        usageFrame.setLocationRelativeTo(this.parentWindow);
        usageFrame.setSize(500, 250);
        usageFrame.setVisible(true);
    }

    private void showAMPIUsageProfile() {
        JFrame profileFrame = new JFrame();
        profileFrame.setTitle("AMPI Function Profile Table");
        profileFrame.setDefaultCloseOperation(2);
        Object[] tHeading = new String[]{"Processor#", "Function Name", "Source File Name", "Line#", "%/Total", "%/Process"};
        int curPe = -1;
        this.data.plist.reset();
        Vector[] ampiProcessVec = new Vector[this.data.plist.size()];
        int pCnt = 0;
        int totalLine = 0;
        while (this.data.plist.hasMoreElements()) {
            curPe = this.data.plist.nextElement();
            ampiProcessVec[pCnt] = new Vector();
            MainWindow.runObject[this.myRun].createAMPIUsage(curPe, this.data.begintime, this.data.endtime, ampiProcessVec[pCnt]);
            Vector v = ampiProcessVec[pCnt];
            for (int i = 0; i < v.size(); ++i) {
                AmpiProcessProfile p = (AmpiProcessProfile)v.get(i);
                totalLine += p.getFinalCallFuncStack().size();
            }
            ++pCnt;
        }
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(3);
        long totalExecTime = this.data.endtime - this.data.begintime;
        Object[][] tData = new Object[totalLine][];
        curPe = -1;
        this.data.plist.reset();
        pCnt = 0;
        int lineCnt = 0;
        while (this.data.plist.hasMoreElements()) {
            curPe = this.data.plist.nextElement();
            Vector v = ampiProcessVec[pCnt++];
            for (int i = 0; i < v.size(); ++i) {
                AmpiProcessProfile p = (AmpiProcessProfile)v.get(i);
                long processTotalExecTime = p.getAccExecTime();
                Stack stk = p.getFinalCallFuncStack();
                Enumeration e = stk.elements();
                while (e.hasMoreElements()) {
                    AmpiFunctionData d = (AmpiFunctionData)e.nextElement();
                    tData[lineCnt] = new Object[tHeading.length];
                    tData[lineCnt][0] = "" + curPe;
                    tData[lineCnt][1] = MainWindow.runObject[this.myRun].getFunctionName(d.FunctionID);
                    tData[lineCnt][2] = d.sourceFileName;
                    tData[lineCnt][3] = "" + d.LineNo;
                    tData[lineCnt][4] = df.format((double)d.getAccExecTime() / (double)totalExecTime * 100.0) + "%";
                    tData[lineCnt][5] = df.format((double)d.getAccExecTime() / (double)processTotalExecTime * 100.0) + "%";
                    ++lineCnt;
                }
            }
        }
        JTable t = new JTable(tData, tHeading);
        JScrollPane sp = new JScrollPane(t);
        profileFrame.getContentPane().add(sp);
        profileFrame.setLocationRelativeTo(this);
        profileFrame.setSize(500, 250);
        profileFrame.setVisible(true);
    }

    void readAmpiUsageData() {
        int numPes = this.data.plist.size();
        this.accTime = new float[numPes][];
        int progressCount = 0;
        int curPe = 0;
        UsageCalc u = new UsageCalc();
        ProgressMonitor progressBar = new ProgressMonitor(this, "Computing Usage Values", "", 0, this.data.numPs);
        this.data.plist.reset();
        while (this.data.plist.hasMoreElements()) {
            curPe = this.data.plist.nextElement();
            if (progressBar.isCanceled()) break;
            progressBar.setNote("[PE: " + curPe + " ] Computing Average.");
            progressBar.setProgress(progressCount);
            this.accTime[progressCount] = u.ampiUsage(curPe, this.data.begintime, this.data.endtime, MainWindow.runObject[this.myRun].getVersion());
            ++progressCount;
        }
        progressBar.close();
    }

    void setAmpiDisplayProfileData() {
        int numPes = this.data.plist.size();
        int numFunc = MainWindow.runObject[this.myRun].getNumFunctionEvents();
        String[] xNames = new String[numFunc - 1];
        boolean pCnt = false;
        float[][] ampiDataSrc = new float[numFunc - 1][];
        String[][] ampiFuncNameMap = new String[numFunc - 1][];
        double avgScale = 1.0 / (double)numPes;
        long totalExecTime = this.data.endtime - this.data.begintime;
        long totalExecTimeAll = totalExecTime * (long)this.data.numPs;
        for (int i = 1; i < numFunc; ++i) {
            ampiDataSrc[i - 1] = new float[1];
            for (int j = 0; j < numPes; ++j) {
                float[] fArray = ampiDataSrc[i - 1];
                fArray[0] = (float)((double)fArray[0] + (double)this.accTime[j][i] * avgScale);
            }
            xNames[i - 1] = MainWindow.runObject[this.myRun].getFunctionName(i);
            ampiFuncNameMap[i - 1] = new String[1];
            ampiFuncNameMap[i - 1][0] = xNames[i - 1];
        }
        int colorNum = numFunc - 1;
        Color[] ampiFuncColors = ColorManager.createColorMap(colorNum);
        int[][] ampiFuncColorMap = new int[colorNum][];
        for (int i = 0; i < colorNum; ++i) {
            ampiFuncColorMap[i] = new int[1];
            ampiFuncColorMap[i][0] = i;
        }
        String[] gTitles = new String[]{"Profile of Usage per Functions in AMPI programs " + this.data.pstring, "(Time " + (float)this.data.begintime / 1000.0f + " ~ " + (float)this.data.endtime / 1000.0f + " ms)"};
        this.ampiDisplayCanvas.setGraphTiltes(gTitles);
        this.ampiDisplayCanvas.setXAxis("", "", xNames);
        this.ampiDisplayCanvas.setYAxis("Usage Percent % (over processor)");
        this.ampiDisplayCanvas.setDisplayDataSource(ampiDataSrc, ampiFuncColorMap, ampiFuncColors, ampiFuncNameMap);
        this.ampiDisplayCanvas.repaint();
    }

    void setDisplayProfileData() {
        this.createDisplayDataSource();
        String[] gTitles = new String[]{"Profile of Usage for Processors " + this.data.pstring, "(Time " + (float)this.data.begintime / 1000.0f + " ~ " + (float)this.data.endtime / 1000.0f + " ms)"};
        this.displayCanvas.setGraphTiltes(gTitles);
        String[] xNames = new String[this.data.plist.size() + 1];
        xNames[0] = "Avg";
        this.data.plist.reset();
        int cnt = 1;
        while (this.data.plist.hasMoreElements()) {
            xNames[cnt++] = "" + this.data.plist.nextElement();
        }
        this.procNames = xNames;
        this.displayCanvas.setXAxis("", "", xNames);
        this.displayCanvas.setYAxis("Usage Percent %");
        this.displayCanvas.setDisplayDataSource(this.dataSource, this.colorMap, this.colors, this.nameMap);
        this.displayCanvas.repaint();
    }

    private void createDisplayDataSource() {
        int i;
        int procCnt;
        this.data.numPs = procCnt = this.data.plist.size();
        int numFunc = MainWindow.runObject[this.myRun].getNumFunctionEvents();
        this.dataSource = new float[procCnt + 1][];
        this.colorMap = new int[procCnt + 1][];
        this.nameMap = new String[procCnt + 1][];
        long totalExecTime = this.data.endtime - this.data.begintime;
        this.avgData = new float[numFunc + 1];
        for (int i2 = 0; i2 < numFunc + 1; ++i2) {
            this.avgData[i2] = 0.0f;
        }
        double avgScale = 1.0 / (double)this.data.plist.size();
        int progressCount = 0;
        int curPe = -1;
        ProgressMonitor progressBar = new ProgressMonitor(this, "Computing Usage Values", "", 0, this.data.numPs);
        progressCount = 0;
        for (int j = 0; j < procCnt; ++j) {
            for (i = 0; i < this.avgData.length; ++i) {
                int n = i;
                this.avgData[n] = this.avgData[n] + (float)((double)this.accTime[j][i] * avgScale);
            }
        }
        if (!this.colorsSet) {
            Color[] funcColors = ColorManager.createColorMap(numFunc);
            this.colors = new Color[numFunc + 1];
            for (i = 1; i < numFunc; ++i) {
                this.colors[i] = funcColors[i];
            }
            this.colors[numFunc] = Color.white;
            this.colorsSet = true;
        }
        this.createSingleProcSource(this.avgData, -1);
        this.dataSource[0] = this.sDataSrc;
        this.colorMap[0] = this.sColorMap;
        this.nameMap[0] = this.sNameMap;
        progressCount = 0;
        this.data.plist.reset();
        while (this.data.plist.hasMoreElements()) {
            curPe = this.data.plist.nextElement();
            if (progressBar.isCanceled()) break;
            progressBar.setNote("[PE: " + curPe + " ] Reading Entry Point Usage.");
            progressBar.setProgress(progressCount);
            this.createSingleProcSource(this.accTime[progressCount], curPe);
            this.dataSource[++progressCount] = this.sDataSrc;
            this.colorMap[progressCount] = this.sColorMap;
            this.nameMap[progressCount] = this.sNameMap;
        }
        progressBar.close();
    }

    public void createSingleProcSource(float[] rawData, int procNum) {
        int numFunc = MainWindow.runObject[this.myRun].getNumFunctionEvents() - 1;
        float[] dSrc = new float[numFunc + 1];
        int[] cMap = new int[numFunc + 1];
        String[] nMap = new String[numFunc + 1];
        this.sDataSrc = dSrc;
        this.sColorMap = cMap;
        this.sNameMap = nMap;
        DecimalFormat format_ = new DecimalFormat();
        format_.setMaximumFractionDigits(5);
        format_.setMinimumFractionDigits(5);
        String[] funcNames = MainWindow.runObject[this.myRun].getFunctionNames();
        for (int funcIdx = 0; funcIdx < numFunc + 1; ++funcIdx) {
            float usage = rawData[funcIdx + 1];
            if (usage <= 0.0f) continue;
            dSrc[funcIdx] = usage;
            cMap[funcIdx] = funcIdx + 1;
            nMap[funcIdx] = funcIdx == numFunc ? "OTHER" : MainWindow.runObject[this.myRun].getFunctionName(funcIdx + 1);
        }
    }

    public void MakePOArray(long bt, long et) {
    }

    public int getHSBValue() {
        return 0;
    }

    public int getVSBValue() {
        return 0;
    }
}

