/*
 * Decompiled with CFR 0.152.
 */
package projections.analysis;

import projections.analysis.AmpiFunctionData;
import projections.analysis.ObjectId;
import projections.misc.LogEntryData;

class LogEntry {
    public int Replay;
    public int TransactionType;
    public int MsgType;
    public int Entry;
    long Time;
    int EventID;
    int Pe;
    int MsgLen;
    ObjectId id;
    long recvTime;
    long sendTime;
    int numPEs;
    int[] destPEs;
    long cpuBegin;
    long cpuEnd;
    int numPapiCounts;
    long[] papiCounts;
    Integer userSupplied;
    int FunctionID;
    AmpiFunctionData ampiData;

    LogEntry() {
    }

    public void setAmpiData(int functionID, int lineNo, String sourceFileName) {
        this.ampiData = new AmpiFunctionData();
        this.ampiData.FunctionID = functionID;
        this.ampiData.LineNo = lineNo;
        this.ampiData.sourceFileName = sourceFileName;
    }

    public static LogEntry adapt(LogEntryData data) {
        int i;
        LogEntry log = new LogEntry();
        log.TransactionType = data.type;
        log.MsgType = data.mtype;
        log.Time = data.time;
        log.Entry = data.entry;
        log.EventID = data.event;
        log.Pe = data.pe;
        log.MsgLen = data.msglen;
        log.sendTime = data.sendTime;
        log.recvTime = data.recvTime;
        log.id = new ObjectId(data.id[0], data.id[1], data.id[2], data.id[3]);
        log.userSupplied = data.userSupplied;
        log.numPEs = data.numPEs;
        if (data.destPEs != null) {
            log.destPEs = new int[data.destPEs.length];
            for (i = 0; i < log.destPEs.length; ++i) {
                log.destPEs[i] = data.destPEs[i];
            }
        }
        log.cpuBegin = data.cpuStartTime;
        log.cpuEnd = data.cpuEndTime;
        log.numPapiCounts = data.numPerfCounts;
        log.papiCounts = new long[log.numPapiCounts];
        for (i = 0; i < log.numPapiCounts; ++i) {
            log.papiCounts[i] = data.perfCounts[i];
        }
        log.FunctionID = data.entry;
        if (data.funcName != null) {
            log.setAmpiData(data.entry, data.lineNo, new String(data.funcName));
        }
        return log;
    }

    public int userSuppliedValue() {
        return this.userSupplied;
    }

    public void setUserSupplied(int userSuppliedValue) {
        this.userSupplied = userSuppliedValue;
    }
}

